/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.io.Flushable;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.logging.console.AnsiContext;
import org.gradle.internal.logging.console.AnsiExecutor;
import org.gradle.internal.logging.console.AnsiFactory;
import org.gradle.internal.logging.console.BuildProgressArea;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.Cursor;
import org.gradle.internal.logging.console.DefaultAnsiExecutor;
import org.gradle.internal.logging.console.DefaultAnsiFactory;
import org.gradle.internal.logging.console.DefaultTextArea;
import org.gradle.internal.logging.console.MultiLineBuildProgressArea;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.console.TextArea;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;

public class AnsiConsole
implements Console {
    private final Action<AnsiContext> redrawAction = new Action<AnsiContext>(){

        public void execute(AnsiContext ansiContext) {
            AnsiConsole.this.buildStatusArea.redraw(ansiContext);
        }
    };
    private final Flushable flushable;
    private final MultiLineBuildProgressArea buildStatusArea = new MultiLineBuildProgressArea();
    private final DefaultTextArea buildOutputArea;
    private final AnsiExecutor ansiExecutor;

    public AnsiConsole(Appendable target, Flushable flushable, ColorMap colorMap, ConsoleMetaData consoleMetaData, boolean forceAnsi) {
        this(target, flushable, colorMap, consoleMetaData, new DefaultAnsiFactory(forceAnsi));
    }

    private AnsiConsole(Appendable target, Flushable flushable, ColorMap colorMap, ConsoleMetaData consoleMetaData, AnsiFactory factory) {
        this.flushable = flushable;
        this.ansiExecutor = new DefaultAnsiExecutor(target, colorMap, factory, consoleMetaData, Cursor.newBottomLeft(), new Listener());
        this.buildOutputArea = new DefaultTextArea(this.ansiExecutor);
    }

    @Override
    public void flush() {
        this.redraw();
        try {
            this.flushable.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void redraw() {
        int numberOfOverlappedRows = this.buildStatusArea.getWritePosition().row - this.buildOutputArea.getWritePosition().row;
        if (this.buildOutputArea.getWritePosition().col > 0) {
            ++numberOfOverlappedRows;
        }
        if (numberOfOverlappedRows > 0) {
            this.buildStatusArea.scrollDownBy(numberOfOverlappedRows);
        }
        this.ansiExecutor.write(this.redrawAction);
    }

    @Override
    public StyledLabel getStatusBar() {
        return this.buildStatusArea.getProgressBar();
    }

    @Override
    public BuildProgressArea getBuildProgressArea() {
        return this.buildStatusArea;
    }

    @Override
    public TextArea getBuildOutputArea() {
        return this.buildOutputArea;
    }

    private class Listener
    implements DefaultAnsiExecutor.NewLineListener {
        private Listener() {
        }

        @Override
        public void beforeNewLineWritten(AnsiContext ansi, Cursor writeCursor) {
            if (AnsiConsole.this.buildStatusArea.isOverlappingWith(writeCursor)) {
                ansi.eraseForward();
            }
            if (writeCursor.row == 0) {
                AnsiConsole.this.buildOutputArea.newLineAdjustment();
                AnsiConsole.this.buildStatusArea.newLineAdjustment();
            }
        }

        @Override
        public void beforeLineWrap(AnsiContext ansi, Cursor writeCursor) {
            if (writeCursor.row == 0) {
                AnsiConsole.this.buildStatusArea.newLineAdjustment();
            }
        }

        @Override
        public void afterLineWrap(AnsiContext ansi, Cursor writeCursor) {
            if (AnsiConsole.this.buildStatusArea.isOverlappingWith(writeCursor)) {
                ansi.eraseForward();
            }
        }
    }
}

