/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.Zip64Mode;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.copy.ZipCompressor;

public class DefaultZipCompressor
implements ZipCompressor {
    private final int entryCompressionMethod;
    private final Zip64Mode zip64Mode;

    public DefaultZipCompressor(boolean allowZip64Mode, int entryCompressionMethod) {
        this.entryCompressionMethod = entryCompressionMethod;
        this.zip64Mode = allowZip64Mode ? Zip64Mode.AsNeeded : Zip64Mode.Never;
    }

    @Override
    public ZipOutputStream createArchiveOutputStream(File destination) throws IOException {
        ZipOutputStream outStream = new ZipOutputStream(destination);
        try {
            outStream.setUseZip64(this.zip64Mode);
            outStream.setMethod(this.entryCompressionMethod);
            return outStream;
        }
        catch (Exception e) {
            IOUtils.closeQuietly((OutputStream)outStream);
            String message = String.format("Unable to create ZIP output stream for file %s.", destination);
            throw new UncheckedIOException(message, (Throwable)e);
        }
    }
}

