/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import java.io.IOException;
import java.io.InputStream;

public class WIBInputStream
extends InputStream {
    private final InputStream in;
    private Integer repeatData = null;
    private int repeatCount = 0;
    private boolean eof = false;

    public WIBInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        while (!this.eof) {
            int n;
            if (this.repeatCount > 0) {
                --this.repeatCount;
                if (this.repeatData == null) {
                    n = this.in.read();
                    if (n < 0) {
                        this.eof = true;
                    }
                    return n;
                }
                return this.repeatData;
            }
            n = this.in.read();
            if (n < 0) {
                this.eof = true;
                return n;
            }
            this.repeatCount = n & 0x1F;
            if ((n & 0x20) != 0) {
                this.repeatCount <<= 5;
            }
            switch (n & 0xC0) {
                case 0: {
                    this.repeatData = 0;
                    break;
                }
                case 64: {
                    this.repeatData = 255;
                    break;
                }
                case 128: {
                    n = this.in.read();
                    if (n < 0) {
                        this.eof = true;
                        return n;
                    }
                    this.repeatData = n;
                    break;
                }
                case 192: {
                    this.repeatData = null;
                }
            }
        }
        return -1;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

