/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListListener;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.unicode.data.NameResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListDataPanel<G extends FontGlyph>
extends JPanel
implements GlyphListListener<G> {
    private static final long serialVersionUID = 1L;
    private static final String T = "    ";
    private final JLabel label = new JLabel(" ");

    public GlyphListDataPanel(GlyphList<G> glyphList) {
        this.label.setFont(this.label.getFont().deriveFont(10.0f));
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Before");
        if (glyphList != null) {
            glyphList.addGlyphListListener(this);
        }
    }

    @Override
    public void selectionChanged(GlyphList<G> glyphList, Font<G> font) {
        List<GlyphLocator<G>> list = glyphList.getSelection();
        if (list.isEmpty()) {
            this.label.setText(" ");
        } else if (list.size() > 1) {
            this.label.setText(list.size() + " glyphs selected");
        } else if (list.get(0).isCodePoint()) {
            int n = list.get(0).getCodePoint();
            String string = Integer.toHexString(n).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            NameResolver nameResolver = NameResolver.instance(n);
            String string2 = nameResolver.getCategory(n);
            String string3 = nameResolver.getName(n);
            this.label.setText("U+" + string + T + "#" + n + T + string2 + T + string3);
        } else if (list.get(0).isGlyphName()) {
            this.label.setText(list.get(0).getGlyphName());
        } else {
            this.label.setText("1 glyph selected");
        }
    }

    @Override
    public void selectionOpened(GlyphList<G> glyphList, Font<G> font) {
    }

    @Override
    public void metricsChanged(GlyphList<G> glyphList, Font<G> font) {
    }

    @Override
    public void glyphsChanged(GlyphList<G> glyphList, Font<G> font) {
    }
}

