/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat12;
import com.kreative.bitsnpicas.truetype.CmapSubtableFormat4;
import com.kreative.bitsnpicas.truetype.CmapSubtableSequentialEntry;
import com.kreative.bitsnpicas.truetype.CmapTable;
import com.kreative.bitsnpicas.truetype.CmapTableEntry;
import com.kreative.bitsnpicas.truetype.EbdtEntry;
import com.kreative.bitsnpicas.truetype.EbdtEntryFormat1;
import com.kreative.bitsnpicas.truetype.EbdtTable;
import com.kreative.bitsnpicas.truetype.EblcBitmapSize;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtable1;
import com.kreative.bitsnpicas.truetype.EblcIndexSubtableHeader;
import com.kreative.bitsnpicas.truetype.EblcTable;
import com.kreative.bitsnpicas.truetype.HeadTable;
import com.kreative.bitsnpicas.truetype.HheaTable;
import com.kreative.bitsnpicas.truetype.HmtxTable;
import com.kreative.bitsnpicas.truetype.HmtxTableEntry;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.NameTable;
import com.kreative.bitsnpicas.truetype.NameTableEntry;
import com.kreative.bitsnpicas.truetype.Os2Table;
import com.kreative.bitsnpicas.truetype.PostTable;
import com.kreative.bitsnpicas.truetype.PostTableEntry;
import com.kreative.bitsnpicas.truetype.SbitLineMetrics;
import com.kreative.bitsnpicas.truetype.SbitSmallGlyphMetrics;
import com.kreative.bitsnpicas.truetype.SbitTableType;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTBBitmapFontExporter
implements BitmapFontExporter {
    private boolean extendWinMetrics;

    public OTBBitmapFontExporter() {
        this.extendWinMetrics = false;
    }

    public OTBBitmapFontExporter(boolean bl) {
        this.extendWinMetrics = bl;
    }

    @Override
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        return OTBBitmapFontExporter.createTrueTypeTables(bitmapFont, 100, 100, this.extendWinMetrics).compile();
    }

    @Override
    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(OTBBitmapFontExporter.createTrueTypeTables(bitmapFont, 100, 100, this.extendWinMetrics).compile());
        fileOutputStream.close();
    }

    @Override
    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        outputStream.write(OTBBitmapFontExporter.createTrueTypeTables(bitmapFont, 100, 100, this.extendWinMetrics).compile());
    }

    private static final TrueTypeFile createTrueTypeTables(BitmapFont bitmapFont, int n, int n2, boolean bl) throws IOException {
        ThingsToKeepTrackOf thingsToKeepTrackOf = new ThingsToKeepTrackOf();
        bitmapFont.autoFillNames();
        ArrayList<EbdtEntry> arrayList = new ArrayList<EbdtEntry>();
        HmtxTable hmtxTable = new HmtxTable();
        PostTable postTable = new PostTable();
        if (bitmapFont.isItalicStyle()) {
            postTable.italicAngle = -1740967;
        }
        postTable.underlinePosition = -n2;
        postTable.underlineThickness = n2;
        OTBBitmapFontExporter.makeCharacterGlyph(bitmapFont, (BitmapFontGlyph)bitmapFont.getNamedGlyph(".notdef"), ".notdef", thingsToKeepTrackOf, n, n2, arrayList, hmtxTable, postTable);
        OTBBitmapFontExporter.makeCharacterGlyph(bitmapFont, (BitmapFontGlyph)bitmapFont.getCharacter(0), 0, thingsToKeepTrackOf, n, n2, arrayList, hmtxTable, postTable);
        OTBBitmapFontExporter.makeCharacterGlyph(bitmapFont, (BitmapFontGlyph)bitmapFont.getCharacter(13), 13, thingsToKeepTrackOf, n, n2, arrayList, hmtxTable, postTable);
        OTBBitmapFontExporter.makeCharacterGlyph(bitmapFont, (BitmapFontGlyph)bitmapFont.getCharacter(32), 32, thingsToKeepTrackOf, n, n2, arrayList, hmtxTable, postTable);
        for (Map.Entry entry2 : bitmapFont.characters(false).entrySet()) {
            int n3 = entry2.getKey();
            if (n3 == 0 || n3 == 13 || n3 == 32) continue;
            OTBBitmapFontExporter.makeCharacterGlyph(bitmapFont, (BitmapFontGlyph)entry2.getValue(), entry2.getKey(), thingsToKeepTrackOf, n, n2, arrayList, hmtxTable, postTable);
        }
        for (Map.Entry entry : bitmapFont.namedGlyphs(false).entrySet()) {
            if (((String)entry.getKey()).toString().equals(".notdef")) continue;
            OTBBitmapFontExporter.makeCharacterGlyph(bitmapFont, (BitmapFontGlyph)entry.getValue(), entry.getKey(), thingsToKeepTrackOf, n, n2, arrayList, hmtxTable, postTable);
        }
        EbdtTable ebdtTable = new EbdtTable(SbitTableType.OPENTYPE);
        EblcIndexSubtable1 eblcIndexSubtable1 = new EblcIndexSubtable1();
        eblcIndexSubtable1.header = new EblcIndexSubtableHeader();
        eblcIndexSubtable1.header.firstGlyphIndex = 0;
        eblcIndexSubtable1.header.lastGlyphIndex = thingsToKeepTrackOf.numGlyphs - 1;
        eblcIndexSubtable1.header.indexFormat = 1;
        eblcIndexSubtable1.header.imageFormat = 1;
        for (EbdtEntry ebdtEntry : arrayList) {
            int n4 = ebdtTable.getNextKey();
            ebdtTable.put(n4, ebdtEntry);
            eblcIndexSubtable1.add(n4);
        }
        eblcIndexSubtable1.add(ebdtTable.getNextKey());
        EblcBitmapSize eblcBitmapSize = OTBBitmapFontExporter.createBitmapSize(bitmapFont, thingsToKeepTrackOf, n);
        eblcBitmapSize.startGlyphIndex = 0;
        eblcBitmapSize.endGlyphIndex = thingsToKeepTrackOf.numGlyphs - 1;
        eblcBitmapSize.add(eblcIndexSubtable1);
        EblcTable eblcTable = new EblcTable(SbitTableType.OPENTYPE);
        eblcTable.add(eblcBitmapSize);
        TrueTypeFile trueTypeFile = new TrueTypeFile();
        trueTypeFile.add(OTBBitmapFontExporter.makeHeadTable(bitmapFont, thingsToKeepTrackOf, n2));
        trueTypeFile.add(OTBBitmapFontExporter.makeHheaTable(bitmapFont, thingsToKeepTrackOf, n2));
        trueTypeFile.add(OTBBitmapFontExporter.makeMaxpTable(thingsToKeepTrackOf));
        trueTypeFile.add(OTBBitmapFontExporter.makeOs2Table(bitmapFont, thingsToKeepTrackOf, n, n2, bl));
        trueTypeFile.add(hmtxTable);
        trueTypeFile.add(OTBBitmapFontExporter.makeCmapTable(bitmapFont, thingsToKeepTrackOf));
        trueTypeFile.add(eblcTable);
        trueTypeFile.add(ebdtTable);
        trueTypeFile.add(OTBBitmapFontExporter.makeNameTable(bitmapFont));
        trueTypeFile.add(postTable);
        return trueTypeFile;
    }

    private static final void makeCharacterGlyph(BitmapFont bitmapFont, BitmapFontGlyph bitmapFontGlyph, Object object, ThingsToKeepTrackOf thingsToKeepTrackOf, int n, int n2, List<EbdtEntry> list, HmtxTable hmtxTable, PostTable postTable) {
        if (object instanceof Integer) {
            thingsToKeepTrackOf.charToGlyfMap.put((Integer)object, thingsToKeepTrackOf.numGlyphs);
        }
        if (bitmapFontGlyph == null) {
            EbdtEntryFormat1 ebdtEntryFormat1 = new EbdtEntryFormat1();
            ebdtEntryFormat1.smallMetrics = new SbitSmallGlyphMetrics();
            ebdtEntryFormat1.imageData = new byte[0];
            list.add(ebdtEntryFormat1);
            hmtxTable.add(new HmtxTableEntry());
        } else {
            Rectangle rectangle = new Rectangle(bitmapFontGlyph.getGlyphOffset() * n, bitmapFontGlyph.getGlyphAscent() * n2, bitmapFontGlyph.getGlyphWidth() * n, bitmapFontGlyph.getGlyphHeight() * n2);
            int n3 = bitmapFontGlyph.getCharacterWidth() * n;
            if (!thingsToKeepTrackOf.maxBoundingBox) {
                thingsToKeepTrackOf.maxBoundingBox = true;
                thingsToKeepTrackOf.bbx1 = rectangle.x;
                thingsToKeepTrackOf.bby1 = rectangle.y;
                thingsToKeepTrackOf.bbx2 = rectangle.x + rectangle.width;
                thingsToKeepTrackOf.bby2 = rectangle.y + rectangle.height;
                thingsToKeepTrackOf.minLSB = rectangle.x;
                thingsToKeepTrackOf.minRSB = n3 - rectangle.x - rectangle.width;
                thingsToKeepTrackOf.maxAdvance = n3;
                thingsToKeepTrackOf.maxExtent = rectangle.x + rectangle.width;
            } else {
                if (rectangle.x < thingsToKeepTrackOf.bbx1) {
                    thingsToKeepTrackOf.bbx1 = rectangle.x;
                }
                if (rectangle.y < thingsToKeepTrackOf.bby1) {
                    thingsToKeepTrackOf.bby1 = rectangle.y;
                }
                if (rectangle.x + rectangle.width > thingsToKeepTrackOf.bbx2) {
                    thingsToKeepTrackOf.bbx2 = rectangle.x + rectangle.width;
                }
                if (rectangle.y + rectangle.height > thingsToKeepTrackOf.bby2) {
                    thingsToKeepTrackOf.bby2 = rectangle.y + rectangle.height;
                }
                if (rectangle.x < thingsToKeepTrackOf.minLSB) {
                    thingsToKeepTrackOf.minLSB = rectangle.x;
                }
                if (n3 - rectangle.x - rectangle.width < thingsToKeepTrackOf.minRSB) {
                    thingsToKeepTrackOf.minRSB = n3 - rectangle.x - rectangle.width;
                }
                if (n3 > thingsToKeepTrackOf.maxAdvance) {
                    thingsToKeepTrackOf.maxAdvance = n3;
                }
                if (rectangle.x + rectangle.width > thingsToKeepTrackOf.maxExtent) {
                    thingsToKeepTrackOf.maxExtent = rectangle.x + rectangle.width;
                }
            }
            if (n3 > 0) {
                ThingsToKeepTrackOf thingsToKeepTrackOf2 = thingsToKeepTrackOf;
                thingsToKeepTrackOf2.averageWidth = thingsToKeepTrackOf2.averageWidth + n3;
                thingsToKeepTrackOf.numAverages++;
            }
            if (object instanceof Integer && (Integer)object == 120) {
                thingsToKeepTrackOf.xHeight = rectangle.y + rectangle.height;
            }
            if (object instanceof Integer && (Integer)object == 72) {
                thingsToKeepTrackOf.HHeight = rectangle.y + rectangle.height;
            }
            if (object instanceof Integer && (Integer)object >= 65536) {
                thingsToKeepTrackOf.highUnicode = true;
            }
            list.add(OTBBitmapFontExporter.createEbdtEntry(bitmapFontGlyph));
            hmtxTable.add(new HmtxTableEntry(n3, rectangle.x));
        }
        if (object instanceof Integer) {
            postTable.add(PostTableEntry.forCharacter((Integer)object));
        }
        if (object instanceof String) {
            postTable.add(PostTableEntry.forCharacterName(object.toString()));
        }
        thingsToKeepTrackOf.numGlyphs++;
    }

    private static final EblcBitmapSize createBitmapSize(BitmapFont bitmapFont, ThingsToKeepTrackOf thingsToKeepTrackOf, int n) {
        EblcBitmapSize eblcBitmapSize = new EblcBitmapSize();
        eblcBitmapSize.hori = new SbitLineMetrics();
        eblcBitmapSize.vert = new SbitLineMetrics();
        eblcBitmapSize.hori.ascender = eblcBitmapSize.vert.ascender = bitmapFont.getLineAscent();
        eblcBitmapSize.hori.descender = eblcBitmapSize.vert.descender = -bitmapFont.getLineDescent();
        eblcBitmapSize.hori.widthMax = eblcBitmapSize.vert.widthMax = thingsToKeepTrackOf.maxAdvance / n;
        eblcBitmapSize.ppemX = eblcBitmapSize.ppemY = bitmapFont.getEmAscent() + bitmapFont.getEmDescent();
        eblcBitmapSize.bitDepth = 8;
        eblcBitmapSize.flags = 1;
        return eblcBitmapSize;
    }

    private static final EbdtEntry createEbdtEntry(BitmapFontGlyph bitmapFontGlyph) {
        int n = bitmapFontGlyph.getGlyphWidth();
        int n2 = bitmapFontGlyph.getGlyphHeight();
        byte[] byArray = new byte[n * n2];
        byte[][] byArray2 = bitmapFontGlyph.getGlyph();
        int n3 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            byte[] byArray3 = byArray2[i];
            int n4 = n3;
            for (int j = 0; j < byArray3.length; ++j) {
                byArray[n4] = byArray3[j];
                ++n4;
            }
            n3 += n;
        }
        EbdtEntryFormat1 ebdtEntryFormat1 = new EbdtEntryFormat1();
        ebdtEntryFormat1.smallMetrics = new SbitSmallGlyphMetrics();
        ebdtEntryFormat1.smallMetrics.height = n2;
        ebdtEntryFormat1.smallMetrics.width = n;
        ebdtEntryFormat1.smallMetrics.bearingX = bitmapFontGlyph.getGlyphOffset();
        ebdtEntryFormat1.smallMetrics.bearingY = bitmapFontGlyph.getGlyphAscent();
        ebdtEntryFormat1.smallMetrics.advance = bitmapFontGlyph.getCharacterWidth();
        ebdtEntryFormat1.imageData = byArray;
        return ebdtEntryFormat1;
    }

    private static final CmapTable makeCmapTable(BitmapFont bitmapFont, ThingsToKeepTrackOf thingsToKeepTrackOf) {
        Set<Integer> set = bitmapFont.characters(false).keySet();
        CmapSubtableFormat4 cmapSubtableFormat4 = new CmapSubtableFormat4();
        CmapSubtableFormat12 cmapSubtableFormat12 = new CmapSubtableFormat12();
        CmapSubtableSequentialEntry cmapSubtableSequentialEntry = null;
        int n = 0;
        Object object = set.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            int n3 = (Integer)thingsToKeepTrackOf.charToGlyfMap.get(n2);
            if (cmapSubtableSequentialEntry == null) {
                cmapSubtableSequentialEntry = new CmapSubtableSequentialEntry();
                cmapSubtableSequentialEntry.startCharCode = n2;
                cmapSubtableSequentialEntry.endCharCode = n2;
                cmapSubtableSequentialEntry.glyphIndex = n3;
                n = n3;
                continue;
            }
            if (n2 == cmapSubtableSequentialEntry.endCharCode + 1 && n3 == n + 1) {
                cmapSubtableSequentialEntry.endCharCode = n2;
                n = n3;
                continue;
            }
            if (cmapSubtableSequentialEntry.startCharCode < 65536) {
                cmapSubtableFormat4.add(cmapSubtableSequentialEntry);
            }
            cmapSubtableFormat12.add(cmapSubtableSequentialEntry);
            cmapSubtableSequentialEntry = new CmapSubtableSequentialEntry();
            cmapSubtableSequentialEntry.startCharCode = n2;
            cmapSubtableSequentialEntry.endCharCode = n2;
            cmapSubtableSequentialEntry.glyphIndex = n3;
            n = n3;
        }
        if (cmapSubtableSequentialEntry != null) {
            if (cmapSubtableSequentialEntry.startCharCode < 65536) {
                cmapSubtableFormat4.add(cmapSubtableSequentialEntry);
            }
            cmapSubtableFormat12.add(cmapSubtableSequentialEntry);
        }
        cmapSubtableSequentialEntry = new CmapSubtableSequentialEntry();
        cmapSubtableSequentialEntry.startCharCode = 65535;
        cmapSubtableSequentialEntry.endCharCode = 65535;
        cmapSubtableSequentialEntry.glyphIndex = 0;
        cmapSubtableFormat4.add(cmapSubtableSequentialEntry);
        object = new CmapTable();
        ((CmapTable)object).subtables.add(cmapSubtableFormat4);
        if (thingsToKeepTrackOf.highUnicode) {
            ((CmapTable)object).subtables.add(cmapSubtableFormat12);
        }
        ((CmapTable)object).entries.add(CmapTableEntry.forUnicode(thingsToKeepTrackOf.highUnicode ? cmapSubtableFormat12 : cmapSubtableFormat4));
        ((CmapTable)object).entries.add(CmapTableEntry.forWindowsUnicode16(cmapSubtableFormat4));
        if (thingsToKeepTrackOf.highUnicode) {
            ((CmapTable)object).entries.add(CmapTableEntry.forWindowsUnicode32(cmapSubtableFormat12));
        }
        return object;
    }

    private static final HeadTable makeHeadTable(BitmapFont bitmapFont, ThingsToKeepTrackOf thingsToKeepTrackOf, int n) {
        double d;
        Object object;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        try {
            object = bitmapFont.getName(5);
            d = object == null ? 1.0 : (((String)object).startsWith("Version ") ? Double.parseDouble(((String)object).substring(8)) : Double.parseDouble((String)object));
        }
        catch (NumberFormatException numberFormatException) {
            d = 1.0;
        }
        object = new HeadTable();
        ((HeadTable)object).setFontRevisionDouble(d);
        ((HeadTable)object).flags = 3;
        ((HeadTable)object).unitsPerEm = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n;
        ((HeadTable)object).setDateCreatedCalendar(gregorianCalendar);
        ((HeadTable)object).setDateModifiedCalendar(gregorianCalendar);
        ((HeadTable)object).xMin = thingsToKeepTrackOf.bbx1;
        ((HeadTable)object).yMin = thingsToKeepTrackOf.bby1;
        ((HeadTable)object).xMax = thingsToKeepTrackOf.bbx2;
        ((HeadTable)object).yMax = thingsToKeepTrackOf.bby2;
        ((HeadTable)object).macStyle = bitmapFont.getMacStyle();
        ((HeadTable)object).lowestRecPPEM = bitmapFont.getEmAscent() + bitmapFont.getEmDescent();
        ((HeadTable)object).fontDirectionHint = 0;
        ((HeadTable)object).indexToLocFormat = 1;
        return object;
    }

    private static final HheaTable makeHheaTable(BitmapFont bitmapFont, ThingsToKeepTrackOf thingsToKeepTrackOf, int n) {
        HheaTable hheaTable = new HheaTable();
        hheaTable.ascent = bitmapFont.getLineAscent() * n;
        hheaTable.descent = -bitmapFont.getLineDescent() * n;
        hheaTable.lineGap = bitmapFont.getLineGap() * n;
        hheaTable.advanceWidthMax = thingsToKeepTrackOf.maxAdvance;
        hheaTable.minLeftSideBearing = thingsToKeepTrackOf.minLSB;
        hheaTable.minRightSideBearing = thingsToKeepTrackOf.minRSB;
        hheaTable.xMaxExtent = thingsToKeepTrackOf.maxExtent;
        if (bitmapFont.isItalicStyle()) {
            hheaTable.caretSlopeRise = 2;
            hheaTable.caretSlopeRun = 1;
        }
        hheaTable.numLongHorMetrics = thingsToKeepTrackOf.numGlyphs;
        return hheaTable;
    }

    private static final MaxpTable makeMaxpTable(ThingsToKeepTrackOf thingsToKeepTrackOf) {
        MaxpTable maxpTable = new MaxpTable();
        maxpTable.numGlyphs = thingsToKeepTrackOf.numGlyphs;
        return maxpTable;
    }

    private static final Os2Table makeOs2Table(BitmapFont bitmapFont, ThingsToKeepTrackOf thingsToKeepTrackOf, int n, int n2, boolean bl) {
        Set<Integer> set = bitmapFont.characters(false).keySet();
        Os2Table os2Table = new Os2Table();
        if (thingsToKeepTrackOf.numAverages > 0) {
            os2Table.averageCharWidth = thingsToKeepTrackOf.averageWidth / thingsToKeepTrackOf.numAverages;
        }
        int n3 = os2Table.weightClass = bitmapFont.isBoldStyle() ? 700 : 500;
        os2Table.widthClass = bitmapFont.isCondensedStyle() ? 3 : (bitmapFont.isExtendedStyle() ? 7 : 5);
        os2Table.subscriptXSize = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n;
        os2Table.subscriptYSize = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n2;
        os2Table.subscriptXOffset = 0;
        os2Table.subscriptYOffset = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n2 / 2;
        os2Table.superscriptXSize = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n;
        os2Table.superscriptYSize = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n2;
        os2Table.superscriptXOffset = 0;
        os2Table.superscriptYOffset = (bitmapFont.getEmAscent() + bitmapFont.getEmDescent()) * n2 / 2;
        os2Table.strikeoutWidth = n2;
        os2Table.strikeoutPosition = bitmapFont.getEmAscent() * n2 / 2;
        os2Table.panoseFamilyType = 2;
        if (bitmapFont.isMonospaced()) {
            os2Table.panoseProportion = 9;
        }
        os2Table.setUnicodeRanges(set);
        os2Table.setVendorIDString("KBnP");
        os2Table.fsSelection = bitmapFont.getFsSelection() | 0x80;
        os2Table.setCharIndices(set);
        os2Table.typoAscent = bitmapFont.getLineAscent() * n2;
        os2Table.typoDescent = -bitmapFont.getLineDescent() * n2;
        os2Table.typoLineGap = bitmapFont.getLineGap() * n2;
        os2Table.winAscent = bitmapFont.getLineAscent() * n2;
        os2Table.winDescent = bitmapFont.getLineDescent() * n2;
        if (bl) {
            os2Table.winAscent = Math.max(thingsToKeepTrackOf.bby2, os2Table.winAscent);
            os2Table.winDescent = Math.max(-thingsToKeepTrackOf.bby1, os2Table.winDescent);
        }
        os2Table.setCodePages(set);
        os2Table.xHeight = thingsToKeepTrackOf.xHeight;
        os2Table.capHeight = thingsToKeepTrackOf.HHeight;
        return os2Table;
    }

    private static final NameTable makeNameTable(BitmapFont bitmapFont) {
        NameTable nameTable = new NameTable();
        for (Map.Entry<Integer, String> entry : bitmapFont.names(false).entrySet()) {
            nameTable.add(NameTableEntry.forUnicode(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Integer, String> entry : bitmapFont.names(false).entrySet()) {
            nameTable.add(NameTableEntry.forMacintosh(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Integer, String> entry : bitmapFont.names(false).entrySet()) {
            nameTable.add(NameTableEntry.forWindows(entry.getKey(), entry.getValue()));
        }
        return nameTable;
    }

    private static final class ThingsToKeepTrackOf {
        private int numGlyphs = 0;
        private boolean maxBoundingBox = false;
        private int bbx1 = 0;
        private int bby1 = 0;
        private int bbx2 = 0;
        private int bby2 = 0;
        private int minLSB = 0;
        private int minRSB = 0;
        private int maxAdvance = 0;
        private int maxExtent = 0;
        private int averageWidth = 0;
        private int numAverages = 0;
        private int xHeight = 0;
        private int HHeight = 0;
        private boolean highUnicode = false;
        private Map<Integer, Integer> charToGlyfMap = new HashMap<Integer, Integer>();

        private ThingsToKeepTrackOf() {
        }
    }
}

