/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.CBMConstants;
import com.kreative.bitsnpicas.geos.GEOSIcons;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class GEOSInfoBlock
implements CBMConstants {
    public static final int ICON_WIDTH = 3;
    public static final int ICON_HEIGHT = 21;
    public static final int ICON_FLAGS = 191;
    public int iconWidth;
    public int iconHeight;
    public int iconFlags;
    public byte[] iconBitmap;
    public int cbmFileType;
    public int geosFileType;
    public int fileStructure;
    public int loadAddress;
    public int endAddress;
    public int startAddress;
    public byte[] classText;
    public byte[] author;
    public byte[] creator;
    public byte[] appData;
    public byte[] description;

    public GEOSInfoBlock() {
        this.clear();
    }

    public void clear() {
        this.iconWidth = 3;
        this.iconHeight = 21;
        this.iconFlags = 191;
        this.iconBitmap = new byte[63];
        this.cbmFileType = 128;
        this.geosFileType = 0;
        this.fileStructure = 0;
        this.loadAddress = 0;
        this.endAddress = 65535;
        this.startAddress = 0;
        this.classText = new byte[20];
        this.author = new byte[20];
        this.creator = new byte[20];
        this.appData = new byte[23];
        this.description = new byte[96];
    }

    public String getIconString() {
        return GEOSIcons.toString(this.iconBitmap);
    }

    public byte[][] getIconGlyph() {
        return GEOSIcons.toGlyph(this.iconBitmap);
    }

    public int[] getIconRGB() {
        return GEOSIcons.toRGB(this.iconBitmap);
    }

    public BufferedImage getIconImage() {
        return GEOSIcons.toImage(this.iconBitmap);
    }

    public void setIconGlyph(byte[][] byArray) {
        this.iconBitmap = GEOSIcons.fromGlyph(byArray);
    }

    public void setIconRGB(int[] nArray) {
        this.iconBitmap = GEOSIcons.fromRGB(nArray);
    }

    public void setIconImage(BufferedImage bufferedImage, int n, int n2) {
        this.iconBitmap = GEOSIcons.fromImage(bufferedImage, n, n2);
    }

    public boolean hasAuthorString() {
        switch (this.geosFileType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean hasCreatorString() {
        return this.geosFileType == 7;
    }

    public String getClassTextString() {
        return GEOSInfoBlock.toString(this.classText);
    }

    public String getAuthorString() {
        return GEOSInfoBlock.toString(this.author);
    }

    public String getCreatorString() {
        return GEOSInfoBlock.toString(this.creator);
    }

    public String getDescriptionString() {
        return GEOSInfoBlock.toString(this.description);
    }

    public void setClassTextString(String string) {
        this.classText = GEOSInfoBlock.toByteArray(string);
    }

    public void setAuthorString(String string) {
        this.author = GEOSInfoBlock.toByteArray(string);
    }

    public void setCreatorString(String string) {
        this.creator = GEOSInfoBlock.toByteArray(string);
    }

    public void setDescriptionString(String string) {
        this.description = GEOSInfoBlock.toByteArray(string);
    }

    public byte getByte(int n) {
        switch (n &= 0xFF) {
            case 2: {
                return (byte)this.iconWidth;
            }
            case 3: {
                return (byte)this.iconHeight;
            }
            case 4: {
                return (byte)this.iconFlags;
            }
            case 68: {
                return (byte)this.cbmFileType;
            }
            case 69: {
                return (byte)this.geosFileType;
            }
            case 70: {
                return (byte)this.fileStructure;
            }
            case 71: {
                return (byte)this.loadAddress;
            }
            case 72: {
                return (byte)(this.loadAddress >> 8);
            }
            case 73: {
                return (byte)this.endAddress;
            }
            case 74: {
                return (byte)(this.endAddress >> 8);
            }
            case 75: {
                return (byte)this.startAddress;
            }
            case 76: {
                return (byte)(this.startAddress >> 8);
            }
        }
        if (n >= 5 && n <= 67) {
            return this.iconBitmap[n - 5];
        }
        if (n >= 77 && n <= 96) {
            return this.classText[n - 77];
        }
        if (n >= 97 && n <= 116) {
            return this.author[n - 97];
        }
        if (n >= 117 && n <= 136) {
            return this.creator[n - 117];
        }
        if (n >= 137 && n <= 159) {
            return this.appData[n - 137];
        }
        if (n >= 160 && n <= 255) {
            return this.description[n - 160];
        }
        return 0;
    }

    public void setByte(int n, byte by) {
        switch (n &= 0xFF) {
            case 2: {
                this.iconWidth = by & 0xFF;
                break;
            }
            case 3: {
                this.iconHeight = by & 0xFF;
                break;
            }
            case 4: {
                this.iconFlags = by & 0xFF;
                break;
            }
            case 68: {
                this.cbmFileType = by & 0xFF;
                break;
            }
            case 69: {
                this.geosFileType = by & 0xFF;
                break;
            }
            case 70: {
                this.fileStructure = by & 0xFF;
                break;
            }
            case 71: {
                this.loadAddress = this.loadAddress & 0xFF00 | by & 0xFF;
                break;
            }
            case 72: {
                this.loadAddress = this.loadAddress & 0xFF | (by & 0xFF) << 8;
                break;
            }
            case 73: {
                this.endAddress = this.endAddress & 0xFF00 | by & 0xFF;
                break;
            }
            case 74: {
                this.endAddress = this.endAddress & 0xFF | (by & 0xFF) << 8;
                break;
            }
            case 75: {
                this.startAddress = this.startAddress & 0xFF00 | by & 0xFF;
                break;
            }
            case 76: {
                this.startAddress = this.startAddress & 0xFF | (by & 0xFF) << 8;
                break;
            }
            default: {
                if (n >= 5 && n <= 67) {
                    this.iconBitmap[n - 5] = by;
                }
                if (n >= 77 && n <= 96) {
                    this.classText[n - 77] = by;
                }
                if (n >= 97 && n <= 116) {
                    this.author[n - 97] = by;
                }
                if (n >= 117 && n <= 136) {
                    this.creator[n - 117] = by;
                }
                if (n >= 137 && n <= 159) {
                    this.appData[n - 137] = by;
                }
                if (n < 160 || n > 255) break;
                this.description[n - 160] = by;
            }
        }
    }

    public void read(DataInput dataInput) throws IOException {
        this.iconWidth = dataInput.readUnsignedByte();
        this.iconHeight = dataInput.readUnsignedByte();
        this.iconFlags = dataInput.readUnsignedByte();
        this.iconBitmap = new byte[63];
        dataInput.readFully(this.iconBitmap);
        this.cbmFileType = dataInput.readUnsignedByte();
        this.geosFileType = dataInput.readUnsignedByte();
        this.fileStructure = dataInput.readUnsignedByte();
        this.loadAddress = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        this.endAddress = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        this.startAddress = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        this.classText = new byte[20];
        dataInput.readFully(this.classText);
        this.author = new byte[20];
        dataInput.readFully(this.author);
        this.creator = new byte[20];
        dataInput.readFully(this.creator);
        this.appData = new byte[23];
        dataInput.readFully(this.appData);
        this.description = new byte[96];
        dataInput.readFully(this.description);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.iconWidth);
        dataOutput.writeByte(this.iconHeight);
        dataOutput.writeByte(this.iconFlags);
        GEOSInfoBlock.write(dataOutput, this.iconBitmap, 63);
        dataOutput.writeByte(this.cbmFileType);
        dataOutput.writeByte(this.geosFileType);
        dataOutput.writeByte(this.fileStructure);
        dataOutput.writeShort(Short.reverseBytes((short)this.loadAddress));
        dataOutput.writeShort(Short.reverseBytes((short)this.endAddress));
        dataOutput.writeShort(Short.reverseBytes((short)this.startAddress));
        GEOSInfoBlock.write(dataOutput, this.classText, 20);
        GEOSInfoBlock.write(dataOutput, this.author, 20);
        GEOSInfoBlock.write(dataOutput, this.creator, 20);
        GEOSInfoBlock.write(dataOutput, this.appData, 23);
        GEOSInfoBlock.write(dataOutput, this.description, 96);
    }

    private static String toString(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        try {
            return new String(byArray, 0, n, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static byte[] toByteArray(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static void write(DataOutput dataOutput, byte[] byArray, int n) throws IOException {
        int n2;
        for (n2 = 0; n2 < byArray.length && n2 < n; ++n2) {
            dataOutput.writeByte(byArray[n2]);
        }
        for (n2 = byArray.length; n2 < n; ++n2) {
            dataOutput.writeByte(0);
        }
    }
}

