/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos.mover;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.geos.GEOSFontFile;
import com.kreative.bitsnpicas.geos.GEOSFontPointSize;
import com.kreative.bitsnpicas.geos.mover.GEOSFontPointSizeSelection;
import com.kreative.bitsnpicas.geos.mover.GEOSFontPointSizeTableModel;
import com.kreative.bitsnpicas.importer.GEOSBitmapFontImporter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEOSFontPointSizeTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public GEOSFontPointSizeTable(GEOSFontPointSizeTableModel gEOSFontPointSizeTableModel) {
        super(gEOSFontPointSizeTableModel);
        this.setColumnWidth(0, 40);
        this.setColumnWidth(1, 100);
        this.setColumnWidth(2, 100);
        this.setDefaultEditor(Integer.class, new MyCellEditor());
        this.setDefaultRenderer(Integer.class, new MyCellRenderer());
        this.setDefaultRenderer(String.class, new MyCellRenderer());
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setRowHeight(26);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    GEOSFontPointSizeTable.this.doOpen();
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        inputMap.put(KeyStroke.getKeyStroke(88, n), "Cut");
        inputMap.put(KeyStroke.getKeyStroke(67, n), "Copy");
        inputMap.put(KeyStroke.getKeyStroke(86, n), "Paste");
        inputMap.put(KeyStroke.getKeyStroke(127, n), "Clear");
        inputMap.put(KeyStroke.getKeyStroke(8, n), "Clear");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("Cut", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSFontPointSizeTable.this.doCut();
            }
        });
        actionMap.put("Copy", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSFontPointSizeTable.this.doCopy();
            }
        });
        actionMap.put("Paste", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSFontPointSizeTable.this.doPaste();
            }
        });
        actionMap.put("Clear", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GEOSFontPointSizeTable.this.doClear();
            }
        });
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 1, new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                if (dragGestureEvent.getDragOrigin().x < 40) {
                    List<GEOSFontPointSize> list = GEOSFontPointSizeTable.this.getSelectedPointSizeObjects();
                    if (list.isEmpty()) {
                        return;
                    }
                    dragGestureEvent.startDrag(null, new GEOSFontPointSizeSelection(list));
                }
            }
        });
    }

    public void createDropTarget(JComponent jComponent) {
        new DropTarget(jComponent, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    DataFlavor dataFlavor = GEOSFontPointSizeSelection.geosFontPointSizeFlavor;
                    if (transferable.isDataFlavorSupported(dataFlavor)) {
                        List list = (List)transferable.getTransferData(dataFlavor);
                        if (list != null && !list.isEmpty()) {
                            GEOSFontPointSizeTableModel gEOSFontPointSizeTableModel = GEOSFontPointSizeTable.this.getPointSizeModel();
                            GEOSFontFile gEOSFontFile = gEOSFontPointSizeTableModel.getFontFile();
                            for (Object e : list) {
                                GEOSFontPointSize gEOSFontPointSize = (GEOSFontPointSize)e;
                                gEOSFontFile.setFontPointSize(gEOSFontPointSize.pointSize, gEOSFontPointSize);
                            }
                            gEOSFontPointSizeTableModel.refresh();
                            dropTargetDropEvent.dropComplete(true);
                        } else {
                            dropTargetDropEvent.dropComplete(false);
                        }
                    } else {
                        dropTargetDropEvent.dropComplete(false);
                    }
                }
                catch (Exception exception) {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
        });
    }

    public GEOSFontPointSizeTableModel getPointSizeModel() {
        return (GEOSFontPointSizeTableModel)this.getModel();
    }

    public List<Integer> getSelectedPointSizes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        GEOSFontPointSizeTableModel gEOSFontPointSizeTableModel = this.getPointSizeModel();
        for (int n : this.getSelectedRows()) {
            arrayList.add(gEOSFontPointSizeTableModel.getPointSize(n));
        }
        return arrayList;
    }

    public List<GEOSFontPointSize> getSelectedPointSizeObjects() {
        ArrayList<GEOSFontPointSize> arrayList = new ArrayList<GEOSFontPointSize>();
        GEOSFontFile gEOSFontFile = this.getPointSizeModel().getFontFile();
        for (int n : this.getSelectedPointSizes()) {
            arrayList.add(gEOSFontFile.getFontPointSize(n));
        }
        return arrayList;
    }

    public void doOpen() {
        GEOSBitmapFontImporter gEOSBitmapFontImporter = new GEOSBitmapFontImporter();
        GEOSFontFile gEOSFontFile = this.getPointSizeModel().getFontFile();
        for (int n : this.getSelectedPointSizes()) {
            BitmapFont bitmapFont = gEOSBitmapFontImporter.importFont(gEOSFontFile, n);
            Main.openFont(null, null, bitmapFont);
        }
    }

    public void doCut() {
        this.doCopy();
        this.doClear();
    }

    public void doCopy() {
        List<GEOSFontPointSize> list = this.getSelectedPointSizeObjects();
        if (list.isEmpty()) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new GEOSFontPointSizeSelection(list), new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
    }

    public void doPaste() {
        DataFlavor dataFlavor;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(dataFlavor = GEOSFontPointSizeSelection.geosFontPointSizeFlavor)) {
            try {
                List list = (List)clipboard.getData(dataFlavor);
                if (list == null || list.isEmpty()) {
                    return;
                }
                GEOSFontPointSizeTableModel gEOSFontPointSizeTableModel = this.getPointSizeModel();
                GEOSFontFile gEOSFontFile = gEOSFontPointSizeTableModel.getFontFile();
                for (Object e : list) {
                    GEOSFontPointSize gEOSFontPointSize = (GEOSFontPointSize)e;
                    gEOSFontFile.setFontPointSize(gEOSFontPointSize.pointSize, gEOSFontPointSize);
                }
                gEOSFontPointSizeTableModel.refresh();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void doClear() {
        GEOSFontPointSizeTableModel gEOSFontPointSizeTableModel = this.getPointSizeModel();
        GEOSFontFile gEOSFontFile = gEOSFontPointSizeTableModel.getFontFile();
        for (int n : this.getSelectedPointSizes()) {
            gEOSFontFile.removeFontPointSize(n);
        }
        gEOSFontPointSizeTableModel.refresh();
    }

    private void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    private static class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final Border padding = BorderFactory.createEmptyBorder(0, 4, 0, 4);

        private MyCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jComponent.setBorder(BorderFactory.createCompoundBorder(jComponent.getBorder(), padding));
            return jComponent;
        }
    }

    private static class MyCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public MyCellEditor() {
            super(new JTextField());
        }
    }
}

