/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RockboxBitmapFontImporter
implements BitmapFontImporter {
    private static final int RB11 = 1380069681;
    private static final int RB12 = 1380069682;

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(byteArrayInputStream));
        byteArrayInputStream.close();
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(inputStream));
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont bitmapFont = this.importFontImpl(new DataInputStream(fileInputStream));
        fileInputStream.close();
        String string = bitmapFont.getName(1);
        if (string == null || string.length() == 0) {
            string = file.getName();
            if (string.toLowerCase().endsWith(".fnt")) {
                string = string.substring(0, string.length() - 4);
            } else if (string.toLowerCase().endsWith(".rbf")) {
                string = string.substring(0, string.length() - 4);
            } else if (string.toLowerCase().endsWith(".rb11")) {
                string = string.substring(0, string.length() - 5);
            } else if (string.toLowerCase().endsWith(".rb12")) {
                string = string.substring(0, string.length() - 5);
            }
            bitmapFont.setName(1, string);
        }
        return new BitmapFont[]{bitmapFont};
    }

    private BitmapFont importFontImpl(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        String string;
        String string2;
        int n3 = dataInputStream.readInt();
        if (n3 != 1380069681 && n3 != 1380069682) {
            throw new IOException("bad magic number");
        }
        if (n3 == 1380069681) {
            byte[] byArray = new byte[64];
            byte[] byArray2 = new byte[256];
            dataInputStream.readFully(byArray);
            dataInputStream.readFully(byArray2);
            string2 = new String(byArray, "UTF-8").trim();
            string = new String(byArray2, "UTF-8").trim();
        } else {
            string2 = null;
            string = null;
        }
        int n4 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n5 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n6 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n7 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n8 = Integer.reverseBytes(dataInputStream.readInt());
        int n9 = Integer.reverseBytes(dataInputStream.readInt());
        int n10 = Integer.reverseBytes(dataInputStream.readInt());
        int n11 = Integer.reverseBytes(dataInputStream.readInt());
        int n12 = Integer.reverseBytes(dataInputStream.readInt());
        int n13 = Integer.reverseBytes(dataInputStream.readInt());
        if (n7 != 0) {
            throw new IOException("anti-aliased not supported right now");
        }
        byte[] byArray = n3 == 1380069681 ? new byte[(n11 * 2 + 3) / 4 * 4] : new byte[(n11 + 1) / 2 * 2];
        dataInputStream.readFully(byArray);
        int[] nArray = new int[n12];
        int[] nArray2 = new int[n13];
        if (n3 == 1380069681) {
            for (n2 = 0; n2 < n12; ++n2) {
                nArray[n2] = Integer.reverseBytes(dataInputStream.readInt());
            }
        } else {
            for (n2 = 0; n2 < n12; ++n2) {
                nArray[n2] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
            }
        }
        for (n2 = 0; n2 < n13; ++n2) {
            nArray2[n2] = dataInputStream.readUnsignedByte();
        }
        BitmapFont bitmapFont = new BitmapFont(n6, n5 - n6, n6, n5 - n6, 0, 0, 0);
        if (string2 != null) {
            bitmapFont.setName(1, string2);
        }
        if (string != null) {
            bitmapFont.setName(0, string);
        }
        int n14 = (n = n9 - n8) >= 0 && n < n12 ? nArray[n] : 0;
        for (int i = 0; i < n10; ++i) {
            byte[] byArray3;
            int n15;
            if (i != n && i < n12 && nArray[i] == n14) continue;
            int n16 = i < n13 ? nArray2[i] : n4;
            int n17 = (n16 + 15) / 16 * 2;
            if (n3 == 1380069681) {
                n15 = i < n12 ? nArray[i] * 2 : n17 * n5 * i;
                byArray3 = RockboxBitmapFontImporter.swab(byArray, n15, n16, n5);
            } else {
                n15 = i < n12 ? nArray[i] : (n5 + 7) / 8 * n4 * i;
                byArray3 = RockboxBitmapFontImporter.rotright(byArray, n15, n16, n5);
            }
            byte[][] byArray4 = new byte[n5][n16];
            int n18 = 0;
            int n19 = 0;
            while (n19 < n5) {
                int n20 = 0;
                for (int j = 0; j < n17; ++j) {
                    int n21 = 128;
                    while (n21 != 0) {
                        if (n20 < n16 && (byArray3[n18 + j] & n21) != 0) {
                            byArray4[n19][n20] = -1;
                        }
                        n21 >>= 1;
                        ++n20;
                    }
                }
                ++n19;
                n18 += n17;
            }
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray4, 0, n16, n6);
            bitmapFont.putCharacter(n8 + i, bitmapFontGlyph);
        }
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private static byte[] swab(byte[] byArray, int n, int n2, int n3) {
        int n4 = (n2 + 15) / 16 * 2;
        int n5 = n4 * n3;
        byte[] byArray2 = new byte[n5];
        for (int i = 0; i < n5; ++i) {
            byArray2[i ^ 1] = byArray[n++];
        }
        return byArray2;
    }

    private static byte[] rotright(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = (n2 + 15) / 16;
        int n7 = n6 * n3;
        int[] nArray = new int[n7];
        int n8 = 1;
        for (int i = 0; i < n3; ++i) {
            n5 = i * n6;
            n4 = 32768;
            for (int j = 0; j < n2; ++j) {
                if ((byArray[n + j] & n8) != 0) {
                    int n9 = n5;
                    nArray[n9] = nArray[n9] | n4;
                }
                if ((n4 >>= 1) != 0) continue;
                n4 = 32768;
                ++n5;
            }
            if ((n8 <<= 1) < 256) continue;
            n8 = 1;
            n += n2;
        }
        byte[] byArray2 = new byte[n7 * 2];
        n5 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            byArray2[n5++] = (byte)(nArray[n4] >> 8);
            byArray2[n5++] = (byte)(nArray[n4] >> 0);
        }
        return byArray2;
    }
}

