/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialCasingCodec
extends PuaaCodec {
    @Override
    public String getFileName() {
        return "SpecialCasing.txt";
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"Lowercase_Mapping", "Titlecase_Mapping", "Uppercase_Mapping"};
    }

    @Override
    public void compile(PuaaTable puaaTable, Scanner scanner) {
        PuaaSubtable puaaSubtable = puaaTable.getOrCreateSubtable("Lowercase_Mapping");
        PuaaSubtable puaaSubtable2 = puaaTable.getOrCreateSubtable("Titlecase_Mapping");
        PuaaSubtable puaaSubtable3 = puaaTable.getOrCreateSubtable("Uppercase_Mapping");
        while (scanner.hasNextLine()) {
            String[] stringArray = PuaaUtility.splitLine(scanner.nextLine());
            if (stringArray == null || stringArray.length < 4) continue;
            PuaaSubtableEntry.CaseMapping caseMapping = SpecialCasingCodec.createEntry(stringArray, 1);
            if (caseMapping != null) {
                puaaSubtable.add(caseMapping);
            }
            if ((caseMapping = SpecialCasingCodec.createEntry(stringArray, 2)) != null) {
                puaaSubtable2.add(caseMapping);
            }
            if ((caseMapping = SpecialCasingCodec.createEntry(stringArray, 3)) == null) continue;
            puaaSubtable3.add(caseMapping);
        }
    }

    @Override
    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        PuaaSubtable puaaSubtable = puaaTable.getSubtable("Lowercase_Mapping");
        PuaaSubtable puaaSubtable2 = puaaTable.getSubtable("Titlecase_Mapping");
        PuaaSubtable puaaSubtable3 = puaaTable.getSubtable("Uppercase_Mapping");
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        if (puaaSubtable != null) {
            for (String[] stringArray : puaaSubtable) {
                SpecialCasingCodec.addLine(linkedHashMap, (PuaaSubtableEntry)stringArray, 1);
            }
        }
        if (puaaSubtable2 != null) {
            for (String[] stringArray : puaaSubtable2) {
                SpecialCasingCodec.addLine(linkedHashMap, (PuaaSubtableEntry)stringArray, 2);
            }
        }
        if (puaaSubtable3 != null) {
            for (String[] stringArray : puaaSubtable3) {
                SpecialCasingCodec.addLine(linkedHashMap, (PuaaSubtableEntry)stringArray, 3);
            }
        }
        for (String[] stringArray : linkedHashMap.values()) {
            printWriter.println(SpecialCasingCodec.joinLine(stringArray));
        }
    }

    private static PuaaSubtableEntry.CaseMapping createEntry(String[] stringArray, int n) {
        try {
            String string;
            PuaaSubtableEntry.CaseMapping caseMapping = new PuaaSubtableEntry.CaseMapping();
            int[] nArray = PuaaUtility.splitRange(stringArray[0]);
            caseMapping.firstCodePoint = nArray[0];
            caseMapping.lastCodePoint = nArray[1];
            String[] stringArray2 = stringArray[n].trim().split("\\s+");
            caseMapping.values = new int[stringArray2.length];
            for (n = 0; n < stringArray2.length; ++n) {
                caseMapping.values[n] = Integer.parseInt(stringArray2[n], 16);
            }
            if (stringArray.length > 4 && (string = stringArray[4].trim()).length() > 0) {
                caseMapping.condition = string;
            }
            return caseMapping;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static void addLine(LinkedHashMap<String, String[]> linkedHashMap, PuaaSubtableEntry puaaSubtableEntry, int n) {
        for (int i = puaaSubtableEntry.firstCodePoint; i <= puaaSubtableEntry.lastCodePoint; ++i) {
            String[] stringArray;
            String string = Integer.toHexString(-1073741824 + i);
            String string2 = puaaSubtableEntry.getPropertyValue(i);
            String string3 = null;
            int n2 = string2.indexOf(";");
            if (n2 >= 0) {
                string3 = string2.substring(n2 + 1).trim();
                string2 = string2.substring(0, n2).trim();
                string = string + string3;
            }
            if (linkedHashMap.containsKey(string)) {
                stringArray = linkedHashMap.get(string);
                stringArray[n] = string2;
                continue;
            }
            stringArray = new String[5];
            stringArray[0] = PuaaUtility.toHexString(i);
            stringArray[n] = string2;
            stringArray[4] = string3;
            linkedHashMap.put(string, stringArray);
        }
    }

    private static String joinLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray[0] != null) {
            stringBuffer.append(stringArray[0]);
        }
        stringBuffer.append("; ");
        if (stringArray[1] != null) {
            stringBuffer.append(stringArray[1]);
        }
        stringBuffer.append("; ");
        if (stringArray[2] != null) {
            stringBuffer.append(stringArray[2]);
        }
        stringBuffer.append("; ");
        if (stringArray[3] != null) {
            stringBuffer.append(stringArray[3]);
        }
        stringBuffer.append(";");
        if (stringArray[4] != null && stringArray[4].length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[4]);
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }
}

