/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ColrTable
extends TrueTypeTable {
    public int version = 0;
    public BaseGlyph[] baseGlyphRecords = new BaseGlyph[0];
    public Layer[] layerRecords = new Layer[0];

    public String tableName() {
        return "COLR";
    }

    public String[] dependencyNames() {
        return new String[0];
    }

    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n = this.version < 1 ? 14 : 34;
        dataOutputStream.writeShort(this.version);
        if (this.baseGlyphRecords != null) {
            dataOutputStream.writeShort(this.baseGlyphRecords.length);
            dataOutputStream.writeInt(n);
            n += this.baseGlyphRecords.length * 6;
        } else {
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(0);
        }
        if (this.layerRecords != null) {
            dataOutputStream.writeInt(n);
            n += this.layerRecords.length * 4;
            dataOutputStream.writeShort(this.layerRecords.length);
        } else {
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(0);
        }
        if (this.version >= 1) {
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
        }
        if (this.baseGlyphRecords != null) {
            for (BaseGlyph object : this.baseGlyphRecords) {
                object.write(dataOutputStream);
            }
        }
        if (this.layerRecords != null) {
            for (Layer layer : this.layerRecords) {
                layer.write(dataOutputStream);
            }
        }
        if (this.version >= 1) {
            // empty if block
        }
    }

    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n2;
        this.version = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readUnsignedShort();
        if (n4 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n4);
            this.baseGlyphRecords = new BaseGlyph[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.baseGlyphRecords[n2] = new BaseGlyph();
                this.baseGlyphRecords[n2].read(dataInputStream);
            }
        } else {
            this.baseGlyphRecords = null;
        }
        if (n5 > 0) {
            dataInputStream.reset();
            dataInputStream.skipBytes(n5);
            this.layerRecords = new Layer[n6];
            for (n2 = 0; n2 < n6; ++n2) {
                this.layerRecords[n2] = new Layer();
                this.layerRecords[n2].read(dataInputStream);
            }
        } else {
            this.layerRecords = null;
        }
    }

    public static final class Layer {
        public int glyphID;
        public int paletteIndex;

        public void read(DataInputStream dataInputStream) throws IOException {
            this.glyphID = dataInputStream.readUnsignedShort();
            this.paletteIndex = dataInputStream.readUnsignedShort();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.glyphID);
            dataOutputStream.writeShort(this.paletteIndex);
        }
    }

    public static final class BaseGlyph {
        public int glyphID;
        public int firstLayerIndex;
        public int numLayers;

        public void read(DataInputStream dataInputStream) throws IOException {
            this.glyphID = dataInputStream.readUnsignedShort();
            this.firstLayerIndex = dataInputStream.readUnsignedShort();
            this.numLayers = dataInputStream.readUnsignedShort();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.glyphID);
            dataOutputStream.writeShort(this.firstLayerIndex);
            dataOutputStream.writeShort(this.numLayers);
        }
    }
}

