/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.data;

import com.kreative.unicode.data.EncodingInclude;
import com.kreative.unicode.data.EncodingTable;
import com.kreative.unicode.data.GlyphList;
import com.kreative.unicode.data.UnicodeUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoding
extends EncodingTable
implements Comparable<Encoding> {
    private String name;
    private Set<String> aliases;
    private static final Pattern FUZZY_NAME = Pattern.compile("(map\\s+from\\s+)?(.+?)(\\s+character\\s+set)?(\\s+to\\s+unicode)?(\\s+table)?", 2);

    public Encoding(String string, InputStream inputStream) {
        this.name = string;
        this.aliases = Collections.emptySet();
        this.read(new Scanner(inputStream));
    }

    public Encoding(String string, Scanner scanner) {
        this.name = string;
        this.aliases = Collections.emptySet();
        this.read(scanner);
    }

    public Encoding(Charset charset) {
        this.name = charset.displayName();
        this.aliases = charset.aliases();
        this.decode(charset);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public int compareTo(Encoding encoding) {
        return UnicodeUtils.naturalCompare(this.name, encoding.name);
    }

    public boolean isMultiByte() {
        for (int i = 0; i < 256; ++i) {
            if (this.submaps[i] == null) continue;
            return true;
        }
        return false;
    }

    public GlyphList toGlyphList() {
        boolean bl = false;
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            if (this.seqs[i] != null && this.seqs[i].codePointCount(0, this.seqs[i].length()) == 1) {
                bl = true;
                nArray[i] = this.seqs[i].codePointAt(0);
                continue;
            }
            nArray[i] = -1;
        }
        return bl ? new GlyphList(nArray, this.name, this.aliases) : null;
    }

    private void read(Scanner scanner) {
        while (scanner.hasNextLine()) {
            Object object;
            Object object2;
            String string = scanner.nextLine().trim();
            if (string.length() <= 0) continue;
            String[] stringArray = string.split("#", 2);
            if ((string = stringArray[0].trim()).length() > 0) {
                stringArray = string.split("\\s+");
                if (stringArray.length <= 1) continue;
                try {
                    object2 = Encoding.parseBytes(stringArray[0]);
                    object = Encoding.parseChars(stringArray[1]);
                    this.setSequence((String)object, (byte[])object2);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (stringArray.length <= 1) continue;
            string = stringArray[1].trim();
            if (string.startsWith("Name:")) {
                object2 = string.substring(5).trim();
                if (((String)object2).length() <= 0) continue;
                object = FUZZY_NAME.matcher((CharSequence)object2);
                EncodingInclude[] encodingIncludeArray = ((Matcher)object).matches() ? ((Matcher)object).group(2).trim() : object2;
                this.name = encodingIncludeArray.length() > 0 ? encodingIncludeArray : object2;
                continue;
            }
            if (string.startsWith("Aliases:")) {
                object2 = string.substring(8).trim();
                if (((String)object2).length() <= 0) continue;
                object = Arrays.asList(((String)object2).split("\\s*[,;]\\s*"));
                this.aliases = Collections.unmodifiableSet(new HashSet<String>((Collection<String>)object));
                continue;
            }
            if (!string.startsWith("Include:") || ((String)(object2 = string.substring(8).trim())).length() <= 0) continue;
            object = Arrays.asList(((String)object2).split("\\s*[,;]\\s*"));
            for (EncodingInclude encodingInclude : EncodingInclude.values()) {
                if (!object.contains(encodingInclude.name())) continue;
                encodingInclude.includeIn(this);
            }
        }
    }

    private void decode(Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        charsetDecoder.replaceWith("\uffff");
        this.decode(charsetDecoder, new byte[256], 0, new char[256]);
    }

    private void decode(CharsetDecoder charsetDecoder, byte[] byArray, int n, char[] cArray) {
        for (int i = 0; i < 256; ++i) {
            byArray[n] = (byte)i;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n + 1);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                charsetDecoder.reset();
                charsetDecoder.decode(byteBuffer, charBuffer, false);
            }
            catch (Exception exception) {
                System.err.println("Failed to decode encoding " + this.name + "; it should be added to the list of broken charsets.");
                exception.printStackTrace();
                continue;
            }
            if (charBuffer.position() > 0) {
                String string = new String(cArray, 0, charBuffer.position());
                if (string.contains("\uffff")) continue;
                this.setSequence(string, byArray, 0, n + 1);
                continue;
            }
            if (n + 1 < byArray.length) {
                this.decode(charsetDecoder, byArray, n + 1, cArray);
                continue;
            }
            System.err.println("Failed to decode encoding " + this.name + "; it should be added to the list of broken charsets.");
        }
    }

    private static byte[] parseBytes(String string) {
        String[] stringArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String string2 : stringArray = string.split("[+,]")) {
            if ((string2 = string2.toUpperCase()).startsWith("0X")) {
                string2 = string2.substring(2);
            }
            if ((string2.length() & 1) == 1) {
                string2 = "0" + string2;
            }
            int n = string2.length();
            for (int i = 0; i < n; i += 2) {
                String string3 = string2.substring(i, i + 2);
                byteArrayOutputStream.write(Integer.parseInt(string3, 16));
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String parseChars(String string) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray = string.split("[+,]")) {
            if ((string2 = string2.toUpperCase()).startsWith("0X")) {
                string2 = string2.substring(2);
            }
            stringBuffer.append(Character.toChars(Integer.parseInt(string2, 16)));
        }
        return stringBuffer.toString();
    }
}

