//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// A NSURLDownload loads a request and saves the downloaded data to a file. The progress of the download
    /// is reported via the NSURLDownloadDelegate protocol. Note: The word "download" is used to refer to the process
    /// of loading data off a network, decoding the data if necessary and saving the data to a file.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurldownload?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSURLDownload;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSURLDownload {}
);

impl NSURLDownload {
    extern_methods!(
        #[cfg(feature = "NSString")]
        /// Returns whether or not NSURLDownload can resume a download that was decoded with a given encoding MIME type.
        ///
        /// Parameter `MIMEType`: The encoding MIME type.
        /// canResumeDownloadDecodedWithEncodingMIMEType: returns whether or not NSURLDownload can resume a download
        /// that was decoded with a given encoding MIME type.  NSURLDownload cannot resume a download that was partially decoded
        /// in the gzip format for example. In order to ensure that a download can be later resumed,
        /// canResumeDownloadDecodedWithEncodingMIMEType: should be used when download:shouldDecodeSourceDataOfMIMEType: is called.
        #[unsafe(method(canResumeDownloadDecodedWithEncodingMIMEType:))]
        #[unsafe(method_family = none)]
        pub fn canResumeDownloadDecodedWithEncodingMIMEType(mime_type: &NSString) -> bool;

        #[cfg(feature = "NSURLRequest")]
        /// Initializes a NSURLDownload object and starts the download.
        ///
        /// Parameter `request`: The request to download. Must not be nil.
        ///
        /// Parameter `delegate`: The delegate of the download.
        ///
        /// Returns: An initialized NSURLDownload object.
        #[deprecated = "Use NSURLSession downloadTask (see NSURLSession.h)"]
        #[unsafe(method(initWithRequest:delegate:))]
        #[unsafe(method_family = init)]
        pub fn initWithRequest_delegate(
            this: Allocated<Self>,
            request: &NSURLRequest,
            delegate: Option<&ProtocolObject<dyn NSURLDownloadDelegate>>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        /// Initializes a NSURLDownload object for resuming a previous download.
        ///
        /// Parameter `resumeData`: The resume data from the previous download.
        ///
        /// Parameter `delegate`: The delegate of the download.
        ///
        /// Parameter `path`: The path of the incomplete downloaded file.
        ///
        /// Returns: An initialized NSURLDownload object.
        #[deprecated = "Use NSURLSession downloadTask (see NSURLSession.h)"]
        #[unsafe(method(initWithResumeData:delegate:path:))]
        #[unsafe(method_family = init)]
        pub fn initWithResumeData_delegate_path(
            this: Allocated<Self>,
            resume_data: &NSData,
            delegate: Option<&ProtocolObject<dyn NSURLDownloadDelegate>>,
            path: &NSString,
        ) -> Retained<Self>;

        /// Cancels the download and deletes the downloaded file.
        #[unsafe(method(cancel))]
        #[unsafe(method_family = none)]
        pub fn cancel(&self);

        #[cfg(feature = "NSString")]
        /// Sets the destination path of the downloaded file.
        ///
        /// Parameter `path`: The destination path of the downloaded file.
        ///
        /// Parameter `allowOverwrite`: Allows a file of the same path to be overwritten.
        ///
        /// This method can be called after the download is created or in response to the
        /// decideDestinationWithSuggestedFilename: delegate method. It should only be called once.
        /// If NO is passed for allowOverwrite and a file of the same path exists, a number will be
        /// appended to the filename to prevent the overwrite. Because of this, use the path
        /// passed with didCreateDestination: to determine the actual path of the downloaded file.
        #[unsafe(method(setDestination:allowOverwrite:))]
        #[unsafe(method_family = none)]
        pub fn setDestination_allowOverwrite(&self, path: &NSString, allow_overwrite: bool);

        #[cfg(feature = "NSURLRequest")]
        /// Returns the request of the download.
        ///
        /// Returns: The request of the download.
        #[unsafe(method(request))]
        #[unsafe(method_family = none)]
        pub fn request(&self) -> Retained<NSURLRequest>;

        #[cfg(feature = "NSData")]
        /// Returns the resume data of a download that is incomplete.
        ///
        /// Returns: The resume data.
        /// resumeData returns the resume data of a download that is incomplete. This data represents the necessary
        /// state information that NSURLDownload needs to resume a download. The resume data can later be used when initializing
        /// a download with initWithResumeData:delegate:path:. Non-nil is returned if resuming the download seems possible.
        /// Non-nil is returned if the download was cancelled or ended in error after some but not all data has been received.
        /// The protocol of the download as well as the server must support resuming for non-nil to be returned.
        /// In order to later resume a download, be sure to call setDeletesFileUponFailure: with NO.
        #[unsafe(method(resumeData))]
        #[unsafe(method_family = none)]
        pub fn resumeData(&self) -> Option<Retained<NSData>>;

        /// Sets whether or not the downloaded file should be deleted upon failure.
        /// 1
        /// To allow the download to be resumed in case the download ends prematurely,
        /// deletesFileUponFailure must be set to NO as soon as possible to prevent the downloaded file
        /// from being deleted. deletesFileUponFailure is YES by default.
        #[unsafe(method(deletesFileUponFailure))]
        #[unsafe(method_family = none)]
        pub fn deletesFileUponFailure(&self) -> bool;

        /// Setter for [`deletesFileUponFailure`][Self::deletesFileUponFailure].
        #[unsafe(method(setDeletesFileUponFailure:))]
        #[unsafe(method_family = none)]
        pub fn setDeletesFileUponFailure(&self, deletes_file_upon_failure: bool);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSURLDownload {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSURLDownload {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_protocol!(
    /// The NSURLDownloadDelegate delegate is used to report the progress of the download.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurldownloaddelegate?language=objc)
    pub unsafe trait NSURLDownloadDelegate: NSObjectProtocol {
        /// This method is called immediately after the download has started.
        ///
        /// Parameter `download`: The download that just started downloading.
        #[optional]
        #[unsafe(method(downloadDidBegin:))]
        #[unsafe(method_family = none)]
        fn downloadDidBegin(&self, download: &NSURLDownload);

        #[cfg(all(feature = "NSURLRequest", feature = "NSURLResponse"))]
        /// This method is called if the download must load another request because the previous
        /// request was redirected.
        ///
        /// Parameter `download`: The download that will send the request.
        ///
        /// Parameter `request`: The request that will be used to continue loading.
        ///
        /// Returns: The request to be used; either the request parameter or a replacement. If nil is returned,
        /// the download is cancelled.
        ///
        /// This method gives the delegate an opportunity to inspect the request
        /// that will be used to continue loading the request, and modify it if necessary.
        #[optional]
        #[unsafe(method(download:willSendRequest:redirectResponse:))]
        #[unsafe(method_family = none)]
        fn download_willSendRequest_redirectResponse(
            &self,
            download: &NSURLDownload,
            request: &NSURLRequest,
            redirect_response: Option<&NSURLResponse>,
        ) -> Option<Retained<NSURLRequest>>;

        #[cfg(feature = "NSURLProtectionSpace")]
        /// This method gives the delegate an opportunity to inspect an NSURLProtectionSpace before an authentication attempt is made.
        ///
        /// If implemented, will be called before connection:didReceiveAuthenticationChallenge
        /// to give the delegate a chance to inspect the protection space that will be authenticated against.  Delegates should determine
        /// if they are prepared to respond to the authentication method of the protection space and if so, return YES, or NO to
        /// allow default processing to handle the authentication.  If this delegate is not implemented, then default
        /// processing will occur (typically, consulting
        /// the user's keychain and/or failing the connection attempt.
        ///
        /// Parameter `connection`: an NSURLConnection that has an NSURLProtectionSpace ready for inspection
        ///
        /// Parameter `protectionSpace`: an NSURLProtectionSpace that will be used to generate an authentication challenge
        ///
        /// Returns: a boolean value that indicates the willingness of the delegate to handle the authentication
        #[optional]
        #[unsafe(method(download:canAuthenticateAgainstProtectionSpace:))]
        #[unsafe(method_family = none)]
        fn download_canAuthenticateAgainstProtectionSpace(
            &self,
            connection: &NSURLDownload,
            protection_space: &NSURLProtectionSpace,
        ) -> bool;

        #[cfg(feature = "NSURLAuthenticationChallenge")]
        /// Start authentication for a given challenge
        ///
        /// Parameter `download`: The download that needs authentication.
        ///
        /// Parameter `challenge`: The NSURLAuthenticationChallenge for which to start authentication.
        ///
        /// Call useCredential:forAuthenticationChallenge:,
        /// continueWithoutCredentialForAuthenticationChallenge: or cancel on
        /// the connection sender when done.
        #[optional]
        #[unsafe(method(download:didReceiveAuthenticationChallenge:))]
        #[unsafe(method_family = none)]
        fn download_didReceiveAuthenticationChallenge(
            &self,
            download: &NSURLDownload,
            challenge: &NSURLAuthenticationChallenge,
        );

        #[cfg(feature = "NSURLAuthenticationChallenge")]
        /// Cancel authentication for a given request
        ///
        /// Parameter `download`: The download that's cancelling
        ///
        /// Parameter `challenge`: The NSURLAuthenticationChallenge to cancel authentication for
        #[optional]
        #[unsafe(method(download:didCancelAuthenticationChallenge:))]
        #[unsafe(method_family = none)]
        fn download_didCancelAuthenticationChallenge(
            &self,
            download: &NSURLDownload,
            challenge: &NSURLAuthenticationChallenge,
        );

        /// This method allows the delegate to inform the url loader that it
        /// should not consult the credential storage for the download.
        ///
        /// This method will be called before any attempt to authenticate is
        /// attempted on a download.  By returning NO the delegate is telling the
        /// download to not consult the credential storage and taking responsibility
        /// for providing any credentials for authentication challenges.  Not implementing
        /// this method is the same as returning YES.  The delegate is free to consult the
        /// credential storage itself when it receives a didReceiveAuthenticationChallenge
        /// message.
        ///
        /// Parameter `download`: the NSURLDownload object asking if it should consult the credential storage.
        ///
        /// Returns: NO if the download should not consult the credential storage, Yes if it should.
        #[optional]
        #[unsafe(method(downloadShouldUseCredentialStorage:))]
        #[unsafe(method_family = none)]
        fn downloadShouldUseCredentialStorage(&self, download: &NSURLDownload) -> bool;

        #[cfg(feature = "NSURLResponse")]
        /// This method is called when the download has received a response from the server.
        ///
        /// Parameter `download`: The download that now has a NSURLResponse available for inspection.
        ///
        /// Parameter `response`: The NSURLResponse object for the given download.
        ///
        /// In some rare cases, multiple responses may be received for a single download.
        /// This occurs with multipart/x-mixed-replace, or "server push". In this case, the client
        /// should assume that each new response resets progress so far for the resource back to 0,
        /// and should check the new response for the expected content length.
        #[optional]
        #[unsafe(method(download:didReceiveResponse:))]
        #[unsafe(method_family = none)]
        fn download_didReceiveResponse(&self, download: &NSURLDownload, response: &NSURLResponse);

        #[cfg(feature = "NSURLResponse")]
        /// This method is called when the download has received a response from the server after attempting to
        /// resume a download.
        ///
        /// Parameter `download`: The download that now has a NSURLResponse available for inspection.
        ///
        /// Parameter `response`: The NSURLResponse object for the given download.
        ///
        /// Parameter `startingByte`: The number of bytes from where the download will resume. 0 indicates that the download will
        /// restart from the beginning.
        ///
        /// download:willResumeWithResponse:fromByte: is called instead of download:didReceiveResponse:
        /// when a download is initialized with initWithResumeData:delegate:path:.
        #[optional]
        #[unsafe(method(download:willResumeWithResponse:fromByte:))]
        #[unsafe(method_family = none)]
        fn download_willResumeWithResponse_fromByte(
            &self,
            download: &NSURLDownload,
            response: &NSURLResponse,
            starting_byte: c_longlong,
        );

        /// This method is called when the download has loaded data.
        ///
        /// Parameter `download`: The download that has received data.
        ///
        /// Parameter `length`: The length of the received data.
        ///
        /// This method will be called one or more times.
        #[optional]
        #[unsafe(method(download:didReceiveDataOfLength:))]
        #[unsafe(method_family = none)]
        fn download_didReceiveDataOfLength(&self, download: &NSURLDownload, length: NSUInteger);

        #[cfg(feature = "NSString")]
        /// This method is called if the download detects that the downloading file is encoded.
        ///
        /// Parameter `download`: The download that has detected that the downloading file is encoded.
        ///
        /// Parameter `encodingType`: A MIME type expressing the encoding type.
        ///
        /// Returns: Return YES to decode the file, NO to not decode the file.
        ///
        /// An encoded file is encoded in MacBinary, BinHex or gzip format. This method may be
        /// called more than once if the file is encoded multiple times. This method is not called if the
        /// download is not encoded.
        #[optional]
        #[unsafe(method(download:shouldDecodeSourceDataOfMIMEType:))]
        #[unsafe(method_family = none)]
        fn download_shouldDecodeSourceDataOfMIMEType(
            &self,
            download: &NSURLDownload,
            encoding_type: &NSString,
        ) -> bool;

        #[cfg(feature = "NSString")]
        /// This method is called when enough information has been loaded to decide a destination
        /// for the downloaded file.
        ///
        /// Parameter `download`: The download that requests the download path.
        ///
        /// Parameter `filename`: The suggested filename for deciding the path of the downloaded file. The filename is either
        /// derived from the last path component of the URL and the MIME type or if the download was encoded,
        /// it is the filename specified in the encoding.
        ///
        /// Once the delegate has decided a path, it should call setDestination:allowOverwrite:.
        /// The delegate may respond immediately or later. This method is not called if
        /// setDestination:allowOverwrite: has already been called.
        #[optional]
        #[unsafe(method(download:decideDestinationWithSuggestedFilename:))]
        #[unsafe(method_family = none)]
        fn download_decideDestinationWithSuggestedFilename(
            &self,
            download: &NSURLDownload,
            filename: &NSString,
        );

        #[cfg(feature = "NSString")]
        /// This method is called after the download creates the downloaded file.
        ///
        /// Parameter `download`: The download that created the downloaded file.
        ///
        /// Parameter `path`: The path of the downloaded file.
        #[optional]
        #[unsafe(method(download:didCreateDestination:))]
        #[unsafe(method_family = none)]
        fn download_didCreateDestination(&self, download: &NSURLDownload, path: &NSString);

        /// This method is called when the download has finished downloading.
        ///
        /// Parameter `download`: The download that has finished downloading.
        ///
        /// This method is called after all the data has been received and written to disk.
        /// This method or download:didFailWithError: will only be called once.
        #[optional]
        #[unsafe(method(downloadDidFinish:))]
        #[unsafe(method_family = none)]
        fn downloadDidFinish(&self, download: &NSURLDownload);

        #[cfg(feature = "NSError")]
        /// This method is called when the download has failed.
        ///
        /// Parameter `download`: The download that ended in error.
        ///
        /// Parameter `error`: The error caused the download to fail.
        ///
        /// This method is called when the download encounters a network or file I/O related error.
        /// This method or downloadDidFinish: will only be called once.
        #[optional]
        #[unsafe(method(download:didFailWithError:))]
        #[unsafe(method_family = none)]
        fn download_didFailWithError(&self, download: &NSURLDownload, error: &NSError);
    }
);
