# data/keymap/

Directory for keymaps (shortcut keys)

Shortcut keys are configurable from the preferences dialog GUI.

*   Preferences GUI > General tab > Keymap > Keymap style.

## Files

*   atok.tsv
    +   ATOK style keymap.
*   ms-ime.tsv
    +   Windows style keymap. default for the Windows version.
*   kotoeri.tsv
    +   macOS style keymap. default for the macOS version.
*   chromeos.tsv
    +   default keymap for ChromeOS, similar with the Windows style.
*   mobile.tsv
    +   Keymap for mobile input.
*   overlay_kenkan_muhenkan_to_ime_on_off.tsv
    +   Subset of keymap for special purpose.

## Commands

Commands are defined in
[session/internal/keymap.cc](../../session/internal/keymap.cc)

## Input modes

*   Direct
    +   Mode to type Latin characters without IME.
*   Precomposition
    +   Mode to type Hiragana characters, but no character is typed yet.
*   Composition
    +   Mode to type Hiragana characters.
*   Suggestion
    +   Sub-mode of Composition. Some word suggestions have appeared, but no
        candidate is focused.
*   Conversion
    +   Mode to select words (in Kanji). Candidate words are generated by
        exact-match (by Space key).
*   Prediction
    +   Sub-mode of Conversion. Candidate words are generated by prefix-match
        (by Tab key).

![Diagram of input modes](../../../docs/input_modes.svg)
![Screenshots of input modes](../../../docs/input_modes.png)
