// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Get_ready_screen_h
#define Get_ready_screen_h




#include "SDL.h"
#include "enums.h"
#include "User_input.h"
#include "FS_gfx.h"
#include <tr1/memory>
#include "constants.h"




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;
extern std::tr1::shared_ptr<FS::User_input> input_ptr;




namespace FS
{
    
class Get_ready_screen
{
    public:

        Get_ready_screen();
        ~Get_ready_screen();
        
        void init_level_select(int furthest_lev);
        int update_level_select();
        // FIXME: Having to pass in the level's a bit clumsy, maybe?
        void init_countdown(int t, int lev);
        bool update_countdown(int t, int lev);

    private:

        static const int SECONDS_TO_WAIT = 10;
    
        int start_time;
        int current_start_level;
        // 'furthest_level' MUST be reset on every call to init_level_select
        // to ensure it remains valid!
        int furthest_level; 

        void draw_level_select();
        void draw_countdown(int seconds, int lev);

}; // class Get_ready_screen
    
} // namespace FS




#endif
    
