// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.

// N.B. This class is based on the work of Karl Bartel's original SFont.
// See http://www.linux-games.com/sfont/ for details.




#ifndef SFont_gl_h
#define SFont_gl_h




#include <string>
#include <SDL/SDL.h>
#include <SDL/SDL_opengl.h>
#include <SDL/SDL_image.h>
#include <iostream>
#include <vector>
#include "Useful_gl.h"




namespace Mafferyew
{
 
class SFont_gl
{
    public:
        
        explicit SFont_gl(const std::string& image_file);
        ~SFont_gl();
    
        void write(int x, 
                   int y, 
                   const std::string& text) const;
        
        void write_center(int screen_width, 
                          int y, 
                          const std::string& text) const;
        
        int text_width(const std::string& text) const;
        
        int text_height() const { return font_height; }
        
        int get_spacing() const { return spacing; }
        
        void set_spacing(int spc = DEFAULT_SPACING);
        
        
    private:
        
        static const int DEFAULT_SPACING = 5;
        static const int MIN_SPACING = 4;
        static const int MAX_SPACING = 20;
        static const int BEGIN_ASCII = 33;  // '!'
        static const int END_ASCII = 127;   // one past '~'
        static const int NUM_FONT_CHARS = 94;
        
        struct Font_char
        {
            GLuint texture;
            int visible_w;
            int texture_w;
            int texture_h;
        }; // struct Font_char
        
        std::vector<Font_char> my_font_chars;
        int spacing;
        // Accessible via public interface - see 'text_height' above.
        int font_height;    
        
        void init(const std::string& image_file);
        
        void create_font_char(SDL_Surface* image, 
                              int begin_x, 
                              int end_x);
        
}; // class SFont_gl

} // namespace Mafferyew
        
        
        

#endif
