// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Sound_engine.h"
#include <iostream>




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Sound_engine::Sound_engine()
{
    sounds[0] = Mix_LoadWAV( PKG_DATA_DIR "/sounds/miaow.wav" );
    sounds[1] = Mix_LoadWAV( PKG_DATA_DIR "/sounds/splash.wav" );
    sounds[2] = Mix_LoadWAV( PKG_DATA_DIR "/sounds/river.wav" );
    sounds[3] = Mix_LoadWAV( PKG_DATA_DIR "/sounds/ping.wav" );
    
} // FS::Sound_engine::Sound_engine

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Sound_engine::~Sound_engine()
{
    for (int i = 0; i < NUM_SOUNDS; ++i)
    {
        Mix_FreeChunk(sounds[i]);
    } // for
    
} // FS::Sound_engine::~Sound_engine




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Sound_engine::play_sound(SoundIDs sid, int loops, int volume)
{
    //if (!on) { return; }
    if (sound_available && on)
    {
        Mix_PlayChannel((int) sid, sounds[sid], loops);
        Mix_VolumeChunk(sounds[sid], volume);
    } // if

} // FS::Sound_engine::play_sound

// **************************************************

void FS::Sound_engine::stop_sound(int channel)
{
    //if (!on) { return; }
    if (sound_available && on)
    {
        Mix_HaltChannel(channel);
    } // if

} // FS::Sound_engine::stop_sound

// **************************************************

void FS::Sound_engine::stop_all_sounds()
{
    //if (!on) { return; }
    if (sound_available && on)
    {
        for (int i = 0; i < NUM_SOUNDS; ++i)
        {
            Mix_HaltChannel(i);
        } // for
    } // if

} // FS::Sound_engine::stop_all_sounds 

// **************************************************

void FS::Sound_engine::pause_all_sounds()
{
    //if (!on) { return; }
    if (sound_available && on)
    {
        for (int i = 0; i < NUM_SOUNDS; ++i)
        {
            Mix_Pause(i);
        } // for
    } // if

} // FS::Sound_engine::pause_all_sounds
    
// **************************************************

void FS::Sound_engine::resume_all_sounds()
{
    //if (!on) { return; }
    if (sound_available && on)
    {
        for (int i = 0; i < NUM_SOUNDS; ++i)
        {
            Mix_Resume(i);
        } // for
    } // if

} // FS::Sound_engine::resume_all_sounds
    
// **************************************************
