/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSRemoveBooleanEqualityIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        return JSIntentionBundle.message("bool.remove-boolean-equality.display-name", sign == JSTokenTypes.EQEQ ? "==" : "!=");
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("bool.remove-boolean-equality.family-name", new Object[0]);
        if (string == null) {
            JSRemoveBooleanEqualityIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new BooleanLiteralEqualityPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSRemoveBooleanEqualityIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSRemoveBooleanEqualityIntention.$$$reportNull$$$0(2);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        boolean isEquals = JSTokenTypes.EQEQ.equals(exp.getOperationSign());
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        assert (lhs != null);
        assert (rhs != null);
        String lhsText = lhs.getText();
        String rhsText = rhs.getText();
        if (com.sixrr.inspectjs.utils.BoolUtils.isTrueLiteral((JSExpression)lhs)) {
            if (isEquals) {
                JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)rhsText);
            } else {
                ConditionalUtils.replaceExpressionWithNegatedExpression(rhs, (JSExpression)exp);
            }
        } else if (com.sixrr.inspectjs.utils.BoolUtils.isFalseLiteral((JSExpression)lhs)) {
            if (isEquals) {
                ConditionalUtils.replaceExpressionWithNegatedExpression(rhs, (JSExpression)exp);
            } else {
                JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)rhsText);
            }
        } else if (com.sixrr.inspectjs.utils.BoolUtils.isTrueLiteral((JSExpression)rhs)) {
            if (isEquals) {
                JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)lhsText);
            } else {
                ConditionalUtils.replaceExpressionWithNegatedExpression(lhs, (JSExpression)exp);
            }
        } else if (isEquals) {
            ConditionalUtils.replaceExpressionWithNegatedExpression(lhs, (JSExpression)exp);
        } else {
            JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)lhsText);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSRemoveBooleanEqualityIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSRemoveBooleanEqualityIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class BooleanLiteralEqualityPredicate
    implements JSElementPredicate {
        private BooleanLiteralEqualityPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                BooleanLiteralEqualityPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression expression = (JSBinaryExpression)element;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            IElementType sign = expression.getOperationSign();
            if (!JSTokenTypes.EQEQ.equals(sign) && !JSTokenTypes.NE.equals(sign)) {
                return false;
            }
            JSExpression lhs = expression.getLOperand();
            JSExpression rhs = expression.getROperand();
            return lhs != null && rhs != null && (BoolUtils.isBooleanLiteral(lhs) || BoolUtils.isBooleanLiteral(rhs));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSRemoveBooleanEqualityIntention$BooleanLiteralEqualityPredicate", "satisfiedBy"));
        }
    }
}

