/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.ES6CodeStyleImportsUI;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.Objects;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CodeStyleImportsPanel {
    @NotNull
    private final Class<? extends JSCodeStyleSettings> mySettingsClass;
    protected final JSApplicationSettings appSettings;
    private final ES6CodeStyleImportsUI ui;

    @NotNull
    public static CodeStyleAbstractPanel getImportsCodeStylePanel(@NotNull CodeStyleSettings settings, final @NotNull FileType type2, final @NotNull ES6CodeStyleImportsPanel panel) {
        if (settings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(1);
        }
        if (panel == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(2);
        }
        JBScrollPane content = new JBScrollPane((Component)panel.ui.panel);
        return new CodeStyleAbstractPanel(settings, (JComponent)content){
            final /* synthetic */ JComponent val$content;
            {
                this.val$content = jComponent;
                super(arg0);
            }

            protected int getRightMargin() {
                return 0;
            }

            protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(0);
                }
                return null;
            }

            @NotNull
            protected FileType getFileType() {
                FileType fileType = type2;
                if (fileType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return fileType;
            }

            protected String getPreviewText() {
                return null;
            }

            public void apply(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                panel.apply(settings);
            }

            public boolean isModified(CodeStyleSettings settings) {
                return panel.isModified(settings);
            }

            public JComponent getPanel() {
                return this.val$content;
            }

            protected void resetImpl(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(3);
                }
                panel.reset(settings);
            }

            @NlsContexts.TabTitle
            @NotNull
            protected String getTabTitle() {
                String string = ApplicationBundle.message((String)"title.imports", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFileType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTabTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createHighlighter";
                        break;
                    }
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "resetImpl";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    public ES6CodeStyleImportsPanel(@NotNull Class<? extends JSCodeStyleSettings> settingsClass) {
        if (settingsClass == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(3);
        }
        this.appSettings = JSApplicationSettings.getInstance();
        this.mySettingsClass = settingsClass;
        this.ui = new ES6CodeStyleImportsUI(this.getAbsolutePathCheckboxTitle(), this.getPathsComboBoxTitle(), this.getPathsHelpText(), (Function1<? super JSCodeStyleSettings.UseExplicitExtension, String>)((Function1)this::getExplicitExtensionText), this.getExtensionsHelpText(), this.hasImportType());
    }

    @NlsSafe
    @NotNull
    protected String getExplicitExtensionText(@NotNull JSCodeStyleSettings.UseExplicitExtension value) {
        if (value == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(4);
        }
        String string = JavaScriptBundle.message(switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case JSCodeStyleSettings.UseExplicitExtension.NEVER -> "js.import.options.use.explicit.js.extension.no";
            case JSCodeStyleSettings.UseExplicitExtension.ALWAYS_JS -> "js.import.options.use.explicit.js.extension.yes";
            case JSCodeStyleSettings.UseExplicitExtension.AUTO -> "js.import.options.use.explicit.js.extension.auto";
        }, new Object[0]);
        if (string == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsContexts.Tooltip
    @NotNull
    protected String getPathsHelpText() {
        String string = JavaScriptBundle.message("es6.import.options.paths.help", new Object[0]);
        if (string == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NlsContexts.Tooltip
    @NotNull
    protected String getExtensionsHelpText() {
        String string = JavaScriptBundle.message("es6.import.options.exts.help", new Object[0]);
        if (string == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected boolean hasImportType() {
        return false;
    }

    @NlsContexts.Label
    @NotNull
    protected String getPathsComboBoxTitle() {
        String string = JavaScriptBundle.message("es6.import.options.paths", new Object[0]);
        if (string == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isModified(@NotNull CodeStyleSettings commonSettings) {
        JSCodeStyleSettings jsSettings;
        JSApplicationSettings appSettings;
        if (commonSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(9);
        }
        return ES6CodeStyleImportsPanel.getMergeImports(appSettings = JSApplicationSettings.getInstance(), jsSettings = this.getCustomJSSettings(commonSettings)) != this.ui.myMergeImports.isSelected() || this.getUseAbsolutePath(jsSettings) != this.ui.myUseAbsolutePathJBCheckBox.isSelected() || this.getUseNodeModulesResolution(jsSettings) != this.ui.myUseNodeModulesResolutionImports.isSelected() || jsSettings.IMPORT_SORT_MEMBERS != this.ui.mySortMembers.isSelected() || jsSettings.IMPORT_SORT_MODULE_NAME != this.ui.mySortModuleName.isSelected() || jsSettings.USE_PATH_MAPPING != this.ui.myPathMappingBox.getSelectedItem() || jsSettings.getUseExplicitJSExtension() != this.getUseExplicitJSExtensionCheckboxValue() || jsSettings.getUseImportType() != this.ui.myUseImportType.getSelectedItem() || !StringUtil.equals((CharSequence)ES6CodeStyleImportsPanel.getBannedListString(jsSettings), (CharSequence)this.ui.myBlacklistImports.getText());
    }

    public void apply(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(10);
        }
        JSApplicationSettings appSettings = JSApplicationSettings.getInstance();
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.applyUseNodeModulesResolution(jsSettings, this.ui.myUseNodeModulesResolutionImports.isSelected());
        this.applyUseAbsolutePath(jsSettings, this.ui.myUseAbsolutePathJBCheckBox.isSelected());
        ES6CodeStyleImportsPanel.applyMergeImports(appSettings, jsSettings, this.ui.myMergeImports.isSelected());
        jsSettings.setUseExplicitJSExtension(this.getUseExplicitJSExtensionCheckboxValue());
        jsSettings.setUseImportType((JSCodeStyleSettings.UseImportType)((Object)Objects.requireNonNull(this.ui.myUseImportType.getSelectedItem())));
        jsSettings.IMPORT_SORT_MEMBERS = this.ui.mySortMembers.isSelected();
        jsSettings.IMPORT_SORT_MODULE_NAME = this.ui.mySortModuleName.isSelected();
        Object item = this.ui.myPathMappingBox.getSelectedItem();
        if (item instanceof JSCodeStyleSettings.PathMappingOption) {
            jsSettings.USE_PATH_MAPPING = (JSCodeStyleSettings.PathMappingOption)((Object)item);
        }
        ES6CodeStyleImportsPanel.applyBlacklist(jsSettings, this.ui.myBlacklistImports.getText());
    }

    @NotNull
    protected JSCodeStyleSettings.UseExplicitExtension getUseExplicitJSExtensionCheckboxValue() {
        JSCodeStyleSettings.UseExplicitExtension useExplicitExtension = (JSCodeStyleSettings.UseExplicitExtension)((Object)Objects.requireNonNull(this.ui.myUseExplicitJSExtension.getSelectedItem()));
        if (useExplicitExtension == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(11);
        }
        return useExplicitExtension;
    }

    protected void setUseExplicitJSExtensionCheckboxValue(JSCodeStyleSettings.UseExplicitExtension useExplicitJSExtension) {
        this.ui.myUseExplicitJSExtension.setSelectedItem((Object)useExplicitJSExtension);
    }

    public void reset(@NotNull CodeStyleSettings commonSettings) {
        if (commonSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(12);
        }
        JSApplicationSettings appSettings = JSApplicationSettings.getInstance();
        JSCodeStyleSettings jsSettings = this.getCustomJSSettings(commonSettings);
        this.ui.myUseNodeModulesResolutionImports.setSelected(this.getUseNodeModulesResolution(jsSettings));
        this.ui.myUseAbsolutePathJBCheckBox.setSelected(this.getUseAbsolutePath(jsSettings));
        this.ui.myMergeImports.setSelected(ES6CodeStyleImportsPanel.getMergeImports(appSettings, jsSettings));
        this.ui.mySortMembers.setSelected(jsSettings.IMPORT_SORT_MEMBERS);
        this.ui.mySortModuleName.setSelected(jsSettings.IMPORT_SORT_MODULE_NAME);
        this.ui.myBlacklistImports.setText(ES6CodeStyleImportsPanel.getBannedListString(jsSettings));
        this.ui.myPathMappingBox.setSelectedItem((Object)jsSettings.USE_PATH_MAPPING);
        this.setUseExplicitJSExtensionCheckboxValue(jsSettings.getUseExplicitJSExtension());
        this.ui.myUseImportType.setSelectedItem((Object)jsSettings.getUseImportType());
    }

    private static void applyMergeImports(@NotNull JSApplicationSettings appSettings, @NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (appSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(13);
        }
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(14);
        }
        if (appSettings.isMergeImports() == value) {
            jsSettings.IMPORT_MERGE_MEMBERS = JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL;
            return;
        }
        jsSettings.IMPORT_MERGE_MEMBERS = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    @NlsContexts.Checkbox
    @NotNull
    protected String getAbsolutePathCheckboxTitle() {
        String string = JavaScriptBundle.message("javascript.import.options.use.resource.root", new Object[0]);
        if (string == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static boolean getMergeImports(@NotNull JSApplicationSettings appSettings, @NotNull JSCodeStyleSettings jsSettings) {
        JSCodeStyleSettings.BooleanWithGlobalOption value;
        if (appSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(16);
        }
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(17);
        }
        return (value = jsSettings.IMPORT_MERGE_MEMBERS) == JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL ? appSettings.isMergeImports() : value == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    @NotNull
    protected JSCodeStyleSettings getCustomJSSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(18);
        }
        JSCodeStyleSettings jSCodeStyleSettings = (JSCodeStyleSettings)settings.getCustomSettings(this.mySettingsClass);
        if (jSCodeStyleSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(19);
        }
        return jSCodeStyleSettings;
    }

    private boolean getUseAbsolutePath(@NotNull JSCodeStyleSettings jsSettings) {
        JSCodeStyleSettings.BooleanWithGlobalOption value;
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(20);
        }
        return (value = jsSettings.IMPORT_PREFER_ABSOLUTE_PATH) == JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL ? this.appSettings.isUseAbsoluteConfigPath() : value == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    private void applyUseAbsolutePath(@NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(21);
        }
        if (this.appSettings.isUseAbsoluteConfigPath() == value) {
            jsSettings.IMPORT_PREFER_ABSOLUTE_PATH = JSCodeStyleSettings.BooleanWithGlobalOption.GLOBAL;
            return;
        }
        jsSettings.IMPORT_PREFER_ABSOLUTE_PATH = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    protected boolean getUseNodeModulesResolution(@NotNull JSCodeStyleSettings jsSettings) {
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(22);
        }
        return jsSettings.IMPORT_USE_NODE_RESOLUTION == JSCodeStyleSettings.BooleanWithGlobalOption.TRUE;
    }

    protected void applyUseNodeModulesResolution(@NotNull JSCodeStyleSettings jsSettings, boolean value) {
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(23);
        }
        jsSettings.IMPORT_USE_NODE_RESOLUTION = value ? JSCodeStyleSettings.BooleanWithGlobalOption.TRUE : JSCodeStyleSettings.BooleanWithGlobalOption.FALSE;
    }

    protected static String getBannedListString(@NotNull JSCodeStyleSettings jsSettings) {
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(24);
        }
        return jsSettings.BLACKLIST_IMPORTS;
    }

    protected static void applyBlacklist(@NotNull JSCodeStyleSettings jsSettings, @Nullable String value) {
        if (jsSettings == null) {
            ES6CodeStyleImportsPanel.$$$reportNull$$$0(25);
        }
        jsSettings.BLACKLIST_IMPORTS = StringUtil.notNullize((String)StringUtil.trim((String)value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 11, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appSettings";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/ES6CodeStyleImportsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitExtensionText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsHelpText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionsHelpText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsComboBoxTitle";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseExplicitJSExtensionCheckboxValue";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePathCheckboxTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomJSSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportsCodeStylePanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitExtensionText";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyMergeImports";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMergeImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCustomJSSettings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUseAbsolutePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyUseAbsolutePath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUseNodeModulesResolution";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyUseNodeModulesResolution";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBannedListString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyBlacklist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 11, 15, 19 -> new IllegalStateException(string);
        };
    }
}

