/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceVariableIntention
extends BaseElementAtCaretIntentionAction
implements Iconable,
LowPriorityAction {
    public JSIntroduceVariableIntention() {
        this.setText(JavaScriptBundle.message("javascript.introduce.variable.title.local", new Object[0]));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.introduce.variable.title.local", new Object[0]);
        if (string == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return ExperimentalUI.isNewUI() ? null : AllIcons.Actions.RefactoringBulb;
    }

    private static boolean isInNestedContext(@NotNull PsiElement element2, @NotNull PsiElement otherElement) {
        JSFunctionItem parentFunc;
        if (element2 == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(1);
        }
        if (otherElement == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(2);
        }
        return (parentFunc = (JSFunctionItem)PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunctionItem.class)) != null && PsiTreeUtil.isAncestor((PsiElement)otherElement, (PsiElement)parentFunc, (boolean)true);
    }

    @Contract(value="null -> false")
    protected boolean isApplicableExpression(@Nullable JSExpression expression) {
        JSAttributeList attList;
        if (expression == null || expression instanceof JSAssignmentExpression) {
            return false;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSIfStatement && ((JSIfStatement)parent).getCondition() == expression) {
            return false;
        }
        if (parent instanceof JSSwitchStatement && ((JSSwitchStatement)parent).getSwitchExpression() == expression) {
            return false;
        }
        if (parent instanceof JSLoopStatement && ((JSLoopStatement)parent).getCondition() == expression) {
            return false;
        }
        if (parent instanceof JSWithStatement && ((JSWithStatement)parent).getExpression() == expression) {
            return false;
        }
        if (parent instanceof JSImportStatement) {
            return false;
        }
        if (parent instanceof JSTypeDeclaration) {
            return false;
        }
        if (DialectDetector.dialectOfElement((PsiElement)expression) == DialectOptionHolder.OTHER) {
            return false;
        }
        if (expression instanceof JSClassExpression && parent instanceof ES6ExportDefaultAssignment && (attList = ((ES6ExportDefaultAssignment)parent).getAttributeList()) != null && attList.getDecorators().length > 0) {
            return false;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSStatement.class);
        if (statement == null) {
            return false;
        }
        return this.hasAcceptableStatementExecutionScope((PsiElement)statement);
    }

    protected boolean hasAcceptableStatementExecutionScope(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(3);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element2, (boolean)true, el -> {
            if (!(el instanceof JSExecutionScope)) {
                return false;
            }
            if (!(el instanceof JSEmbeddedContent)) {
                return true;
            }
            return ES6PsiUtil.isEmbeddedBlock(el);
        }) != null;
    }

    @Nullable
    private static JSExpression findExpression(@NotNull PsiElement element2, boolean hasSelection) {
        PsiElement parent;
        if (element2 == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(4);
        }
        if (PsiUtilCore.getElementType((PsiElement)element2) == JSTokenTypes.SEMICOLON) {
            element2 = element2.getPrevSibling();
        } else if (element2 instanceof PsiWhiteSpace) {
            if (element2.getText().contains("\n")) {
                return null;
            }
            if (!((element2 = element2.getPrevSibling()) instanceof JSExpressionStatement)) {
                return null;
            }
            element2 = element2.getLastChild();
        }
        JSArgumentList argumentList = (JSArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element2, JSArgumentList.class);
        if (argumentList != null && !JSIntroduceVariableIntention.isInNestedContext(element2, (PsiElement)argumentList)) {
            return null;
        }
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSCallExpression.class);
        if (callExpression != null && !JSIntroduceVariableIntention.isInNestedContext(element2, (PsiElement)callExpression) && (parent = callExpression.getParent()) instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == callExpression) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSReferenceExpression.class);
        if (referenceExpression != null) {
            if (JSResolveUtil.isExprInTypeContext(referenceExpression)) {
                return null;
            }
            PsiElement parent2 = referenceExpression.getParent();
            if (parent2 instanceof JSReferenceExpression && ((JSReferenceExpression)parent2).getQualifier() == callExpression) {
                return null;
            }
        }
        JSExpression expression = (JSExpression)PsiTreeUtil.getContextOfType((PsiElement)element2, JSExpression.class, (boolean)false, (Class[])new Class[]{JSFile.class});
        JSExpression foundExpression = null;
        while (expression != null) {
            JSExpression newExpression;
            if (expression.getParent() instanceof JSQualifiedNamedElement) {
                return null;
            }
            if (JSInheritedLanguagesHelper.isBadExpressionStatement((PsiElement)expression)) {
                if (hasSelection) {
                    return expression;
                }
                foundExpression = expression;
            }
            if ((newExpression = (JSExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, (Class[])new Class[]{JSExpression.class})) instanceof JSFunctionExpression || newExpression != null && JSIntroduceVariableIntention.isInNestedContext((PsiElement)expression, (PsiElement)newExpression)) break;
            expression = newExpression;
        }
        if (foundExpression != null) {
            return foundExpression;
        }
        JSExpressionStatement statement = (JSExpressionStatement)PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{JSExpressionStatement.class});
        if (statement == null) {
            return null;
        }
        JSExpression statementExpression = statement.getExpression();
        if (statementExpression != null && JSInheritedLanguagesHelper.isBadExpressionStatement((PsiElement)statementExpression)) {
            return statementExpression;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        JSExpression expression;
        SelectionModel selectionModel;
        if (project == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(7);
        }
        if (!this.isGenerallyApplicable(selectionModel = editor.getSelectionModel(), expression = JSIntroduceVariableIntention.findExpression(element2, selectionModel.hasSelection()))) {
            return false;
        }
        List psiFiles = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)expression);
        if (psiFiles != null && !psiFiles.isEmpty()) {
            TextRange range = expression.getTextRange();
            int offset = editor.getCaretModel().getOffset();
            return offset == range.getStartOffset() || offset == range.getEndOffset();
        }
        return true;
    }

    @Contract(value="_, null -> false")
    protected boolean isGenerallyApplicable(SelectionModel selectionModel, JSExpression expression) {
        ASTNode[] children;
        int selectionEnd;
        int selectionStart;
        if (!this.isApplicableExpression(expression)) {
            return false;
        }
        TextRange range = expression.getTextRange();
        if (expression instanceof JSLiteralExpression && selectionModel.hasSelection() && selectionModel.getSelectionStart() > range.getStartOffset() && selectionModel.getSelectionEnd() < range.getEndOffset()) {
            return false;
        }
        if (expression instanceof TypeScriptFunction && TypeScriptPsiUtil.getAllOverloadsWithImplementation((TypeScriptFunction)((Object)expression)).size() > 1) {
            return false;
        }
        if ((expression instanceof JSFunctionExpression || expression instanceof JSClassExpression) && (selectionStart = selectionModel.getSelectionStart()) == (selectionEnd = selectionModel.getSelectionEnd()) && expression.getTextRange().contains(selectionStart) && (children = expression.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.CLASS_KEYWORD}))).length == 1 && !children[0].getTextRange().contains(selectionStart)) {
            return false;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSVariable) {
            return false;
        }
        JSType type2 = JSResolveUtil.getExpressionJSType(expression);
        return !(type2 instanceof JSVoidType);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            JSIntroduceVariableIntention.$$$reportNull$$$0(10);
        }
        JSExpression expression = JSIntroduceVariableIntention.findExpression(element2, editor.getSelectionModel().hasSelection());
        assert (expression != null);
        TextRange range = expression.getTextRange();
        ApplicationManager.getApplication().runWriteAction(() -> editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset()));
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        this.createIntroduceVariableHandler().invoke(project, editor, element2.getContainingFile(), dataContext);
    }

    protected JSBaseIntroduceHandler<? extends PsiElement, BaseIntroduceSettings, JSIntroduceVariableDialog> createIntroduceVariableHandler() {
        return new JSIntroduceVariableHandler();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSIntroduceVariableIntention";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSIntroduceVariableIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInNestedContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasAcceptableStatementExecutionScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

