/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.surroundWith.JSWithIfSurrounder;
import com.intellij.lang.javascript.template.postfix.JSTemplateExpressionCondition;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.utils.BoolUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPostfixTemplateUtils {
    @NotNull
    private static final Map<String, JSTemplateExpressionCondition.Factory> ourConditionFactories = Map.of("nonVoid", () -> new JSTemplateExpressionCondition.NonVoidCondition(), "arrayType", () -> new JSTemplateExpressionCondition.ArrayCondition());
    public static final Condition<PsiElement> DEFAULT_FILTER = new Condition<PsiElement>(){
        private final Class[] FILTER_TYPES = new Class[]{JSThisExpression.class, TypeScriptImportStatement.class, ES6ImportDeclaration.class, TypeScriptEntityName.class, TypeScriptType.class, JSReferenceListMember.class, JSReferenceList.class, ES6ExportDeclaration.class};
        private final Class[] STOP_TYPES = (Class[])ArrayUtil.append((Object[])this.FILTER_TYPES, JSStatement.class);

        public boolean value(PsiElement element2) {
            if (!JSPostfixTemplateUtils.isAcceptableDialect(element2)) {
                return false;
            }
            if (element2.getParent() instanceof JSProperty) {
                return false;
            }
            PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])this.STOP_TYPES);
            if (parent == null) {
                return true;
            }
            for (Class aClass : this.FILTER_TYPES) {
                if (!aClass.isInstance(parent)) continue;
                return false;
            }
            return true;
        }
    };
    static final Condition<PsiElement> ARRAY_ITERABLE_ANY_TYPE = element2 -> {
        if (!DEFAULT_FILTER.value(element2)) {
            return false;
        }
        if (element2 instanceof JSReferenceExpression || element2 instanceof JSArrayLiteralExpression || element2 instanceof JSCallExpression || element2 instanceof JSParenthesizedExpression) {
            JSType valuableType = JSPostfixTemplateUtils.computeType((JSExpression)element2);
            return valuableType == null || valuableType instanceof JSAnyType || JSTypeUtils.isIterableCollectionType(valuableType);
        }
        return false;
    };
    public static final Condition<PsiElement> NON_LITERAL_CONDITION = element2 -> {
        boolean isIncorrect = element2 instanceof JSLiteralExpression || element2 instanceof JSSuperExpression || element2 instanceof TypeScriptEntityName;
        return !isIncorrect;
    };
    public static final Condition<PsiElement> DEFAULT_AND_NON_LITERAL_CONDITION = Conditions.and(DEFAULT_FILTER, NON_LITERAL_CONDITION);
    public static final Condition<PsiElement> TYPESCRIPT_CONDITION = el -> DialectDetector.isTypeScript(el);
    public static final Condition<PsiElement> THIS_FILTER = el -> el instanceof JSThisExpression;
    @NotNull
    public static final PostfixTemplatePsiInfo JS_PSI_INFO = new PostfixTemplatePsiInfo(){

        @NotNull
        public PsiElement createExpression(@NotNull PsiElement context2, @NotNull String prefix, @NotNull String suffix) {
            if (context2 == null) {
                6.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                6.$$$reportNull$$$0(1);
            }
            if (suffix == null) {
                6.$$$reportNull$$$0(2);
            }
            PsiElement psiElement = JSPostfixTemplateUtils.createExpression(context2, prefix, suffix);
            if (psiElement == null) {
                6.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @NotNull
        public PsiElement getNegatedExpression(@NotNull PsiElement element2) {
            if (element2 == null) {
                6.$$$reportNull$$$0(4);
            }
            String negatedExpressionText = BoolUtils.getNegatedExpressionText((JSExpression)element2);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)element2.getProject());
            PsiElement psiElement = codeStyleManager.reformat((PsiElement)JSPsiElementFactory.createJSExpression(negatedExpressionText, element2));
            if (psiElement == null) {
                6.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$6";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$6";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNegatedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createExpression";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getNegatedExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5 -> new IllegalStateException(string);
            };
        }
    };

    public static String endTemplate(PsiElement element2) {
        return (JSPostfixTemplateUtils.isArrowFunctionExpression(element2) ? "" : JSCodeStyleSettings.getSemicolon(element2)) + "$END$";
    }

    public static PostfixTemplateExpressionSelector selectorTopmost() {
        return JSPostfixTemplateUtils.selectorTopmost(DEFAULT_FILTER);
    }

    public static PostfixTemplateExpressionSelector selectNotLiteralExpressionsWithCurrentOffset() {
        return JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset(DEFAULT_AND_NON_LITERAL_CONDITION);
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset() {
        return JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset(DEFAULT_FILTER);
    }

    public static PostfixTemplateExpressionSelector selectorWithFeature(final @NotNull PostfixTemplateExpressionSelector parent, final @NotNull JSLanguageFeature feature, final @Nullable Condition<? super PsiElement> placeAdditionalCondition) {
        if (parent == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(0);
        }
        if (feature == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(1);
        }
        return new PostfixTemplateExpressionSelector(){

            public boolean hasExpression(@NotNull PsiElement context2, @NotNull Document copyDocument, int newOffset) {
                VirtualFile virtualFile;
                JSLanguageDialect dialect;
                PsiFile file;
                DialectOptionHolder holder;
                if (context2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (copyDocument == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((holder = DialectDetector.dialectOfElement(context2)) == null && (file = context2.getContainingFile()) != null && (dialect = DialectDetector.getLanguageDialect(virtualFile = file.getViewProvider().getVirtualFile(), context2.getProject())) != null) {
                    holder = dialect.getOptionHolder();
                }
                return holder != null && holder.hasFeature(feature) && (placeAdditionalCondition == null || placeAdditionalCondition.value((Object)context2)) && parent.hasExpression(context2, copyDocument, newOffset);
            }

            @NotNull
            public List<PsiElement> getExpressions(@NotNull PsiElement context2, @NotNull Document document, int offset) {
                if (context2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(3);
                }
                List list = parent.getExpressions(context2, document, offset);
                if (list == null) {
                    2.$$$reportNull$$$0(4);
                }
                return list;
            }

            @NotNull
            public Function<PsiElement, String> getRenderer() {
                Function function = parent.getRenderer();
                if (function == null) {
                    2.$$$reportNull$$$0(5);
                }
                return function;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "copyDocument";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExpressions";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "hasExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getExpressions";
                        break;
                    }
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4, 5 -> new IllegalStateException(string);
                };
            }
        };
    }

    public static PostfixTemplateExpressionSelector selectorTopmost(Condition<PsiElement> expressionsFilter) {
        return new PostfixTemplateExpressionSelectorBase(expressionsFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context2, @NotNull Document document, int offset) {
                if (context2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!JSPostfixTemplateUtils.isAcceptableDialect(context2)) {
                    return ContainerUtil.emptyList();
                }
                JSExpressionStatement exprStatement = (JSExpressionStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2, (Class[])new Class[]{JSExpressionStatement.class});
                JSExpression statement = exprStatement != null ? (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)exprStatement, JSExpression.class) : null;
                return ContainerUtil.createMaybeSingletonList((Object)statement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$3";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static PostfixTemplateExpressionSelector selectorTopmostExpression(Condition<PsiElement> expressionsFilter) {
        return new PostfixTemplateExpressionSelectorBase(expressionsFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context2, @NotNull Document document, int offset) {
                JSExpression expression;
                if (context2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!JSPostfixTemplateUtils.isAcceptableDialect(context2)) {
                    return ContainerUtil.emptyList();
                }
                PsiElement candidate = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context2, (Class[])new Class[]{JSExpressionStatement.class, JSFunction.class});
                if (candidate instanceof JSExpressionStatement) {
                    JSExpression nestedExpression = (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)candidate, JSExpression.class);
                    return ContainerUtil.createMaybeSingletonList((Object)nestedExpression);
                }
                if (candidate instanceof JSFunction && ((JSFunction)candidate).isArrowFunction() && PsiTreeUtil.isAncestor((PsiElement)(expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)candidate)), (PsiElement)context2, (boolean)false)) {
                    return ContainerUtil.createMaybeSingletonList((Object)expression);
                }
                return ContainerUtil.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$4";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isAcceptableDialect(@NotNull PsiElement context2) {
        DialectOptionHolder holder;
        if (context2 == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(2);
        }
        return (holder = DialectDetector.dialectOfElement(context2)) != null && holder.hasJSSyntax() && holder != DialectOptionHolder.OTHER;
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset(Condition<PsiElement> additionalExpressionsFilter) {
        return new PostfixTemplateExpressionSelectorBase(additionalExpressionsFilter){

            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context2, @NotNull Document document, int newOffset) {
                if (context2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    5.$$$reportNull$$$0(1);
                }
                List<Pair<JSExpression, TextRange>> expressionsInRange = JSIntroducedExpressionUtil.findExpressionsInRange(context2.getContainingFile(), newOffset, newOffset);
                ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
                if (expressionsInRange == null) {
                    return result2;
                }
                for (Pair<JSExpression, TextRange> pair : expressionsInRange) {
                    JSExpression expression = (JSExpression)pair.getFirst();
                    if (expression instanceof JSCallExpression && JSResolveUtil.getExpressionJSType(expression) instanceof JSVoidType) continue;
                    result2.add((PsiElement)expression);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils$5";
                objectArray[2] = "getNonFilteredExpressions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static Surrounder createIfSurrounder() {
        return new JSWithIfSurrounder(){

            @Override
            protected boolean willWrapExpression() {
                return false;
            }
        };
    }

    @NotNull
    public static PsiElement createExpression(@NotNull PsiElement context2, @NotNull String prefix, @NotNull String suffix) {
        if (context2 == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(5);
        }
        ASTNode node = JSChangeUtil.createExpressionWithContext(prefix + context2.getText() + suffix, context2);
        assert (node != null);
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public static PostfixTemplateExpressionCondition<JSExpression> createCondition(@NotNull Element element2) {
        if (element2 == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(7);
        }
        String id = element2.getAttributeValue("id");
        JSTemplateExpressionCondition.Factory factory = ourConditionFactories.get(id);
        JSTemplateExpressionCondition jSTemplateExpressionCondition = factory.create();
        if (jSTemplateExpressionCondition == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(8);
        }
        return jSTemplateExpressionCondition;
    }

    static JSType computeType(JSExpression element2) {
        JSType type2 = JSResolveUtil.getExpressionJSType((JSExpression)CompletionUtil.getOriginalOrSelf((PsiElement)element2));
        return JSTypeUtils.getValuableType(type2, (PsiElement)element2);
    }

    public static boolean isArrowFunctionExpression(@NotNull PsiElement expr) {
        PsiElement parent;
        if (expr == null) {
            JSPostfixTemplateUtils.$$$reportNull$$$0(9);
        }
        return (parent = expr.getParent()) instanceof JSFunction && JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)parent) == expr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/template/postfix/JSPostfixTemplateUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectorWithFeature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableDialect";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isArrowFunctionExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

