/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class SillyAssignmentJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("silly.assignment.error.string", new Object[0]);
        if (string == null) {
            SillyAssignmentJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/assignment/SillyAssignmentJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            String lhsQualifierText;
            JSReferenceExpression rhsReference;
            JSExpression lhs;
            block13: {
                block12: {
                    JSExpression rhs;
                    if (assignment == null) {
                        Visitor.$$$reportNull$$$0(0);
                    }
                    super.visitJSAssignmentExpression(assignment);
                    IElementType sign = assignment.getOperationSign();
                    if (!JSTokenTypes.EQ.equals(sign)) {
                        return;
                    }
                    lhs = assignment.getLOperand();
                    if (lhs instanceof JSDefinitionExpression) {
                        lhs = ((JSDefinitionExpression)lhs).getExpression();
                    }
                    if ((rhs = assignment.getROperand()) == null || lhs == null) {
                        return;
                    }
                    if (!(rhs instanceof JSReferenceExpression)) break block12;
                    rhsReference = (JSReferenceExpression)rhs;
                    if (lhs instanceof JSReferenceExpression) break block13;
                }
                return;
            }
            JSReferenceExpression lhsReference = (JSReferenceExpression)lhs;
            JSExpression rhsQualifier = rhsReference.getQualifier();
            JSExpression lhsQualifier = lhsReference.getQualifier();
            if (!(rhsQualifier == null && lhsQualifier == null || EquivalenceChecker.expressionsAreEquivalent(rhsQualifier, lhsQualifier))) {
                return;
            }
            String rhsName = rhsReference.getReferenceName();
            String lhsName = lhsReference.getReferenceName();
            if (rhsName == null || lhsName == null) {
                return;
            }
            if (!rhsName.equals(lhsName)) {
                return;
            }
            PsiElement rhsReferent = rhsReference.resolve();
            PsiElement lhsReferent = lhsReference.resolve();
            if (rhsReferent != null && lhsReferent != null && !rhsReferent.equals(lhsReferent)) {
                return;
            }
            if (lhsName.equals("location") && lhsQualifier instanceof JSReferenceExpression && ((JSReferenceExpression)lhsQualifier).getQualifier() == null && ("document".equals(lhsQualifierText = ((JSReferenceExpression)lhsQualifier).getReferenceName()) || "window".equals(lhsQualifierText))) {
                return;
            }
            this.registerError((PsiElement)assignment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/sixrr/inspectjs/assignment/SillyAssignmentJSInspection$Visitor", "visitJSAssignmentExpression"));
        }
    }
}

