/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.rt.impl;

import com.intellij.execution.rmi.RemoteObject;
import com.intellij.grid.scripting.rt.RemoteLoaderScript;
import com.intellij.grid.scripting.rt.RemoteLoaderSession;
import com.intellij.grid.scripting.rt.bindings.Loader;
import com.intellij.grid.scripting.rt.impl.DatabaseExtensionScriptRunnerRaw;
import com.intellij.grid.scripting.rt.impl.RemoteLoaderSessionImpl;
import com.intellij.grid.scripting.rt.util.DatabaseExtensionScriptRunnerBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.script.ScriptEngine;
import org.jetbrains.annotations.NotNull;

public class RemoteLoaderScriptImpl
extends RemoteObject
implements RemoteLoaderScript {
    private Supplier<MyLoader> myLoader;
    private final List<DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer> myProgressConsumers;

    public RemoteLoaderScriptImpl(@NotNull ScriptEngine engine, @NotNull String path) {
        if (engine == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(1);
        }
        this.myProgressConsumers = new CopyOnWriteArrayList<DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer>();
        this.myLoader = () -> this.createLoaderLazy(engine, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private MyLoader createLoaderLazy(@NotNull ScriptEngine engine, @NotNull String path) {
        if (engine == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(3);
        }
        RemoteLoaderScriptImpl remoteLoaderScriptImpl = this;
        // MONITORENTER : remoteLoaderScriptImpl
        MyLoader loader = this.createLoader(engine, path);
        this.myLoader = () -> loader;
        MyLoader myLoader = loader;
        // MONITOREXIT : remoteLoaderScriptImpl
        if (myLoader != null) return myLoader;
        RemoteLoaderScriptImpl.$$$reportNull$$$0(4);
        return myLoader;
    }

    private void multicastProgress(String message) {
        for (DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer consumer : this.myProgressConsumers) {
            consumer.message(message);
        }
    }

    @NotNull
    private MyLoader createLoader(@NotNull ScriptEngine engine, @NotNull String path) {
        MyLoader myLoader;
        if (engine == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(5);
        }
        if (path == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(6);
        }
        try {
            MyLoader loader = new MyLoader();
            DatabaseExtensionScriptRunnerRaw runner = new DatabaseExtensionScriptRunnerRaw(engine, this::multicastProgress);
            ((DatabaseExtensionScriptRunnerBase)runner).bind("LOADER", loader);
            String script = FileUtilRt.loadFile((File)new File(path), (String)StandardCharsets.UTF_8.name());
            ((DatabaseExtensionScriptRunnerBase)runner).eval(script);
            myLoader = loader;
        }
        catch (Throwable th) {
            Throwable we = this.wrapException(th);
            ExceptionUtilRt.rethrowUnchecked((Throwable)we);
            throw new AssertionError((Object)we);
        }
        if (myLoader == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(7);
        }
        return myLoader;
    }

    @Override
    @NotNull
    public RemoteLoaderSession startLoading(@NotNull Map<String, Object> context) throws RemoteException {
        RemoteLoaderSession remoteLoaderSession;
        if (context == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(8);
        }
        try {
            remoteLoaderSession = (RemoteLoaderSession)this.export(new RemoteLoaderSessionImpl(context){

                @Override
                protected void load(final Loader.DataConsumer consumer) throws Exception {
                    RemoteLoaderScriptImpl.this.doLoad(new Loader.LoadContext(){

                        @Override
                        @NotNull
                        public Map<String, Object> getParameters() {
                            Map map = myContext;
                            if (map == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return map;
                        }

                        @Override
                        @NotNull
                        public Loader.DataConsumer getDataConsumer() {
                            Loader.DataConsumer dataConsumer = consumer;
                            if (dataConsumer == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return dataConsumer;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = "com/intellij/grid/scripting/rt/impl/RemoteLoaderScriptImpl$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getParameters";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getDataConsumer";
                                    break;
                                }
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                        }
                    }, this.myProgressConsumer);
                }
            });
        }
        catch (Throwable th) {
            Throwable we = this.wrapException(th);
            ExceptionUtilRt.rethrowUnchecked((Throwable)we);
            throw new AssertionError((Object)we);
        }
        if (remoteLoaderSession == null) {
            RemoteLoaderScriptImpl.$$$reportNull$$$0(9);
        }
        return remoteLoaderSession;
    }

    private void doLoad(Loader.LoadContext ctx, DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer consumer) throws Exception {
        this.myProgressConsumers.add(consumer);
        try {
            this.myLoader.get().myLoad.consume((Object)ctx);
        }
        finally {
            this.myProgressConsumers.remove(consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grid/scripting/rt/impl/RemoteLoaderScriptImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grid/scripting/rt/impl/RemoteLoaderScriptImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoaderLazy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startLoading";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLoaderLazy";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLoader
    implements Loader,
    DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer {
        private ThrowableConsumer<Loader.LoadContext, Exception> myLoad;

        private MyLoader() {
        }

        @Override
        public void load(@NotNull ThrowableConsumer<Loader.LoadContext, Exception> load) {
            if (load == null) {
                MyLoader.$$$reportNull$$$0(0);
            }
            this.myLoad = load;
        }

        @Override
        public void message(String message) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "load", "com/intellij/grid/scripting/rt/impl/RemoteLoaderScriptImpl$MyLoader", "load"));
        }
    }
}

