/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelTracker;
import com.intellij.database.schemaEditor.model.DbModelApplyHelper;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DbModelResetHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class DbEditorModelSynchronizer
implements Disposable {
    private static final Key<DbEditorModelSynchronizer> KEY = Key.create((String)"DbEditorModelSynchronizer");
    private final DbEditorModelController myModelController;
    private final DbEditorModelTracker<DbModelRef<?, ?>> myModelTracker;

    public DbEditorModelSynchronizer(@NotNull DbEditorModelController editorModelController, @NotNull DbEditorModelController modelController) {
        if (editorModelController == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(0);
        }
        if (modelController == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(1);
        }
        KEY.set(editorModelController.getDataHolder(), (Object)this);
        this.myModelController = modelController;
        this.myModelTracker = new DbEditorModelTracker.ByRef(modelController);
        Disposer.register((Disposable)this, this.myModelTracker);
    }

    public void addModifications(@NotNull Iterable<DbModelRef<?, ?>> refs) {
        if (refs == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(2);
        }
        this.myModelTracker.addModifications(refs);
    }

    @Deprecated
    public static DbEditorModelController getBackModelController(DbEditorModelController controller) {
        DbEditorModelSynchronizer sync = (DbEditorModelSynchronizer)KEY.get(controller.getDataHolder());
        return sync == null ? controller : sync.getModelController();
    }

    public void applyToImpl(@NotNull ElementOwner owner, boolean incremental, DbModelTransactionManager.DbModelTransaction transaction) {
        if (owner == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(3);
        }
        DbModelApplyHelper.applyRefs(this.myModelController, owner, this.getModifiedBackModels(incremental), transaction);
    }

    public boolean hasModifications() {
        return this.myModelTracker.getModified().iterator().hasNext();
    }

    @NotNull
    public @Unmodifiable List<DbModelRef<?, ?>> finish(boolean incremental) {
        ArrayList<DbModelRef<?, ?>> modifiedBackModels = this.getModifiedBackModels(incremental);
        this.myModelTracker.clearModified();
        ArrayList<DbModelRef<?, ?>> arrayList = modifiedBackModels;
        if (arrayList == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private @Unmodifiable ArrayList<DbModelRef<?, ?>> getModifiedBackModels(boolean incremental) {
        ArrayList arrayList = ContainerUtil.newArrayList(incremental ? this.myModelTracker.getModified() : this.myModelController.getAllModelsRefs());
        if (arrayList == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void resetFrom(@NotNull ElementOwner owner) {
        if (owner == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(6);
        }
        DbModelResetHelper.resetAll(this.myModelController, owner);
    }

    public void dispose() {
    }

    @NotNull
    public DbEditorModelController getModelController() {
        DbEditorModelController dbEditorModelController = this.myModelController;
        if (dbEditorModelController == null) {
            DbEditorModelSynchronizer.$$$reportNull$$$0(7);
        }
        return dbEditorModelController;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorModelController";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelController";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbEditorModelSynchronizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbEditorModelSynchronizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedBackModels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModifications";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyToImpl";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

