/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientRequest;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/RedirectionChecker;", "", "isEnabled", "", "limit", "", "<init>", "(ZI)V", "current", "Ljava/util/concurrent/atomic/AtomicInteger;", "redirectAvailable", "Key", "intellij.httpClient.executor"})
public final class RedirectionChecker {
    @NotNull
    public static final Key Key = new Key(null);
    private final boolean isEnabled;
    private final int limit;
    @NotNull
    private final AtomicInteger current;
    public static final int REDIRECTION_LIMIT = 50;
    @NotNull
    private static final Set<String> laxRedirectionMethods;
    @NotNull
    private static final Set<Integer> redirectionStatuses;
    public static final int REDIRECTION_STATUS_WITH_SPECIAL_HANDLING = 302;

    private RedirectionChecker(boolean isEnabled, int limit) {
        this.isEnabled = isEnabled;
        this.limit = limit;
        this.current = new AtomicInteger(0);
    }

    /* synthetic */ RedirectionChecker(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(bl, n);
    }

    public final boolean redirectAvailable() {
        return this.isEnabled && this.current.incrementAndGet() <= this.limit;
    }

    public /* synthetic */ RedirectionChecker(boolean isEnabled, int limit, DefaultConstructorMarker $constructor_marker) {
        this(isEnabled, limit);
    }

    static {
        Object[] objectArray = new String[]{"GET", "POST", "HEAD", "DELETE"};
        laxRedirectionMethods = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{301, 302, 303, 307, 308};
        redirectionStatuses = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/RedirectionChecker$Key;", "", "<init>", "()V", "fromRequestAndConfig", "Lcom/intellij/httpClient/execution/impl/engineV2/RedirectionChecker;", "request", "Lcom/intellij/httpClient/execution/RestClientRequest;", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "limit", "", "REDIRECTION_LIMIT", "laxRedirectionMethods", "", "", "getLaxRedirectionMethods", "()Ljava/util/Set;", "redirectionStatuses", "getRedirectionStatuses", "REDIRECTION_STATUS_WITH_SPECIAL_HANDLING", "intellij.httpClient.executor"})
    public static final class Key {
        private Key() {
        }

        @NotNull
        public final RedirectionChecker fromRequestAndConfig(@NotNull RestClientRequest request, @NotNull HttpRequestConfig config, int limit) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            boolean isEnabled = config.isFollowRedirects() && this.getLaxRedirectionMethods().contains(request.httpMethod);
            return new RedirectionChecker(isEnabled, limit, null);
        }

        public static /* synthetic */ RedirectionChecker fromRequestAndConfig$default(Key key, RestClientRequest restClientRequest, HttpRequestConfig httpRequestConfig, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 50;
            }
            return key.fromRequestAndConfig(restClientRequest, httpRequestConfig, n);
        }

        @NotNull
        public final Set<String> getLaxRedirectionMethods() {
            return laxRedirectionMethods;
        }

        @NotNull
        public final Set<Integer> getRedirectionStatuses() {
            return redirectionStatuses;
        }

        public /* synthetic */ Key(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

