/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.docker;

import com.intellij.openapi.util.Pair;
import com.intellij.python.docker.PyDockerBundle;
import com.intellij.remote.RemoteSdkException;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import java.io.IOException;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.jetbrains.annotations.NotNull;

public final class DockerNetworkInterfaceGatewayProvider
implements PyRemoteSocketToLocalHostProvider {
    @NotNull
    private final String myNetworkInterfaceName;

    private DockerNetworkInterfaceGatewayProvider(@NotNull String name) {
        if (name == null) {
            DockerNetworkInterfaceGatewayProvider.$$$reportNull$$$0(0);
        }
        this.myNetworkInterfaceName = name;
    }

    public void close() throws IOException {
    }

    @NotNull
    public Pair<String, Integer> getRemoteSocket(int localPort) throws RemoteSdkException {
        Pair pair;
        try {
            NetworkInterface docker0 = NetworkInterface.getByName(this.myNetworkInterfaceName);
            if (docker0 == null) {
                throw new RemoteSdkException(PyDockerBundle.message("could.not.find.network.interface", this.myNetworkInterfaceName));
            }
            String hostAddress = this.getInterfaceHostAddress(docker0.getInterfaceAddresses());
            pair = Pair.create((Object)hostAddress, (Object)localPort);
        }
        catch (SocketException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (pair == null) {
            DockerNetworkInterfaceGatewayProvider.$$$reportNull$$$0(1);
        }
        return pair;
    }

    @NotNull
    private String getInterfaceHostAddress(@NotNull Iterable<InterfaceAddress> iterable) throws RemoteSdkException {
        if (iterable == null) {
            DockerNetworkInterfaceGatewayProvider.$$$reportNull$$$0(2);
        }
        String resultAddress = null;
        for (InterfaceAddress address : iterable) {
            if (address.getBroadcast() != null) {
                String string = address.getAddress().getHostAddress();
                if (string == null) {
                    DockerNetworkInterfaceGatewayProvider.$$$reportNull$$$0(3);
                }
                return string;
            }
            resultAddress = address.getAddress().getHostAddress();
        }
        if (resultAddress == null) {
            throw new RemoteSdkException(PyDockerBundle.message("no.interface.addresses.for.network.interface", this.myNetworkInterfaceName));
        }
        String string = resultAddress;
        if (string == null) {
            DockerNetworkInterfaceGatewayProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static DockerNetworkInterfaceGatewayProvider newDockerNetworkInterfaceProvider() {
        return new DockerNetworkInterfaceGatewayProvider("docker0");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/docker/DockerNetworkInterfaceGatewayProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/docker/DockerNetworkInterfaceGatewayProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSocket";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceHostAddress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceHostAddress";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

