/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.execution.rmi.ssl.SslTrustStore;
import com.intellij.openapi.util.text.StringUtilRt;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrinoJdbcHelper
extends JdbcHelperImpl {
    public TrinoJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("TRINO", version, connection, jdbcClassLoader);
    }

    public TrinoJdbcHelper() {
        this(null, null, null);
    }

    private TrinoJdbcHelper(@NotNull TrinoJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(2);
        }
        return TrinoJdbcHelper.classNameContains(driver, "io.trino.jdbc.");
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Trino")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return TrinoJdbcHelper.create(delegate, productVer, jdbcClassLoader);
    }

    @NotNull
    private static TrinoJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcClassLoader) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new TrinoJdbcHelper(TrinoJdbcHelper.extractVersion(productVer), delegate, jdbcClassLoader);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(4);
        }
        if (sslMode == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(5);
        }
        TrinoJdbcHelper.setIfEmpty(properties, "SSL", "true");
        TrinoJdbcHelper.setIfEmpty(properties, "SSLVerification", sslMode == JdbcSettings.SslMode.REQUIRE ? "NONE" : (sslMode == JdbcSettings.SslMode.VERIFY_CA ? "CA" : "FULL"));
        if (sslMode != JdbcSettings.SslMode.REQUIRE) {
            TrinoJdbcHelper.setIfEmpty(properties, "SSLTrustStoreType", SslTrustStore.getType());
            TrinoJdbcHelper.setIfEmpty(properties, "SSLTrustStorePath", StringUtilRt.notNullize((String)System.getProperty("javax.net.ssl.trustStore")));
        }
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return TrinoJdbcHelper.extractVersion(version);
    }

    @Nullable
    private static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new TrinoJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.NONE;
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        if (typeName != null && typeName.startsWith("timestamp with time zone")) {
            return OFFSET_TIMESTAMP_GETTER;
        }
        return super.getTemporalGetter(typeName, type);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            TrinoJdbcHelper.$$$reportNull$$$0(6);
        }
        return new TrinoJdbcHelper(this, jdbcClassLoader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/TrinoJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

