/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.desktop;

import com.intellij.desktop.DesktopActionsHandler;
import com.intellij.desktop.DesktopActionsPeer;
import com.intellij.desktop.DesktopActionsToolkit;
import com.intellij.desktop.DummyToolkit;
import java.awt.Toolkit;

public class DesktopActionsUtils {
    public static void setHandler(DesktopActionsHandler handler) {
        DesktopActionsPeer.setHandler(handler);
    }

    public static boolean setDefaultToolkit() {
        String current = System.getProperty("awt.toolkit");
        if (current == null) {
            return false;
        }
        Toolkit toolkit = DesktopActionsUtils.getDefaultToolkit();
        if (toolkit != null && toolkit.getClass().getName().equals(current)) {
            System.out.println("Toolkit is already set to " + current);
            return false;
        }
        try {
            DummyToolkit.setToolkit((Toolkit)Class.forName(current).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed instantiate toolkit " + current, e);
        }
        return true;
    }

    private static Toolkit getDefaultToolkit() {
        try {
            return Toolkit.getDefaultToolkit();
        }
        catch (Throwable th) {
            System.err.println("Failed to check current toolkit " + th.getMessage());
            return null;
        }
    }

    public static String getActionsToolkitClass() {
        return DesktopActionsToolkit.class.getName();
    }
}

