/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.xdebugger.XDebuggerManager;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.FileResponses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapDetectorFileHandler;", "Lorg/jetbrains/builtInWebServer/WebServerFileHandler;", "<init>", "()V", "process", "", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalPath", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "channel", "Lio/netty/channel/Channel;", "projectNameIfNotCustomHost", "", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nSourceMapDetectorFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapDetectorFileHandler.kt\ncom/intellij/javascript/debugger/sourcemap/SourceMapDetectorFileHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,77:1\n61#2,5:78\n127#3:83\n*S KotlinDebug\n*F\n+ 1 SourceMapDetectorFileHandler.kt\ncom/intellij/javascript/debugger/sourcemap/SourceMapDetectorFileHandler\n*L\n53#1:78,5\n73#1:83\n*E\n"})
final class SourceMapDetectorFileHandler
extends WebServerFileHandler {
    /*
     * WARNING - void declaration
     */
    public boolean process(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalPath, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull Channel channel, @Nullable String projectNameIfNotCustomHost, @NotNull HttpHeaders extraHeaders) {
        void $this$processedRun$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkNotNullParameter((Object)canonicalPath, (String)"canonicalPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)extraHeaders, (String)"extraHeaders");
        Path file = pathInfo.getIoFile();
        if (file == null || !StringsKt.endsWith((String)((Object)file.getFileName()).toString(), (String)".js", (boolean)true)) {
            return false;
        }
        List list = XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDebugProcesses(...)");
        List debugProcesses = list;
        if (debugProcesses.isEmpty()) {
            return false;
        }
        String string = SourceMapLoaderKt.getSourceMapUrl(file);
        if (string == null) {
            return false;
        }
        String sourceMapUrl = string;
        String string2 = NettyKt.getHost((HttpRequest)((HttpRequest)request));
        if (string2 == null) {
            return false;
        }
        String host = string2;
        Url scriptUrl = Urls.newUrl((String)NettyKt.getUriScheme((Channel)channel), (String)host, (String)this.getRequestPath(canonicalPath, projectNameIfNotCustomHost));
        Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, scriptUrl);
        if (!JsFileUtil.isOnBuiltInWebServer(parsedUrl)) {
            return false;
        }
        String string3 = parsedUrl.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String path = string3;
        if (projectNameIfNotCustomHost == null) {
            String string4 = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            path = string4;
        } else if (path.length() > projectNameIfNotCustomHost.length() + 1 && StringsKt.startsWith$default((String)path, (String)projectNameIfNotCustomHost, (int)1, (boolean)false, (int)4, null) && path.charAt(projectNameIfNotCustomHost.length() + 1) == '/') {
            String string5 = path.substring(projectNameIfNotCustomHost.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            path = string5;
        } else {
            Logger $this$debug_u24default$iv = JavaScriptDebugProcessKt.getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("SourceMap " + parsedUrl + " doesn't belong to current project " + projectNameIfNotCustomHost, e$iv);
            }
            return false;
        }
        if ((object = WebServerPathToFileManager.getPathInfo$default((WebServerPathToFileManager)WebServerPathToFileManager.Companion.getInstance(project), (String)path, (boolean)false, null, (int)6, null)) == null || (object = object.getIoFile()) == null) {
            return false;
        }
        Object sourceMapFile = object;
        CharSequence sourceMapData = PathKt.readChars((Path)sourceMapFile);
        SmartList promises = new SmartList();
        for (JavaScriptDebugProcess debugProcess : debugProcesses) {
            SourceMap sourceMap;
            if (debugProcess.isFilesOnlyInLocalFileSystem() || debugProcess.getPreloadedSourceMaps().containsScript(scriptUrl) || debugProcess.decodeSourceMap(sourceMapData, scriptUrl, true) == null) continue;
            PreloadedSourceMapList.add$default(debugProcess.getPreloadedSourceMaps(), parsedUrl, sourceMap, scriptUrl, null, null, 24, null);
            Vm vm = debugProcess.getMainVm();
            Intrinsics.checkNotNull((Object)vm);
            debugProcess.sourceMapFound(vm, sourceMap, null, scriptUrl, (List)promises);
        }
        Promise bl = Promises.all((Collection)((Collection)promises));
        boolean $i$f$processedRun = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$processedRun$iv.onProcessed(new Consumer(request, channel, file, extraHeaders){
            final /* synthetic */ FullHttpRequest $request$inlined;
            final /* synthetic */ Channel $channel$inlined;
            final /* synthetic */ Path $file$inlined;
            final /* synthetic */ HttpHeaders $extraHeaders$inlined;
            {
                this.$request$inlined = fullHttpRequest;
                this.$channel$inlined = channel;
                this.$file$inlined = path;
                this.$extraHeaders$inlined = httpHeaders;
            }

            public final void accept(Object it) {
                boolean bl = false;
                FileResponses.INSTANCE.sendFile((HttpRequest)this.$request$inlined, this.$channel$inlined, this.$file$inlined, this.$extraHeaders$inlined);
            }
        }), (String)"onProcessed(...)");
        return true;
    }
}

