/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackCommandReporter;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.utils.ReporterCommandAsTelemetrySpan;
import com.jetbrains.performancePlugin.utils.ReporterWithTimer;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptRunner {
    private PlaybackCommandReporter myScriptRunnerReporter;

    public ScriptRunner setScriptRunnerReporter(@Nullable PlaybackCommandReporter scriptRunnerReporter) {
        this.myScriptRunnerReporter = scriptRunnerReporter;
        return this;
    }

    public void doRunScript(@NotNull Project project, @NotNull String text, @Nullable File workingDir) {
        if (project == null) {
            ScriptRunner.$$$reportNull$$$0(0);
        }
        if (text == null) {
            ScriptRunner.$$$reportNull$$$0(1);
        }
        final PlaybackRunnerExtended runner = new PlaybackRunnerExtended(text, new CommandLogger(), project);
        runner.setScriptDir(workingDir);
        runner.setCommandStartStopProcessor((PlaybackCommandReporter)(this.myScriptRunnerReporter != null ? this.myScriptRunnerReporter : (SystemProperties.getBooleanProperty((String)"performance.execute.script.reportEachCommandAsTelemetrySpan", (boolean)false) ? new ReporterCommandAsTelemetrySpan(new ReporterWithTimer()) : new ReporterWithTimer())));
        Task.Backgroundable task = new Task.Backgroundable(project, PerformanceTestingBundle.message("task.title.executing.performance.script", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                CountDownLatch countDownLatch = new CountDownLatch(1);
                runner.run().whenComplete((o, throwable) -> countDownLatch.countDown());
                ScheduledThreadPoolExecutor myExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Performance plugin script runner");
                myExecutor.scheduleWithFixedDelay(() -> {
                    if (indicator.isCanceled()) {
                        runner.stop();
                    }
                }, 0L, 100L, TimeUnit.MILLISECONDS);
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                myExecutor.shutdownNow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/utils/ScriptRunner$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/performancePlugin/utils/ScriptRunner";
        objectArray[2] = "doRunScript";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

