// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCancelIngestion = "CancelIngestion"

// CancelIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CancelIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelIngestion for more information on using the CancelIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelIngestionRequest method.
//    req, resp := client.CancelIngestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestionRequest(input *CancelIngestionInput) (req *request.Request, output *CancelIngestionOutput) {
	op := &request.Operation{
		Name:       opCancelIngestion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CancelIngestionInput{}
	}

	output = &CancelIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelIngestion API operation for Amazon QuickSight.
//
// Cancels an ongoing ingestion of data into SPICE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CancelIngestion for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion
func (c *QuickSight) CancelIngestion(input *CancelIngestionInput) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	return out, req.Send()
}

// CancelIngestionWithContext is the same as CancelIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CancelIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CancelIngestionWithContext(ctx aws.Context, input *CancelIngestionInput, opts ...request.Option) (*CancelIngestionOutput, error) {
	req, out := c.CancelIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountCustomization = "CreateAccountCustomization"

// CreateAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountCustomization for more information on using the CreateAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccountCustomizationRequest method.
//    req, resp := client.CreateAccountCustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization
func (c *QuickSight) CreateAccountCustomizationRequest(input *CreateAccountCustomizationInput) (req *request.Request, output *CreateAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opCreateAccountCustomization,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &CreateAccountCustomizationInput{}
	}

	output = &CreateAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountCustomization API operation for Amazon QuickSight.
//
// Creates Amazon QuickSight customizations the current Amazon Web Services
// Region. Currently, you can add a custom default theme by using the CreateAccountCustomization
// or UpdateAccountCustomization API operation. To further customize Amazon
// QuickSight by removing Amazon QuickSight sample assets and videos for all
// new users, see Customizing Amazon QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html)
// in the Amazon QuickSight User Guide.
//
// You can create customizations for your Amazon Web Services account or, if
// you specify a namespace, for a QuickSight namespace instead. Customizations
// that apply to a namespace always override customizations that apply to an
// Amazon Web Services account. To find out which customizations apply, use
// the DescribeAccountCustomization API operation.
//
// Before you use the CreateAccountCustomization API operation to add a theme
// as the namespace default, make sure that you first share the theme with the
// namespace. If you don't share it with the namespace, the theme isn't visible
// to your users even if you make it the default theme. To check if the theme
// is shared, view the current permissions by using the DescribeThemePermissions
// (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html)
// API operation. To share the theme, grant permissions by using the UpdateThemePermissions
// (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html)
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAccountCustomization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization
func (c *QuickSight) CreateAccountCustomization(input *CreateAccountCustomizationInput) (*CreateAccountCustomizationOutput, error) {
	req, out := c.CreateAccountCustomizationRequest(input)
	return out, req.Send()
}

// CreateAccountCustomizationWithContext is the same as CreateAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAccountCustomizationWithContext(ctx aws.Context, input *CreateAccountCustomizationInput, opts ...request.Option) (*CreateAccountCustomizationOutput, error) {
	req, out := c.CreateAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAnalysis = "CreateAnalysis"

// CreateAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the CreateAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAnalysis for more information on using the CreateAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAnalysisRequest method.
//    req, resp := client.CreateAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis
func (c *QuickSight) CreateAnalysisRequest(input *CreateAnalysisInput) (req *request.Request, output *CreateAnalysisOutput) {
	op := &request.Operation{
		Name:       opCreateAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &CreateAnalysisInput{}
	}

	output = &CreateAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAnalysis API operation for Amazon QuickSight.
//
// Creates an analysis in Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateAnalysis for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis
func (c *QuickSight) CreateAnalysis(input *CreateAnalysisInput) (*CreateAnalysisOutput, error) {
	req, out := c.CreateAnalysisRequest(input)
	return out, req.Send()
}

// CreateAnalysisWithContext is the same as CreateAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateAnalysisWithContext(ctx aws.Context, input *CreateAnalysisInput, opts ...request.Option) (*CreateAnalysisOutput, error) {
	req, out := c.CreateAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDashboard = "CreateDashboard"

// CreateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the CreateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDashboard for more information on using the CreateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDashboardRequest method.
//    req, resp := client.CreateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboardRequest(input *CreateDashboardInput) (req *request.Request, output *CreateDashboardOutput) {
	op := &request.Operation{
		Name:       opCreateDashboard,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &CreateDashboardInput{}
	}

	output = &CreateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDashboard API operation for Amazon QuickSight.
//
// Creates a dashboard from a template. To first create a template, see the
// CreateTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html)
// API operation.
//
// A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight
// reports, created from analyses. You can share Amazon QuickSight dashboards.
// With the right permissions, you can create scheduled email reports from them.
// If you have the correct permissions, you can create a dashboard from a template
// that exists in a different Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDashboard for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard
func (c *QuickSight) CreateDashboard(input *CreateDashboardInput) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	return out, req.Send()
}

// CreateDashboardWithContext is the same as CreateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDashboardWithContext(ctx aws.Context, input *CreateDashboardInput, opts ...request.Option) (*CreateDashboardOutput, error) {
	req, out := c.CreateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSet = "CreateDataSet"

// CreateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSet for more information on using the CreateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSetRequest method.
//    req, resp := client.CreateDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSetRequest(input *CreateDataSetInput) (req *request.Request, output *CreateDataSetOutput) {
	op := &request.Operation{
		Name:       opCreateDataSet,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
	}

	if input == nil {
		input = &CreateDataSetInput{}
	}

	output = &CreateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSet API operation for Amazon QuickSight.
//
// Creates a dataset. This operation doesn't support datasets that include uploaded
// files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSet for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet
func (c *QuickSight) CreateDataSet(input *CreateDataSetInput) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	return out, req.Send()
}

// CreateDataSetWithContext is the same as CreateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSetWithContext(ctx aws.Context, input *CreateDataSetInput, opts ...request.Option) (*CreateDataSetOutput, error) {
	req, out := c.CreateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataSourceRequest method.
//    req, resp := client.CreateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Amazon QuickSight.
//
// Creates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource
func (c *QuickSight) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolder = "CreateFolder"

// CreateFolderRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolder for more information on using the CreateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFolderRequest method.
//    req, resp := client.CreateFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder
func (c *QuickSight) CreateFolderRequest(input *CreateFolderInput) (req *request.Request, output *CreateFolderOutput) {
	op := &request.Operation{
		Name:       opCreateFolder,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &CreateFolderInput{}
	}

	output = &CreateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolder API operation for Amazon QuickSight.
//
// Creates an empty shared folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateFolder for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder
func (c *QuickSight) CreateFolder(input *CreateFolderInput) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	return out, req.Send()
}

// CreateFolderWithContext is the same as CreateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateFolderWithContext(ctx aws.Context, input *CreateFolderInput, opts ...request.Option) (*CreateFolderOutput, error) {
	req, out := c.CreateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFolderMembership = "CreateFolderMembership"

// CreateFolderMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateFolderMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFolderMembership for more information on using the CreateFolderMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFolderMembershipRequest method.
//    req, resp := client.CreateFolderMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership
func (c *QuickSight) CreateFolderMembershipRequest(input *CreateFolderMembershipInput) (req *request.Request, output *CreateFolderMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateFolderMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
	}

	if input == nil {
		input = &CreateFolderMembershipInput{}
	}

	output = &CreateFolderMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFolderMembership API operation for Amazon QuickSight.
//
// Adds an asset, such as a dashboard, analysis, or dataset into a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateFolderMembership for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership
func (c *QuickSight) CreateFolderMembership(input *CreateFolderMembershipInput) (*CreateFolderMembershipOutput, error) {
	req, out := c.CreateFolderMembershipRequest(input)
	return out, req.Send()
}

// CreateFolderMembershipWithContext is the same as CreateFolderMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFolderMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateFolderMembershipWithContext(ctx aws.Context, input *CreateFolderMembershipInput, opts ...request.Option) (*CreateFolderMembershipOutput, error) {
	req, out := c.CreateFolderMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight group.
//
// The permissions resource is arn:aws:quicksight:<your-region>:<relevant-aws-account-id>:group/default/<group-name> .
//
// The response is a group object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroup for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup
func (c *QuickSight) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupMembership = "CreateGroupMembership"

// CreateGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupMembership for more information on using the CreateGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupMembershipRequest method.
//    req, resp := client.CreateGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembershipRequest(input *CreateGroupMembershipInput) (req *request.Request, output *CreateGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateGroupMembership,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &CreateGroupMembershipInput{}
	}

	output = &CreateGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupMembership API operation for Amazon QuickSight.
//
// Adds an Amazon QuickSight user to an Amazon QuickSight group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateGroupMembership for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership
func (c *QuickSight) CreateGroupMembership(input *CreateGroupMembershipInput) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	return out, req.Send()
}

// CreateGroupMembershipWithContext is the same as CreateGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateGroupMembershipWithContext(ctx aws.Context, input *CreateGroupMembershipInput, opts ...request.Option) (*CreateGroupMembershipOutput, error) {
	req, out := c.CreateGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIAMPolicyAssignment = "CreateIAMPolicyAssignment"

// CreateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIAMPolicyAssignment for more information on using the CreateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIAMPolicyAssignmentRequest method.
//    req, resp := client.CreateIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignmentRequest(input *CreateIAMPolicyAssignmentInput) (req *request.Request, output *CreateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateIAMPolicyAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/",
	}

	if input == nil {
		input = &CreateIAMPolicyAssignmentInput{}
	}

	output = &CreateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Creates an assignment with one specified IAM policy, identified by its Amazon
// Resource Name (ARN). This policy assignment is attached to the specified
// groups or users of Amazon QuickSight. Assignment names are unique per Amazon
// Web Services account. To avoid overwriting rules in other namespaces, use
// assignment names that are unique.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConcurrentUpdatingException
//   A resource is already in a state that indicates an operation is happening
//   that must complete before a new update can be applied.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment
func (c *QuickSight) CreateIAMPolicyAssignment(input *CreateIAMPolicyAssignmentInput) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// CreateIAMPolicyAssignmentWithContext is the same as CreateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIAMPolicyAssignmentWithContext(ctx aws.Context, input *CreateIAMPolicyAssignmentInput, opts ...request.Option) (*CreateIAMPolicyAssignmentOutput, error) {
	req, out := c.CreateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIngestion = "CreateIngestion"

// CreateIngestionRequest generates a "aws/request.Request" representing the
// client's request for the CreateIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIngestion for more information on using the CreateIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIngestionRequest method.
//    req, resp := client.CreateIngestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestionRequest(input *CreateIngestionInput) (req *request.Request, output *CreateIngestionOutput) {
	op := &request.Operation{
		Name:       opCreateIngestion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &CreateIngestionInput{}
	}

	output = &CreateIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIngestion API operation for Amazon QuickSight.
//
// Creates and starts a new SPICE ingestion for a dataset. You can manually
// refresh datasets in an Enterprise edition account 32 times in a 24-hour period.
// You can manually refresh datasets in a Standard edition account 8 times in
// a 24-hour period. Each 24-hour period is measured starting 24 hours before
// the current date and time.
//
// Any ingestions operating on tagged datasets inherit the same tags automatically
// for use in access control. For an example, see How do I create an IAM policy
// to control access to Amazon EC2 resources using tags? (http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/)
// in the Amazon Web Services Knowledge Center. Tags are visible on the tagged
// dataset, but not on the ingestion resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateIngestion for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion
func (c *QuickSight) CreateIngestion(input *CreateIngestionInput) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	return out, req.Send()
}

// CreateIngestionWithContext is the same as CreateIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateIngestionWithContext(ctx aws.Context, input *CreateIngestionInput, opts ...request.Option) (*CreateIngestionOutput, error) {
	req, out := c.CreateIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamespace = "CreateNamespace"

// CreateNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamespace for more information on using the CreateNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNamespaceRequest method.
//    req, resp := client.CreateNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace
func (c *QuickSight) CreateNamespaceRequest(input *CreateNamespaceInput) (req *request.Request, output *CreateNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}",
	}

	if input == nil {
		input = &CreateNamespaceInput{}
	}

	output = &CreateNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamespace API operation for Amazon QuickSight.
//
// (Enterprise edition only) Creates a new namespace for you to use with Amazon
// QuickSight.
//
// A namespace allows you to isolate the Amazon QuickSight users and groups
// that are registered for that namespace. Users that access the namespace can
// share assets only with other users or groups in the same namespace. They
// can't see users and groups in other namespaces. You can create a namespace
// after your Amazon Web Services account is subscribed to Amazon QuickSight.
// The namespace must be unique within the Amazon Web Services account. By default,
// there is a limit of 100 namespaces per Amazon Web Services account. To increase
// your limit, create a ticket with Amazon Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateNamespace for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace
func (c *QuickSight) CreateNamespace(input *CreateNamespaceInput) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	return out, req.Send()
}

// CreateNamespaceWithContext is the same as CreateNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateNamespaceWithContext(ctx aws.Context, input *CreateNamespaceInput, opts ...request.Option) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplate = "CreateTemplate"

// CreateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplate for more information on using the CreateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTemplateRequest method.
//    req, resp := client.CreateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplateRequest(input *CreateTemplateInput) (req *request.Request, output *CreateTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &CreateTemplateInput{}
	}

	output = &CreateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplate API operation for Amazon QuickSight.
//
// Creates a template from an existing Amazon QuickSight analysis or template.
// You can use the resulting template to create a dashboard.
//
// A template is an entity in Amazon QuickSight that encapsulates the metadata
// required to create an analysis and that you can use to create s dashboard.
// A template adds a layer of abstraction by using placeholders to replace the
// dataset associated with the analysis. You can use templates to create dashboards
// by replacing dataset placeholders with datasets that follow the same schema
// that was used to create the source analysis and template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate
func (c *QuickSight) CreateTemplate(input *CreateTemplateInput) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	return out, req.Send()
}

// CreateTemplateWithContext is the same as CreateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateWithContext(ctx aws.Context, input *CreateTemplateInput, opts ...request.Option) (*CreateTemplateOutput, error) {
	req, out := c.CreateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateAlias = "CreateTemplateAlias"

// CreateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateAlias for more information on using the CreateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTemplateAliasRequest method.
//    req, resp := client.CreateTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAliasRequest(input *CreateTemplateAliasInput) (req *request.Request, output *CreateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateTemplateAliasInput{}
	}

	output = &CreateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplateAlias API operation for Amazon QuickSight.
//
// Creates a template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTemplateAlias for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias
func (c *QuickSight) CreateTemplateAlias(input *CreateTemplateAliasInput) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	return out, req.Send()
}

// CreateTemplateAliasWithContext is the same as CreateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateTemplateAliasWithContext(ctx aws.Context, input *CreateTemplateAliasInput, opts ...request.Option) (*CreateTemplateAliasOutput, error) {
	req, out := c.CreateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTheme = "CreateTheme"

// CreateThemeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTheme for more information on using the CreateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThemeRequest method.
//    req, resp := client.CreateThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *QuickSight) CreateThemeRequest(input *CreateThemeInput) (req *request.Request, output *CreateThemeOutput) {
	op := &request.Operation{
		Name:       opCreateTheme,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &CreateThemeInput{}
	}

	output = &CreateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTheme API operation for Amazon QuickSight.
//
// Creates a theme.
//
// A theme is set of configuration options for color and layout. Themes apply
// to analyses and dashboards. For more information, see Using Themes in Amazon
// QuickSight (https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
// in the Amazon QuickSight User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateTheme for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme
func (c *QuickSight) CreateTheme(input *CreateThemeInput) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	return out, req.Send()
}

// CreateThemeWithContext is the same as CreateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateThemeWithContext(ctx aws.Context, input *CreateThemeInput, opts ...request.Option) (*CreateThemeOutput, error) {
	req, out := c.CreateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateThemeAlias = "CreateThemeAlias"

// CreateThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateThemeAlias for more information on using the CreateThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateThemeAliasRequest method.
//    req, resp := client.CreateThemeAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias
func (c *QuickSight) CreateThemeAliasRequest(input *CreateThemeAliasInput) (req *request.Request, output *CreateThemeAliasOutput) {
	op := &request.Operation{
		Name:       opCreateThemeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &CreateThemeAliasInput{}
	}

	output = &CreateThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateThemeAlias API operation for Amazon QuickSight.
//
// Creates a theme alias for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation CreateThemeAlias for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias
func (c *QuickSight) CreateThemeAlias(input *CreateThemeAliasInput) (*CreateThemeAliasOutput, error) {
	req, out := c.CreateThemeAliasRequest(input)
	return out, req.Send()
}

// CreateThemeAliasWithContext is the same as CreateThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) CreateThemeAliasWithContext(ctx aws.Context, input *CreateThemeAliasInput, opts ...request.Option) (*CreateThemeAliasOutput, error) {
	req, out := c.CreateThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountCustomization = "DeleteAccountCustomization"

// DeleteAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountCustomization for more information on using the DeleteAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccountCustomizationRequest method.
//    req, resp := client.DeleteAccountCustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization
func (c *QuickSight) DeleteAccountCustomizationRequest(input *DeleteAccountCustomizationInput) (req *request.Request, output *DeleteAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountCustomization,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &DeleteAccountCustomizationInput{}
	}

	output = &DeleteAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountCustomization API operation for Amazon QuickSight.
//
// Deletes all Amazon QuickSight customizations in this Amazon Web Services
// Region for the specified Amazon Web Services account and Amazon QuickSight
// namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAccountCustomization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization
func (c *QuickSight) DeleteAccountCustomization(input *DeleteAccountCustomizationInput) (*DeleteAccountCustomizationOutput, error) {
	req, out := c.DeleteAccountCustomizationRequest(input)
	return out, req.Send()
}

// DeleteAccountCustomizationWithContext is the same as DeleteAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAccountCustomizationWithContext(ctx aws.Context, input *DeleteAccountCustomizationInput, opts ...request.Option) (*DeleteAccountCustomizationOutput, error) {
	req, out := c.DeleteAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAnalysis = "DeleteAnalysis"

// DeleteAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAnalysis for more information on using the DeleteAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAnalysisRequest method.
//    req, resp := client.DeleteAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis
func (c *QuickSight) DeleteAnalysisRequest(input *DeleteAnalysisInput) (req *request.Request, output *DeleteAnalysisOutput) {
	op := &request.Operation{
		Name:       opDeleteAnalysis,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &DeleteAnalysisInput{}
	}

	output = &DeleteAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAnalysis API operation for Amazon QuickSight.
//
// Deletes an analysis from Amazon QuickSight. You can optionally include a
// recovery window during which you can restore the analysis. If you don't specify
// a recovery window value, the operation defaults to 30 days. Amazon QuickSight
// attaches a DeletionTime stamp to the response that specifies the end of the
// recovery window. At the end of the recovery window, Amazon QuickSight deletes
// the analysis permanently.
//
// At any time before recovery window ends, you can use the RestoreAnalysis
// API operation to remove the DeletionTime stamp and cancel the deletion of
// the analysis. The analysis remains visible in the API until it's deleted,
// so you can describe it but you can't make a template from it.
//
// An analysis that's scheduled for deletion isn't accessible in the Amazon
// QuickSight console. To access it in the console, restore it. Deleting an
// analysis doesn't delete the dashboards that you publish from it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteAnalysis for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis
func (c *QuickSight) DeleteAnalysis(input *DeleteAnalysisInput) (*DeleteAnalysisOutput, error) {
	req, out := c.DeleteAnalysisRequest(input)
	return out, req.Send()
}

// DeleteAnalysisWithContext is the same as DeleteAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteAnalysisWithContext(ctx aws.Context, input *DeleteAnalysisInput, opts ...request.Option) (*DeleteAnalysisOutput, error) {
	req, out := c.DeleteAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDashboard = "DeleteDashboard"

// DeleteDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDashboard for more information on using the DeleteDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDashboardRequest method.
//    req, resp := client.DeleteDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboardRequest(input *DeleteDashboardInput) (req *request.Request, output *DeleteDashboardOutput) {
	op := &request.Operation{
		Name:       opDeleteDashboard,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DeleteDashboardInput{}
	}

	output = &DeleteDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDashboard API operation for Amazon QuickSight.
//
// Deletes a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDashboard for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard
func (c *QuickSight) DeleteDashboard(input *DeleteDashboardInput) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	return out, req.Send()
}

// DeleteDashboardWithContext is the same as DeleteDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDashboardWithContext(ctx aws.Context, input *DeleteDashboardInput, opts ...request.Option) (*DeleteDashboardOutput, error) {
	req, out := c.DeleteDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSet = "DeleteDataSet"

// DeleteDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSet for more information on using the DeleteDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSetRequest method.
//    req, resp := client.DeleteDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSetRequest(input *DeleteDataSetInput) (req *request.Request, output *DeleteDataSetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DeleteDataSetInput{}
	}

	output = &DeleteDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSet API operation for Amazon QuickSight.
//
// Deletes a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSet for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet
func (c *QuickSight) DeleteDataSet(input *DeleteDataSetInput) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	return out, req.Send()
}

// DeleteDataSetWithContext is the same as DeleteDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSetWithContext(ctx aws.Context, input *DeleteDataSetInput, opts ...request.Option) (*DeleteDataSetOutput, error) {
	req, out := c.DeleteDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataSourceRequest method.
//    req, resp := client.DeleteDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon QuickSight.
//
// Deletes the data source permanently. This operation breaks all the datasets
// that reference the deleted data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource
func (c *QuickSight) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolder = "DeleteFolder"

// DeleteFolderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolder for more information on using the DeleteFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFolderRequest method.
//    req, resp := client.DeleteFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder
func (c *QuickSight) DeleteFolderRequest(input *DeleteFolderInput) (req *request.Request, output *DeleteFolderOutput) {
	op := &request.Operation{
		Name:       opDeleteFolder,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &DeleteFolderInput{}
	}

	output = &DeleteFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFolder API operation for Amazon QuickSight.
//
// Deletes an empty folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteFolder for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder
func (c *QuickSight) DeleteFolder(input *DeleteFolderInput) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	return out, req.Send()
}

// DeleteFolderWithContext is the same as DeleteFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteFolderWithContext(ctx aws.Context, input *DeleteFolderInput, opts ...request.Option) (*DeleteFolderOutput, error) {
	req, out := c.DeleteFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFolderMembership = "DeleteFolderMembership"

// DeleteFolderMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFolderMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFolderMembership for more information on using the DeleteFolderMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFolderMembershipRequest method.
//    req, resp := client.DeleteFolderMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership
func (c *QuickSight) DeleteFolderMembershipRequest(input *DeleteFolderMembershipInput) (req *request.Request, output *DeleteFolderMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteFolderMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members/{MemberType}/{MemberId}",
	}

	if input == nil {
		input = &DeleteFolderMembershipInput{}
	}

	output = &DeleteFolderMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFolderMembership API operation for Amazon QuickSight.
//
// Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteFolderMembership for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership
func (c *QuickSight) DeleteFolderMembership(input *DeleteFolderMembershipInput) (*DeleteFolderMembershipOutput, error) {
	req, out := c.DeleteFolderMembershipRequest(input)
	return out, req.Send()
}

// DeleteFolderMembershipWithContext is the same as DeleteFolderMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFolderMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteFolderMembershipWithContext(ctx aws.Context, input *DeleteFolderMembershipInput, opts ...request.Option) (*DeleteFolderMembershipOutput, error) {
	req, out := c.DeleteFolderMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for Amazon QuickSight.
//
// Removes a user group from Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup
func (c *QuickSight) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroupMembership = "DeleteGroupMembership"

// DeleteGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroupMembership for more information on using the DeleteGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupMembershipRequest method.
//    req, resp := client.DeleteGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembershipRequest(input *DeleteGroupMembershipInput) (req *request.Request, output *DeleteGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DeleteGroupMembershipInput{}
	}

	output = &DeleteGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroupMembership API operation for Amazon QuickSight.
//
// Removes a user from a group so that the user is no longer a member of the
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteGroupMembership for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership
func (c *QuickSight) DeleteGroupMembership(input *DeleteGroupMembershipInput) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	return out, req.Send()
}

// DeleteGroupMembershipWithContext is the same as DeleteGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteGroupMembershipWithContext(ctx aws.Context, input *DeleteGroupMembershipInput, opts ...request.Option) (*DeleteGroupMembershipOutput, error) {
	req, out := c.DeleteGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIAMPolicyAssignment = "DeleteIAMPolicyAssignment"

// DeleteIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIAMPolicyAssignment for more information on using the DeleteIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIAMPolicyAssignmentRequest method.
//    req, resp := client.DeleteIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignmentRequest(input *DeleteIAMPolicyAssignmentInput) (req *request.Request, output *DeleteIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteIAMPolicyAssignment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespace/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DeleteIAMPolicyAssignmentInput{}
	}

	output = &DeleteIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Deletes an existing IAM policy assignment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConcurrentUpdatingException
//   A resource is already in a state that indicates an operation is happening
//   that must complete before a new update can be applied.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment
func (c *QuickSight) DeleteIAMPolicyAssignment(input *DeleteIAMPolicyAssignmentInput) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DeleteIAMPolicyAssignmentWithContext is the same as DeleteIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteIAMPolicyAssignmentWithContext(ctx aws.Context, input *DeleteIAMPolicyAssignmentInput, opts ...request.Option) (*DeleteIAMPolicyAssignmentOutput, error) {
	req, out := c.DeleteIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamespaceRequest method.
//    req, resp := client.DeleteNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace
func (c *QuickSight) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for Amazon QuickSight.
//
// Deletes a namespace and the users and groups that are associated with the
// namespace. This is an asynchronous process. Assets including dashboards,
// analyses, datasets and data sources are not deleted. To delete these assets,
// you use the API operations for the relevant asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace
func (c *QuickSight) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplate = "DeleteTemplate"

// DeleteTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplate for more information on using the DeleteTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTemplateRequest method.
//    req, resp := client.DeleteTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplateRequest(input *DeleteTemplateInput) (req *request.Request, output *DeleteTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DeleteTemplateInput{}
	}

	output = &DeleteTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplate API operation for Amazon QuickSight.
//
// Deletes a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate
func (c *QuickSight) DeleteTemplate(input *DeleteTemplateInput) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	return out, req.Send()
}

// DeleteTemplateWithContext is the same as DeleteTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateWithContext(ctx aws.Context, input *DeleteTemplateInput, opts ...request.Option) (*DeleteTemplateOutput, error) {
	req, out := c.DeleteTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateAlias = "DeleteTemplateAlias"

// DeleteTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateAlias for more information on using the DeleteTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTemplateAliasRequest method.
//    req, resp := client.DeleteTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAliasRequest(input *DeleteTemplateAliasInput) (req *request.Request, output *DeleteTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteTemplateAliasInput{}
	}

	output = &DeleteTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplateAlias API operation for Amazon QuickSight.
//
// Deletes the item that the specified template alias points to. If you provide
// a specific alias, you delete the version of the template that the alias points
// to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTemplateAlias for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias
func (c *QuickSight) DeleteTemplateAlias(input *DeleteTemplateAliasInput) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	return out, req.Send()
}

// DeleteTemplateAliasWithContext is the same as DeleteTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteTemplateAliasWithContext(ctx aws.Context, input *DeleteTemplateAliasInput, opts ...request.Option) (*DeleteTemplateAliasOutput, error) {
	req, out := c.DeleteTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTheme = "DeleteTheme"

// DeleteThemeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTheme for more information on using the DeleteTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThemeRequest method.
//    req, resp := client.DeleteThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *QuickSight) DeleteThemeRequest(input *DeleteThemeInput) (req *request.Request, output *DeleteThemeOutput) {
	op := &request.Operation{
		Name:       opDeleteTheme,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DeleteThemeInput{}
	}

	output = &DeleteThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTheme API operation for Amazon QuickSight.
//
// Deletes a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteTheme for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme
func (c *QuickSight) DeleteTheme(input *DeleteThemeInput) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	return out, req.Send()
}

// DeleteThemeWithContext is the same as DeleteTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteThemeWithContext(ctx aws.Context, input *DeleteThemeInput, opts ...request.Option) (*DeleteThemeOutput, error) {
	req, out := c.DeleteThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteThemeAlias = "DeleteThemeAlias"

// DeleteThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThemeAlias for more information on using the DeleteThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteThemeAliasRequest method.
//    req, resp := client.DeleteThemeAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *QuickSight) DeleteThemeAliasRequest(input *DeleteThemeAliasInput) (req *request.Request, output *DeleteThemeAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteThemeAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DeleteThemeAliasInput{}
	}

	output = &DeleteThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThemeAlias API operation for Amazon QuickSight.
//
// Deletes the version of the theme that the specified theme alias points to.
// If you provide a specific alias, you delete the version of the theme that
// the alias points to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteThemeAlias for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias
func (c *QuickSight) DeleteThemeAlias(input *DeleteThemeAliasInput) (*DeleteThemeAliasOutput, error) {
	req, out := c.DeleteThemeAliasRequest(input)
	return out, req.Send()
}

// DeleteThemeAliasWithContext is the same as DeleteThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteThemeAliasWithContext(ctx aws.Context, input *DeleteThemeAliasInput, opts ...request.Option) (*DeleteThemeAliasOutput, error) {
	req, out := c.DeleteThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon QuickSight.
//
// Deletes the Amazon QuickSight user that is associated with the identity of
// the Identity and Access Management (IAM) user or role that's making the call.
// The IAM user isn't deleted as a result of this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser
func (c *QuickSight) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserByPrincipalId = "DeleteUserByPrincipalId"

// DeleteUserByPrincipalIdRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserByPrincipalId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserByPrincipalId for more information on using the DeleteUserByPrincipalId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserByPrincipalIdRequest method.
//    req, resp := client.DeleteUserByPrincipalIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalIdRequest(input *DeleteUserByPrincipalIdInput) (req *request.Request, output *DeleteUserByPrincipalIdOutput) {
	op := &request.Operation{
		Name:       opDeleteUserByPrincipalId,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/user-principals/{PrincipalId}",
	}

	if input == nil {
		input = &DeleteUserByPrincipalIdInput{}
	}

	output = &DeleteUserByPrincipalIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserByPrincipalId API operation for Amazon QuickSight.
//
// Deletes a user identified by its principal ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DeleteUserByPrincipalId for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId
func (c *QuickSight) DeleteUserByPrincipalId(input *DeleteUserByPrincipalIdInput) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	return out, req.Send()
}

// DeleteUserByPrincipalIdWithContext is the same as DeleteUserByPrincipalId with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserByPrincipalId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DeleteUserByPrincipalIdWithContext(ctx aws.Context, input *DeleteUserByPrincipalIdInput, opts ...request.Option) (*DeleteUserByPrincipalIdOutput, error) {
	req, out := c.DeleteUserByPrincipalIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountCustomization = "DescribeAccountCustomization"

// DescribeAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountCustomization for more information on using the DescribeAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountCustomizationRequest method.
//    req, resp := client.DescribeAccountCustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization
func (c *QuickSight) DescribeAccountCustomizationRequest(input *DescribeAccountCustomizationInput) (req *request.Request, output *DescribeAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountCustomization,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &DescribeAccountCustomizationInput{}
	}

	output = &DescribeAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountCustomization API operation for Amazon QuickSight.
//
// Describes the customizations associated with the provided Amazon Web Services
// account and Amazon Amazon QuickSight namespace in an Amazon Web Services
// Region. The Amazon QuickSight console evaluates which customizations to apply
// by running this API operation with the Resolved flag included.
//
// To determine what customizations display when you run this command, it can
// help to visualize the relationship of the entities involved.
//
//    * Amazon Web Services account - The Amazon Web Services account exists
//    at the top of the hierarchy. It has the potential to use all of the Amazon
//    Web Services Regions and Amazon Web Services Services. When you subscribe
//    to Amazon QuickSight, you choose one Amazon Web Services Region to use
//    as your home Region. That's where your free SPICE capacity is located.
//    You can use Amazon QuickSight in any supported Amazon Web Services Region.
//
//    * Amazon Web Services Region - In each Amazon Web Services Region where
//    you sign in to Amazon QuickSight at least once, Amazon QuickSight acts
//    as a separate instance of the same service. If you have a user directory,
//    it resides in us-east-1, which is the US East (N. Virginia). Generally
//    speaking, these users have access to Amazon QuickSight in any Amazon Web
//    Services Region, unless they are constrained to a namespace. To run the
//    command in a different Amazon Web Services Region, you change your Region
//    settings. If you're using the CLI, you can use one of the following options:
//    Use command line options (https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
//    Use named profiles (https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
//    Run aws configure to change your default Amazon Web Services Region. Use
//    Enter to key the same settings for your keys. For more information, see
//    Configuring the CLI (https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
//
//    * Namespace - A QuickSight namespace is a partition that contains users
//    and assets (data sources, datasets, dashboards, and so on). To access
//    assets that are in a specific namespace, users and groups must also be
//    part of the same namespace. People who share a namespace are completely
//    isolated from users and assets in other namespaces, even if they are in
//    the same Amazon Web Services account and Amazon Web Services Region.
//
//    * Applied customizations - Within an Amazon Web Services Region, a set
//    of Amazon QuickSight customizations can apply to an Amazon Web Services
//    account or to a namespace. Settings that you apply to a namespace override
//    settings that you apply to an Amazon Web Services account. All settings
//    are isolated to a single Amazon Web Services Region. To apply them in
//    other Amazon Web Services Regions, run the CreateAccountCustomization
//    command in each Amazon Web Services Region where you want to apply the
//    same customizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountCustomization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization
func (c *QuickSight) DescribeAccountCustomization(input *DescribeAccountCustomizationInput) (*DescribeAccountCustomizationOutput, error) {
	req, out := c.DescribeAccountCustomizationRequest(input)
	return out, req.Send()
}

// DescribeAccountCustomizationWithContext is the same as DescribeAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountCustomizationWithContext(ctx aws.Context, input *DescribeAccountCustomizationInput, opts ...request.Option) (*DescribeAccountCustomizationOutput, error) {
	req, out := c.DescribeAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountSettings = "DescribeAccountSettings"

// DescribeAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountSettings for more information on using the DescribeAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountSettingsRequest method.
//    req, resp := client.DescribeAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings
func (c *QuickSight) DescribeAccountSettingsRequest(input *DescribeAccountSettingsInput) (req *request.Request, output *DescribeAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/settings",
	}

	if input == nil {
		input = &DescribeAccountSettingsInput{}
	}

	output = &DescribeAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountSettings API operation for Amazon QuickSight.
//
// Describes the settings that were used when your Amazon QuickSight subscription
// was first created in this Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAccountSettings for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings
func (c *QuickSight) DescribeAccountSettings(input *DescribeAccountSettingsInput) (*DescribeAccountSettingsOutput, error) {
	req, out := c.DescribeAccountSettingsRequest(input)
	return out, req.Send()
}

// DescribeAccountSettingsWithContext is the same as DescribeAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAccountSettingsWithContext(ctx aws.Context, input *DescribeAccountSettingsInput, opts ...request.Option) (*DescribeAccountSettingsOutput, error) {
	req, out := c.DescribeAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysis = "DescribeAnalysis"

// DescribeAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysis for more information on using the DescribeAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAnalysisRequest method.
//    req, resp := client.DescribeAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis
func (c *QuickSight) DescribeAnalysisRequest(input *DescribeAnalysisInput) (req *request.Request, output *DescribeAnalysisOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysis,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &DescribeAnalysisInput{}
	}

	output = &DescribeAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysis API operation for Amazon QuickSight.
//
// Provides a summary of the metadata for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysis for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis
func (c *QuickSight) DescribeAnalysis(input *DescribeAnalysisInput) (*DescribeAnalysisOutput, error) {
	req, out := c.DescribeAnalysisRequest(input)
	return out, req.Send()
}

// DescribeAnalysisWithContext is the same as DescribeAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisWithContext(ctx aws.Context, input *DescribeAnalysisInput, opts ...request.Option) (*DescribeAnalysisOutput, error) {
	req, out := c.DescribeAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnalysisPermissions = "DescribeAnalysisPermissions"

// DescribeAnalysisPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnalysisPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnalysisPermissions for more information on using the DescribeAnalysisPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAnalysisPermissionsRequest method.
//    req, resp := client.DescribeAnalysisPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions
func (c *QuickSight) DescribeAnalysisPermissionsRequest(input *DescribeAnalysisPermissionsInput) (req *request.Request, output *DescribeAnalysisPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAnalysisPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
	}

	if input == nil {
		input = &DescribeAnalysisPermissionsInput{}
	}

	output = &DescribeAnalysisPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnalysisPermissions API operation for Amazon QuickSight.
//
// Provides the read and write permissions for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeAnalysisPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions
func (c *QuickSight) DescribeAnalysisPermissions(input *DescribeAnalysisPermissionsInput) (*DescribeAnalysisPermissionsOutput, error) {
	req, out := c.DescribeAnalysisPermissionsRequest(input)
	return out, req.Send()
}

// DescribeAnalysisPermissionsWithContext is the same as DescribeAnalysisPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnalysisPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeAnalysisPermissionsWithContext(ctx aws.Context, input *DescribeAnalysisPermissionsInput, opts ...request.Option) (*DescribeAnalysisPermissionsOutput, error) {
	req, out := c.DescribeAnalysisPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboard = "DescribeDashboard"

// DescribeDashboardRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboard for more information on using the DescribeDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDashboardRequest method.
//    req, resp := client.DescribeDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboardRequest(input *DescribeDashboardInput) (req *request.Request, output *DescribeDashboardOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboard,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &DescribeDashboardInput{}
	}

	output = &DescribeDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboard API operation for Amazon QuickSight.
//
// Provides a summary for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboard for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard
func (c *QuickSight) DescribeDashboard(input *DescribeDashboardInput) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	return out, req.Send()
}

// DescribeDashboardWithContext is the same as DescribeDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardWithContext(ctx aws.Context, input *DescribeDashboardInput, opts ...request.Option) (*DescribeDashboardOutput, error) {
	req, out := c.DescribeDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDashboardPermissions = "DescribeDashboardPermissions"

// DescribeDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDashboardPermissions for more information on using the DescribeDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDashboardPermissionsRequest method.
//    req, resp := client.DescribeDashboardPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissionsRequest(input *DescribeDashboardPermissionsInput) (req *request.Request, output *DescribeDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDashboardPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &DescribeDashboardPermissionsInput{}
	}

	output = &DescribeDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDashboardPermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions for a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDashboardPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions
func (c *QuickSight) DescribeDashboardPermissions(input *DescribeDashboardPermissionsInput) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDashboardPermissionsWithContext is the same as DescribeDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDashboardPermissionsWithContext(ctx aws.Context, input *DescribeDashboardPermissionsInput, opts ...request.Option) (*DescribeDashboardPermissionsOutput, error) {
	req, out := c.DescribeDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSet = "DescribeDataSet"

// DescribeDataSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSet for more information on using the DescribeDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSetRequest method.
//    req, resp := client.DescribeDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSetRequest(input *DescribeDataSetInput) (req *request.Request, output *DescribeDataSetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSet,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &DescribeDataSetInput{}
	}

	output = &DescribeDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSet API operation for Amazon QuickSight.
//
// Describes a dataset. This operation doesn't support datasets that include
// uploaded files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSet for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet
func (c *QuickSight) DescribeDataSet(input *DescribeDataSetInput) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	return out, req.Send()
}

// DescribeDataSetWithContext is the same as DescribeDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetWithContext(ctx aws.Context, input *DescribeDataSetInput, opts ...request.Option) (*DescribeDataSetOutput, error) {
	req, out := c.DescribeDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSetPermissions = "DescribeDataSetPermissions"

// DescribeDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSetPermissions for more information on using the DescribeDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSetPermissionsRequest method.
//    req, resp := client.DescribeDataSetPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissionsRequest(input *DescribeDataSetPermissionsInput) (req *request.Request, output *DescribeDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSetPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSetPermissionsInput{}
	}

	output = &DescribeDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSetPermissions API operation for Amazon QuickSight.
//
// Describes the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSetPermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions
func (c *QuickSight) DescribeDataSetPermissions(input *DescribeDataSetPermissionsInput) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSetPermissionsWithContext is the same as DescribeDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSetPermissionsWithContext(ctx aws.Context, input *DescribeDataSetPermissionsInput, opts ...request.Option) (*DescribeDataSetPermissionsOutput, error) {
	req, out := c.DescribeDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSource = "DescribeDataSource"

// DescribeDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSource for more information on using the DescribeDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourceRequest method.
//    req, resp := client.DescribeDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSourceRequest(input *DescribeDataSourceInput) (req *request.Request, output *DescribeDataSourceOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &DescribeDataSourceInput{}
	}

	output = &DescribeDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSource API operation for Amazon QuickSight.
//
// Describes a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource
func (c *QuickSight) DescribeDataSource(input *DescribeDataSourceInput) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	return out, req.Send()
}

// DescribeDataSourceWithContext is the same as DescribeDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourceWithContext(ctx aws.Context, input *DescribeDataSourceInput, opts ...request.Option) (*DescribeDataSourceOutput, error) {
	req, out := c.DescribeDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataSourcePermissions = "DescribeDataSourcePermissions"

// DescribeDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataSourcePermissions for more information on using the DescribeDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataSourcePermissionsRequest method.
//    req, resp := client.DescribeDataSourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissionsRequest(input *DescribeDataSourcePermissionsInput) (req *request.Request, output *DescribeDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDataSourcePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &DescribeDataSourcePermissionsInput{}
	}

	output = &DescribeDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataSourcePermissions API operation for Amazon QuickSight.
//
// Describes the resource permissions for a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeDataSourcePermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions
func (c *QuickSight) DescribeDataSourcePermissions(input *DescribeDataSourcePermissionsInput) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// DescribeDataSourcePermissionsWithContext is the same as DescribeDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeDataSourcePermissionsWithContext(ctx aws.Context, input *DescribeDataSourcePermissionsInput, opts ...request.Option) (*DescribeDataSourcePermissionsOutput, error) {
	req, out := c.DescribeDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolder = "DescribeFolder"

// DescribeFolderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolder for more information on using the DescribeFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFolderRequest method.
//    req, resp := client.DescribeFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder
func (c *QuickSight) DescribeFolderRequest(input *DescribeFolderInput) (req *request.Request, output *DescribeFolderOutput) {
	op := &request.Operation{
		Name:       opDescribeFolder,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &DescribeFolderInput{}
	}

	output = &DescribeFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolder API operation for Amazon QuickSight.
//
// Describes a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolder for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder
func (c *QuickSight) DescribeFolder(input *DescribeFolderInput) (*DescribeFolderOutput, error) {
	req, out := c.DescribeFolderRequest(input)
	return out, req.Send()
}

// DescribeFolderWithContext is the same as DescribeFolder with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderWithContext(ctx aws.Context, input *DescribeFolderInput, opts ...request.Option) (*DescribeFolderOutput, error) {
	req, out := c.DescribeFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolderPermissions = "DescribeFolderPermissions"

// DescribeFolderPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderPermissions for more information on using the DescribeFolderPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFolderPermissionsRequest method.
//    req, resp := client.DescribeFolderPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions
func (c *QuickSight) DescribeFolderPermissionsRequest(input *DescribeFolderPermissionsInput) (req *request.Request, output *DescribeFolderPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
	}

	if input == nil {
		input = &DescribeFolderPermissionsInput{}
	}

	output = &DescribeFolderPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderPermissions API operation for Amazon QuickSight.
//
// Describes permissions for a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolderPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions
func (c *QuickSight) DescribeFolderPermissions(input *DescribeFolderPermissionsInput) (*DescribeFolderPermissionsOutput, error) {
	req, out := c.DescribeFolderPermissionsRequest(input)
	return out, req.Send()
}

// DescribeFolderPermissionsWithContext is the same as DescribeFolderPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderPermissionsWithContext(ctx aws.Context, input *DescribeFolderPermissionsInput, opts ...request.Option) (*DescribeFolderPermissionsOutput, error) {
	req, out := c.DescribeFolderPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFolderResolvedPermissions = "DescribeFolderResolvedPermissions"

// DescribeFolderResolvedPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFolderResolvedPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFolderResolvedPermissions for more information on using the DescribeFolderResolvedPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFolderResolvedPermissionsRequest method.
//    req, resp := client.DescribeFolderResolvedPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions
func (c *QuickSight) DescribeFolderResolvedPermissionsRequest(input *DescribeFolderResolvedPermissionsInput) (req *request.Request, output *DescribeFolderResolvedPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeFolderResolvedPermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/resolved-permissions",
	}

	if input == nil {
		input = &DescribeFolderResolvedPermissionsInput{}
	}

	output = &DescribeFolderResolvedPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFolderResolvedPermissions API operation for Amazon QuickSight.
//
// Describes the folder resolved permissions. Permissions consists of both folder
// direct permissions and the inherited permissions from the ancestor folders.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeFolderResolvedPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions
func (c *QuickSight) DescribeFolderResolvedPermissions(input *DescribeFolderResolvedPermissionsInput) (*DescribeFolderResolvedPermissionsOutput, error) {
	req, out := c.DescribeFolderResolvedPermissionsRequest(input)
	return out, req.Send()
}

// DescribeFolderResolvedPermissionsWithContext is the same as DescribeFolderResolvedPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFolderResolvedPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeFolderResolvedPermissionsWithContext(ctx aws.Context, input *DescribeFolderResolvedPermissionsInput, opts ...request.Option) (*DescribeFolderResolvedPermissionsOutput, error) {
	req, out := c.DescribeFolderResolvedPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupRequest method.
//    req, resp := client.DescribeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon QuickSight.
//
// Returns an Amazon QuickSight group's description and Amazon Resource Name
// (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup
func (c *QuickSight) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroupMembership = "DescribeGroupMembership"

// DescribeGroupMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroupMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroupMembership for more information on using the DescribeGroupMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupMembershipRequest method.
//    req, resp := client.DescribeGroupMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership
func (c *QuickSight) DescribeGroupMembershipRequest(input *DescribeGroupMembershipInput) (req *request.Request, output *DescribeGroupMembershipOutput) {
	op := &request.Operation{
		Name:       opDescribeGroupMembership,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members/{MemberName}",
	}

	if input == nil {
		input = &DescribeGroupMembershipInput{}
	}

	output = &DescribeGroupMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroupMembership API operation for Amazon QuickSight.
//
// Use the DescribeGroupMembership operation to determine if a user is a member
// of the specified group. If the user exists and is a member of the specified
// group, an associated GroupMember object is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeGroupMembership for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership
func (c *QuickSight) DescribeGroupMembership(input *DescribeGroupMembershipInput) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	return out, req.Send()
}

// DescribeGroupMembershipWithContext is the same as DescribeGroupMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroupMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeGroupMembershipWithContext(ctx aws.Context, input *DescribeGroupMembershipInput, opts ...request.Option) (*DescribeGroupMembershipOutput, error) {
	req, out := c.DescribeGroupMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIAMPolicyAssignment = "DescribeIAMPolicyAssignment"

// DescribeIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIAMPolicyAssignment for more information on using the DescribeIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIAMPolicyAssignmentRequest method.
//    req, resp := client.DescribeIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignmentRequest(input *DescribeIAMPolicyAssignmentInput) (req *request.Request, output *DescribeIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opDescribeIAMPolicyAssignment,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &DescribeIAMPolicyAssignmentInput{}
	}

	output = &DescribeIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Describes an existing IAM policy assignment, as specified by the assignment
// name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment
func (c *QuickSight) DescribeIAMPolicyAssignment(input *DescribeIAMPolicyAssignmentInput) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// DescribeIAMPolicyAssignmentWithContext is the same as DescribeIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIAMPolicyAssignmentWithContext(ctx aws.Context, input *DescribeIAMPolicyAssignmentInput, opts ...request.Option) (*DescribeIAMPolicyAssignmentOutput, error) {
	req, out := c.DescribeIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIngestion = "DescribeIngestion"

// DescribeIngestionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIngestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIngestion for more information on using the DescribeIngestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIngestionRequest method.
//    req, resp := client.DescribeIngestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestionRequest(input *DescribeIngestionInput) (req *request.Request, output *DescribeIngestionOutput) {
	op := &request.Operation{
		Name:       opDescribeIngestion,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions/{IngestionId}",
	}

	if input == nil {
		input = &DescribeIngestionInput{}
	}

	output = &DescribeIngestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIngestion API operation for Amazon QuickSight.
//
// Describes a SPICE ingestion.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIngestion for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion
func (c *QuickSight) DescribeIngestion(input *DescribeIngestionInput) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	return out, req.Send()
}

// DescribeIngestionWithContext is the same as DescribeIngestion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIngestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIngestionWithContext(ctx aws.Context, input *DescribeIngestionInput, opts ...request.Option) (*DescribeIngestionOutput, error) {
	req, out := c.DescribeIngestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpRestriction = "DescribeIpRestriction"

// DescribeIpRestrictionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpRestriction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpRestriction for more information on using the DescribeIpRestriction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIpRestrictionRequest method.
//    req, resp := client.DescribeIpRestrictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction
func (c *QuickSight) DescribeIpRestrictionRequest(input *DescribeIpRestrictionInput) (req *request.Request, output *DescribeIpRestrictionOutput) {
	op := &request.Operation{
		Name:       opDescribeIpRestriction,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/ip-restriction",
	}

	if input == nil {
		input = &DescribeIpRestrictionInput{}
	}

	output = &DescribeIpRestrictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpRestriction API operation for Amazon QuickSight.
//
// Provides a summary and status of IP rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeIpRestriction for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction
func (c *QuickSight) DescribeIpRestriction(input *DescribeIpRestrictionInput) (*DescribeIpRestrictionOutput, error) {
	req, out := c.DescribeIpRestrictionRequest(input)
	return out, req.Send()
}

// DescribeIpRestrictionWithContext is the same as DescribeIpRestriction with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpRestriction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeIpRestrictionWithContext(ctx aws.Context, input *DescribeIpRestrictionInput, opts ...request.Option) (*DescribeIpRestrictionOutput, error) {
	req, out := c.DescribeIpRestrictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNamespace = "DescribeNamespace"

// DescribeNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNamespace for more information on using the DescribeNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNamespaceRequest method.
//    req, resp := client.DescribeNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace
func (c *QuickSight) DescribeNamespaceRequest(input *DescribeNamespaceInput) (req *request.Request, output *DescribeNamespaceOutput) {
	op := &request.Operation{
		Name:       opDescribeNamespace,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}",
	}

	if input == nil {
		input = &DescribeNamespaceInput{}
	}

	output = &DescribeNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNamespace API operation for Amazon QuickSight.
//
// Describes the current namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeNamespace for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace
func (c *QuickSight) DescribeNamespace(input *DescribeNamespaceInput) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	return out, req.Send()
}

// DescribeNamespaceWithContext is the same as DescribeNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeNamespaceWithContext(ctx aws.Context, input *DescribeNamespaceInput, opts ...request.Option) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplate = "DescribeTemplate"

// DescribeTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplate for more information on using the DescribeTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTemplateRequest method.
//    req, resp := client.DescribeTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplateRequest(input *DescribeTemplateInput) (req *request.Request, output *DescribeTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &DescribeTemplateInput{}
	}

	output = &DescribeTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplate API operation for Amazon QuickSight.
//
// Describes a template's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate
func (c *QuickSight) DescribeTemplate(input *DescribeTemplateInput) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	return out, req.Send()
}

// DescribeTemplateWithContext is the same as DescribeTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateWithContext(ctx aws.Context, input *DescribeTemplateInput, opts ...request.Option) (*DescribeTemplateOutput, error) {
	req, out := c.DescribeTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplateAlias = "DescribeTemplateAlias"

// DescribeTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplateAlias for more information on using the DescribeTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTemplateAliasRequest method.
//    req, resp := client.DescribeTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAliasRequest(input *DescribeTemplateAliasInput) (req *request.Request, output *DescribeTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplateAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeTemplateAliasInput{}
	}

	output = &DescribeTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplateAlias API operation for Amazon QuickSight.
//
// Describes the template alias for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplateAlias for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias
func (c *QuickSight) DescribeTemplateAlias(input *DescribeTemplateAliasInput) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	return out, req.Send()
}

// DescribeTemplateAliasWithContext is the same as DescribeTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplateAliasWithContext(ctx aws.Context, input *DescribeTemplateAliasInput, opts ...request.Option) (*DescribeTemplateAliasOutput, error) {
	req, out := c.DescribeTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTemplatePermissions = "DescribeTemplatePermissions"

// DescribeTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTemplatePermissions for more information on using the DescribeTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTemplatePermissionsRequest method.
//    req, resp := client.DescribeTemplatePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissionsRequest(input *DescribeTemplatePermissionsInput) (req *request.Request, output *DescribeTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeTemplatePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &DescribeTemplatePermissionsInput{}
	}

	output = &DescribeTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTemplatePermissions API operation for Amazon QuickSight.
//
// Describes read and write permissions on a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTemplatePermissions for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions
func (c *QuickSight) DescribeTemplatePermissions(input *DescribeTemplatePermissionsInput) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	return out, req.Send()
}

// DescribeTemplatePermissionsWithContext is the same as DescribeTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeTemplatePermissionsWithContext(ctx aws.Context, input *DescribeTemplatePermissionsInput, opts ...request.Option) (*DescribeTemplatePermissionsOutput, error) {
	req, out := c.DescribeTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTheme = "DescribeTheme"

// DescribeThemeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTheme for more information on using the DescribeTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThemeRequest method.
//    req, resp := client.DescribeThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *QuickSight) DescribeThemeRequest(input *DescribeThemeInput) (req *request.Request, output *DescribeThemeOutput) {
	op := &request.Operation{
		Name:       opDescribeTheme,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &DescribeThemeInput{}
	}

	output = &DescribeThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTheme API operation for Amazon QuickSight.
//
// Describes a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeTheme for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme
func (c *QuickSight) DescribeTheme(input *DescribeThemeInput) (*DescribeThemeOutput, error) {
	req, out := c.DescribeThemeRequest(input)
	return out, req.Send()
}

// DescribeThemeWithContext is the same as DescribeTheme with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemeWithContext(ctx aws.Context, input *DescribeThemeInput, opts ...request.Option) (*DescribeThemeOutput, error) {
	req, out := c.DescribeThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThemeAlias = "DescribeThemeAlias"

// DescribeThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThemeAlias for more information on using the DescribeThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThemeAliasRequest method.
//    req, resp := client.DescribeThemeAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *QuickSight) DescribeThemeAliasRequest(input *DescribeThemeAliasInput) (req *request.Request, output *DescribeThemeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeThemeAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &DescribeThemeAliasInput{}
	}

	output = &DescribeThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThemeAlias API operation for Amazon QuickSight.
//
// Describes the alias for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeThemeAlias for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias
func (c *QuickSight) DescribeThemeAlias(input *DescribeThemeAliasInput) (*DescribeThemeAliasOutput, error) {
	req, out := c.DescribeThemeAliasRequest(input)
	return out, req.Send()
}

// DescribeThemeAliasWithContext is the same as DescribeThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemeAliasWithContext(ctx aws.Context, input *DescribeThemeAliasInput, opts ...request.Option) (*DescribeThemeAliasOutput, error) {
	req, out := c.DescribeThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeThemePermissions = "DescribeThemePermissions"

// DescribeThemePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThemePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThemePermissions for more information on using the DescribeThemePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeThemePermissionsRequest method.
//    req, resp := client.DescribeThemePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions
func (c *QuickSight) DescribeThemePermissionsRequest(input *DescribeThemePermissionsInput) (req *request.Request, output *DescribeThemePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeThemePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
	}

	if input == nil {
		input = &DescribeThemePermissionsInput{}
	}

	output = &DescribeThemePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThemePermissions API operation for Amazon QuickSight.
//
// Describes the read and write permissions for a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeThemePermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions
func (c *QuickSight) DescribeThemePermissions(input *DescribeThemePermissionsInput) (*DescribeThemePermissionsOutput, error) {
	req, out := c.DescribeThemePermissionsRequest(input)
	return out, req.Send()
}

// DescribeThemePermissionsWithContext is the same as DescribeThemePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThemePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeThemePermissionsWithContext(ctx aws.Context, input *DescribeThemePermissionsInput, opts ...request.Option) (*DescribeThemePermissionsOutput, error) {
	req, out := c.DescribeThemePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon QuickSight.
//
// Returns information about a user, given the user name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser
func (c *QuickSight) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateEmbedUrlForAnonymousUser = "GenerateEmbedUrlForAnonymousUser"

// GenerateEmbedUrlForAnonymousUserRequest generates a "aws/request.Request" representing the
// client's request for the GenerateEmbedUrlForAnonymousUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateEmbedUrlForAnonymousUser for more information on using the GenerateEmbedUrlForAnonymousUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GenerateEmbedUrlForAnonymousUserRequest method.
//    req, resp := client.GenerateEmbedUrlForAnonymousUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser
func (c *QuickSight) GenerateEmbedUrlForAnonymousUserRequest(input *GenerateEmbedUrlForAnonymousUserInput) (req *request.Request, output *GenerateEmbedUrlForAnonymousUserOutput) {
	op := &request.Operation{
		Name:       opGenerateEmbedUrlForAnonymousUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/embed-url/anonymous-user",
	}

	if input == nil {
		input = &GenerateEmbedUrlForAnonymousUserInput{}
	}

	output = &GenerateEmbedUrlForAnonymousUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateEmbedUrlForAnonymousUser API operation for Amazon QuickSight.
//
// Generates an embed URL that you can use to embed an Amazon QuickSight dashboard
// in your website, without having to register any reader users. Before you
// use this action, make sure that you have configured the dashboards and permissions.
//
// The following rules apply to the generated URL:
//
//    * It contains a temporary bearer token. It is valid for 5 minutes after
//    it is generated. Once redeemed within this period, it cannot be re-used
//    again.
//
//    * The URL validity period should not be confused with the actual session
//    lifetime that can be customized using the SessionLifetimeInMinutes (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes)
//    parameter. The resulting user session is valid for 15 minutes (minimum)
//    to 10 hours (maximum). The default session duration is 10 hours.
//
//    * You are charged only when the URL is used or there is interaction with
//    Amazon QuickSight.
//
// For more information, see Embedded Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GenerateEmbedUrlForAnonymousUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * SessionLifetimeInMinutesInvalidException
//   The number of minutes specified for the lifetime of a session isn't valid.
//   The session lifetime must be 15-600 minutes.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * UnsupportedPricingPlanException
//   This error indicates that you are calling an embedding operation in Amazon
//   QuickSight without the required pricing plan on your Amazon Web Services
//   account. Before you can use embedding for anonymous users, a QuickSight administrator
//   needs to add capacity pricing to Amazon QuickSight. You can do this on the
//   Manage Amazon QuickSight page.
//
//   After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//   API operation with the --identity-type ANONYMOUS option.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser
func (c *QuickSight) GenerateEmbedUrlForAnonymousUser(input *GenerateEmbedUrlForAnonymousUserInput) (*GenerateEmbedUrlForAnonymousUserOutput, error) {
	req, out := c.GenerateEmbedUrlForAnonymousUserRequest(input)
	return out, req.Send()
}

// GenerateEmbedUrlForAnonymousUserWithContext is the same as GenerateEmbedUrlForAnonymousUser with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateEmbedUrlForAnonymousUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GenerateEmbedUrlForAnonymousUserWithContext(ctx aws.Context, input *GenerateEmbedUrlForAnonymousUserInput, opts ...request.Option) (*GenerateEmbedUrlForAnonymousUserOutput, error) {
	req, out := c.GenerateEmbedUrlForAnonymousUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateEmbedUrlForRegisteredUser = "GenerateEmbedUrlForRegisteredUser"

// GenerateEmbedUrlForRegisteredUserRequest generates a "aws/request.Request" representing the
// client's request for the GenerateEmbedUrlForRegisteredUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateEmbedUrlForRegisteredUser for more information on using the GenerateEmbedUrlForRegisteredUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GenerateEmbedUrlForRegisteredUserRequest method.
//    req, resp := client.GenerateEmbedUrlForRegisteredUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser
func (c *QuickSight) GenerateEmbedUrlForRegisteredUserRequest(input *GenerateEmbedUrlForRegisteredUserInput) (req *request.Request, output *GenerateEmbedUrlForRegisteredUserOutput) {
	op := &request.Operation{
		Name:       opGenerateEmbedUrlForRegisteredUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/embed-url/registered-user",
	}

	if input == nil {
		input = &GenerateEmbedUrlForRegisteredUserInput{}
	}

	output = &GenerateEmbedUrlForRegisteredUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateEmbedUrlForRegisteredUser API operation for Amazon QuickSight.
//
// Generates an embed URL that you can use to embed an Amazon QuickSight experience
// in your website. This action can be used for any type of user registered
// in an Amazon QuickSight account. Before you use this action, make sure that
// you have configured the relevant Amazon QuickSight resource and permissions.
//
// The following rules apply to the generated URL:
//
//    * It contains a temporary bearer token. It is valid for 5 minutes after
//    it is generated. Once redeemed within this period, it cannot be re-used
//    again.
//
//    * The URL validity period should not be confused with the actual session
//    lifetime that can be customized using the SessionLifetimeInMinutes (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes)
//    parameter. The resulting user session is valid for 15 minutes (minimum)
//    to 10 hours (maximum). The default session duration is 10 hours.
//
//    * You are charged only when the URL is used or there is interaction with
//    Amazon QuickSight.
//
// For more information, see Embedded Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GenerateEmbedUrlForRegisteredUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * UserNotFoundException
//   The user with the provided name isn't found. This error can happen in any
//   operation that requires finding a user based on a provided user name, such
//   as DeleteUser, DescribeUser, and so on.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * SessionLifetimeInMinutesInvalidException
//   The number of minutes specified for the lifetime of a session isn't valid.
//   The session lifetime must be 15-600 minutes.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * UnsupportedPricingPlanException
//   This error indicates that you are calling an embedding operation in Amazon
//   QuickSight without the required pricing plan on your Amazon Web Services
//   account. Before you can use embedding for anonymous users, a QuickSight administrator
//   needs to add capacity pricing to Amazon QuickSight. You can do this on the
//   Manage Amazon QuickSight page.
//
//   After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//   API operation with the --identity-type ANONYMOUS option.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser
func (c *QuickSight) GenerateEmbedUrlForRegisteredUser(input *GenerateEmbedUrlForRegisteredUserInput) (*GenerateEmbedUrlForRegisteredUserOutput, error) {
	req, out := c.GenerateEmbedUrlForRegisteredUserRequest(input)
	return out, req.Send()
}

// GenerateEmbedUrlForRegisteredUserWithContext is the same as GenerateEmbedUrlForRegisteredUser with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateEmbedUrlForRegisteredUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GenerateEmbedUrlForRegisteredUserWithContext(ctx aws.Context, input *GenerateEmbedUrlForRegisteredUserInput, opts ...request.Option) (*GenerateEmbedUrlForRegisteredUserOutput, error) {
	req, out := c.GenerateEmbedUrlForRegisteredUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDashboardEmbedUrl = "GetDashboardEmbedUrl"

// GetDashboardEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetDashboardEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDashboardEmbedUrl for more information on using the GetDashboardEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDashboardEmbedUrlRequest method.
//    req, resp := client.GetDashboardEmbedUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrlRequest(input *GetDashboardEmbedUrlInput) (req *request.Request, output *GetDashboardEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetDashboardEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/embed-url",
	}

	if input == nil {
		input = &GetDashboardEmbedUrlInput{}
	}

	output = &GetDashboardEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDashboardEmbedUrl API operation for Amazon QuickSight.
//
// Generates a session URL and authorization code that you can use to embed
// an Amazon Amazon QuickSight read-only dashboard in your web server code.
// Before you use this command, make sure that you have configured the dashboards
// and permissions.
//
// Currently, you can use GetDashboardEmbedURL only from the server, not from
// the user's browser. The following rules apply to the combination of URL and
// authorization code:
//
//    * They must be used together.
//
//    * They can be used one time only.
//
//    * They are valid for 5 minutes after you run this command.
//
//    * The resulting user session is valid for 10 hours.
//
// For more information, see Embedding Analytics Using GetDashboardEmbedUrl
// (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html)
// in the Amazon QuickSight User Guide.
//
// For more information about the high-level steps for embedding and for an
// interactive demo of the ways you can customize embedding, visit the Amazon
// QuickSight Developer Portal (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetDashboardEmbedUrl for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * DomainNotWhitelistedException
//   The domain specified isn't on the allow list. All domains for embedded dashboards
//   must be added to the approved list by an Amazon QuickSight admin.
//
//   * UserNotFoundException
//   The user with the provided name isn't found. This error can happen in any
//   operation that requires finding a user based on a provided user name, such
//   as DeleteUser, DescribeUser, and so on.
//
//   * IdentityTypeNotSupportedException
//   The identity type specified isn't supported. Supported identity types include
//   IAM and QUICKSIGHT.
//
//   * SessionLifetimeInMinutesInvalidException
//   The number of minutes specified for the lifetime of a session isn't valid.
//   The session lifetime must be 15-600 minutes.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * UnsupportedPricingPlanException
//   This error indicates that you are calling an embedding operation in Amazon
//   QuickSight without the required pricing plan on your Amazon Web Services
//   account. Before you can use embedding for anonymous users, a QuickSight administrator
//   needs to add capacity pricing to Amazon QuickSight. You can do this on the
//   Manage Amazon QuickSight page.
//
//   After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//   API operation with the --identity-type ANONYMOUS option.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl
func (c *QuickSight) GetDashboardEmbedUrl(input *GetDashboardEmbedUrlInput) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	return out, req.Send()
}

// GetDashboardEmbedUrlWithContext is the same as GetDashboardEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetDashboardEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetDashboardEmbedUrlWithContext(ctx aws.Context, input *GetDashboardEmbedUrlInput, opts ...request.Option) (*GetDashboardEmbedUrlOutput, error) {
	req, out := c.GetDashboardEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSessionEmbedUrl = "GetSessionEmbedUrl"

// GetSessionEmbedUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetSessionEmbedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSessionEmbedUrl for more information on using the GetSessionEmbedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSessionEmbedUrlRequest method.
//    req, resp := client.GetSessionEmbedUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl
func (c *QuickSight) GetSessionEmbedUrlRequest(input *GetSessionEmbedUrlInput) (req *request.Request, output *GetSessionEmbedUrlOutput) {
	op := &request.Operation{
		Name:       opGetSessionEmbedUrl,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/session-embed-url",
	}

	if input == nil {
		input = &GetSessionEmbedUrlInput{}
	}

	output = &GetSessionEmbedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSessionEmbedUrl API operation for Amazon QuickSight.
//
// Generates a session URL and authorization code that you can use to embed
// the Amazon Amazon QuickSight console in your web server code. Use GetSessionEmbedUrl
// where you want to provide an authoring portal that allows users to create
// data sources, datasets, analyses, and dashboards. The users who access an
// embedded Amazon QuickSight console need belong to the author or admin security
// cohort. If you want to restrict permissions to some of these features, add
// a custom permissions profile to the user with the UpdateUser (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html)
// API operation. Use RegisterUser (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html)
// API operation to add a new user with a custom permission profile attached.
// For more information, see the following sections in the Amazon QuickSight
// User Guide:
//
//    * Embedding Analytics (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
//
//    * Customizing Access to the Amazon QuickSight Console (https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation GetSessionEmbedUrl for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UserNotFoundException
//   The user with the provided name isn't found. This error can happen in any
//   operation that requires finding a user based on a provided user name, such
//   as DeleteUser, DescribeUser, and so on.
//
//   * SessionLifetimeInMinutesInvalidException
//   The number of minutes specified for the lifetime of a session isn't valid.
//   The session lifetime must be 15-600 minutes.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl
func (c *QuickSight) GetSessionEmbedUrl(input *GetSessionEmbedUrlInput) (*GetSessionEmbedUrlOutput, error) {
	req, out := c.GetSessionEmbedUrlRequest(input)
	return out, req.Send()
}

// GetSessionEmbedUrlWithContext is the same as GetSessionEmbedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetSessionEmbedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) GetSessionEmbedUrlWithContext(ctx aws.Context, input *GetSessionEmbedUrlInput, opts ...request.Option) (*GetSessionEmbedUrlOutput, error) {
	req, out := c.GetSessionEmbedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAnalyses = "ListAnalyses"

// ListAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the ListAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnalyses for more information on using the ListAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnalysesRequest method.
//    req, resp := client.ListAnalysesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses
func (c *QuickSight) ListAnalysesRequest(input *ListAnalysesInput) (req *request.Request, output *ListAnalysesOutput) {
	op := &request.Operation{
		Name:       opListAnalyses,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalysesInput{}
	}

	output = &ListAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnalyses API operation for Amazon QuickSight.
//
// Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListAnalyses for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses
func (c *QuickSight) ListAnalyses(input *ListAnalysesInput) (*ListAnalysesOutput, error) {
	req, out := c.ListAnalysesRequest(input)
	return out, req.Send()
}

// ListAnalysesWithContext is the same as ListAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAnalysesWithContext(ctx aws.Context, input *ListAnalysesInput, opts ...request.Option) (*ListAnalysesOutput, error) {
	req, out := c.ListAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnalysesPages iterates over the pages of a ListAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnalyses operation.
//    pageNum := 0
//    err := client.ListAnalysesPages(params,
//        func(page *quicksight.ListAnalysesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListAnalysesPages(input *ListAnalysesInput, fn func(*ListAnalysesOutput, bool) bool) error {
	return c.ListAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnalysesPagesWithContext same as ListAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListAnalysesPagesWithContext(ctx aws.Context, input *ListAnalysesInput, fn func(*ListAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboardVersions = "ListDashboardVersions"

// ListDashboardVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboardVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboardVersions for more information on using the ListDashboardVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardVersionsRequest method.
//    req, resp := client.ListDashboardVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersionsRequest(input *ListDashboardVersionsInput) (req *request.Request, output *ListDashboardVersionsOutput) {
	op := &request.Operation{
		Name:       opListDashboardVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardVersionsInput{}
	}

	output = &ListDashboardVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboardVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the dashboards in the Amazon QuickSight subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboardVersions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions
func (c *QuickSight) ListDashboardVersions(input *ListDashboardVersionsInput) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	return out, req.Send()
}

// ListDashboardVersionsWithContext is the same as ListDashboardVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboardVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsWithContext(ctx aws.Context, input *ListDashboardVersionsInput, opts ...request.Option) (*ListDashboardVersionsOutput, error) {
	req, out := c.ListDashboardVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardVersionsPages iterates over the pages of a ListDashboardVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboardVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDashboardVersions operation.
//    pageNum := 0
//    err := client.ListDashboardVersionsPages(params,
//        func(page *quicksight.ListDashboardVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDashboardVersionsPages(input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool) error {
	return c.ListDashboardVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardVersionsPagesWithContext same as ListDashboardVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardVersionsPagesWithContext(ctx aws.Context, input *ListDashboardVersionsInput, fn func(*ListDashboardVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDashboards = "ListDashboards"

// ListDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the ListDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDashboards for more information on using the ListDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDashboardsRequest method.
//    req, resp := client.ListDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboardsRequest(input *ListDashboardsInput) (req *request.Request, output *ListDashboardsOutput) {
	op := &request.Operation{
		Name:       opListDashboards,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDashboardsInput{}
	}

	output = &ListDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDashboards API operation for Amazon QuickSight.
//
// Lists dashboards in an Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDashboards for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards
func (c *QuickSight) ListDashboards(input *ListDashboardsInput) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	return out, req.Send()
}

// ListDashboardsWithContext is the same as ListDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See ListDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsWithContext(ctx aws.Context, input *ListDashboardsInput, opts ...request.Option) (*ListDashboardsOutput, error) {
	req, out := c.ListDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDashboardsPages iterates over the pages of a ListDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDashboards operation.
//    pageNum := 0
//    err := client.ListDashboardsPages(params,
//        func(page *quicksight.ListDashboardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDashboardsPages(input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool) error {
	return c.ListDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDashboardsPagesWithContext same as ListDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDashboardsPagesWithContext(ctx aws.Context, input *ListDashboardsInput, fn func(*ListDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSets = "ListDataSets"

// ListDataSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSets for more information on using the ListDataSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSetsRequest method.
//    req, resp := client.ListDataSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSetsRequest(input *ListDataSetsInput) (req *request.Request, output *ListDataSetsOutput) {
	op := &request.Operation{
		Name:       opListDataSets,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSetsInput{}
	}

	output = &ListDataSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSets API operation for Amazon QuickSight.
//
// Lists all of the datasets belonging to the current Amazon Web Services account
// in an Amazon Web Services Region.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/*.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSets for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets
func (c *QuickSight) ListDataSets(input *ListDataSetsInput) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	return out, req.Send()
}

// ListDataSetsWithContext is the same as ListDataSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsWithContext(ctx aws.Context, input *ListDataSetsInput, opts ...request.Option) (*ListDataSetsOutput, error) {
	req, out := c.ListDataSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSetsPages iterates over the pages of a ListDataSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSets operation.
//    pageNum := 0
//    err := client.ListDataSetsPages(params,
//        func(page *quicksight.ListDataSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDataSetsPages(input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool) error {
	return c.ListDataSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSetsPagesWithContext same as ListDataSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSetsPagesWithContext(ctx aws.Context, input *ListDataSetsInput, fn func(*ListDataSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataSourcesRequest method.
//    req, resp := client.ListDataSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Amazon QuickSight.
//
// Lists data sources in current Amazon Web Services Region that belong to this
// Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources
func (c *QuickSight) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataSources operation.
//    pageNum := 0
//    err := client.ListDataSourcesPages(params,
//        func(page *quicksight.ListDataSourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFolderMembers = "ListFolderMembers"

// ListFolderMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListFolderMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFolderMembers for more information on using the ListFolderMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFolderMembersRequest method.
//    req, resp := client.ListFolderMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers
func (c *QuickSight) ListFolderMembersRequest(input *ListFolderMembersInput) (req *request.Request, output *ListFolderMembersOutput) {
	op := &request.Operation{
		Name:       opListFolderMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/members",
	}

	if input == nil {
		input = &ListFolderMembersInput{}
	}

	output = &ListFolderMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFolderMembers API operation for Amazon QuickSight.
//
// List all assets (DASHBOARD, ANALYSIS, and DATASET) in a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListFolderMembers for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers
func (c *QuickSight) ListFolderMembers(input *ListFolderMembersInput) (*ListFolderMembersOutput, error) {
	req, out := c.ListFolderMembersRequest(input)
	return out, req.Send()
}

// ListFolderMembersWithContext is the same as ListFolderMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListFolderMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFolderMembersWithContext(ctx aws.Context, input *ListFolderMembersInput, opts ...request.Option) (*ListFolderMembersOutput, error) {
	req, out := c.ListFolderMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFolders = "ListFolders"

// ListFoldersRequest generates a "aws/request.Request" representing the
// client's request for the ListFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFolders for more information on using the ListFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFoldersRequest method.
//    req, resp := client.ListFoldersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders
func (c *QuickSight) ListFoldersRequest(input *ListFoldersInput) (req *request.Request, output *ListFoldersOutput) {
	op := &request.Operation{
		Name:       opListFolders,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/folders",
	}

	if input == nil {
		input = &ListFoldersInput{}
	}

	output = &ListFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFolders API operation for Amazon QuickSight.
//
// Lists all folders in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListFolders for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders
func (c *QuickSight) ListFolders(input *ListFoldersInput) (*ListFoldersOutput, error) {
	req, out := c.ListFoldersRequest(input)
	return out, req.Send()
}

// ListFoldersWithContext is the same as ListFolders with the addition of
// the ability to pass a context and additional request options.
//
// See ListFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListFoldersWithContext(ctx aws.Context, input *ListFoldersInput, opts ...request.Option) (*ListFoldersOutput, error) {
	req, out := c.ListFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupMemberships = "ListGroupMemberships"

// ListGroupMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMemberships for more information on using the ListGroupMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupMembershipsRequest method.
//    req, resp := client.ListGroupMembershipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMembershipsRequest(input *ListGroupMembershipsInput) (req *request.Request, output *ListGroupMembershipsOutput) {
	op := &request.Operation{
		Name:       opListGroupMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}/members",
	}

	if input == nil {
		input = &ListGroupMembershipsInput{}
	}

	output = &ListGroupMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMemberships API operation for Amazon QuickSight.
//
// Lists member users in a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroupMemberships for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships
func (c *QuickSight) ListGroupMemberships(input *ListGroupMembershipsInput) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	return out, req.Send()
}

// ListGroupMembershipsWithContext is the same as ListGroupMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupMembershipsWithContext(ctx aws.Context, input *ListGroupMembershipsInput, opts ...request.Option) (*ListGroupMembershipsOutput, error) {
	req, out := c.ListGroupMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon QuickSight.
//
// Lists all user groups in Amazon QuickSight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListGroups for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups
func (c *QuickSight) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIAMPolicyAssignments = "ListIAMPolicyAssignments"

// ListIAMPolicyAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignments for more information on using the ListIAMPolicyAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIAMPolicyAssignmentsRequest method.
//    req, resp := client.ListIAMPolicyAssignmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignmentsRequest(input *ListIAMPolicyAssignmentsInput) (req *request.Request, output *ListIAMPolicyAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignments,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsInput{}
	}

	output = &ListIAMPolicyAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignments API operation for Amazon QuickSight.
//
// Lists IAM policy assignments in the current Amazon QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignments for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments
func (c *QuickSight) ListIAMPolicyAssignments(input *ListIAMPolicyAssignmentsInput) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsWithContext is the same as ListIAMPolicyAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsInput, opts ...request.Option) (*ListIAMPolicyAssignmentsOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIAMPolicyAssignmentsForUser = "ListIAMPolicyAssignmentsForUser"

// ListIAMPolicyAssignmentsForUserRequest generates a "aws/request.Request" representing the
// client's request for the ListIAMPolicyAssignmentsForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIAMPolicyAssignmentsForUser for more information on using the ListIAMPolicyAssignmentsForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIAMPolicyAssignmentsForUserRequest method.
//    req, resp := client.ListIAMPolicyAssignmentsForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUserRequest(input *ListIAMPolicyAssignmentsForUserInput) (req *request.Request, output *ListIAMPolicyAssignmentsForUserOutput) {
	op := &request.Operation{
		Name:       opListIAMPolicyAssignmentsForUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/iam-policy-assignments",
	}

	if input == nil {
		input = &ListIAMPolicyAssignmentsForUserInput{}
	}

	output = &ListIAMPolicyAssignmentsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIAMPolicyAssignmentsForUser API operation for Amazon QuickSight.
//
// Lists all the IAM policy assignments, including the Amazon Resource Names
// (ARNs) for the IAM policies assigned to the specified user and group or groups
// that the user belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIAMPolicyAssignmentsForUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConcurrentUpdatingException
//   A resource is already in a state that indicates an operation is happening
//   that must complete before a new update can be applied.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser
func (c *QuickSight) ListIAMPolicyAssignmentsForUser(input *ListIAMPolicyAssignmentsForUserInput) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	return out, req.Send()
}

// ListIAMPolicyAssignmentsForUserWithContext is the same as ListIAMPolicyAssignmentsForUser with the addition of
// the ability to pass a context and additional request options.
//
// See ListIAMPolicyAssignmentsForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIAMPolicyAssignmentsForUserWithContext(ctx aws.Context, input *ListIAMPolicyAssignmentsForUserInput, opts ...request.Option) (*ListIAMPolicyAssignmentsForUserOutput, error) {
	req, out := c.ListIAMPolicyAssignmentsForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIngestions = "ListIngestions"

// ListIngestionsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestions for more information on using the ListIngestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIngestionsRequest method.
//    req, resp := client.ListIngestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestionsRequest(input *ListIngestionsInput) (req *request.Request, output *ListIngestionsOutput) {
	op := &request.Operation{
		Name:       opListIngestions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/ingestions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionsInput{}
	}

	output = &ListIngestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestions API operation for Amazon QuickSight.
//
// Lists the history of SPICE ingestions for a dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListIngestions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions
func (c *QuickSight) ListIngestions(input *ListIngestionsInput) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	return out, req.Send()
}

// ListIngestionsWithContext is the same as ListIngestions with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsWithContext(ctx aws.Context, input *ListIngestionsInput, opts ...request.Option) (*ListIngestionsOutput, error) {
	req, out := c.ListIngestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionsPages iterates over the pages of a ListIngestions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIngestions operation.
//    pageNum := 0
//    err := client.ListIngestionsPages(params,
//        func(page *quicksight.ListIngestionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListIngestionsPages(input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool) error {
	return c.ListIngestionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionsPagesWithContext same as ListIngestionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListIngestionsPagesWithContext(ctx aws.Context, input *ListIngestionsInput, fn func(*ListIngestionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNamespacesRequest method.
//    req, resp := client.ListNamespacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces
func (c *QuickSight) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamespaces API operation for Amazon QuickSight.
//
// Lists the namespaces for the specified Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListNamespaces for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces
func (c *QuickSight) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListNamespacesWithContext(ctx aws.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamespacesPages iterates over the pages of a ListNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNamespaces operation.
//    pageNum := 0
//    err := client.ListNamespacesPages(params,
//        func(page *quicksight.ListNamespacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListNamespacesPages(input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool) error {
	return c.ListNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamespacesPagesWithContext same as ListNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListNamespacesPagesWithContext(ctx aws.Context, input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon QuickSight.
//
// Lists the tags assigned to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource
func (c *QuickSight) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTemplateAliases = "ListTemplateAliases"

// ListTemplateAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateAliases for more information on using the ListTemplateAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplateAliasesRequest method.
//    req, resp := client.ListTemplateAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliasesRequest(input *ListTemplateAliasesInput) (req *request.Request, output *ListTemplateAliasesOutput) {
	op := &request.Operation{
		Name:       opListTemplateAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateAliasesInput{}
	}

	output = &ListTemplateAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateAliases for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases
func (c *QuickSight) ListTemplateAliases(input *ListTemplateAliasesInput) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	return out, req.Send()
}

// ListTemplateAliasesWithContext is the same as ListTemplateAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, opts ...request.Option) (*ListTemplateAliasesOutput, error) {
	req, out := c.ListTemplateAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateAliasesPages iterates over the pages of a ListTemplateAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTemplateAliases operation.
//    pageNum := 0
//    err := client.ListTemplateAliasesPages(params,
//        func(page *quicksight.ListTemplateAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListTemplateAliasesPages(input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool) error {
	return c.ListTemplateAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateAliasesPagesWithContext same as ListTemplateAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateAliasesPagesWithContext(ctx aws.Context, input *ListTemplateAliasesInput, fn func(*ListTemplateAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplateVersions = "ListTemplateVersions"

// ListTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplateVersions for more information on using the ListTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplateVersionsRequest method.
//    req, resp := client.ListTemplateVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersionsRequest(input *ListTemplateVersionsInput) (req *request.Request, output *ListTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListTemplateVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplateVersionsInput{}
	}

	output = &ListTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplateVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the templates in the current Amazon QuickSight
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplateVersions for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions
func (c *QuickSight) ListTemplateVersions(input *ListTemplateVersionsInput) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListTemplateVersionsWithContext is the same as ListTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsWithContext(ctx aws.Context, input *ListTemplateVersionsInput, opts ...request.Option) (*ListTemplateVersionsOutput, error) {
	req, out := c.ListTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplateVersionsPages iterates over the pages of a ListTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTemplateVersions operation.
//    pageNum := 0
//    err := client.ListTemplateVersionsPages(params,
//        func(page *quicksight.ListTemplateVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListTemplateVersionsPages(input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool) error {
	return c.ListTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplateVersionsPagesWithContext same as ListTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplateVersionsPagesWithContext(ctx aws.Context, input *ListTemplateVersionsInput, fn func(*ListTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTemplates = "ListTemplates"

// ListTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTemplates for more information on using the ListTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTemplatesRequest method.
//    req, resp := client.ListTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplatesRequest(input *ListTemplatesInput) (req *request.Request, output *ListTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTemplatesInput{}
	}

	output = &ListTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTemplates API operation for Amazon QuickSight.
//
// Lists all the templates in the current Amazon QuickSight account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListTemplates for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates
func (c *QuickSight) ListTemplates(input *ListTemplatesInput) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	return out, req.Send()
}

// ListTemplatesWithContext is the same as ListTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesWithContext(ctx aws.Context, input *ListTemplatesInput, opts ...request.Option) (*ListTemplatesOutput, error) {
	req, out := c.ListTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTemplatesPages iterates over the pages of a ListTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTemplates operation.
//    pageNum := 0
//    err := client.ListTemplatesPages(params,
//        func(page *quicksight.ListTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListTemplatesPages(input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool) error {
	return c.ListTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTemplatesPagesWithContext same as ListTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListTemplatesPagesWithContext(ctx aws.Context, input *ListTemplatesInput, fn func(*ListTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemeAliases = "ListThemeAliases"

// ListThemeAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemeAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemeAliases for more information on using the ListThemeAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThemeAliasesRequest method.
//    req, resp := client.ListThemeAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *QuickSight) ListThemeAliasesRequest(input *ListThemeAliasesInput) (req *request.Request, output *ListThemeAliasesOutput) {
	op := &request.Operation{
		Name:       opListThemeAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases",
	}

	if input == nil {
		input = &ListThemeAliasesInput{}
	}

	output = &ListThemeAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemeAliases API operation for Amazon QuickSight.
//
// Lists all the aliases of a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemeAliases for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases
func (c *QuickSight) ListThemeAliases(input *ListThemeAliasesInput) (*ListThemeAliasesOutput, error) {
	req, out := c.ListThemeAliasesRequest(input)
	return out, req.Send()
}

// ListThemeAliasesWithContext is the same as ListThemeAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemeAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeAliasesWithContext(ctx aws.Context, input *ListThemeAliasesInput, opts ...request.Option) (*ListThemeAliasesOutput, error) {
	req, out := c.ListThemeAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListThemeVersions = "ListThemeVersions"

// ListThemeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListThemeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemeVersions for more information on using the ListThemeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThemeVersionsRequest method.
//    req, resp := client.ListThemeVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *QuickSight) ListThemeVersionsRequest(input *ListThemeVersionsInput) (req *request.Request, output *ListThemeVersionsOutput) {
	op := &request.Operation{
		Name:       opListThemeVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemeVersionsInput{}
	}

	output = &ListThemeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemeVersions API operation for Amazon QuickSight.
//
// Lists all the versions of the themes in the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemeVersions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions
func (c *QuickSight) ListThemeVersions(input *ListThemeVersionsInput) (*ListThemeVersionsOutput, error) {
	req, out := c.ListThemeVersionsRequest(input)
	return out, req.Send()
}

// ListThemeVersionsWithContext is the same as ListThemeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeVersionsWithContext(ctx aws.Context, input *ListThemeVersionsInput, opts ...request.Option) (*ListThemeVersionsOutput, error) {
	req, out := c.ListThemeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemeVersionsPages iterates over the pages of a ListThemeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListThemeVersions operation.
//    pageNum := 0
//    err := client.ListThemeVersionsPages(params,
//        func(page *quicksight.ListThemeVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListThemeVersionsPages(input *ListThemeVersionsInput, fn func(*ListThemeVersionsOutput, bool) bool) error {
	return c.ListThemeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemeVersionsPagesWithContext same as ListThemeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemeVersionsPagesWithContext(ctx aws.Context, input *ListThemeVersionsInput, fn func(*ListThemeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListThemes = "ListThemes"

// ListThemesRequest generates a "aws/request.Request" representing the
// client's request for the ListThemes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListThemes for more information on using the ListThemes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListThemesRequest method.
//    req, resp := client.ListThemesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes
func (c *QuickSight) ListThemesRequest(input *ListThemesInput) (req *request.Request, output *ListThemesOutput) {
	op := &request.Operation{
		Name:       opListThemes,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/themes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListThemesInput{}
	}

	output = &ListThemesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListThemes API operation for Amazon QuickSight.
//
// Lists all the themes in the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListThemes for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes
func (c *QuickSight) ListThemes(input *ListThemesInput) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	return out, req.Send()
}

// ListThemesWithContext is the same as ListThemes with the addition of
// the ability to pass a context and additional request options.
//
// See ListThemes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemesWithContext(ctx aws.Context, input *ListThemesInput, opts ...request.Option) (*ListThemesOutput, error) {
	req, out := c.ListThemesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListThemesPages iterates over the pages of a ListThemes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListThemes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListThemes operation.
//    pageNum := 0
//    err := client.ListThemesPages(params,
//        func(page *quicksight.ListThemesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) ListThemesPages(input *ListThemesInput, fn func(*ListThemesOutput, bool) bool) error {
	return c.ListThemesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListThemesPagesWithContext same as ListThemesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListThemesPagesWithContext(ctx aws.Context, input *ListThemesInput, fn func(*ListThemesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListThemesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListThemesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListThemesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserGroups = "ListUserGroups"

// ListUserGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserGroups for more information on using the ListUserGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserGroupsRequest method.
//    req, resp := client.ListUserGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroupsRequest(input *ListUserGroupsInput) (req *request.Request, output *ListUserGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}/groups",
	}

	if input == nil {
		input = &ListUserGroupsInput{}
	}

	output = &ListUserGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserGroups API operation for Amazon QuickSight.
//
// Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member
// of.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUserGroups for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups
func (c *QuickSight) ListUserGroups(input *ListUserGroupsInput) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	return out, req.Send()
}

// ListUserGroupsWithContext is the same as ListUserGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUserGroupsWithContext(ctx aws.Context, input *ListUserGroupsInput, opts ...request.Option) (*ListUserGroupsOutput, error) {
	req, out := c.ListUserGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon QuickSight.
//
// Returns a list of all of the Amazon QuickSight users belonging to this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers
func (c *QuickSight) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterUser = "RegisterUser"

// RegisterUserRequest generates a "aws/request.Request" representing the
// client's request for the RegisterUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterUser for more information on using the RegisterUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterUserRequest method.
//    req, resp := client.RegisterUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUserRequest(input *RegisterUserInput) (req *request.Request, output *RegisterUserOutput) {
	op := &request.Operation{
		Name:       opRegisterUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users",
	}

	if input == nil {
		input = &RegisterUserInput{}
	}

	output = &RegisterUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterUser API operation for Amazon QuickSight.
//
// Creates an Amazon QuickSight user, whose identity is associated with the
// Identity and Access Management (IAM) identity or role specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RegisterUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser
func (c *QuickSight) RegisterUser(input *RegisterUserInput) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	return out, req.Send()
}

// RegisterUserWithContext is the same as RegisterUser with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RegisterUserWithContext(ctx aws.Context, input *RegisterUserInput, opts ...request.Option) (*RegisterUserOutput, error) {
	req, out := c.RegisterUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreAnalysis = "RestoreAnalysis"

// RestoreAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the RestoreAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreAnalysis for more information on using the RestoreAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreAnalysisRequest method.
//    req, resp := client.RestoreAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis
func (c *QuickSight) RestoreAnalysisRequest(input *RestoreAnalysisInput) (req *request.Request, output *RestoreAnalysisOutput) {
	op := &request.Operation{
		Name:       opRestoreAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/restore/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &RestoreAnalysisInput{}
	}

	output = &RestoreAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreAnalysis API operation for Amazon QuickSight.
//
// Restores an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation RestoreAnalysis for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis
func (c *QuickSight) RestoreAnalysis(input *RestoreAnalysisInput) (*RestoreAnalysisOutput, error) {
	req, out := c.RestoreAnalysisRequest(input)
	return out, req.Send()
}

// RestoreAnalysisWithContext is the same as RestoreAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) RestoreAnalysisWithContext(ctx aws.Context, input *RestoreAnalysisInput, opts ...request.Option) (*RestoreAnalysisOutput, error) {
	req, out := c.RestoreAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAnalyses = "SearchAnalyses"

// SearchAnalysesRequest generates a "aws/request.Request" representing the
// client's request for the SearchAnalyses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAnalyses for more information on using the SearchAnalyses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchAnalysesRequest method.
//    req, resp := client.SearchAnalysesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses
func (c *QuickSight) SearchAnalysesRequest(input *SearchAnalysesInput) (req *request.Request, output *SearchAnalysesOutput) {
	op := &request.Operation{
		Name:       opSearchAnalyses,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/analyses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAnalysesInput{}
	}

	output = &SearchAnalysesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAnalyses API operation for Amazon QuickSight.
//
// Searches for analyses that belong to the user specified in the filter.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchAnalyses for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses
func (c *QuickSight) SearchAnalyses(input *SearchAnalysesInput) (*SearchAnalysesOutput, error) {
	req, out := c.SearchAnalysesRequest(input)
	return out, req.Send()
}

// SearchAnalysesWithContext is the same as SearchAnalyses with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAnalyses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchAnalysesWithContext(ctx aws.Context, input *SearchAnalysesInput, opts ...request.Option) (*SearchAnalysesOutput, error) {
	req, out := c.SearchAnalysesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAnalysesPages iterates over the pages of a SearchAnalyses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAnalyses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchAnalyses operation.
//    pageNum := 0
//    err := client.SearchAnalysesPages(params,
//        func(page *quicksight.SearchAnalysesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) SearchAnalysesPages(input *SearchAnalysesInput, fn func(*SearchAnalysesOutput, bool) bool) error {
	return c.SearchAnalysesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAnalysesPagesWithContext same as SearchAnalysesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchAnalysesPagesWithContext(ctx aws.Context, input *SearchAnalysesInput, fn func(*SearchAnalysesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAnalysesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAnalysesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAnalysesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchDashboards = "SearchDashboards"

// SearchDashboardsRequest generates a "aws/request.Request" representing the
// client's request for the SearchDashboards operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchDashboards for more information on using the SearchDashboards
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchDashboardsRequest method.
//    req, resp := client.SearchDashboardsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *QuickSight) SearchDashboardsRequest(input *SearchDashboardsInput) (req *request.Request, output *SearchDashboardsOutput) {
	op := &request.Operation{
		Name:       opSearchDashboards,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/dashboards",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchDashboardsInput{}
	}

	output = &SearchDashboardsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchDashboards API operation for Amazon QuickSight.
//
// Searches for dashboards that belong to a user.
//
// This operation is eventually consistent. The results are best effort and
// may not reflect very recent updates and changes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchDashboards for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards
func (c *QuickSight) SearchDashboards(input *SearchDashboardsInput) (*SearchDashboardsOutput, error) {
	req, out := c.SearchDashboardsRequest(input)
	return out, req.Send()
}

// SearchDashboardsWithContext is the same as SearchDashboards with the addition of
// the ability to pass a context and additional request options.
//
// See SearchDashboards for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDashboardsWithContext(ctx aws.Context, input *SearchDashboardsInput, opts ...request.Option) (*SearchDashboardsOutput, error) {
	req, out := c.SearchDashboardsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchDashboardsPages iterates over the pages of a SearchDashboards operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchDashboards method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchDashboards operation.
//    pageNum := 0
//    err := client.SearchDashboardsPages(params,
//        func(page *quicksight.SearchDashboardsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *QuickSight) SearchDashboardsPages(input *SearchDashboardsInput, fn func(*SearchDashboardsOutput, bool) bool) error {
	return c.SearchDashboardsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchDashboardsPagesWithContext same as SearchDashboardsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchDashboardsPagesWithContext(ctx aws.Context, input *SearchDashboardsInput, fn func(*SearchDashboardsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchDashboardsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchDashboardsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchDashboardsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchFolders = "SearchFolders"

// SearchFoldersRequest generates a "aws/request.Request" representing the
// client's request for the SearchFolders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFolders for more information on using the SearchFolders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchFoldersRequest method.
//    req, resp := client.SearchFoldersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders
func (c *QuickSight) SearchFoldersRequest(input *SearchFoldersInput) (req *request.Request, output *SearchFoldersOutput) {
	op := &request.Operation{
		Name:       opSearchFolders,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/search/folders",
	}

	if input == nil {
		input = &SearchFoldersInput{}
	}

	output = &SearchFoldersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFolders API operation for Amazon QuickSight.
//
// Searches the subfolders in a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchFolders for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders
func (c *QuickSight) SearchFolders(input *SearchFoldersInput) (*SearchFoldersOutput, error) {
	req, out := c.SearchFoldersRequest(input)
	return out, req.Send()
}

// SearchFoldersWithContext is the same as SearchFolders with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFolders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchFoldersWithContext(ctx aws.Context, input *SearchFoldersInput, opts ...request.Option) (*SearchFoldersOutput, error) {
	req, out := c.SearchFoldersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchGroups = "SearchGroups"

// SearchGroupsRequest generates a "aws/request.Request" representing the
// client's request for the SearchGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGroups for more information on using the SearchGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchGroupsRequest method.
//    req, resp := client.SearchGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups
func (c *QuickSight) SearchGroupsRequest(input *SearchGroupsInput) (req *request.Request, output *SearchGroupsOutput) {
	op := &request.Operation{
		Name:       opSearchGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups-search",
	}

	if input == nil {
		input = &SearchGroupsInput{}
	}

	output = &SearchGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGroups API operation for Amazon QuickSight.
//
// Use the SearchGroups operation to search groups in a specified Amazon QuickSight
// namespace using the supplied filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation SearchGroups for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidNextTokenException
//   The NextToken value isn't valid.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups
func (c *QuickSight) SearchGroups(input *SearchGroupsInput) (*SearchGroupsOutput, error) {
	req, out := c.SearchGroupsRequest(input)
	return out, req.Send()
}

// SearchGroupsWithContext is the same as SearchGroups with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) SearchGroupsWithContext(ctx aws.Context, input *SearchGroupsInput, opts ...request.Option) (*SearchGroupsOutput, error) {
	req, out := c.SearchGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon QuickSight.
//
// Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight
// resource.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values. You can use the TagResource
// operation with a resource that already has tags. If you specify a new tag
// key for the resource, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource. Amazon QuickSight supports
// tagging on data set, data source, dashboard, and template.
//
// Tagging for Amazon QuickSight works in a similar way to tagging for other
// Amazon Web Services services, except for the following:
//
//    * You can't use tags to track costs for Amazon QuickSight. This isn't
//    possible because you can't tag the resources that Amazon QuickSight costs
//    are based on, for example Amazon QuickSight storage capacity (SPICE),
//    number of users, type of users, and usage metrics.
//
//    * Amazon QuickSight doesn't currently support the tag editor for Resource
//    Groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   A limit is exceeded.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource
func (c *QuickSight) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/resources/{ResourceArn}/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon QuickSight.
//
// Removes a tag or tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource
func (c *QuickSight) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountCustomization = "UpdateAccountCustomization"

// UpdateAccountCustomizationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountCustomization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountCustomization for more information on using the UpdateAccountCustomization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountCustomizationRequest method.
//    req, resp := client.UpdateAccountCustomizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization
func (c *QuickSight) UpdateAccountCustomizationRequest(input *UpdateAccountCustomizationInput) (req *request.Request, output *UpdateAccountCustomizationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountCustomization,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/customizations",
	}

	if input == nil {
		input = &UpdateAccountCustomizationInput{}
	}

	output = &UpdateAccountCustomizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountCustomization API operation for Amazon QuickSight.
//
// Updates Amazon QuickSight customizations the current Amazon Web Services
// Region. Currently, the only customization you can use is a theme.
//
// You can use customizations for your Amazon Web Services account or, if you
// specify a namespace, for a Amazon QuickSight namespace instead. Customizations
// that apply to a namespace override customizations that apply to an Amazon
// Web Services account. To find out which customizations apply, use the DescribeAccountCustomization
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAccountCustomization for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization
func (c *QuickSight) UpdateAccountCustomization(input *UpdateAccountCustomizationInput) (*UpdateAccountCustomizationOutput, error) {
	req, out := c.UpdateAccountCustomizationRequest(input)
	return out, req.Send()
}

// UpdateAccountCustomizationWithContext is the same as UpdateAccountCustomization with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountCustomization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAccountCustomizationWithContext(ctx aws.Context, input *UpdateAccountCustomizationInput, opts ...request.Option) (*UpdateAccountCustomizationOutput, error) {
	req, out := c.UpdateAccountCustomizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountSettingsRequest method.
//    req, resp := client.UpdateAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings
func (c *QuickSight) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/settings",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountSettings API operation for Amazon QuickSight.
//
// Updates the Amazon QuickSight settings in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings
func (c *QuickSight) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysis = "UpdateAnalysis"

// UpdateAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysis for more information on using the UpdateAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAnalysisRequest method.
//    req, resp := client.UpdateAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis
func (c *QuickSight) UpdateAnalysisRequest(input *UpdateAnalysisInput) (req *request.Request, output *UpdateAnalysisOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysis,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}",
	}

	if input == nil {
		input = &UpdateAnalysisInput{}
	}

	output = &UpdateAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysis API operation for Amazon QuickSight.
//
// Updates an analysis in Amazon QuickSight
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAnalysis for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis
func (c *QuickSight) UpdateAnalysis(input *UpdateAnalysisInput) (*UpdateAnalysisOutput, error) {
	req, out := c.UpdateAnalysisRequest(input)
	return out, req.Send()
}

// UpdateAnalysisWithContext is the same as UpdateAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAnalysisWithContext(ctx aws.Context, input *UpdateAnalysisInput, opts ...request.Option) (*UpdateAnalysisOutput, error) {
	req, out := c.UpdateAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAnalysisPermissions = "UpdateAnalysisPermissions"

// UpdateAnalysisPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAnalysisPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAnalysisPermissions for more information on using the UpdateAnalysisPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAnalysisPermissionsRequest method.
//    req, resp := client.UpdateAnalysisPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions
func (c *QuickSight) UpdateAnalysisPermissionsRequest(input *UpdateAnalysisPermissionsInput) (req *request.Request, output *UpdateAnalysisPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateAnalysisPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/analyses/{AnalysisId}/permissions",
	}

	if input == nil {
		input = &UpdateAnalysisPermissionsInput{}
	}

	output = &UpdateAnalysisPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAnalysisPermissions API operation for Amazon QuickSight.
//
// Updates the read and write permissions for an analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateAnalysisPermissions for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions
func (c *QuickSight) UpdateAnalysisPermissions(input *UpdateAnalysisPermissionsInput) (*UpdateAnalysisPermissionsOutput, error) {
	req, out := c.UpdateAnalysisPermissionsRequest(input)
	return out, req.Send()
}

// UpdateAnalysisPermissionsWithContext is the same as UpdateAnalysisPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAnalysisPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateAnalysisPermissionsWithContext(ctx aws.Context, input *UpdateAnalysisPermissionsInput, opts ...request.Option) (*UpdateAnalysisPermissionsOutput, error) {
	req, out := c.UpdateAnalysisPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboard = "UpdateDashboard"

// UpdateDashboardRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboard for more information on using the UpdateDashboard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardRequest method.
//    req, resp := client.UpdateDashboardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboardRequest(input *UpdateDashboardInput) (req *request.Request, output *UpdateDashboardOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboard,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}",
	}

	if input == nil {
		input = &UpdateDashboardInput{}
	}

	output = &UpdateDashboardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboard API operation for Amazon QuickSight.
//
// Updates a dashboard in an Amazon Web Services account.
//
// Updating a Dashboard creates a new dashboard version but does not immediately
// publish the new version. You can update the published version of a dashboard
// by using the UpdateDashboardPublishedVersion (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html)
// API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboard for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard
func (c *QuickSight) UpdateDashboard(input *UpdateDashboardInput) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	return out, req.Send()
}

// UpdateDashboardWithContext is the same as UpdateDashboard with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardWithContext(ctx aws.Context, input *UpdateDashboardInput, opts ...request.Option) (*UpdateDashboardOutput, error) {
	req, out := c.UpdateDashboardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPermissions = "UpdateDashboardPermissions"

// UpdateDashboardPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPermissions for more information on using the UpdateDashboardPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardPermissionsRequest method.
//    req, resp := client.UpdateDashboardPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissionsRequest(input *UpdateDashboardPermissionsInput) (req *request.Request, output *UpdateDashboardPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/permissions",
	}

	if input == nil {
		input = &UpdateDashboardPermissionsInput{}
	}

	output = &UpdateDashboardPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPermissions API operation for Amazon QuickSight.
//
// Updates read and write permissions on a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPermissions for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions
func (c *QuickSight) UpdateDashboardPermissions(input *UpdateDashboardPermissionsInput) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDashboardPermissionsWithContext is the same as UpdateDashboardPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPermissionsWithContext(ctx aws.Context, input *UpdateDashboardPermissionsInput, opts ...request.Option) (*UpdateDashboardPermissionsOutput, error) {
	req, out := c.UpdateDashboardPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDashboardPublishedVersion = "UpdateDashboardPublishedVersion"

// UpdateDashboardPublishedVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDashboardPublishedVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDashboardPublishedVersion for more information on using the UpdateDashboardPublishedVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDashboardPublishedVersionRequest method.
//    req, resp := client.UpdateDashboardPublishedVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersionRequest(input *UpdateDashboardPublishedVersionInput) (req *request.Request, output *UpdateDashboardPublishedVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDashboardPublishedVersion,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/dashboards/{DashboardId}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &UpdateDashboardPublishedVersionInput{}
	}

	output = &UpdateDashboardPublishedVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDashboardPublishedVersion API operation for Amazon QuickSight.
//
// Updates the published version of a dashboard.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDashboardPublishedVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion
func (c *QuickSight) UpdateDashboardPublishedVersion(input *UpdateDashboardPublishedVersionInput) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	return out, req.Send()
}

// UpdateDashboardPublishedVersionWithContext is the same as UpdateDashboardPublishedVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDashboardPublishedVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDashboardPublishedVersionWithContext(ctx aws.Context, input *UpdateDashboardPublishedVersionInput, opts ...request.Option) (*UpdateDashboardPublishedVersionOutput, error) {
	req, out := c.UpdateDashboardPublishedVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSet = "UpdateDataSet"

// UpdateDataSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSet for more information on using the UpdateDataSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSetRequest method.
//    req, resp := client.UpdateDataSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSetRequest(input *UpdateDataSetInput) (req *request.Request, output *UpdateDataSetOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSet,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}",
	}

	if input == nil {
		input = &UpdateDataSetInput{}
	}

	output = &UpdateDataSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSet API operation for Amazon QuickSight.
//
// Updates a dataset. This operation doesn't support datasets that include uploaded
// files as a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSet for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet
func (c *QuickSight) UpdateDataSet(input *UpdateDataSetInput) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	return out, req.Send()
}

// UpdateDataSetWithContext is the same as UpdateDataSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetWithContext(ctx aws.Context, input *UpdateDataSetInput, opts ...request.Option) (*UpdateDataSetOutput, error) {
	req, out := c.UpdateDataSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSetPermissions = "UpdateDataSetPermissions"

// UpdateDataSetPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSetPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSetPermissions for more information on using the UpdateDataSetPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSetPermissionsRequest method.
//    req, resp := client.UpdateDataSetPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissionsRequest(input *UpdateDataSetPermissionsInput) (req *request.Request, output *UpdateDataSetPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSetPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sets/{DataSetId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSetPermissionsInput{}
	}

	output = &UpdateDataSetPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSetPermissions API operation for Amazon QuickSight.
//
// Updates the permissions on a dataset.
//
// The permissions resource is arn:aws:quicksight:region:aws-account-id:dataset/data-set-id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSetPermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions
func (c *QuickSight) UpdateDataSetPermissions(input *UpdateDataSetPermissionsInput) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSetPermissionsWithContext is the same as UpdateDataSetPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSetPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSetPermissionsWithContext(ctx aws.Context, input *UpdateDataSetPermissionsInput, opts ...request.Option) (*UpdateDataSetPermissionsOutput, error) {
	req, out := c.UpdateDataSetPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourceRequest method.
//    req, resp := client.UpdateDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon QuickSight.
//
// Updates a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource
func (c *QuickSight) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSourcePermissions = "UpdateDataSourcePermissions"

// UpdateDataSourcePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSourcePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSourcePermissions for more information on using the UpdateDataSourcePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataSourcePermissionsRequest method.
//    req, resp := client.UpdateDataSourcePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissionsRequest(input *UpdateDataSourcePermissionsInput) (req *request.Request, output *UpdateDataSourcePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSourcePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/data-sources/{DataSourceId}/permissions",
	}

	if input == nil {
		input = &UpdateDataSourcePermissionsInput{}
	}

	output = &UpdateDataSourcePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSourcePermissions API operation for Amazon QuickSight.
//
// Updates the permissions to a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateDataSourcePermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions
func (c *QuickSight) UpdateDataSourcePermissions(input *UpdateDataSourcePermissionsInput) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	return out, req.Send()
}

// UpdateDataSourcePermissionsWithContext is the same as UpdateDataSourcePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSourcePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateDataSourcePermissionsWithContext(ctx aws.Context, input *UpdateDataSourcePermissionsInput, opts ...request.Option) (*UpdateDataSourcePermissionsOutput, error) {
	req, out := c.UpdateDataSourcePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolder = "UpdateFolder"

// UpdateFolderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolder for more information on using the UpdateFolder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFolderRequest method.
//    req, resp := client.UpdateFolderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder
func (c *QuickSight) UpdateFolderRequest(input *UpdateFolderInput) (req *request.Request, output *UpdateFolderOutput) {
	op := &request.Operation{
		Name:       opUpdateFolder,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}",
	}

	if input == nil {
		input = &UpdateFolderInput{}
	}

	output = &UpdateFolderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFolder API operation for Amazon QuickSight.
//
// Updates the name of a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateFolder for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder
func (c *QuickSight) UpdateFolder(input *UpdateFolderInput) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	return out, req.Send()
}

// UpdateFolderWithContext is the same as UpdateFolder with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateFolderWithContext(ctx aws.Context, input *UpdateFolderInput, opts ...request.Option) (*UpdateFolderOutput, error) {
	req, out := c.UpdateFolderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFolderPermissions = "UpdateFolderPermissions"

// UpdateFolderPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFolderPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFolderPermissions for more information on using the UpdateFolderPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFolderPermissionsRequest method.
//    req, resp := client.UpdateFolderPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions
func (c *QuickSight) UpdateFolderPermissionsRequest(input *UpdateFolderPermissionsInput) (req *request.Request, output *UpdateFolderPermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateFolderPermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/folders/{FolderId}/permissions",
	}

	if input == nil {
		input = &UpdateFolderPermissionsInput{}
	}

	output = &UpdateFolderPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFolderPermissions API operation for Amazon QuickSight.
//
// Updates permissions of a folder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateFolderPermissions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions
func (c *QuickSight) UpdateFolderPermissions(input *UpdateFolderPermissionsInput) (*UpdateFolderPermissionsOutput, error) {
	req, out := c.UpdateFolderPermissionsRequest(input)
	return out, req.Send()
}

// UpdateFolderPermissionsWithContext is the same as UpdateFolderPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFolderPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateFolderPermissionsWithContext(ctx aws.Context, input *UpdateFolderPermissionsInput, opts ...request.Option) (*UpdateFolderPermissionsOutput, error) {
	req, out := c.UpdateFolderPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/groups/{GroupName}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for Amazon QuickSight.
//
// Changes a group description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup
func (c *QuickSight) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIAMPolicyAssignment = "UpdateIAMPolicyAssignment"

// UpdateIAMPolicyAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIAMPolicyAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIAMPolicyAssignment for more information on using the UpdateIAMPolicyAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIAMPolicyAssignmentRequest method.
//    req, resp := client.UpdateIAMPolicyAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignmentRequest(input *UpdateIAMPolicyAssignmentInput) (req *request.Request, output *UpdateIAMPolicyAssignmentOutput) {
	op := &request.Operation{
		Name:       opUpdateIAMPolicyAssignment,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &UpdateIAMPolicyAssignmentInput{}
	}

	output = &UpdateIAMPolicyAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIAMPolicyAssignment API operation for Amazon QuickSight.
//
// Updates an existing IAM policy assignment. This operation updates only the
// optional parameter or parameters that are specified in the request. This
// overwrites all of the users included in Identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIAMPolicyAssignment for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConcurrentUpdatingException
//   A resource is already in a state that indicates an operation is happening
//   that must complete before a new update can be applied.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *QuickSight) UpdateIAMPolicyAssignment(input *UpdateIAMPolicyAssignmentInput) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	return out, req.Send()
}

// UpdateIAMPolicyAssignmentWithContext is the same as UpdateIAMPolicyAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIAMPolicyAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIAMPolicyAssignmentWithContext(ctx aws.Context, input *UpdateIAMPolicyAssignmentInput, opts ...request.Option) (*UpdateIAMPolicyAssignmentOutput, error) {
	req, out := c.UpdateIAMPolicyAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIpRestriction = "UpdateIpRestriction"

// UpdateIpRestrictionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIpRestriction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIpRestriction for more information on using the UpdateIpRestriction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIpRestrictionRequest method.
//    req, resp := client.UpdateIpRestrictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction
func (c *QuickSight) UpdateIpRestrictionRequest(input *UpdateIpRestrictionInput) (req *request.Request, output *UpdateIpRestrictionOutput) {
	op := &request.Operation{
		Name:       opUpdateIpRestriction,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{AwsAccountId}/ip-restriction",
	}

	if input == nil {
		input = &UpdateIpRestrictionInput{}
	}

	output = &UpdateIpRestrictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIpRestriction API operation for Amazon QuickSight.
//
// Updates the content and status of IP rules. To use this operation, you need
// to provide the entire map of rules. You can use the DescribeIpRestriction
// operation to get the current rule map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateIpRestriction for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   A limit is exceeded.
//
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction
func (c *QuickSight) UpdateIpRestriction(input *UpdateIpRestrictionInput) (*UpdateIpRestrictionOutput, error) {
	req, out := c.UpdateIpRestrictionRequest(input)
	return out, req.Send()
}

// UpdateIpRestrictionWithContext is the same as UpdateIpRestriction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIpRestriction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateIpRestrictionWithContext(ctx aws.Context, input *UpdateIpRestrictionInput, opts ...request.Option) (*UpdateIpRestrictionOutput, error) {
	req, out := c.UpdateIpRestrictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePublicSharingSettings = "UpdatePublicSharingSettings"

// UpdatePublicSharingSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePublicSharingSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePublicSharingSettings for more information on using the UpdatePublicSharingSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePublicSharingSettingsRequest method.
//    req, resp := client.UpdatePublicSharingSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings
func (c *QuickSight) UpdatePublicSharingSettingsRequest(input *UpdatePublicSharingSettingsInput) (req *request.Request, output *UpdatePublicSharingSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdatePublicSharingSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/public-sharing-settings",
	}

	if input == nil {
		input = &UpdatePublicSharingSettingsInput{}
	}

	output = &UpdatePublicSharingSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePublicSharingSettings API operation for Amazon QuickSight.
//
// Use the UpdatePublicSharingSettings operation to enable or disable the public
// sharing settings of an Amazon QuickSight dashboard.
//
// To use this operation, enable session capacity pricing on your Amazon QuickSight
// account.
//
// Before you can enable public sharing on your account, you need to allow public
// sharing permissions to an administrative user in the IAM console. For more
// information on using IAM with Amazon QuickSight, see Using Amazon QuickSight
// with IAM (https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdatePublicSharingSettings for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedPricingPlanException
//   This error indicates that you are calling an embedding operation in Amazon
//   QuickSight without the required pricing plan on your Amazon Web Services
//   account. Before you can use embedding for anonymous users, a QuickSight administrator
//   needs to add capacity pricing to Amazon QuickSight. You can do this on the
//   Manage Amazon QuickSight page.
//
//   After capacity pricing is added, you can use the GetDashboardEmbedUrl (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html)
//   API operation with the --identity-type ANONYMOUS option.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings
func (c *QuickSight) UpdatePublicSharingSettings(input *UpdatePublicSharingSettingsInput) (*UpdatePublicSharingSettingsOutput, error) {
	req, out := c.UpdatePublicSharingSettingsRequest(input)
	return out, req.Send()
}

// UpdatePublicSharingSettingsWithContext is the same as UpdatePublicSharingSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePublicSharingSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdatePublicSharingSettingsWithContext(ctx aws.Context, input *UpdatePublicSharingSettingsInput, opts ...request.Option) (*UpdatePublicSharingSettingsOutput, error) {
	req, out := c.UpdatePublicSharingSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplate = "UpdateTemplate"

// UpdateTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplate for more information on using the UpdateTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplateRequest method.
//    req, resp := client.UpdateTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplateRequest(input *UpdateTemplateInput) (req *request.Request, output *UpdateTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}",
	}

	if input == nil {
		input = &UpdateTemplateInput{}
	}

	output = &UpdateTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplate API operation for Amazon QuickSight.
//
// Updates a template from an existing Amazon QuickSight analysis or another
// template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate
func (c *QuickSight) UpdateTemplate(input *UpdateTemplateInput) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	return out, req.Send()
}

// UpdateTemplateWithContext is the same as UpdateTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateWithContext(ctx aws.Context, input *UpdateTemplateInput, opts ...request.Option) (*UpdateTemplateOutput, error) {
	req, out := c.UpdateTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateAlias = "UpdateTemplateAlias"

// UpdateTemplateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateAlias for more information on using the UpdateTemplateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplateAliasRequest method.
//    req, resp := client.UpdateTemplateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAliasRequest(input *UpdateTemplateAliasInput) (req *request.Request, output *UpdateTemplateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateTemplateAliasInput{}
	}

	output = &UpdateTemplateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplateAlias API operation for Amazon QuickSight.
//
// Updates the template alias of a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplateAlias for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias
func (c *QuickSight) UpdateTemplateAlias(input *UpdateTemplateAliasInput) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	return out, req.Send()
}

// UpdateTemplateAliasWithContext is the same as UpdateTemplateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplateAliasWithContext(ctx aws.Context, input *UpdateTemplateAliasInput, opts ...request.Option) (*UpdateTemplateAliasOutput, error) {
	req, out := c.UpdateTemplateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplatePermissions = "UpdateTemplatePermissions"

// UpdateTemplatePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplatePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplatePermissions for more information on using the UpdateTemplatePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTemplatePermissionsRequest method.
//    req, resp := client.UpdateTemplatePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissionsRequest(input *UpdateTemplatePermissionsInput) (req *request.Request, output *UpdateTemplatePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplatePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/templates/{TemplateId}/permissions",
	}

	if input == nil {
		input = &UpdateTemplatePermissionsInput{}
	}

	output = &UpdateTemplatePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplatePermissions API operation for Amazon QuickSight.
//
// Updates the resource permissions for a template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTemplatePermissions for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Access is throttled.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions
func (c *QuickSight) UpdateTemplatePermissions(input *UpdateTemplatePermissionsInput) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	return out, req.Send()
}

// UpdateTemplatePermissionsWithContext is the same as UpdateTemplatePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplatePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateTemplatePermissionsWithContext(ctx aws.Context, input *UpdateTemplatePermissionsInput, opts ...request.Option) (*UpdateTemplatePermissionsOutput, error) {
	req, out := c.UpdateTemplatePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTheme = "UpdateTheme"

// UpdateThemeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTheme operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTheme for more information on using the UpdateTheme
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThemeRequest method.
//    req, resp := client.UpdateThemeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *QuickSight) UpdateThemeRequest(input *UpdateThemeInput) (req *request.Request, output *UpdateThemeOutput) {
	op := &request.Operation{
		Name:       opUpdateTheme,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}",
	}

	if input == nil {
		input = &UpdateThemeInput{}
	}

	output = &UpdateThemeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTheme API operation for Amazon QuickSight.
//
// Updates a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateTheme for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * LimitExceededException
//   A limit is exceeded.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme
func (c *QuickSight) UpdateTheme(input *UpdateThemeInput) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	return out, req.Send()
}

// UpdateThemeWithContext is the same as UpdateTheme with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTheme for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemeWithContext(ctx aws.Context, input *UpdateThemeInput, opts ...request.Option) (*UpdateThemeOutput, error) {
	req, out := c.UpdateThemeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThemeAlias = "UpdateThemeAlias"

// UpdateThemeAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThemeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThemeAlias for more information on using the UpdateThemeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThemeAliasRequest method.
//    req, resp := client.UpdateThemeAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias
func (c *QuickSight) UpdateThemeAliasRequest(input *UpdateThemeAliasInput) (req *request.Request, output *UpdateThemeAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateThemeAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/aliases/{AliasName}",
	}

	if input == nil {
		input = &UpdateThemeAliasInput{}
	}

	output = &UpdateThemeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThemeAlias API operation for Amazon QuickSight.
//
// Updates an alias of a theme.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateThemeAlias for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceExistsException
//   The resource specified already exists.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias
func (c *QuickSight) UpdateThemeAlias(input *UpdateThemeAliasInput) (*UpdateThemeAliasOutput, error) {
	req, out := c.UpdateThemeAliasRequest(input)
	return out, req.Send()
}

// UpdateThemeAliasWithContext is the same as UpdateThemeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThemeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemeAliasWithContext(ctx aws.Context, input *UpdateThemeAliasInput, opts ...request.Option) (*UpdateThemeAliasOutput, error) {
	req, out := c.UpdateThemeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThemePermissions = "UpdateThemePermissions"

// UpdateThemePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThemePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThemePermissions for more information on using the UpdateThemePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateThemePermissionsRequest method.
//    req, resp := client.UpdateThemePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions
func (c *QuickSight) UpdateThemePermissionsRequest(input *UpdateThemePermissionsInput) (req *request.Request, output *UpdateThemePermissionsOutput) {
	op := &request.Operation{
		Name:       opUpdateThemePermissions,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/themes/{ThemeId}/permissions",
	}

	if input == nil {
		input = &UpdateThemePermissionsInput{}
	}

	output = &UpdateThemePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThemePermissions API operation for Amazon QuickSight.
//
// Updates the resource permissions for a theme. Permissions apply to the action
// to grant or revoke permissions on, for example "quicksight:DescribeTheme".
//
// Theme permissions apply in groupings. Valid groupings include the following
// for the three levels of permissions, which are user, owner, or no permissions:
//
//    * User "quicksight:DescribeTheme" "quicksight:DescribeThemeAlias" "quicksight:ListThemeAliases"
//    "quicksight:ListThemeVersions"
//
//    * Owner "quicksight:DescribeTheme" "quicksight:DescribeThemeAlias" "quicksight:ListThemeAliases"
//    "quicksight:ListThemeVersions" "quicksight:DeleteTheme" "quicksight:UpdateTheme"
//    "quicksight:CreateThemeAlias" "quicksight:DeleteThemeAlias" "quicksight:UpdateThemeAlias"
//    "quicksight:UpdateThemePermissions" "quicksight:DescribeThemePermissions"
//
//    * To specify no permissions, omit the permissions list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateThemePermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * UnsupportedUserEditionException
//   This error indicates that you are calling an operation on an Amazon QuickSight
//   subscription where the edition doesn't include support for that operation.
//   Amazon Amazon QuickSight currently has Standard Edition and Enterprise Edition.
//   Not every operation and capability is available in every edition.
//
//   * InternalFailureException
//   An internal failure occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions
func (c *QuickSight) UpdateThemePermissions(input *UpdateThemePermissionsInput) (*UpdateThemePermissionsOutput, error) {
	req, out := c.UpdateThemePermissionsRequest(input)
	return out, req.Send()
}

// UpdateThemePermissionsWithContext is the same as UpdateThemePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThemePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateThemePermissionsWithContext(ctx aws.Context, input *UpdateThemePermissionsInput, opts ...request.Option) (*UpdateThemePermissionsOutput, error) {
	req, out := c.UpdateThemePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/users/{UserName}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon QuickSight.
//
// Updates an Amazon QuickSight user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon QuickSight's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have access to this item. The provided credentials couldn't be
//   validated. You might not be authorized to carry out the request. Make sure
//   that your account is authorized to use the Amazon QuickSight service, that
//   your policies have the correct permissions, and that you are using the correct
//   access keys.
//
//   * InvalidParameterValueException
//   One or more parameters has a value that isn't valid.
//
//   * ResourceNotFoundException
//   One or more resources can't be found.
//
//   * ThrottlingException
//   Access is throttled.
//
//   * PreconditionNotMetException
//   One or more preconditions aren't met.
//
//   * InternalFailureException
//   An internal failure occurred.
//
//   * ResourceUnavailableException
//   This resource is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser
func (c *QuickSight) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QuickSight) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have access to this item. The provided credentials couldn't be
// validated. You might not be authorized to carry out the request. Make sure
// that your account is authorized to use the Amazon QuickSight service, that
// your policies have the correct permissions, and that you are using the correct
// access keys.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The Amazon Web Services request ID for this request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon QuickSight customizations associated with your Amazon Web Services
// account or a QuickSight namespace in a specific Amazon Web Services Region.
type AccountCustomization struct {
	_ struct{} `type:"structure"`

	// The default email customization template.
	DefaultEmailCustomizationTemplate *string `type:"string"`

	// The default theme for this Amazon QuickSight subscription.
	DefaultTheme *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountCustomization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountCustomization) GoString() string {
	return s.String()
}

// SetDefaultEmailCustomizationTemplate sets the DefaultEmailCustomizationTemplate field's value.
func (s *AccountCustomization) SetDefaultEmailCustomizationTemplate(v string) *AccountCustomization {
	s.DefaultEmailCustomizationTemplate = &v
	return s
}

// SetDefaultTheme sets the DefaultTheme field's value.
func (s *AccountCustomization) SetDefaultTheme(v string) *AccountCustomization {
	s.DefaultTheme = &v
	return s
}

// The Amazon QuickSight settings associated with your Amazon Web Services account.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The "account name" you provided for the Amazon QuickSight subscription in
	// your Amazon Web Services account. You create this name when you sign up for
	// Amazon QuickSight. It is unique in all of Amazon Web Services and it appears
	// only when users sign in.
	AccountName *string `type:"string"`

	// The default Amazon QuickSight namespace for your Amazon Web Services account.
	DefaultNamespace *string `type:"string"`

	// The edition of Amazon QuickSight that you're currently subscribed to: Enterprise
	// edition or Standard edition.
	Edition *string `type:"string" enum:"Edition"`

	// The main notification email for your Amazon QuickSight subscription.
	NotificationEmail *string `type:"string"`

	// A boolean that indicates whether or not public sharing is enabled on an Amazon
	// QuickSight account. For more information about enabling public sharing, see
	// UpdatePublicSharingSettings (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html).
	PublicSharingEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetAccountName sets the AccountName field's value.
func (s *AccountSettings) SetAccountName(v string) *AccountSettings {
	s.AccountName = &v
	return s
}

// SetDefaultNamespace sets the DefaultNamespace field's value.
func (s *AccountSettings) SetDefaultNamespace(v string) *AccountSettings {
	s.DefaultNamespace = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *AccountSettings) SetEdition(v string) *AccountSettings {
	s.Edition = &v
	return s
}

// SetNotificationEmail sets the NotificationEmail field's value.
func (s *AccountSettings) SetNotificationEmail(v string) *AccountSettings {
	s.NotificationEmail = &v
	return s
}

// SetPublicSharingEnabled sets the PublicSharingEnabled field's value.
func (s *AccountSettings) SetPublicSharingEnabled(v bool) *AccountSettings {
	s.PublicSharingEnabled = &v
	return s
}

// The active Identity and Access Management (IAM) policy assignment.
type ActiveIAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// A name for the IAM policy assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	PolicyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveIAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActiveIAMPolicyAssignment) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *ActiveIAMPolicyAssignment) SetAssignmentName(v string) *ActiveIAMPolicyAssignment {
	s.AssignmentName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ActiveIAMPolicyAssignment) SetPolicyArn(v string) *ActiveIAMPolicyAssignment {
	s.PolicyArn = &v
	return s
}

// Ad hoc (one-time) filtering option.
type AdHocFilteringOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus *string `type:"string" enum:"DashboardBehavior"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdHocFilteringOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdHocFilteringOption) GoString() string {
	return s.String()
}

// SetAvailabilityStatus sets the AvailabilityStatus field's value.
func (s *AdHocFilteringOption) SetAvailabilityStatus(v string) *AdHocFilteringOption {
	s.AvailabilityStatus = &v
	return s
}

// The parameters for OpenSearch.
type AmazonElasticsearchParameters struct {
	_ struct{} `type:"structure"`

	// The OpenSearch domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonElasticsearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonElasticsearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonElasticsearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonElasticsearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonElasticsearchParameters) SetDomain(v string) *AmazonElasticsearchParameters {
	s.Domain = &v
	return s
}

// The parameters for OpenSearch.
type AmazonOpenSearchParameters struct {
	_ struct{} `type:"structure"`

	// The OpenSearch domain.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonOpenSearchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonOpenSearchParameters"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *AmazonOpenSearchParameters) SetDomain(v string) *AmazonOpenSearchParameters {
	s.Domain = &v
	return s
}

// Metadata structure for an analysis in Amazon QuickSight
type Analysis struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the analysis.
	Arn *string `type:"string"`

	// The time that the analysis was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ARNs of the datasets of the analysis.
	DataSetArns []*string `type:"list"`

	// Errors associated with the analysis.
	Errors []*AnalysisError `min:"1" type:"list"`

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The descriptive name of the analysis.
	Name *string `min:"1" type:"string"`

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []*Sheet `type:"list"`

	// Status associated with the analysis.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The ARN of the theme of the analysis.
	ThemeArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Analysis) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *Analysis) SetAnalysisId(v string) *Analysis {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Analysis) SetArn(v string) *Analysis {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Analysis) SetCreatedTime(v time.Time) *Analysis {
	s.CreatedTime = &v
	return s
}

// SetDataSetArns sets the DataSetArns field's value.
func (s *Analysis) SetDataSetArns(v []*string) *Analysis {
	s.DataSetArns = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *Analysis) SetErrors(v []*AnalysisError) *Analysis {
	s.Errors = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Analysis) SetLastUpdatedTime(v time.Time) *Analysis {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Analysis) SetName(v string) *Analysis {
	s.Name = &v
	return s
}

// SetSheets sets the Sheets field's value.
func (s *Analysis) SetSheets(v []*Sheet) *Analysis {
	s.Sheets = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Analysis) SetStatus(v string) *Analysis {
	s.Status = &v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *Analysis) SetThemeArn(v string) *Analysis {
	s.ThemeArn = &v
	return s
}

// Analysis error.
type AnalysisError struct {
	_ struct{} `type:"structure"`

	// The message associated with the analysis error.
	Message *string `type:"string"`

	// The type of the analysis error.
	Type *string `type:"string" enum:"AnalysisErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AnalysisError) SetMessage(v string) *AnalysisError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *AnalysisError) SetType(v string) *AnalysisError {
	s.Type = &v
	return s
}

// A filter that you apply when searching for one or more analyses.
type AnalysisSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of the value that you want to use as a filter, for example "Name":
	// "QUICKSIGHT_USER".
	Name *string `type:"string" enum:"AnalysisFilterAttribute"`

	// The comparison operator that you want to use as a filter, for example "Operator":
	// "StringEquals".
	Operator *string `type:"string" enum:"FilterOperator"`

	// The value of the named item, in this case QUICKSIGHT_USER, that you want
	// to use as a filter, for example "Value". An example is "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSearchFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AnalysisSearchFilter) SetName(v string) *AnalysisSearchFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *AnalysisSearchFilter) SetOperator(v string) *AnalysisSearchFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AnalysisSearchFilter) SetValue(v string) *AnalysisSearchFilter {
	s.Value = &v
	return s
}

// The source entity of an analysis.
type AnalysisSourceEntity struct {
	_ struct{} `type:"structure"`

	// The source template for the source entity of the analysis.
	SourceTemplate *AnalysisSourceTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisSourceEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisSourceEntity"}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceTemplate sets the SourceTemplate field's value.
func (s *AnalysisSourceEntity) SetSourceTemplate(v *AnalysisSourceTemplate) *AnalysisSourceEntity {
	s.SourceTemplate = v
	return s
}

// The source template of an analysis.
type AnalysisSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the source template of an analysis.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The dataset references of the source template of an analysis.
	//
	// DataSetReferences is a required field
	DataSetReferences []*DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSourceTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalysisSourceTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalysisSourceTemplate"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DataSetReferences == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AnalysisSourceTemplate) SetArn(v string) *AnalysisSourceTemplate {
	s.Arn = &v
	return s
}

// SetDataSetReferences sets the DataSetReferences field's value.
func (s *AnalysisSourceTemplate) SetDataSetReferences(v []*DataSetReference) *AnalysisSourceTemplate {
	s.DataSetReferences = v
	return s
}

// The summary metadata that describes an analysis.
type AnalysisSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis. This ID displays in the URL.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the analysis.
	Arn *string `type:"string"`

	// The time that the analysis was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the analysis. This name is displayed in the Amazon QuickSight
	// console.
	Name *string `min:"1" type:"string"`

	// The last known status for the analysis.
	Status *string `type:"string" enum:"ResourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalysisSummary) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *AnalysisSummary) SetAnalysisId(v string) *AnalysisSummary {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *AnalysisSummary) SetArn(v string) *AnalysisSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AnalysisSummary) SetCreatedTime(v time.Time) *AnalysisSummary {
	s.CreatedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *AnalysisSummary) SetLastUpdatedTime(v time.Time) *AnalysisSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AnalysisSummary) SetName(v string) *AnalysisSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AnalysisSummary) SetStatus(v string) *AnalysisSummary {
	s.Status = &v
	return s
}

// Information about the dashboard that you want to embed.
type AnonymousUserDashboardEmbeddingConfiguration struct {
	_ struct{} `type:"structure"`

	// The dashboard ID for the dashboard that you want the user to see first. This
	// ID is included in the output URL. When the URL in response is accessed, Amazon
	// QuickSight renders this dashboard.
	//
	// The Amazon Resource Name (ARN) of this dashboard must be included in the
	// AuthorizedResourceArns parameter. Otherwise, the request will fail with InvalidParameterValueException.
	//
	// InitialDashboardId is a required field
	InitialDashboardId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardEmbeddingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserDashboardEmbeddingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserDashboardEmbeddingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserDashboardEmbeddingConfiguration"}
	if s.InitialDashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialDashboardId"))
	}
	if s.InitialDashboardId != nil && len(*s.InitialDashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialDashboardId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialDashboardId sets the InitialDashboardId field's value.
func (s *AnonymousUserDashboardEmbeddingConfiguration) SetInitialDashboardId(v string) *AnonymousUserDashboardEmbeddingConfiguration {
	s.InitialDashboardId = &v
	return s
}

// The type of experience you want to embed. For anonymous users, you can embed
// Amazon QuickSight dashboards.
type AnonymousUserEmbeddingExperienceConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of embedding experience. In this case, Amazon QuickSight dashboards.
	Dashboard *AnonymousUserDashboardEmbeddingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserEmbeddingExperienceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnonymousUserEmbeddingExperienceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnonymousUserEmbeddingExperienceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnonymousUserEmbeddingExperienceConfiguration"}
	if s.Dashboard != nil {
		if err := s.Dashboard.Validate(); err != nil {
			invalidParams.AddNested("Dashboard", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboard sets the Dashboard field's value.
func (s *AnonymousUserEmbeddingExperienceConfiguration) SetDashboard(v *AnonymousUserDashboardEmbeddingConfiguration) *AnonymousUserEmbeddingExperienceConfiguration {
	s.Dashboard = v
	return s
}

// Parameters for Amazon Athena.
type AthenaParameters struct {
	_ struct{} `type:"structure"`

	// The workgroup that Amazon Athena uses.
	WorkGroup *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AthenaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AthenaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AthenaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AthenaParameters"}
	if s.WorkGroup != nil && len(*s.WorkGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *AthenaParameters) SetWorkGroup(v string) *AthenaParameters {
	s.WorkGroup = &v
	return s
}

// Parameters for Amazon Aurora.
type AuroraParameters struct {
	_ struct{} `type:"structure"`

	// Database.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// Host.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// Port.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraParameters) SetDatabase(v string) *AuroraParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraParameters) SetHost(v string) *AuroraParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraParameters) SetPort(v int64) *AuroraParameters {
	s.Port = &v
	return s
}

// Parameters for Amazon Aurora PostgreSQL-Compatible Edition.
type AuroraPostgreSqlParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon Aurora PostgreSQL database to connect to.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The Amazon Aurora PostgreSQL-Compatible host to connect to.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// The port that Amazon Aurora PostgreSQL is listening on.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraPostgreSqlParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuroraPostgreSqlParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuroraPostgreSqlParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuroraPostgreSqlParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *AuroraPostgreSqlParameters) SetDatabase(v string) *AuroraPostgreSqlParameters {
	s.Database = &v
	return s
}

// SetHost sets the Host field's value.
func (s *AuroraPostgreSqlParameters) SetHost(v string) *AuroraPostgreSqlParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AuroraPostgreSqlParameters) SetPort(v int64) *AuroraPostgreSqlParameters {
	s.Port = &v
	return s
}

// The parameters for IoT Analytics.
type AwsIotAnalyticsParameters struct {
	_ struct{} `type:"structure"`

	// Dataset name.
	//
	// DataSetName is a required field
	DataSetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIotAnalyticsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsIotAnalyticsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIotAnalyticsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsIotAnalyticsParameters"}
	if s.DataSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetName"))
	}
	if s.DataSetName != nil && len(*s.DataSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetName sets the DataSetName field's value.
func (s *AwsIotAnalyticsParameters) SetDataSetName(v string) *AwsIotAnalyticsParameters {
	s.DataSetName = &v
	return s
}

// The display options for tile borders for visuals.
type BorderStyle struct {
	_ struct{} `type:"structure"`

	// The option to enable display of borders for visuals.
	Show *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BorderStyle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BorderStyle) GoString() string {
	return s.String()
}

// SetShow sets the Show field's value.
func (s *BorderStyle) SetShow(v bool) *BorderStyle {
	s.Show = &v
	return s
}

// A calculated column for a dataset.
type CalculatedColumn struct {
	_ struct{} `type:"structure"`

	// A unique ID to identify a calculated column. During a dataset update, if
	// the column ID of a calculated column matches that of an existing calculated
	// column, Amazon QuickSight preserves the existing calculated column.
	//
	// ColumnId is a required field
	ColumnId *string `min:"1" type:"string" required:"true"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// An expression that defines the calculated column.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CalculatedColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CalculatedColumn"}
	if s.ColumnId == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnId"))
	}
	if s.ColumnId != nil && len(*s.ColumnId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnId", 1))
	}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnId sets the ColumnId field's value.
func (s *CalculatedColumn) SetColumnId(v string) *CalculatedColumn {
	s.ColumnId = &v
	return s
}

// SetColumnName sets the ColumnName field's value.
func (s *CalculatedColumn) SetColumnName(v string) *CalculatedColumn {
	s.ColumnName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CalculatedColumn) SetExpression(v string) *CalculatedColumn {
	s.Expression = &v
	return s
}

type CancelIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CancelIngestionInput) SetAwsAccountId(v string) *CancelIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CancelIngestionInput) SetDataSetId(v string) *CancelIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CancelIngestionInput) SetIngestionId(v string) *CancelIngestionInput {
	s.IngestionId = &v
	return s
}

type CancelIngestionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data ingestion.
	Arn *string `type:"string"`

	// An ID for the ingestion.
	IngestionId *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelIngestionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CancelIngestionOutput) SetArn(v string) *CancelIngestionOutput {
	s.Arn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CancelIngestionOutput) SetIngestionId(v string) *CancelIngestionOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CancelIngestionOutput) SetRequestId(v string) *CancelIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelIngestionOutput) SetStatus(v int64) *CancelIngestionOutput {
	s.Status = &v
	return s
}

// A transform operation that casts a column to a different type.
type CastColumnTypeOperation struct {
	_ struct{} `type:"structure"`

	// Column name.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// When casting a column from string to datetime type, you can supply a string
	// in a format supported by Amazon QuickSight to denote the source data format.
	Format *string `type:"string"`

	// New column data type.
	//
	// NewColumnType is a required field
	NewColumnType *string `type:"string" required:"true" enum:"ColumnDataType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CastColumnTypeOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CastColumnTypeOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CastColumnTypeOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CastColumnTypeOperation"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.NewColumnType == nil {
		invalidParams.Add(request.NewErrParamRequired("NewColumnType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *CastColumnTypeOperation) SetColumnName(v string) *CastColumnTypeOperation {
	s.ColumnName = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *CastColumnTypeOperation) SetFormat(v string) *CastColumnTypeOperation {
	s.Format = &v
	return s
}

// SetNewColumnType sets the NewColumnType field's value.
func (s *CastColumnTypeOperation) SetNewColumnType(v string) *CastColumnTypeOperation {
	s.NewColumnType = &v
	return s
}

// Metadata that contains a description for a column.
type ColumnDescription struct {
	_ struct{} `type:"structure"`

	// The text of a description for a column.
	Text *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDescription) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *ColumnDescription) SetText(v string) *ColumnDescription {
	s.Text = &v
	return s
}

// Groupings of columns that work together in certain Amazon QuickSight features.
// This is a variant type structure. For this structure to be valid, only one
// of the attributes can be non-null.
type ColumnGroup struct {
	_ struct{} `type:"structure"`

	// Geospatial column group that denotes a hierarchy.
	GeoSpatialColumnGroup *GeoSpatialColumnGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnGroup"}
	if s.GeoSpatialColumnGroup != nil {
		if err := s.GeoSpatialColumnGroup.Validate(); err != nil {
			invalidParams.AddNested("GeoSpatialColumnGroup", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeoSpatialColumnGroup sets the GeoSpatialColumnGroup field's value.
func (s *ColumnGroup) SetGeoSpatialColumnGroup(v *GeoSpatialColumnGroup) *ColumnGroup {
	s.GeoSpatialColumnGroup = v
	return s
}

// A structure describing the name, data type, and geographic role of the columns.
type ColumnGroupColumnSchema struct {
	_ struct{} `type:"structure"`

	// The name of the column group's column schema.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupColumnSchema) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ColumnGroupColumnSchema) SetName(v string) *ColumnGroupColumnSchema {
	s.Name = &v
	return s
}

// The column group schema.
type ColumnGroupSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of schemas for column group columns.
	ColumnGroupColumnSchemaList []*ColumnGroupColumnSchema `type:"list"`

	// The name of the column group schema.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnGroupSchema) GoString() string {
	return s.String()
}

// SetColumnGroupColumnSchemaList sets the ColumnGroupColumnSchemaList field's value.
func (s *ColumnGroupSchema) SetColumnGroupColumnSchemaList(v []*ColumnGroupColumnSchema) *ColumnGroupSchema {
	s.ColumnGroupColumnSchemaList = v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnGroupSchema) SetName(v string) *ColumnGroupSchema {
	s.Name = &v
	return s
}

// A rule defined to grant access on one or more restricted columns. Each dataset
// can have multiple rules. To create a restricted column, you add it to one
// or more rules. Each rule must contain at least one column and at least one
// user or group. To be able to see a restricted column, a user or group needs
// to be added to a rule for that column.
type ColumnLevelPermissionRule struct {
	_ struct{} `type:"structure"`

	// An array of column names.
	ColumnNames []*string `min:"1" type:"list"`

	// An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.
	Principals []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnLevelPermissionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnLevelPermissionRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnLevelPermissionRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnLevelPermissionRule"}
	if s.ColumnNames != nil && len(s.ColumnNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnNames", 1))
	}
	if s.Principals != nil && len(s.Principals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principals", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnNames sets the ColumnNames field's value.
func (s *ColumnLevelPermissionRule) SetColumnNames(v []*string) *ColumnLevelPermissionRule {
	s.ColumnNames = v
	return s
}

// SetPrincipals sets the Principals field's value.
func (s *ColumnLevelPermissionRule) SetPrincipals(v []*string) *ColumnLevelPermissionRule {
	s.Principals = v
	return s
}

// The column schema.
type ColumnSchema struct {
	_ struct{} `type:"structure"`

	// The data type of the column schema.
	DataType *string `type:"string"`

	// The geographic role of the column schema.
	GeographicRole *string `type:"string"`

	// The name of the column schema.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSchema) GoString() string {
	return s.String()
}

// SetDataType sets the DataType field's value.
func (s *ColumnSchema) SetDataType(v string) *ColumnSchema {
	s.DataType = &v
	return s
}

// SetGeographicRole sets the GeographicRole field's value.
func (s *ColumnSchema) SetGeographicRole(v string) *ColumnSchema {
	s.GeographicRole = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColumnSchema) SetName(v string) *ColumnSchema {
	s.Name = &v
	return s
}

// A tag for a column in a TagColumnOperation (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html)
// structure. This is a variant type structure. For this structure to be valid,
// only one of the attributes can be non-null.
type ColumnTag struct {
	_ struct{} `type:"structure"`

	// A description for a column.
	ColumnDescription *ColumnDescription `type:"structure"`

	// A geospatial role for a column.
	ColumnGeographicRole *string `type:"string" enum:"GeoSpatialDataRole"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnTag) GoString() string {
	return s.String()
}

// SetColumnDescription sets the ColumnDescription field's value.
func (s *ColumnTag) SetColumnDescription(v *ColumnDescription) *ColumnTag {
	s.ColumnDescription = v
	return s
}

// SetColumnGeographicRole sets the ColumnGeographicRole field's value.
func (s *ColumnTag) SetColumnGeographicRole(v string) *ColumnTag {
	s.ColumnGeographicRole = &v
	return s
}

// A resource is already in a state that indicates an operation is happening
// that must complete before a new update can be applied.
type ConcurrentUpdatingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentUpdatingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentUpdatingException) GoString() string {
	return s.String()
}

func newErrorConcurrentUpdatingException(v protocol.ResponseMetadata) error {
	return &ConcurrentUpdatingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentUpdatingException) Code() string {
	return "ConcurrentUpdatingException"
}

// Message returns the exception's message.
func (s *ConcurrentUpdatingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentUpdatingException) OrigErr() error {
	return nil
}

func (s *ConcurrentUpdatingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentUpdatingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentUpdatingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The Amazon Web Services request ID for this request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccountCustomizationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon QuickSight customizations you're adding in the current Amazon
	// Web Services Region. You can add these to an Amazon Web Services account
	// and a QuickSight namespace.
	//
	// For example, you can add a default theme by setting AccountCustomization
	// to the midnight theme: "AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT"
	// }. Or, you can add a custom theme by specifying "AccountCustomization": {
	// "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639"
	// }.
	//
	// AccountCustomization is a required field
	AccountCustomization *AccountCustomization `type:"structure" required:"true"`

	// The ID for the Amazon Web Services account that you want to customize Amazon
	// QuickSight for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Amazon QuickSight namespace that you want to add customizations to.
	Namespace *string `location:"querystring" locationName:"namespace" type:"string"`

	// A list of the tags that you want to attach to this resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountCustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountCustomizationInput"}
	if s.AccountCustomization == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountCustomization"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountCustomization sets the AccountCustomization field's value.
func (s *CreateAccountCustomizationInput) SetAccountCustomization(v *AccountCustomization) *CreateAccountCustomizationInput {
	s.AccountCustomization = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAccountCustomizationInput) SetAwsAccountId(v string) *CreateAccountCustomizationInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateAccountCustomizationInput) SetNamespace(v string) *CreateAccountCustomizationInput {
	s.Namespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccountCustomizationInput) SetTags(v []*Tag) *CreateAccountCustomizationInput {
	s.Tags = v
	return s
}

type CreateAccountCustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon QuickSight customizations you're adding in the current Amazon
	// Web Services Region.
	AccountCustomization *AccountCustomization `type:"structure"`

	// The Amazon Resource Name (ARN) for the customization that you created for
	// this Amazon Web Services account.
	Arn *string `type:"string"`

	// The ID for the Amazon Web Services account that you want to customize Amazon
	// QuickSight for.
	AwsAccountId *string `min:"12" type:"string"`

	// The namespace associated with the customization you're creating.
	Namespace *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountCustomizationOutput) GoString() string {
	return s.String()
}

// SetAccountCustomization sets the AccountCustomization field's value.
func (s *CreateAccountCustomizationOutput) SetAccountCustomization(v *AccountCustomization) *CreateAccountCustomizationOutput {
	s.AccountCustomization = v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateAccountCustomizationOutput) SetArn(v string) *CreateAccountCustomizationOutput {
	s.Arn = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAccountCustomizationOutput) SetAwsAccountId(v string) *CreateAccountCustomizationOutput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateAccountCustomizationOutput) SetNamespace(v string) *CreateAccountCustomizationOutput {
	s.Namespace = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateAccountCustomizationOutput) SetRequestId(v string) *CreateAccountCustomizationOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAccountCustomizationOutput) SetStatus(v int64) *CreateAccountCustomizationOutput {
	s.Status = &v
	return s
}

type CreateAnalysisInput struct {
	_ struct{} `type:"structure"`

	// The ID for the analysis that you're creating. This ID displays in the URL
	// of the analysis.
	//
	// AnalysisId is a required field
	AnalysisId *string `location:"uri" locationName:"AnalysisId" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account where you are creating an analysis.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A descriptive name for the analysis that you're creating. This name displays
	// for the analysis in the Amazon QuickSight console.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The parameter names and override values that you want to use. An analysis
	// can have any parameter type, and some parameters might accept multiple values.
	Parameters *Parameters `type:"structure"`

	// A structure that describes the principals and the resource-level permissions
	// on an analysis. You can use the Permissions structure to grant permissions
	// by providing a list of Identity and Access Management (IAM) action information
	// for each principal listed by Amazon Resource Name (ARN).
	//
	// To specify no permissions, omit Permissions.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// A source entity to use for the analysis that you're creating. This metadata
	// structure contains details that describe a source template and one or more
	// datasets.
	//
	// SourceEntity is a required field
	SourceEntity *AnalysisSourceEntity `type:"structure" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the analysis.
	Tags []*Tag `min:"1" type:"list"`

	// The ARN for the theme to apply to the analysis that you're creating. To see
	// the theme in the Amazon QuickSight console, make sure that you have access
	// to it.
	ThemeArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAnalysisInput"}
	if s.AnalysisId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisId"))
	}
	if s.AnalysisId != nil && len(*s.AnalysisId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisId", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *CreateAnalysisInput) SetAnalysisId(v string) *CreateAnalysisInput {
	s.AnalysisId = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateAnalysisInput) SetAwsAccountId(v string) *CreateAnalysisInput {
	s.AwsAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAnalysisInput) SetName(v string) *CreateAnalysisInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateAnalysisInput) SetParameters(v *Parameters) *CreateAnalysisInput {
	s.Parameters = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateAnalysisInput) SetPermissions(v []*ResourcePermission) *CreateAnalysisInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateAnalysisInput) SetSourceEntity(v *AnalysisSourceEntity) *CreateAnalysisInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAnalysisInput) SetTags(v []*Tag) *CreateAnalysisInput {
	s.Tags = v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *CreateAnalysisInput) SetThemeArn(v string) *CreateAnalysisInput {
	s.ThemeArn = &v
	return s
}

type CreateAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the analysis.
	AnalysisId *string `min:"1" type:"string"`

	// The ARN for the analysis.
	Arn *string `type:"string"`

	// The status of the creation of the analysis.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *CreateAnalysisOutput) SetAnalysisId(v string) *CreateAnalysisOutput {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateAnalysisOutput) SetArn(v string) *CreateAnalysisOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateAnalysisOutput) SetCreationStatus(v string) *CreateAnalysisOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateAnalysisOutput) SetRequestId(v string) *CreateAnalysisOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAnalysisOutput) SetStatus(v int64) *CreateAnalysisOutput {
	s.Status = &v
	return s
}

// A transform operation that creates calculated columns. Columns created in
// one such operation form a lexical closure.
type CreateColumnsOperation struct {
	_ struct{} `type:"structure"`

	// Calculated columns to create.
	//
	// Columns is a required field
	Columns []*CalculatedColumn `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateColumnsOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateColumnsOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateColumnsOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateColumnsOperation"}
	if s.Columns == nil {
		invalidParams.Add(request.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *CreateColumnsOperation) SetColumns(v []*CalculatedColumn) *CreateColumnsOperation {
	s.Columns = v
	return s
}

type CreateDashboardInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account where you want to create the dashboard.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to the IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// Options for publishing the dashboard when you create it:
	//
	//    * AvailabilityStatus for AdHocFilteringOption - This status can be either
	//    ENABLED or DISABLED. When this is set to DISABLED, Amazon QuickSight disables
	//    the left filter pane on the published dashboard, which can be used for
	//    ad hoc (one-time) filtering. This option is ENABLED by default.
	//
	//    * AvailabilityStatus for ExportToCSVOption - This status can be either
	//    ENABLED or DISABLED. The visual option to export data to .CSV format isn't
	//    enabled when this is set to DISABLED. This option is ENABLED by default.
	//
	//    * VisibilityState for SheetControlsOption - This visibility state can
	//    be either COLLAPSED or EXPANDED. This option is COLLAPSED by default.
	DashboardPublishOptions *DashboardPublishOptions `type:"structure"`

	// The display name of the dashboard.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The parameters for the creation of the dashboard, which you want to use to
	// override the default settings. A dashboard can have any type of parameters,
	// and some parameters might accept multiple values.
	Parameters *Parameters `type:"structure"`

	// A structure that contains the permissions of the dashboard. You can use this
	// structure for granting permissions by providing a list of IAM action information
	// for each principal ARN.
	//
	// To specify no permissions, omit the permissions list.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The entity that you are using as a source when you create the dashboard.
	// In SourceEntity, you specify the type of object you're using as source. You
	// can only create a dashboard from a template, so you use a SourceTemplate
	// entity. If you need to create a dashboard from an analysis, first convert
	// the analysis to a template by using the CreateTemplate (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html)
	// API operation. For SourceTemplate, specify the Amazon Resource Name (ARN)
	// of the source template. The SourceTemplateARN can contain any Amazon Web
	// Services account and any Amazon QuickSight-supported Amazon Web Services
	// Region.
	//
	// Use the DataSetReferences entity within SourceTemplate to list the replacement
	// datasets for the placeholders listed in the original. The schema in each
	// dataset must match its placeholder.
	//
	// SourceEntity is a required field
	SourceEntity *DashboardSourceEntity `type:"structure" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dashboard.
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the theme that is being used for this dashboard.
	// If you add a value for this field, it overrides the value that is used in
	// the source entity. The theme ARN must exist in the same Amazon Web Services
	// account where you create the dashboard.
	ThemeArn *string `type:"string"`

	// A description for the first version of the dashboard being created.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDashboardInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDashboardInput) SetAwsAccountId(v string) *CreateDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardInput) SetDashboardId(v string) *CreateDashboardInput {
	s.DashboardId = &v
	return s
}

// SetDashboardPublishOptions sets the DashboardPublishOptions field's value.
func (s *CreateDashboardInput) SetDashboardPublishOptions(v *DashboardPublishOptions) *CreateDashboardInput {
	s.DashboardPublishOptions = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDashboardInput) SetName(v string) *CreateDashboardInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateDashboardInput) SetParameters(v *Parameters) *CreateDashboardInput {
	s.Parameters = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDashboardInput) SetPermissions(v []*ResourcePermission) *CreateDashboardInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateDashboardInput) SetSourceEntity(v *DashboardSourceEntity) *CreateDashboardInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDashboardInput) SetTags(v []*Tag) *CreateDashboardInput {
	s.Tags = v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *CreateDashboardInput) SetThemeArn(v string) *CreateDashboardInput {
	s.ThemeArn = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateDashboardInput) SetVersionDescription(v string) *CreateDashboardInput {
	s.VersionDescription = &v
	return s
}

type CreateDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the dashboard.
	Arn *string `type:"string"`

	// The status of the dashboard creation request.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ARN of the dashboard, including the version number of the first version
	// that is created.
	VersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDashboardOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDashboardOutput) SetArn(v string) *CreateDashboardOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateDashboardOutput) SetCreationStatus(v string) *CreateDashboardOutput {
	s.CreationStatus = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *CreateDashboardOutput) SetDashboardId(v string) *CreateDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDashboardOutput) SetRequestId(v string) *CreateDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDashboardOutput) SetStatus(v int64) *CreateDashboardOutput {
	s.Status = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateDashboardOutput) SetVersionArn(v string) *CreateDashboardOutput {
	s.VersionArn = &v
	return s
}

type CreateDataSetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Groupings of columns that work together in certain Amazon QuickSight features.
	// Currently, only geospatial hierarchy is supported.
	ColumnGroups []*ColumnGroup `min:"1" type:"list"`

	// A set of one or more definitions of a ColumnLevelPermissionRule (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html) .
	ColumnLevelPermissionRules []*ColumnLevelPermissionRule `min:"1" type:"list"`

	// An ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	//
	// DataSetId is a required field
	DataSetId *string `type:"string" required:"true"`

	// The usage configuration to apply to child datasets that reference this dataset
	// as a source.
	DataSetUsageConfiguration *DataSetUsageConfiguration `type:"structure"`

	// The folder that contains fields and nested subfolders for your dataset.
	FieldFolders map[string]*FieldFolder `type:"map"`

	// Indicates whether you want to import the data into SPICE.
	//
	// ImportMode is a required field
	ImportMode *string `type:"string" required:"true" enum:"DataSetImportMode"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]*LogicalTable `min:"1" type:"map"`

	// The display name for the dataset.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the dataset.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	//
	// PhysicalTableMap is a required field
	PhysicalTableMap map[string]*PhysicalTable `type:"map" required:"true"`

	// The row-level security configuration for the data that you want to create.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`

	// The configuration of tags on a dataset to set row-level security. Row-level
	// security tags are currently supported for anonymous embedding only.
	RowLevelPermissionTagConfiguration *RowLevelPermissionTagConfiguration `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the dataset.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ColumnGroups != nil && len(s.ColumnGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnGroups", 1))
	}
	if s.ColumnLevelPermissionRules != nil && len(s.ColumnLevelPermissionRules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnLevelPermissionRules", 1))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.ImportMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportMode"))
	}
	if s.LogicalTableMap != nil && len(s.LogicalTableMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogicalTableMap", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.PhysicalTableMap == nil {
		invalidParams.Add(request.NewErrParamRequired("PhysicalTableMap"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ColumnGroups != nil {
		for i, v := range s.ColumnGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColumnLevelPermissionRules != nil {
		for i, v := range s.ColumnLevelPermissionRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ColumnLevelPermissionRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LogicalTableMap != nil {
		for i, v := range s.LogicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LogicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PhysicalTableMap != nil {
		for i, v := range s.PhysicalTableMap {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhysicalTableMap", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RowLevelPermissionDataSet != nil {
		if err := s.RowLevelPermissionDataSet.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionDataSet", err.(request.ErrInvalidParams))
		}
	}
	if s.RowLevelPermissionTagConfiguration != nil {
		if err := s.RowLevelPermissionTagConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RowLevelPermissionTagConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDataSetInput) SetAwsAccountId(v string) *CreateDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetColumnGroups sets the ColumnGroups field's value.
func (s *CreateDataSetInput) SetColumnGroups(v []*ColumnGroup) *CreateDataSetInput {
	s.ColumnGroups = v
	return s
}

// SetColumnLevelPermissionRules sets the ColumnLevelPermissionRules field's value.
func (s *CreateDataSetInput) SetColumnLevelPermissionRules(v []*ColumnLevelPermissionRule) *CreateDataSetInput {
	s.ColumnLevelPermissionRules = v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateDataSetInput) SetDataSetId(v string) *CreateDataSetInput {
	s.DataSetId = &v
	return s
}

// SetDataSetUsageConfiguration sets the DataSetUsageConfiguration field's value.
func (s *CreateDataSetInput) SetDataSetUsageConfiguration(v *DataSetUsageConfiguration) *CreateDataSetInput {
	s.DataSetUsageConfiguration = v
	return s
}

// SetFieldFolders sets the FieldFolders field's value.
func (s *CreateDataSetInput) SetFieldFolders(v map[string]*FieldFolder) *CreateDataSetInput {
	s.FieldFolders = v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *CreateDataSetInput) SetImportMode(v string) *CreateDataSetInput {
	s.ImportMode = &v
	return s
}

// SetLogicalTableMap sets the LogicalTableMap field's value.
func (s *CreateDataSetInput) SetLogicalTableMap(v map[string]*LogicalTable) *CreateDataSetInput {
	s.LogicalTableMap = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSetInput) SetName(v string) *CreateDataSetInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDataSetInput) SetPermissions(v []*ResourcePermission) *CreateDataSetInput {
	s.Permissions = v
	return s
}

// SetPhysicalTableMap sets the PhysicalTableMap field's value.
func (s *CreateDataSetInput) SetPhysicalTableMap(v map[string]*PhysicalTable) *CreateDataSetInput {
	s.PhysicalTableMap = v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *CreateDataSetInput) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *CreateDataSetInput {
	s.RowLevelPermissionDataSet = v
	return s
}

// SetRowLevelPermissionTagConfiguration sets the RowLevelPermissionTagConfiguration field's value.
func (s *CreateDataSetInput) SetRowLevelPermissionTagConfiguration(v *RowLevelPermissionTagConfiguration) *CreateDataSetInput {
	s.RowLevelPermissionTagConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSetInput) SetTags(v []*Tag) *CreateDataSetInput {
	s.Tags = v
	return s
}

type CreateDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	DataSetId *string `type:"string"`

	// The ARN for the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE.
	IngestionArn *string `type:"string"`

	// The ID of the ingestion, which is triggered as a result of dataset creation
	// if the import mode is SPICE.
	IngestionId *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSetOutput) SetArn(v string) *CreateDataSetOutput {
	s.Arn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateDataSetOutput) SetDataSetId(v string) *CreateDataSetOutput {
	s.DataSetId = &v
	return s
}

// SetIngestionArn sets the IngestionArn field's value.
func (s *CreateDataSetOutput) SetIngestionArn(v string) *CreateDataSetOutput {
	s.IngestionArn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateDataSetOutput) SetIngestionId(v string) *CreateDataSetOutput {
	s.IngestionId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDataSetOutput) SetRequestId(v string) *CreateDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSetOutput) SetStatus(v int64) *CreateDataSetOutput {
	s.Status = &v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The credentials Amazon QuickSight that uses to connect to your underlying
	// source. Currently, only credentials based on user name and password are supported.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceInput's
	// String and GoString methods.
	Credentials *DataSourceCredentials `type:"structure" sensitive:"true"`

	// An ID for the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	//
	// DataSourceId is a required field
	DataSourceId *string `type:"string" required:"true"`

	// The parameters that Amazon QuickSight uses to connect to your underlying
	// source.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// A display name for the data source.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of resource permissions on the data source.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the data source.
	Tags []*Tag `min:"1" type:"list"`

	// The type of the data source. To return a list of all data sources, use ListDataSources.
	//
	// Use AMAZON_ELASTICSEARCH for Amazon OpenSearch Service.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DataSourceType"`

	// Use this parameter only when you want Amazon QuickSight to use a VPC connection
	// when connecting to your underlying source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSourceParameters != nil {
		if err := s.DataSourceParameters.Validate(); err != nil {
			invalidParams.AddNested("DataSourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConnectionProperties != nil {
		if err := s.VpcConnectionProperties.Validate(); err != nil {
			invalidParams.AddNested("VpcConnectionProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateDataSourceInput) SetAwsAccountId(v string) *CreateDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *CreateDataSourceInput) SetCredentials(v *DataSourceCredentials) *CreateDataSourceInput {
	s.Credentials = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceInput) SetDataSourceId(v string) *CreateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *CreateDataSourceInput) SetDataSourceParameters(v *DataSourceParameters) *CreateDataSourceInput {
	s.DataSourceParameters = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateDataSourceInput) SetPermissions(v []*ResourcePermission) *CreateDataSourceInput {
	s.Permissions = v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *CreateDataSourceInput) SetSslProperties(v *SslProperties) *CreateDataSourceInput {
	s.SslProperties = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataSourceInput) SetTags(v []*Tag) *CreateDataSourceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *CreateDataSourceInput) SetVpcConnectionProperties(v *VpcConnectionProperties) *CreateDataSourceInput {
	s.VpcConnectionProperties = v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string `type:"string"`

	// The status of creating the data source.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	DataSourceId *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataSourceOutput) SetArn(v string) *CreateDataSourceOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateDataSourceOutput) SetCreationStatus(v string) *CreateDataSourceOutput {
	s.CreationStatus = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *CreateDataSourceOutput) SetDataSourceId(v string) *CreateDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateDataSourceOutput) SetRequestId(v string) *CreateDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSourceOutput) SetStatus(v int64) *CreateDataSourceOutput {
	s.Status = &v
	return s
}

type CreateFolderInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account where you want to create the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The type of folder. By default, folderType is SHARED.
	FolderType *string `type:"string" enum:"FolderType"`

	// The name of the folder.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the parent folder.
	//
	// ParentFolderArn can be null. An empty parentFolderArn creates a root-level
	// folder.
	ParentFolderArn *string `type:"string"`

	// A structure that describes the principals and the resource-level permissions
	// of a folder.
	//
	// To specify no permissions, omit Permissions.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// Tags for the folder.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFolderInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateFolderInput) SetAwsAccountId(v string) *CreateFolderInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *CreateFolderInput) SetFolderId(v string) *CreateFolderInput {
	s.FolderId = &v
	return s
}

// SetFolderType sets the FolderType field's value.
func (s *CreateFolderInput) SetFolderType(v string) *CreateFolderInput {
	s.FolderType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFolderInput) SetName(v string) *CreateFolderInput {
	s.Name = &v
	return s
}

// SetParentFolderArn sets the ParentFolderArn field's value.
func (s *CreateFolderInput) SetParentFolderArn(v string) *CreateFolderInput {
	s.ParentFolderArn = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateFolderInput) SetPermissions(v []*ResourcePermission) *CreateFolderInput {
	s.Permissions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFolderInput) SetTags(v []*Tag) *CreateFolderInput {
	s.Tags = v
	return s
}

type CreateFolderMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The ID of the asset (the dashboard, analysis, or dataset).
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"MemberId" min:"1" type:"string" required:"true"`

	// The type of the member, including DASHBOARD, ANALYSIS, and DATASET.
	//
	// MemberType is a required field
	MemberType *string `location:"uri" locationName:"MemberType" type:"string" required:"true" enum:"MemberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFolderMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFolderMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.MemberType == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberType"))
	}
	if s.MemberType != nil && len(*s.MemberType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateFolderMembershipInput) SetAwsAccountId(v string) *CreateFolderMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *CreateFolderMembershipInput) SetFolderId(v string) *CreateFolderMembershipInput {
	s.FolderId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *CreateFolderMembershipInput) SetMemberId(v string) *CreateFolderMembershipInput {
	s.MemberId = &v
	return s
}

// SetMemberType sets the MemberType field's value.
func (s *CreateFolderMembershipInput) SetMemberType(v string) *CreateFolderMembershipInput {
	s.MemberType = &v
	return s
}

type CreateFolderMembershipOutput struct {
	_ struct{} `type:"structure"`

	// Information about the member in the folder.
	FolderMember *FolderMember `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderMembershipOutput) GoString() string {
	return s.String()
}

// SetFolderMember sets the FolderMember field's value.
func (s *CreateFolderMembershipOutput) SetFolderMember(v *FolderMember) *CreateFolderMembershipOutput {
	s.FolderMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateFolderMembershipOutput) SetRequestId(v string) *CreateFolderMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFolderMembershipOutput) SetStatus(v int64) *CreateFolderMembershipOutput {
	s.Status = &v
	return s
}

type CreateFolderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the newly created folder.
	Arn *string `type:"string"`

	// The folder ID for the newly created folder.
	FolderId *string `min:"1" type:"string"`

	// The request ID for the newly created folder.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFolderOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFolderOutput) SetArn(v string) *CreateFolderOutput {
	s.Arn = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *CreateFolderOutput) SetFolderId(v string) *CreateFolderOutput {
	s.FolderId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateFolderOutput) SetRequestId(v string) *CreateFolderOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFolderOutput) SetStatus(v int64) *CreateFolderOutput {
	s.Status = &v
	return s
}

// The request object for this operation.
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A description for the group that you want to create.
	Description *string `min:"1" type:"string"`

	// A name for the group that you want to create.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The namespace that you want the group to be a part of.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupInput) SetAwsAccountId(v string) *CreateGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupInput) SetNamespace(v string) *CreateGroupInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to add the user to.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to add to the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace that you want the user to be a part of.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateGroupMembershipInput) SetAwsAccountId(v string) *CreateGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupMembershipInput) SetGroupName(v string) *CreateGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *CreateGroupMembershipInput) SetMemberName(v string) *CreateGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateGroupMembershipInput) SetNamespace(v string) *CreateGroupMembershipInput {
	s.Namespace = &v
	return s
}

type CreateGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The group member.
	GroupMember *GroupMember `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetGroupMember sets the GroupMember field's value.
func (s *CreateGroupMembershipOutput) SetGroupMember(v *GroupMember) *CreateGroupMembershipOutput {
	s.GroupMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupMembershipOutput) SetRequestId(v string) *CreateGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupMembershipOutput) SetStatus(v int64) *CreateGroupMembershipOutput {
	s.Status = &v
	return s
}

// The response object for this operation.
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateGroupOutput) SetRequestId(v string) *CreateGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupOutput) SetStatus(v int64) *CreateGroupOutput {
	s.Status = &v
	return s
}

type CreateIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment, also called a rule. It must be unique within
	// an Amazon Web Services account.
	//
	// AssignmentName is a required field
	AssignmentName *string `min:"1" type:"string" required:"true"`

	// The status of the assignment. Possible values are as follows:
	//
	//    * ENABLED - Anything specified in this assignment is used when creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used when creating the data source.
	//
	//    * DRAFT - This assignment is an unfinished draft and isn't used when creating
	//    the data source.
	//
	// AssignmentStatus is a required field
	AssignmentStatus *string `type:"string" required:"true" enum:"AssignmentStatus"`

	// The ID of the Amazon Web Services account where you want to assign an IAM
	// policy to Amazon QuickSight users or groups.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Amazon QuickSight users, groups, or both that you want to assign the
	// policy to.
	Identities map[string][]*string `type:"map"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The ARN for the IAM policy to apply to the Amazon QuickSight users and groups
	// specified in this assignment.
	PolicyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AssignmentStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentStatus"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAssignmentName(v string) *CreateIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAssignmentStatus(v string) *CreateIAMPolicyAssignmentInput {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateIAMPolicyAssignmentInput) SetAwsAccountId(v string) *CreateIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *CreateIAMPolicyAssignmentInput) SetIdentities(v map[string][]*string) *CreateIAMPolicyAssignmentInput {
	s.Identities = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateIAMPolicyAssignmentInput) SetNamespace(v string) *CreateIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateIAMPolicyAssignmentInput) SetPolicyArn(v string) *CreateIAMPolicyAssignmentInput {
	s.PolicyArn = &v
	return s
}

type CreateIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the assignment.
	AssignmentId *string `type:"string"`

	// The name of the assignment. This name must be unique within the Amazon Web
	// Services account.
	AssignmentName *string `min:"1" type:"string"`

	// The status of the assignment. Possible values are as follows:
	//
	//    * ENABLED - Anything specified in this assignment is used when creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used when creating the data source.
	//
	//    * DRAFT - This assignment is an unfinished draft and isn't used when creating
	//    the data source.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// The Amazon QuickSight users, groups, or both that the IAM policy is assigned
	// to.
	Identities map[string][]*string `type:"map"`

	// The ARN for the IAM policy that is applied to the Amazon QuickSight users
	// and groups specified in this assignment.
	PolicyArn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentId(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentId = &v
	return s
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentName(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetAssignmentStatus(v string) *CreateIAMPolicyAssignmentOutput {
	s.AssignmentStatus = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetIdentities(v map[string][]*string) *CreateIAMPolicyAssignmentOutput {
	s.Identities = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetPolicyArn(v string) *CreateIAMPolicyAssignmentOutput {
	s.PolicyArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetRequestId(v string) *CreateIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateIAMPolicyAssignmentOutput) SetStatus(v int64) *CreateIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type CreateIngestionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`

	// The type of ingestion that you want to create.
	IngestionType *string `type:"string" enum:"IngestionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateIngestionInput) SetAwsAccountId(v string) *CreateIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *CreateIngestionInput) SetDataSetId(v string) *CreateIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateIngestionInput) SetIngestionId(v string) *CreateIngestionInput {
	s.IngestionId = &v
	return s
}

// SetIngestionType sets the IngestionType field's value.
func (s *CreateIngestionInput) SetIngestionType(v string) *CreateIngestionInput {
	s.IngestionType = &v
	return s
}

type CreateIngestionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the data ingestion.
	Arn *string `type:"string"`

	// An ID for the ingestion.
	IngestionId *string `min:"1" type:"string"`

	// The ingestion status.
	IngestionStatus *string `type:"string" enum:"IngestionStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIngestionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateIngestionOutput) SetArn(v string) *CreateIngestionOutput {
	s.Arn = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *CreateIngestionOutput) SetIngestionId(v string) *CreateIngestionOutput {
	s.IngestionId = &v
	return s
}

// SetIngestionStatus sets the IngestionStatus field's value.
func (s *CreateIngestionOutput) SetIngestionStatus(v string) *CreateIngestionOutput {
	s.IngestionStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateIngestionOutput) SetRequestId(v string) *CreateIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateIngestionOutput) SetStatus(v int64) *CreateIngestionOutput {
	s.Status = &v
	return s
}

type CreateNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that you want to create the Amazon
	// QuickSight namespace in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// Specifies the type of your user identity directory. Currently, this supports
	// users with an identity type of QUICKSIGHT.
	//
	// IdentityStore is a required field
	IdentityStore *string `type:"string" required:"true" enum:"IdentityStore"`

	// The name that you want to use to describe the new namespace.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The tags that you want to associate with the namespace that you're creating.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNamespaceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.IdentityStore == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStore"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateNamespaceInput) SetAwsAccountId(v string) *CreateNamespaceInput {
	s.AwsAccountId = &v
	return s
}

// SetIdentityStore sets the IdentityStore field's value.
func (s *CreateNamespaceInput) SetIdentityStore(v string) *CreateNamespaceInput {
	s.IdentityStore = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateNamespaceInput) SetNamespace(v string) *CreateNamespaceInput {
	s.Namespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNamespaceInput) SetTags(v []*Tag) *CreateNamespaceInput {
	s.Tags = v
	return s
}

type CreateNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon QuickSight namespace you created.
	Arn *string `type:"string"`

	// The Amazon Web Services Region; that you want to use for the free SPICE capacity
	// for the new namespace. This is set to the region that you run CreateNamespace
	// in.
	CapacityRegion *string `type:"string"`

	// The status of the creation of the namespace. This is an asynchronous process.
	// A status of CREATED means that your namespace is ready to use. If an error
	// occurs, it indicates if the process is retryable or non-retryable. In the
	// case of a non-retryable error, refer to the error message for follow-up tasks.
	CreationStatus *string `type:"string" enum:"NamespaceStatus"`

	// Specifies the type of your user identity directory. Currently, this supports
	// users with an identity type of QUICKSIGHT.
	IdentityStore *string `type:"string" enum:"IdentityStore"`

	// The name of the new namespace that you created.
	Name *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateNamespaceOutput) SetArn(v string) *CreateNamespaceOutput {
	s.Arn = &v
	return s
}

// SetCapacityRegion sets the CapacityRegion field's value.
func (s *CreateNamespaceOutput) SetCapacityRegion(v string) *CreateNamespaceOutput {
	s.CapacityRegion = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateNamespaceOutput) SetCreationStatus(v string) *CreateNamespaceOutput {
	s.CreationStatus = &v
	return s
}

// SetIdentityStore sets the IdentityStore field's value.
func (s *CreateNamespaceOutput) SetIdentityStore(v string) *CreateNamespaceOutput {
	s.IdentityStore = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNamespaceOutput) SetName(v string) *CreateNamespaceOutput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateNamespaceOutput) SetRequestId(v string) *CreateNamespaceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateNamespaceOutput) SetStatus(v int64) *CreateNamespaceOutput {
	s.Status = &v
	return s
}

type CreateTemplateAliasInput struct {
	_ struct{} `type:"structure"`

	// The name that you want to give to the template alias that you're creating.
	// Don't start the alias name with the $ character. Alias names that start with
	// $ are reserved by Amazon QuickSight.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the template that
	// you creating an alias for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// The version number of the template.
	//
	// TemplateVersionNumber is a required field
	TemplateVersionNumber *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.TemplateVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateVersionNumber"))
	}
	if s.TemplateVersionNumber != nil && *s.TemplateVersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TemplateVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateTemplateAliasInput) SetAliasName(v string) *CreateTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateTemplateAliasInput) SetAwsAccountId(v string) *CreateTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateAliasInput) SetTemplateId(v string) *CreateTemplateAliasInput {
	s.TemplateId = &v
	return s
}

// SetTemplateVersionNumber sets the TemplateVersionNumber field's value.
func (s *CreateTemplateAliasInput) SetTemplateVersionNumber(v int64) *CreateTemplateAliasInput {
	s.TemplateVersionNumber = &v
	return s
}

type CreateTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateTemplateAliasOutput) SetRequestId(v string) *CreateTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateAliasOutput) SetStatus(v int64) *CreateTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateAlias sets the TemplateAlias field's value.
func (s *CreateTemplateAliasOutput) SetTemplateAlias(v *TemplateAlias) *CreateTemplateAliasOutput {
	s.TemplateAlias = v
	return s
}

type CreateTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that the group is in. You use
	// the ID for the Amazon Web Services account that contains your Amazon QuickSight
	// account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// A display name for the template.
	Name *string `min:"1" type:"string"`

	// A list of resource permissions to be set on the template.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The entity that you are using as a source when you create the template. In
	// SourceEntity, you specify the type of object you're using as source: SourceTemplate
	// for a template or SourceAnalysis for an analysis. Both of these require an
	// Amazon Resource Name (ARN). For SourceTemplate, specify the ARN of the source
	// template. For SourceAnalysis, specify the ARN of the source analysis. The
	// SourceTemplate ARN can contain any Amazon Web Services account and any Amazon
	// QuickSight-supported Amazon Web Services Region.
	//
	// Use the DataSetReferences entity within SourceTemplate or SourceAnalysis
	// to list the replacement datasets for the placeholders listed in the original.
	// The schema in each dataset must match its placeholder.
	//
	// SourceEntity is a required field
	SourceEntity *TemplateSourceEntity `type:"structure" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	Tags []*Tag `min:"1" type:"list"`

	// An ID for the template that you want to create. This template is unique per
	// Amazon Web Services Region; in each Amazon Web Services account.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// A description of the current template version being created. This API operation
	// creates the first version of the template. Every time UpdateTemplate is called,
	// a new version is created. Each version of the template maintains a description
	// of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.SourceEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEntity"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SourceEntity != nil {
		if err := s.SourceEntity.Validate(); err != nil {
			invalidParams.AddNested("SourceEntity", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateTemplateInput) SetAwsAccountId(v string) *CreateTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTemplateInput) SetName(v string) *CreateTemplateInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateTemplateInput) SetPermissions(v []*ResourcePermission) *CreateTemplateInput {
	s.Permissions = v
	return s
}

// SetSourceEntity sets the SourceEntity field's value.
func (s *CreateTemplateInput) SetSourceEntity(v *TemplateSourceEntity) *CreateTemplateInput {
	s.SourceEntity = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTemplateInput) SetTags(v []*Tag) *CreateTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateInput) SetTemplateId(v string) *CreateTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateTemplateInput) SetVersionDescription(v string) *CreateTemplateInput {
	s.VersionDescription = &v
	return s
}

type CreateTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The ARN for the template.
	Arn *string `type:"string"`

	// The template creation status.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID of the template.
	TemplateId *string `min:"1" type:"string"`

	// The ARN for the template, including the version information of the first
	// version.
	VersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTemplateOutput) SetArn(v string) *CreateTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateTemplateOutput) SetCreationStatus(v string) *CreateTemplateOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateTemplateOutput) SetRequestId(v string) *CreateTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTemplateOutput) SetStatus(v int64) *CreateTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *CreateTemplateOutput) SetTemplateId(v string) *CreateTemplateOutput {
	s.TemplateId = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateTemplateOutput) SetVersionArn(v string) *CreateTemplateOutput {
	s.VersionArn = &v
	return s
}

type CreateThemeAliasInput struct {
	_ struct{} `type:"structure"`

	// The name that you want to give to the theme alias that you are creating.
	// The alias name can't begin with a $. Alias names that start with $ are reserved
	// by Amazon QuickSight.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the theme for the
	// new theme alias.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the theme alias.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// The version number of the theme.
	//
	// ThemeVersionNumber is a required field
	ThemeVersionNumber *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThemeAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}
	if s.ThemeVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeVersionNumber"))
	}
	if s.ThemeVersionNumber != nil && *s.ThemeVersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThemeVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *CreateThemeAliasInput) SetAliasName(v string) *CreateThemeAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateThemeAliasInput) SetAwsAccountId(v string) *CreateThemeAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *CreateThemeAliasInput) SetThemeId(v string) *CreateThemeAliasInput {
	s.ThemeId = &v
	return s
}

// SetThemeVersionNumber sets the ThemeVersionNumber field's value.
func (s *CreateThemeAliasInput) SetThemeVersionNumber(v int64) *CreateThemeAliasInput {
	s.ThemeVersionNumber = &v
	return s
}

type CreateThemeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the theme alias.
	ThemeAlias *ThemeAlias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *CreateThemeAliasOutput) SetRequestId(v string) *CreateThemeAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateThemeAliasOutput) SetStatus(v int64) *CreateThemeAliasOutput {
	s.Status = &v
	return s
}

// SetThemeAlias sets the ThemeAlias field's value.
func (s *CreateThemeAliasOutput) SetThemeAlias(v *ThemeAlias) *CreateThemeAliasOutput {
	s.ThemeAlias = v
	return s
}

type CreateThemeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account where you want to store the new
	// theme.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the theme that a custom theme will inherit from. All themes inherit
	// from one of the starting themes defined by Amazon QuickSight. For a list
	// of the starting themes, use ListThemes or choose Themes from within an analysis.
	//
	// BaseThemeId is a required field
	BaseThemeId *string `min:"1" type:"string" required:"true"`

	// The theme configuration, which contains the theme display properties.
	//
	// Configuration is a required field
	Configuration *ThemeConfiguration `type:"structure" required:"true"`

	// A display name for the theme.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A valid grouping of resource permissions to apply to the new theme.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// A map of the key-value pairs for the resource tag or tags that you want to
	// add to the resource.
	Tags []*Tag `min:"1" type:"list"`

	// An ID for the theme that you want to create. The theme ID is unique per Amazon
	// Web Services Region in each Amazon Web Services account.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// A description of the first version of the theme that you're creating. Every
	// time UpdateTheme is called, a new version is created. Each version of the
	// theme has a description of the version in the VersionDescription field.
	VersionDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateThemeInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.BaseThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseThemeId"))
	}
	if s.BaseThemeId != nil && len(*s.BaseThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BaseThemeId", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Permissions != nil && len(s.Permissions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionDescription != nil && len(*s.VersionDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionDescription", 1))
	}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateThemeInput) SetAwsAccountId(v string) *CreateThemeInput {
	s.AwsAccountId = &v
	return s
}

// SetBaseThemeId sets the BaseThemeId field's value.
func (s *CreateThemeInput) SetBaseThemeId(v string) *CreateThemeInput {
	s.BaseThemeId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateThemeInput) SetConfiguration(v *ThemeConfiguration) *CreateThemeInput {
	s.Configuration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateThemeInput) SetName(v string) *CreateThemeInput {
	s.Name = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateThemeInput) SetPermissions(v []*ResourcePermission) *CreateThemeInput {
	s.Permissions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateThemeInput) SetTags(v []*Tag) *CreateThemeInput {
	s.Tags = v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *CreateThemeInput) SetThemeId(v string) *CreateThemeInput {
	s.ThemeId = &v
	return s
}

// SetVersionDescription sets the VersionDescription field's value.
func (s *CreateThemeInput) SetVersionDescription(v string) *CreateThemeInput {
	s.VersionDescription = &v
	return s
}

type CreateThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the theme.
	Arn *string `type:"string"`

	// The theme creation status.
	CreationStatus *string `type:"string" enum:"ResourceStatus"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The ID of the theme.
	ThemeId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the new theme.
	VersionArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateThemeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateThemeOutput) SetArn(v string) *CreateThemeOutput {
	s.Arn = &v
	return s
}

// SetCreationStatus sets the CreationStatus field's value.
func (s *CreateThemeOutput) SetCreationStatus(v string) *CreateThemeOutput {
	s.CreationStatus = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateThemeOutput) SetRequestId(v string) *CreateThemeOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateThemeOutput) SetStatus(v int64) *CreateThemeOutput {
	s.Status = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *CreateThemeOutput) SetThemeId(v string) *CreateThemeOutput {
	s.ThemeId = &v
	return s
}

// SetVersionArn sets the VersionArn field's value.
func (s *CreateThemeOutput) SetVersionArn(v string) *CreateThemeOutput {
	s.VersionArn = &v
	return s
}

// The combination of user name and password that are used as credentials.
type CredentialPair struct {
	_ struct{} `type:"structure"`

	// A set of alternate data source parameters that you want to share for these
	// credentials. The credentials are applied in tandem with the data source parameters
	// when you copy a data source by using a create or update request. The API
	// operation compares the DataSourceParameters structure that's in the request
	// with the structures in the AlternateDataSourceParameters allow list. If the
	// structures are an exact match, the request is allowed to use the new data
	// source with the existing credentials. If the AlternateDataSourceParameters
	// list is null, the DataSourceParameters originally used with these Credentials
	// is automatically allowed.
	AlternateDataSourceParameters []*DataSourceParameters `min:"1" type:"list"`

	// Password.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// User name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CredentialPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CredentialPair) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CredentialPair) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CredentialPair"}
	if s.AlternateDataSourceParameters != nil && len(s.AlternateDataSourceParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlternateDataSourceParameters", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.AlternateDataSourceParameters != nil {
		for i, v := range s.AlternateDataSourceParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AlternateDataSourceParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlternateDataSourceParameters sets the AlternateDataSourceParameters field's value.
func (s *CredentialPair) SetAlternateDataSourceParameters(v []*DataSourceParameters) *CredentialPair {
	s.AlternateDataSourceParameters = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CredentialPair) SetPassword(v string) *CredentialPair {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CredentialPair) SetUsername(v string) *CredentialPair {
	s.Username = &v
	return s
}

// A physical table type built from the results of the custom SQL query.
type CustomSql struct {
	_ struct{} `type:"structure"`

	// The column schema from the SQL query result set.
	Columns []*InputColumn `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the data source.
	//
	// DataSourceArn is a required field
	DataSourceArn *string `type:"string" required:"true"`

	// A display name for the SQL query result.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The SQL query.
	//
	// SqlQuery is a required field
	SqlQuery *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomSql) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomSql) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomSql) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomSql"}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.DataSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SqlQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlQuery"))
	}
	if s.SqlQuery != nil && len(*s.SqlQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlQuery", 1))
	}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *CustomSql) SetColumns(v []*InputColumn) *CustomSql {
	s.Columns = v
	return s
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *CustomSql) SetDataSourceArn(v string) *CustomSql {
	s.DataSourceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomSql) SetName(v string) *CustomSql {
	s.Name = &v
	return s
}

// SetSqlQuery sets the SqlQuery field's value.
func (s *CustomSql) SetSqlQuery(v string) *CustomSql {
	s.SqlQuery = &v
	return s
}

// Dashboard.
type Dashboard struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dataset was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Dashboard ID.
	DashboardId *string `min:"1" type:"string"`

	// The last time that this dataset was published.
	LastPublishedTime *time.Time `type:"timestamp"`

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dashboard.
	Name *string `min:"1" type:"string"`

	// Version.
	Version *DashboardVersion `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dashboard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dashboard) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Dashboard) SetArn(v string) *Dashboard {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Dashboard) SetCreatedTime(v time.Time) *Dashboard {
	s.CreatedTime = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *Dashboard) SetDashboardId(v string) *Dashboard {
	s.DashboardId = &v
	return s
}

// SetLastPublishedTime sets the LastPublishedTime field's value.
func (s *Dashboard) SetLastPublishedTime(v time.Time) *Dashboard {
	s.LastPublishedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Dashboard) SetLastUpdatedTime(v time.Time) *Dashboard {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Dashboard) SetName(v string) *Dashboard {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Dashboard) SetVersion(v *DashboardVersion) *Dashboard {
	s.Version = v
	return s
}

// Dashboard error.
type DashboardError struct {
	_ struct{} `type:"structure"`

	// Message.
	Message *string `type:"string"`

	// Type.
	Type *string `type:"string" enum:"DashboardErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DashboardError) SetMessage(v string) *DashboardError {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *DashboardError) SetType(v string) *DashboardError {
	s.Type = &v
	return s
}

// Dashboard publish options.
type DashboardPublishOptions struct {
	_ struct{} `type:"structure"`

	// Ad hoc (one-time) filtering option.
	AdHocFilteringOption *AdHocFilteringOption `type:"structure"`

	// Export to .csv option.
	ExportToCSVOption *ExportToCSVOption `type:"structure"`

	// Sheet controls option.
	SheetControlsOption *SheetControlsOption `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardPublishOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardPublishOptions) GoString() string {
	return s.String()
}

// SetAdHocFilteringOption sets the AdHocFilteringOption field's value.
func (s *DashboardPublishOptions) SetAdHocFilteringOption(v *AdHocFilteringOption) *DashboardPublishOptions {
	s.AdHocFilteringOption = v
	return s
}

// SetExportToCSVOption sets the ExportToCSVOption field's value.
func (s *DashboardPublishOptions) SetExportToCSVOption(v *ExportToCSVOption) *DashboardPublishOptions {
	s.ExportToCSVOption = v
	return s
}

// SetSheetControlsOption sets the SheetControlsOption field's value.
func (s *DashboardPublishOptions) SetSheetControlsOption(v *SheetControlsOption) *DashboardPublishOptions {
	s.SheetControlsOption = v
	return s
}

// A filter that you apply when searching for dashboards.
type DashboardSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of the value that you want to use as a filter, for example, "Name":
	// "QUICKSIGHT_USER".
	Name *string `type:"string" enum:"DashboardFilterAttribute"`

	// The comparison operator that you want to use as a filter, for example, "Operator":
	// "StringEquals".
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"FilterOperator"`

	// The value of the named item, in this case QUICKSIGHT_USER, that you want
	// to use as a filter, for example, "Value": "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSearchFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSearchFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashboardSearchFilter"}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DashboardSearchFilter) SetName(v string) *DashboardSearchFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *DashboardSearchFilter) SetOperator(v string) *DashboardSearchFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DashboardSearchFilter) SetValue(v string) *DashboardSearchFilter {
	s.Value = &v
	return s
}

// Dashboard source entity.
type DashboardSourceEntity struct {
	_ struct{} `type:"structure"`

	// Source template.
	SourceTemplate *DashboardSourceTemplate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSourceEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSourceEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSourceEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashboardSourceEntity"}
	if s.SourceTemplate != nil {
		if err := s.SourceTemplate.Validate(); err != nil {
			invalidParams.AddNested("SourceTemplate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceTemplate sets the SourceTemplate field's value.
func (s *DashboardSourceEntity) SetSourceTemplate(v *DashboardSourceTemplate) *DashboardSourceEntity {
	s.SourceTemplate = v
	return s
}

// Dashboard source template.
type DashboardSourceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// Dataset references.
	//
	// DataSetReferences is a required field
	DataSetReferences []*DataSetReference `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSourceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSourceTemplate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DashboardSourceTemplate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DashboardSourceTemplate"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.DataSetReferences == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetReferences"))
	}
	if s.DataSetReferences != nil && len(s.DataSetReferences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetReferences", 1))
	}
	if s.DataSetReferences != nil {
		for i, v := range s.DataSetReferences {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSetReferences", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DashboardSourceTemplate) SetArn(v string) *DashboardSourceTemplate {
	s.Arn = &v
	return s
}

// SetDataSetReferences sets the DataSetReferences field's value.
func (s *DashboardSourceTemplate) SetDataSetReferences(v []*DataSetReference) *DashboardSourceTemplate {
	s.DataSetReferences = v
	return s
}

// Dashboard summary.
type DashboardSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dashboard was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Dashboard ID.
	DashboardId *string `min:"1" type:"string"`

	// The last time that this dashboard was published.
	LastPublishedTime *time.Time `type:"timestamp"`

	// The last time that this dashboard was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dashboard.
	Name *string `min:"1" type:"string"`

	// Published version number.
	PublishedVersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DashboardSummary) SetArn(v string) *DashboardSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DashboardSummary) SetCreatedTime(v time.Time) *DashboardSummary {
	s.CreatedTime = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DashboardSummary) SetDashboardId(v string) *DashboardSummary {
	s.DashboardId = &v
	return s
}

// SetLastPublishedTime sets the LastPublishedTime field's value.
func (s *DashboardSummary) SetLastPublishedTime(v time.Time) *DashboardSummary {
	s.LastPublishedTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DashboardSummary) SetLastUpdatedTime(v time.Time) *DashboardSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DashboardSummary) SetName(v string) *DashboardSummary {
	s.Name = &v
	return s
}

// SetPublishedVersionNumber sets the PublishedVersionNumber field's value.
func (s *DashboardSummary) SetPublishedVersionNumber(v int64) *DashboardSummary {
	s.PublishedVersionNumber = &v
	return s
}

// Dashboard version.
type DashboardVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dashboard version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Numbers (ARNs) for the datasets that are associated with
	// this version of the dashboard.
	DataSetArns []*string `type:"list"`

	// Description.
	Description *string `min:"1" type:"string"`

	// Errors associated with this dashboard version.
	Errors []*DashboardError `min:"1" type:"list"`

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []*Sheet `type:"list"`

	// Source entity ARN.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The ARN of the theme associated with a version of the dashboard.
	ThemeArn *string `type:"string"`

	// Version number for this version of the dashboard.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DashboardVersion) SetArn(v string) *DashboardVersion {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DashboardVersion) SetCreatedTime(v time.Time) *DashboardVersion {
	s.CreatedTime = &v
	return s
}

// SetDataSetArns sets the DataSetArns field's value.
func (s *DashboardVersion) SetDataSetArns(v []*string) *DashboardVersion {
	s.DataSetArns = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DashboardVersion) SetDescription(v string) *DashboardVersion {
	s.Description = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DashboardVersion) SetErrors(v []*DashboardError) *DashboardVersion {
	s.Errors = v
	return s
}

// SetSheets sets the Sheets field's value.
func (s *DashboardVersion) SetSheets(v []*Sheet) *DashboardVersion {
	s.Sheets = v
	return s
}

// SetSourceEntityArn sets the SourceEntityArn field's value.
func (s *DashboardVersion) SetSourceEntityArn(v string) *DashboardVersion {
	s.SourceEntityArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DashboardVersion) SetStatus(v string) *DashboardVersion {
	s.Status = &v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *DashboardVersion) SetThemeArn(v string) *DashboardVersion {
	s.ThemeArn = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DashboardVersion) SetVersionNumber(v int64) *DashboardVersion {
	s.VersionNumber = &v
	return s
}

// Dashboard version summary.
type DashboardVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The time that this dashboard version was created.
	CreatedTime *time.Time `type:"timestamp"`

	// Description.
	Description *string `min:"1" type:"string"`

	// Source entity ARN.
	SourceEntityArn *string `type:"string"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// Version number.
	VersionNumber *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DashboardVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DashboardVersionSummary) SetArn(v string) *DashboardVersionSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DashboardVersionSummary) SetCreatedTime(v time.Time) *DashboardVersionSummary {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DashboardVersionSummary) SetDescription(v string) *DashboardVersionSummary {
	s.Description = &v
	return s
}

// SetSourceEntityArn sets the SourceEntityArn field's value.
func (s *DashboardVersionSummary) SetSourceEntityArn(v string) *DashboardVersionSummary {
	s.SourceEntityArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DashboardVersionSummary) SetStatus(v string) *DashboardVersionSummary {
	s.Status = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DashboardVersionSummary) SetVersionNumber(v int64) *DashboardVersionSummary {
	s.VersionNumber = &v
	return s
}

// The theme colors that are used for data colors in charts. The colors description
// is a hexadecimal color code that consists of six alphanumerical characters,
// prefixed with #, for example #37BFF5.
type DataColorPalette struct {
	_ struct{} `type:"structure"`

	// The hexadecimal codes for the colors.
	Colors []*string `type:"list"`

	// The hexadecimal code of a color that applies to charts where a lack of data
	// is highlighted.
	EmptyFillColor *string `type:"string"`

	// The minimum and maximum hexadecimal codes that describe a color gradient.
	MinMaxGradient []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataColorPalette) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataColorPalette) GoString() string {
	return s.String()
}

// SetColors sets the Colors field's value.
func (s *DataColorPalette) SetColors(v []*string) *DataColorPalette {
	s.Colors = v
	return s
}

// SetEmptyFillColor sets the EmptyFillColor field's value.
func (s *DataColorPalette) SetEmptyFillColor(v string) *DataColorPalette {
	s.EmptyFillColor = &v
	return s
}

// SetMinMaxGradient sets the MinMaxGradient field's value.
func (s *DataColorPalette) SetMinMaxGradient(v []*string) *DataColorPalette {
	s.MinMaxGradient = v
	return s
}

// Dataset.
type DataSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// Groupings of columns that work together in certain Amazon QuickSight features.
	// Currently, only geospatial hierarchy is supported.
	ColumnGroups []*ColumnGroup `min:"1" type:"list"`

	// A set of one or more definitions of a ColumnLevelPermissionRule (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html) .
	ColumnLevelPermissionRules []*ColumnLevelPermissionRule `min:"1" type:"list"`

	// The amount of SPICE capacity used by this dataset. This is 0 if the dataset
	// isn't imported into SPICE.
	ConsumedSpiceCapacityInBytes *int64 `type:"long"`

	// The time that this dataset was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the dataset.
	DataSetId *string `type:"string"`

	// The usage configuration to apply to child datasets that reference this dataset
	// as a source.
	DataSetUsageConfiguration *DataSetUsageConfiguration `type:"structure"`

	// The folder that contains fields and nested subfolders for your dataset.
	FieldFolders map[string]*FieldFolder `type:"map"`

	// A value that indicates whether you want to import the data into SPICE.
	ImportMode *string `type:"string" enum:"DataSetImportMode"`

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]*LogicalTable `min:"1" type:"map"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// The list of columns after all transforms. These columns are available in
	// templates, analyses, and dashboards.
	OutputColumns []*OutputColumn `type:"list"`

	// Declares the physical tables that are available in the underlying data sources.
	PhysicalTableMap map[string]*PhysicalTable `type:"map"`

	// The row-level security configuration for the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`

	// The element you can use to define tags for row-level security.
	RowLevelPermissionTagConfiguration *RowLevelPermissionTagConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSet) SetArn(v string) *DataSet {
	s.Arn = &v
	return s
}

// SetColumnGroups sets the ColumnGroups field's value.
func (s *DataSet) SetColumnGroups(v []*ColumnGroup) *DataSet {
	s.ColumnGroups = v
	return s
}

// SetColumnLevelPermissionRules sets the ColumnLevelPermissionRules field's value.
func (s *DataSet) SetColumnLevelPermissionRules(v []*ColumnLevelPermissionRule) *DataSet {
	s.ColumnLevelPermissionRules = v
	return s
}

// SetConsumedSpiceCapacityInBytes sets the ConsumedSpiceCapacityInBytes field's value.
func (s *DataSet) SetConsumedSpiceCapacityInBytes(v int64) *DataSet {
	s.ConsumedSpiceCapacityInBytes = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DataSet) SetCreatedTime(v time.Time) *DataSet {
	s.CreatedTime = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DataSet) SetDataSetId(v string) *DataSet {
	s.DataSetId = &v
	return s
}

// SetDataSetUsageConfiguration sets the DataSetUsageConfiguration field's value.
func (s *DataSet) SetDataSetUsageConfiguration(v *DataSetUsageConfiguration) *DataSet {
	s.DataSetUsageConfiguration = v
	return s
}

// SetFieldFolders sets the FieldFolders field's value.
func (s *DataSet) SetFieldFolders(v map[string]*FieldFolder) *DataSet {
	s.FieldFolders = v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *DataSet) SetImportMode(v string) *DataSet {
	s.ImportMode = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSet) SetLastUpdatedTime(v time.Time) *DataSet {
	s.LastUpdatedTime = &v
	return s
}

// SetLogicalTableMap sets the LogicalTableMap field's value.
func (s *DataSet) SetLogicalTableMap(v map[string]*LogicalTable) *DataSet {
	s.LogicalTableMap = v
	return s
}

// SetName sets the Name field's value.
func (s *DataSet) SetName(v string) *DataSet {
	s.Name = &v
	return s
}

// SetOutputColumns sets the OutputColumns field's value.
func (s *DataSet) SetOutputColumns(v []*OutputColumn) *DataSet {
	s.OutputColumns = v
	return s
}

// SetPhysicalTableMap sets the PhysicalTableMap field's value.
func (s *DataSet) SetPhysicalTableMap(v map[string]*PhysicalTable) *DataSet {
	s.PhysicalTableMap = v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *DataSet) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *DataSet {
	s.RowLevelPermissionDataSet = v
	return s
}

// SetRowLevelPermissionTagConfiguration sets the RowLevelPermissionTagConfiguration field's value.
func (s *DataSet) SetRowLevelPermissionTagConfiguration(v *RowLevelPermissionTagConfiguration) *DataSet {
	s.RowLevelPermissionTagConfiguration = v
	return s
}

// Dataset configuration.
type DataSetConfiguration struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column group schemas.
	ColumnGroupSchemaList []*ColumnGroupSchema `type:"list"`

	// Dataset schema.
	DataSetSchema *DataSetSchema `type:"structure"`

	// Placeholder.
	Placeholder *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetConfiguration) GoString() string {
	return s.String()
}

// SetColumnGroupSchemaList sets the ColumnGroupSchemaList field's value.
func (s *DataSetConfiguration) SetColumnGroupSchemaList(v []*ColumnGroupSchema) *DataSetConfiguration {
	s.ColumnGroupSchemaList = v
	return s
}

// SetDataSetSchema sets the DataSetSchema field's value.
func (s *DataSetConfiguration) SetDataSetSchema(v *DataSetSchema) *DataSetConfiguration {
	s.DataSetSchema = v
	return s
}

// SetPlaceholder sets the Placeholder field's value.
func (s *DataSetConfiguration) SetPlaceholder(v string) *DataSetConfiguration {
	s.Placeholder = &v
	return s
}

// Dataset reference.
type DataSetReference struct {
	_ struct{} `type:"structure"`

	// Dataset Amazon Resource Name (ARN).
	//
	// DataSetArn is a required field
	DataSetArn *string `type:"string" required:"true"`

	// Dataset placeholder.
	//
	// DataSetPlaceholder is a required field
	DataSetPlaceholder *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSetReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSetReference"}
	if s.DataSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetArn"))
	}
	if s.DataSetPlaceholder == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetPlaceholder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSetArn sets the DataSetArn field's value.
func (s *DataSetReference) SetDataSetArn(v string) *DataSetReference {
	s.DataSetArn = &v
	return s
}

// SetDataSetPlaceholder sets the DataSetPlaceholder field's value.
func (s *DataSetReference) SetDataSetPlaceholder(v string) *DataSetReference {
	s.DataSetPlaceholder = &v
	return s
}

// Dataset schema.
type DataSetSchema struct {
	_ struct{} `type:"structure"`

	// A structure containing the list of column schemas.
	ColumnSchemaList []*ColumnSchema `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetSchema) GoString() string {
	return s.String()
}

// SetColumnSchemaList sets the ColumnSchemaList field's value.
func (s *DataSetSchema) SetColumnSchemaList(v []*ColumnSchema) *DataSetSchema {
	s.ColumnSchemaList = v
	return s
}

// Dataset summary.
type DataSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// A value that indicates if the dataset has column level permission configured.
	ColumnLevelPermissionRulesApplied *bool `type:"boolean"`

	// The time that this dataset was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the dataset.
	DataSetId *string `type:"string"`

	// A value that indicates whether you want to import the data into SPICE.
	ImportMode *string `type:"string" enum:"DataSetImportMode"`

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the dataset.
	Name *string `min:"1" type:"string"`

	// The row-level security configuration for the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet `type:"structure"`

	// Whether or not the row level permission tags are applied.
	RowLevelPermissionTagConfigurationApplied *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSetSummary) SetArn(v string) *DataSetSummary {
	s.Arn = &v
	return s
}

// SetColumnLevelPermissionRulesApplied sets the ColumnLevelPermissionRulesApplied field's value.
func (s *DataSetSummary) SetColumnLevelPermissionRulesApplied(v bool) *DataSetSummary {
	s.ColumnLevelPermissionRulesApplied = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DataSetSummary) SetCreatedTime(v time.Time) *DataSetSummary {
	s.CreatedTime = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DataSetSummary) SetDataSetId(v string) *DataSetSummary {
	s.DataSetId = &v
	return s
}

// SetImportMode sets the ImportMode field's value.
func (s *DataSetSummary) SetImportMode(v string) *DataSetSummary {
	s.ImportMode = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSetSummary) SetLastUpdatedTime(v time.Time) *DataSetSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSetSummary) SetName(v string) *DataSetSummary {
	s.Name = &v
	return s
}

// SetRowLevelPermissionDataSet sets the RowLevelPermissionDataSet field's value.
func (s *DataSetSummary) SetRowLevelPermissionDataSet(v *RowLevelPermissionDataSet) *DataSetSummary {
	s.RowLevelPermissionDataSet = v
	return s
}

// SetRowLevelPermissionTagConfigurationApplied sets the RowLevelPermissionTagConfigurationApplied field's value.
func (s *DataSetSummary) SetRowLevelPermissionTagConfigurationApplied(v bool) *DataSetSummary {
	s.RowLevelPermissionTagConfigurationApplied = &v
	return s
}

// The usage configuration to apply to child datasets that reference this dataset
// as a source.
type DataSetUsageConfiguration struct {
	_ struct{} `type:"structure"`

	// An option that controls whether a child dataset of a direct query can use
	// this dataset as a source.
	DisableUseAsDirectQuerySource *bool `type:"boolean"`

	// An option that controls whether a child dataset that's stored in QuickSight
	// can use this dataset as a source.
	DisableUseAsImportedSource *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetUsageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSetUsageConfiguration) GoString() string {
	return s.String()
}

// SetDisableUseAsDirectQuerySource sets the DisableUseAsDirectQuerySource field's value.
func (s *DataSetUsageConfiguration) SetDisableUseAsDirectQuerySource(v bool) *DataSetUsageConfiguration {
	s.DisableUseAsDirectQuerySource = &v
	return s
}

// SetDisableUseAsImportedSource sets the DisableUseAsImportedSource field's value.
func (s *DataSetUsageConfiguration) SetDisableUseAsImportedSource(v bool) *DataSetUsageConfiguration {
	s.DisableUseAsImportedSource = &v
	return s
}

// The structure of a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// A set of alternate data source parameters that you want to share for the
	// credentials stored with this data source. The credentials are applied in
	// tandem with the data source parameters when you copy a data source by using
	// a create or update request. The API operation compares the DataSourceParameters
	// structure that's in the request with the structures in the AlternateDataSourceParameters
	// allow list. If the structures are an exact match, the request is allowed
	// to use the credentials from this existing data source. If the AlternateDataSourceParameters
	// list is null, the Credentials originally used with this DataSourceParameters
	// are automatically allowed.
	AlternateDataSourceParameters []*DataSourceParameters `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string `type:"string"`

	// The time that this data source was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	DataSourceId *string `type:"string"`

	// The parameters that Amazon QuickSight uses to connect to your underlying
	// source. This is a variant type structure. For this structure to be valid,
	// only one of the attributes can be non-null.
	DataSourceParameters *DataSourceParameters `type:"structure"`

	// Error information from the last update or the creation of the data source.
	ErrorInfo *DataSourceErrorInfo `type:"structure"`

	// The last time that this data source was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the data source.
	Name *string `min:"1" type:"string"`

	// Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties `type:"structure"`

	// The HTTP status of the request.
	Status *string `type:"string" enum:"ResourceStatus"`

	// The type of the data source. This type indicates which database engine the
	// data source connects to.
	Type *string `type:"string" enum:"DataSourceType"`

	// The VPC connection information. You need to use this parameter only when
	// you want Amazon QuickSight to use a VPC connection when connecting to your
	// underlying source.
	VpcConnectionProperties *VpcConnectionProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) GoString() string {
	return s.String()
}

// SetAlternateDataSourceParameters sets the AlternateDataSourceParameters field's value.
func (s *DataSource) SetAlternateDataSourceParameters(v []*DataSourceParameters) *DataSource {
	s.AlternateDataSourceParameters = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DataSource) SetArn(v string) *DataSource {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DataSource) SetCreatedTime(v time.Time) *DataSource {
	s.CreatedTime = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSource) SetDataSourceId(v string) *DataSource {
	s.DataSourceId = &v
	return s
}

// SetDataSourceParameters sets the DataSourceParameters field's value.
func (s *DataSource) SetDataSourceParameters(v *DataSourceParameters) *DataSource {
	s.DataSourceParameters = v
	return s
}

// SetErrorInfo sets the ErrorInfo field's value.
func (s *DataSource) SetErrorInfo(v *DataSourceErrorInfo) *DataSource {
	s.ErrorInfo = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DataSource) SetLastUpdatedTime(v time.Time) *DataSource {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetSslProperties sets the SslProperties field's value.
func (s *DataSource) SetSslProperties(v *SslProperties) *DataSource {
	s.SslProperties = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSource) SetStatus(v string) *DataSource {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSource) SetType(v string) *DataSource {
	s.Type = &v
	return s
}

// SetVpcConnectionProperties sets the VpcConnectionProperties field's value.
func (s *DataSource) SetVpcConnectionProperties(v *VpcConnectionProperties) *DataSource {
	s.VpcConnectionProperties = v
	return s
}

// Data source credentials. This is a variant type structure. For this structure
// to be valid, only one of the attributes can be non-null.
type DataSourceCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN) of a data source that has the credential pair
	// that you want to use. When CopySourceArn is not null, the credential pair
	// from the data source in the ARN is used as the credentials for the DataSourceCredentials
	// structure.
	CopySourceArn *string `type:"string"`

	// Credential pair. For more information, see CredentialPair (https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html) .
	CredentialPair *CredentialPair `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceCredentials"}
	if s.CredentialPair != nil {
		if err := s.CredentialPair.Validate(); err != nil {
			invalidParams.AddNested("CredentialPair", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopySourceArn sets the CopySourceArn field's value.
func (s *DataSourceCredentials) SetCopySourceArn(v string) *DataSourceCredentials {
	s.CopySourceArn = &v
	return s
}

// SetCredentialPair sets the CredentialPair field's value.
func (s *DataSourceCredentials) SetCredentialPair(v *CredentialPair) *DataSourceCredentials {
	s.CredentialPair = v
	return s
}

// Error information for the data source creation or update.
type DataSourceErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error message.
	Message *string `type:"string"`

	// Error type.
	Type *string `type:"string" enum:"DataSourceErrorInfoType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceErrorInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DataSourceErrorInfo) SetMessage(v string) *DataSourceErrorInfo {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceErrorInfo) SetType(v string) *DataSourceErrorInfo {
	s.Type = &v
	return s
}

// The parameters that Amazon QuickSight uses to connect to your underlying
// data source. This is a variant type structure. For this structure to be valid,
// only one of the attributes can be non-null.
type DataSourceParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for OpenSearch.
	AmazonElasticsearchParameters *AmazonElasticsearchParameters `type:"structure"`

	// The parameters for OpenSearch.
	AmazonOpenSearchParameters *AmazonOpenSearchParameters `type:"structure"`

	// The parameters for Amazon Athena.
	AthenaParameters *AthenaParameters `type:"structure"`

	// The parameters for Amazon Aurora MySQL.
	AuroraParameters *AuroraParameters `type:"structure"`

	// The parameters for Amazon Aurora.
	AuroraPostgreSqlParameters *AuroraPostgreSqlParameters `type:"structure"`

	// The parameters for IoT Analytics.
	AwsIotAnalyticsParameters *AwsIotAnalyticsParameters `type:"structure"`

	// The parameters for Exasol.
	ExasolParameters *ExasolParameters `type:"structure"`

	// The parameters for Jira.
	JiraParameters *JiraParameters `type:"structure"`

	// The parameters for MariaDB.
	MariaDbParameters *MariaDbParameters `type:"structure"`

	// The parameters for MySQL.
	MySqlParameters *MySqlParameters `type:"structure"`

	// The parameters for Oracle.
	OracleParameters *OracleParameters `type:"structure"`

	// The parameters for PostgreSQL.
	PostgreSqlParameters *PostgreSqlParameters `type:"structure"`

	// The parameters for Presto.
	PrestoParameters *PrestoParameters `type:"structure"`

	// The parameters for Amazon RDS.
	RdsParameters *RdsParameters `type:"structure"`

	// The parameters for Amazon Redshift.
	RedshiftParameters *RedshiftParameters `type:"structure"`

	// The parameters for S3.
	S3Parameters *S3Parameters `type:"structure"`

	// The parameters for ServiceNow.
	ServiceNowParameters *ServiceNowParameters `type:"structure"`

	// The parameters for Snowflake.
	SnowflakeParameters *SnowflakeParameters `type:"structure"`

	// The parameters for Spark.
	SparkParameters *SparkParameters `type:"structure"`

	// The parameters for SQL Server.
	SqlServerParameters *SqlServerParameters `type:"structure"`

	// The parameters for Teradata.
	TeradataParameters *TeradataParameters `type:"structure"`

	// The parameters for Twitter.
	TwitterParameters *TwitterParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceParameters"}
	if s.AmazonElasticsearchParameters != nil {
		if err := s.AmazonElasticsearchParameters.Validate(); err != nil {
			invalidParams.AddNested("AmazonElasticsearchParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AmazonOpenSearchParameters != nil {
		if err := s.AmazonOpenSearchParameters.Validate(); err != nil {
			invalidParams.AddNested("AmazonOpenSearchParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AthenaParameters != nil {
		if err := s.AthenaParameters.Validate(); err != nil {
			invalidParams.AddNested("AthenaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AuroraParameters != nil {
		if err := s.AuroraParameters.Validate(); err != nil {
			invalidParams.AddNested("AuroraParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AuroraPostgreSqlParameters != nil {
		if err := s.AuroraPostgreSqlParameters.Validate(); err != nil {
			invalidParams.AddNested("AuroraPostgreSqlParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.AwsIotAnalyticsParameters != nil {
		if err := s.AwsIotAnalyticsParameters.Validate(); err != nil {
			invalidParams.AddNested("AwsIotAnalyticsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.ExasolParameters != nil {
		if err := s.ExasolParameters.Validate(); err != nil {
			invalidParams.AddNested("ExasolParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.JiraParameters != nil {
		if err := s.JiraParameters.Validate(); err != nil {
			invalidParams.AddNested("JiraParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.MariaDbParameters != nil {
		if err := s.MariaDbParameters.Validate(); err != nil {
			invalidParams.AddNested("MariaDbParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.MySqlParameters != nil {
		if err := s.MySqlParameters.Validate(); err != nil {
			invalidParams.AddNested("MySqlParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.OracleParameters != nil {
		if err := s.OracleParameters.Validate(); err != nil {
			invalidParams.AddNested("OracleParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.PostgreSqlParameters != nil {
		if err := s.PostgreSqlParameters.Validate(); err != nil {
			invalidParams.AddNested("PostgreSqlParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.PrestoParameters != nil {
		if err := s.PrestoParameters.Validate(); err != nil {
			invalidParams.AddNested("PrestoParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RdsParameters != nil {
		if err := s.RdsParameters.Validate(); err != nil {
			invalidParams.AddNested("RdsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftParameters != nil {
		if err := s.RedshiftParameters.Validate(); err != nil {
			invalidParams.AddNested("RedshiftParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Parameters != nil {
		if err := s.S3Parameters.Validate(); err != nil {
			invalidParams.AddNested("S3Parameters", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNowParameters != nil {
		if err := s.ServiceNowParameters.Validate(); err != nil {
			invalidParams.AddNested("ServiceNowParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SnowflakeParameters != nil {
		if err := s.SnowflakeParameters.Validate(); err != nil {
			invalidParams.AddNested("SnowflakeParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SparkParameters != nil {
		if err := s.SparkParameters.Validate(); err != nil {
			invalidParams.AddNested("SparkParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SqlServerParameters != nil {
		if err := s.SqlServerParameters.Validate(); err != nil {
			invalidParams.AddNested("SqlServerParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TeradataParameters != nil {
		if err := s.TeradataParameters.Validate(); err != nil {
			invalidParams.AddNested("TeradataParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TwitterParameters != nil {
		if err := s.TwitterParameters.Validate(); err != nil {
			invalidParams.AddNested("TwitterParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonElasticsearchParameters sets the AmazonElasticsearchParameters field's value.
func (s *DataSourceParameters) SetAmazonElasticsearchParameters(v *AmazonElasticsearchParameters) *DataSourceParameters {
	s.AmazonElasticsearchParameters = v
	return s
}

// SetAmazonOpenSearchParameters sets the AmazonOpenSearchParameters field's value.
func (s *DataSourceParameters) SetAmazonOpenSearchParameters(v *AmazonOpenSearchParameters) *DataSourceParameters {
	s.AmazonOpenSearchParameters = v
	return s
}

// SetAthenaParameters sets the AthenaParameters field's value.
func (s *DataSourceParameters) SetAthenaParameters(v *AthenaParameters) *DataSourceParameters {
	s.AthenaParameters = v
	return s
}

// SetAuroraParameters sets the AuroraParameters field's value.
func (s *DataSourceParameters) SetAuroraParameters(v *AuroraParameters) *DataSourceParameters {
	s.AuroraParameters = v
	return s
}

// SetAuroraPostgreSqlParameters sets the AuroraPostgreSqlParameters field's value.
func (s *DataSourceParameters) SetAuroraPostgreSqlParameters(v *AuroraPostgreSqlParameters) *DataSourceParameters {
	s.AuroraPostgreSqlParameters = v
	return s
}

// SetAwsIotAnalyticsParameters sets the AwsIotAnalyticsParameters field's value.
func (s *DataSourceParameters) SetAwsIotAnalyticsParameters(v *AwsIotAnalyticsParameters) *DataSourceParameters {
	s.AwsIotAnalyticsParameters = v
	return s
}

// SetExasolParameters sets the ExasolParameters field's value.
func (s *DataSourceParameters) SetExasolParameters(v *ExasolParameters) *DataSourceParameters {
	s.ExasolParameters = v
	return s
}

// SetJiraParameters sets the JiraParameters field's value.
func (s *DataSourceParameters) SetJiraParameters(v *JiraParameters) *DataSourceParameters {
	s.JiraParameters = v
	return s
}

// SetMariaDbParameters sets the MariaDbParameters field's value.
func (s *DataSourceParameters) SetMariaDbParameters(v *MariaDbParameters) *DataSourceParameters {
	s.MariaDbParameters = v
	return s
}

// SetMySqlParameters sets the MySqlParameters field's value.
func (s *DataSourceParameters) SetMySqlParameters(v *MySqlParameters) *DataSourceParameters {
	s.MySqlParameters = v
	return s
}

// SetOracleParameters sets the OracleParameters field's value.
func (s *DataSourceParameters) SetOracleParameters(v *OracleParameters) *DataSourceParameters {
	s.OracleParameters = v
	return s
}

// SetPostgreSqlParameters sets the PostgreSqlParameters field's value.
func (s *DataSourceParameters) SetPostgreSqlParameters(v *PostgreSqlParameters) *DataSourceParameters {
	s.PostgreSqlParameters = v
	return s
}

// SetPrestoParameters sets the PrestoParameters field's value.
func (s *DataSourceParameters) SetPrestoParameters(v *PrestoParameters) *DataSourceParameters {
	s.PrestoParameters = v
	return s
}

// SetRdsParameters sets the RdsParameters field's value.
func (s *DataSourceParameters) SetRdsParameters(v *RdsParameters) *DataSourceParameters {
	s.RdsParameters = v
	return s
}

// SetRedshiftParameters sets the RedshiftParameters field's value.
func (s *DataSourceParameters) SetRedshiftParameters(v *RedshiftParameters) *DataSourceParameters {
	s.RedshiftParameters = v
	return s
}

// SetS3Parameters sets the S3Parameters field's value.
func (s *DataSourceParameters) SetS3Parameters(v *S3Parameters) *DataSourceParameters {
	s.S3Parameters = v
	return s
}

// SetServiceNowParameters sets the ServiceNowParameters field's value.
func (s *DataSourceParameters) SetServiceNowParameters(v *ServiceNowParameters) *DataSourceParameters {
	s.ServiceNowParameters = v
	return s
}

// SetSnowflakeParameters sets the SnowflakeParameters field's value.
func (s *DataSourceParameters) SetSnowflakeParameters(v *SnowflakeParameters) *DataSourceParameters {
	s.SnowflakeParameters = v
	return s
}

// SetSparkParameters sets the SparkParameters field's value.
func (s *DataSourceParameters) SetSparkParameters(v *SparkParameters) *DataSourceParameters {
	s.SparkParameters = v
	return s
}

// SetSqlServerParameters sets the SqlServerParameters field's value.
func (s *DataSourceParameters) SetSqlServerParameters(v *SqlServerParameters) *DataSourceParameters {
	s.SqlServerParameters = v
	return s
}

// SetTeradataParameters sets the TeradataParameters field's value.
func (s *DataSourceParameters) SetTeradataParameters(v *TeradataParameters) *DataSourceParameters {
	s.TeradataParameters = v
	return s
}

// SetTwitterParameters sets the TwitterParameters field's value.
func (s *DataSourceParameters) SetTwitterParameters(v *TwitterParameters) *DataSourceParameters {
	s.TwitterParameters = v
	return s
}

// A date-time parameter.
type DateTimeParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the date-time parameter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The values for the date-time parameter.
	//
	// Values is a required field
	Values []*time.Time `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateTimeParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateTimeParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateTimeParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateTimeParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DateTimeParameter) SetName(v string) *DateTimeParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DateTimeParameter) SetValues(v []*time.Time) *DateTimeParameter {
	s.Values = v
	return s
}

// A decimal parameter.
type DecimalParameter struct {
	_ struct{} `type:"structure"`

	// A display name for the decimal parameter.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The values for the decimal parameter.
	//
	// Values is a required field
	Values []*float64 `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecimalParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecimalParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecimalParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecimalParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DecimalParameter) SetName(v string) *DecimalParameter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DecimalParameter) SetValues(v []*float64) *DecimalParameter {
	s.Values = v
	return s
}

type DeleteAccountCustomizationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that you want to delete Amazon
	// QuickSight customizations from in this Amazon Web Services Region.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Amazon QuickSight namespace that you're deleting the customizations from.
	Namespace *string `location:"querystring" locationName:"namespace" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountCustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountCustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountCustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountCustomizationInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteAccountCustomizationInput) SetAwsAccountId(v string) *DeleteAccountCustomizationInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteAccountCustomizationInput) SetNamespace(v string) *DeleteAccountCustomizationInput {
	s.Namespace = &v
	return s
}

type DeleteAccountCustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountCustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountCustomizationOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteAccountCustomizationOutput) SetRequestId(v string) *DeleteAccountCustomizationOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteAccountCustomizationOutput) SetStatus(v int64) *DeleteAccountCustomizationOutput {
	s.Status = &v
	return s
}

type DeleteAnalysisInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the analysis that you're deleting.
	//
	// AnalysisId is a required field
	AnalysisId *string `location:"uri" locationName:"AnalysisId" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account where you want to delete an analysis.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// This option defaults to the value NoForceDeleteWithoutRecovery. To immediately
	// delete the analysis, add the ForceDeleteWithoutRecovery option. You can't
	// restore an analysis after it's deleted.
	ForceDeleteWithoutRecovery *bool `location:"querystring" locationName:"force-delete-without-recovery" type:"boolean"`

	// A value that specifies the number of days that Amazon QuickSight waits before
	// it deletes the analysis. You can't use this parameter with the ForceDeleteWithoutRecovery
	// option in the same API call. The default value is 30.
	RecoveryWindowInDays *int64 `location:"querystring" locationName:"recovery-window-in-days" min:"7" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAnalysisInput"}
	if s.AnalysisId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisId"))
	}
	if s.AnalysisId != nil && len(*s.AnalysisId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisId", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.RecoveryWindowInDays != nil && *s.RecoveryWindowInDays < 7 {
		invalidParams.Add(request.NewErrParamMinValue("RecoveryWindowInDays", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *DeleteAnalysisInput) SetAnalysisId(v string) *DeleteAnalysisInput {
	s.AnalysisId = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteAnalysisInput) SetAwsAccountId(v string) *DeleteAnalysisInput {
	s.AwsAccountId = &v
	return s
}

// SetForceDeleteWithoutRecovery sets the ForceDeleteWithoutRecovery field's value.
func (s *DeleteAnalysisInput) SetForceDeleteWithoutRecovery(v bool) *DeleteAnalysisInput {
	s.ForceDeleteWithoutRecovery = &v
	return s
}

// SetRecoveryWindowInDays sets the RecoveryWindowInDays field's value.
func (s *DeleteAnalysisInput) SetRecoveryWindowInDays(v int64) *DeleteAnalysisInput {
	s.RecoveryWindowInDays = &v
	return s
}

type DeleteAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the deleted analysis.
	AnalysisId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the deleted analysis.
	Arn *string `type:"string"`

	// The date and time that the analysis is scheduled to be deleted.
	DeletionTime *time.Time `type:"timestamp"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *DeleteAnalysisOutput) SetAnalysisId(v string) *DeleteAnalysisOutput {
	s.AnalysisId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteAnalysisOutput) SetArn(v string) *DeleteAnalysisOutput {
	s.Arn = &v
	return s
}

// SetDeletionTime sets the DeletionTime field's value.
func (s *DeleteAnalysisOutput) SetDeletionTime(v time.Time) *DeleteAnalysisOutput {
	s.DeletionTime = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteAnalysisOutput) SetRequestId(v string) *DeleteAnalysisOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteAnalysisOutput) SetStatus(v int64) *DeleteAnalysisOutput {
	s.Status = &v
	return s
}

type DeleteDashboardInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the dashboard that
	// you're deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The version number of the dashboard. If the version number property is provided,
	// only the specified version of the dashboard is deleted.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDashboardInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteDashboardInput) SetAwsAccountId(v string) *DeleteDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DeleteDashboardInput) SetDashboardId(v string) *DeleteDashboardInput {
	s.DashboardId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteDashboardInput) SetVersionNumber(v int64) *DeleteDashboardInput {
	s.VersionNumber = &v
	return s
}

type DeleteDashboardOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Socket Layer (SSL) properties that apply for the resource.
	Arn *string `type:"string"`

	// The ID of the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDashboardOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDashboardOutput) SetArn(v string) *DeleteDashboardOutput {
	s.Arn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DeleteDashboardOutput) SetDashboardId(v string) *DeleteDashboardOutput {
	s.DashboardId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDashboardOutput) SetRequestId(v string) *DeleteDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDashboardOutput) SetStatus(v int64) *DeleteDashboardOutput {
	s.Status = &v
	return s
}

type DeleteDataSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteDataSetInput) SetAwsAccountId(v string) *DeleteDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteDataSetInput) SetDataSetId(v string) *DeleteDataSetInput {
	s.DataSetId = &v
	return s
}

type DeleteDataSetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	DataSetId *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDataSetOutput) SetArn(v string) *DeleteDataSetOutput {
	s.Arn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DeleteDataSetOutput) SetDataSetId(v string) *DeleteDataSetOutput {
	s.DataSetId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDataSetOutput) SetRequestId(v string) *DeleteDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSetOutput) SetStatus(v int64) *DeleteDataSetOutput {
	s.Status = &v
	return s
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteDataSourceInput) SetAwsAccountId(v string) *DeleteDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceInput) SetDataSourceId(v string) *DeleteDataSourceInput {
	s.DataSourceId = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source that you deleted.
	Arn *string `type:"string"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	DataSourceId *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteDataSourceOutput) SetArn(v string) *DeleteDataSourceOutput {
	s.Arn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceOutput) SetDataSourceId(v string) *DeleteDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteDataSourceOutput) SetRequestId(v string) *DeleteDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSourceOutput) SetStatus(v int64) *DeleteDataSourceOutput {
	s.Status = &v
	return s
}

type DeleteFolderInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFolderInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteFolderInput) SetAwsAccountId(v string) *DeleteFolderInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DeleteFolderInput) SetFolderId(v string) *DeleteFolderInput {
	s.FolderId = &v
	return s
}

type DeleteFolderMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Folder ID.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The ID of the asset (the dashboard, analysis, or dataset) that you want to
	// delete.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"MemberId" min:"1" type:"string" required:"true"`

	// The type of the member, including DASHBOARD, ANALYSIS, and DATASET
	//
	// MemberType is a required field
	MemberType *string `location:"uri" locationName:"MemberType" type:"string" required:"true" enum:"MemberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFolderMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFolderMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.MemberType == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberType"))
	}
	if s.MemberType != nil && len(*s.MemberType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteFolderMembershipInput) SetAwsAccountId(v string) *DeleteFolderMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DeleteFolderMembershipInput) SetFolderId(v string) *DeleteFolderMembershipInput {
	s.FolderId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *DeleteFolderMembershipInput) SetMemberId(v string) *DeleteFolderMembershipInput {
	s.MemberId = &v
	return s
}

// SetMemberType sets the MemberType field's value.
func (s *DeleteFolderMembershipInput) SetMemberType(v string) *DeleteFolderMembershipInput {
	s.MemberType = &v
	return s
}

type DeleteFolderMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderMembershipOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteFolderMembershipOutput) SetRequestId(v string) *DeleteFolderMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteFolderMembershipOutput) SetStatus(v int64) *DeleteFolderMembershipOutput {
	s.Status = &v
	return s
}

type DeleteFolderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the deleted folder.
	Arn *string `type:"string"`

	// The ID of the folder.
	FolderId *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFolderOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteFolderOutput) SetArn(v string) *DeleteFolderOutput {
	s.Arn = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DeleteFolderOutput) SetFolderId(v string) *DeleteFolderOutput {
	s.FolderId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteFolderOutput) SetRequestId(v string) *DeleteFolderOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteFolderOutput) SetStatus(v int64) *DeleteFolderOutput {
	s.Status = &v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to delete.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace of the group that you want to delete.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteGroupInput) SetAwsAccountId(v string) *DeleteGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteGroupInput) SetNamespace(v string) *DeleteGroupInput {
	s.Namespace = &v
	return s
}

type DeleteGroupMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to delete the user from.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The name of the user that you want to delete from the group membership.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace of the group that you want to remove a user from.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteGroupMembershipInput) SetAwsAccountId(v string) *DeleteGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupMembershipInput) SetGroupName(v string) *DeleteGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *DeleteGroupMembershipInput) SetMemberName(v string) *DeleteGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteGroupMembershipInput) SetNamespace(v string) *DeleteGroupMembershipInput {
	s.Namespace = &v
	return s
}

type DeleteGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteGroupMembershipOutput) SetRequestId(v string) *DeleteGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteGroupMembershipOutput) SetStatus(v int64) *DeleteGroupMembershipOutput {
	s.Status = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteGroupOutput) SetRequestId(v string) *DeleteGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteGroupOutput) SetStatus(v int64) *DeleteGroupOutput {
	s.Status = &v
	return s
}

type DeleteIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the assignment.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The Amazon Web Services account ID where you want to delete the IAM policy
	// assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *DeleteIAMPolicyAssignmentInput) SetAssignmentName(v string) *DeleteIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteIAMPolicyAssignmentInput) SetAwsAccountId(v string) *DeleteIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteIAMPolicyAssignmentInput) SetNamespace(v string) *DeleteIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

type DeleteIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *DeleteIAMPolicyAssignmentOutput) SetAssignmentName(v string) *DeleteIAMPolicyAssignmentOutput {
	s.AssignmentName = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteIAMPolicyAssignmentOutput) SetRequestId(v string) *DeleteIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteIAMPolicyAssignmentOutput) SetStatus(v int64) *DeleteIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type DeleteNamespaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that you want to delete the Amazon
	// QuickSight namespace from.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that you want to delete.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNamespaceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteNamespaceInput) SetAwsAccountId(v string) *DeleteNamespaceInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteNamespaceInput) SetNamespace(v string) *DeleteNamespaceInput {
	s.Namespace = &v
	return s
}

type DeleteNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteNamespaceOutput) SetRequestId(v string) *DeleteNamespaceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteNamespaceOutput) SetStatus(v int64) *DeleteNamespaceOutput {
	s.Status = &v
	return s
}

type DeleteTemplateAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name for the template alias. To delete a specific alias, you delete the
	// version that the alias points to. You can specify the alias name, or specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the item to delete.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template that the specified alias is for.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteTemplateAliasInput) SetAliasName(v string) *DeleteTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteTemplateAliasInput) SetAwsAccountId(v string) *DeleteTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateAliasInput) SetTemplateId(v string) *DeleteTemplateAliasInput {
	s.TemplateId = &v
	return s
}

type DeleteTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The name for the template alias.
	AliasName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the template you want to delete.
	Arn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the template associated with the deletion.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteTemplateAliasOutput) SetAliasName(v string) *DeleteTemplateAliasOutput {
	s.AliasName = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteTemplateAliasOutput) SetArn(v string) *DeleteTemplateAliasOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteTemplateAliasOutput) SetRequestId(v string) *DeleteTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteTemplateAliasOutput) SetStatus(v int64) *DeleteTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateAliasOutput) SetTemplateId(v string) *DeleteTemplateAliasOutput {
	s.TemplateId = &v
	return s
}

type DeleteTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the template that
	// you're deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the template you want to delete.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// Specifies the version of the template that you want to delete. If you don't
	// provide a version number, DeleteTemplate deletes all versions of the template.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteTemplateInput) SetAwsAccountId(v string) *DeleteTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateInput) SetTemplateId(v string) *DeleteTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteTemplateInput) SetVersionNumber(v int64) *DeleteTemplateInput {
	s.VersionNumber = &v
	return s
}

type DeleteTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteTemplateOutput) SetArn(v string) *DeleteTemplateOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteTemplateOutput) SetRequestId(v string) *DeleteTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteTemplateOutput) SetStatus(v int64) *DeleteTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DeleteTemplateOutput) SetTemplateId(v string) *DeleteTemplateOutput {
	s.TemplateId = &v
	return s
}

type DeleteThemeAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name for the theme alias to delete.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the theme alias to
	// delete.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the theme that the specified alias is for.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThemeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThemeAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteThemeAliasInput) SetAliasName(v string) *DeleteThemeAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteThemeAliasInput) SetAwsAccountId(v string) *DeleteThemeAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DeleteThemeAliasInput) SetThemeId(v string) *DeleteThemeAliasInput {
	s.ThemeId = &v
	return s
}

type DeleteThemeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The name for the theme alias.
	AliasName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the theme resource using the deleted alias.
	Arn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the theme associated with the deletion.
	ThemeId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeAliasOutput) GoString() string {
	return s.String()
}

// SetAliasName sets the AliasName field's value.
func (s *DeleteThemeAliasOutput) SetAliasName(v string) *DeleteThemeAliasOutput {
	s.AliasName = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DeleteThemeAliasOutput) SetArn(v string) *DeleteThemeAliasOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteThemeAliasOutput) SetRequestId(v string) *DeleteThemeAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteThemeAliasOutput) SetStatus(v int64) *DeleteThemeAliasOutput {
	s.Status = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DeleteThemeAliasOutput) SetThemeId(v string) *DeleteThemeAliasOutput {
	s.ThemeId = &v
	return s
}

type DeleteThemeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the theme that you're
	// deleting.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// An ID for the theme that you want to delete.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// The version of the theme that you want to delete.
	//
	// Note: If you don't provide a version number, you're using this call to DeleteTheme
	// to delete all versions of the theme.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThemeInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteThemeInput) SetAwsAccountId(v string) *DeleteThemeInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DeleteThemeInput) SetThemeId(v string) *DeleteThemeInput {
	s.ThemeId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteThemeInput) SetVersionNumber(v int64) *DeleteThemeInput {
	s.VersionNumber = &v
	return s
}

type DeleteThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// An ID for the theme.
	ThemeId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThemeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteThemeOutput) SetArn(v string) *DeleteThemeOutput {
	s.Arn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteThemeOutput) SetRequestId(v string) *DeleteThemeOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteThemeOutput) SetStatus(v int64) *DeleteThemeOutput {
	s.Status = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DeleteThemeOutput) SetThemeId(v string) *DeleteThemeOutput {
	s.ThemeId = &v
	return s
}

type DeleteUserByPrincipalIdInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the user is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The principal ID of the user.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"PrincipalId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserByPrincipalIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserByPrincipalIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserByPrincipalIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserByPrincipalIdInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteUserByPrincipalIdInput) SetAwsAccountId(v string) *DeleteUserByPrincipalIdInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteUserByPrincipalIdInput) SetNamespace(v string) *DeleteUserByPrincipalIdInput {
	s.Namespace = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteUserByPrincipalIdInput) SetPrincipalId(v string) *DeleteUserByPrincipalIdInput {
	s.PrincipalId = &v
	return s
}

type DeleteUserByPrincipalIdOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserByPrincipalIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserByPrincipalIdOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteUserByPrincipalIdOutput) SetRequestId(v string) *DeleteUserByPrincipalIdOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteUserByPrincipalIdOutput) SetStatus(v int64) *DeleteUserByPrincipalIdOutput {
	s.Status = &v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the user is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the user that you want to delete.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DeleteUserInput) SetAwsAccountId(v string) *DeleteUserInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteUserInput) SetNamespace(v string) *DeleteUserInput {
	s.Namespace = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DeleteUserOutput) SetRequestId(v string) *DeleteUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteUserOutput) SetStatus(v int64) *DeleteUserOutput {
	s.Status = &v
	return s
}

type DescribeAccountCustomizationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that you want to describe Amazon
	// QuickSight customizations for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The Amazon QuickSight namespace that you want to describe Amazon QuickSight
	// customizations for.
	Namespace *string `location:"querystring" locationName:"namespace" type:"string"`

	// The Resolved flag works with the other parameters to determine which view
	// of Amazon QuickSight customizations is returned. You can add this flag to
	// your command to use the same view that Amazon QuickSight uses to identify
	// which customizations to apply to the console. Omit this flag, or set it to
	// no-resolved, to reveal customizations that are configured at different levels.
	Resolved *bool `location:"querystring" locationName:"resolved" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountCustomizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountCustomizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountCustomizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountCustomizationInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeAccountCustomizationInput) SetAwsAccountId(v string) *DescribeAccountCustomizationInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeAccountCustomizationInput) SetNamespace(v string) *DescribeAccountCustomizationInput {
	s.Namespace = &v
	return s
}

// SetResolved sets the Resolved field's value.
func (s *DescribeAccountCustomizationInput) SetResolved(v bool) *DescribeAccountCustomizationInput {
	s.Resolved = &v
	return s
}

type DescribeAccountCustomizationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon QuickSight customizations that exist in the current Amazon Web
	// Services Region.
	AccountCustomization *AccountCustomization `type:"structure"`

	// The Amazon Resource Name (ARN) of the customization that's associated with
	// this Amazon Web Services account.
	Arn *string `type:"string"`

	// The ID for the Amazon Web Services account that you're describing.
	AwsAccountId *string `min:"12" type:"string"`

	// The Amazon QuickSight namespace that you're describing.
	Namespace *string `type:"string"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountCustomizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountCustomizationOutput) GoString() string {
	return s.String()
}

// SetAccountCustomization sets the AccountCustomization field's value.
func (s *DescribeAccountCustomizationOutput) SetAccountCustomization(v *AccountCustomization) *DescribeAccountCustomizationOutput {
	s.AccountCustomization = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeAccountCustomizationOutput) SetArn(v string) *DescribeAccountCustomizationOutput {
	s.Arn = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeAccountCustomizationOutput) SetAwsAccountId(v string) *DescribeAccountCustomizationOutput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeAccountCustomizationOutput) SetNamespace(v string) *DescribeAccountCustomizationOutput {
	s.Namespace = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeAccountCustomizationOutput) SetRequestId(v string) *DescribeAccountCustomizationOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAccountCustomizationOutput) SetStatus(v int64) *DescribeAccountCustomizationOutput {
	s.Status = &v
	return s
}

type DescribeAccountSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the settings that
	// you want to list.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountSettingsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeAccountSettingsInput) SetAwsAccountId(v string) *DescribeAccountSettingsInput {
	s.AwsAccountId = &v
	return s
}

type DescribeAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon QuickSight settings for this Amazon Web Services account. This
	// information includes the edition of Amazon Amazon QuickSight that you subscribed
	// to (Standard or Enterprise) and the notification email for the Amazon QuickSight
	// subscription. In the QuickSight console, the Amazon QuickSight subscription
	// is sometimes referred to as a QuickSight "account" even though it's technically
	// not an account by itself. Instead, it's a subscription to the Amazon QuickSight
	// service for your Amazon Web Services account. The edition that you subscribe
	// to applies to Amazon QuickSight in every Amazon Web Services Region where
	// you use it.
	AccountSettings *AccountSettings `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *DescribeAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *DescribeAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeAccountSettingsOutput) SetRequestId(v string) *DescribeAccountSettingsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAccountSettingsOutput) SetStatus(v int64) *DescribeAccountSettingsOutput {
	s.Status = &v
	return s
}

type DescribeAnalysisInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the analysis that you're describing. The ID is part of the URL
	// of the analysis.
	//
	// AnalysisId is a required field
	AnalysisId *string `location:"uri" locationName:"AnalysisId" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the analysis. You
	// must be using the Amazon Web Services account that the analysis is in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnalysisInput"}
	if s.AnalysisId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisId"))
	}
	if s.AnalysisId != nil && len(*s.AnalysisId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisId", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *DescribeAnalysisInput) SetAnalysisId(v string) *DescribeAnalysisInput {
	s.AnalysisId = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeAnalysisInput) SetAwsAccountId(v string) *DescribeAnalysisInput {
	s.AwsAccountId = &v
	return s
}

type DescribeAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// A metadata structure that contains summary information for the analysis that
	// you're describing.
	Analysis *Analysis `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalysis sets the Analysis field's value.
func (s *DescribeAnalysisOutput) SetAnalysis(v *Analysis) *DescribeAnalysisOutput {
	s.Analysis = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeAnalysisOutput) SetRequestId(v string) *DescribeAnalysisOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAnalysisOutput) SetStatus(v int64) *DescribeAnalysisOutput {
	s.Status = &v
	return s
}

type DescribeAnalysisPermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the analysis whose permissions you're describing. The ID is part
	// of the analysis URL.
	//
	// AnalysisId is a required field
	AnalysisId *string `location:"uri" locationName:"AnalysisId" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the analysis whose
	// permissions you're describing. You must be using the Amazon Web Services
	// account that the analysis is in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnalysisPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnalysisPermissionsInput"}
	if s.AnalysisId == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalysisId"))
	}
	if s.AnalysisId != nil && len(*s.AnalysisId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnalysisId", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *DescribeAnalysisPermissionsInput) SetAnalysisId(v string) *DescribeAnalysisPermissionsInput {
	s.AnalysisId = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeAnalysisPermissionsInput) SetAwsAccountId(v string) *DescribeAnalysisPermissionsInput {
	s.AwsAccountId = &v
	return s
}

type DescribeAnalysisPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the analysis whose permissions you're describing.
	AnalysisArn *string `type:"string"`

	// The ID of the analysis whose permissions you're describing.
	AnalysisId *string `min:"1" type:"string"`

	// A structure that describes the principals and the resource-level permissions
	// on an analysis.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAnalysisPermissionsOutput) GoString() string {
	return s.String()
}

// SetAnalysisArn sets the AnalysisArn field's value.
func (s *DescribeAnalysisPermissionsOutput) SetAnalysisArn(v string) *DescribeAnalysisPermissionsOutput {
	s.AnalysisArn = &v
	return s
}

// SetAnalysisId sets the AnalysisId field's value.
func (s *DescribeAnalysisPermissionsOutput) SetAnalysisId(v string) *DescribeAnalysisPermissionsOutput {
	s.AnalysisId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeAnalysisPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeAnalysisPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeAnalysisPermissionsOutput) SetRequestId(v string) *DescribeAnalysisPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeAnalysisPermissionsOutput) SetStatus(v int64) *DescribeAnalysisPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeDashboardInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias name.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// The ID of the Amazon Web Services account that contains the dashboard that
	// you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The version number for the dashboard. If a version number isn't passed, the
	// latest published dashboard version is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDashboardInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeDashboardInput) SetAliasName(v string) *DescribeDashboardInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDashboardInput) SetAwsAccountId(v string) *DescribeDashboardInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardInput) SetDashboardId(v string) *DescribeDashboardInput {
	s.DashboardId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DescribeDashboardInput) SetVersionNumber(v int64) *DescribeDashboardInput {
	s.VersionNumber = &v
	return s
}

type DescribeDashboardOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dashboard.
	Dashboard *Dashboard `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of this request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardOutput) GoString() string {
	return s.String()
}

// SetDashboard sets the Dashboard field's value.
func (s *DescribeDashboardOutput) SetDashboard(v *Dashboard) *DescribeDashboardOutput {
	s.Dashboard = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDashboardOutput) SetRequestId(v string) *DescribeDashboardOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDashboardOutput) SetStatus(v int64) *DescribeDashboardOutput {
	s.Status = &v
	return s
}

type DescribeDashboardPermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the dashboard that
	// you're describing permissions for.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to the IAM policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDashboardPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDashboardPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDashboardPermissionsInput) SetAwsAccountId(v string) *DescribeDashboardPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardPermissionsInput) SetDashboardId(v string) *DescribeDashboardPermissionsInput {
	s.DashboardId = &v
	return s
}

type DescribeDashboardPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dashboard.
	DashboardArn *string `type:"string"`

	// The ID for the dashboard.
	DashboardId *string `min:"1" type:"string"`

	// A structure that contains the configuration of a shareable link that grants
	// access to the dashboard. Your users can use the link to view and interact
	// with the dashboard, if the dashboard has been shared with them. For more
	// information about sharing dashboards, see Sharing Dashboards (https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html).
	LinkSharingConfiguration *LinkSharingConfiguration `type:"structure"`

	// A structure that contains the permissions for the dashboard.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDashboardPermissionsOutput) GoString() string {
	return s.String()
}

// SetDashboardArn sets the DashboardArn field's value.
func (s *DescribeDashboardPermissionsOutput) SetDashboardArn(v string) *DescribeDashboardPermissionsOutput {
	s.DashboardArn = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *DescribeDashboardPermissionsOutput) SetDashboardId(v string) *DescribeDashboardPermissionsOutput {
	s.DashboardId = &v
	return s
}

// SetLinkSharingConfiguration sets the LinkSharingConfiguration field's value.
func (s *DescribeDashboardPermissionsOutput) SetLinkSharingConfiguration(v *LinkSharingConfiguration) *DescribeDashboardPermissionsOutput {
	s.LinkSharingConfiguration = v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeDashboardPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeDashboardPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDashboardPermissionsOutput) SetRequestId(v string) *DescribeDashboardPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDashboardPermissionsOutput) SetStatus(v int64) *DescribeDashboardPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeDataSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSetInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSetInput) SetAwsAccountId(v string) *DescribeDataSetInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeDataSetInput) SetDataSetId(v string) *DescribeDataSetInput {
	s.DataSetId = &v
	return s
}

type DescribeDataSetOutput struct {
	_ struct{} `type:"structure"`

	// Information on the dataset.
	DataSet *DataSet `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetOutput) GoString() string {
	return s.String()
}

// SetDataSet sets the DataSet field's value.
func (s *DescribeDataSetOutput) SetDataSet(v *DataSet) *DescribeDataSetOutput {
	s.DataSet = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSetOutput) SetRequestId(v string) *DescribeDataSetOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSetOutput) SetStatus(v int64) *DescribeDataSetOutput {
	s.Status = &v
	return s
}

type DescribeDataSetPermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSetPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSetPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSetPermissionsInput) SetAwsAccountId(v string) *DescribeDataSetPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeDataSetPermissionsInput) SetDataSetId(v string) *DescribeDataSetPermissionsInput {
	s.DataSetId = &v
	return s
}

type DescribeDataSetPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset.
	DataSetArn *string `type:"string"`

	// The ID for the dataset that you want to create. This ID is unique per Amazon
	// Web Services Region for each Amazon Web Services account.
	DataSetId *string `type:"string"`

	// A list of resource permissions on the dataset.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSetPermissionsOutput) GoString() string {
	return s.String()
}

// SetDataSetArn sets the DataSetArn field's value.
func (s *DescribeDataSetPermissionsOutput) SetDataSetArn(v string) *DescribeDataSetPermissionsOutput {
	s.DataSetArn = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeDataSetPermissionsOutput) SetDataSetId(v string) *DescribeDataSetPermissionsOutput {
	s.DataSetId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeDataSetPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeDataSetPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSetPermissionsOutput) SetRequestId(v string) *DescribeDataSetPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSetPermissionsOutput) SetStatus(v int64) *DescribeDataSetPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSourceInput) SetAwsAccountId(v string) *DescribeDataSourceInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribeDataSourceInput) SetDataSourceId(v string) *DescribeDataSourceInput {
	s.DataSourceId = &v
	return s
}

type DescribeDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The information on the data source.
	DataSource *DataSource `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *DescribeDataSourceOutput) SetDataSource(v *DataSource) *DescribeDataSourceOutput {
	s.DataSource = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSourceOutput) SetRequestId(v string) *DescribeDataSourceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSourceOutput) SetStatus(v int64) *DescribeDataSourceOutput {
	s.Status = &v
	return s
}

type DescribeDataSourcePermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"DataSourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourcePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourcePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDataSourcePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDataSourcePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeDataSourcePermissionsInput) SetAwsAccountId(v string) *DescribeDataSourcePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribeDataSourcePermissionsInput) SetDataSourceId(v string) *DescribeDataSourcePermissionsInput {
	s.DataSourceId = &v
	return s
}

type DescribeDataSourcePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string `type:"string"`

	// The ID of the data source. This ID is unique per Amazon Web Services Region
	// for each Amazon Web Services account.
	DataSourceId *string `type:"string"`

	// A list of resource permissions on the data source.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourcePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDataSourcePermissionsOutput) GoString() string {
	return s.String()
}

// SetDataSourceArn sets the DataSourceArn field's value.
func (s *DescribeDataSourcePermissionsOutput) SetDataSourceArn(v string) *DescribeDataSourcePermissionsOutput {
	s.DataSourceArn = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DescribeDataSourcePermissionsOutput) SetDataSourceId(v string) *DescribeDataSourcePermissionsOutput {
	s.DataSourceId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeDataSourcePermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeDataSourcePermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeDataSourcePermissionsOutput) SetRequestId(v string) *DescribeDataSourcePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDataSourcePermissionsOutput) SetStatus(v int64) *DescribeDataSourcePermissionsOutput {
	s.Status = &v
	return s
}

type DescribeFolderInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFolderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFolderInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeFolderInput) SetAwsAccountId(v string) *DescribeFolderInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DescribeFolderInput) SetFolderId(v string) *DescribeFolderInput {
	s.FolderId = &v
	return s
}

type DescribeFolderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the folder.
	Folder *Folder `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderOutput) GoString() string {
	return s.String()
}

// SetFolder sets the Folder field's value.
func (s *DescribeFolderOutput) SetFolder(v *Folder) *DescribeFolderOutput {
	s.Folder = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeFolderOutput) SetRequestId(v string) *DescribeFolderOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeFolderOutput) SetStatus(v int64) *DescribeFolderOutput {
	s.Status = &v
	return s
}

type DescribeFolderPermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFolderPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFolderPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeFolderPermissionsInput) SetAwsAccountId(v string) *DescribeFolderPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DescribeFolderPermissionsInput) SetFolderId(v string) *DescribeFolderPermissionsInput {
	s.FolderId = &v
	return s
}

type DescribeFolderPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the folder.
	Arn *string `type:"string"`

	// The ID of the folder.
	FolderId *string `min:"1" type:"string"`

	// Information about the permissions on the folder.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderPermissionsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeFolderPermissionsOutput) SetArn(v string) *DescribeFolderPermissionsOutput {
	s.Arn = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DescribeFolderPermissionsOutput) SetFolderId(v string) *DescribeFolderPermissionsOutput {
	s.FolderId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeFolderPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeFolderPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeFolderPermissionsOutput) SetRequestId(v string) *DescribeFolderPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeFolderPermissionsOutput) SetStatus(v int64) *DescribeFolderPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeFolderResolvedPermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the folder.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderResolvedPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderResolvedPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFolderResolvedPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFolderResolvedPermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.FolderId == nil {
		invalidParams.Add(request.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeFolderResolvedPermissionsInput) SetAwsAccountId(v string) *DescribeFolderResolvedPermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DescribeFolderResolvedPermissionsInput) SetFolderId(v string) *DescribeFolderResolvedPermissionsInput {
	s.FolderId = &v
	return s
}

type DescribeFolderResolvedPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the folder.
	Arn *string `type:"string"`

	// The ID of the folder.
	FolderId *string `min:"1" type:"string"`

	// Information about the permissions for the folder.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderResolvedPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFolderResolvedPermissionsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeFolderResolvedPermissionsOutput) SetArn(v string) *DescribeFolderResolvedPermissionsOutput {
	s.Arn = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *DescribeFolderResolvedPermissionsOutput) SetFolderId(v string) *DescribeFolderResolvedPermissionsOutput {
	s.FolderId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeFolderResolvedPermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeFolderResolvedPermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeFolderResolvedPermissionsOutput) SetRequestId(v string) *DescribeFolderResolvedPermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeFolderResolvedPermissionsOutput) SetStatus(v int64) *DescribeFolderResolvedPermissionsOutput {
	s.Status = &v
	return s
}

type DescribeGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to describe.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The namespace of the group that you want described.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeGroupInput) SetAwsAccountId(v string) *DescribeGroupInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DescribeGroupInput) SetGroupName(v string) *DescribeGroupInput {
	s.GroupName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeGroupInput) SetNamespace(v string) *DescribeGroupInput {
	s.Namespace = &v
	return s
}

type DescribeGroupMembershipInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the group is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The name of the group that you want to search.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The user name of the user that you want to search for.
	//
	// MemberName is a required field
	MemberName *string `location:"uri" locationName:"MemberName" min:"1" type:"string" required:"true"`

	// The namespace that includes the group you are searching within.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupMembershipInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MemberName == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberName"))
	}
	if s.MemberName != nil && len(*s.MemberName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeGroupMembershipInput) SetAwsAccountId(v string) *DescribeGroupMembershipInput {
	s.AwsAccountId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DescribeGroupMembershipInput) SetGroupName(v string) *DescribeGroupMembershipInput {
	s.GroupName = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *DescribeGroupMembershipInput) SetMemberName(v string) *DescribeGroupMembershipInput {
	s.MemberName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeGroupMembershipInput) SetNamespace(v string) *DescribeGroupMembershipInput {
	s.Namespace = &v
	return s
}

type DescribeGroupMembershipOutput struct {
	_ struct{} `type:"structure"`

	// A member of an Amazon QuickSight group. Currently, group members must be
	// users. Groups can't be members of another group. .
	GroupMember *GroupMember `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupMembershipOutput) GoString() string {
	return s.String()
}

// SetGroupMember sets the GroupMember field's value.
func (s *DescribeGroupMembershipOutput) SetGroupMember(v *GroupMember) *DescribeGroupMembershipOutput {
	s.GroupMember = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeGroupMembershipOutput) SetRequestId(v string) *DescribeGroupMembershipOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeGroupMembershipOutput) SetStatus(v int64) *DescribeGroupMembershipOutput {
	s.Status = &v
	return s
}

type DescribeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	Group *Group `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *DescribeGroupOutput) SetGroup(v *Group) *DescribeGroupOutput {
	s.Group = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeGroupOutput) SetRequestId(v string) *DescribeGroupOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeGroupOutput) SetStatus(v int64) *DescribeGroupOutput {
	s.Status = &v
	return s
}

type DescribeIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the assignment, also called a rule.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the assignment that
	// you want to describe.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that contains the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIAMPolicyAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIAMPolicyAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIAMPolicyAssignmentInput"}
	if s.AssignmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *DescribeIAMPolicyAssignmentInput) SetAssignmentName(v string) *DescribeIAMPolicyAssignmentInput {
	s.AssignmentName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeIAMPolicyAssignmentInput) SetAwsAccountId(v string) *DescribeIAMPolicyAssignmentInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeIAMPolicyAssignmentInput) SetNamespace(v string) *DescribeIAMPolicyAssignmentInput {
	s.Namespace = &v
	return s
}

type DescribeIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// Information describing the IAM policy assignment.
	IAMPolicyAssignment *IAMPolicyAssignment `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIAMPolicyAssignmentOutput) GoString() string {
	return s.String()
}

// SetIAMPolicyAssignment sets the IAMPolicyAssignment field's value.
func (s *DescribeIAMPolicyAssignmentOutput) SetIAMPolicyAssignment(v *IAMPolicyAssignment) *DescribeIAMPolicyAssignmentOutput {
	s.IAMPolicyAssignment = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeIAMPolicyAssignmentOutput) SetRequestId(v string) *DescribeIAMPolicyAssignmentOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIAMPolicyAssignmentOutput) SetStatus(v int64) *DescribeIAMPolicyAssignmentOutput {
	s.Status = &v
	return s
}

type DescribeIngestionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Web Services account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID of the dataset used in the ingestion.
	//
	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	// An ID for the ingestion.
	//
	// IngestionId is a required field
	IngestionId *string `location:"uri" locationName:"IngestionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIngestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIngestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIngestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIngestionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DataSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSetId"))
	}
	if s.DataSetId != nil && len(*s.DataSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSetId", 1))
	}
	if s.IngestionId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionId"))
	}
	if s.IngestionId != nil && len(*s.IngestionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeIngestionInput) SetAwsAccountId(v string) *DescribeIngestionInput {
	s.AwsAccountId = &v
	return s
}

// SetDataSetId sets the DataSetId field's value.
func (s *DescribeIngestionInput) SetDataSetId(v string) *DescribeIngestionInput {
	s.DataSetId = &v
	return s
}

// SetIngestionId sets the IngestionId field's value.
func (s *DescribeIngestionInput) SetIngestionId(v string) *DescribeIngestionInput {
	s.IngestionId = &v
	return s
}

type DescribeIngestionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ingestion.
	Ingestion *Ingestion `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIngestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIngestionOutput) GoString() string {
	return s.String()
}

// SetIngestion sets the Ingestion field's value.
func (s *DescribeIngestionOutput) SetIngestion(v *Ingestion) *DescribeIngestionOutput {
	s.Ingestion = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeIngestionOutput) SetRequestId(v string) *DescribeIngestionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIngestionOutput) SetStatus(v int64) *DescribeIngestionOutput {
	s.Status = &v
	return s
}

type DescribeIpRestrictionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the IP rules.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpRestrictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpRestrictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIpRestrictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIpRestrictionInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeIpRestrictionInput) SetAwsAccountId(v string) *DescribeIpRestrictionInput {
	s.AwsAccountId = &v
	return s
}

type DescribeIpRestrictionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services account that contains the IP rules.
	AwsAccountId *string `min:"12" type:"string"`

	// A value that specifies whether IP rules are turned on.
	Enabled *bool `type:"boolean"`

	// A map that describes the IP rules with CIDR range and description.
	IpRestrictionRuleMap map[string]*string `type:"map"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpRestrictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpRestrictionOutput) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeIpRestrictionOutput) SetAwsAccountId(v string) *DescribeIpRestrictionOutput {
	s.AwsAccountId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *DescribeIpRestrictionOutput) SetEnabled(v bool) *DescribeIpRestrictionOutput {
	s.Enabled = &v
	return s
}

// SetIpRestrictionRuleMap sets the IpRestrictionRuleMap field's value.
func (s *DescribeIpRestrictionOutput) SetIpRestrictionRuleMap(v map[string]*string) *DescribeIpRestrictionOutput {
	s.IpRestrictionRuleMap = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeIpRestrictionOutput) SetRequestId(v string) *DescribeIpRestrictionOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeIpRestrictionOutput) SetStatus(v int64) *DescribeIpRestrictionOutput {
	s.Status = &v
	return s
}

type DescribeNamespaceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that contains the Amazon QuickSight
	// namespace that you want to describe.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace that you want to describe.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNamespaceInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeNamespaceInput) SetAwsAccountId(v string) *DescribeNamespaceInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeNamespaceInput) SetNamespace(v string) *DescribeNamespaceInput {
	s.Namespace = &v
	return s
}

type DescribeNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The information about the namespace that you're describing. The response
	// includes the namespace ARN, name, Amazon Web Services Region, creation status,
	// and identity store. DescribeNamespace also works for namespaces that are
	// in the process of being created. For incomplete namespaces, this API operation
	// lists the namespace error types and messages associated with the creation
	// process.
	Namespace *NamespaceInfoV2 `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeNamespaceOutput) SetNamespace(v *NamespaceInfoV2) *DescribeNamespaceOutput {
	s.Namespace = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeNamespaceOutput) SetRequestId(v string) *DescribeNamespaceOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeNamespaceOutput) SetStatus(v int64) *DescribeNamespaceOutput {
	s.Status = &v
	return s
}

type DescribeTemplateAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the template alias that you want to describe. If you name a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the template alias
	// that you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTemplateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeTemplateAliasInput) SetAliasName(v string) *DescribeTemplateAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeTemplateAliasInput) SetAwsAccountId(v string) *DescribeTemplateAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplateAliasInput) SetTemplateId(v string) *DescribeTemplateAliasInput {
	s.TemplateId = &v
	return s
}

type DescribeTemplateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the template alias.
	TemplateAlias *TemplateAlias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeTemplateAliasOutput) SetRequestId(v string) *DescribeTemplateAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTemplateAliasOutput) SetStatus(v int64) *DescribeTemplateAliasOutput {
	s.Status = &v
	return s
}

// SetTemplateAlias sets the TemplateAlias field's value.
func (s *DescribeTemplateAliasOutput) SetTemplateAlias(v *TemplateAlias) *DescribeTemplateAliasOutput {
	s.TemplateAlias = v
	return s
}

type DescribeTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the template that you want to describe. If you name a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the template by providing the keyword $LATEST in the
	// AliasName parameter. The keyword $PUBLISHED doesn't apply to templates.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// The ID of the Amazon Web Services account that contains the template that
	// you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`

	// (Optional) The number for the version to describe. If a VersionNumber parameter
	// value isn't provided, the latest version of the template is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTemplateInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeTemplateInput) SetAliasName(v string) *DescribeTemplateInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeTemplateInput) SetAwsAccountId(v string) *DescribeTemplateInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplateInput) SetTemplateId(v string) *DescribeTemplateInput {
	s.TemplateId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DescribeTemplateInput) SetVersionNumber(v int64) *DescribeTemplateInput {
	s.VersionNumber = &v
	return s
}

type DescribeTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The template structure for the object you want to describe.
	Template *Template `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplateOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeTemplateOutput) SetRequestId(v string) *DescribeTemplateOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTemplateOutput) SetStatus(v int64) *DescribeTemplateOutput {
	s.Status = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *DescribeTemplateOutput) SetTemplate(v *Template) *DescribeTemplateOutput {
	s.Template = v
	return s
}

type DescribeTemplatePermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the template that
	// you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplatePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplatePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTemplatePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTemplatePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeTemplatePermissionsInput) SetAwsAccountId(v string) *DescribeTemplatePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplatePermissionsInput) SetTemplateId(v string) *DescribeTemplatePermissionsInput {
	s.TemplateId = &v
	return s
}

type DescribeTemplatePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of resource permissions to be set on the template.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The Amazon Resource Name (ARN) of the template.
	TemplateArn *string `type:"string"`

	// The ID for the template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplatePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTemplatePermissionsOutput) GoString() string {
	return s.String()
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeTemplatePermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeTemplatePermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeTemplatePermissionsOutput) SetRequestId(v string) *DescribeTemplatePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeTemplatePermissionsOutput) SetStatus(v int64) *DescribeTemplatePermissionsOutput {
	s.Status = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *DescribeTemplatePermissionsOutput) SetTemplateArn(v string) *DescribeTemplatePermissionsOutput {
	s.TemplateArn = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *DescribeTemplatePermissionsOutput) SetTemplateId(v string) *DescribeTemplatePermissionsOutput {
	s.TemplateId = &v
	return s
}

type DescribeThemeAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the theme alias that you want to describe.
	//
	// AliasName is a required field
	AliasName *string `location:"uri" locationName:"AliasName" min:"1" type:"string" required:"true"`

	// The ID of the Amazon Web Services account that contains the theme alias that
	// you're describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThemeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThemeAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeThemeAliasInput) SetAliasName(v string) *DescribeThemeAliasInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeThemeAliasInput) SetAwsAccountId(v string) *DescribeThemeAliasInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DescribeThemeAliasInput) SetThemeId(v string) *DescribeThemeAliasInput {
	s.ThemeId = &v
	return s
}

type DescribeThemeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// Information about the theme alias.
	ThemeAlias *ThemeAlias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeAliasOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeThemeAliasOutput) SetRequestId(v string) *DescribeThemeAliasOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeThemeAliasOutput) SetStatus(v int64) *DescribeThemeAliasOutput {
	s.Status = &v
	return s
}

// SetThemeAlias sets the ThemeAlias field's value.
func (s *DescribeThemeAliasOutput) SetThemeAlias(v *ThemeAlias) *DescribeThemeAliasOutput {
	s.ThemeAlias = v
	return s
}

type DescribeThemeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The alias of the theme that you want to describe. If you name a specific
	// alias, you describe the version that the alias points to. You can specify
	// the latest version of the theme by providing the keyword $LATEST in the AliasName
	// parameter. The keyword $PUBLISHED doesn't apply to themes.
	AliasName *string `location:"querystring" locationName:"alias-name" min:"1" type:"string"`

	// The ID of the Amazon Web Services account that contains the theme that you're
	// describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" type:"string" required:"true"`

	// The ID for the theme.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`

	// The version number for the version to describe. If a VersionNumber parameter
	// value isn't provided, the latest version of the theme is described.
	VersionNumber *int64 `location:"querystring" locationName:"version-number" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThemeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThemeInput"}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 1))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}
	if s.VersionNumber != nil && *s.VersionNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasName sets the AliasName field's value.
func (s *DescribeThemeInput) SetAliasName(v string) *DescribeThemeInput {
	s.AliasName = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeThemeInput) SetAwsAccountId(v string) *DescribeThemeInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DescribeThemeInput) SetThemeId(v string) *DescribeThemeInput {
	s.ThemeId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DescribeThemeInput) SetVersionNumber(v int64) *DescribeThemeInput {
	s.VersionNumber = &v
	return s
}

type DescribeThemeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The information about the theme that you are describing.
	Theme *Theme `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemeOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeThemeOutput) SetRequestId(v string) *DescribeThemeOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeThemeOutput) SetStatus(v int64) *DescribeThemeOutput {
	s.Status = &v
	return s
}

// SetTheme sets the Theme field's value.
func (s *DescribeThemeOutput) SetTheme(v *Theme) *DescribeThemeOutput {
	s.Theme = v
	return s
}

type DescribeThemePermissionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon Web Services account that contains the theme that you're
	// describing.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the theme that you want to describe permissions for.
	//
	// ThemeId is a required field
	ThemeId *string `location:"uri" locationName:"ThemeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThemePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThemePermissionsInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ThemeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ThemeId"))
	}
	if s.ThemeId != nil && len(*s.ThemeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThemeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeThemePermissionsInput) SetAwsAccountId(v string) *DescribeThemePermissionsInput {
	s.AwsAccountId = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DescribeThemePermissionsInput) SetThemeId(v string) *DescribeThemePermissionsInput {
	s.ThemeId = &v
	return s
}

type DescribeThemePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of resource permissions set on the theme.
	Permissions []*ResourcePermission `min:"1" type:"list"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The Amazon Resource Name (ARN) of the theme.
	ThemeArn *string `type:"string"`

	// The ID for the theme.
	ThemeId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThemePermissionsOutput) GoString() string {
	return s.String()
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeThemePermissionsOutput) SetPermissions(v []*ResourcePermission) *DescribeThemePermissionsOutput {
	s.Permissions = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeThemePermissionsOutput) SetRequestId(v string) *DescribeThemePermissionsOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeThemePermissionsOutput) SetStatus(v int64) *DescribeThemePermissionsOutput {
	s.Status = &v
	return s
}

// SetThemeArn sets the ThemeArn field's value.
func (s *DescribeThemePermissionsOutput) SetThemeArn(v string) *DescribeThemePermissionsOutput {
	s.ThemeArn = &v
	return s
}

// SetThemeId sets the ThemeId field's value.
func (s *DescribeThemePermissionsOutput) SetThemeId(v string) *DescribeThemePermissionsOutput {
	s.ThemeId = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account that the user is in. Currently,
	// you use the ID for the Amazon Web Services account that contains your Amazon
	// QuickSight account.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The namespace. Currently, you should set this to default.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The name of the user that you want to describe.
	//
	// UserName is a required field
	UserName *string `location:"uri" locationName:"UserName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *DescribeUserInput) SetAwsAccountId(v string) *DescribeUserInput {
	s.AwsAccountId = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *DescribeUserInput) SetNamespace(v string) *DescribeUserInput {
	s.Namespace = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserInput) SetUserName(v string) *DescribeUserInput {
	s.UserName = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`

	// The user name.
	User *User `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeUserOutput) SetRequestId(v string) *DescribeUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeUserOutput) SetStatus(v int64) *DescribeUserOutput {
	s.Status = &v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *User) *DescribeUserOutput {
	s.User = v
	return s
}

// The domain specified isn't on the allow list. All domains for embedded dashboards
// must be added to the approved list by an Amazon QuickSight admin.
type DomainNotWhitelistedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The Amazon Web Services request ID for this request.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainNotWhitelistedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainNotWhitelistedException) GoString() string {
	return s.String()
}

func newErrorDomainNotWhitelistedException(v protocol.ResponseMetadata) error {
	return &DomainNotWhitelistedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DomainNotWhitelistedException) Code() string {
	return "DomainNotWhitelistedException"
}

// Message returns the exception's message.
func (s *DomainNotWhitelistedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DomainNotWhitelistedException) OrigErr() error {
	return nil
}

func (s *DomainNotWhitelistedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DomainNotWhitelistedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DomainNotWhitelistedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Error information for the SPICE ingestion of a dataset.
type ErrorInfo struct {
	_ struct{} `type:"structure"`

	// Error message.
	Message *string `type:"string"`

	// Error type.
	Type *string `type:"string" enum:"IngestionErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorInfo) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ErrorInfo) SetMessage(v string) *ErrorInfo {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *ErrorInfo) SetType(v string) *ErrorInfo {
	s.Type = &v
	return s
}

// The required parameters for connecting to an Exasol data source.
type ExasolParameters struct {
	_ struct{} `type:"structure"`

	// The hostname or IP address of the Exasol data source.
	//
	// Host is a required field
	Host *string `min:"1" type:"string" required:"true"`

	// The port for the Exasol data source.
	//
	// Port is a required field
	Port *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExasolParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExasolParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExasolParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExasolParameters"}
	if s.Host == nil {
		invalidParams.Add(request.NewErrParamRequired("Host"))
	}
	if s.Host != nil && len(*s.Host) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Host", 1))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Port", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *ExasolParameters) SetHost(v string) *ExasolParameters {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ExasolParameters) SetPort(v int64) *ExasolParameters {
	s.Port = &v
	return s
}

// Export to .csv option.
type ExportToCSVOption struct {
	_ struct{} `type:"structure"`

	// Availability status.
	AvailabilityStatus *string `type:"string" enum:"DashboardBehavior"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportToCSVOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportToCSVOption) GoString() string {
	return s.String()
}

// SetAvailabilityStatus sets the AvailabilityStatus field's value.
func (s *ExportToCSVOption) SetAvailabilityStatus(v string) *ExportToCSVOption {
	s.AvailabilityStatus = &v
	return s
}

// A FieldFolder element is a folder that contains fields and nested subfolders.
type FieldFolder struct {
	_ struct{} `type:"structure"`

	// A folder has a list of columns. A column can only be in one folder.
	Columns []*string `locationName:"columns" type:"list"`

	// The description for a field folder.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldFolder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldFolder) GoString() string {
	return s.String()
}

// SetColumns sets the Columns field's value.
func (s *FieldFolder) SetColumns(v []*string) *FieldFolder {
	s.Columns = v
	return s
}

// SetDescription sets the Description field's value.
func (s *FieldFolder) SetDescription(v string) *FieldFolder {
	s.Description = &v
	return s
}

// A transform operation that filters rows based on a condition.
type FilterOperation struct {
	_ struct{} `type:"structure"`

	// An expression that must evaluate to a Boolean value. Rows for which the expression
	// evaluates to true are kept in the dataset.
	//
	// ConditionExpression is a required field
	ConditionExpression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterOperation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterOperation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterOperation"}
	if s.ConditionExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionExpression"))
	}
	if s.ConditionExpression != nil && len(*s.ConditionExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *FilterOperation) SetConditionExpression(v string) *FilterOperation {
	s.ConditionExpression = &v
	return s
}

// A folder in Amazon QuickSight.
type Folder struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the folder.
	Arn *string `type:"string"`

	// The time that the folder was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the folder.
	FolderId *string `min:"1" type:"string"`

	// An array of ancestor ARN strings for the folder.
	FolderPath []*string `min:"1" type:"list"`

	// The type of folder it is.
	FolderType *string `type:"string" enum:"FolderType"`

	// The time that the folder was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A display name for the folder.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Folder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Folder) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Folder) SetArn(v string) *Folder {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Folder) SetCreatedTime(v time.Time) *Folder {
	s.CreatedTime = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *Folder) SetFolderId(v string) *Folder {
	s.FolderId = &v
	return s
}

// SetFolderPath sets the FolderPath field's value.
func (s *Folder) SetFolderPath(v []*string) *Folder {
	s.FolderPath = v
	return s
}

// SetFolderType sets the FolderType field's value.
func (s *Folder) SetFolderType(v string) *Folder {
	s.FolderType = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Folder) SetLastUpdatedTime(v time.Time) *Folder {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Folder) SetName(v string) *Folder {
	s.Name = &v
	return s
}

// An asset in a Amazon QuickSight folder, such as a dashboard, analysis, or
// dataset.
type FolderMember struct {
	_ struct{} `type:"structure"`

	// The ID of an asset in the folder.
	MemberId *string `min:"1" type:"string"`

	// The type of asset that it is.
	MemberType *string `type:"string" enum:"MemberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FolderMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FolderMember) GoString() string {
	return s.String()
}

// SetMemberId sets the MemberId field's value.
func (s *FolderMember) SetMemberId(v string) *FolderMember {
	s.MemberId = &v
	return s
}

// SetMemberType sets the MemberType field's value.
func (s *FolderMember) SetMemberType(v string) *FolderMember {
	s.MemberType = &v
	return s
}

// A filter to use to search a Amazon QuickSight folder.
type FolderSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of a value that you want to use in the filter. For example, "Name":
	// "PARENT_FOLDER_ARN".
	Name *string `type:"string" enum:"FolderFilterAttribute"`

	// The comparison operator that you want to use in the filter. For example,
	// "Operator": "StringEquals".
	Operator *string `type:"string" enum:"FilterOperator"`

	// The value of the named item (in this example, PARENT_FOLDER_ARN), that you
	// want to use as a filter. For example, "Value": "arn:aws:quicksight:us-east-1:1:folder/folderId".
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FolderSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FolderSearchFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FolderSearchFilter) SetName(v string) *FolderSearchFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *FolderSearchFilter) SetOperator(v string) *FolderSearchFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FolderSearchFilter) SetValue(v string) *FolderSearchFilter {
	s.Value = &v
	return s
}

// A summary of information about an existing Amazon QuickSight folder.
type FolderSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the folder.
	Arn *string `type:"string"`

	// The time that the folder was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The ID of the folder.
	FolderId *string `min:"1" type:"string"`

	// The type of folder.
	FolderType *string `type:"string" enum:"FolderType"`

	// The time that the folder was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The display name of the folder.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FolderSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FolderSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FolderSummary) SetArn(v string) *FolderSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *FolderSummary) SetCreatedTime(v time.Time) *FolderSummary {
	s.CreatedTime = &v
	return s
}

// SetFolderId sets the FolderId field's value.
func (s *FolderSummary) SetFolderId(v string) *FolderSummary {
	s.FolderId = &v
	return s
}

// SetFolderType sets the FolderType field's value.
func (s *FolderSummary) SetFolderType(v string) *FolderSummary {
	s.FolderType = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *FolderSummary) SetLastUpdatedTime(v time.Time) *FolderSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FolderSummary) SetName(v string) *FolderSummary {
	s.Name = &v
	return s
}

type GenerateEmbedUrlForAnonymousUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names for the Amazon QuickSight resources that the user
	// is authorized to access during the lifetime of the session. If you choose
	// Dashboard embedding experience, pass the list of dashboard ARNs in the account
	// that you want the user to be able to view. Currently, you can pass up to
	// 25 dashboard ARNs in each API call.
	//
	// AuthorizedResourceArns is a required field
	AuthorizedResourceArns []*string `type:"list" required:"true"`

	// The ID for the Amazon Web Services account that contains the dashboard that
	// you're embedding.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The configuration of the experience you are embedding.
	//
	// ExperienceConfiguration is a required field
	ExperienceConfiguration *AnonymousUserEmbeddingExperienceConfiguration `type:"structure" required:"true"`

	// The Amazon QuickSight namespace that the anonymous user virtually belongs
	// to. If you are not using an Amazon QuickSight custom namespace, set this
	// to default.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// How many minutes the session is valid. The session lifetime must be in [15-600]
	// minutes range.
	SessionLifetimeInMinutes *int64 `min:"15" type:"long"`

	// The session tags used for row-level security. Before you use this parameter,
	// make sure that you have configured the relevant datasets using the DataSet$RowLevelPermissionTagConfiguration
	// parameter so that session tags can be used to provide row-level security.
	//
	// These are not the tags used for the Amazon Web Services resource tagging
	// feature. For more information, see Using Row-Level Security (RLS) with Tags
	// (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html).
	SessionTags []*SessionTag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForAnonymousUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForAnonymousUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateEmbedUrlForAnonymousUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateEmbedUrlForAnonymousUserInput"}
	if s.AuthorizedResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedResourceArns"))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ExperienceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperienceConfiguration"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.SessionLifetimeInMinutes != nil && *s.SessionLifetimeInMinutes < 15 {
		invalidParams.Add(request.NewErrParamMinValue("SessionLifetimeInMinutes", 15))
	}
	if s.SessionTags != nil && len(s.SessionTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionTags", 1))
	}
	if s.ExperienceConfiguration != nil {
		if err := s.ExperienceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ExperienceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SessionTags != nil {
		for i, v := range s.SessionTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SessionTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedResourceArns sets the AuthorizedResourceArns field's value.
func (s *GenerateEmbedUrlForAnonymousUserInput) SetAuthorizedResourceArns(v []*string) *GenerateEmbedUrlForAnonymousUserInput {
	s.AuthorizedResourceArns = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GenerateEmbedUrlForAnonymousUserInput) SetAwsAccountId(v string) *GenerateEmbedUrlForAnonymousUserInput {
	s.AwsAccountId = &v
	return s
}

// SetExperienceConfiguration sets the ExperienceConfiguration field's value.
func (s *GenerateEmbedUrlForAnonymousUserInput) SetExperienceConfiguration(v *AnonymousUserEmbeddingExperienceConfiguration) *GenerateEmbedUrlForAnonymousUserInput {
	s.ExperienceConfiguration = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GenerateEmbedUrlForAnonymousUserInput) SetNamespace(v string) *GenerateEmbedUrlForAnonymousUserInput {
	s.Namespace = &v
	return s
}

// SetSessionLifetimeInMinutes sets the SessionLifetimeInMinutes field's value.
func (s *GenerateEmbedUrlForAnonymousUserInput) SetSessionLifetimeInMinutes(v int64) *GenerateEmbedUrlForAnonymousUserInput {
	s.SessionLifetimeInMinutes = &v
	return s
}

// SetSessionTags sets the SessionTags field's value.
func (s *GenerateEmbedUrlForAnonymousUserInput) SetSessionTags(v []*SessionTag) *GenerateEmbedUrlForAnonymousUserInput {
	s.SessionTags = v
	return s
}

type GenerateEmbedUrlForAnonymousUserOutput struct {
	_ struct{} `type:"structure"`

	// The embed URL for the dashboard.
	//
	// EmbedUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateEmbedUrlForAnonymousUserOutput's
	// String and GoString methods.
	//
	// EmbedUrl is a required field
	EmbedUrl *string `type:"string" required:"true" sensitive:"true"`

	// The Amazon Web Services request ID for this operation.
	//
	// RequestId is a required field
	RequestId *string `type:"string" required:"true"`

	// The HTTP status of the request.
	//
	// Status is a required field
	Status *int64 `location:"statusCode" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForAnonymousUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForAnonymousUserOutput) GoString() string {
	return s.String()
}

// SetEmbedUrl sets the EmbedUrl field's value.
func (s *GenerateEmbedUrlForAnonymousUserOutput) SetEmbedUrl(v string) *GenerateEmbedUrlForAnonymousUserOutput {
	s.EmbedUrl = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GenerateEmbedUrlForAnonymousUserOutput) SetRequestId(v string) *GenerateEmbedUrlForAnonymousUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GenerateEmbedUrlForAnonymousUserOutput) SetStatus(v int64) *GenerateEmbedUrlForAnonymousUserOutput {
	s.Status = &v
	return s
}

type GenerateEmbedUrlForRegisteredUserInput struct {
	_ struct{} `type:"structure"`

	// The ID for the Amazon Web Services account that contains the dashboard that
	// you're embedding.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The experience you are embedding. For registered users, you can embed Amazon
	// QuickSight dashboards or the entire Amazon QuickSight console.
	//
	// ExperienceConfiguration is a required field
	ExperienceConfiguration *RegisteredUserEmbeddingExperienceConfiguration `type:"structure" required:"true"`

	// How many minutes the session is valid. The session lifetime must be in [15-600]
	// minutes range.
	SessionLifetimeInMinutes *int64 `min:"15" type:"long"`

	// The Amazon Resource Name for the registered user.
	//
	// UserArn is a required field
	UserArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForRegisteredUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForRegisteredUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateEmbedUrlForRegisteredUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateEmbedUrlForRegisteredUserInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.ExperienceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ExperienceConfiguration"))
	}
	if s.SessionLifetimeInMinutes != nil && *s.SessionLifetimeInMinutes < 15 {
		invalidParams.Add(request.NewErrParamMinValue("SessionLifetimeInMinutes", 15))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.ExperienceConfiguration != nil {
		if err := s.ExperienceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ExperienceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GenerateEmbedUrlForRegisteredUserInput) SetAwsAccountId(v string) *GenerateEmbedUrlForRegisteredUserInput {
	s.AwsAccountId = &v
	return s
}

// SetExperienceConfiguration sets the ExperienceConfiguration field's value.
func (s *GenerateEmbedUrlForRegisteredUserInput) SetExperienceConfiguration(v *RegisteredUserEmbeddingExperienceConfiguration) *GenerateEmbedUrlForRegisteredUserInput {
	s.ExperienceConfiguration = v
	return s
}

// SetSessionLifetimeInMinutes sets the SessionLifetimeInMinutes field's value.
func (s *GenerateEmbedUrlForRegisteredUserInput) SetSessionLifetimeInMinutes(v int64) *GenerateEmbedUrlForRegisteredUserInput {
	s.SessionLifetimeInMinutes = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *GenerateEmbedUrlForRegisteredUserInput) SetUserArn(v string) *GenerateEmbedUrlForRegisteredUserInput {
	s.UserArn = &v
	return s
}

type GenerateEmbedUrlForRegisteredUserOutput struct {
	_ struct{} `type:"structure"`

	// The embed URL for the Amazon QuickSight dashboard or console.
	//
	// EmbedUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateEmbedUrlForRegisteredUserOutput's
	// String and GoString methods.
	//
	// EmbedUrl is a required field
	EmbedUrl *string `type:"string" required:"true" sensitive:"true"`

	// The Amazon Web Services request ID for this operation.
	//
	// RequestId is a required field
	RequestId *string `type:"string" required:"true"`

	// The HTTP status of the request.
	//
	// Status is a required field
	Status *int64 `location:"statusCode" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForRegisteredUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateEmbedUrlForRegisteredUserOutput) GoString() string {
	return s.String()
}

// SetEmbedUrl sets the EmbedUrl field's value.
func (s *GenerateEmbedUrlForRegisteredUserOutput) SetEmbedUrl(v string) *GenerateEmbedUrlForRegisteredUserOutput {
	s.EmbedUrl = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GenerateEmbedUrlForRegisteredUserOutput) SetRequestId(v string) *GenerateEmbedUrlForRegisteredUserOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GenerateEmbedUrlForRegisteredUserOutput) SetStatus(v int64) *GenerateEmbedUrlForRegisteredUserOutput {
	s.Status = &v
	return s
}

// Geospatial column group that denotes a hierarchy.
type GeoSpatialColumnGroup struct {
	_ struct{} `type:"structure"`

	// Columns in this hierarchy.
	//
	// Columns is a required field
	Columns []*string `min:"1" type:"list" required:"true"`

	// Country code.
	//
	// CountryCode is a required field
	CountryCode *string `type:"string" required:"true" enum:"GeoSpatialCountryCode"`

	// A display name for the hierarchy.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeoSpatialColumnGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeoSpatialColumnGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoSpatialColumnGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoSpatialColumnGroup"}
	if s.Columns == nil {
		invalidParams.Add(request.NewErrParamRequired("Columns"))
	}
	if s.Columns != nil && len(s.Columns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Columns", 1))
	}
	if s.CountryCode == nil {
		invalidParams.Add(request.NewErrParamRequired("CountryCode"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumns sets the Columns field's value.
func (s *GeoSpatialColumnGroup) SetColumns(v []*string) *GeoSpatialColumnGroup {
	s.Columns = v
	return s
}

// SetCountryCode sets the CountryCode field's value.
func (s *GeoSpatialColumnGroup) SetCountryCode(v string) *GeoSpatialColumnGroup {
	s.CountryCode = &v
	return s
}

// SetName sets the Name field's value.
func (s *GeoSpatialColumnGroup) SetName(v string) *GeoSpatialColumnGroup {
	s.Name = &v
	return s
}

type GetDashboardEmbedUrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A list of one or more dashboard IDs that you want to add to a session that
	// includes anonymous users. The IdentityType parameter must be set to ANONYMOUS
	// for this to work, because other identity types authenticate as Amazon QuickSight
	// or IAM users. For example, if you set "--dashboard-id dash_id1 --dashboard-id
	// dash_id2 dash_id3 identity-type ANONYMOUS", the session can access all three
	// dashboards.
	AdditionalDashboardIds []*string `location:"querystring" locationName:"additional-dashboard-ids" min:"1" type:"list"`

	// The ID for the Amazon Web Services account that contains the dashboard that
	// you're embedding.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The ID for the dashboard, also added to the Identity and Access Management
	// (IAM) policy.
	//
	// DashboardId is a required field
	DashboardId *string `location:"uri" locationName:"DashboardId" min:"1" type:"string" required:"true"`

	// The authentication method that the user uses to sign in.
	//
	// IdentityType is a required field
	IdentityType *string `location:"querystring" locationName:"creds-type" type:"string" required:"true" enum:"EmbeddingIdentityType"`

	// The Amazon QuickSight namespace that contains the dashboard IDs in this request.
	// If you're not using a custom namespace, set Namespace = default.
	Namespace *string `location:"querystring" locationName:"namespace" type:"string"`

	// Remove the reset button on the embedded dashboard. The default is FALSE,
	// which enables the reset button.
	ResetDisabled *bool `location:"querystring" locationName:"reset-disabled" type:"boolean"`

	// How many minutes the session is valid. The session lifetime must be 15-600
	// minutes.
	SessionLifetimeInMinutes *int64 `location:"querystring" locationName:"session-lifetime" min:"15" type:"long"`

	// Adds persistence of state for the user session in an embedded dashboard.
	// Persistence applies to the sheet and the parameter settings. These are control
	// settings that the dashboard subscriber (Amazon QuickSight reader) chooses
	// while viewing the dashboard. If this is set to TRUE, the settings are the
	// same when the subscriber reopens the same dashboard URL. The state is stored
	// in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the
	// state of the user session is not persisted. The default is FALSE.
	StatePersistenceEnabled *bool `location:"querystring" locationName:"state-persistence-enabled" type:"boolean"`

	// Remove the undo/redo button on the embedded dashboard. The default is FALSE,
	// which enables the undo/redo button.
	UndoRedoDisabled *bool `location:"querystring" locationName:"undo-redo-disabled" type:"boolean"`

	// The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT
	// identity type. You can use this for any Amazon QuickSight users in your account
	// (readers, authors, or admins) authenticated as one of the following:
	//
	//    * Active Directory (AD) users or group members
	//
	//    * Invited nonfederated users
	//
	//    * IAM users and IAM role-based sessions authenticated through Federated
	//    Single Sign-On using SAML, OpenID Connect, or IAM federation.
	//
	// Omit this parameter for users in the third group – IAM users and IAM role-based
	// sessions.
	UserArn *string `location:"querystring" locationName:"user-arn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardEmbedUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardEmbedUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDashboardEmbedUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDashboardEmbedUrlInput"}
	if s.AdditionalDashboardIds != nil && len(s.AdditionalDashboardIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalDashboardIds", 1))
	}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.DashboardId == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardId"))
	}
	if s.DashboardId != nil && len(*s.DashboardId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DashboardId", 1))
	}
	if s.IdentityType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityType"))
	}
	if s.SessionLifetimeInMinutes != nil && *s.SessionLifetimeInMinutes < 15 {
		invalidParams.Add(request.NewErrParamMinValue("SessionLifetimeInMinutes", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalDashboardIds sets the AdditionalDashboardIds field's value.
func (s *GetDashboardEmbedUrlInput) SetAdditionalDashboardIds(v []*string) *GetDashboardEmbedUrlInput {
	s.AdditionalDashboardIds = v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GetDashboardEmbedUrlInput) SetAwsAccountId(v string) *GetDashboardEmbedUrlInput {
	s.AwsAccountId = &v
	return s
}

// SetDashboardId sets the DashboardId field's value.
func (s *GetDashboardEmbedUrlInput) SetDashboardId(v string) *GetDashboardEmbedUrlInput {
	s.DashboardId = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *GetDashboardEmbedUrlInput) SetIdentityType(v string) *GetDashboardEmbedUrlInput {
	s.IdentityType = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetDashboardEmbedUrlInput) SetNamespace(v string) *GetDashboardEmbedUrlInput {
	s.Namespace = &v
	return s
}

// SetResetDisabled sets the ResetDisabled field's value.
func (s *GetDashboardEmbedUrlInput) SetResetDisabled(v bool) *GetDashboardEmbedUrlInput {
	s.ResetDisabled = &v
	return s
}

// SetSessionLifetimeInMinutes sets the SessionLifetimeInMinutes field's value.
func (s *GetDashboardEmbedUrlInput) SetSessionLifetimeInMinutes(v int64) *GetDashboardEmbedUrlInput {
	s.SessionLifetimeInMinutes = &v
	return s
}

// SetStatePersistenceEnabled sets the StatePersistenceEnabled field's value.
func (s *GetDashboardEmbedUrlInput) SetStatePersistenceEnabled(v bool) *GetDashboardEmbedUrlInput {
	s.StatePersistenceEnabled = &v
	return s
}

// SetUndoRedoDisabled sets the UndoRedoDisabled field's value.
func (s *GetDashboardEmbedUrlInput) SetUndoRedoDisabled(v bool) *GetDashboardEmbedUrlInput {
	s.UndoRedoDisabled = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *GetDashboardEmbedUrlInput) SetUserArn(v string) *GetDashboardEmbedUrlInput {
	s.UserArn = &v
	return s
}

// Output returned from the GetDashboardEmbedUrl operation.
type GetDashboardEmbedUrlOutput struct {
	_ struct{} `type:"structure"`

	// A single-use URL that you can put into your server-side webpage to embed
	// your dashboard. This URL is valid for 5 minutes. The API operation provides
	// the URL with an auth_code value that enables one (and only one) sign-on to
	// a user session that is valid for 10 hours.
	//
	// EmbedUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDashboardEmbedUrlOutput's
	// String and GoString methods.
	EmbedUrl *string `type:"string" sensitive:"true"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardEmbedUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDashboardEmbedUrlOutput) GoString() string {
	return s.String()
}

// SetEmbedUrl sets the EmbedUrl field's value.
func (s *GetDashboardEmbedUrlOutput) SetEmbedUrl(v string) *GetDashboardEmbedUrlOutput {
	s.EmbedUrl = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetDashboardEmbedUrlOutput) SetRequestId(v string) *GetDashboardEmbedUrlOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDashboardEmbedUrlOutput) SetStatus(v int64) *GetDashboardEmbedUrlOutput {
	s.Status = &v
	return s
}

type GetSessionEmbedUrlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID for the Amazon Web Services account associated with your Amazon QuickSight
	// subscription.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The URL you use to access the embedded session. The entry point URL is constrained
	// to the following paths:
	//
	//    * /start
	//
	//    * /start/analyses
	//
	//    * /start/dashboards
	//
	//    * /start/favorites
	//
	//    * /dashboards/DashboardId - where DashboardId is the actual ID key from
	//    the Amazon QuickSight console URL of the dashboard
	//
	//    * /analyses/AnalysisId - where AnalysisId is the actual ID key from the
	//    Amazon QuickSight console URL of the analysis
	EntryPoint *string `location:"querystring" locationName:"entry-point" min:"1" type:"string"`

	// How many minutes the session is valid. The session lifetime must be 15-600
	// minutes.
	SessionLifetimeInMinutes *int64 `location:"querystring" locationName:"session-lifetime" min:"15" type:"long"`

	// The Amazon QuickSight user's Amazon Resource Name (ARN), for use with QUICKSIGHT
	// identity type. You can use this for any type of Amazon QuickSight users in
	// your account (readers, authors, or admins). They need to be authenticated
	// as one of the following:
	//
	// Active Directory (AD) users or group members
	//
	// Invited nonfederated users
	//
	// Identity and Access Management (IAM) users and IAM role-based sessions authenticated
	// through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation
	//
	// Omit this parameter for users in the third group, IAM users and IAM role-based
	// sessions.
	UserArn *string `location:"querystring" locationName:"user-arn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionEmbedUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionEmbedUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSessionEmbedUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSessionEmbedUrlInput"}
	if s.AwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AwsAccountId", 12))
	}
	if s.EntryPoint != nil && len(*s.EntryPoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntryPoint", 1))
	}
	if s.SessionLifetimeInMinutes != nil && *s.SessionLifetimeInMinutes < 15 {
		invalidParams.Add(request.NewErrParamMinValue("SessionLifetimeInMinutes", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *GetSessionEmbedUrlInput) SetAwsAccountId(v string) *GetSessionEmbedUrlInput {
	s.AwsAccountId = &v
	return s
}

// SetEntryPoint sets the EntryPoint field's value.
func (s *GetSessionEmbedUrlInput) SetEntryPoint(v string) *GetSessionEmbedUrlInput {
	s.EntryPoint = &v
	return s
}

// SetSessionLifetimeInMinutes sets the SessionLifetimeInMinutes field's value.
func (s *GetSessionEmbedUrlInput) SetSessionLifetimeInMinutes(v int64) *GetSessionEmbedUrlInput {
	s.SessionLifetimeInMinutes = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *GetSessionEmbedUrlInput) SetUserArn(v string) *GetSessionEmbedUrlInput {
	s.UserArn = &v
	return s
}

type GetSessionEmbedUrlOutput struct {
	_ struct{} `type:"structure"`

	// A single-use URL that you can put into your server-side web page to embed
	// your Amazon QuickSight session. This URL is valid for 5 minutes. The API
	// operation provides the URL with an auth_code value that enables one (and
	// only one) sign-on to a user session that is valid for 10 hours.
	//
	// EmbedUrl is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSessionEmbedUrlOutput's
	// String and GoString methods.
	EmbedUrl *string `type:"string" sensitive:"true"`

	// The Amazon Web Services request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionEmbedUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionEmbedUrlOutput) GoString() string {
	return s.String()
}

// SetEmbedUrl sets the EmbedUrl field's value.
func (s *GetSessionEmbedUrlOutput) SetEmbedUrl(v string) *GetSessionEmbedUrlOutput {
	s.EmbedUrl = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *GetSessionEmbedUrlOutput) SetRequestId(v string) *GetSessionEmbedUrlOutput {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSessionEmbedUrlOutput) SetStatus(v int64) *GetSessionEmbedUrlOutput {
	s.Status = &v
	return s
}

// A group in Amazon QuickSight consists of a set of users. You can use groups
// to make it easier to manage access and security.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the group.
	Arn *string `type:"string"`

	// The group description.
	Description *string `min:"1" type:"string"`

	// The name of the group.
	GroupName *string `min:"1" type:"string"`

	// The principal ID of the group.
	PrincipalId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Group) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Group) SetArn(v string) *Group {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Group) SetDescription(v string) *Group {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *Group) SetGroupName(v string) *Group {
	s.GroupName = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *Group) SetPrincipalId(v string) *Group {
	s.PrincipalId = &v
	return s
}

// A member of an Amazon QuickSight group. Currently, group members must be
// users. Groups can't be members of another group. .
type GroupMember struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the group member (user).
	Arn *string `type:"string"`

	// The name of the group member (user).
	MemberName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupMember) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GroupMember) SetArn(v string) *GroupMember {
	s.Arn = &v
	return s
}

// SetMemberName sets the MemberName field's value.
func (s *GroupMember) SetMemberName(v string) *GroupMember {
	s.MemberName = &v
	return s
}

// A GroupSearchFilter object that you want to apply to your search.
type GroupSearchFilter struct {
	_ struct{} `type:"structure"`

	// The name of the value that you want to use as a filter, for example "Name":
	// "GROUP_NAME". Currently, the only supported name is GROUP_NAME.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"GroupFilterAttribute"`

	// The comparison operator that you want to use as a filter, for example "Operator":
	// "StartsWith". Currently, the only supported operator is StartsWith.
	//
	// Operator is a required field
	Operator *string `type:"string" required:"true" enum:"GroupFilterOperator"`

	// The value of the named item, in this case GROUP_NAME, that you want to use
	// as a filter.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupSearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupSearchFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupSearchFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupSearchFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GroupSearchFilter) SetName(v string) *GroupSearchFilter {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *GroupSearchFilter) SetOperator(v string) *GroupSearchFilter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GroupSearchFilter) SetValue(v string) *GroupSearchFilter {
	s.Value = &v
	return s
}

// The display options for gutter spacing between tiles on a sheet.
type GutterStyle struct {
	_ struct{} `type:"structure"`

	// This Boolean value controls whether to display a gutter space between sheet
	// tiles.
	Show *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GutterStyle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GutterStyle) GoString() string {
	return s.String()
}

// SetShow sets the Show field's value.
func (s *GutterStyle) SetShow(v bool) *GutterStyle {
	s.Show = &v
	return s
}

// An Identity and Access Management (IAM) policy assignment.
type IAMPolicyAssignment struct {
	_ struct{} `type:"structure"`

	// Assignment ID.
	AssignmentId *string `type:"string"`

	// Assignment name.
	AssignmentName *string `min:"1" type:"string"`

	// Assignment status.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// The Amazon Web Services account ID.
	AwsAccountId *string `min:"12" type:"string"`

	// Identities.
	Identities map[string][]*string `type:"map"`

	// The Amazon Resource Name (ARN) for the IAM policy.
	PolicyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IAMPolicyAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IAMPolicyAssignment) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *IAMPolicyAssignment) SetAssignmentId(v string) *IAMPolicyAssignment {
	s.AssignmentId = &v
	return s
}

// SetAssignmentName sets the AssignmentName field's value.
func (s *IAMPolicyAssignment) SetAssignmentName(v string) *IAMPolicyAssignment {
	s.AssignmentName = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *IAMPolicyAssignment) SetAssignmentStatus(v string) *IAMPolicyAssignment {
	s.AssignmentStatus = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *IAMPolicyAssignment) SetAwsAccountId(v string) *IAMPolicyAssignment {
	s.AwsAccountId = &v
	return s
}

// SetIdentities sets the Identities field's value.
func (s *IAMPolicyAssignment) SetIdentities(v map[string][]*string) *IAMPolicyAssignment {
	s.Identities = v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *IAMPolicyAssignment) SetPolicyArn(v string) *IAMPolicyAssignment {
	s.PolicyArn = &v
	return s
}

// IAM policy assignment summary.
type IAMPolicyAssignmentSummary struct {
	_ struct{} `type:"structure"`

	// Assignment name.
	AssignmentName *string `min:"1" type:"string"`

	// Assignment status.
	AssignmentStatus *string `type:"string" enum