// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53recoverycontrolconfig

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateCluster
func (c *Route53RecoveryControlConfig) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/cluster",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for AWS Route53 Recovery Control Config.
//
// Create a new cluster. A cluster is a set of redundant Regional endpoints
// against which you can run API calls to update or get the state of one or
// more routing controls. Each cluster has a name, status, Amazon Resource Name
// (ARN), and an array of the five cluster endpoints (one for each supported
// Amazon Web Services Region) that you can use with API calls to the cluster
// data plane.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * ServiceQuotaExceededException
//   402 response - You attempted to create more resources than the service allows
//   based on service quotas.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateCluster
func (c *Route53RecoveryControlConfig) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateControlPanel = "CreateControlPanel"

// CreateControlPanelRequest generates a "aws/request.Request" representing the
// client's request for the CreateControlPanel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateControlPanel for more information on using the CreateControlPanel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateControlPanelRequest method.
//    req, resp := client.CreateControlPanelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateControlPanel
func (c *Route53RecoveryControlConfig) CreateControlPanelRequest(input *CreateControlPanelInput) (req *request.Request, output *CreateControlPanelOutput) {
	op := &request.Operation{
		Name:       opCreateControlPanel,
		HTTPMethod: "POST",
		HTTPPath:   "/controlpanel",
	}

	if input == nil {
		input = &CreateControlPanelInput{}
	}

	output = &CreateControlPanelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateControlPanel API operation for AWS Route53 Recovery Control Config.
//
// Creates a new control panel. A control panel represents a group of routing
// controls that can be changed together in a single transaction. You can use
// a control panel to centrally view the operational status of applications
// across your organization, and trigger multi-app failovers in a single transaction,
// for example, to fail over an Availability Zone or Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation CreateControlPanel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * ServiceQuotaExceededException
//   402 response - You attempted to create more resources than the service allows
//   based on service quotas.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateControlPanel
func (c *Route53RecoveryControlConfig) CreateControlPanel(input *CreateControlPanelInput) (*CreateControlPanelOutput, error) {
	req, out := c.CreateControlPanelRequest(input)
	return out, req.Send()
}

// CreateControlPanelWithContext is the same as CreateControlPanel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateControlPanel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) CreateControlPanelWithContext(ctx aws.Context, input *CreateControlPanelInput, opts ...request.Option) (*CreateControlPanelOutput, error) {
	req, out := c.CreateControlPanelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoutingControl = "CreateRoutingControl"

// CreateRoutingControlRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoutingControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoutingControl for more information on using the CreateRoutingControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoutingControlRequest method.
//    req, resp := client.CreateRoutingControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateRoutingControl
func (c *Route53RecoveryControlConfig) CreateRoutingControlRequest(input *CreateRoutingControlInput) (req *request.Request, output *CreateRoutingControlOutput) {
	op := &request.Operation{
		Name:       opCreateRoutingControl,
		HTTPMethod: "POST",
		HTTPPath:   "/routingcontrol",
	}

	if input == nil {
		input = &CreateRoutingControlInput{}
	}

	output = &CreateRoutingControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoutingControl API operation for AWS Route53 Recovery Control Config.
//
// Creates a new routing control.
//
// A routing control has one of two states: ON and OFF. You can map the routing
// control state to the state of an Amazon Route 53 health check, which can
// be used to control traffic routing.
//
// To get or update the routing control state, see the Recovery Cluster (data
// plane) API actions for Amazon Route 53 Application Recovery Controller.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation CreateRoutingControl for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * ServiceQuotaExceededException
//   402 response - You attempted to create more resources than the service allows
//   based on service quotas.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateRoutingControl
func (c *Route53RecoveryControlConfig) CreateRoutingControl(input *CreateRoutingControlInput) (*CreateRoutingControlOutput, error) {
	req, out := c.CreateRoutingControlRequest(input)
	return out, req.Send()
}

// CreateRoutingControlWithContext is the same as CreateRoutingControl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoutingControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) CreateRoutingControlWithContext(ctx aws.Context, input *CreateRoutingControlInput, opts ...request.Option) (*CreateRoutingControlOutput, error) {
	req, out := c.CreateRoutingControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSafetyRule = "CreateSafetyRule"

// CreateSafetyRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateSafetyRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSafetyRule for more information on using the CreateSafetyRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSafetyRuleRequest method.
//    req, resp := client.CreateSafetyRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateSafetyRule
func (c *Route53RecoveryControlConfig) CreateSafetyRuleRequest(input *CreateSafetyRuleInput) (req *request.Request, output *CreateSafetyRuleOutput) {
	op := &request.Operation{
		Name:       opCreateSafetyRule,
		HTTPMethod: "POST",
		HTTPPath:   "/safetyrule",
	}

	if input == nil {
		input = &CreateSafetyRuleInput{}
	}

	output = &CreateSafetyRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSafetyRule API operation for AWS Route53 Recovery Control Config.
//
// Creates a safety rule in a control panel. Safety rules let you add safeguards
// around changing routing control states, and for enabling and disabling routing
// controls, to help prevent unexpected outcomes.
//
// There are two types of safety rules: assertion rules and gating rules.
//
// Assertion rule: An assertion rule enforces that, when you change a routing
// control state, that a certain criteria is met. For example, the criteria
// might be that at least one routing control state is On after the transation
// so that traffic continues to flow to at least one cell for the application.
// This ensures that you avoid a fail-open scenario.
//
// Gating rule: A gating rule lets you configure a gating routing control as
// an overall "on/off" switch for a group of routing controls. Or, you can configure
// more complex gating scenarios, for example by configuring multiple gating
// routing controls.
//
// For more information, see Safety rules (https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.safety-rules.html)
// in the Amazon Route 53 Application Recovery Controller Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation CreateSafetyRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/CreateSafetyRule
func (c *Route53RecoveryControlConfig) CreateSafetyRule(input *CreateSafetyRuleInput) (*CreateSafetyRuleOutput, error) {
	req, out := c.CreateSafetyRuleRequest(input)
	return out, req.Send()
}

// CreateSafetyRuleWithContext is the same as CreateSafetyRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSafetyRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) CreateSafetyRuleWithContext(ctx aws.Context, input *CreateSafetyRuleInput, opts ...request.Option) (*CreateSafetyRuleOutput, error) {
	req, out := c.CreateSafetyRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteCluster
func (c *Route53RecoveryControlConfig) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cluster/{ClusterArn}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCluster API operation for AWS Route53 Recovery Control Config.
//
// Delete a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteCluster
func (c *Route53RecoveryControlConfig) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteControlPanel = "DeleteControlPanel"

// DeleteControlPanelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteControlPanel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteControlPanel for more information on using the DeleteControlPanel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteControlPanelRequest method.
//    req, resp := client.DeleteControlPanelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteControlPanel
func (c *Route53RecoveryControlConfig) DeleteControlPanelRequest(input *DeleteControlPanelInput) (req *request.Request, output *DeleteControlPanelOutput) {
	op := &request.Operation{
		Name:       opDeleteControlPanel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/controlpanel/{ControlPanelArn}",
	}

	if input == nil {
		input = &DeleteControlPanelInput{}
	}

	output = &DeleteControlPanelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteControlPanel API operation for AWS Route53 Recovery Control Config.
//
// Deletes a control panel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DeleteControlPanel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteControlPanel
func (c *Route53RecoveryControlConfig) DeleteControlPanel(input *DeleteControlPanelInput) (*DeleteControlPanelOutput, error) {
	req, out := c.DeleteControlPanelRequest(input)
	return out, req.Send()
}

// DeleteControlPanelWithContext is the same as DeleteControlPanel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteControlPanel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DeleteControlPanelWithContext(ctx aws.Context, input *DeleteControlPanelInput, opts ...request.Option) (*DeleteControlPanelOutput, error) {
	req, out := c.DeleteControlPanelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoutingControl = "DeleteRoutingControl"

// DeleteRoutingControlRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoutingControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoutingControl for more information on using the DeleteRoutingControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoutingControlRequest method.
//    req, resp := client.DeleteRoutingControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteRoutingControl
func (c *Route53RecoveryControlConfig) DeleteRoutingControlRequest(input *DeleteRoutingControlInput) (req *request.Request, output *DeleteRoutingControlOutput) {
	op := &request.Operation{
		Name:       opDeleteRoutingControl,
		HTTPMethod: "DELETE",
		HTTPPath:   "/routingcontrol/{RoutingControlArn}",
	}

	if input == nil {
		input = &DeleteRoutingControlInput{}
	}

	output = &DeleteRoutingControlOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoutingControl API operation for AWS Route53 Recovery Control Config.
//
// Deletes a routing control.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DeleteRoutingControl for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteRoutingControl
func (c *Route53RecoveryControlConfig) DeleteRoutingControl(input *DeleteRoutingControlInput) (*DeleteRoutingControlOutput, error) {
	req, out := c.DeleteRoutingControlRequest(input)
	return out, req.Send()
}

// DeleteRoutingControlWithContext is the same as DeleteRoutingControl with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoutingControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DeleteRoutingControlWithContext(ctx aws.Context, input *DeleteRoutingControlInput, opts ...request.Option) (*DeleteRoutingControlOutput, error) {
	req, out := c.DeleteRoutingControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSafetyRule = "DeleteSafetyRule"

// DeleteSafetyRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSafetyRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSafetyRule for more information on using the DeleteSafetyRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSafetyRuleRequest method.
//    req, resp := client.DeleteSafetyRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteSafetyRule
func (c *Route53RecoveryControlConfig) DeleteSafetyRuleRequest(input *DeleteSafetyRuleInput) (req *request.Request, output *DeleteSafetyRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteSafetyRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/safetyrule/{SafetyRuleArn}",
	}

	if input == nil {
		input = &DeleteSafetyRuleInput{}
	}

	output = &DeleteSafetyRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSafetyRule API operation for AWS Route53 Recovery Control Config.
//
// Deletes a safety rule.
// />
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DeleteSafetyRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DeleteSafetyRule
func (c *Route53RecoveryControlConfig) DeleteSafetyRule(input *DeleteSafetyRuleInput) (*DeleteSafetyRuleOutput, error) {
	req, out := c.DeleteSafetyRuleRequest(input)
	return out, req.Send()
}

// DeleteSafetyRuleWithContext is the same as DeleteSafetyRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSafetyRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DeleteSafetyRuleWithContext(ctx aws.Context, input *DeleteSafetyRuleInput, opts ...request.Option) (*DeleteSafetyRuleOutput, error) {
	req, out := c.DeleteSafetyRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeCluster
func (c *Route53RecoveryControlConfig) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/cluster/{ClusterArn}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for AWS Route53 Recovery Control Config.
//
// Display the details about a cluster. The response includes the cluster name,
// endpoints, status, and Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeCluster
func (c *Route53RecoveryControlConfig) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeControlPanel = "DescribeControlPanel"

// DescribeControlPanelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeControlPanel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeControlPanel for more information on using the DescribeControlPanel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeControlPanelRequest method.
//    req, resp := client.DescribeControlPanelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeControlPanel
func (c *Route53RecoveryControlConfig) DescribeControlPanelRequest(input *DescribeControlPanelInput) (req *request.Request, output *DescribeControlPanelOutput) {
	op := &request.Operation{
		Name:       opDescribeControlPanel,
		HTTPMethod: "GET",
		HTTPPath:   "/controlpanel/{ControlPanelArn}",
	}

	if input == nil {
		input = &DescribeControlPanelInput{}
	}

	output = &DescribeControlPanelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeControlPanel API operation for AWS Route53 Recovery Control Config.
//
// Displays details about a control panel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DescribeControlPanel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeControlPanel
func (c *Route53RecoveryControlConfig) DescribeControlPanel(input *DescribeControlPanelInput) (*DescribeControlPanelOutput, error) {
	req, out := c.DescribeControlPanelRequest(input)
	return out, req.Send()
}

// DescribeControlPanelWithContext is the same as DescribeControlPanel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeControlPanel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DescribeControlPanelWithContext(ctx aws.Context, input *DescribeControlPanelInput, opts ...request.Option) (*DescribeControlPanelOutput, error) {
	req, out := c.DescribeControlPanelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoutingControl = "DescribeRoutingControl"

// DescribeRoutingControlRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoutingControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoutingControl for more information on using the DescribeRoutingControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRoutingControlRequest method.
//    req, resp := client.DescribeRoutingControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeRoutingControl
func (c *Route53RecoveryControlConfig) DescribeRoutingControlRequest(input *DescribeRoutingControlInput) (req *request.Request, output *DescribeRoutingControlOutput) {
	op := &request.Operation{
		Name:       opDescribeRoutingControl,
		HTTPMethod: "GET",
		HTTPPath:   "/routingcontrol/{RoutingControlArn}",
	}

	if input == nil {
		input = &DescribeRoutingControlInput{}
	}

	output = &DescribeRoutingControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoutingControl API operation for AWS Route53 Recovery Control Config.
//
// Displays details about a routing control. A routing control has one of two
// states: ON and OFF. You can map the routing control state to the state of
// an Amazon Route 53 health check, which can be used to control routing.
//
// To get or update the routing control state, see the Recovery Cluster (data
// plane) API actions for Amazon Route 53 Application Recovery Controller.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DescribeRoutingControl for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeRoutingControl
func (c *Route53RecoveryControlConfig) DescribeRoutingControl(input *DescribeRoutingControlInput) (*DescribeRoutingControlOutput, error) {
	req, out := c.DescribeRoutingControlRequest(input)
	return out, req.Send()
}

// DescribeRoutingControlWithContext is the same as DescribeRoutingControl with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoutingControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DescribeRoutingControlWithContext(ctx aws.Context, input *DescribeRoutingControlInput, opts ...request.Option) (*DescribeRoutingControlOutput, error) {
	req, out := c.DescribeRoutingControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSafetyRule = "DescribeSafetyRule"

// DescribeSafetyRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSafetyRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSafetyRule for more information on using the DescribeSafetyRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSafetyRuleRequest method.
//    req, resp := client.DescribeSafetyRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeSafetyRule
func (c *Route53RecoveryControlConfig) DescribeSafetyRuleRequest(input *DescribeSafetyRuleInput) (req *request.Request, output *DescribeSafetyRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeSafetyRule,
		HTTPMethod: "GET",
		HTTPPath:   "/safetyrule/{SafetyRuleArn}",
	}

	if input == nil {
		input = &DescribeSafetyRuleInput{}
	}

	output = &DescribeSafetyRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSafetyRule API operation for AWS Route53 Recovery Control Config.
//
// Returns information about a safety rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation DescribeSafetyRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/DescribeSafetyRule
func (c *Route53RecoveryControlConfig) DescribeSafetyRule(input *DescribeSafetyRuleInput) (*DescribeSafetyRuleOutput, error) {
	req, out := c.DescribeSafetyRuleRequest(input)
	return out, req.Send()
}

// DescribeSafetyRuleWithContext is the same as DescribeSafetyRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSafetyRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) DescribeSafetyRuleWithContext(ctx aws.Context, input *DescribeSafetyRuleInput, opts ...request.Option) (*DescribeSafetyRuleOutput, error) {
	req, out := c.DescribeSafetyRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociatedRoute53HealthChecks = "ListAssociatedRoute53HealthChecks"

// ListAssociatedRoute53HealthChecksRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedRoute53HealthChecks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedRoute53HealthChecks for more information on using the ListAssociatedRoute53HealthChecks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedRoute53HealthChecksRequest method.
//    req, resp := client.ListAssociatedRoute53HealthChecksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListAssociatedRoute53HealthChecks
func (c *Route53RecoveryControlConfig) ListAssociatedRoute53HealthChecksRequest(input *ListAssociatedRoute53HealthChecksInput) (req *request.Request, output *ListAssociatedRoute53HealthChecksOutput) {
	op := &request.Operation{
		Name:       opListAssociatedRoute53HealthChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/routingcontrol/{RoutingControlArn}/associatedRoute53HealthChecks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedRoute53HealthChecksInput{}
	}

	output = &ListAssociatedRoute53HealthChecksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedRoute53HealthChecks API operation for AWS Route53 Recovery Control Config.
//
// Returns an array of all Amazon Route 53 health checks associated with a specific
// routing control.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation ListAssociatedRoute53HealthChecks for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListAssociatedRoute53HealthChecks
func (c *Route53RecoveryControlConfig) ListAssociatedRoute53HealthChecks(input *ListAssociatedRoute53HealthChecksInput) (*ListAssociatedRoute53HealthChecksOutput, error) {
	req, out := c.ListAssociatedRoute53HealthChecksRequest(input)
	return out, req.Send()
}

// ListAssociatedRoute53HealthChecksWithContext is the same as ListAssociatedRoute53HealthChecks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedRoute53HealthChecks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListAssociatedRoute53HealthChecksWithContext(ctx aws.Context, input *ListAssociatedRoute53HealthChecksInput, opts ...request.Option) (*ListAssociatedRoute53HealthChecksOutput, error) {
	req, out := c.ListAssociatedRoute53HealthChecksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociatedRoute53HealthChecksPages iterates over the pages of a ListAssociatedRoute53HealthChecks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociatedRoute53HealthChecks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociatedRoute53HealthChecks operation.
//    pageNum := 0
//    err := client.ListAssociatedRoute53HealthChecksPages(params,
//        func(page *route53recoverycontrolconfig.ListAssociatedRoute53HealthChecksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryControlConfig) ListAssociatedRoute53HealthChecksPages(input *ListAssociatedRoute53HealthChecksInput, fn func(*ListAssociatedRoute53HealthChecksOutput, bool) bool) error {
	return c.ListAssociatedRoute53HealthChecksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociatedRoute53HealthChecksPagesWithContext same as ListAssociatedRoute53HealthChecksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListAssociatedRoute53HealthChecksPagesWithContext(ctx aws.Context, input *ListAssociatedRoute53HealthChecksInput, fn func(*ListAssociatedRoute53HealthChecksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociatedRoute53HealthChecksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociatedRoute53HealthChecksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociatedRoute53HealthChecksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListClusters
func (c *Route53RecoveryControlConfig) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/cluster",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for AWS Route53 Recovery Control Config.
//
// Returns an array of all the clusters in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListClusters
func (c *Route53RecoveryControlConfig) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusters operation.
//    pageNum := 0
//    err := client.ListClustersPages(params,
//        func(page *route53recoverycontrolconfig.ListClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryControlConfig) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListControlPanels = "ListControlPanels"

// ListControlPanelsRequest generates a "aws/request.Request" representing the
// client's request for the ListControlPanels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListControlPanels for more information on using the ListControlPanels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListControlPanelsRequest method.
//    req, resp := client.ListControlPanelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListControlPanels
func (c *Route53RecoveryControlConfig) ListControlPanelsRequest(input *ListControlPanelsInput) (req *request.Request, output *ListControlPanelsOutput) {
	op := &request.Operation{
		Name:       opListControlPanels,
		HTTPMethod: "GET",
		HTTPPath:   "/controlpanels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListControlPanelsInput{}
	}

	output = &ListControlPanelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListControlPanels API operation for AWS Route53 Recovery Control Config.
//
// Returns an array of control panels in an account or in a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation ListControlPanels for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListControlPanels
func (c *Route53RecoveryControlConfig) ListControlPanels(input *ListControlPanelsInput) (*ListControlPanelsOutput, error) {
	req, out := c.ListControlPanelsRequest(input)
	return out, req.Send()
}

// ListControlPanelsWithContext is the same as ListControlPanels with the addition of
// the ability to pass a context and additional request options.
//
// See ListControlPanels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListControlPanelsWithContext(ctx aws.Context, input *ListControlPanelsInput, opts ...request.Option) (*ListControlPanelsOutput, error) {
	req, out := c.ListControlPanelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListControlPanelsPages iterates over the pages of a ListControlPanels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListControlPanels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListControlPanels operation.
//    pageNum := 0
//    err := client.ListControlPanelsPages(params,
//        func(page *route53recoverycontrolconfig.ListControlPanelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryControlConfig) ListControlPanelsPages(input *ListControlPanelsInput, fn func(*ListControlPanelsOutput, bool) bool) error {
	return c.ListControlPanelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListControlPanelsPagesWithContext same as ListControlPanelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListControlPanelsPagesWithContext(ctx aws.Context, input *ListControlPanelsInput, fn func(*ListControlPanelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListControlPanelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListControlPanelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListControlPanelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoutingControls = "ListRoutingControls"

// ListRoutingControlsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutingControls operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutingControls for more information on using the ListRoutingControls
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoutingControlsRequest method.
//    req, resp := client.ListRoutingControlsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListRoutingControls
func (c *Route53RecoveryControlConfig) ListRoutingControlsRequest(input *ListRoutingControlsInput) (req *request.Request, output *ListRoutingControlsOutput) {
	op := &request.Operation{
		Name:       opListRoutingControls,
		HTTPMethod: "GET",
		HTTPPath:   "/controlpanel/{ControlPanelArn}/routingcontrols",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutingControlsInput{}
	}

	output = &ListRoutingControlsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutingControls API operation for AWS Route53 Recovery Control Config.
//
// Returns an array of routing controls for a control panel. A routing control
// is an Amazon Route 53 Application Recovery Controller construct that has
// one of two states: ON and OFF. You can map the routing control state to the
// state of an Amazon Route 53 health check, which can be used to control routing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation ListRoutingControls for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListRoutingControls
func (c *Route53RecoveryControlConfig) ListRoutingControls(input *ListRoutingControlsInput) (*ListRoutingControlsOutput, error) {
	req, out := c.ListRoutingControlsRequest(input)
	return out, req.Send()
}

// ListRoutingControlsWithContext is the same as ListRoutingControls with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutingControls for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListRoutingControlsWithContext(ctx aws.Context, input *ListRoutingControlsInput, opts ...request.Option) (*ListRoutingControlsOutput, error) {
	req, out := c.ListRoutingControlsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutingControlsPages iterates over the pages of a ListRoutingControls operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutingControls method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoutingControls operation.
//    pageNum := 0
//    err := client.ListRoutingControlsPages(params,
//        func(page *route53recoverycontrolconfig.ListRoutingControlsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryControlConfig) ListRoutingControlsPages(input *ListRoutingControlsInput, fn func(*ListRoutingControlsOutput, bool) bool) error {
	return c.ListRoutingControlsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutingControlsPagesWithContext same as ListRoutingControlsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListRoutingControlsPagesWithContext(ctx aws.Context, input *ListRoutingControlsInput, fn func(*ListRoutingControlsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutingControlsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutingControlsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutingControlsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSafetyRules = "ListSafetyRules"

// ListSafetyRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListSafetyRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSafetyRules for more information on using the ListSafetyRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSafetyRulesRequest method.
//    req, resp := client.ListSafetyRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListSafetyRules
func (c *Route53RecoveryControlConfig) ListSafetyRulesRequest(input *ListSafetyRulesInput) (req *request.Request, output *ListSafetyRulesOutput) {
	op := &request.Operation{
		Name:       opListSafetyRules,
		HTTPMethod: "GET",
		HTTPPath:   "/controlpanel/{ControlPanelArn}/safetyrules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSafetyRulesInput{}
	}

	output = &ListSafetyRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSafetyRules API operation for AWS Route53 Recovery Control Config.
//
// List the safety rules (the assertion rules and gating rules) that you've
// defined for the routing controls in a control panel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation ListSafetyRules for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListSafetyRules
func (c *Route53RecoveryControlConfig) ListSafetyRules(input *ListSafetyRulesInput) (*ListSafetyRulesOutput, error) {
	req, out := c.ListSafetyRulesRequest(input)
	return out, req.Send()
}

// ListSafetyRulesWithContext is the same as ListSafetyRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListSafetyRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListSafetyRulesWithContext(ctx aws.Context, input *ListSafetyRulesInput, opts ...request.Option) (*ListSafetyRulesOutput, error) {
	req, out := c.ListSafetyRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSafetyRulesPages iterates over the pages of a ListSafetyRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSafetyRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSafetyRules operation.
//    pageNum := 0
//    err := client.ListSafetyRulesPages(params,
//        func(page *route53recoverycontrolconfig.ListSafetyRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53RecoveryControlConfig) ListSafetyRulesPages(input *ListSafetyRulesInput, fn func(*ListSafetyRulesOutput, bool) bool) error {
	return c.ListSafetyRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSafetyRulesPagesWithContext same as ListSafetyRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListSafetyRulesPagesWithContext(ctx aws.Context, input *ListSafetyRulesInput, fn func(*ListSafetyRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSafetyRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSafetyRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSafetyRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListTagsForResource
func (c *Route53RecoveryControlConfig) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Route53 Recovery Control Config.
//
// Lists the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/ListTagsForResource
func (c *Route53RecoveryControlConfig) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/TagResource
func (c *Route53RecoveryControlConfig) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Route53 Recovery Control Config.
//
// Adds a tag to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/TagResource
func (c *Route53RecoveryControlConfig) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UntagResource
func (c *Route53RecoveryControlConfig) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Route53 Recovery Control Config.
//
// Removes a tag from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UntagResource
func (c *Route53RecoveryControlConfig) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateControlPanel = "UpdateControlPanel"

// UpdateControlPanelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateControlPanel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateControlPanel for more information on using the UpdateControlPanel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateControlPanelRequest method.
//    req, resp := client.UpdateControlPanelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateControlPanel
func (c *Route53RecoveryControlConfig) UpdateControlPanelRequest(input *UpdateControlPanelInput) (req *request.Request, output *UpdateControlPanelOutput) {
	op := &request.Operation{
		Name:       opUpdateControlPanel,
		HTTPMethod: "PUT",
		HTTPPath:   "/controlpanel",
	}

	if input == nil {
		input = &UpdateControlPanelInput{}
	}

	output = &UpdateControlPanelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateControlPanel API operation for AWS Route53 Recovery Control Config.
//
// Updates a control panel. The only update you can make to a control panel
// is to change the name of the control panel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation UpdateControlPanel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateControlPanel
func (c *Route53RecoveryControlConfig) UpdateControlPanel(input *UpdateControlPanelInput) (*UpdateControlPanelOutput, error) {
	req, out := c.UpdateControlPanelRequest(input)
	return out, req.Send()
}

// UpdateControlPanelWithContext is the same as UpdateControlPanel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateControlPanel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) UpdateControlPanelWithContext(ctx aws.Context, input *UpdateControlPanelInput, opts ...request.Option) (*UpdateControlPanelOutput, error) {
	req, out := c.UpdateControlPanelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingControl = "UpdateRoutingControl"

// UpdateRoutingControlRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingControl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingControl for more information on using the UpdateRoutingControl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoutingControlRequest method.
//    req, resp := client.UpdateRoutingControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateRoutingControl
func (c *Route53RecoveryControlConfig) UpdateRoutingControlRequest(input *UpdateRoutingControlInput) (req *request.Request, output *UpdateRoutingControlOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingControl,
		HTTPMethod: "PUT",
		HTTPPath:   "/routingcontrol",
	}

	if input == nil {
		input = &UpdateRoutingControlInput{}
	}

	output = &UpdateRoutingControlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoutingControl API operation for AWS Route53 Recovery Control Config.
//
// Updates a routing control. You can only update the name of the routing control.
// To get or update the routing control state, see the Recovery Cluster (data
// plane) API actions for Amazon Route 53 Application Recovery Controller.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation UpdateRoutingControl for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
//   * AccessDeniedException
//   403 response - You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ThrottlingException
//   429 response - LimitExceededException or TooManyRequestsException.
//
//   * ConflictException
//   409 response - ConflictException. You might be using a predefined variable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateRoutingControl
func (c *Route53RecoveryControlConfig) UpdateRoutingControl(input *UpdateRoutingControlInput) (*UpdateRoutingControlOutput, error) {
	req, out := c.UpdateRoutingControlRequest(input)
	return out, req.Send()
}

// UpdateRoutingControlWithContext is the same as UpdateRoutingControl with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) UpdateRoutingControlWithContext(ctx aws.Context, input *UpdateRoutingControlInput, opts ...request.Option) (*UpdateRoutingControlOutput, error) {
	req, out := c.UpdateRoutingControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSafetyRule = "UpdateSafetyRule"

// UpdateSafetyRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSafetyRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSafetyRule for more information on using the UpdateSafetyRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSafetyRuleRequest method.
//    req, resp := client.UpdateSafetyRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateSafetyRule
func (c *Route53RecoveryControlConfig) UpdateSafetyRuleRequest(input *UpdateSafetyRuleInput) (req *request.Request, output *UpdateSafetyRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateSafetyRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/safetyrule",
	}

	if input == nil {
		input = &UpdateSafetyRuleInput{}
	}

	output = &UpdateSafetyRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSafetyRule API operation for AWS Route53 Recovery Control Config.
//
// Update a safety rule (an assertion rule or gating rule). You can only update
// the name and the waiting period for a safety rule. To make other updates,
// delete the safety rule and create a new one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Route53 Recovery Control Config's
// API operation UpdateSafetyRule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   404 response - MalformedQueryString. The query string contains a syntax error
//   or resource not found..
//
//   * ValidationException
//   400 response - Multiple causes. For example, you might have a malformed query
//   string and input parameter might be out of range, or you might have used
//   parameters together incorrectly.
//
//   * InternalServerException
//   500 response - InternalServiceError. Temporary service error. Retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53-recovery-control-config-2020-11-02/UpdateSafetyRule
func (c *Route53RecoveryControlConfig) UpdateSafetyRule(input *UpdateSafetyRuleInput) (*UpdateSafetyRuleOutput, error) {
	req, out := c.UpdateSafetyRuleRequest(input)
	return out, req.Send()
}

// UpdateSafetyRuleWithContext is the same as UpdateSafetyRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSafetyRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53RecoveryControlConfig) UpdateSafetyRuleWithContext(ctx aws.Context, input *UpdateSafetyRuleInput, opts ...request.Option) (*UpdateSafetyRuleOutput, error) {
	req, out := c.UpdateSafetyRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// 403 response - You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An assertion rule enforces that, when you change a routing control state,
// that the criteria that you set in the rule configuration is met. Otherwise,
// the change to the routing control is not accepted. For example, the criteria
// might be that at least one routing control state is On after the transation
// so that traffic continues to flow to at least one cell for the application.
// This ensures that you avoid a fail-open scenario.
type AssertionRule struct {
	_ struct{} `type:"structure"`

	// The routing controls that are part of transactions that are evaluated to
	// determine if a request to change a routing control state is allowed. For
	// example, you might include three routing controls, one for each of three
	// Amazon Web Services Regions.
	//
	// AssertedControls is a required field
	AssertedControls []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the control panel.
	//
	// ControlPanelArn is a required field
	ControlPanelArn *string `min:"1" type:"string" required:"true"`

	// Name of the assertion rule. You can use any non-white space character in
	// the name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The criteria that you set for specific assertion routing controls (AssertedControls)
	// that designate how many routing control states must be ON as the result of
	// a transaction. For example, if you have three assertion routing controls,
	// you might specify atleast 2 for your rule configuration. This means that
	// at least two assertion routing control states must be ON, so that at least
	// two Amazon Web Services Regions have traffic flowing to them.
	//
	// RuleConfig is a required field
	RuleConfig *RuleConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the assertion rule.
	//
	// SafetyRuleArn is a required field
	SafetyRuleArn *string `min:"1" type:"string" required:"true"`

	// The deployment status of an assertion rule. Status can be one of the following:
	// PENDING, DEPLOYED, PENDING_DELETION.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"Status"`

	// An evaluation period, in milliseconds (ms), during which any request against
	// the target routing controls will fail. This helps prevent "flapping" of state.
	// The wait period is 5000 ms by default, but you can choose a custom value.
	//
	// WaitPeriodMs is a required field
	WaitPeriodMs *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssertionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssertionRule) GoString() string {
	return s.String()
}

// SetAssertedControls sets the AssertedControls field's value.
func (s *AssertionRule) SetAssertedControls(v []*string) *AssertionRule {
	s.AssertedControls = v
	return s
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *AssertionRule) SetControlPanelArn(v string) *AssertionRule {
	s.ControlPanelArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssertionRule) SetName(v string) *AssertionRule {
	s.Name = &v
	return s
}

// SetRuleConfig sets the RuleConfig field's value.
func (s *AssertionRule) SetRuleConfig(v *RuleConfig) *AssertionRule {
	s.RuleConfig = v
	return s
}

// SetSafetyRuleArn sets the SafetyRuleArn field's value.
func (s *AssertionRule) SetSafetyRuleArn(v string) *AssertionRule {
	s.SafetyRuleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssertionRule) SetStatus(v string) *AssertionRule {
	s.Status = &v
	return s
}

// SetWaitPeriodMs sets the WaitPeriodMs field's value.
func (s *AssertionRule) SetWaitPeriodMs(v int64) *AssertionRule {
	s.WaitPeriodMs = &v
	return s
}

// An update to an assertion rule. You can update the name or the evaluation
// period (wait period). If you don't specify one of the items to update, the
// item is unchanged.
type AssertionRuleUpdate struct {
	_ struct{} `type:"structure"`

	// The name of the assertion rule. You can use any non-white space character
	// in the name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the assertion rule.
	//
	// SafetyRuleArn is a required field
	SafetyRuleArn *string `min:"1" type:"string" required:"true"`

	// An evaluation period, in milliseconds (ms), during which any request against
	// the target routing controls will fail. This helps prevent "flapping" of state.
	// The wait period is 5000 ms by default, but you can choose a custom value.
	//
	// WaitPeriodMs is a required field
	WaitPeriodMs *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssertionRuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssertionRuleUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssertionRuleUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssertionRuleUpdate"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SafetyRuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SafetyRuleArn"))
	}
	if s.SafetyRuleArn != nil && len(*s.SafetyRuleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SafetyRuleArn", 1))
	}
	if s.WaitPeriodMs == nil {
		invalidParams.Add(request.NewErrParamRequired("WaitPeriodMs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssertionRuleUpdate) SetName(v string) *AssertionRuleUpdate {
	s.Name = &v
	return s
}

// SetSafetyRuleArn sets the SafetyRuleArn field's value.
func (s *AssertionRuleUpdate) SetSafetyRuleArn(v string) *AssertionRuleUpdate {
	s.SafetyRuleArn = &v
	return s
}

// SetWaitPeriodMs sets the WaitPeriodMs field's value.
func (s *AssertionRuleUpdate) SetWaitPeriodMs(v int64) *AssertionRuleUpdate {
	s.WaitPeriodMs = &v
	return s
}

// A set of five redundant Regional endpoints against which you can execute
// API calls to update or get the state of routing controls. You can host multiple
// control panels and routing controls on one cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `min:"1" type:"string"`

	// Endpoints for a cluster. Specify one of these endpoints when you want to
	// set or retrieve a routing control state in the cluster.
	//
	// To get or update the routing control state, see the Amazon Route 53 Application
	// Recovery Controller Routing Control Actions.
	ClusterEndpoints []*ClusterEndpoint `type:"list"`

	// The name of the cluster.
	Name *string `min:"1" type:"string"`

	// Deployment status of a resource. Status can be one of the following: PENDING,
	// DEPLOYED, PENDING_DELETION.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Cluster) SetClusterArn(v string) *Cluster {
	s.ClusterArn = &v
	return s
}

// SetClusterEndpoints sets the ClusterEndpoints field's value.
func (s *Cluster) SetClusterEndpoints(v []*ClusterEndpoint) *Cluster {
	s.ClusterEndpoints = v
	return s
}

// SetName sets the Name field's value.
func (s *Cluster) SetName(v string) *Cluster {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// A cluster endpoint. Specify an endpoint when you want to set or retrieve
// a routing control state in the cluster.
type ClusterEndpoint struct {
	_ struct{} `type:"structure"`

	// A cluster endpoint. Specify an endpoint and Amazon Web Services Region when
	// you want to set or retrieve a routing control state in the cluster.
	//
	// To get or update the routing control state, see the Amazon Route 53 Application
	// Recovery Controller Routing Control Actions.
	Endpoint *string `min:"1" type:"string"`

	// The Amazon Web Services Region for a cluster endpoint.
	Region *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterEndpoint) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *ClusterEndpoint) SetEndpoint(v string) *ClusterEndpoint {
	s.Endpoint = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ClusterEndpoint) SetRegion(v string) *ClusterEndpoint {
	s.Region = &v
	return s
}

// 409 response - ConflictException. You might be using a predefined variable.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A control panel represents a group of routing controls that can be changed
// together in a single transaction.
type ControlPanel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster that includes the control panel.
	ClusterArn *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the control panel.
	ControlPanelArn *string `min:"1" type:"string"`

	// A flag that Amazon Route 53 Application Recovery Controller sets to true
	// to designate the default control panel for a cluster. When you create a cluster,
	// Amazon Route 53 Application Recovery Controller creates a control panel,
	// and sets this flag for that control panel. If you create a control panel
	// yourself, this flag is set to false.
	DefaultControlPanel *bool `type:"boolean"`

	// The name of the control panel. You can use any non-white space character
	// in the name.
	Name *string `min:"1" type:"string"`

	// The number of routing controls in the control panel.
	RoutingControlCount *int64 `type:"integer"`

	// The deployment status of control panel. Status can be one of the following:
	// PENDING, DEPLOYED, PENDING_DELETION.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPanel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPanel) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ControlPanel) SetClusterArn(v string) *ControlPanel {
	s.ClusterArn = &v
	return s
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *ControlPanel) SetControlPanelArn(v string) *ControlPanel {
	s.ControlPanelArn = &v
	return s
}

// SetDefaultControlPanel sets the DefaultControlPanel field's value.
func (s *ControlPanel) SetDefaultControlPanel(v bool) *ControlPanel {
	s.DefaultControlPanel = &v
	return s
}

// SetName sets the Name field's value.
func (s *ControlPanel) SetName(v string) *ControlPanel {
	s.Name = &v
	return s
}

// SetRoutingControlCount sets the RoutingControlCount field's value.
func (s *ControlPanel) SetRoutingControlCount(v int64) *ControlPanel {
	s.RoutingControlCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ControlPanel) SetStatus(v string) *ControlPanel {
	s.Status = &v
	return s
}

// The properties of a request to create a cluster.
type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive string of up to 64 ASCII characters. To make an
	// idempotent API request with an action, specify a client token in the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `min:"1" type:"string" required:"true"`

	// The tags associated with the cluster.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateClusterInput) SetClientToken(v string) *CreateClusterInput {
	s.ClientToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// The result of a successful CreateCluster request.
type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster that was created.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

// A request to create a control panel.
type CreateControlPanelInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive string of up to 64 ASCII characters. To make an
	// idempotent API request with an action, specify a client token in the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the cluster for the control panel.
	//
	// ClusterArn is a required field
	ClusterArn *string `min:"1" type:"string" required:"true"`

	// The name of the control panel.
	//
	// ControlPanelName is a required field
	ControlPanelName *string `min:"1" type:"string" required:"true"`

	// The tags associated with the control panel.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateControlPanelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateControlPanelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateControlPanelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateControlPanelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.ControlPanelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelName"))
	}
	if s.ControlPanelName != nil && len(*s.ControlPanelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateControlPanelInput) SetClientToken(v string) *CreateControlPanelInput {
	s.ClientToken = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateControlPanelInput) SetClusterArn(v string) *CreateControlPanelInput {
	s.ClusterArn = &v
	return s
}

// SetControlPanelName sets the ControlPanelName field's value.
func (s *CreateControlPanelInput) SetControlPanelName(v string) *CreateControlPanelInput {
	s.ControlPanelName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateControlPanelInput) SetTags(v map[string]*string) *CreateControlPanelInput {
	s.Tags = v
	return s
}

// The result of a successful CreateControlPanel request.
type CreateControlPanelOutput struct {
	_ struct{} `type:"structure"`

	// Information about a control panel.
	ControlPanel *ControlPanel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateControlPanelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateControlPanelOutput) GoString() string {
	return s.String()
}

// SetControlPanel sets the ControlPanel field's value.
func (s *CreateControlPanelOutput) SetControlPanel(v *ControlPanel) *CreateControlPanelOutput {
	s.ControlPanel = v
	return s
}

// A request to create a routing control. If you don't specify ControlPanelArn,
// Amazon Route 53 Application Recovery Controller creates the routing control
// in DefaultControlPanel.
type CreateRoutingControlInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive string of up to 64 ASCII characters. To make an
	// idempotent API request with an action, specify a client token in the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the cluster that includes the routing control.
	//
	// ClusterArn is a required field
	ClusterArn *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the control panel that includes the routing
	// control.
	ControlPanelArn *string `min:"1" type:"string"`

	// The name of the routing control.
	//
	// RoutingControlName is a required field
	RoutingControlName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoutingControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoutingControlInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.RoutingControlName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlName"))
	}
	if s.RoutingControlName != nil && len(*s.RoutingControlName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRoutingControlInput) SetClientToken(v string) *CreateRoutingControlInput {
	s.ClientToken = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateRoutingControlInput) SetClusterArn(v string) *CreateRoutingControlInput {
	s.ClusterArn = &v
	return s
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *CreateRoutingControlInput) SetControlPanelArn(v string) *CreateRoutingControlInput {
	s.ControlPanelArn = &v
	return s
}

// SetRoutingControlName sets the RoutingControlName field's value.
func (s *CreateRoutingControlInput) SetRoutingControlName(v string) *CreateRoutingControlInput {
	s.RoutingControlName = &v
	return s
}

// The result of a successful CreateRoutingControl request.
type CreateRoutingControlOutput struct {
	_ struct{} `type:"structure"`

	// The routing control that is created.
	RoutingControl *RoutingControl `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingControlOutput) GoString() string {
	return s.String()
}

// SetRoutingControl sets the RoutingControl field's value.
func (s *CreateRoutingControlOutput) SetRoutingControl(v *RoutingControl) *CreateRoutingControlOutput {
	s.RoutingControl = v
	return s
}

// Request to create a safety rule. You can create either an assertion rule
// or a gating rule with a CreateSafetyRuleRequest call.
type CreateSafetyRuleInput struct {
	_ struct{} `type:"structure"`

	// The assertion rule requested.
	AssertionRule *NewAssertionRule `type:"structure"`

	// A unique, case-sensitive string of up to 64 ASCII characters. To make an
	// idempotent API request with an action, specify a client token in the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The gating rule requested.
	GatingRule *NewGatingRule `type:"structure"`

	// The tags associated with the safety rule.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSafetyRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSafetyRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSafetyRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSafetyRuleInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.AssertionRule != nil {
		if err := s.AssertionRule.Validate(); err != nil {
			invalidParams.AddNested("AssertionRule", err.(request.ErrInvalidParams))
		}
	}
	if s.GatingRule != nil {
		if err := s.GatingRule.Validate(); err != nil {
			invalidParams.AddNested("GatingRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssertionRule sets the AssertionRule field's value.
func (s *CreateSafetyRuleInput) SetAssertionRule(v *NewAssertionRule) *CreateSafetyRuleInput {
	s.AssertionRule = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSafetyRuleInput) SetClientToken(v string) *CreateSafetyRuleInput {
	s.ClientToken = &v
	return s
}

// SetGatingRule sets the GatingRule field's value.
func (s *CreateSafetyRuleInput) SetGatingRule(v *NewGatingRule) *CreateSafetyRuleInput {
	s.GatingRule = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSafetyRuleInput) SetTags(v map[string]*string) *CreateSafetyRuleInput {
	s.Tags = v
	return s
}

// The result of a successful CreateSafetyRule request.
type CreateSafetyRuleOutput struct {
	_ struct{} `type:"structure"`

	// The assertion rule created.
	AssertionRule *AssertionRule `type:"structure"`

	// The gating rule created.
	GatingRule *GatingRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSafetyRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSafetyRuleOutput) GoString() string {
	return s.String()
}

// SetAssertionRule sets the AssertionRule field's value.
func (s *CreateSafetyRuleOutput) SetAssertionRule(v *AssertionRule) *CreateSafetyRuleOutput {
	s.AssertionRule = v
	return s
}

// SetGatingRule sets the GatingRule field's value.
func (s *CreateSafetyRuleOutput) SetGatingRule(v *GatingRule) *CreateSafetyRuleOutput {
	s.GatingRule = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"ClusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterInput) SetClusterArn(v string) *DeleteClusterInput {
	s.ClusterArn = &v
	return s
}

// A successful DeleteCluster request returns no response.
type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

type DeleteControlPanelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ControlPanelArn is a required field
	ControlPanelArn *string `location:"uri" locationName:"ControlPanelArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteControlPanelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteControlPanelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteControlPanelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteControlPanelInput"}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *DeleteControlPanelInput) SetControlPanelArn(v string) *DeleteControlPanelInput {
	s.ControlPanelArn = &v
	return s
}

// A successful DeleteControlPanel request returns no response.
type DeleteControlPanelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteControlPanelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteControlPanelOutput) GoString() string {
	return s.String()
}

type DeleteRoutingControlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// RoutingControlArn is a required field
	RoutingControlArn *string `location:"uri" locationName:"RoutingControlArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoutingControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoutingControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoutingControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoutingControlInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *DeleteRoutingControlInput) SetRoutingControlArn(v string) *DeleteRoutingControlInput {
	s.RoutingControlArn = &v
	return s
}

// A successful DeleteRoutingControl request returns no response.
type DeleteRoutingControlOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoutingControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRoutingControlOutput) GoString() string {
	return s.String()
}

type DeleteSafetyRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SafetyRuleArn is a required field
	SafetyRuleArn *string `location:"uri" locationName:"SafetyRuleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSafetyRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSafetyRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSafetyRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSafetyRuleInput"}
	if s.SafetyRuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SafetyRuleArn"))
	}
	if s.SafetyRuleArn != nil && len(*s.SafetyRuleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SafetyRuleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSafetyRuleArn sets the SafetyRuleArn field's value.
func (s *DeleteSafetyRuleInput) SetSafetyRuleArn(v string) *DeleteSafetyRuleInput {
	s.SafetyRuleArn = &v
	return s
}

// There is an empty response when you delete a safety rule.
// />
type DeleteSafetyRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSafetyRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSafetyRuleOutput) GoString() string {
	return s.String()
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"ClusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DescribeClusterInput) SetClusterArn(v string) *DescribeClusterInput {
	s.ClusterArn = &v
	return s
}

// The result of a successful DescribeCluster request.
type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster for the DescribeCluster request.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DescribeClusterOutput) SetCluster(v *Cluster) *DescribeClusterOutput {
	s.Cluster = v
	return s
}

type DescribeControlPanelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ControlPanelArn is a required field
	ControlPanelArn *string `location:"uri" locationName:"ControlPanelArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeControlPanelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeControlPanelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeControlPanelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeControlPanelInput"}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *DescribeControlPanelInput) SetControlPanelArn(v string) *DescribeControlPanelInput {
	s.ControlPanelArn = &v
	return s
}

// The result of a successful DescribeControlPanel request.
type DescribeControlPanelOutput struct {
	_ struct{} `type:"structure"`

	// Information about the control panel.
	ControlPanel *ControlPanel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeControlPanelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeControlPanelOutput) GoString() string {
	return s.String()
}

// SetControlPanel sets the ControlPanel field's value.
func (s *DescribeControlPanelOutput) SetControlPanel(v *ControlPanel) *DescribeControlPanelOutput {
	s.ControlPanel = v
	return s
}

type DescribeRoutingControlInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// RoutingControlArn is a required field
	RoutingControlArn *string `location:"uri" locationName:"RoutingControlArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRoutingControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRoutingControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRoutingControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRoutingControlInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *DescribeRoutingControlInput) SetRoutingControlArn(v string) *DescribeRoutingControlInput {
	s.RoutingControlArn = &v
	return s
}

// The result of a successful DescribeRoutingControl request.
type DescribeRoutingControlOutput struct {
	_ struct{} `type:"structure"`

	// Information about the routing control.
	RoutingControl *RoutingControl `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRoutingControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRoutingControlOutput) GoString() string {
	return s.String()
}

// SetRoutingControl sets the RoutingControl field's value.
func (s *DescribeRoutingControlOutput) SetRoutingControl(v *RoutingControl) *DescribeRoutingControlOutput {
	s.RoutingControl = v
	return s
}

type DescribeSafetyRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// SafetyRuleArn is a required field
	SafetyRuleArn *string `location:"uri" locationName:"SafetyRuleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSafetyRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSafetyRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSafetyRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSafetyRuleInput"}
	if s.SafetyRuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SafetyRuleArn"))
	}
	if s.SafetyRuleArn != nil && len(*s.SafetyRuleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SafetyRuleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSafetyRuleArn sets the SafetyRuleArn field's value.
func (s *DescribeSafetyRuleInput) SetSafetyRuleArn(v string) *DescribeSafetyRuleInput {
	s.SafetyRuleArn = &v
	return s
}

// The response when you send a DescribeSafetyRuleResponse request.
type DescribeSafetyRuleOutput struct {
	_ struct{} `type:"structure"`

	// The assertion rule in the response.
	AssertionRule *AssertionRule `type:"structure"`

	// The gating rule in the response.
	GatingRule *GatingRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSafetyRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSafetyRuleOutput) GoString() string {
	return s.String()
}

// SetAssertionRule sets the AssertionRule field's value.
func (s *DescribeSafetyRuleOutput) SetAssertionRule(v *AssertionRule) *DescribeSafetyRuleOutput {
	s.AssertionRule = v
	return s
}

// SetGatingRule sets the GatingRule field's value.
func (s *DescribeSafetyRuleOutput) SetGatingRule(v *GatingRule) *DescribeSafetyRuleOutput {
	s.GatingRule = v
	return s
}

// A gating rule verifies that a gating routing control or set of gating rounting
// controls, evaluates as true, based on a rule configuration that you specify,
// which allows a set of routing control state changes to complete.
//
// For example, if you specify one gating routing control and you set the Type
// in the rule configuration to OR, that indicates that you must set the gating
// routing control to On for the rule to evaluate as true; that is, for the
// gating control "switch" to be "On". When you do that, then you can update
// the routing control states for the target routing controls that you specify
// in the gating rule.
type GatingRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the control panel.
	//
	// ControlPanelArn is a required field
	ControlPanelArn *string `min:"1" type:"string" required:"true"`

	// An array of gating routing control Amazon Resource Names (ARNs). For a simple
	// "on/off" switch, specify the ARN for one routing control. The gating routing
	// controls are evaluated by the rule configuration that you specify to determine
	// if the target routing control states can be changed.
	//
	// GatingControls is a required field
	GatingControls []*string `type:"list" required:"true"`

	// The name for the gating rule. You can use any non-white space character in
	// the name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The criteria that you set for gating routing controls that designates how
	// many of the routing control states must be ON to allow you to update target
	// routing control states.
	//
	// RuleConfig is a required field
	RuleConfig *RuleConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the gating rule.
	//
	// SafetyRuleArn is a required field
	SafetyRuleArn *string `min:"1" type:"string" required:"true"`

	// The deployment status of a gating rule. Status can be one of the following:
	// PENDING, DEPLOYED, PENDING_DELETION.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"Status"`

	// An array of target routing control Amazon Resource Names (ARNs) for which
	// the states can only be updated if the rule configuration that you specify
	// evaluates to true for the gating routing control. As a simple example, if
	// you have a single gating control, it acts as an overall "on/off" switch for
	// a set of target routing controls. You can use this to manually override automated
	// fail over, for example.
	//
	// TargetControls is a required field
	TargetControls []*string `type:"list" required:"true"`

	// An evaluation period, in milliseconds (ms), during which any request against
	// the target routing controls will fail. This helps prevent "flapping" of state.
	// The wait period is 5000 ms by default, but you can choose a custom value.
	//
	// WaitPeriodMs is a required field
	WaitPeriodMs *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatingRule) GoString() string {
	return s.String()
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *GatingRule) SetControlPanelArn(v string) *GatingRule {
	s.ControlPanelArn = &v
	return s
}

// SetGatingControls sets the GatingControls field's value.
func (s *GatingRule) SetGatingControls(v []*string) *GatingRule {
	s.GatingControls = v
	return s
}

// SetName sets the Name field's value.
func (s *GatingRule) SetName(v string) *GatingRule {
	s.Name = &v
	return s
}

// SetRuleConfig sets the RuleConfig field's value.
func (s *GatingRule) SetRuleConfig(v *RuleConfig) *GatingRule {
	s.RuleConfig = v
	return s
}

// SetSafetyRuleArn sets the SafetyRuleArn field's value.
func (s *GatingRule) SetSafetyRuleArn(v string) *GatingRule {
	s.SafetyRuleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GatingRule) SetStatus(v string) *GatingRule {
	s.Status = &v
	return s
}

// SetTargetControls sets the TargetControls field's value.
func (s *GatingRule) SetTargetControls(v []*string) *GatingRule {
	s.TargetControls = v
	return s
}

// SetWaitPeriodMs sets the WaitPeriodMs field's value.
func (s *GatingRule) SetWaitPeriodMs(v int64) *GatingRule {
	s.WaitPeriodMs = &v
	return s
}

// Update to a gating rule. You can update the name or the evaluation period
// (wait period). If you don't specify one of the items to update, the item
// is unchanged.
type GatingRuleUpdate struct {
	_ struct{} `type:"structure"`

	// The name for the gating rule. You can use any non-white space character in
	// the name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gating rule.
	//
	// SafetyRuleArn is a required field
	SafetyRuleArn *string `min:"1" type:"string" required:"true"`

	// An evaluation period, in milliseconds (ms), during which any request against
	// the target routing controls will fail. This helps prevent "flapping" of state.
	// The wait period is 5000 ms by default, but you can choose a custom value.
	//
	// WaitPeriodMs is a required field
	WaitPeriodMs *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatingRuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatingRuleUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GatingRuleUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GatingRuleUpdate"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SafetyRuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SafetyRuleArn"))
	}
	if s.SafetyRuleArn != nil && len(*s.SafetyRuleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SafetyRuleArn", 1))
	}
	if s.WaitPeriodMs == nil {
		invalidParams.Add(request.NewErrParamRequired("WaitPeriodMs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GatingRuleUpdate) SetName(v string) *GatingRuleUpdate {
	s.Name = &v
	return s
}

// SetSafetyRuleArn sets the SafetyRuleArn field's value.
func (s *GatingRuleUpdate) SetSafetyRuleArn(v string) *GatingRuleUpdate {
	s.SafetyRuleArn = &v
	return s
}

// SetWaitPeriodMs sets the WaitPeriodMs field's value.
func (s *GatingRuleUpdate) SetWaitPeriodMs(v int64) *GatingRuleUpdate {
	s.WaitPeriodMs = &v
	return s
}

// 500 response - InternalServiceError. Temporary service error. Retry the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAssociatedRoute53HealthChecksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// RoutingControlArn is a required field
	RoutingControlArn *string `location:"uri" locationName:"RoutingControlArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedRoute53HealthChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedRoute53HealthChecksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedRoute53HealthChecksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedRoute53HealthChecksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociatedRoute53HealthChecksInput) SetMaxResults(v int64) *ListAssociatedRoute53HealthChecksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedRoute53HealthChecksInput) SetNextToken(v string) *ListAssociatedRoute53HealthChecksInput {
	s.NextToken = &v
	return s
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *ListAssociatedRoute53HealthChecksInput) SetRoutingControlArn(v string) *ListAssociatedRoute53HealthChecksInput {
	s.RoutingControlArn = &v
	return s
}

// The result of a successful ListAssociatedRoute53HealthChecks request.
type ListAssociatedRoute53HealthChecksOutput struct {
	_ struct{} `type:"structure"`

	// Identifiers for the health checks.
	HealthCheckIds []*string `type:"list"`

	// Next token for listing health checks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedRoute53HealthChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedRoute53HealthChecksOutput) GoString() string {
	return s.String()
}

// SetHealthCheckIds sets the HealthCheckIds field's value.
func (s *ListAssociatedRoute53HealthChecksOutput) SetHealthCheckIds(v []*string) *ListAssociatedRoute53HealthChecksOutput {
	s.HealthCheckIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedRoute53HealthChecksOutput) SetNextToken(v string) *ListAssociatedRoute53HealthChecksOutput {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListClusters request.
type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// An array of the clusters in an account.
	Clusters []*Cluster `type:"list"`

	// The token that identifies which batch of results you want to see.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *ListClustersOutput) SetClusters(v []*Cluster) *ListClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListControlPanelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	ClusterArn *string `location:"querystring" locationName:"ClusterArn" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListControlPanelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListControlPanelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListControlPanelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListControlPanelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListControlPanelsInput) SetClusterArn(v string) *ListControlPanelsInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListControlPanelsInput) SetMaxResults(v int64) *ListControlPanelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListControlPanelsInput) SetNextToken(v string) *ListControlPanelsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListControlPanel request.
type ListControlPanelsOutput struct {
	_ struct{} `type:"structure"`

	// The result of a successful ListControlPanel request.
	ControlPanels []*ControlPanel `type:"list"`

	// The token that identifies which batch of results you want to see.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListControlPanelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListControlPanelsOutput) GoString() string {
	return s.String()
}

// SetControlPanels sets the ControlPanels field's value.
func (s *ListControlPanelsOutput) SetControlPanels(v []*ControlPanel) *ListControlPanelsOutput {
	s.ControlPanels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListControlPanelsOutput) SetNextToken(v string) *ListControlPanelsOutput {
	s.NextToken = &v
	return s
}

type ListRoutingControlsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ControlPanelArn is a required field
	ControlPanelArn *string `location:"uri" locationName:"ControlPanelArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutingControlsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutingControlsInput"}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *ListRoutingControlsInput) SetControlPanelArn(v string) *ListRoutingControlsInput {
	s.ControlPanelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoutingControlsInput) SetMaxResults(v int64) *ListRoutingControlsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingControlsInput) SetNextToken(v string) *ListRoutingControlsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListRoutingControl request.
type ListRoutingControlsOutput struct {
	_ struct{} `type:"structure"`

	// The token that identifies which batch of results you want to see.
	NextToken *string `min:"1" type:"string"`

	// An array of routing controls.
	RoutingControls []*RoutingControl `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRoutingControlsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingControlsOutput) SetNextToken(v string) *ListRoutingControlsOutput {
	s.NextToken = &v
	return s
}

// SetRoutingControls sets the RoutingControls field's value.
func (s *ListRoutingControlsOutput) SetRoutingControls(v []*RoutingControl) *ListRoutingControlsOutput {
	s.RoutingControls = v
	return s
}

type ListSafetyRulesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ControlPanelArn is a required field
	ControlPanelArn *string `location:"uri" locationName:"ControlPanelArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSafetyRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSafetyRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSafetyRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSafetyRulesInput"}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *ListSafetyRulesInput) SetControlPanelArn(v string) *ListSafetyRulesInput {
	s.ControlPanelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSafetyRulesInput) SetMaxResults(v int64) *ListSafetyRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSafetyRulesInput) SetNextToken(v string) *ListSafetyRulesInput {
	s.NextToken = &v
	return s
}

// The response to a ListSafetyRulesRequest.
type ListSafetyRulesOutput struct {
	_ struct{} `type:"structure"`

	// The token that identifies which batch of results you want to see.
	NextToken *string `min:"1" type:"string"`

	// The list of safety rules in a control panel.
	SafetyRules []*Rule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSafetyRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSafetyRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSafetyRulesOutput) SetNextToken(v string) *ListSafetyRulesOutput {
	s.NextToken = &v
	return s
}

// SetSafetyRules sets the SafetyRules field's value.
func (s *ListSafetyRulesOutput) SetSafetyRules(v []*Rule) *ListSafetyRulesOutput {
	s.SafetyRules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// The result of a successful ListTagsForResource request.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A new assertion rule for a control panel.
type NewAssertionRule struct {
	_ struct{} `type:"structure"`

	// The routing controls that are part of transactions that are evaluated to
	// determine if a request to change a routing control state is allowed. For
	// example, you might include three routing controls, one for each of three
	// Amazon Web Services Regions.
	//
	// AssertedControls is a required field
	AssertedControls []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) for the control panel.
	//
	// ControlPanelArn is a required field
	ControlPanelArn *string `min:"1" type:"string" required:"true"`

	// The name of the assertion rule. You can use any non-white space character
	// in the name.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The criteria that you set for specific assertion controls (routing controls)
	// that designate how many control states must be ON as the result of a transaction.
	// For example, if you have three assertion controls, you might specify ATLEAST
	// 2for your rule configuration. This means that at least two assertion controls
	// must be ON, so that at least two Amazon Web Services Regions have traffic
	// flowing to them.
	//
	// RuleConfig is a required field
	RuleConfig *RuleConfig `type:"structure" required:"true"`

	// An evaluation period, in milliseconds (ms), during which any request against
	// the target routing controls will fail. This helps prevent "flapping" of state.
	// The wait period is 5000 ms by default, but you can choose a custom value.
	//
	// WaitPeriodMs is a required field
	WaitPeriodMs *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewAssertionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewAssertionRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewAssertionRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewAssertionRule"}
	if s.AssertedControls == nil {
		invalidParams.Add(request.NewErrParamRequired("AssertedControls"))
	}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuleConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleConfig"))
	}
	if s.WaitPeriodMs == nil {
		invalidParams.Add(request.NewErrParamRequired("WaitPeriodMs"))
	}
	if s.RuleConfig != nil {
		if err := s.RuleConfig.Validate(); err != nil {
			invalidParams.AddNested("RuleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssertedControls sets the AssertedControls field's value.
func (s *NewAssertionRule) SetAssertedControls(v []*string) *NewAssertionRule {
	s.AssertedControls = v
	return s
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *NewAssertionRule) SetControlPanelArn(v string) *NewAssertionRule {
	s.ControlPanelArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *NewAssertionRule) SetName(v string) *NewAssertionRule {
	s.Name = &v
	return s
}

// SetRuleConfig sets the RuleConfig field's value.
func (s *NewAssertionRule) SetRuleConfig(v *RuleConfig) *NewAssertionRule {
	s.RuleConfig = v
	return s
}

// SetWaitPeriodMs sets the WaitPeriodMs field's value.
func (s *NewAssertionRule) SetWaitPeriodMs(v int64) *NewAssertionRule {
	s.WaitPeriodMs = &v
	return s
}

// A new gating rule for a control panel.
type NewGatingRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the control panel.
	//
	// ControlPanelArn is a required field
	ControlPanelArn *string `min:"1" type:"string" required:"true"`

	// The gating controls for the new gating rule. That is, routing controls that
	// are evaluated by the rule configuration that you specify.
	//
	// GatingControls is a required field
	GatingControls []*string `type:"list" required:"true"`

	// The name for the new gating rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The criteria that you set for specific gating controls (routing controls)
	// that designates how many control states must be ON to allow you to change
	// (set or unset) the target control states.
	//
	// RuleConfig is a required field
	RuleConfig *RuleConfig `type:"structure" required:"true"`

	// Routing controls that can only be set or unset if the specified RuleConfig
	// evaluates to true for the specified GatingControls. For example, say you
	// have three gating controls, one for each of three Amazon Web Services Regions.
	// Now you specify AtLeast 2 as your RuleConfig. With these settings, you can
	// only change (set or unset) the routing controls that you have specified as
	// TargetControls if that rule evaluates to true.
	//
	// In other words, your ability to change the routing controls that you have
	// specified as TargetControls is gated by the rule that you set for the routing
	// controls in GatingControls.
	//
	// TargetControls is a required field
	TargetControls []*string `type:"list" required:"true"`

	// An evaluation period, in milliseconds (ms), during which any request against
	// the target routing controls will fail. This helps prevent "flapping" of state.
	// The wait period is 5000 ms by default, but you can choose a custom value.
	//
	// WaitPeriodMs is a required field
	WaitPeriodMs *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewGatingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NewGatingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewGatingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewGatingRule"}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.GatingControls == nil {
		invalidParams.Add(request.NewErrParamRequired("GatingControls"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuleConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleConfig"))
	}
	if s.TargetControls == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetControls"))
	}
	if s.WaitPeriodMs == nil {
		invalidParams.Add(request.NewErrParamRequired("WaitPeriodMs"))
	}
	if s.RuleConfig != nil {
		if err := s.RuleConfig.Validate(); err != nil {
			invalidParams.AddNested("RuleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *NewGatingRule) SetControlPanelArn(v string) *NewGatingRule {
	s.ControlPanelArn = &v
	return s
}

// SetGatingControls sets the GatingControls field's value.
func (s *NewGatingRule) SetGatingControls(v []*string) *NewGatingRule {
	s.GatingControls = v
	return s
}

// SetName sets the Name field's value.
func (s *NewGatingRule) SetName(v string) *NewGatingRule {
	s.Name = &v
	return s
}

// SetRuleConfig sets the RuleConfig field's value.
func (s *NewGatingRule) SetRuleConfig(v *RuleConfig) *NewGatingRule {
	s.RuleConfig = v
	return s
}

// SetTargetControls sets the TargetControls field's value.
func (s *NewGatingRule) SetTargetControls(v []*string) *NewGatingRule {
	s.TargetControls = v
	return s
}

// SetWaitPeriodMs sets the WaitPeriodMs field's value.
func (s *NewGatingRule) SetWaitPeriodMs(v int64) *NewGatingRule {
	s.WaitPeriodMs = &v
	return s
}

// 404 response - MalformedQueryString. The query string contains a syntax error
// or resource not found..
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A routing control has one of two states: ON and OFF. You can map the routing
// control state to the state of an Amazon Route 53 health check, which can
// be used to control traffic routing.
type RoutingControl struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the control panel that includes the routing
	// control.
	ControlPanelArn *string `min:"1" type:"string"`

	// The name of the routing control.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the routing control.
	RoutingControlArn *string `min:"1" type:"string"`

	// The deployment status of a routing control. Status can be one of the following:
	// PENDING, DEPLOYED, PENDING_DELETION.
	Status *string `type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoutingControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RoutingControl) GoString() string {
	return s.String()
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *RoutingControl) SetControlPanelArn(v string) *RoutingControl {
	s.ControlPanelArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *RoutingControl) SetName(v string) *RoutingControl {
	s.Name = &v
	return s
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *RoutingControl) SetRoutingControlArn(v string) *RoutingControl {
	s.RoutingControlArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RoutingControl) SetStatus(v string) *RoutingControl {
	s.Status = &v
	return s
}

// A safety rule. A safety rule can be an assertion rule or a gating rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// An assertion rule enforces that, when a routing control state is changed,
	// the criteria set by the rule configuration is met. Otherwise, the change
	// to the routing control state is not accepted. For example, the criteria might
	// be that at least one routing control state is On after the transation so
	// that traffic continues to flow to at least one cell for the application.
	// This ensures that you avoid a fail-open scenario.
	ASSERTION *AssertionRule `type:"structure"`

	// A gating rule verifies that a gating routing control or set of gating rounting
	// controls, evaluates as true, based on a rule configuration that you specify,
	// which allows a set of routing control state changes to complete.
	//
	// For example, if you specify one gating routing control and you set the Type
	// in the rule configuration to OR, that indicates that you must set the gating
	// routing control to On for the rule to evaluate as true; that is, for the
	// gating control "switch" to be "On". When you do that, then you can update
	// the routing control states for the target routing controls that you specify
	// in the gating rule.
	GATING *GatingRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// SetASSERTION sets the ASSERTION field's value.
func (s *Rule) SetASSERTION(v *AssertionRule) *Rule {
	s.ASSERTION = v
	return s
}

// SetGATING sets the GATING field's value.
func (s *Rule) SetGATING(v *GatingRule) *Rule {
	s.GATING = v
	return s
}

// The rule configuration for an assertion rule. That is, the criteria that
// you set for specific assertion controls (routing controls) that specify how
// many control states must be ON after a transaction completes.
type RuleConfig struct {
	_ struct{} `type:"structure"`

	// Logical negation of the rule. If the rule would usually evaluate true, it's
	// evaluated as false, and vice versa.
	//
	// Inverted is a required field
	Inverted *bool `type:"boolean" required:"true"`

	// The value of N, when you specify an ATLEAST rule type. That is, Threshold
	// is the number of controls that must be set when you specify an ATLEAST type.
	//
	// Threshold is a required field
	Threshold *int64 `type:"integer" required:"true"`

	// A rule can be one of the following: ATLEAST, AND, or OR.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RuleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleConfig"}
	if s.Inverted == nil {
		invalidParams.Add(request.NewErrParamRequired("Inverted"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInverted sets the Inverted field's value.
func (s *RuleConfig) SetInverted(v bool) *RuleConfig {
	s.Inverted = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *RuleConfig) SetThreshold(v int64) *RuleConfig {
	s.Threshold = &v
	return s
}

// SetType sets the Type field's value.
func (s *RuleConfig) SetType(v string) *RuleConfig {
	s.Type = &v
	return s
}

// 402 response - You attempted to create more resources than the service allows
// based on service quotas.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request to tag a resource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags associated with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

// The result of a successful TagResource request.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// 429 response - LimitExceededException or TooManyRequestsException.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"TagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The result of a successful UntagResource request.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Updates an existing control panel.
type UpdateControlPanelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the control panel.
	//
	// ControlPanelArn is a required field
	ControlPanelArn *string `min:"1" type:"string" required:"true"`

	// The name of the control panel.
	//
	// ControlPanelName is a required field
	ControlPanelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateControlPanelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateControlPanelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateControlPanelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateControlPanelInput"}
	if s.ControlPanelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelArn"))
	}
	if s.ControlPanelArn != nil && len(*s.ControlPanelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelArn", 1))
	}
	if s.ControlPanelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPanelName"))
	}
	if s.ControlPanelName != nil && len(*s.ControlPanelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ControlPanelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPanelArn sets the ControlPanelArn field's value.
func (s *UpdateControlPanelInput) SetControlPanelArn(v string) *UpdateControlPanelInput {
	s.ControlPanelArn = &v
	return s
}

// SetControlPanelName sets the ControlPanelName field's value.
func (s *UpdateControlPanelInput) SetControlPanelName(v string) *UpdateControlPanelInput {
	s.ControlPanelName = &v
	return s
}

// The result of a successful UpdateControlPanel request.
type UpdateControlPanelOutput struct {
	_ struct{} `type:"structure"`

	// The control panel to update.
	ControlPanel *ControlPanel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateControlPanelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateControlPanelOutput) GoString() string {
	return s.String()
}

// SetControlPanel sets the ControlPanel field's value.
func (s *UpdateControlPanelOutput) SetControlPanel(v *ControlPanel) *UpdateControlPanelOutput {
	s.ControlPanel = v
	return s
}

// A request to update a routing control.
type UpdateRoutingControlInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the routing control.
	//
	// RoutingControlArn is a required field
	RoutingControlArn *string `min:"1" type:"string" required:"true"`

	// The name of the routing control.
	//
	// RoutingControlName is a required field
	RoutingControlName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoutingControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoutingControlInput"}
	if s.RoutingControlArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlArn"))
	}
	if s.RoutingControlArn != nil && len(*s.RoutingControlArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlArn", 1))
	}
	if s.RoutingControlName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingControlName"))
	}
	if s.RoutingControlName != nil && len(*s.RoutingControlName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingControlName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoutingControlArn sets the RoutingControlArn field's value.
func (s *UpdateRoutingControlInput) SetRoutingControlArn(v string) *UpdateRoutingControlInput {
	s.RoutingControlArn = &v
	return s
}

// SetRoutingControlName sets the RoutingControlName field's value.
func (s *UpdateRoutingControlInput) SetRoutingControlName(v string) *UpdateRoutingControlInput {
	s.RoutingControlName = &v
	return s
}

// The result of a successful UpdateRoutingControl request.
type UpdateRoutingControlOutput struct {
	_ struct{} `type:"structure"`

	// The routing control that was updated.
	RoutingControl *RoutingControl `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRoutingControlOutput) GoString() string {
	return s.String()
}

// SetRoutingControl sets the RoutingControl field's value.
func (s *UpdateRoutingControlOutput) SetRoutingControl(v *RoutingControl) *UpdateRoutingControlOutput {
	s.RoutingControl = v
	return s
}

// Request to update a safety rule. A safety rule can be an assertion rule or
// a gating rule.
type UpdateSafetyRuleInput struct {
	_ struct{} `type:"structure"`

	// The assertion rule to update.
	AssertionRuleUpdate *AssertionRuleUpdate `type:"structure"`

	// The gating rule to update.
	GatingRuleUpdate *GatingRuleUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSafetyRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSafetyRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSafetyRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSafetyRuleInput"}
	if s.AssertionRuleUpdate != nil {
		if err := s.AssertionRuleUpdate.Validate(); err != nil {
			invalidParams.AddNested("AssertionRuleUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.GatingRuleUpdate != nil {
		if err := s.GatingRuleUpdate.Validate(); err != nil {
			invalidParams.AddNested("GatingRuleUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssertionRuleUpdate sets the AssertionRuleUpdate field's value.
func (s *UpdateSafetyRuleInput) SetAssertionRuleUpdate(v *AssertionRuleUpdate) *UpdateSafetyRuleInput {
	s.AssertionRuleUpdate = v
	return s
}

// SetGatingRuleUpdate sets the GatingRuleUpdate field's value.
func (s *UpdateSafetyRuleInput) SetGatingRuleUpdate(v *GatingRuleUpdate) *UpdateSafetyRuleInput {
	s.GatingRuleUpdate = v
	return s
}

// The result of a successful UpdateSafetyRule request.
type UpdateSafetyRuleOutput struct {
	_ struct{} `type:"structure"`

	// The assertion rule updated.
	AssertionRule *AssertionRule `type:"structure"`

	// The gating rule updated.
	GatingRule *GatingRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSafetyRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSafetyRuleOutput) GoString() string {
	return s.String()
}

// SetAssertionRule sets the AssertionRule field's value.
func (s *UpdateSafetyRuleOutput) SetAssertionRule(v *AssertionRule) *UpdateSafetyRuleOutput {
	s.AssertionRule = v
	return s
}

// SetGatingRule sets the GatingRule field's value.
func (s *UpdateSafetyRuleOutput) SetGatingRule(v *GatingRule) *UpdateSafetyRuleOutput {
	s.GatingRule = v
	return s
}

// 400 response - Multiple causes. For example, you might have a malformed query
// string and input parameter might be out of range, or you might have used
// parameters together incorrectly.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An enumerated type that determines how the evaluated rules are processed.
// RuleType can be one of the following:
//
// ATLEAST - At least N routing controls must be set. You specify N as the Threshold
// in the rule configuration.
//
// AND - All routing controls must be set. This is a shortcut for "At least
// N," where N is the total number of controls in the rule.
//
// OR - Any control must be set. This is a shortcut for "At least N," where
// N is 1.
const (
	// RuleTypeAtleast is a RuleType enum value
	RuleTypeAtleast = "ATLEAST"

	// RuleTypeAnd is a RuleType enum value
	RuleTypeAnd = "AND"

	// RuleTypeOr is a RuleType enum value
	RuleTypeOr = "OR"
)

// RuleType_Values returns all elements of the RuleType enum
func RuleType_Values() []string {
	return []string{
		RuleTypeAtleast,
		RuleTypeAnd,
		RuleTypeOr,
	}
}

// The deployment status of a resource. Status can be one of the following:
//
// PENDING: Amazon Route 53 Application Recovery Controller is creating the
// resource.
//
// DEPLOYED: The resource is deployed and ready to use.
//
// PENDING_DELETION: Amazon Route 53 Application Recovery Controller is deleting
// the resource.
const (
	// StatusPending is a Status enum value
	StatusPending = "PENDING"

	// StatusDeployed is a Status enum value
	StatusDeployed = "DEPLOYED"

	// StatusPendingDeletion is a Status enum value
	StatusPendingDeletion = "PENDING_DELETION"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusPending,
		StatusDeployed,
		StatusPendingDeletion,
	}
}
