// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dialogflow/cx/v3beta1/test_case.proto

package cx

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The test result for a test case and an agent environment.
type TestResult int32

const (
	// Not specified. Should never be used.
	TestResult_TEST_RESULT_UNSPECIFIED TestResult = 0
	// The test passed.
	TestResult_PASSED TestResult = 1
	// The test did not pass.
	TestResult_FAILED TestResult = 2
)

// Enum value maps for TestResult.
var (
	TestResult_name = map[int32]string{
		0: "TEST_RESULT_UNSPECIFIED",
		1: "PASSED",
		2: "FAILED",
	}
	TestResult_value = map[string]int32{
		"TEST_RESULT_UNSPECIFIED": 0,
		"PASSED":                  1,
		"FAILED":                  2,
	}
)

func (x TestResult) Enum() *TestResult {
	p := new(TestResult)
	*p = x
	return p
}

func (x TestResult) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestResult) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[0].Descriptor()
}

func (TestResult) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[0]
}

func (x TestResult) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TestResult.Descriptor instead.
func (TestResult) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{0}
}

// What part of the message replay differs from the test case.
type TestRunDifference_DiffType int32

const (
	// Should never be used.
	TestRunDifference_DIFF_TYPE_UNSPECIFIED TestRunDifference_DiffType = 0
	// The intent.
	TestRunDifference_INTENT TestRunDifference_DiffType = 1
	// The page.
	TestRunDifference_PAGE TestRunDifference_DiffType = 2
	// The parameters.
	TestRunDifference_PARAMETERS TestRunDifference_DiffType = 3
	// The message utterance.
	TestRunDifference_UTTERANCE TestRunDifference_DiffType = 4
)

// Enum value maps for TestRunDifference_DiffType.
var (
	TestRunDifference_DiffType_name = map[int32]string{
		0: "DIFF_TYPE_UNSPECIFIED",
		1: "INTENT",
		2: "PAGE",
		3: "PARAMETERS",
		4: "UTTERANCE",
	}
	TestRunDifference_DiffType_value = map[string]int32{
		"DIFF_TYPE_UNSPECIFIED": 0,
		"INTENT":                1,
		"PAGE":                  2,
		"PARAMETERS":            3,
		"UTTERANCE":             4,
	}
)

func (x TestRunDifference_DiffType) Enum() *TestRunDifference_DiffType {
	p := new(TestRunDifference_DiffType)
	*p = x
	return p
}

func (x TestRunDifference_DiffType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestRunDifference_DiffType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[1].Descriptor()
}

func (TestRunDifference_DiffType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[1]
}

func (x TestRunDifference_DiffType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TestRunDifference_DiffType.Descriptor instead.
func (TestRunDifference_DiffType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{4, 0}
}

// The type of coverage score requested.
type CalculateCoverageRequest_CoverageType int32

const (
	// Should never be used.
	CalculateCoverageRequest_COVERAGE_TYPE_UNSPECIFIED CalculateCoverageRequest_CoverageType = 0
	// Intent coverage.
	CalculateCoverageRequest_INTENT CalculateCoverageRequest_CoverageType = 1
	// Page transition coverage.
	CalculateCoverageRequest_PAGE_TRANSITION CalculateCoverageRequest_CoverageType = 2
	// Transition route group coverage.
	CalculateCoverageRequest_TRANSITION_ROUTE_GROUP CalculateCoverageRequest_CoverageType = 3
)

// Enum value maps for CalculateCoverageRequest_CoverageType.
var (
	CalculateCoverageRequest_CoverageType_name = map[int32]string{
		0: "COVERAGE_TYPE_UNSPECIFIED",
		1: "INTENT",
		2: "PAGE_TRANSITION",
		3: "TRANSITION_ROUTE_GROUP",
	}
	CalculateCoverageRequest_CoverageType_value = map[string]int32{
		"COVERAGE_TYPE_UNSPECIFIED": 0,
		"INTENT":                    1,
		"PAGE_TRANSITION":           2,
		"TRANSITION_ROUTE_GROUP":    3,
	}
)

func (x CalculateCoverageRequest_CoverageType) Enum() *CalculateCoverageRequest_CoverageType {
	p := new(CalculateCoverageRequest_CoverageType)
	*p = x
	return p
}

func (x CalculateCoverageRequest_CoverageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CalculateCoverageRequest_CoverageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[2].Descriptor()
}

func (CalculateCoverageRequest_CoverageType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[2]
}

func (x CalculateCoverageRequest_CoverageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CalculateCoverageRequest_CoverageType.Descriptor instead.
func (CalculateCoverageRequest_CoverageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{8, 0}
}

// Specifies how much test case information to include in the response.
type ListTestCasesRequest_TestCaseView int32

const (
	// The default / unset value.
	// The API will default to the BASIC view.
	ListTestCasesRequest_TEST_CASE_VIEW_UNSPECIFIED ListTestCasesRequest_TestCaseView = 0
	// Include basic metadata about the test case, but not the conversation
	// turns. This is the default value.
	ListTestCasesRequest_BASIC ListTestCasesRequest_TestCaseView = 1
	// Include everything.
	ListTestCasesRequest_FULL ListTestCasesRequest_TestCaseView = 2
)

// Enum value maps for ListTestCasesRequest_TestCaseView.
var (
	ListTestCasesRequest_TestCaseView_name = map[int32]string{
		0: "TEST_CASE_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	ListTestCasesRequest_TestCaseView_value = map[string]int32{
		"TEST_CASE_VIEW_UNSPECIFIED": 0,
		"BASIC":                      1,
		"FULL":                       2,
	}
)

func (x ListTestCasesRequest_TestCaseView) Enum() *ListTestCasesRequest_TestCaseView {
	p := new(ListTestCasesRequest_TestCaseView)
	*p = x
	return p
}

func (x ListTestCasesRequest_TestCaseView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListTestCasesRequest_TestCaseView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[3].Descriptor()
}

func (ListTestCasesRequest_TestCaseView) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[3]
}

func (x ListTestCasesRequest_TestCaseView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListTestCasesRequest_TestCaseView.Descriptor instead.
func (ListTestCasesRequest_TestCaseView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{10, 0}
}

// Data format of the exported test cases.
type ExportTestCasesRequest_DataFormat int32

const (
	// Unspecified format.
	ExportTestCasesRequest_DATA_FORMAT_UNSPECIFIED ExportTestCasesRequest_DataFormat = 0
	// Raw bytes.
	ExportTestCasesRequest_BLOB ExportTestCasesRequest_DataFormat = 1
	// JSON format.
	ExportTestCasesRequest_JSON ExportTestCasesRequest_DataFormat = 2
)

// Enum value maps for ExportTestCasesRequest_DataFormat.
var (
	ExportTestCasesRequest_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "BLOB",
		2: "JSON",
	}
	ExportTestCasesRequest_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"BLOB":                    1,
		"JSON":                    2,
	}
)

func (x ExportTestCasesRequest_DataFormat) Enum() *ExportTestCasesRequest_DataFormat {
	p := new(ExportTestCasesRequest_DataFormat)
	*p = x
	return p
}

func (x ExportTestCasesRequest_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportTestCasesRequest_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[4].Descriptor()
}

func (ExportTestCasesRequest_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes[4]
}

func (x ExportTestCasesRequest_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportTestCasesRequest_DataFormat.Descriptor instead.
func (ExportTestCasesRequest_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{27, 0}
}

// Represents a test case.
type TestCase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the test case.
	// [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase] will populate the name automatically.
	// Otherwise use format: `projects/<Project ID>/locations/<LocationID>/agents/
	// <AgentID>/testCases/<TestCase ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Tags are short descriptions that users may apply to test cases for
	// organizational and filtering purposes. Each tag should start with "#" and
	// has a limit of 30 characters.
	Tags []string `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
	// Required. The human-readable name of the test case, unique within the agent. Limit of
	// 200 characters.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Additional freeform notes about the test case. Limit of 400 characters.
	Notes string `protobuf:"bytes,4,opt,name=notes,proto3" json:"notes,omitempty"`
	// Config for the test case.
	TestConfig *TestConfig `protobuf:"bytes,13,opt,name=test_config,json=testConfig,proto3" json:"test_config,omitempty"`
	// The conversation turns uttered when the test case was created, in
	// chronological order. These include the canonical set of agent utterances
	// that should occur when the agent is working properly.
	TestCaseConversationTurns []*ConversationTurn `protobuf:"bytes,5,rep,name=test_case_conversation_turns,json=testCaseConversationTurns,proto3" json:"test_case_conversation_turns,omitempty"`
	// Output only. When the test was created.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// The latest test result.
	LastTestResult *TestCaseResult `protobuf:"bytes,12,opt,name=last_test_result,json=lastTestResult,proto3" json:"last_test_result,omitempty"`
}

func (x *TestCase) Reset() {
	*x = TestCase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestCase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestCase) ProtoMessage() {}

func (x *TestCase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestCase.ProtoReflect.Descriptor instead.
func (*TestCase) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{0}
}

func (x *TestCase) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TestCase) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *TestCase) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TestCase) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *TestCase) GetTestConfig() *TestConfig {
	if x != nil {
		return x.TestConfig
	}
	return nil
}

func (x *TestCase) GetTestCaseConversationTurns() []*ConversationTurn {
	if x != nil {
		return x.TestCaseConversationTurns
	}
	return nil
}

func (x *TestCase) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *TestCase) GetLastTestResult() *TestCaseResult {
	if x != nil {
		return x.LastTestResult
	}
	return nil
}

// Represents a result from running a test case in an agent environment.
type TestCaseResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name for the test case result. Format:
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/testCases/
	// <TestCase ID>/results/<TestCaseResult ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Environment where the test was run. If not set, it indicates the draft
	// environment.
	Environment string `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
	// The conversation turns uttered during the test case replay in chronological
	// order.
	ConversationTurns []*ConversationTurn `protobuf:"bytes,3,rep,name=conversation_turns,json=conversationTurns,proto3" json:"conversation_turns,omitempty"`
	// Whether the test case passed in the agent environment.
	TestResult TestResult `protobuf:"varint,4,opt,name=test_result,json=testResult,proto3,enum=google.cloud.dialogflow.cx.v3beta1.TestResult" json:"test_result,omitempty"`
	// The time that the test was run.
	TestTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=test_time,json=testTime,proto3" json:"test_time,omitempty"`
}

func (x *TestCaseResult) Reset() {
	*x = TestCaseResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestCaseResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestCaseResult) ProtoMessage() {}

func (x *TestCaseResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestCaseResult.ProtoReflect.Descriptor instead.
func (*TestCaseResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{1}
}

func (x *TestCaseResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TestCaseResult) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *TestCaseResult) GetConversationTurns() []*ConversationTurn {
	if x != nil {
		return x.ConversationTurns
	}
	return nil
}

func (x *TestCaseResult) GetTestResult() TestResult {
	if x != nil {
		return x.TestResult
	}
	return TestResult_TEST_RESULT_UNSPECIFIED
}

func (x *TestCaseResult) GetTestTime() *timestamppb.Timestamp {
	if x != nil {
		return x.TestTime
	}
	return nil
}

// Represents configurations for a test case.
type TestConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Session parameters to be compared when calculating differences.
	TrackingParameters []string `protobuf:"bytes,1,rep,name=tracking_parameters,json=trackingParameters,proto3" json:"tracking_parameters,omitempty"`
	// Flow name. If not set, default start flow is assumed.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>`.
	Flow string `protobuf:"bytes,2,opt,name=flow,proto3" json:"flow,omitempty"`
}

func (x *TestConfig) Reset() {
	*x = TestConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestConfig) ProtoMessage() {}

func (x *TestConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestConfig.ProtoReflect.Descriptor instead.
func (*TestConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{2}
}

func (x *TestConfig) GetTrackingParameters() []string {
	if x != nil {
		return x.TrackingParameters
	}
	return nil
}

func (x *TestConfig) GetFlow() string {
	if x != nil {
		return x.Flow
	}
	return ""
}

// One interaction between a human and virtual agent. The human provides some
// input and the virtual agent provides a response.
type ConversationTurn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user input.
	UserInput *ConversationTurn_UserInput `protobuf:"bytes,1,opt,name=user_input,json=userInput,proto3" json:"user_input,omitempty"`
	// The virtual agent output.
	VirtualAgentOutput *ConversationTurn_VirtualAgentOutput `protobuf:"bytes,2,opt,name=virtual_agent_output,json=virtualAgentOutput,proto3" json:"virtual_agent_output,omitempty"`
}

func (x *ConversationTurn) Reset() {
	*x = ConversationTurn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationTurn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationTurn) ProtoMessage() {}

func (x *ConversationTurn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationTurn.ProtoReflect.Descriptor instead.
func (*ConversationTurn) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{3}
}

func (x *ConversationTurn) GetUserInput() *ConversationTurn_UserInput {
	if x != nil {
		return x.UserInput
	}
	return nil
}

func (x *ConversationTurn) GetVirtualAgentOutput() *ConversationTurn_VirtualAgentOutput {
	if x != nil {
		return x.VirtualAgentOutput
	}
	return nil
}

// The description of differences between original and replayed agent output.
type TestRunDifference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of diff.
	Type TestRunDifference_DiffType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.dialogflow.cx.v3beta1.TestRunDifference_DiffType" json:"type,omitempty"`
	// A description of the diff, showing the actual output vs expected output.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *TestRunDifference) Reset() {
	*x = TestRunDifference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestRunDifference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestRunDifference) ProtoMessage() {}

func (x *TestRunDifference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestRunDifference.ProtoReflect.Descriptor instead.
func (*TestRunDifference) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{4}
}

func (x *TestRunDifference) GetType() TestRunDifference_DiffType {
	if x != nil {
		return x.Type
	}
	return TestRunDifference_DIFF_TYPE_UNSPECIFIED
}

func (x *TestRunDifference) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Transition coverage represents the percentage of all possible page
// transitions (page-level transition routes and event handlers, excluding
// transition route groups) present within any of a parent's test cases.
type TransitionCoverage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Transitions present in the agent.
	Transitions []*TransitionCoverage_Transition `protobuf:"bytes,1,rep,name=transitions,proto3" json:"transitions,omitempty"`
	// The percent of transitions in the agent that are covered.
	CoverageScore float32 `protobuf:"fixed32,2,opt,name=coverage_score,json=coverageScore,proto3" json:"coverage_score,omitempty"`
}

func (x *TransitionCoverage) Reset() {
	*x = TransitionCoverage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionCoverage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionCoverage) ProtoMessage() {}

func (x *TransitionCoverage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionCoverage.ProtoReflect.Descriptor instead.
func (*TransitionCoverage) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{5}
}

func (x *TransitionCoverage) GetTransitions() []*TransitionCoverage_Transition {
	if x != nil {
		return x.Transitions
	}
	return nil
}

func (x *TransitionCoverage) GetCoverageScore() float32 {
	if x != nil {
		return x.CoverageScore
	}
	return 0
}

// Transition route group coverage represents the percentage of all possible
// transition routes present within any of a parent's test cases. The results
// are grouped by the transition route group.
type TransitionRouteGroupCoverage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transition route group coverages.
	Coverages []*TransitionRouteGroupCoverage_Coverage `protobuf:"bytes,1,rep,name=coverages,proto3" json:"coverages,omitempty"`
	// The percent of transition routes in all the transition route groups that
	// are covered.
	CoverageScore float32 `protobuf:"fixed32,2,opt,name=coverage_score,json=coverageScore,proto3" json:"coverage_score,omitempty"`
}

func (x *TransitionRouteGroupCoverage) Reset() {
	*x = TransitionRouteGroupCoverage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionRouteGroupCoverage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionRouteGroupCoverage) ProtoMessage() {}

func (x *TransitionRouteGroupCoverage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionRouteGroupCoverage.ProtoReflect.Descriptor instead.
func (*TransitionRouteGroupCoverage) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{6}
}

func (x *TransitionRouteGroupCoverage) GetCoverages() []*TransitionRouteGroupCoverage_Coverage {
	if x != nil {
		return x.Coverages
	}
	return nil
}

func (x *TransitionRouteGroupCoverage) GetCoverageScore() float32 {
	if x != nil {
		return x.CoverageScore
	}
	return 0
}

// Intent coverage represents the percentage of all possible intents in the
// agent that are triggered in any of a parent's test cases.
type IntentCoverage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Intents present in the agent
	Intents []*IntentCoverage_Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	// The percent of intents in the agent that are covered.
	CoverageScore float32 `protobuf:"fixed32,2,opt,name=coverage_score,json=coverageScore,proto3" json:"coverage_score,omitempty"`
}

func (x *IntentCoverage) Reset() {
	*x = IntentCoverage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentCoverage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentCoverage) ProtoMessage() {}

func (x *IntentCoverage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentCoverage.ProtoReflect.Descriptor instead.
func (*IntentCoverage) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{7}
}

func (x *IntentCoverage) GetIntents() []*IntentCoverage_Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (x *IntentCoverage) GetCoverageScore() float32 {
	if x != nil {
		return x.CoverageScore
	}
	return 0
}

// The request message for [TestCases.CalculateCoverage][google.cloud.dialogflow.cx.v3beta1.TestCases.CalculateCoverage].
type CalculateCoverageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to calculate coverage for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Agent string `protobuf:"bytes,3,opt,name=agent,proto3" json:"agent,omitempty"`
	// Required. The type of coverage requested.
	Type CalculateCoverageRequest_CoverageType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest_CoverageType" json:"type,omitempty"`
}

func (x *CalculateCoverageRequest) Reset() {
	*x = CalculateCoverageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateCoverageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateCoverageRequest) ProtoMessage() {}

func (x *CalculateCoverageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateCoverageRequest.ProtoReflect.Descriptor instead.
func (*CalculateCoverageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{8}
}

func (x *CalculateCoverageRequest) GetAgent() string {
	if x != nil {
		return x.Agent
	}
	return ""
}

func (x *CalculateCoverageRequest) GetType() CalculateCoverageRequest_CoverageType {
	if x != nil {
		return x.Type
	}
	return CalculateCoverageRequest_COVERAGE_TYPE_UNSPECIFIED
}

// The response message for [TestCases.CalculateCoverage][google.cloud.dialogflow.cx.v3beta1.TestCases.CalculateCoverage].
type CalculateCoverageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The agent to calculate coverage for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Agent string `protobuf:"bytes,5,opt,name=agent,proto3" json:"agent,omitempty"`
	// The type of coverage requested.
	//
	// Types that are assignable to CoverageType:
	//	*CalculateCoverageResponse_IntentCoverage
	//	*CalculateCoverageResponse_TransitionCoverage
	//	*CalculateCoverageResponse_RouteGroupCoverage
	CoverageType isCalculateCoverageResponse_CoverageType `protobuf_oneof:"coverage_type"`
}

func (x *CalculateCoverageResponse) Reset() {
	*x = CalculateCoverageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalculateCoverageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalculateCoverageResponse) ProtoMessage() {}

func (x *CalculateCoverageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalculateCoverageResponse.ProtoReflect.Descriptor instead.
func (*CalculateCoverageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{9}
}

func (x *CalculateCoverageResponse) GetAgent() string {
	if x != nil {
		return x.Agent
	}
	return ""
}

func (m *CalculateCoverageResponse) GetCoverageType() isCalculateCoverageResponse_CoverageType {
	if m != nil {
		return m.CoverageType
	}
	return nil
}

func (x *CalculateCoverageResponse) GetIntentCoverage() *IntentCoverage {
	if x, ok := x.GetCoverageType().(*CalculateCoverageResponse_IntentCoverage); ok {
		return x.IntentCoverage
	}
	return nil
}

func (x *CalculateCoverageResponse) GetTransitionCoverage() *TransitionCoverage {
	if x, ok := x.GetCoverageType().(*CalculateCoverageResponse_TransitionCoverage); ok {
		return x.TransitionCoverage
	}
	return nil
}

func (x *CalculateCoverageResponse) GetRouteGroupCoverage() *TransitionRouteGroupCoverage {
	if x, ok := x.GetCoverageType().(*CalculateCoverageResponse_RouteGroupCoverage); ok {
		return x.RouteGroupCoverage
	}
	return nil
}

type isCalculateCoverageResponse_CoverageType interface {
	isCalculateCoverageResponse_CoverageType()
}

type CalculateCoverageResponse_IntentCoverage struct {
	// Intent coverage.
	IntentCoverage *IntentCoverage `protobuf:"bytes,2,opt,name=intent_coverage,json=intentCoverage,proto3,oneof"`
}

type CalculateCoverageResponse_TransitionCoverage struct {
	// Transition (excluding transition route groups) coverage.
	TransitionCoverage *TransitionCoverage `protobuf:"bytes,4,opt,name=transition_coverage,json=transitionCoverage,proto3,oneof"`
}

type CalculateCoverageResponse_RouteGroupCoverage struct {
	// Transition route group coverage.
	RouteGroupCoverage *TransitionRouteGroupCoverage `protobuf:"bytes,6,opt,name=route_group_coverage,json=routeGroupCoverage,proto3,oneof"`
}

func (*CalculateCoverageResponse_IntentCoverage) isCalculateCoverageResponse_CoverageType() {}

func (*CalculateCoverageResponse_TransitionCoverage) isCalculateCoverageResponse_CoverageType() {}

func (*CalculateCoverageResponse_RouteGroupCoverage) isCalculateCoverageResponse_CoverageType() {}

// The request message for [TestCases.ListTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCases].
type ListTestCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all pages for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 20.
	// Note that when TestCaseView = FULL, the maximum page size allowed is 20.
	// When TestCaseView = BASIC, the maximum page size allowed is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies whether response should include all fields or just the metadata.
	View ListTestCasesRequest_TestCaseView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest_TestCaseView" json:"view,omitempty"`
}

func (x *ListTestCasesRequest) Reset() {
	*x = ListTestCasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTestCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTestCasesRequest) ProtoMessage() {}

func (x *ListTestCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTestCasesRequest.ProtoReflect.Descriptor instead.
func (*ListTestCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{10}
}

func (x *ListTestCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTestCasesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTestCasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTestCasesRequest) GetView() ListTestCasesRequest_TestCaseView {
	if x != nil {
		return x.View
	}
	return ListTestCasesRequest_TEST_CASE_VIEW_UNSPECIFIED
}

// The response message for [TestCases.ListTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCases].
type ListTestCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of test cases. There will be a maximum number of items returned
	// based on the page_size field in the request.
	TestCases []*TestCase `protobuf:"bytes,1,rep,name=test_cases,json=testCases,proto3" json:"test_cases,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTestCasesResponse) Reset() {
	*x = ListTestCasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTestCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTestCasesResponse) ProtoMessage() {}

func (x *ListTestCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTestCasesResponse.ProtoReflect.Descriptor instead.
func (*ListTestCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{11}
}

func (x *ListTestCasesResponse) GetTestCases() []*TestCase {
	if x != nil {
		return x.TestCases
	}
	return nil
}

func (x *ListTestCasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for [TestCases.BatchDeleteTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.BatchDeleteTestCases].
type BatchDeleteTestCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to delete test cases from.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Format of test case names: `projects/<Project ID>/locations/
	// <Location ID>/agents/<AgentID>/testCases/<TestCase ID>`.
	Names []string `protobuf:"bytes,3,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchDeleteTestCasesRequest) Reset() {
	*x = BatchDeleteTestCasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteTestCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteTestCasesRequest) ProtoMessage() {}

func (x *BatchDeleteTestCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteTestCasesRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteTestCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{12}
}

func (x *BatchDeleteTestCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteTestCasesRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// The request message for [TestCases.CreateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase].
type CreateTestCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create the test case for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The test case to create.
	TestCase *TestCase `protobuf:"bytes,2,opt,name=test_case,json=testCase,proto3" json:"test_case,omitempty"`
}

func (x *CreateTestCaseRequest) Reset() {
	*x = CreateTestCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTestCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTestCaseRequest) ProtoMessage() {}

func (x *CreateTestCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTestCaseRequest.ProtoReflect.Descriptor instead.
func (*CreateTestCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{13}
}

func (x *CreateTestCaseRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTestCaseRequest) GetTestCase() *TestCase {
	if x != nil {
		return x.TestCase
	}
	return nil
}

// The request message for [TestCases.UpdateTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.UpdateTestCase].
type UpdateTestCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The test case to update.
	TestCase *TestCase `protobuf:"bytes,1,opt,name=test_case,json=testCase,proto3" json:"test_case,omitempty"`
	// Required. The mask to specify which fields should be updated. The
	// [`creationTime`][google.cloud.dialogflow.cx.v3beta1.TestCase.creation_time] and
	// [`lastTestResult`][google.cloud.dialogflow.cx.v3beta1.TestCase.last_test_result] cannot be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTestCaseRequest) Reset() {
	*x = UpdateTestCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTestCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTestCaseRequest) ProtoMessage() {}

func (x *UpdateTestCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTestCaseRequest.ProtoReflect.Descriptor instead.
func (*UpdateTestCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateTestCaseRequest) GetTestCase() *TestCase {
	if x != nil {
		return x.TestCase
	}
	return nil
}

func (x *UpdateTestCaseRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for [TestCases.GetTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.GetTestCase].
type GetTestCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the testcase.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/testCases/<TestCase ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTestCaseRequest) Reset() {
	*x = GetTestCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTestCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTestCaseRequest) ProtoMessage() {}

func (x *GetTestCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTestCaseRequest.ProtoReflect.Descriptor instead.
func (*GetTestCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{15}
}

func (x *GetTestCaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for [TestCases.RunTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.RunTestCase].
type RunTestCaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format of test case name to run: `projects/<Project ID>/locations/
	// <Location ID>/agents/<AgentID>/testCases/<TestCase ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Environment name. If not set, draft environment is assumed.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>`.
	Environment string `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
}

func (x *RunTestCaseRequest) Reset() {
	*x = RunTestCaseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunTestCaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunTestCaseRequest) ProtoMessage() {}

func (x *RunTestCaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunTestCaseRequest.ProtoReflect.Descriptor instead.
func (*RunTestCaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{16}
}

func (x *RunTestCaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RunTestCaseRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

// The response message for [TestCases.RunTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.RunTestCase].
type RunTestCaseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result.
	Result *TestCaseResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *RunTestCaseResponse) Reset() {
	*x = RunTestCaseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunTestCaseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunTestCaseResponse) ProtoMessage() {}

func (x *RunTestCaseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunTestCaseResponse.ProtoReflect.Descriptor instead.
func (*RunTestCaseResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{17}
}

func (x *RunTestCaseResponse) GetResult() *TestCaseResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// Metadata returned for the [TestCases.RunTestCase][google.cloud.dialogflow.cx.v3beta1.TestCases.RunTestCase] long running operation.
type RunTestCaseMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RunTestCaseMetadata) Reset() {
	*x = RunTestCaseMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunTestCaseMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunTestCaseMetadata) ProtoMessage() {}

func (x *RunTestCaseMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunTestCaseMetadata.ProtoReflect.Descriptor instead.
func (*RunTestCaseMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{18}
}

// The request message for [TestCases.BatchRunTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.BatchRunTestCases].
type BatchRunTestCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Agent name. Format: `projects/<Project ID>/locations/<Location ID>/agents/
	// <AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If not set, draft environment is assumed. Format: `projects/<Project
	// ID>/locations/<Location ID>/agents/<Agent ID>/environments/<Environment
	// ID>`.
	Environment string `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
	// Required. Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/testCases/<TestCase ID>`.
	TestCases []string `protobuf:"bytes,3,rep,name=test_cases,json=testCases,proto3" json:"test_cases,omitempty"`
}

func (x *BatchRunTestCasesRequest) Reset() {
	*x = BatchRunTestCasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunTestCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunTestCasesRequest) ProtoMessage() {}

func (x *BatchRunTestCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunTestCasesRequest.ProtoReflect.Descriptor instead.
func (*BatchRunTestCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{19}
}

func (x *BatchRunTestCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchRunTestCasesRequest) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *BatchRunTestCasesRequest) GetTestCases() []string {
	if x != nil {
		return x.TestCases
	}
	return nil
}

// The response message for [TestCases.BatchRunTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.BatchRunTestCases].
type BatchRunTestCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The test case results. The detailed
	// [conversation turns][google.cloud.dialogflow.cx.v3beta1.TestCaseResult.conversation_turns] are empty in this
	// response.
	Results []*TestCaseResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *BatchRunTestCasesResponse) Reset() {
	*x = BatchRunTestCasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunTestCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunTestCasesResponse) ProtoMessage() {}

func (x *BatchRunTestCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunTestCasesResponse.ProtoReflect.Descriptor instead.
func (*BatchRunTestCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{20}
}

func (x *BatchRunTestCasesResponse) GetResults() []*TestCaseResult {
	if x != nil {
		return x.Results
	}
	return nil
}

// Metadata returned for the [TestCases.BatchRunTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.BatchRunTestCases] long running
// operation.
type BatchRunTestCasesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The test errors.
	Errors []*TestError `protobuf:"bytes,1,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *BatchRunTestCasesMetadata) Reset() {
	*x = BatchRunTestCasesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunTestCasesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunTestCasesMetadata) ProtoMessage() {}

func (x *BatchRunTestCasesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunTestCasesMetadata.ProtoReflect.Descriptor instead.
func (*BatchRunTestCasesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{21}
}

func (x *BatchRunTestCasesMetadata) GetErrors() []*TestError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Error info for running a test.
type TestError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The test case resource name.
	TestCase string `protobuf:"bytes,1,opt,name=test_case,json=testCase,proto3" json:"test_case,omitempty"`
	// The status associated with the test.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// The timestamp when the test was completed.
	TestTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=test_time,json=testTime,proto3" json:"test_time,omitempty"`
}

func (x *TestError) Reset() {
	*x = TestError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestError) ProtoMessage() {}

func (x *TestError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestError.ProtoReflect.Descriptor instead.
func (*TestError) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{22}
}

func (x *TestError) GetTestCase() string {
	if x != nil {
		return x.TestCase
	}
	return ""
}

func (x *TestError) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TestError) GetTestTime() *timestamppb.Timestamp {
	if x != nil {
		return x.TestTime
	}
	return nil
}

// The request message for [TestCases.ImportTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ImportTestCases].
type ImportTestCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to import test cases to.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source to import.
	//
	// Types that are assignable to Source:
	//	*ImportTestCasesRequest_GcsUri
	//	*ImportTestCasesRequest_Content
	Source isImportTestCasesRequest_Source `protobuf_oneof:"source"`
}

func (x *ImportTestCasesRequest) Reset() {
	*x = ImportTestCasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTestCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTestCasesRequest) ProtoMessage() {}

func (x *ImportTestCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTestCasesRequest.ProtoReflect.Descriptor instead.
func (*ImportTestCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{23}
}

func (x *ImportTestCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportTestCasesRequest) GetSource() isImportTestCasesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportTestCasesRequest) GetGcsUri() string {
	if x, ok := x.GetSource().(*ImportTestCasesRequest_GcsUri); ok {
		return x.GcsUri
	}
	return ""
}

func (x *ImportTestCasesRequest) GetContent() []byte {
	if x, ok := x.GetSource().(*ImportTestCasesRequest_Content); ok {
		return x.Content
	}
	return nil
}

type isImportTestCasesRequest_Source interface {
	isImportTestCasesRequest_Source()
}

type ImportTestCasesRequest_GcsUri struct {
	// The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
	// to import test cases from. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	GcsUri string `protobuf:"bytes,2,opt,name=gcs_uri,json=gcsUri,proto3,oneof"`
}

type ImportTestCasesRequest_Content struct {
	// Uncompressed raw byte content for test cases.
	Content []byte `protobuf:"bytes,3,opt,name=content,proto3,oneof"`
}

func (*ImportTestCasesRequest_GcsUri) isImportTestCasesRequest_Source() {}

func (*ImportTestCasesRequest_Content) isImportTestCasesRequest_Source() {}

// The response message for [TestCases.ImportTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ImportTestCases].
type ImportTestCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifiers of the new test cases.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/testCases/<TestCase ID>`.
	Names []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *ImportTestCasesResponse) Reset() {
	*x = ImportTestCasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTestCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTestCasesResponse) ProtoMessage() {}

func (x *ImportTestCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTestCasesResponse.ProtoReflect.Descriptor instead.
func (*ImportTestCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{24}
}

func (x *ImportTestCasesResponse) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// Metadata returned for the [TestCases.ImportTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ImportTestCases] long running
// operation.
type ImportTestCasesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Errors for failed test cases.
	Errors []*TestCaseError `protobuf:"bytes,1,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *ImportTestCasesMetadata) Reset() {
	*x = ImportTestCasesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportTestCasesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportTestCasesMetadata) ProtoMessage() {}

func (x *ImportTestCasesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportTestCasesMetadata.ProtoReflect.Descriptor instead.
func (*ImportTestCasesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{25}
}

func (x *ImportTestCasesMetadata) GetErrors() []*TestCaseError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Error info for importing a test.
type TestCaseError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The test case.
	TestCase *TestCase `protobuf:"bytes,1,opt,name=test_case,json=testCase,proto3" json:"test_case,omitempty"`
	// The status associated with the test case.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *TestCaseError) Reset() {
	*x = TestCaseError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestCaseError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestCaseError) ProtoMessage() {}

func (x *TestCaseError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestCaseError.ProtoReflect.Descriptor instead.
func (*TestCaseError) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{26}
}

func (x *TestCaseError) GetTestCase() *TestCase {
	if x != nil {
		return x.TestCase
	}
	return nil
}

func (x *TestCaseError) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// The request message for [TestCases.ExportTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ExportTestCases].
type ExportTestCasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent where to export test cases from.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The destination to export.
	//
	// Types that are assignable to Destination:
	//	*ExportTestCasesRequest_GcsUri
	Destination isExportTestCasesRequest_Destination `protobuf_oneof:"destination"`
	// The data format of the exported test cases. If not specified, `BLOB` is
	// assumed.
	DataFormat ExportTestCasesRequest_DataFormat `protobuf:"varint,3,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest_DataFormat" json:"data_format,omitempty"`
	// The filter expression used to filter exported test cases, see
	// [API Filtering](https://aip.dev/160). The expression is case insensitive
	// and supports the following syntax:
	//
	//   name = <value> [OR name = <value>] ...
	//
	// For example:
	//
	// *   "name = t1 OR name = t2" matches the test case with the exact resource
	//     name "t1" or "t2".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ExportTestCasesRequest) Reset() {
	*x = ExportTestCasesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTestCasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTestCasesRequest) ProtoMessage() {}

func (x *ExportTestCasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTestCasesRequest.ProtoReflect.Descriptor instead.
func (*ExportTestCasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{27}
}

func (x *ExportTestCasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ExportTestCasesRequest) GetDestination() isExportTestCasesRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportTestCasesRequest) GetGcsUri() string {
	if x, ok := x.GetDestination().(*ExportTestCasesRequest_GcsUri); ok {
		return x.GcsUri
	}
	return ""
}

func (x *ExportTestCasesRequest) GetDataFormat() ExportTestCasesRequest_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExportTestCasesRequest_DATA_FORMAT_UNSPECIFIED
}

func (x *ExportTestCasesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type isExportTestCasesRequest_Destination interface {
	isExportTestCasesRequest_Destination()
}

type ExportTestCasesRequest_GcsUri struct {
	// The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI to
	// export the test cases to. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`. If unspecified, the serialized test
	// cases is returned inline.
	GcsUri string `protobuf:"bytes,2,opt,name=gcs_uri,json=gcsUri,proto3,oneof"`
}

func (*ExportTestCasesRequest_GcsUri) isExportTestCasesRequest_Destination() {}

// The response message for [TestCases.ExportTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ExportTestCases].
type ExportTestCasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported test cases.
	//
	// Types that are assignable to Destination:
	//	*ExportTestCasesResponse_GcsUri
	//	*ExportTestCasesResponse_Content
	Destination isExportTestCasesResponse_Destination `protobuf_oneof:"destination"`
}

func (x *ExportTestCasesResponse) Reset() {
	*x = ExportTestCasesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTestCasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTestCasesResponse) ProtoMessage() {}

func (x *ExportTestCasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTestCasesResponse.ProtoReflect.Descriptor instead.
func (*ExportTestCasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{28}
}

func (m *ExportTestCasesResponse) GetDestination() isExportTestCasesResponse_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportTestCasesResponse) GetGcsUri() string {
	if x, ok := x.GetDestination().(*ExportTestCasesResponse_GcsUri); ok {
		return x.GcsUri
	}
	return ""
}

func (x *ExportTestCasesResponse) GetContent() []byte {
	if x, ok := x.GetDestination().(*ExportTestCasesResponse_Content); ok {
		return x.Content
	}
	return nil
}

type isExportTestCasesResponse_Destination interface {
	isExportTestCasesResponse_Destination()
}

type ExportTestCasesResponse_GcsUri struct {
	// The URI to a file containing the exported test cases. This field is
	// populated only if `gcs_uri` is specified in
	// [ExportTestCasesRequest][google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest].
	GcsUri string `protobuf:"bytes,1,opt,name=gcs_uri,json=gcsUri,proto3,oneof"`
}

type ExportTestCasesResponse_Content struct {
	// Uncompressed raw byte content for test cases.
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*ExportTestCasesResponse_GcsUri) isExportTestCasesResponse_Destination() {}

func (*ExportTestCasesResponse_Content) isExportTestCasesResponse_Destination() {}

// Metadata returned for the [TestCases.ExportTestCases][google.cloud.dialogflow.cx.v3beta1.TestCases.ExportTestCases] long running
// operation.
type ExportTestCasesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportTestCasesMetadata) Reset() {
	*x = ExportTestCasesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportTestCasesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportTestCasesMetadata) ProtoMessage() {}

func (x *ExportTestCasesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportTestCasesMetadata.ProtoReflect.Descriptor instead.
func (*ExportTestCasesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{29}
}

// The request message for [TestCases.ListTestCaseResults][google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCaseResults].
type ListTestCaseResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The test case to list results for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/
	// testCases/<TestCase ID>`. Specify a `-` as a wildcard for TestCase ID to
	// list results across multiple test cases.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter expression used to filter test case results. See
	// [API Filtering](https://aip.dev/160).
	//
	// The expression is case insensitive. Only 'AND' is supported for logical
	// operators. The supported syntax is listed below in detail:
	//
	//   <field> <operator> <value> [AND <field> <operator> <value>] ...
	//   [AND latest]
	//
	// The supported fields and operators are:
	// field                 operator
	// `environment`         `=`, `IN`  (Use value `draft` for draft environment)
	// `test_time`           `>`, `<`
	//
	// `latest` only returns the latest test result in all results for each test
	// case.
	//
	// Examples:
	// *   "environment=draft AND latest" matches the latest test result for each
	//     test case in the draft environment.
	// *   "environment IN (e1,e2)" matches any test case results with an
	//     environment resource name of either "e1" or "e2".
	// *   "test_time > 1602540713" matches any test case results with test time
	//     later than a unix timestamp in seconds 1602540713.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListTestCaseResultsRequest) Reset() {
	*x = ListTestCaseResultsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTestCaseResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTestCaseResultsRequest) ProtoMessage() {}

func (x *ListTestCaseResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTestCaseResultsRequest.ProtoReflect.Descriptor instead.
func (*ListTestCaseResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{30}
}

func (x *ListTestCaseResultsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTestCaseResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTestCaseResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTestCaseResultsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response message for [TestCases.ListTestCaseResults][google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCaseResults].
type ListTestCaseResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of test case results.
	TestCaseResults []*TestCaseResult `protobuf:"bytes,1,rep,name=test_case_results,json=testCaseResults,proto3" json:"test_case_results,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTestCaseResultsResponse) Reset() {
	*x = ListTestCaseResultsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTestCaseResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTestCaseResultsResponse) ProtoMessage() {}

func (x *ListTestCaseResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTestCaseResultsResponse.ProtoReflect.Descriptor instead.
func (*ListTestCaseResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{31}
}

func (x *ListTestCaseResultsResponse) GetTestCaseResults() []*TestCaseResult {
	if x != nil {
		return x.TestCaseResults
	}
	return nil
}

func (x *ListTestCaseResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for [TestCases.GetTestCaseResult][google.cloud.dialogflow.cx.v3beta1.TestCases.GetTestCaseResult].
type GetTestCaseResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the testcase.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/testCases/<TestCase ID>/results/<TestCaseResult ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTestCaseResultRequest) Reset() {
	*x = GetTestCaseResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTestCaseResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTestCaseResultRequest) ProtoMessage() {}

func (x *GetTestCaseResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTestCaseResultRequest.ProtoReflect.Descriptor instead.
func (*GetTestCaseResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{32}
}

func (x *GetTestCaseResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The input from the human user.
type ConversationTurn_UserInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Supports [text input][google.cloud.dialogflow.cx.v3beta1.QueryInput.text], [event input][google.cloud.dialogflow.cx.v3beta1.QueryInput.event],
	// [dtmf input][google.cloud.dialogflow.cx.v3beta1.QueryInput.dtmf] in the test case.
	Input *QueryInput `protobuf:"bytes,5,opt,name=input,proto3" json:"input,omitempty"`
	// Parameters that need to be injected into the conversation during intent
	// detection.
	InjectedParameters *structpb.Struct `protobuf:"bytes,2,opt,name=injected_parameters,json=injectedParameters,proto3" json:"injected_parameters,omitempty"`
	// If webhooks should be allowed to trigger in response to the user
	// utterance. Often if parameters are injected, webhooks should not be
	// enabled.
	IsWebhookEnabled bool `protobuf:"varint,3,opt,name=is_webhook_enabled,json=isWebhookEnabled,proto3" json:"is_webhook_enabled,omitempty"`
	// Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `protobuf:"varint,7,opt,name=enable_sentiment_analysis,json=enableSentimentAnalysis,proto3" json:"enable_sentiment_analysis,omitempty"`
}

func (x *ConversationTurn_UserInput) Reset() {
	*x = ConversationTurn_UserInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationTurn_UserInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationTurn_UserInput) ProtoMessage() {}

func (x *ConversationTurn_UserInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationTurn_UserInput.ProtoReflect.Descriptor instead.
func (*ConversationTurn_UserInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ConversationTurn_UserInput) GetInput() *QueryInput {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *ConversationTurn_UserInput) GetInjectedParameters() *structpb.Struct {
	if x != nil {
		return x.InjectedParameters
	}
	return nil
}

func (x *ConversationTurn_UserInput) GetIsWebhookEnabled() bool {
	if x != nil {
		return x.IsWebhookEnabled
	}
	return false
}

func (x *ConversationTurn_UserInput) GetEnableSentimentAnalysis() bool {
	if x != nil {
		return x.EnableSentimentAnalysis
	}
	return false
}

// The output from the virtual agent.
type ConversationTurn_VirtualAgentOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The session parameters available to the bot at this point.
	SessionParameters *structpb.Struct `protobuf:"bytes,4,opt,name=session_parameters,json=sessionParameters,proto3" json:"session_parameters,omitempty"`
	// Output only. If this is part of a [result conversation
	// turn][TestCaseResult.conversation_turns], the list of differences
	// between the original run and the replay for this output, if any.
	Differences []*TestRunDifference `protobuf:"bytes,5,rep,name=differences,proto3" json:"differences,omitempty"`
	// Required. Input only. The diagnostic
	// [info][Session.DetectIntentResponse.QueryResult.diagnostic_info]
	// output for the turn.
	DiagnosticInfo *structpb.Struct `protobuf:"bytes,6,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] that triggered the response. Only name and displayName
	// will be set.
	TriggeredIntent *Intent `protobuf:"bytes,7,opt,name=triggered_intent,json=triggeredIntent,proto3" json:"triggered_intent,omitempty"`
	// The [Page][google.cloud.dialogflow.cx.v3beta1.Page] on which the utterance was spoken. Only name and displayName
	// will be set.
	CurrentPage *Page `protobuf:"bytes,8,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
	// The [text][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text] responses from the agent for the turn.
	TextResponses []*ResponseMessage_Text `protobuf:"bytes,9,rep,name=text_responses,json=textResponses,proto3" json:"text_responses,omitempty"`
	// Response error from the agent in the test result. If set, other output
	// is empty.
	Status *status.Status `protobuf:"bytes,10,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ConversationTurn_VirtualAgentOutput) Reset() {
	*x = ConversationTurn_VirtualAgentOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationTurn_VirtualAgentOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationTurn_VirtualAgentOutput) ProtoMessage() {}

func (x *ConversationTurn_VirtualAgentOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationTurn_VirtualAgentOutput.ProtoReflect.Descriptor instead.
func (*ConversationTurn_VirtualAgentOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{3, 1}
}

func (x *ConversationTurn_VirtualAgentOutput) GetSessionParameters() *structpb.Struct {
	if x != nil {
		return x.SessionParameters
	}
	return nil
}

func (x *ConversationTurn_VirtualAgentOutput) GetDifferences() []*TestRunDifference {
	if x != nil {
		return x.Differences
	}
	return nil
}

func (x *ConversationTurn_VirtualAgentOutput) GetDiagnosticInfo() *structpb.Struct {
	if x != nil {
		return x.DiagnosticInfo
	}
	return nil
}

func (x *ConversationTurn_VirtualAgentOutput) GetTriggeredIntent() *Intent {
	if x != nil {
		return x.TriggeredIntent
	}
	return nil
}

func (x *ConversationTurn_VirtualAgentOutput) GetCurrentPage() *Page {
	if x != nil {
		return x.CurrentPage
	}
	return nil
}

func (x *ConversationTurn_VirtualAgentOutput) GetTextResponses() []*ResponseMessage_Text {
	if x != nil {
		return x.TextResponses
	}
	return nil
}

func (x *ConversationTurn_VirtualAgentOutput) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// The source or target of a transition.
type TransitionCoverage_TransitionNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A TransitionNode can be either a page or a flow.
	//
	// Types that are assignable to Kind:
	//	*TransitionCoverage_TransitionNode_Page
	//	*TransitionCoverage_TransitionNode_Flow
	Kind isTransitionCoverage_TransitionNode_Kind `protobuf_oneof:"kind"`
}

func (x *TransitionCoverage_TransitionNode) Reset() {
	*x = TransitionCoverage_TransitionNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionCoverage_TransitionNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionCoverage_TransitionNode) ProtoMessage() {}

func (x *TransitionCoverage_TransitionNode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionCoverage_TransitionNode.ProtoReflect.Descriptor instead.
func (*TransitionCoverage_TransitionNode) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{5, 0}
}

func (m *TransitionCoverage_TransitionNode) GetKind() isTransitionCoverage_TransitionNode_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *TransitionCoverage_TransitionNode) GetPage() *Page {
	if x, ok := x.GetKind().(*TransitionCoverage_TransitionNode_Page); ok {
		return x.Page
	}
	return nil
}

func (x *TransitionCoverage_TransitionNode) GetFlow() *Flow {
	if x, ok := x.GetKind().(*TransitionCoverage_TransitionNode_Flow); ok {
		return x.Flow
	}
	return nil
}

type isTransitionCoverage_TransitionNode_Kind interface {
	isTransitionCoverage_TransitionNode_Kind()
}

type TransitionCoverage_TransitionNode_Page struct {
	// Indicates a transition to a [Page][google.cloud.dialogflow.cx.v3beta1.Page]. Only some fields such as name and
	// displayname will be set.
	Page *Page `protobuf:"bytes,1,opt,name=page,proto3,oneof"`
}

type TransitionCoverage_TransitionNode_Flow struct {
	// Indicates a transition to a [Flow][google.cloud.dialogflow.cx.v3beta1.Flow]. Only some fields such as name and
	// displayname will be set.
	Flow *Flow `protobuf:"bytes,2,opt,name=flow,proto3,oneof"`
}

func (*TransitionCoverage_TransitionNode_Page) isTransitionCoverage_TransitionNode_Kind() {}

func (*TransitionCoverage_TransitionNode_Flow) isTransitionCoverage_TransitionNode_Kind() {}

// A transition in a page.
type TransitionCoverage_Transition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start node of a transition.
	Source *TransitionCoverage_TransitionNode `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The index of a transition in the transition list. Starting from 0.
	Index int32 `protobuf:"varint,4,opt,name=index,proto3" json:"index,omitempty"`
	// The end node of a transition.
	Target *TransitionCoverage_TransitionNode `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// Whether or not the transition is covered by at least one of the
	// agent's test cases.
	Covered bool `protobuf:"varint,3,opt,name=covered,proto3" json:"covered,omitempty"`
	// The detailed transition.
	//
	// Types that are assignable to Detail:
	//	*TransitionCoverage_Transition_TransitionRoute
	//	*TransitionCoverage_Transition_EventHandler
	Detail isTransitionCoverage_Transition_Detail `protobuf_oneof:"detail"`
}

func (x *TransitionCoverage_Transition) Reset() {
	*x = TransitionCoverage_Transition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionCoverage_Transition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionCoverage_Transition) ProtoMessage() {}

func (x *TransitionCoverage_Transition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionCoverage_Transition.ProtoReflect.Descriptor instead.
func (*TransitionCoverage_Transition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{5, 1}
}

func (x *TransitionCoverage_Transition) GetSource() *TransitionCoverage_TransitionNode {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *TransitionCoverage_Transition) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *TransitionCoverage_Transition) GetTarget() *TransitionCoverage_TransitionNode {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *TransitionCoverage_Transition) GetCovered() bool {
	if x != nil {
		return x.Covered
	}
	return false
}

func (m *TransitionCoverage_Transition) GetDetail() isTransitionCoverage_Transition_Detail {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (x *TransitionCoverage_Transition) GetTransitionRoute() *TransitionRoute {
	if x, ok := x.GetDetail().(*TransitionCoverage_Transition_TransitionRoute); ok {
		return x.TransitionRoute
	}
	return nil
}

func (x *TransitionCoverage_Transition) GetEventHandler() *EventHandler {
	if x, ok := x.GetDetail().(*TransitionCoverage_Transition_EventHandler); ok {
		return x.EventHandler
	}
	return nil
}

type isTransitionCoverage_Transition_Detail interface {
	isTransitionCoverage_Transition_Detail()
}

type TransitionCoverage_Transition_TransitionRoute struct {
	// Intent route or condition route.
	TransitionRoute *TransitionRoute `protobuf:"bytes,5,opt,name=transition_route,json=transitionRoute,proto3,oneof"`
}

type TransitionCoverage_Transition_EventHandler struct {
	// Event handler.
	EventHandler *EventHandler `protobuf:"bytes,6,opt,name=event_handler,json=eventHandler,proto3,oneof"`
}

func (*TransitionCoverage_Transition_TransitionRoute) isTransitionCoverage_Transition_Detail() {}

func (*TransitionCoverage_Transition_EventHandler) isTransitionCoverage_Transition_Detail() {}

// Coverage result message for one transition route group.
type TransitionRouteGroupCoverage_Coverage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transition route group metadata. Only name and displayName will be set.
	RouteGroup *TransitionRouteGroup `protobuf:"bytes,1,opt,name=route_group,json=routeGroup,proto3" json:"route_group,omitempty"`
	// The list of transition routes and coverage in the transition route group.
	Transitions []*TransitionRouteGroupCoverage_Coverage_Transition `protobuf:"bytes,2,rep,name=transitions,proto3" json:"transitions,omitempty"`
	// The percent of transition routes in the transition route group that are
	// covered.
	CoverageScore float32 `protobuf:"fixed32,3,opt,name=coverage_score,json=coverageScore,proto3" json:"coverage_score,omitempty"`
}

func (x *TransitionRouteGroupCoverage_Coverage) Reset() {
	*x = TransitionRouteGroupCoverage_Coverage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionRouteGroupCoverage_Coverage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionRouteGroupCoverage_Coverage) ProtoMessage() {}

func (x *TransitionRouteGroupCoverage_Coverage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionRouteGroupCoverage_Coverage.ProtoReflect.Descriptor instead.
func (*TransitionRouteGroupCoverage_Coverage) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{6, 0}
}

func (x *TransitionRouteGroupCoverage_Coverage) GetRouteGroup() *TransitionRouteGroup {
	if x != nil {
		return x.RouteGroup
	}
	return nil
}

func (x *TransitionRouteGroupCoverage_Coverage) GetTransitions() []*TransitionRouteGroupCoverage_Coverage_Transition {
	if x != nil {
		return x.Transitions
	}
	return nil
}

func (x *TransitionRouteGroupCoverage_Coverage) GetCoverageScore() float32 {
	if x != nil {
		return x.CoverageScore
	}
	return 0
}

// A transition coverage in a transition route group.
type TransitionRouteGroupCoverage_Coverage_Transition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Intent route or condition route.
	TransitionRoute *TransitionRoute `protobuf:"bytes,1,opt,name=transition_route,json=transitionRoute,proto3" json:"transition_route,omitempty"`
	// Whether or not the transition route is covered by at least one of the
	// agent's test cases.
	Covered bool `protobuf:"varint,2,opt,name=covered,proto3" json:"covered,omitempty"`
}

func (x *TransitionRouteGroupCoverage_Coverage_Transition) Reset() {
	*x = TransitionRouteGroupCoverage_Coverage_Transition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionRouteGroupCoverage_Coverage_Transition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionRouteGroupCoverage_Coverage_Transition) ProtoMessage() {}

func (x *TransitionRouteGroupCoverage_Coverage_Transition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionRouteGroupCoverage_Coverage_Transition.ProtoReflect.Descriptor instead.
func (*TransitionRouteGroupCoverage_Coverage_Transition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (x *TransitionRouteGroupCoverage_Coverage_Transition) GetTransitionRoute() *TransitionRoute {
	if x != nil {
		return x.TransitionRoute
	}
	return nil
}

func (x *TransitionRouteGroupCoverage_Coverage_Transition) GetCovered() bool {
	if x != nil {
		return x.Covered
	}
	return false
}

// The agent's intent.
type IntentCoverage_Intent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The intent full resource name
	Intent string `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// Whether or not the intent is covered by at least one of the agent's
	// test cases.
	Covered bool `protobuf:"varint,2,opt,name=covered,proto3" json:"covered,omitempty"`
}

func (x *IntentCoverage_Intent) Reset() {
	*x = IntentCoverage_Intent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentCoverage_Intent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentCoverage_Intent) ProtoMessage() {}

func (x *IntentCoverage_Intent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentCoverage_Intent.ProtoReflect.Descriptor instead.
func (*IntentCoverage_Intent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP(), []int{7, 0}
}

func (x *IntentCoverage_Intent) GetIntent() string {
	if x != nil {
		return x.Intent
	}
	return ""
}

func (x *IntentCoverage_Intent) GetCovered() bool {
	if x != nil {
		return x.Covered
	}
	return false
}

var File_google_cloud_dialogflow_cx_v3beta1_test_case_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x70, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63,
	0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd3, 0x04, 0x0a, 0x08, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x74, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x1c, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x75, 0x72, 0x6e, 0x52, 0x19, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x75, 0x72, 0x6e, 0x73, 0x12,
	0x44, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x4c, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x7d, 0x22, 0xf1, 0x03, 0x0a, 0x0e, 0x54,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x63, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x75, 0x72, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x75, 0x72,
	0x6e, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x75, 0x72, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0a, 0x74, 0x65, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x74, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x8d,
	0x01, 0xea, 0x41, 0x89, 0x01, 0x0a, 0x28, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x5d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x73, 0x2f, 0x7b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x7d, 0x2f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x22, 0x76,
	0x0a, 0x0a, 0x54, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x13,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x37, 0x0a,
	0x04, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77,
	0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x22, 0xac, 0x08, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x75, 0x72, 0x6e, 0x12, 0x5d, 0x0a, 0x0a, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x75, 0x72, 0x6e, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52,
	0x09, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x79, 0x0a, 0x14, 0x76, 0x69,
	0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x75, 0x72, 0x6e, 0x2e, 0x56,
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x12, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x1a, 0x85, 0x02, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x48, 0x0a, 0x13, 0x69, 0x6e, 0x6a,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x12, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x73, 0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x69, 0x73, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x3a, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x1a, 0xb5, 0x04,
	0x0a, 0x12, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x12, 0x46, 0x0a, 0x12, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x11, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x5c, 0x0a, 0x0b,
	0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x44, 0x69,
	0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64,
	0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0f, 0x64, 0x69,
	0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x55, 0x0a, 0x10, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x65,
	0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0c, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52, 0x0b, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x5f, 0x0a, 0x0e, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xe5, 0x01, 0x0a, 0x11, 0x54, 0x65, 0x73, 0x74, 0x52, 0x75,
	0x6e, 0x44, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x44, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x44, 0x69, 0x66, 0x66, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5a, 0x0a, 0x08, 0x44, 0x69, 0x66, 0x66, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a,
	0x15, 0x44, 0x49, 0x46, 0x46, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x54, 0x45,
	0x4e, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x41, 0x47, 0x45, 0x10, 0x02, 0x12, 0x0e,
	0x0a, 0x0a, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x53, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x04, 0x22, 0xfd, 0x05,
	0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x12, 0x63, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x0d, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x1a, 0x98, 0x01, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x6f, 0x64, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x04, 0x70,
	0x61, 0x67, 0x65, 0x12, 0x3e, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x04, 0x66,
	0x6c, 0x6f, 0x77, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0xbf, 0x03, 0x0a, 0x0a,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x64,
	0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x5d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x07, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x0d, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0xbe, 0x04,
	0x0a, 0x1c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x67,
	0x0a, 0x09, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x52, 0x09, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0d, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0x8d,
	0x03, 0x0a, 0x08, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x59, 0x0a, 0x0b, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0a, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x76, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0d, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0x86, 0x01, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x22, 0xef,
	0x01, 0x0a, 0x0e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x12, 0x53, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0d,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0x61, 0x0a,
	0x06, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64,
	0x22, 0xa9, 0x02, 0x0a, 0x18, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a,
	0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x6a, 0x0a, 0x0c, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x50,
	0x41, 0x47, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02,
	0x12, 0x1a, 0x0a, 0x16, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52,
	0x4f, 0x55, 0x54, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0x03, 0x22, 0xa8, 0x03, 0x0a,
	0x19, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52,
	0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x76,
	0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x69, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x12, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x12, 0x74, 0x0a, 0x14, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65,
	0x48, 0x00, 0x52, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xb6, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x59, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x43, 0x0a, 0x0c, 0x54,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a, 0x1a, 0x54,
	0x45, 0x53, 0x54, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42,
	0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02,
	0x22, 0x8c, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0a, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x09, 0x74, 0x65,
	0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa3, 0x01, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x05,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xab, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74,
	0x43, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65,
	0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x54, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x12, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73,
	0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x61, 0x0a,
	0x13, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61,
	0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0x15, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xfa, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x09, 0x74, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x22, 0x69, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x4c, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22,
	0x62, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x45, 0x0a, 0x06,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x09, 0x54, 0x65, 0x73, 0x74, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x44, 0x0a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x08, 0x74,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x08, 0x74, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a,
	0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12,
	0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x07, 0x67,
	0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06,
	0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x58, 0x0a, 0x17,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52,
	0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x49, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x86, 0x01, 0x0a,
	0x0d, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x49,
	0x0a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52,
	0x08, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xc5, 0x02, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12,
	0x66, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0x3d, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a,
	0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c,
	0x4f, 0x42, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x42, 0x0d,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5f, 0x0a,
	0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x67, 0x63, 0x73,
	0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42,
	0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x19,
	0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xba, 0x01, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x12, 0x28, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74,
	0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa5, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63,
	0x61, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x60,
	0x0a, 0x18, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x73, 0x74,
	0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x2a, 0x41, 0x0a, 0x0a, 0x54, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1b,
	0x0a, 0x17, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50,
	0x41, 0x53, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x32, 0xb6, 0x16, 0x0a, 0x09, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x73, 0x12, 0xd2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73,
	0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xcc, 0x01, 0x0a, 0x14, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x5b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c,
	0x22, 0x47, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbf, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73,
	0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdc, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x22, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x22, 0x3b, 0x2f, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63,
	0x61, 0x73, 0x65, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x12, 0xeb, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61,
	0x73, 0x65, 0x22, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x32, 0x45, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x09, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0xda, 0x41, 0x15, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xdd, 0x01, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74,
	0x43, 0x61, 0x73, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73,
	0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x22, 0x3f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x75, 0x6e, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x2a, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x54,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x13, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xfb, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75,
	0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x22, 0x44, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x36, 0x0a, 0x19, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75,
	0x6e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xe6, 0x01, 0x0a, 0x11, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61,
	0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x12, 0x4c, 0x2f,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x3a, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0xf1, 0x01, 0x0a, 0x0f,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x47, 0x22, 0x42, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x32, 0x0a, 0x17, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65,
	0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xf1, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54,
	0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x42, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43,
	0x61, 0x73, 0x65, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41,
	0x32, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xee, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74,
	0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xdb, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74,
	0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65,
	0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x54, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xd5, 0x01, 0x0a,
	0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x63, 0x78, 0xf8, 0x01,
	0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_goTypes = []interface{}{
	(TestResult)(0),                                          // 0: google.cloud.dialogflow.cx.v3beta1.TestResult
	(TestRunDifference_DiffType)(0),                          // 1: google.cloud.dialogflow.cx.v3beta1.TestRunDifference.DiffType
	(CalculateCoverageRequest_CoverageType)(0),               // 2: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest.CoverageType
	(ListTestCasesRequest_TestCaseView)(0),                   // 3: google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest.TestCaseView
	(ExportTestCasesRequest_DataFormat)(0),                   // 4: google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest.DataFormat
	(*TestCase)(nil),                                         // 5: google.cloud.dialogflow.cx.v3beta1.TestCase
	(*TestCaseResult)(nil),                                   // 6: google.cloud.dialogflow.cx.v3beta1.TestCaseResult
	(*TestConfig)(nil),                                       // 7: google.cloud.dialogflow.cx.v3beta1.TestConfig
	(*ConversationTurn)(nil),                                 // 8: google.cloud.dialogflow.cx.v3beta1.ConversationTurn
	(*TestRunDifference)(nil),                                // 9: google.cloud.dialogflow.cx.v3beta1.TestRunDifference
	(*TransitionCoverage)(nil),                               // 10: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage
	(*TransitionRouteGroupCoverage)(nil),                     // 11: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
	(*IntentCoverage)(nil),                                   // 12: google.cloud.dialogflow.cx.v3beta1.IntentCoverage
	(*CalculateCoverageRequest)(nil),                         // 13: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest
	(*CalculateCoverageResponse)(nil),                        // 14: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse
	(*ListTestCasesRequest)(nil),                             // 15: google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest
	(*ListTestCasesResponse)(nil),                            // 16: google.cloud.dialogflow.cx.v3beta1.ListTestCasesResponse
	(*BatchDeleteTestCasesRequest)(nil),                      // 17: google.cloud.dialogflow.cx.v3beta1.BatchDeleteTestCasesRequest
	(*CreateTestCaseRequest)(nil),                            // 18: google.cloud.dialogflow.cx.v3beta1.CreateTestCaseRequest
	(*UpdateTestCaseRequest)(nil),                            // 19: google.cloud.dialogflow.cx.v3beta1.UpdateTestCaseRequest
	(*GetTestCaseRequest)(nil),                               // 20: google.cloud.dialogflow.cx.v3beta1.GetTestCaseRequest
	(*RunTestCaseRequest)(nil),                               // 21: google.cloud.dialogflow.cx.v3beta1.RunTestCaseRequest
	(*RunTestCaseResponse)(nil),                              // 22: google.cloud.dialogflow.cx.v3beta1.RunTestCaseResponse
	(*RunTestCaseMetadata)(nil),                              // 23: google.cloud.dialogflow.cx.v3beta1.RunTestCaseMetadata
	(*BatchRunTestCasesRequest)(nil),                         // 24: google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesRequest
	(*BatchRunTestCasesResponse)(nil),                        // 25: google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesResponse
	(*BatchRunTestCasesMetadata)(nil),                        // 26: google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesMetadata
	(*TestError)(nil),                                        // 27: google.cloud.dialogflow.cx.v3beta1.TestError
	(*ImportTestCasesRequest)(nil),                           // 28: google.cloud.dialogflow.cx.v3beta1.ImportTestCasesRequest
	(*ImportTestCasesResponse)(nil),                          // 29: google.cloud.dialogflow.cx.v3beta1.ImportTestCasesResponse
	(*ImportTestCasesMetadata)(nil),                          // 30: google.cloud.dialogflow.cx.v3beta1.ImportTestCasesMetadata
	(*TestCaseError)(nil),                                    // 31: google.cloud.dialogflow.cx.v3beta1.TestCaseError
	(*ExportTestCasesRequest)(nil),                           // 32: google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest
	(*ExportTestCasesResponse)(nil),                          // 33: google.cloud.dialogflow.cx.v3beta1.ExportTestCasesResponse
	(*ExportTestCasesMetadata)(nil),                          // 34: google.cloud.dialogflow.cx.v3beta1.ExportTestCasesMetadata
	(*ListTestCaseResultsRequest)(nil),                       // 35: google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsRequest
	(*ListTestCaseResultsResponse)(nil),                      // 36: google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsResponse
	(*GetTestCaseResultRequest)(nil),                         // 37: google.cloud.dialogflow.cx.v3beta1.GetTestCaseResultRequest
	(*ConversationTurn_UserInput)(nil),                       // 38: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.UserInput
	(*ConversationTurn_VirtualAgentOutput)(nil),              // 39: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput
	(*TransitionCoverage_TransitionNode)(nil),                // 40: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.TransitionNode
	(*TransitionCoverage_Transition)(nil),                    // 41: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Transition
	(*TransitionRouteGroupCoverage_Coverage)(nil),            // 42: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
	(*TransitionRouteGroupCoverage_Coverage_Transition)(nil), // 43: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
	(*IntentCoverage_Intent)(nil),                            // 44: google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent
	(*timestamppb.Timestamp)(nil),                            // 45: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                            // 46: google.protobuf.FieldMask
	(*status.Status)(nil),                                    // 47: google.rpc.Status
	(*QueryInput)(nil),                                       // 48: google.cloud.dialogflow.cx.v3beta1.QueryInput
	(*structpb.Struct)(nil),                                  // 49: google.protobuf.Struct
	(*Intent)(nil),                                           // 50: google.cloud.dialogflow.cx.v3beta1.Intent
	(*Page)(nil),                                             // 51: google.cloud.dialogflow.cx.v3beta1.Page
	(*ResponseMessage_Text)(nil),                             // 52: google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text
	(*Flow)(nil),                                             // 53: google.cloud.dialogflow.cx.v3beta1.Flow
	(*TransitionRoute)(nil),                                  // 54: google.cloud.dialogflow.cx.v3beta1.TransitionRoute
	(*EventHandler)(nil),                                     // 55: google.cloud.dialogflow.cx.v3beta1.EventHandler
	(*TransitionRouteGroup)(nil),                             // 56: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup
	(*emptypb.Empty)(nil),                                    // 57: google.protobuf.Empty
	(*longrunning.Operation)(nil),                            // 58: google.longrunning.Operation
}
var file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_depIdxs = []int32{
	7,  // 0: google.cloud.dialogflow.cx.v3beta1.TestCase.test_config:type_name -> google.cloud.dialogflow.cx.v3beta1.TestConfig
	8,  // 1: google.cloud.dialogflow.cx.v3beta1.TestCase.test_case_conversation_turns:type_name -> google.cloud.dialogflow.cx.v3beta1.ConversationTurn
	45, // 2: google.cloud.dialogflow.cx.v3beta1.TestCase.creation_time:type_name -> google.protobuf.Timestamp
	6,  // 3: google.cloud.dialogflow.cx.v3beta1.TestCase.last_test_result:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCaseResult
	8,  // 4: google.cloud.dialogflow.cx.v3beta1.TestCaseResult.conversation_turns:type_name -> google.cloud.dialogflow.cx.v3beta1.ConversationTurn
	0,  // 5: google.cloud.dialogflow.cx.v3beta1.TestCaseResult.test_result:type_name -> google.cloud.dialogflow.cx.v3beta1.TestResult
	45, // 6: google.cloud.dialogflow.cx.v3beta1.TestCaseResult.test_time:type_name -> google.protobuf.Timestamp
	38, // 7: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.user_input:type_name -> google.cloud.dialogflow.cx.v3beta1.ConversationTurn.UserInput
	39, // 8: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.virtual_agent_output:type_name -> google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput
	1,  // 9: google.cloud.dialogflow.cx.v3beta1.TestRunDifference.type:type_name -> google.cloud.dialogflow.cx.v3beta1.TestRunDifference.DiffType
	41, // 10: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.transitions:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Transition
	42, // 11: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.coverages:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
	44, // 12: google.cloud.dialogflow.cx.v3beta1.IntentCoverage.intents:type_name -> google.cloud.dialogflow.cx.v3beta1.IntentCoverage.Intent
	2,  // 13: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest.type:type_name -> google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest.CoverageType
	12, // 14: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.intent_coverage:type_name -> google.cloud.dialogflow.cx.v3beta1.IntentCoverage
	10, // 15: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.transition_coverage:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionCoverage
	11, // 16: google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse.route_group_coverage:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
	3,  // 17: google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest.view:type_name -> google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest.TestCaseView
	5,  // 18: google.cloud.dialogflow.cx.v3beta1.ListTestCasesResponse.test_cases:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCase
	5,  // 19: google.cloud.dialogflow.cx.v3beta1.CreateTestCaseRequest.test_case:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCase
	5,  // 20: google.cloud.dialogflow.cx.v3beta1.UpdateTestCaseRequest.test_case:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCase
	46, // 21: google.cloud.dialogflow.cx.v3beta1.UpdateTestCaseRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 22: google.cloud.dialogflow.cx.v3beta1.RunTestCaseResponse.result:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCaseResult
	6,  // 23: google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesResponse.results:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCaseResult
	27, // 24: google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesMetadata.errors:type_name -> google.cloud.dialogflow.cx.v3beta1.TestError
	47, // 25: google.cloud.dialogflow.cx.v3beta1.TestError.status:type_name -> google.rpc.Status
	45, // 26: google.cloud.dialogflow.cx.v3beta1.TestError.test_time:type_name -> google.protobuf.Timestamp
	31, // 27: google.cloud.dialogflow.cx.v3beta1.ImportTestCasesMetadata.errors:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCaseError
	5,  // 28: google.cloud.dialogflow.cx.v3beta1.TestCaseError.test_case:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCase
	47, // 29: google.cloud.dialogflow.cx.v3beta1.TestCaseError.status:type_name -> google.rpc.Status
	4,  // 30: google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest.data_format:type_name -> google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest.DataFormat
	6,  // 31: google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsResponse.test_case_results:type_name -> google.cloud.dialogflow.cx.v3beta1.TestCaseResult
	48, // 32: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.UserInput.input:type_name -> google.cloud.dialogflow.cx.v3beta1.QueryInput
	49, // 33: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.UserInput.injected_parameters:type_name -> google.protobuf.Struct
	49, // 34: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.session_parameters:type_name -> google.protobuf.Struct
	9,  // 35: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.differences:type_name -> google.cloud.dialogflow.cx.v3beta1.TestRunDifference
	49, // 36: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.diagnostic_info:type_name -> google.protobuf.Struct
	50, // 37: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.triggered_intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	51, // 38: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.current_page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	52, // 39: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.text_responses:type_name -> google.cloud.dialogflow.cx.v3beta1.ResponseMessage.Text
	47, // 40: google.cloud.dialogflow.cx.v3beta1.ConversationTurn.VirtualAgentOutput.status:type_name -> google.rpc.Status
	51, // 41: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.TransitionNode.page:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	53, // 42: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.TransitionNode.flow:type_name -> google.cloud.dialogflow.cx.v3beta1.Flow
	40, // 43: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Transition.source:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.TransitionNode
	40, // 44: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Transition.target:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.TransitionNode
	54, // 45: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Transition.transition_route:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRoute
	55, // 46: google.cloud.dialogflow.cx.v3beta1.TransitionCoverage.Transition.event_handler:type_name -> google.cloud.dialogflow.cx.v3beta1.EventHandler
	56, // 47: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.route_group:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup
	43, // 48: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.transitions:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
	54, // 49: google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition.transition_route:type_name -> google.cloud.dialogflow.cx.v3beta1.TransitionRoute
	15, // 50: google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCases:input_type -> google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest
	17, // 51: google.cloud.dialogflow.cx.v3beta1.TestCases.BatchDeleteTestCases:input_type -> google.cloud.dialogflow.cx.v3beta1.BatchDeleteTestCasesRequest
	20, // 52: google.cloud.dialogflow.cx.v3beta1.TestCases.GetTestCase:input_type -> google.cloud.dialogflow.cx.v3beta1.GetTestCaseRequest
	18, // 53: google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase:input_type -> google.cloud.dialogflow.cx.v3beta1.CreateTestCaseRequest
	19, // 54: google.cloud.dialogflow.cx.v3beta1.TestCases.UpdateTestCase:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdateTestCaseRequest
	21, // 55: google.cloud.dialogflow.cx.v3beta1.TestCases.RunTestCase:input_type -> google.cloud.dialogflow.cx.v3beta1.RunTestCaseRequest
	24, // 56: google.cloud.dialogflow.cx.v3beta1.TestCases.BatchRunTestCases:input_type -> google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesRequest
	13, // 57: google.cloud.dialogflow.cx.v3beta1.TestCases.CalculateCoverage:input_type -> google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest
	28, // 58: google.cloud.dialogflow.cx.v3beta1.TestCases.ImportTestCases:input_type -> google.cloud.dialogflow.cx.v3beta1.ImportTestCasesRequest
	32, // 59: google.cloud.dialogflow.cx.v3beta1.TestCases.ExportTestCases:input_type -> google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest
	35, // 60: google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCaseResults:input_type -> google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsRequest
	37, // 61: google.cloud.dialogflow.cx.v3beta1.TestCases.GetTestCaseResult:input_type -> google.cloud.dialogflow.cx.v3beta1.GetTestCaseResultRequest
	16, // 62: google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCases:output_type -> google.cloud.dialogflow.cx.v3beta1.ListTestCasesResponse
	57, // 63: google.cloud.dialogflow.cx.v3beta1.TestCases.BatchDeleteTestCases:output_type -> google.protobuf.Empty
	5,  // 64: google.cloud.dialogflow.cx.v3beta1.TestCases.GetTestCase:output_type -> google.cloud.dialogflow.cx.v3beta1.TestCase
	5,  // 65: google.cloud.dialogflow.cx.v3beta1.TestCases.CreateTestCase:output_type -> google.cloud.dialogflow.cx.v3beta1.TestCase
	5,  // 66: google.cloud.dialogflow.cx.v3beta1.TestCases.UpdateTestCase:output_type -> google.cloud.dialogflow.cx.v3beta1.TestCase
	58, // 67: google.cloud.dialogflow.cx.v3beta1.TestCases.RunTestCase:output_type -> google.longrunning.Operation
	58, // 68: google.cloud.dialogflow.cx.v3beta1.TestCases.BatchRunTestCases:output_type -> google.longrunning.Operation
	14, // 69: google.cloud.dialogflow.cx.v3beta1.TestCases.CalculateCoverage:output_type -> google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse
	58, // 70: google.cloud.dialogflow.cx.v3beta1.TestCases.ImportTestCases:output_type -> google.longrunning.Operation
	58, // 71: google.cloud.dialogflow.cx.v3beta1.TestCases.ExportTestCases:output_type -> google.longrunning.Operation
	36, // 72: google.cloud.dialogflow.cx.v3beta1.TestCases.ListTestCaseResults:output_type -> google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsResponse
	6,  // 73: google.cloud.dialogflow.cx.v3beta1.TestCases.GetTestCaseResult:output_type -> google.cloud.dialogflow.cx.v3beta1.TestCaseResult
	62, // [62:74] is the sub-list for method output_type
	50, // [50:62] is the sub-list for method input_type
	50, // [50:50] is the sub-list for extension type_name
	50, // [50:50] is the sub-list for extension extendee
	0,  // [0:50] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_test_case_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_flow_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_response_message_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_transition_route_group_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestCase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestCaseResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationTurn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestRunDifference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionCoverage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionRouteGroupCoverage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentCoverage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateCoverageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalculateCoverageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTestCasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTestCasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteTestCasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTestCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTestCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTestCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunTestCaseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunTestCaseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunTestCaseMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunTestCasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunTestCasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunTestCasesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTestCasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTestCasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportTestCasesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestCaseError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTestCasesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTestCasesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportTestCasesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTestCaseResultsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTestCaseResultsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTestCaseResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationTurn_UserInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationTurn_VirtualAgentOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionCoverage_TransitionNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionCoverage_Transition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionRouteGroupCoverage_Coverage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionRouteGroupCoverage_Coverage_Transition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentCoverage_Intent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*CalculateCoverageResponse_IntentCoverage)(nil),
		(*CalculateCoverageResponse_TransitionCoverage)(nil),
		(*CalculateCoverageResponse_RouteGroupCoverage)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*ImportTestCasesRequest_GcsUri)(nil),
		(*ImportTestCasesRequest_Content)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*ExportTestCasesRequest_GcsUri)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[28].OneofWrappers = []interface{}{
		(*ExportTestCasesResponse_GcsUri)(nil),
		(*ExportTestCasesResponse_Content)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[35].OneofWrappers = []interface{}{
		(*TransitionCoverage_TransitionNode_Page)(nil),
		(*TransitionCoverage_TransitionNode_Flow)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*TransitionCoverage_Transition_TransitionRoute)(nil),
		(*TransitionCoverage_Transition_EventHandler)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_test_case_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_test_case_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TestCasesClient is the client API for TestCases service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TestCasesClient interface {
	// Fetches a list of test cases for a given agent.
	ListTestCases(ctx context.Context, in *ListTestCasesRequest, opts ...grpc.CallOption) (*ListTestCasesResponse, error)
	// Batch deletes test cases.
	BatchDeleteTestCases(ctx context.Context, in *BatchDeleteTestCasesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a test case.
	GetTestCase(ctx context.Context, in *GetTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error)
	// Creates a test case for the given agent.
	CreateTestCase(ctx context.Context, in *CreateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error)
	// Updates the specified test case.
	UpdateTestCase(ctx context.Context, in *UpdateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error)
	// Kicks off a test case run.
	RunTestCase(ctx context.Context, in *RunTestCaseRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Kicks off a batch run of test cases.
	BatchRunTestCases(ctx context.Context, in *BatchRunTestCasesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Calculates the test coverage for an agent.
	CalculateCoverage(ctx context.Context, in *CalculateCoverageRequest, opts ...grpc.CallOption) (*CalculateCoverageResponse, error)
	// Imports the test cases from a Cloud Storage bucket or a local file. It
	// always creates new test cases and won't overwite any existing ones. The
	// provided ID in the imported test case is neglected.
	ImportTestCases(ctx context.Context, in *ImportTestCasesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports the test cases under the agent to a Cloud Storage bucket or a local
	// file. Filter can be applied to export a subset of test cases.
	ExportTestCases(ctx context.Context, in *ExportTestCasesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Fetches a list of results for a given test case.
	ListTestCaseResults(ctx context.Context, in *ListTestCaseResultsRequest, opts ...grpc.CallOption) (*ListTestCaseResultsResponse, error)
	// Gets a test case result.
	GetTestCaseResult(ctx context.Context, in *GetTestCaseResultRequest, opts ...grpc.CallOption) (*TestCaseResult, error)
}

type testCasesClient struct {
	cc grpc.ClientConnInterface
}

func NewTestCasesClient(cc grpc.ClientConnInterface) TestCasesClient {
	return &testCasesClient{cc}
}

func (c *testCasesClient) ListTestCases(ctx context.Context, in *ListTestCasesRequest, opts ...grpc.CallOption) (*ListTestCasesResponse, error) {
	out := new(ListTestCasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/ListTestCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) BatchDeleteTestCases(ctx context.Context, in *BatchDeleteTestCasesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/BatchDeleteTestCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) GetTestCase(ctx context.Context, in *GetTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error) {
	out := new(TestCase)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/GetTestCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) CreateTestCase(ctx context.Context, in *CreateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error) {
	out := new(TestCase)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/CreateTestCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) UpdateTestCase(ctx context.Context, in *UpdateTestCaseRequest, opts ...grpc.CallOption) (*TestCase, error) {
	out := new(TestCase)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/UpdateTestCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) RunTestCase(ctx context.Context, in *RunTestCaseRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/RunTestCase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) BatchRunTestCases(ctx context.Context, in *BatchRunTestCasesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/BatchRunTestCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) CalculateCoverage(ctx context.Context, in *CalculateCoverageRequest, opts ...grpc.CallOption) (*CalculateCoverageResponse, error) {
	out := new(CalculateCoverageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/CalculateCoverage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) ImportTestCases(ctx context.Context, in *ImportTestCasesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/ImportTestCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) ExportTestCases(ctx context.Context, in *ExportTestCasesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/ExportTestCases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) ListTestCaseResults(ctx context.Context, in *ListTestCaseResultsRequest, opts ...grpc.CallOption) (*ListTestCaseResultsResponse, error) {
	out := new(ListTestCaseResultsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/ListTestCaseResults", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *testCasesClient) GetTestCaseResult(ctx context.Context, in *GetTestCaseResultRequest, opts ...grpc.CallOption) (*TestCaseResult, error) {
	out := new(TestCaseResult)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.TestCases/GetTestCaseResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TestCasesServer is the server API for TestCases service.
type TestCasesServer interface {
	// Fetches a list of test cases for a given agent.
	ListTestCases(context.Context, *ListTestCasesRequest) (*ListTestCasesResponse, error)
	// Batch deletes test cases.
	BatchDeleteTestCases(context.Context, *BatchDeleteTestCasesRequest) (*emptypb.Empty, error)
	// Gets a test case.
	GetTestCase(context.Context, *GetTestCaseRequest) (*TestCase, error)
	// Creates a test case for the given agent.
	CreateTestCase(context.Context, *CreateTestCaseRequest) (*TestCase, error)
	// Updates the specified test case.
	UpdateTestCase(context.Context, *UpdateTestCaseRequest) (*TestCase, error)
	// Kicks off a test case run.
	RunTestCase(context.Context, *RunTestCaseRequest) (*longrunning.Operation, error)
	// Kicks off a batch run of test cases.
	BatchRunTestCases(context.Context, *BatchRunTestCasesRequest) (*longrunning.Operation, error)
	// Calculates the test coverage for an agent.
	CalculateCoverage(context.Context, *CalculateCoverageRequest) (*CalculateCoverageResponse, error)
	// Imports the test cases from a Cloud Storage bucket or a local file. It
	// always creates new test cases and won't overwite any existing ones. The
	// provided ID in the imported test case is neglected.
	ImportTestCases(context.Context, *ImportTestCasesRequest) (*longrunning.Operation, error)
	// Exports the test cases under the agent to a Cloud Storage bucket or a local
	// file. Filter can be applied to export a subset of test cases.
	ExportTestCases(context.Context, *ExportTestCasesRequest) (*longrunning.Operation, error)
	// Fetches a list of results for a given test case.
	ListTestCaseResults(context.Context, *ListTestCaseResultsRequest) (*ListTestCaseResultsResponse, error)
	// Gets a test case result.
	GetTestCaseResult(context.Context, *GetTestCaseResultRequest) (*TestCaseResult, error)
}

// UnimplementedTestCasesServer can be embedded to have forward compatible implementations.
type UnimplementedTestCasesServer struct {
}

func (*UnimplementedTestCasesServer) ListTestCases(context.Context, *ListTestCasesRequest) (*ListTestCasesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListTestCases not implemented")
}
func (*UnimplementedTestCasesServer) BatchDeleteTestCases(context.Context, *BatchDeleteTestCasesRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchDeleteTestCases not implemented")
}
func (*UnimplementedTestCasesServer) GetTestCase(context.Context, *GetTestCaseRequest) (*TestCase, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetTestCase not implemented")
}
func (*UnimplementedTestCasesServer) CreateTestCase(context.Context, *CreateTestCaseRequest) (*TestCase, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateTestCase not implemented")
}
func (*UnimplementedTestCasesServer) UpdateTestCase(context.Context, *UpdateTestCaseRequest) (*TestCase, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateTestCase not implemented")
}
func (*UnimplementedTestCasesServer) RunTestCase(context.Context, *RunTestCaseRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RunTestCase not implemented")
}
func (*UnimplementedTestCasesServer) BatchRunTestCases(context.Context, *BatchRunTestCasesRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchRunTestCases not implemented")
}
func (*UnimplementedTestCasesServer) CalculateCoverage(context.Context, *CalculateCoverageRequest) (*CalculateCoverageResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CalculateCoverage not implemented")
}
func (*UnimplementedTestCasesServer) ImportTestCases(context.Context, *ImportTestCasesRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportTestCases not implemented")
}
func (*UnimplementedTestCasesServer) ExportTestCases(context.Context, *ExportTestCasesRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportTestCases not implemented")
}
func (*UnimplementedTestCasesServer) ListTestCaseResults(context.Context, *ListTestCaseResultsRequest) (*ListTestCaseResultsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListTestCaseResults not implemented")
}
func (*UnimplementedTestCasesServer) GetTestCaseResult(context.Context, *GetTestCaseResultRequest) (*TestCaseResult, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetTestCaseResult not implemented")
}

func RegisterTestCasesServer(s *grpc.Server, srv TestCasesServer) {
	s.RegisterService(&_TestCases_serviceDesc, srv)
}

func _TestCases_ListTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ListTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/ListTestCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ListTestCases(ctx, req.(*ListTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_BatchDeleteTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).BatchDeleteTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/BatchDeleteTestCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).BatchDeleteTestCases(ctx, req.(*BatchDeleteTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_GetTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).GetTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/GetTestCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).GetTestCase(ctx, req.(*GetTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_CreateTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).CreateTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/CreateTestCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).CreateTestCase(ctx, req.(*CreateTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_UpdateTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).UpdateTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/UpdateTestCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).UpdateTestCase(ctx, req.(*UpdateTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_RunTestCase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTestCaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).RunTestCase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/RunTestCase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).RunTestCase(ctx, req.(*RunTestCaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_BatchRunTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).BatchRunTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/BatchRunTestCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).BatchRunTestCases(ctx, req.(*BatchRunTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_CalculateCoverage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalculateCoverageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).CalculateCoverage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/CalculateCoverage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).CalculateCoverage(ctx, req.(*CalculateCoverageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_ImportTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ImportTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/ImportTestCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ImportTestCases(ctx, req.(*ImportTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_ExportTestCases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportTestCasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ExportTestCases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/ExportTestCases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ExportTestCases(ctx, req.(*ExportTestCasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_ListTestCaseResults_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTestCaseResultsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).ListTestCaseResults(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/ListTestCaseResults",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).ListTestCaseResults(ctx, req.(*ListTestCaseResultsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TestCases_GetTestCaseResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTestCaseResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestCasesServer).GetTestCaseResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.TestCases/GetTestCaseResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestCasesServer).GetTestCaseResult(ctx, req.(*GetTestCaseResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TestCases_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.TestCases",
	HandlerType: (*TestCasesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTestCases",
			Handler:    _TestCases_ListTestCases_Handler,
		},
		{
			MethodName: "BatchDeleteTestCases",
			Handler:    _TestCases_BatchDeleteTestCases_Handler,
		},
		{
			MethodName: "GetTestCase",
			Handler:    _TestCases_GetTestCase_Handler,
		},
		{
			MethodName: "CreateTestCase",
			Handler:    _TestCases_CreateTestCase_Handler,
		},
		{
			MethodName: "UpdateTestCase",
			Handler:    _TestCases_UpdateTestCase_Handler,
		},
		{
			MethodName: "RunTestCase",
			Handler:    _TestCases_RunTestCase_Handler,
		},
		{
			MethodName: "BatchRunTestCases",
			Handler:    _TestCases_BatchRunTestCases_Handler,
		},
		{
			MethodName: "CalculateCoverage",
			Handler:    _TestCases_CalculateCoverage_Handler,
		},
		{
			MethodName: "ImportTestCases",
			Handler:    _TestCases_ImportTestCases_Handler,
		},
		{
			MethodName: "ExportTestCases",
			Handler:    _TestCases_ExportTestCases_Handler,
		},
		{
			MethodName: "ListTestCaseResults",
			Handler:    _TestCases_ListTestCaseResults_Handler,
		},
		{
			MethodName: "GetTestCaseResult",
			Handler:    _TestCases_GetTestCaseResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/test_case.proto",
}
