// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Package serverdiscovery provides a service on Consul servers to discover the set of servers
// currently able to handle incoming requests.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: pbserverdiscovery/serverdiscovery.proto

package pbserverdiscovery

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ServerDiscoveryService_WatchServers_FullMethodName = "/hashicorp.consul.serverdiscovery.ServerDiscoveryService/WatchServers"
)

// ServerDiscoveryServiceClient is the client API for ServerDiscoveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ServerDiscoveryServiceClient interface {
	// WatchServers will stream back sets of ready servers as they change such as
	// when new servers are added or older ones removed. A ready server is one that
	// should be considered ready for sending general RPC requests towards that would
	// catalog queries, xDS proxy configurations and similar services.
	WatchServers(ctx context.Context, in *WatchServersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[WatchServersResponse], error)
}

type serverDiscoveryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServerDiscoveryServiceClient(cc grpc.ClientConnInterface) ServerDiscoveryServiceClient {
	return &serverDiscoveryServiceClient{cc}
}

func (c *serverDiscoveryServiceClient) WatchServers(ctx context.Context, in *WatchServersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[WatchServersResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &ServerDiscoveryService_ServiceDesc.Streams[0], ServerDiscoveryService_WatchServers_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[WatchServersRequest, WatchServersResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ServerDiscoveryService_WatchServersClient = grpc.ServerStreamingClient[WatchServersResponse]

// ServerDiscoveryServiceServer is the server API for ServerDiscoveryService service.
// All implementations should embed UnimplementedServerDiscoveryServiceServer
// for forward compatibility.
type ServerDiscoveryServiceServer interface {
	// WatchServers will stream back sets of ready servers as they change such as
	// when new servers are added or older ones removed. A ready server is one that
	// should be considered ready for sending general RPC requests towards that would
	// catalog queries, xDS proxy configurations and similar services.
	WatchServers(*WatchServersRequest, grpc.ServerStreamingServer[WatchServersResponse]) error
}

// UnimplementedServerDiscoveryServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedServerDiscoveryServiceServer struct{}

func (UnimplementedServerDiscoveryServiceServer) WatchServers(*WatchServersRequest, grpc.ServerStreamingServer[WatchServersResponse]) error {
	return status.Errorf(codes.Unimplemented, "method WatchServers not implemented")
}
func (UnimplementedServerDiscoveryServiceServer) testEmbeddedByValue() {}

// UnsafeServerDiscoveryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServerDiscoveryServiceServer will
// result in compilation errors.
type UnsafeServerDiscoveryServiceServer interface {
	mustEmbedUnimplementedServerDiscoveryServiceServer()
}

func RegisterServerDiscoveryServiceServer(s grpc.ServiceRegistrar, srv ServerDiscoveryServiceServer) {
	// If the following call pancis, it indicates UnimplementedServerDiscoveryServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ServerDiscoveryService_ServiceDesc, srv)
}

func _ServerDiscoveryService_WatchServers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchServersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ServerDiscoveryServiceServer).WatchServers(m, &grpc.GenericServerStream[WatchServersRequest, WatchServersResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type ServerDiscoveryService_WatchServersServer = grpc.ServerStreamingServer[WatchServersResponse]

// ServerDiscoveryService_ServiceDesc is the grpc.ServiceDesc for ServerDiscoveryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ServerDiscoveryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.consul.serverdiscovery.ServerDiscoveryService",
	HandlerType: (*ServerDiscoveryServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WatchServers",
			Handler:       _ServerDiscoveryService_WatchServers_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "pbserverdiscovery/serverdiscovery.proto",
}
