/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.WindowMoveListener;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.emojipicker.Emoji;
import org.jetbrains.plugins.emojipicker.EmojiCategory;
import org.jetbrains.plugins.emojipicker.EmojiSkinTone;
import org.jetbrains.plugins.emojipicker.service.EmojiService;
import org.jetbrains.plugins.emojipicker.ui.EmojiCategoryPanel;
import org.jetbrains.plugins.emojipicker.ui.EmojiInfoPanel;
import org.jetbrains.plugins.emojipicker.ui.EmojiListPanel;
import org.jetbrains.plugins.emojipicker.ui.EmojiPickerStyle;
import org.jetbrains.plugins.emojipicker.ui.EmojiSearchField;
import org.jetbrains.plugins.emojipicker.ui.EmojiSkinTonesPanel;

public final class EmojiPicker
extends JLayeredPane {
    private static final JBDimension DEFAULT_SIZE = new JBDimension(358, 415);
    private final List<EmojiCategory> myCategories;
    private final EmojiSearchField mySearchField;
    private final EmojiCategoryPanel myCategoryPanel;
    private final EmojiListPanel myEmojiListPanel;
    private final EmojiInfoPanel myEmojiInfoPanel;
    private final JPanel myEmojiSkinTonesModal;
    private final EmojiSkinTonesPanel myEmojiSkinTonesPanel;
    private final KeyboardManager myKeyboardManager;
    private Consumer<String> myInputCallback = emoji -> {};

    private EmojiPicker() {
        this.myCategories = EmojiService.getInstance().getCategories();
        this.setPreferredSize((Dimension)DEFAULT_SIZE.size());
        this.setLayout(new JPanelFillLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        GridBagConstraints fillerGbc = (GridBagConstraints)gbc.clone();
        fillerGbc.weighty = 1.0;
        EmojiPickerStyle style = new EmojiPickerStyle();
        JPanel contentPanel = new JPanel();
        this.myCategoryPanel = new EmojiCategoryPanel(this, style, this.myCategories);
        this.mySearchField = new EmojiSearchField(this, style);
        this.myEmojiListPanel = new EmojiListPanel(this, style, this.myCategories);
        this.myEmojiInfoPanel = new EmojiInfoPanel(style);
        this.myEmojiSkinTonesModal = new JPanel();
        this.myEmojiSkinTonesPanel = new EmojiSkinTonesPanel(this, style);
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.add((Component)this.myCategoryPanel, gbc);
        contentPanel.add((Component)((Object)this.mySearchField), gbc);
        contentPanel.add((Component)((Object)this.myEmojiListPanel), fillerGbc);
        contentPanel.add((Component)this.myEmojiInfoPanel, gbc);
        this.add(contentPanel);
        this.myEmojiSkinTonesModal.setOpaque(false);
        this.myEmojiSkinTonesModal.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EmojiPicker.this.selectSkinToneFromPanel();
            }
        });
        this.add((Component)this.myEmojiSkinTonesModal, JLayeredPane.MODAL_LAYER);
        this.add((Component)this.myEmojiSkinTonesPanel, JLayeredPane.POPUP_LAYER);
        EmojiPicker.applyWindowMoveListener(this.myCategoryPanel);
        EmojiPicker.applyWindowMoveListener(this.myEmojiInfoPanel);
        this.myKeyboardManager = new KeyboardManager();
        this.selectCategory(this.myCategories.get(0), true);
        this.selectSkinToneFromPanel();
    }

    private static void applyWindowMoveListener(Component c) {
        new WindowMoveListener(c).installTo(c);
    }

    void selectCategory(EmojiCategory category, boolean scrollToCategory) {
        this.myCategoryPanel.selectCategory(category);
        if (scrollToCategory) {
            if (!this.mySearchField.getText().isEmpty()) {
                this.mySearchField.setText("");
            }
            this.myEmojiListPanel.selectCategory(category);
            this.myKeyboardManager.resetFocus();
        }
    }

    void search(@NonNls String text) {
        this.myEmojiListPanel.updateSearchFilter(text);
        this.myKeyboardManager.resetFocus();
        this.myKeyboardManager.emojiNavigationMode = false;
    }

    void updateEmojiInfo(Emoji emoji, EmojiSkinTone skinTone) {
        this.myEmojiInfoPanel.showEmojiInfo(emoji, skinTone);
    }

    void selectEmoji(@NonNls String emoji) {
        this.myInputCallback.accept(emoji);
    }

    boolean handleKey(int key, int modifiers) {
        return this.myKeyboardManager.handleKey(key, modifiers);
    }

    Object getCurrentFocusTarget() {
        return this.myKeyboardManager.focusTargets.get(this.myKeyboardManager.currentFocusTarget);
    }

    Icon getCurrentSkinToneIcon(boolean hover) {
        return this.myEmojiSkinTonesPanel.getCurrentItem().getIcon(hover);
    }

    void selectSkinToneFromPanel() {
        this.myEmojiSkinTonesModal.setVisible(false);
        this.myEmojiSkinTonesPanel.setVisible(false);
        this.myEmojiListPanel.updateSkinTone(this.myEmojiSkinTonesPanel.getCurrentSkinTone());
        this.mySearchField.update();
        EmojiService.getInstance().setCurrentSkinTone(this.myEmojiSkinTonesPanel.getCurrentSkinTone());
        this.myKeyboardManager.resetFocus();
    }

    void openSkinToneSelectionPanel() {
        this.myEmojiSkinTonesModal.setVisible(true);
        this.myEmojiSkinTonesPanel.open(this.mySearchField);
    }

    public static boolean isAvailable() {
        return EmojiPickerStyle.isEmojiFontAvailable();
    }

    public static JBPopup createPopup(Project project, Consumer<String> inputCallback) {
        EmojiPicker picker = new EmojiPicker();
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)picker, (JComponent)((Object)picker.mySearchField)).setProject(project).setModalContext(false).setCancelOnClickOutside(true).setRequestFocus(true).setCancelKeyEnabled(false).setResizable(false).setMovable(true).setLocateWithinScreenBounds(true).setMinSize((Dimension)DEFAULT_SIZE.size()).setShowBorder(false).createPopup();
        picker.myInputCallback = emoji -> {
            if (emoji != null) {
                inputCallback.accept((String)emoji);
                popup.closeOk(null);
            } else {
                popup.cancel();
            }
        };
        return popup;
    }

    private static class JPanelFillLayout
    implements LayoutManager2 {
        private JPanelFillLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                return parent.getSize();
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension size = parent.getSize();
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    if (parent.getComponent(i).getClass() != JPanel.class) continue;
                    parent.getComponent(i).setBounds(0, 0, size.width, size.height);
                }
            }
        }
    }

    private class KeyboardManager {
        private final List<Object> focusTargets = new ArrayList<Object>();
        private int currentFocusTarget = 0;
        private boolean emojiNavigationMode = false;

        private KeyboardManager() {
            this.focusTargets.add((Object)EmojiPicker.this.mySearchField);
            this.focusTargets.add(EmojiPicker.this.myEmojiSkinTonesPanel);
            this.focusTargets.addAll(EmojiPicker.this.myCategories);
        }

        private void resetFocus() {
            if (this.currentFocusTarget != 0) {
                this.currentFocusTarget = 0;
                this.emojiNavigationMode = false;
                EmojiPicker.this.myCategoryPanel.repaint();
                EmojiPicker.this.mySearchField.repaint();
            }
        }

        private boolean handleKey(int k, int modifiers) {
            Object focus = this.focusTargets.get(this.currentFocusTarget);
            if (focus == EmojiPicker.this.myEmojiSkinTonesPanel) {
                if (EmojiPicker.this.myEmojiSkinTonesPanel.isVisible()) {
                    switch (k) {
                        case 38: 
                        case 40: {
                            EmojiPicker.this.myEmojiSkinTonesPanel.focusItem(k == 40 ? 1 : -1);
                            return true;
                        }
                        case 9: 
                        case 10: 
                        case 32: {
                            EmojiPicker.this.myEmojiSkinTonesPanel.setCurrentItemFromFocus();
                        }
                        case 27: {
                            EmojiPicker.this.selectSkinToneFromPanel();
                            return true;
                        }
                    }
                } else if (k == 10 || k == 32) {
                    EmojiPicker.this.openSkinToneSelectionPanel();
                    EmojiPicker.this.myEmojiSkinTonesPanel.focusItem(1);
                    return true;
                }
            }
            switch (k) {
                case 9: {
                    int direction = (modifiers & 0x40) == 64 ? -1 : 1;
                    this.currentFocusTarget = (this.currentFocusTarget + direction + this.focusTargets.size()) % this.focusTargets.size();
                    EmojiPicker.this.myCategoryPanel.repaint();
                    EmojiPicker.this.mySearchField.repaint();
                    return true;
                }
                case 27: {
                    EmojiPicker.this.myInputCallback.accept(null);
                    return true;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.resetFocus();
                    if (!this.emojiNavigationMode) {
                        boolean bl = this.emojiNavigationMode = k == 38 || k == 40 || k == 37 && EmojiPicker.this.mySearchField.getCaretPosition() == 0 || k == 39 && EmojiPicker.this.mySearchField.getCaretPosition() == EmojiPicker.this.mySearchField.getText().length();
                    }
                    if (!EmojiPicker.this.myEmojiListPanel.hasCurrentItem()) {
                        this.emojiNavigationMode = false;
                    }
                    if (this.emojiNavigationMode) {
                        EmojiPicker.this.myEmojiListPanel.navigate(KeyboardManager.keyToOffset(k, 39, 37), KeyboardManager.keyToOffset(k, 40, 38));
                        return true;
                    }
                    return false;
                }
            }
            if (focus instanceof EmojiCategory) {
                if (k == 10 || k == 32) {
                    EmojiPicker.this.selectCategory((EmojiCategory)focus, true);
                    return true;
                }
            } else if (focus == EmojiPicker.this.mySearchField && k == 10) {
                EmojiPicker.this.myEmojiListPanel.selectCurrentEmoji();
                return true;
            }
            return false;
        }

        private static int keyToOffset(int key, int positive, int negative) {
            if (key == positive) {
                return 1;
            }
            if (key == negative) {
                return -1;
            }
            return 0;
        }
    }
}

