/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.Token;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.PrimitivePropertyBuilders;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PrimitiveBackgroundPropertyBuilders {
    private static BitSet setOf(IdentValue ... val) {
        return PrimitivePropertyBuilders.setFor(val);
    }

    public static class BackgroundAttachment
    extends MultipleIdentValue {
        @Override
        protected BitSet getAllowed() {
            return PrimitivePropertyBuilders.BACKGROUND_ATTACHMENTS;
        }
    }

    public static class BackgroundRepeat
    extends MultipleIdentValue {
        @Override
        protected BitSet getAllowed() {
            return PrimitivePropertyBuilders.BACKGROUND_REPEATS;
        }
    }

    private static abstract class MultipleIdentValue
    extends MultipleBackgroundValueBuilder {
        private MultipleIdentValue() {
        }

        @Override
        protected List<PropertyValue> processValue(CSSName cssName, PropertyValue value) {
            this.checkIdentType(cssName, value);
            IdentValue ident = this.checkIdent(cssName, value);
            this.checkValidity(cssName, this.getAllowed(), ident);
            return Collections.singletonList(value);
        }

        protected abstract BitSet getAllowed();
    }

    public static class BackgroundPosition
    extends MultipleBackgroundValueBuilder {
        @Override
        protected List<PropertyValue> processValue(CSSName cssName, PropertyValue first) {
            this.checkIdentLengthOrPercentType(cssName, first);
            if (this.isLength(first) || first.getPrimitiveType() == 2) {
                return Arrays.asList(first, this.createValueForIdent(IdentValue.CENTER));
            }
            assert (first.getPrimitiveType() == 21);
            IdentValue firstIdent = this.checkIdent(cssName, first);
            this.checkValidity(cssName, this.getAllowed(), firstIdent);
            if (firstIdent == IdentValue.TOP || firstIdent == IdentValue.BOTTOM) {
                return Arrays.asList(this.createValueForIdent(IdentValue.CENTER), this.createValueForIdent(firstIdent));
            }
            assert (firstIdent == IdentValue.CENTER || firstIdent == IdentValue.LEFT || firstIdent == IdentValue.RIGHT);
            return Arrays.asList(this.createValueForIdent(firstIdent), this.createValueForIdent(IdentValue.CENTER));
        }

        @Override
        protected List<PropertyValue> processValues(CSSName cssName, PropertyValue first, PropertyValue second) {
            this.checkIdentLengthOrPercentType(cssName, first);
            this.checkIdentLengthOrPercentType(cssName, second);
            IdentValue firstIdent = null;
            if (first.getPrimitiveType() == 21) {
                firstIdent = this.checkIdent(cssName, first);
                this.checkValidity(cssName, this.getAllowed(), firstIdent);
            }
            IdentValue secondIdent = null;
            if (second.getPrimitiveType() == 21) {
                secondIdent = this.checkIdent(cssName, second);
                this.checkValidity(cssName, this.getAllowed(), secondIdent);
            }
            if (firstIdent == null && secondIdent == null) {
                assert (this.isLength(first) || first.getPrimitiveType() == 2);
                assert (this.isLength(second) || second.getPrimitiveType() == 2);
                return Arrays.asList(first, second);
            }
            if (firstIdent != null && secondIdent != null) {
                if (firstIdent == IdentValue.TOP || firstIdent == IdentValue.BOTTOM || secondIdent == IdentValue.LEFT || secondIdent == IdentValue.RIGHT) {
                    IdentValue temp = firstIdent;
                    firstIdent = secondIdent;
                    secondIdent = temp;
                }
                this.checkIdentPosition(cssName, firstIdent, secondIdent);
                assert (firstIdent == IdentValue.CENTER || firstIdent == IdentValue.LEFT || firstIdent == IdentValue.RIGHT);
                assert (secondIdent == IdentValue.CENTER || secondIdent == IdentValue.TOP || secondIdent == IdentValue.BOTTOM);
                return Arrays.asList(this.createValueForIdent(firstIdent), this.createValueForIdent(secondIdent));
            }
            this.checkIdentPosition(cssName, firstIdent, secondIdent);
            if (firstIdent == null) {
                assert (this.isLength(first) || first.getPrimitiveType() == 2);
                assert (secondIdent != null);
                return Arrays.asList(first, this.createValueForIdent(secondIdent));
            }
            assert (firstIdent != null);
            assert (this.isLength(second) || second.getPrimitiveType() == 2);
            return Arrays.asList(this.createValueForIdent(firstIdent), second);
        }

        @Override
        protected boolean allowsTwoValueItems() {
            return true;
        }

        private void checkIdentPosition(CSSName cssName, IdentValue firstIdent, IdentValue secondIdent) {
            if (firstIdent == IdentValue.TOP || firstIdent == IdentValue.BOTTOM || secondIdent == IdentValue.LEFT || secondIdent == IdentValue.RIGHT) {
                throw new CSSParseException("Invalid combination of keywords in " + cssName, -1);
            }
        }

        private float getPercentForIdent(IdentValue ident) {
            float percent;
            if (ident == IdentValue.CENTER) {
                percent = 50.0f;
            } else if (ident == IdentValue.BOTTOM || ident == IdentValue.RIGHT) {
                percent = 100.0f;
            } else {
                assert (ident == IdentValue.TOP || ident == IdentValue.LEFT);
                percent = 0.0f;
            }
            return percent;
        }

        private PropertyValue createValueForIdent(IdentValue ident) {
            float percent = this.getPercentForIdent(ident);
            return new PropertyValue(2, percent, percent + "%");
        }

        private BitSet getAllowed() {
            return PrimitivePropertyBuilders.BACKGROUND_POSITIONS;
        }
    }

    public static class BackgroundSize
    extends MultipleBackgroundValueBuilder {
        private static final BitSet ALL_ALLOWED = PrimitiveBackgroundPropertyBuilders.access$100(new IdentValue[]{IdentValue.AUTO, IdentValue.CONTAIN, IdentValue.COVER});

        @Override
        protected List<PropertyValue> processValue(CSSName cssName, PropertyValue first) {
            this.checkIdentLengthOrPercentType(cssName, first);
            if (first.getPrimitiveType() == 21) {
                IdentValue firstIdent = this.checkIdent(cssName, first);
                this.checkValidity(cssName, ALL_ALLOWED, firstIdent);
                assert (firstIdent == IdentValue.AUTO || firstIdent == IdentValue.COVER || firstIdent == IdentValue.CONTAIN);
                return Arrays.asList(first, first);
            }
            assert (this.isLength(first) || first.getPrimitiveType() == 2);
            return Arrays.asList(first, new PropertyValue(IdentValue.AUTO));
        }

        @Override
        protected List<PropertyValue> processValues(CSSName cssName, PropertyValue first, PropertyValue second) {
            this.checkIdentLengthOrPercentType(cssName, first);
            this.checkIdentLengthOrPercentType(cssName, second);
            if (first.getPrimitiveType() == 21) {
                IdentValue firstIdent = this.checkIdent(cssName, first);
                if (firstIdent != IdentValue.AUTO) {
                    throw new CSSParseException("The only ident value allowed here is 'auto'", -1);
                }
            } else if (first.getFloatValue() < 0.0f) {
                throw new CSSParseException(cssName + " values cannot be negative", -1);
            }
            if (second.getPrimitiveType() == 21) {
                IdentValue secondIdent = this.checkIdent(cssName, second);
                if (secondIdent != IdentValue.AUTO) {
                    throw new CSSParseException("The only ident value allowed here is 'auto'", -1);
                }
            } else if (second.getFloatValue() < 0.0f) {
                throw new CSSParseException(cssName + " values cannot be negative", -1);
            }
            return Arrays.asList(first, second);
        }

        @Override
        protected boolean allowsTwoValueItems() {
            return true;
        }
    }

    public static class BackgroundColor
    extends PrimitivePropertyBuilders.GenericColor {
    }

    public static class BackgroundImage
    extends MultipleBackgroundValueBuilder {
        @Override
        protected List<PropertyValue> processValue(CSSName cssName, PropertyValue value) {
            if (value.getPropertyValueType() == 7 && Objects.equals(value.getFunction().getName(), "linear-gradient")) {
                return Collections.singletonList(value);
            }
            this.checkIdentOrURIType(cssName, value);
            if (value.getPrimitiveType() == 21) {
                IdentValue ident = this.checkIdent(cssName, value);
                this.checkValidity(cssName, PrimitiveBackgroundPropertyBuilders.setOf(new IdentValue[]{IdentValue.NONE}), ident);
            }
            return Collections.singletonList(value);
        }
    }

    private static abstract class MultipleBackgroundValueBuilder
    extends AbstractPropertyBuilder {
        private MultipleBackgroundValueBuilder() {
        }

        protected abstract List<PropertyValue> processValue(CSSName var1, PropertyValue var2);

        protected List<PropertyValue> processValues(CSSName cssName, PropertyValue val1, PropertyValue val2) {
            return Arrays.asList(val1, val2);
        }

        protected boolean allowsTwoValueItems() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
            ArrayList<PropertyValue> res;
            this.checkValueCount(cssName, 1, Integer.MAX_VALUE, values.size());
            if (values.size() == 1) {
                PropertyValue val = values.get(0);
                this.checkInheritAllowed(val, inheritAllowed);
                if (val.getCssValueType() == 0) return Collections.singletonList(new PropertyDeclaration(cssName, val, important, origin));
                res = this.processValue(cssName, val);
                return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(res), important, origin));
            } else {
                res = new ArrayList(values.size());
                for (int i = 0; i < values.size(); ++i) {
                    boolean atEnd = i == values.size() - 1;
                    boolean beforeComma = !atEnd && values.get(i + 1).getOperator() == Token.TK_COMMA;
                    PropertyValue val1 = values.get(i);
                    PropertyValue val2 = !atEnd && !beforeComma ? values.get(i + 1) : null;
                    this.checkForbidInherit(val1);
                    if (val2 == null) {
                        res.addAll(this.processValue(cssName, val1));
                        continue;
                    }
                    if (!this.allowsTwoValueItems()) {
                        this.checkValueCount(cssName, 1, 2);
                        continue;
                    }
                    this.checkForbidInherit(val2);
                    res.addAll(this.processValues(cssName, val1, val2));
                    ++i;
                }
            }
            return Collections.singletonList(new PropertyDeclaration(cssName, new PropertyValue(res), important, origin));
        }
    }
}

