/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.fs;

import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFFileSystemProvider;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderRegistry;

public class FSUtils {
    private static final Log log = Log.getLog(FSUtils.class);

    @Nullable
    public static Path getPathFromURI(@NotNull String fileUriString) throws DBException {
        URI fileUri = URI.create(fileUriString);
        if (!fileUri.isAbsolute() || fileUri.getScheme() == null) {
            return Path.of(fileUriString, new String[0]).toAbsolutePath();
        }
        FileSystem defaultFs = FileSystems.getDefault();
        if (defaultFs.provider().getScheme().equals(fileUri.getScheme())) {
            return defaultFs.provider().getPath(fileUri);
        }
        DBFFileSystemDescriptor externalFsProvider = FileSystemProviderRegistry.getInstance().getFileSystemProviderBySchema(fileUri.getScheme());
        if (externalFsProvider == null) {
            log.error((Object)("File system not found for scheme: " + fileUri.getScheme()));
            return null;
        }
        DBFFileSystemProvider fileSystemProvider = externalFsProvider.getInstance();
        ClassLoader fsClassloader = fileSystemProvider.getClass().getClassLoader();
        Map env = fileSystemProvider.prepareEnv(System.getenv());
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileSystem externalFileSystem = FileSystems.newFileSystem(fileUri, env, fsClassloader);){
                return externalFileSystem.provider().getPath(fileUri);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize path: " + String.valueOf(fileUri)), (Throwable)e);
            return null;
        }
    }
}

