(*************************************************************
 *                                                           *
 *  Cryptographic protocol verifier                          *
 *                                                           *
 *  Bruno Blanchet, Vincent Cheval, and Marc Sylvestre       *
 *                                                           *
 *  Copyright (C) INRIA, CNRS 2000-2023                      *
 *                                                           *
 *************************************************************)

(*

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details (in file LICENSE).

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*)
open Types
open Pitypes
open Stringmap

(* [set_event_status pi_state] records the status of events (injective,
   non-injective, or not used, in hypothesis or in conclusion of
   of the queries) for the queries in [pi_state].
   This function must be called before translating the
   process into clauses. *)
val set_event_status : t_pi_state -> t_pi_state

(* [get_event_status pi_state e] returns the status for event [e]. *)
val get_event_status : t_pi_state -> funsymb -> eventstatus

(* [update_event_status_with_lemmas] updates the status of events occuring in
   in the lemmas. Must be applied after [Lemma.simplify_lemmas]. *)
val update_event_status_with_lemmas : t_pi_state -> unit
