searchData={"items":[{"type":"module","title":"ssh","doc":"Main API of the ssh application\n\nThis is the interface module for the `SSH` application. The Secure Shell (SSH)\nProtocol is a protocol for secure remote login and other secure network services\nover an insecure network. See [ssh](ssh_app.md#supported) for details of\nsupported RFCs, versions, algorithms and unicode handling.\n\nWith the SSH application it is possible to start _clients_ and to start\n_daemons_ (servers).\n\nClients are started with `connect/2`, `connect/3` or `connect/4`. They open an\nencrypted connection on top of TCP/IP. In that encrypted connection one or more\nchannels could be opened with\n[ssh_connection:session_channel/2,4](`ssh_connection:session_channel/2`).\n\nEach channel is an isolated \"pipe\" between a client-side process and a\nserver-side process. Those process pairs could handle for example file transfers\n(sftp) or remote command execution (shell, exec and/or cli). If a custom shell\nis implemented, the user of the client could execute the special commands\nremotely. Note that the user is not necessarily a human but probably a system\ninterfacing the SSH app.\n\nA server-side subssystem (channel) server is requested by the client with\n`ssh_connection:subsystem/4`.\n\nA server (daemon) is started with [daemon/1](`daemon/2`), `daemon/2` or\n[daemon/3](`daemon/2`). Possible channel handlers (subsystems) are declared with\nthe [subsystem](`t:subsystem_daemon_option/0`) option when the daemon is\nstarted.\n\nTo just run a shell on a remote machine, there are functions that bundles the\nneeded three steps needed into one: [shell/1,2,3](`shell/1`). Similarly, to just\nopen an sftp (file transfer) connection to a remote machine, the simplest way is\nto use [ssh_sftp:start_channel/1,2,3](`ssh_sftp:start_channel/1`).\n\nTo write your own client channel handler, use the behaviour\n`m:ssh_client_channel`. For server channel handlers use `m:ssh_server_channel`\nbehaviour (replaces ssh_daemon_channel).\n\nBoth clients and daemons accept options that control the exact behaviour. Some\noptions are common to both. The three sets are called\n[Client Options](`t:client_options/0`), [Daemon Options](`t:daemon_options/0`)\nand [Common Options](`t:common_options/0`).\n\nThe descriptions of the options uses the\n[Erlang Type Language](`e:system:typespec.md`) with explaining text.\n\n> #### Note {: .info }\n>\n> See also [SSH Application Reference](index.html) and [Examples](using_ssh.md) section.","ref":"ssh.html"},{"type":"module","title":"Keys and files - ssh","doc":"A number of objects must be present for the SSH application to work. Those\nobjects are per default stored in files. The default names, paths and file\nformats are the same as for [OpenSSH](http://www.openssh.com). Keys could be\ngenerated with the `ssh-keygen` program from OpenSSH. See the\n[User's Guide](using_ssh.md#running-an-erlang-ssh-daemon).\n\nThe paths could easily be changed by options:\n[`user_dir`](`t:ssh_file:user_dir_common_option/0`) and\n[`system_dir`](`t:ssh_file:system_dir_daemon_option/0`).\n\nA completely different storage could be interfaced by writing callback modules\nusing the behaviours `m:ssh_client_key_api` and/or `m:ssh_server_key_api`. A\ncallback module is installed with the option\n[`key_cb`](`t:key_cb_common_option/0`) to the client and/or the daemon.","ref":"ssh.html#module-keys-and-files"},{"type":"module","title":"Daemons - ssh","doc":"The keys are by default stored in files:\n\n- Mandatory: one or more _Host key(s)_, both private and public. Default is to\n  store them in the directory `/etc/ssh` in the files\n\n  - `ssh_host_dsa_key` and `ssh_host_dsa_key.pub`\n  - `ssh_host_rsa_key` and `ssh_host_rsa_key.pub`\n  - `ssh_host_ecdsa_key` and `ssh_host_ecdsa_key.pub`\n\n  The host keys directory could be changed with the option\n  [`system_dir`](`t:ssh_file:system_dir_daemon_option/0`).\n\n- Optional: one or more _User's public key_ in case of `publickey`\n  authorization. Default is to store them concatenated in the file\n  `.ssh/authorized_keys` in the user's home directory.\n\n  The user keys directory could be changed with the option\n  [`user_dir`](`t:ssh_file:user_dir_common_option/0`).","ref":"ssh.html#module-daemons"},{"type":"module","title":"Clients - ssh","doc":"The keys and some other data are by default stored in files in the directory\n`.ssh` in the user's home directory.\n\nThe directory could be changed with the option\n[`user_dir`](`t:ssh_file:user_dir_common_option/0`).\n\n- Optional: a list of _Host public key(s)_ for previously connected hosts. This\n  list is handled by the SSH application without any need of user assistance.\n  The default is to store them in the file `known_hosts`.\n\n  The `t:host_accepting_client_options/0` are associated with this list of keys.\n\n- Optional: one or more _User's private key(s)_ in case of `publickey`\n  authorization. The default files are\n  - `id_dsa` and `id_dsa.pub`\n  - `id_rsa` and `id_rsa.pub`\n  - `id_ecdsa` and `id_ecdsa.pub`","ref":"ssh.html#module-clients"},{"type":"type","title":"ssh.accept_callback/0","doc":"","ref":"ssh.html#t:accept_callback/0"},{"type":"type","title":"ssh.accept_hosts/0","doc":"","ref":"ssh.html#t:accept_hosts/0"},{"type":"type","title":"ssh.alg_entry/0","doc":"","ref":"ssh.html#t:alg_entry/0"},{"type":"type","title":"ssh.algs_list/0","doc":"","ref":"ssh.html#t:algs_list/0"},{"type":"type","title":"ssh.auth_methods_common_option/0","doc":"Comma-separated string that determines which authentication methods that the\nclient shall support and in which order they are tried. Defaults to\n`\"publickey,keyboard-interactive,password\"`\n\nNote that the client is free to use any order and to exclude methods.","ref":"ssh.html#t:auth_methods_common_option/0"},{"type":"type","title":"ssh.authentication_client_options/0","doc":"- **`user`** - Provides the username. If this option is not given, `ssh` reads\n  from the environment (`LOGNAME` or `USER` on UNIX, `USERNAME` on Windows).\n\n- **`password`** - Provides a password for password authentication. If this\n  option is not given, the user is asked for a password, if the password\n  authentication method is attempted.","ref":"ssh.html#t:authentication_client_options/0"},{"type":"type","title":"ssh.authentication_daemon_options/0","doc":"","ref":"ssh.html#t:authentication_daemon_options/0"},{"type":"type","title":"ssh.callbacks_daemon_options/0","doc":"- **`connectfun`** - Provides a fun to implement your own logging when a user\n  authenticates to the server.\n\n- **`failfun`** - Provides a fun to implement your own logging when a user fails\n  to authenticate.\n\n- **`bannerfun`** - Provides a fun to implement the construction of a banner\n  text that is sent at the beginning of the user authentication. The banner will\n  not be sent if the function does not return a binary.","ref":"ssh.html#t:callbacks_daemon_options/0"},{"type":"opaque","title":"ssh.channel_id/0","doc":"Opaque data type representing a channel inside a connection.\n\nReturned by the functions\n[ssh_connection:session_channel/2,4](`ssh_connection:session_channel/2`).","ref":"ssh.html#t:channel_id/0"},{"type":"type","title":"ssh.cipher_alg/0","doc":"","ref":"ssh.html#t:cipher_alg/0"},{"type":"type","title":"ssh.client_option/0","doc":"Options for [clients](`connect/3`). The individual options are further explained\nbelow or by following the hyperlinks.\n\nNote that not every `t:gen_tcp:connect_option/0` is accepted. See\n`set_sock_opts/2` for a list of prohibited options.\n\nAlso note that setting a `t:gen_tcp:connect_option/0` could change the socket in\na way that impacts the ssh client's behaviour negatively. You use it on your own\nrisk.","ref":"ssh.html#t:client_option/0"},{"type":"type","title":"ssh.client_options/0","doc":"","ref":"ssh.html#t:client_options/0"},{"type":"function","title":"ssh.close/1","doc":"Closes an SSH connection.","ref":"ssh.html#close/1"},{"type":"type","title":"ssh.common_option/0","doc":"The options above can be used both in clients and in daemons (servers). They are\nfurther explained below.","ref":"ssh.html#t:common_option/0"},{"type":"type","title":"ssh.common_options/0","doc":"","ref":"ssh.html#t:common_options/0"},{"type":"type","title":"ssh.compression_alg/0","doc":"","ref":"ssh.html#t:compression_alg/0"},{"type":"type","title":"ssh.conn_info_algs/0","doc":"","ref":"ssh.html#t:conn_info_algs/0"},{"type":"type","title":"ssh.conn_info_channels/0","doc":"","ref":"ssh.html#t:conn_info_channels/0"},{"type":"function","title":"ssh.connect/2","doc":"Equivalent to  connect/4 .","ref":"ssh.html#connect/2"},{"type":"function","title":"ssh.connect/3","doc":"Equivalent to  connect/4 .","ref":"ssh.html#connect/3"},{"type":"function","title":"ssh.connect/4","doc":"Connects to an SSH server at the `Host` on `Port`.\n\nAs an alternative, an already open TCP socket could be passed to the function in\n`TcpSocket`. The SSH initiation and negotiation will be initiated on that one\nwith the SSH that should be at the other end.\n\nNo channel is started. This is done by calling\n[ssh_connection:session_channel/2,4](`ssh_connection:session_channel/2`).\n\nThe `NegotiationTimeout` is in milli-seconds. The default value is `infinity` or\nthe value of the [`connect_timeout`](`t:connect_timeout_client_option/0`)\noption, if present. For connection timeout, use the option\n[`connect_timeout`](`t:connect_timeout_client_option/0`).","ref":"ssh.html#connect/4"},{"type":"type","title":"ssh.connect_timeout_client_option/0","doc":"Sets a timeout on the transport layer connect time. For `m:gen_tcp` the time is\nin milli-seconds and the default value is `infinity`.\n\nSee the parameter `Timeout` in `connect/4` for a timeout of the negotiation\nphase.","ref":"ssh.html#t:connect_timeout_client_option/0"},{"type":"function","title":"ssh.connection_info/1","doc":"Equivalent to  connection_info/2 .","ref":"ssh.html#connection_info/1"},{"type":"function","title":"ssh.connection_info/2","doc":"Returns information about a connection intended for e.g debugging or logging.\n\nWhen the `Key` is a single `Item`, the result is a single `InfoTuple`","ref":"ssh.html#connection_info/2"},{"type":"type","title":"ssh.connection_info_tuple/0","doc":"Return values from the `connection_info/1` and `connection_info/2` functions.\n\n> #### Note {: .info }\n>\n> Note that `options` info tuple contains only items with nondefault values.","ref":"ssh.html#t:connection_info_tuple/0"},{"type":"type","title":"ssh.connection_ref/0","doc":"Opaque data type representing a connection between a client and a server\n(daemon).\n\nReturned by the functions [`connect/2,3,4`](`connect/3`) and\n[`ssh_sftp:start_channel/2,3`](`ssh_sftp:start_channel/2`).","ref":"ssh.html#t:connection_ref/0"},{"type":"function","title":"ssh.daemon/1","doc":"Equivalent to  daemon/3 .","ref":"ssh.html#daemon/1"},{"type":"function","title":"ssh.daemon/2","doc":"Equivalent to  daemon/3 .","ref":"ssh.html#daemon/2"},{"type":"function","title":"ssh.daemon/3","doc":"Starts a server listening for SSH connections on the given port. If the `Port`\nis 0, a random free port is selected. See `daemon_info/1` about how to find the\nselected port number.\n\nAs an alternative, an already open TCP socket could be passed to the function in\n`TcpSocket`. The SSH initiation and negotiation will be initiated on that one\nwhen an SSH starts at the other end of the TCP socket.\n\nFor a description of the options, see [Daemon Options](`t:daemon_options/0`).\n\nPlease note that by historical reasons both the `HostAddress` argument and the\n[gen_tcp connect_option() `{ip,Address}`](`t:gen_tcp:connect_option/0`) set the\nlistening address. This is a source of possible inconsistent settings.\n\nThe rules for handling the two address passing options are:\n\n- if `HostAddress` is an IP-address, that IP-address is the listening address.\n  An 'ip'-option will be discarded if present.\n- if `HostAddress` is the atom `loopback`, the listening address is `loopback`\n  and an loopback address will be chosen by the underlying layers. An\n  'ip'-option will be discarded if present.\n- if `HostAddress` is the atom `any` and no 'ip'-option is present, the\n  listening address is `any` and the socket will listen to all addresses\n- if `HostAddress` is `any` and an 'ip'-option is present, the listening address\n  is set to the value of the 'ip'-option","ref":"ssh.html#daemon/3"},{"type":"function","title":"ssh.daemon_info/1","doc":"Equivalent to  daemon_info/2 .","ref":"ssh.html#daemon_info/1"},{"type":"function","title":"ssh.daemon_info/2","doc":"Returns information about a daemon intended for e.g debugging or logging.\n\nWhen the `Key` is a single `Item`, the result is a single `InfoTuple`\n\nNote that [`daemon_info/1`](`daemon_info/1`) and\n[`daemon_info/2`](`daemon_info/2`) returns different types due to compatibility\nreasons.","ref":"ssh.html#daemon_info/2"},{"type":"type","title":"ssh.daemon_info_tuple/0","doc":"Return values from the `daemon_info/1` and `daemon_info/2` functions.\n\n> #### Note {: .info }\n>\n> Note that `options` info tuple contains only items with nondefault values.","ref":"ssh.html#t:daemon_info_tuple/0"},{"type":"type","title":"ssh.daemon_option/0","doc":"Options for [daemons](`daemon/1`). The individual options are further explained\nbelow or by following the hyperlinks.\n\nNote that not every `t:gen_tcp:listen_option/0` is accepted. See\n`set_sock_opts/2` for a list of prohibited options.\n\nAlso note that setting a `t:gen_tcp:listen_option/0` could change the socket in\na way that impacts the ssh deamon's behaviour negatively. You use it on your own\nrisk.","ref":"ssh.html#t:daemon_option/0"},{"type":"type","title":"ssh.daemon_options/0","doc":"","ref":"ssh.html#t:daemon_options/0"},{"type":"opaque","title":"ssh.daemon_ref/0","doc":"Opaque data type representing a daemon.\n\nReturned by the functions [`daemon/1,2,3`](`daemon/1`).","ref":"ssh.html#t:daemon_ref/0"},{"type":"function","title":"ssh.daemon_replace_options/2","doc":"Replaces the options in a running daemon with the options in `NewUserOptions`.\nOnly connections established after this call are affected, already established\nconnections are not.\n\n> #### Note {: .info }\n>\n> In the final phase of this function, the listening process is restarted.\n> Therfore a connection attempt to the daemon in this final phase could fail.\n\nThe handling of Erlang configurations is described in the User's Guide; see\nchapters [Configuration in SSH](configurations.md) and\n[Configuring algorithms in SSH](configure_algos.md).","ref":"ssh.html#daemon_replace_options/2"},{"type":"function","title":"ssh.default_algorithms/0","doc":"Returns a key-value list, where the keys are the different types of algorithms\nand the values are the algorithms themselves.\n\nSee the [User's Guide](configure_algos.md#example_default_algorithms) for an\nexample.","ref":"ssh.html#default_algorithms/0"},{"type":"type","title":"ssh.deprecated_exec_opt/0","doc":"Old-style exec specification that are kept for compatibility, but should not be\nused in new programs","ref":"ssh.html#t:deprecated_exec_opt/0"},{"type":"type","title":"ssh.diffie_hellman_group_exchange_client_option/0","doc":"Sets the three diffie-hellman-group-exchange parameters that guides the\nconnected server in choosing a group. See\n[RFC 4419](https://tools.ietf.org/html/rfc4419) for the details. The default\nvalue is `{1024, 6144, 8192}`.","ref":"ssh.html#t:diffie_hellman_group_exchange_client_option/0"},{"type":"type","title":"ssh.diffie_hellman_group_exchange_daemon_option/0","doc":"","ref":"ssh.html#t:diffie_hellman_group_exchange_daemon_option/0"},{"type":"type","title":"ssh.disabled_cipher_alg/0","doc":"","ref":"ssh.html#t:disabled_cipher_alg/0"},{"type":"type","title":"ssh.disabled_mac_alg/0","doc":"","ref":"ssh.html#t:disabled_mac_alg/0"},{"type":"type","title":"ssh.disconnectfun_common_option/0","doc":"Provides a fun to implement your own logging or other handling at disconnects.","ref":"ssh.html#t:disconnectfun_common_option/0"},{"type":"type","title":"ssh.double_algs/1","doc":"List of algorithms to use in the algorithm negotiation. The default\n`t:algs_list/0` can be obtained from `default_algorithms/0`.\n\nIf an alg_entry() is missing in the algs_list(), the default value is used for\nthat entry.\n\nHere is an example of this option:\n\n```erlang\n\t  {preferred_algorithms,\n\t  [{public_key,['ssh-rsa','ssh-dss']},\n\t  {cipher,[{client2server,['aes128-ctr']},\n          {server2client,['aes128-cbc','3des-cbc']}]},\n\t  {mac,['hmac-sha2-256','hmac-sha1']},\n\t  {compression,[none,zlib]}\n\t  ]\n\t  }\n```\n\nThe example specifies different algorithms in the two directions (client2server\nand server2client), for cipher but specifies the same algorithms for mac and\ncompression in both directions. The kex (key exchange) is implicit but\npublic_key is set explicitly.\n\nFor background and more examples see the\n[User's Guide](configure_algos.md#introduction).\n\nIf an algorithm name occurs more than once in a list, the behaviour is\nundefined. The tags in the property lists are also assumed to occur at most one\ntime.\n\n> #### Warning {: .warning }\n>\n> Changing the values can make a connection less secure. Do not change unless\n> you know exactly what you are doing. If you do not understand the values then\n> you are not supposed to change them.","ref":"ssh.html#t:double_algs/1"},{"type":"type","title":"ssh.exec_daemon_option/0","doc":"","ref":"ssh.html#t:exec_daemon_option/0"},{"type":"type","title":"ssh.exec_fun/0","doc":"","ref":"ssh.html#t:exec_fun/0"},{"type":"type","title":"ssh.exec_fun/1/0","doc":"","ref":"ssh.html#t:exec_fun/1/0"},{"type":"type","title":"ssh.exec_fun/2/0","doc":"","ref":"ssh.html#t:exec_fun/2/0"},{"type":"type","title":"ssh.exec_fun/3/0","doc":"","ref":"ssh.html#t:exec_fun/3/0"},{"type":"type","title":"ssh.exec_result/0","doc":"This option changes how the daemon executes exec-requests from clients. The term\nin the return value is formatted to a string if it is a non-string type. No\ntrailing newline is added in the ok-case.\n\nSee the User's Guide section on\n[One-Time Execution](using_ssh.md#one-time-execution) for examples.\n\nError texts are returned on channel-type 1 which usually is piped to `stderr` on\ne.g Linux systems. Texts from a successful execution are returned on\nchannel-type 0 and will in similar manner be piped to `stdout`. The exit-status\ncode is set to 0 for success and 255 for errors. The exact results presented on\nthe client side depends on the client and the client's operating system.\n\nIn case of the `{direct, exec_fun()}` variant or no exec-option at all, all\nreads from `standard_input` will be from the received data-events of type 0.\nThose are sent by the client. Similarly all writes to `standard_output` will be\nsent as data-events to the client. An OS shell client like the command 'ssh'\nwill usually use stdin and stdout for the user interface.\n\nThe option cooperates with the daemon-option\n[`shell`](`t:shell_daemon_option/0`) in the following way:\n\n- **1\\. If neither the [`exec-option`](`t:exec_daemon_option/0`) nor the\n  [`shell-option`](`t:shell_daemon_option/0`) is present:** - The default Erlang\n  evaluator is used both for exec and shell requests. The result is returned to\n  the client.\n\n- **2\\. If the [`exec_spec`](`t:exec_daemon_option/0`)'s value is `disabled`\n  (the [`shell-option`](`t:shell_daemon_option/0`) may or may not be\n  present):** - No exec-requests are executed but shell-requests are not\n  affected, they follow the [`shell_spec`](`t:shell_daemon_option/0`)'s value.\n\n- **3\\. If the [`exec-option`](`t:exec_daemon_option/0`) is present and the\n  [`exec_spec`](`t:exec_daemon_option/0`) value =/= `disabled` (the\n  [`shell-option`](`t:shell_daemon_option/0`) may or may not be present):** -\n  The [`exec_spec`](`t:exec_daemon_option/0`) `fun()` is called with the same\n  number of parameters as the arity of the fun, and the result is returned to\n  the client. Shell-requests are not affected, they follow the\n  [`shell_spec`](`t:shell_daemon_option/0`)'s value.\n\n- **4\\. If the [`exec-option`](`t:exec_daemon_option/0`) is absent, and the\n  [`shell-option`](`t:shell_daemon_option/0`) is present with the default Erlang\n  shell as the [`shell_spec`](`t:shell_daemon_option/0`)'s value:** - The\n  default Erlang evaluator is used both for exec and shell requests. The result\n  is returned to the client.\n\n- **5\\. If the [`exec-option`](`t:exec_daemon_option/0`) is absent, and the\n  [`shell-option`](`t:shell_daemon_option/0`) is present with a value that is\n  neither the default Erlang shell nor the value `disabled`:** - The\n  exec-request is not evaluated and an error message is returned to the client.\n  Shell-requests are executed according to the value of the\n  [`shell_spec`](`t:shell_daemon_option/0`).\n\n- **6\\. If the [`exec-option`](`t:exec_daemon_option/0`) is absent, and the\n  [`shell_spec`](`t:shell_daemon_option/0`)'s value is `disabled`:** - Exec\n  requests are executed by the default shell, but shell-requests are not\n  executed.\n\nIf a custom CLI is installed (see the option\n[`ssh_cli`](`t:ssh_cli_daemon_option/0`)) the rules above are replaced by thoose\nimplied by the custom CLI.\n\n> #### Note {: .info }\n>\n> The [`exec-option`](`t:exec_daemon_option/0`) has existed for a long time but\n> has not previously been documented. The old definition and behaviour are\n> retained but obey the rules 1-6 above if conflicting. The old and undocumented\n> style should not be used in new programs.","ref":"ssh.html#t:exec_result/0"},{"type":"type","title":"ssh.exec_spec/0","doc":"","ref":"ssh.html#t:exec_spec/0"},{"type":"type","title":"ssh.experimental_client_options/0","doc":"Experimental options that should not to be used in products.","ref":"ssh.html#t:experimental_client_options/0"},{"type":"type","title":"ssh.experimental_common_options/0","doc":"Experimental options that should not to be used in products.","ref":"ssh.html#t:experimental_common_options/0"},{"type":"type","title":"ssh.experimental_daemon_options/0","doc":"Experimental options that should not to be used in products.","ref":"ssh.html#t:experimental_daemon_options/0"},{"type":"type","title":"ssh.explicit_group/0","doc":"","ref":"ssh.html#t:explicit_group/0"},{"type":"type","title":"ssh.explicit_group_file/0","doc":"","ref":"ssh.html#t:explicit_group_file/0"},{"type":"type","title":"ssh.fd_common_option/0","doc":"Allows an existing file-descriptor to be used (passed on to the transport\nprotocol).","ref":"ssh.html#t:fd_common_option/0"},{"type":"type","title":"ssh.fingerprint/0","doc":"","ref":"ssh.html#t:fingerprint/0"},{"type":"type","title":"ssh.fp_digest_alg/0","doc":"","ref":"ssh.html#t:fp_digest_alg/0"},{"type":"function","title":"ssh.get_sock_opts/2","doc":"Get tcp socket option values of the tcp-socket below an ssh connection.\n\nThis function calls the `inet:getopts/2`, read that documentation.","ref":"ssh.html#get_sock_opts/2"},{"type":"type","title":"ssh.hardening_daemon_options/0","doc":"For more information about hardening, see the [Hardening](hardening.md) section\nin the User's Guide chapter.\n\n- **`max_sessions`{: #hardening_daemon_options-max_sessions }** - The maximum\n  number of simultaneous sessions that are accepted at any time for this daemon.\n  This includes sessions that are being authorized. Thus, if set to `N`, and `N`\n  clients have connected but not started the login process, connection attempt\n  `N+1` is aborted. If `N` connections are authenticated and still logged in, no\n  more logins are accepted until one of the existing ones log out.\n\n  The counter is per listening port. Thus, if two daemons are started, one with\n  `{max_sessions,N}` and the other with `{max_sessions,M}`, in total `N+M`\n  connections are accepted for the whole `ssh` application.\n\n  Notice that if `parallel_login` is `false`, only one client at a time can be\n  in the authentication phase.\n\n  By default, this option is not set. This means that the number is not limited.\n\n- **`max_channels`{: #hardening_daemon_options-max_channels }** - The maximum\n  number of channels with active remote subsystem that are accepted for each\n  connection to this daemon\n\n  By default, this option is not set. This means that the number is not limited.\n\n- **`parallel_login`{: #hardening_daemon_options-parallel_login }** - If set to\n  false (the default value), only one login is handled at a time. If set to\n  true, an unlimited number of login attempts are allowed simultaneously.\n\n  If the `max_sessions` option is set to `N` and `parallel_login` is set to\n  `true`, the maximum number of simultaneous login attempts at any time is\n  limited to `N-K`, where `K` is the number of authenticated connections present\n  at this daemon.\n\n  > #### Warning {: .warning }\n  >\n  > Do not enable `parallel_logins` without protecting the server by other\n  > means, for example, by the `max_sessions` option or a firewall\n  > configuration. If set to `true`, there is no protection against DOS attacks.\n\n- **`minimal_remote_max_packet_size`{:\n  #hardening_daemon_options-minimal_remote_max_packet_size }** - The least\n  maximum packet size that the daemon will accept in channel open requests from\n  the client. The default value is 0.","ref":"ssh.html#t:hardening_daemon_options/0"},{"type":"type","title":"ssh.hello_timeout_daemon_option/0","doc":"Maximum time in milliseconds for the first part of the ssh session setup, the\nhello message exchange. Defaults to 30000 ms (30 seconds). If the client fails\nto send the first message within this time, the connection is closed.\n\nFor more information about timeouts, see the\n[Timeouts section ](hardening.md#timeouts)in the User's Guide\n[Hardening](hardening.md) chapter.","ref":"ssh.html#t:hello_timeout_daemon_option/0"},{"type":"type","title":"ssh.host/0","doc":"","ref":"ssh.html#t:host/0"},{"type":"type","title":"ssh.host_accepting_client_options/0","doc":"- **`silently_accept_hosts`{: #hardening_client_options-silently_accept_hosts\n  }** - This option guides the `connect` function on how to act when the\n  connected server presents a Host Key that the client has not seen before. The\n  default is to ask the user with a question on stdio of whether to accept or\n  reject the new Host Key. See the option\n  [`user_dir`](`t:ssh_file:user_dir_common_option/0`) for specifying the path to\n  the file `known_hosts` where previously accepted Host Keys are recorded. See\n  also the option [key_cb](`t:key_cb_common_option/0`) for the general way to\n  handle keys.\n\n  The option can be given in three different forms as seen\n  [above](`t:accept_hosts/0`):\n\n  - The value is a `t:boolean/0`. The value `true` will make the client accept\n    any unknown Host Key without any user interaction. The value `false`\n    preserves the default behaviour of asking the user on stdio.\n  - An `t:accept_callback/0` will be called and the boolean return value `true`\n    will make the client accept the Host Key. A return value of `false` will\n    make the client to reject the Host Key and as a result the connection will\n    be closed. The arguments to the fun are:\n    - `PeerName` \\- a string with the name or address of the remote host.\n    - `FingerPrint` \\- the fingerprint of the Host Key as\n      `hostkey_fingerprint/1` calculates it.\n  - A tuple `{HashAlgoSpec, accept_callback}`. The `HashAlgoSpec` specifies\n    which hash algorithm shall be used to calculate the fingerprint used in the\n    call of the `t:accept_callback/0`. The `HashALgoSpec` is either an atom or a\n    list of atoms as the first argument in `hostkey_fingerprint/2`. If it is a\n    list of hash algorithm names, the `FingerPrint` argument in the\n    `t:accept_callback/0` will be a list of fingerprints in the same order as\n    the corresponding name in the `HashAlgoSpec` list.\n\n- **`user_interaction`** - If `false`, disables the client to connect to the\n  server if any user interaction is needed, such as accepting the server to be\n  added to the `known_hosts` file, or supplying a password.\n\n  Even if user interaction is allowed it can be suppressed by other options,\n  such as `silently_accept_hosts` and `password`. However, those options are not\n  always desirable to use from a security point of view.\n\n  Defaults to `true`.\n\n- **`save_accepted_host`** - If `true`, the client saves an accepted host key to\n  avoid the accept question the next time the same host is connected. If the\n  option [`key_cb`](`t:key_cb_common_option/0`) is not present, the key is saved\n  in the file \"known_hosts\". See option\n  [`user_dir`](`t:ssh_file:user_dir_common_option/0`) for the location of that\n  file.\n\n  If `false`, the key is not saved and the key will still be unknown at the next\n  access of the same host.\n\n  Defaults to `true`\n\n- **`quiet_mode`** - If `true`, the client does not print anything on\n  authorization.\n\n  Defaults to `false`","ref":"ssh.html#t:host_accepting_client_options/0"},{"type":"function","title":"ssh.hostkey_fingerprint/1","doc":"Equivalent to  hostkey_fingerprint/2 .","ref":"ssh.html#hostkey_fingerprint/1"},{"type":"function","title":"ssh.hostkey_fingerprint/2","doc":"hostkey_fingerprint([DigestType], HostKey) ->\n[string()]hostkey_fingerprint(DigestType, HostKey) -> string()\n\nCalculates a ssh fingerprint from a public host key as openssh does.\n\nThe algorithm in [`hostkey_fingerprint/1`](`hostkey_fingerprint/1`) is md5 to be\ncompatible with older ssh-keygen commands. The string from the second variant is\nprepended by the algorithm name in uppercase as in newer ssh-keygen commands.\n\nExamples:\n\n```erlang\n 2> ssh:hostkey_fingerprint(Key).\n \"f5:64:a6:c1:5a:cb:9f:0a:10:46:a2:5c:3e:2f:57:84\"\n\n 3> ssh:hostkey_fingerprint(md5,Key).\n \"MD5:f5:64:a6:c1:5a:cb:9f:0a:10:46:a2:5c:3e:2f:57:84\"\n\n 4> ssh:hostkey_fingerprint(sha,Key).\n \"SHA1:bSLY/C4QXLDL/Iwmhyg0PGW9UbY\"\n\n 5> ssh:hostkey_fingerprint(sha256,Key).\n \"SHA256:aZGXhabfbf4oxglxltItWeHU7ub3Dc31NcNw2cMJePQ\"\n\n 6> ssh:hostkey_fingerprint([sha,sha256],Key).\n [\"SHA1:bSLY/C4QXLDL/Iwmhyg0PGW9UbY\",\n  \"SHA256:aZGXhabfbf4oxglxltItWeHU7ub3Dc31NcNw2cMJePQ\"]\n```","ref":"ssh.html#hostkey_fingerprint/2"},{"type":"type","title":"ssh.id_string_common_option/0","doc":"The string the daemon will present to a connecting peer initially. The default\nvalue is \"Erlang/VSN\" where VSN is the ssh application version number.\n\nThe value `random` will cause a random string to be created at each connection\nattempt. This is to make it a bit more difficult for a malicious peer to find\nthe ssh software brand and version.\n\nThe value `{random, Nmin, Nmax}` will make a random string with at least `Nmin`\ncharacters and at most `Nmax` characters.","ref":"ssh.html#t:id_string_common_option/0"},{"type":"type","title":"ssh.inet_common_option/0","doc":"IP version to use when the host address is specified as `any`.","ref":"ssh.html#t:inet_common_option/0"},{"type":"type","title":"ssh.ip_port/0","doc":"","ref":"ssh.html#t:ip_port/0"},{"type":"type","title":"ssh.kb_int_fun_3/0","doc":"","ref":"ssh.html#t:kb_int_fun_3/0"},{"type":"type","title":"ssh.kb_int_fun_4/0","doc":"","ref":"ssh.html#t:kb_int_fun_4/0"},{"type":"type","title":"ssh.kb_int_tuple/0","doc":"","ref":"ssh.html#t:kb_int_tuple/0"},{"type":"type","title":"ssh.kex_alg/0","doc":"","ref":"ssh.html#t:kex_alg/0"},{"type":"type","title":"ssh.key_cb_common_option/0","doc":"Module implementing the behaviour `m:ssh_client_key_api` and/or\n`m:ssh_server_key_api`. Can be used to customize the handling of public keys. If\ncallback options are provided along with the module name, they are made\navailable to the callback module via the options passed to it under the key\n'key_cb_private'.\n\nThe `Opts` defaults to `[]` when only the `Module` is specified.\n\nThe default value of this option is `{ssh_file, []}`. See also the manpage of\n`m:ssh_file`.\n\nA call to the call-back function `F` will be\n\n```text\n\t  Module:F(..., [{key_cb_private,Opts}|UserOptions])\n```\n\nwhere `...` are arguments to `F` as in `m:ssh_client_key_api` and/or\n`m:ssh_server_key_api`. The `UserOptions` are the options given to\n[ssh:connect](`connect/3`), [ssh:shell](`shell/1`) or [ssh:daemon](`daemon/2`).","ref":"ssh.html#t:key_cb_common_option/0"},{"type":"type","title":"ssh.legacy_cipher_alg/0","doc":"","ref":"ssh.html#t:legacy_cipher_alg/0"},{"type":"type","title":"ssh.legacy_kex_alg/0","doc":"","ref":"ssh.html#t:legacy_kex_alg/0"},{"type":"type","title":"ssh.legacy_mac_alg/0","doc":"","ref":"ssh.html#t:legacy_mac_alg/0"},{"type":"type","title":"ssh.legacy_pubkey_alg/0","doc":"","ref":"ssh.html#t:legacy_pubkey_alg/0"},{"type":"type","title":"ssh.limit_bytes/0","doc":"","ref":"ssh.html#t:limit_bytes/0"},{"type":"type","title":"ssh.limit_time/0","doc":"Sets the limit when rekeying is to be initiated. Both the max time and max\namount of data could be configured:\n\n- `{Minutes, Bytes}` initiate rekeying when any of the limits are reached.\n- `Bytes` initiate rekeying when `Bytes` number of bytes are transferred, or at\n  latest after one hour.\n\nWhen a rekeying is done, both the timer and the byte counter are restarted.\nDefaults to one hour and one GByte.\n\nIf `Minutes` is set to `infinity`, no rekeying will ever occur due to that max\ntime has passed. Setting `Bytes` to `infinity` will inhibit rekeying after a\ncertain amount of data has been transferred. If the option value is set to\n`{infinity, infinity}`, no rekeying will be initiated. Note that rekeying\ninitiated by the peer will still be performed.","ref":"ssh.html#t:limit_time/0"},{"type":"type","title":"ssh.mac_alg/0","doc":"","ref":"ssh.html#t:mac_alg/0"},{"type":"type","title":"ssh.max_idle_time_common_option/0","doc":"Sets a time-out on a connection when no channels are open. Defaults to\n`infinity`. The unit is milliseconds.\n\nThe timeout is not active until channels are started, so it does not limit the\ntime from the connection creation to the first channel opening.\n\nFor more information about timeouts, see the\n[Timeouts section ](hardening.md#timeouts)in the User's Guide\n[Hardening](hardening.md) chapter.","ref":"ssh.html#t:max_idle_time_common_option/0"},{"type":"type","title":"ssh.max_initial_idle_time_daemon_option/0","doc":"Maximum time in milliseconds for the first channel start after completion of the\nauthentication negotiation. Defaults to `infinity`.\n\nFor more information about timeouts, see the\n[Timeouts section ](hardening.md#timeouts)in the User's Guide\n[Hardening](hardening.md) chapter.","ref":"ssh.html#t:max_initial_idle_time_daemon_option/0"},{"type":"type","title":"ssh.max_log_item_len_common_option/0","doc":"Sets a limit for the size of a logged item excluding a header. The unit is bytes\nand the value defaults to 500.","ref":"ssh.html#t:max_log_item_len_common_option/0"},{"type":"type","title":"ssh.mod_args/0","doc":"","ref":"ssh.html#t:mod_args/0"},{"type":"type","title":"ssh.mod_fun_args/0","doc":"","ref":"ssh.html#t:mod_fun_args/0"},{"type":"type","title":"ssh.modify_algorithms_common_option/0","doc":"","ref":"ssh.html#t:modify_algorithms_common_option/0"},{"type":"type","title":"ssh.modify_algs_list/0","doc":"Modifies the list of algorithms to use in the algorithm negotiation. The\nmodifications are applied after the option `preferred_algorithms` (if existing)\nis applied.\n\nThe algorithm for modifications works like this:\n\n- Input is the `t:modify_algs_list/0` and a set of algorithms `A` obtained from\n  the `preferred_algorithms` option if existing, or else from the\n  [ssh:default_algorithms/0](`default_algorithms/0`).\n- The head of the `t:modify_algs_list/0` modifies `A` giving the result `A'`.\n\n  The possible modifications are:\n\n  - Append or prepend supported but not enabled algorithm(s) to the list of\n    algorithms. If the wanted algorithms already are in `A` they will first be\n    removed and then appended or prepended,\n  - Remove (rm) one or more algorithms from `A`.\n\n- Repeat the modification step with the tail of `t:modify_algs_list/0` and the\n  resulting `A'`.\n\nIf an unsupported algorithm is in the `t:modify_algs_list/0`, it will be\nsilently ignored\n\nIf there are more than one modify_algorithms options, the result is undefined.\n\nHere is an example of this option:\n\n```text\n\t  {modify_algorithms,\n\t  [{prepend, [{kex, ['diffie-hellman-group1-sha1']}],\n\t  {rm,      [{compression, [none]}]}\n\t  ]\n\t  }\n```\n\nThe example specifies that:\n\n- the old key exchange algorithm 'diffie-hellman-group1-sha1' should be the main\n  alternative. It will be the main alternative since it is prepened to the list\n- The compression algorithm none (= no compression) is removed so compression is\n  enforced\n\nFor background and more examples see the\n[User's Guide](configure_algos.md#introduction).","ref":"ssh.html#t:modify_algs_list/0"},{"type":"type","title":"ssh.negotiation_timeout_daemon_option/0","doc":"Maximum time in milliseconds for the authentication negotiation. Defaults to\n120000 ms (2 minutes). If the client fails to log in within this time, the\nconnection is closed.\n\nFor more information about timeouts, see the\n[Timeouts section ](hardening.md#timeouts)in the User's Guide\n[Hardening](hardening.md) chapter.","ref":"ssh.html#t:negotiation_timeout_daemon_option/0"},{"type":"type","title":"ssh.open_socket/0","doc":"The socket is supposed to be result of a [gen_tcp:connect](`gen_tcp:connect/3`)\nor a [gen_tcp:accept](`gen_tcp:accept/1`). The socket must be in passive mode\n(that is, opened with the option `{active,false})`.","ref":"ssh.html#t:open_socket/0"},{"type":"type","title":"ssh.pref_public_key_algs_common_option/0","doc":"List of user (client) public key algorithms to try to use.\n\nThe default value is the `public_key` entry in the list returned by\n[ssh:default_algorithms/0](`default_algorithms/0`).\n\nIf there is no public key of a specified type available, the corresponding entry\nis ignored. Note that the available set is dependent on the underlying cryptolib\nand current user's public keys.\n\nSee also the option [`user_dir`](`t:ssh_file:user_dir_common_option/0`) for\nspecifying the path to the user's keys.","ref":"ssh.html#t:pref_public_key_algs_common_option/0"},{"type":"type","title":"ssh.preferred_algorithms_common_option/0","doc":"","ref":"ssh.html#t:preferred_algorithms_common_option/0"},{"type":"type","title":"ssh.profile_common_option/0","doc":"Used together with `ip-address` and `port` to uniquely identify a ssh daemon.\nThis can be useful in a virtualized environment, where there can be more that\none server that has the same `ip-address` and `port`. If this property is not\nexplicitly set, it is assumed that the the `ip-address` and `port` uniquely\nidentifies the SSH daemon.","ref":"ssh.html#t:profile_common_option/0"},{"type":"type","title":"ssh.prompt_texts/0","doc":"","ref":"ssh.html#t:prompt_texts/0"},{"type":"type","title":"ssh.protocol_version/0","doc":"","ref":"ssh.html#t:protocol_version/0"},{"type":"type","title":"ssh.pubkey_alg/0","doc":"","ref":"ssh.html#t:pubkey_alg/0"},{"type":"type","title":"ssh.pwdfun_2/0","doc":"Equivalent to  pwdfun_4/0 .","ref":"ssh.html#t:pwdfun_2/0"},{"type":"type","title":"ssh.pwdfun_4/0","doc":"- **`auth_method_kb_interactive_data`** - Sets the text strings that the daemon\n  sends to the client for presentation to the user when using\n  `keyboard-interactive` authentication.\n\n  If the fun/3 or fun/4 is used, it is called when the actual authentication\n  occurs and may therefore return dynamic data like time, remote ip etc.\n\n  The parameter `Echo` guides the client about need to hide the password.\n\n  The default value is:\n  `{auth_method_kb_interactive_data, {\"SSH server\", \"Enter password for \\\"\"++User++\"\\\"\", \"password: \", false}>`\n\n- **`user_passwords`{: #option-user_passwords }** - Provides passwords for\n  password authentication. The passwords are used when someone tries to connect\n  to the server and public key user-authentication fails. The option provides a\n  list of valid usernames and the corresponding passwords.\n\n  > #### Warning {: .warning }\n  >\n  > Note that this is very insecure due to the plain-text passwords; it is\n  > intended for test purposes. Use the [`pwdfun`](`m:ssh#option-pwdfun`) option\n  > to handle the password checking instead.\n\n- **`pk_check_user`{: #option-pk_check_user }** - Enables checking of the\n  [client's user name](`t:authentication_client_options/0`) in the server when\n  doing public key authentication. It is disabled by default.\n\n  The term \"user\" is used differently in OpenSSH and SSH in Erlang/OTP: see more\n  in the [User's Guide](terminology.md#the-term-user).\n\n  If the option is enabled, and no [`pwdfun`](`m:ssh#option-pwdfun`) is present,\n  the user name must present in the\n  [user_passwords](`m:ssh#option-user_passwords`) for the check to succeed but\n  the value of the password is not checked.\n\n  In case of a [`pwdfun`](`m:ssh#option-pwdfun`) checking the user, the atom\n  `pubkey` is put in the password argument.\n\n- **`password`{: #option-password }** - Provides a global password that\n  authenticates any user.\n\n  > #### Warning {: .warning }\n  >\n  > Intended to facilitate testing.\n  >\n  > From a security perspective this option makes the server very vulnerable.\n\n- **`pwdfun`{: #option-pwdfun } with `t:pwdfun_4/0`** - Provides a function for\n  password validation. This could used for calling an external system or\n  handling passwords stored as hash values.\n\n  This fun can also be used to make delays in authentication tries for example\n  by calling `timer:sleep/1`.\n\n  To facilitate for instance counting of failed tries, the `State` variable\n  could be used. This state is per connection only. The first time the pwdfun is\n  called for a connection, the `State` variable has the value `undefined`.\n\n  The fun should return:\n\n  - `true` if the user and password is valid\n  - `false` if the user or password is invalid\n  - `disconnect` if a SSH_MSG_DISCONNECT message should be sent immediately. It\n    will be followed by a close of the underlying tcp connection.\n  - `{true, NewState:any()}` if the user and password is valid\n  - `{false, NewState:any()}` if the user or password is invalid\n\n  A third usage is to block login attempts from a missbehaving peer. The `State`\n  described above can be used for this. The return value `disconnect` is useful\n  for this.\n\n  In case of the [`pk_check_user`](`m:ssh#option-pk_check_user`) is set, the\n  atom `pubkey` is put in the password argument when validating a public key\n  login. The pwdfun is then responsible to check that the user name is valid.\n\n- **`pwdfun` with `t:pwdfun_2/0`** - Provides a function for password\n  validation. This function is called with user and password as strings, and\n  returns:\n\n  - `true` if the user and password is valid\n  - `false` if the user or password is invalid\n\n  In case of the [`pk_check_user`](`m:ssh#option-pk_check_user`) is set, the\n  atom `pubkey` is put in the password argument when validating a public key\n  login. The pwdfun is then responsible to check that the user name is valid.\n\n  This variant is kept for compatibility.\n\n- **`no_auth_needed`{: #option-no_auth_needed }** - If `true`, a client is\n  authenticated without any need of providing any password or key.\n\n  This option is only intended for very special applications due to the high\n  risk of accepting any connecting client.\n\n  The default value is `false`.","ref":"ssh.html#t:pwdfun_4/0"},{"type":"type","title":"ssh.recv_ext_info_client_option/0","doc":"Make the client tell the server that the client accepts extension negotiation,\nthat is, include `ext-info-c` in the kexinit message sent. See\n[RFC 8308](https://tools.ietf.org/html/rfc8308) for details and\n[ssh](ssh_app.md#supported-ext-info) for a list of currently implemented\nextensions.\n\nDefault value is `true` which is compatible with other implementations not\nsupporting ext-info.","ref":"ssh.html#t:recv_ext_info_client_option/0"},{"type":"type","title":"ssh.rekey_limit_common_option/0","doc":"","ref":"ssh.html#t:rekey_limit_common_option/0"},{"type":"type","title":"ssh.role/0","doc":"","ref":"ssh.html#t:role/0"},{"type":"type","title":"ssh.send_ext_info_daemon_option/0","doc":"Make the server (daemon) tell the client that the server accepts extension\nnegotiation, that is, include `ext-info-s` in the kexinit message sent. See\n[RFC 8308](https://tools.ietf.org/html/rfc8308) for details and\n[ssh](ssh_app.md#supported-ext-info) for a list of currently implemented\nextensions.\n\nDefault value is `true` which is compatible with other implementations not\nsupporting ext-info.","ref":"ssh.html#t:send_ext_info_daemon_option/0"},{"type":"function","title":"ssh.set_sock_opts/2","doc":"Sets tcp socket options on the tcp-socket below an ssh connection.\n\nThis function calls the `inet:setopts/2`, read that documentation and for\n`t:gen_tcp:option/0`.\n\nAll gen_tcp socket options except\n\n- `active`\n- `deliver`\n- `mode` and\n- `packet`\n\nare allowed. The excluded options are reserved by the SSH application.\n\n> #### Warning {: .warning }\n>\n> This is an extremely dangerous function. You use it on your own risk.\n>\n> Some options are OS and OS version dependent. Do not use it unless you know\n> what effect your option values will have on an TCP stream.\n>\n> Some values may destroy the functionality of the SSH protocol.","ref":"ssh.html#set_sock_opts/2"},{"type":"function","title":"ssh.shell/1","doc":"Equivalent to  shell/3 .","ref":"ssh.html#shell/1"},{"type":"function","title":"ssh.shell/2","doc":"Equivalent to  shell/3 .","ref":"ssh.html#shell/2"},{"type":"function","title":"ssh.shell/3","doc":"Connects to an SSH server at `Host` and `Port` (defaults to 22) and starts an\ninteractive shell on that remote host.\n\nAs an alternative, an already open TCP socket could be passed to the function in\n`TcpSocket`. The SSH initiation and negotiation will be initiated on that one\nand finally a shell will be started on the host at the other end of the TCP\nsocket.\n\nFor a description of the options, see [Client Options](`t:client_options/0`).\n\nThe function waits for user input, and does not return until the remote shell is\nended (that is, exit from the shell).","ref":"ssh.html#shell/3"},{"type":"type","title":"ssh.shell_daemon_option/0","doc":"Equivalent to  'shell_fun/2'/0 .","ref":"ssh.html#t:shell_daemon_option/0"},{"type":"type","title":"ssh.shell_fun/0","doc":"Equivalent to  'shell_fun/2'/0 .","ref":"ssh.html#t:shell_fun/0"},{"type":"type","title":"ssh.shell_fun/1/0","doc":"Equivalent to  'shell_fun/2'/0 .","ref":"ssh.html#t:shell_fun/1/0"},{"type":"type","title":"ssh.shell_fun/2/0","doc":"Defines the read-eval-print loop used in a daemon when a shell is requested by\nthe client. The default is to use the Erlang shell: `{shell, start, []}`\n\nSee the option [`exec-option`](`t:exec_daemon_option/0`) for a description of\nhow the daemon executes shell-requests and exec-requests depending on the shell-\nand exec-options.","ref":"ssh.html#t:shell_fun/2/0"},{"type":"type","title":"ssh.shell_spec/0","doc":"","ref":"ssh.html#t:shell_spec/0"},{"type":"type","title":"ssh.software_version/0","doc":"","ref":"ssh.html#t:software_version/0"},{"type":"opaque","title":"ssh.ssh_channel_id/0","doc":"","ref":"ssh.html#t:ssh_channel_id/0"},{"type":"type","title":"ssh.ssh_cli_daemon_option/0","doc":"Provides your own CLI implementation in a daemon.\n\nIt is a channel callback module that implements a shell and command execution.\nThe shell's read-eval-print loop can be customized, using the option\n[`shell`](`t:shell_daemon_option/0`). This means less work than implementing an\nown CLI channel. If `ssh_cli` is set to `no_cli`, the CLI channels like\n[`shell`](`t:shell_daemon_option/0`) and [`exec`](`t:exec_daemon_option/0`) are\ndisabled and only subsystem channels are allowed.","ref":"ssh.html#t:ssh_cli_daemon_option/0"},{"type":"opaque","title":"ssh.ssh_connection_ref/0","doc":"","ref":"ssh.html#t:ssh_connection_ref/0"},{"type":"opaque","title":"ssh.ssh_daemon_ref/0","doc":"","ref":"ssh.html#t:ssh_daemon_ref/0"},{"type":"type","title":"ssh.ssh_moduli_file/0","doc":"- **`dh_gex_groups`** - Defines the groups the server may choose among when\n  diffie-hellman-group-exchange is negotiated. See\n  [RFC 4419](https://tools.ietf.org/html/rfc4419) for details. The three\n  variants of this option are:\n\n  - **`{Size=integer(),G=integer(),P=integer()}`** - The groups are given\n    explicitly in this list. There may be several elements with the same `Size`.\n    In such a case, the server will choose one randomly in the negotiated Size.\n\n  - **`{file,filename()}`** - The file must have one or more three-tuples\n    `{Size=integer(),G=integer(),P=integer()}` terminated by a dot. The file is\n    read when the daemon starts.\n\n  - **`{ssh_moduli_file,filename()}`** - The file must be in\n    [ssh-keygen moduli file format](`public_key:dh_gex_group/4`). The file is\n    read when the daemon starts.\n\n  The default list is fetched from the [public_key](`public_key:dh_gex_group/4`)\n  application.\n\n- **`dh_gex_limits`** - Limits what a client can ask for in\n  diffie-hellman-group-exchange. The limits will be\n  `{MaxUsed = min(MaxClient,Max), MinUsed = max(MinClient,Min)}` where\n  `MaxClient` and `MinClient` are the values proposed by a connecting client.\n\n  The default value is `{0,infinity}`.\n\n  If `MaxUsed < MinUsed` in a key exchange, it will fail with a disconnect.\n\n  See [RFC 4419](https://tools.ietf.org/html/rfc4419) for the function of the\n  Max and Min values.","ref":"ssh.html#t:ssh_moduli_file/0"},{"type":"type","title":"ssh.ssh_msg_debug_fun_common_option/0","doc":"Provide a fun to implement your own logging of the SSH message SSH_MSG_DEBUG.\nThe last three parameters are from the message, see\n[RFC 4253, section 11.3](https://tools.ietf.org/html/rfc4253#section-11.3). The\n`t:connection_ref/0` is the reference to the connection on which the message\narrived. The return value from the fun is not checked.\n\nThe default behaviour is ignore the message. To get a printout for each message\nwith `AlwaysDisplay = true`, use for example\n`{ssh_msg_debug_fun, fun(_,true,M,_)-> io:format(\"DEBUG: ~p~n\", [M]) end}`","ref":"ssh.html#t:ssh_msg_debug_fun_common_option/0"},{"type":"function","title":"ssh.start/0","doc":"Equivalent to  start/1 .","ref":"ssh.html#start/0"},{"type":"function","title":"ssh.start/1","doc":"Utility function that starts the applications `crypto`, `public_key`, and `ssh`.\nDefault type is `temporary`. For more information, see the `m:application`\nmanual page in Kernel.","ref":"ssh.html#start/1"},{"type":"function","title":"ssh.stop/0","doc":"Stops the `ssh` application. For more information, see the `m:application`\nmanual page in Kernel.","ref":"ssh.html#stop/0"},{"type":"function","title":"ssh.stop_daemon/1","doc":"Equivalent to  stop_daemon/3 .","ref":"ssh.html#stop_daemon/1"},{"type":"function","title":"ssh.stop_daemon/2","doc":"Equivalent to  stop_daemon/3 .","ref":"ssh.html#stop_daemon/2"},{"type":"function","title":"ssh.stop_daemon/3","doc":"Stops the listener and all connections started by the listener.","ref":"ssh.html#stop_daemon/3"},{"type":"function","title":"ssh.stop_listener/1","doc":"Equivalent to  stop_listener/3 .","ref":"ssh.html#stop_listener/1"},{"type":"function","title":"ssh.stop_listener/2","doc":"Equivalent to  stop_listener/3 .","ref":"ssh.html#stop_listener/2"},{"type":"function","title":"ssh.stop_listener/3","doc":"Stops the listener, but leaves existing connections started by the listener\noperational.","ref":"ssh.html#stop_listener/3"},{"type":"type","title":"ssh.subsystem_daemon_option/0","doc":"","ref":"ssh.html#t:subsystem_daemon_option/0"},{"type":"type","title":"ssh.subsystem_spec/0","doc":"Defines a subsystem in the daemon.\n\nThe `subsystem_name` is the name that a client requests to start with for\nexample `ssh_connection:subsystem/4`.\n\nThe `channel_callback` is the module that implements the `m:ssh_server_channel`\n(replaces ssh_daemon_channel) behaviour in the daemon. See the section\n[Creating a Subsystem](using_ssh.md#usersguide_creating_a_subsystem) in the\nUser's Guide for more information and an example.\n\nIf the subsystems option is not present, the value of\n`ssh_sftpd:subsystem_spec([])` is used. This enables the sftp subsystem by\ndefault. The option can be set to the empty list if you do not want the daemon\nto run any subsystems.","ref":"ssh.html#t:subsystem_spec/0"},{"type":"type","title":"ssh.subsystem_specs/0","doc":"","ref":"ssh.html#t:subsystem_specs/0"},{"type":"function","title":"ssh.tcpip_tunnel_from_server/5","doc":"Equivalent to  tcpip_tunnel_from_server/6 .","ref":"ssh.html#tcpip_tunnel_from_server/5"},{"type":"function","title":"ssh.tcpip_tunnel_from_server/6","doc":"Asks the remote server of `ConnectionRef` to listen to `ListenHost:ListenPort`.\nWhen someone connects that address, the connection is forwarded in an encrypted\nchannel from the server to the client. The client (that is, at the node that\ncalls this function) then connects to `ConnectToHost:ConnectToPort`.\n\nThe returned `TrueListenPort` is the port that is listened to. It is the same as\n`ListenPort`, except when `ListenPort = 0`. In that case a free port is selected\nby the underlying OS.\n\nNote that in case of an Erlang/OTP SSH server (daemon) as peer, that server must\nhave been started with the option\n[tcpip_tunnel_out](`t:tcpip_tunnel_out_daemon_option/0`) to allow the\nconnection.","ref":"ssh.html#tcpip_tunnel_from_server/6"},{"type":"type","title":"ssh.tcpip_tunnel_in_daemon_option/0","doc":"Enables (`true`) or disables (`false`) the possibility to tunnel a TCP/IP\nconnection in to a [server](`daemon/2`). Disabled per default.\n\nSet `Callback` function to allow/deny/log tunnel connections.","ref":"ssh.html#t:tcpip_tunnel_in_daemon_option/0"},{"type":"type","title":"ssh.tcpip_tunnel_out_daemon_option/0","doc":"Enables (`true`) or disables (`false`) the possibility to tunnel a TCP/IP\nconnection out of a [server](`daemon/2`). Disabled per default.","ref":"ssh.html#t:tcpip_tunnel_out_daemon_option/0"},{"type":"function","title":"ssh.tcpip_tunnel_to_server/5","doc":"Equivalent to  tcpip_tunnel_to_server/6 .","ref":"ssh.html#tcpip_tunnel_to_server/5"},{"type":"function","title":"ssh.tcpip_tunnel_to_server/6","doc":"Tells the local client to listen to `ListenHost:ListenPort`. When someone\nconnects to that address, the connection is forwarded in an encrypted channel to\nthe peer server of `ConnectionRef`. That server then connects to\n`ConnectToHost:ConnectToPort`.\n\nThe returned `TrueListenPort` is the port that is listened to. It is the same as\n`ListenPort`, except when `ListenPort = 0`. In that case a free port is selected\nby the underlying OS.\n\nNote that in case of an Erlang/OTP SSH server (daemon) as peer, that server must\nhave been started with the option\n[tcpip_tunnel_in](`t:tcpip_tunnel_in_daemon_option/0`) to allow the connection.","ref":"ssh.html#tcpip_tunnel_to_server/6"},{"type":"type","title":"ssh.unexpectedfun_common_option/0","doc":"Provides a fun to implement your own logging or other action when an unexpected\nmessage arrives. If the fun returns `report` the usual info report is issued but\nif `skip` is returned no report is generated.","ref":"ssh.html#t:unexpectedfun_common_option/0"},{"type":"type","title":"ssh.version/0","doc":"","ref":"ssh.html#t:version/0"},{"type":"module","title":"ssh_agent","doc":"Callback module for using an SSH agent instead of the default ssh_file callback.\n\nThis module defines a callback handler for the communication with an\n[SSH Agent](https://tools.ietf.org/html/draft-miller-ssh-agent-02) and can be\nused to replace the [default callback](`m:ssh_file`). This allows to issue\nsigning requests to an agent that stores SSH private keys to perform\nauthentication.\n\nSsh_agent implements the `m:ssh_client_key_api`, to allow it to be used by\nsetting the option [`key_cb`](`t:ssh:key_cb_common_option/0`) when starting a\nclient (with for example [ssh:connect](`ssh:connect/3`),\n[ssh:shell](`ssh:shell/1`) ).\n\n```erlang\n      {key_cb, {ssh_agent, []}}\n```\n\nThe agent communication is established through a UNIX domain socket. By default,\nthe socket path will be fetched from the `SSH_AUTH_SOCK` environment variable,\nwhich is the default socket path in the agent implementation of\n[OpenSSH](http://www.openssh.com).\n\n[](){: #SOCKET_PATH } In order to set a different socket path the `socket_path`\noption can be set.\n\n```erlang\n      {key_cb, {ssh_agent, [{socket_path, SocketPath}]}}\n```\n\n> #### Note {: .info }\n>\n> The functions are _Callbacks_ for the SSH app. They are not intended to be\n> called from the user's code\\!","ref":"ssh_agent.html"},{"type":"function","title":"ssh_agent.add_host_key/3","doc":"Equivalent to  add_host_key/4 .","ref":"ssh_agent.html#add_host_key/3"},{"type":"function","title":"ssh_agent.add_host_key/4","doc":"This callback is delegated to the [ssh_file](`ssh_file:add_host_key/4`) module.","ref":"ssh_agent.html#add_host_key/4"},{"type":"type","title":"ssh_agent.call_ssh_file_option/0","doc":"The module which the `add_host_key` and `is_host_key` callbacks are delegated\nto. Defaults to the `m:ssh_file` module.","ref":"ssh_agent.html#t:call_ssh_file_option/0"},{"type":"function","title":"ssh_agent.is_host_key/4","doc":"Equivalent to  is_host_key/5 .","ref":"ssh_agent.html#is_host_key/4"},{"type":"function","title":"ssh_agent.is_host_key/5","doc":"This callback is delegated to the [ssh_file](`ssh_file:is_host_key/5`) module.","ref":"ssh_agent.html#is_host_key/5"},{"type":"type","title":"ssh_agent.socket_path_option/0","doc":"Sets the [socket path](`m:ssh_agent#SOCKET_PATH`) for the communication with the\nagent.","ref":"ssh_agent.html#t:socket_path_option/0"},{"type":"type","title":"ssh_agent.timeout_option/0","doc":"Sets the time-out in milliseconds when communicating with the agent via the\nsocket. The default value is `1000`.","ref":"ssh_agent.html#t:timeout_option/0"},{"type":"function","title":"ssh_agent.user_key/2","doc":"**Types and description**\n\nSee the api description in\n[ssh_client_key_api, Module:user_key/2](`c:ssh_client_key_api:user_key/2`).","ref":"ssh_agent.html#user_key/2"},{"type":"behaviour","title":"ssh_client_channel","doc":"SSH services (clients and servers) are implemented as channels that are\nmultiplexed over an SSH connection and communicates over the\n[SSH Connection Protocol](http://www.ietf.org/rfc/rfc4254.txt). This module\nprovides a callback API that takes care of generic channel aspects for clients,\nsuch as flow control and close messages. It lets the callback functions take\ncare of the service (application) specific parts. This behavior also ensures\nthat the channel process honors the principal of an OTP-process so that it can\nbe part of a supervisor tree. This is a requirement of channel processes\nimplementing a subsystem that will be added to the `ssh` applications supervisor\ntree.\n\n> #### Note {: .info }\n>\n> This module replaces ssh_channel.\n>\n> The old module is still available for compatibility, but should not be used\n> for new programs. The old module will not be maintained except for some error\n> corrections\n\n> #### Note {: .info }\n>\n> When implementing a `ssh` subsystem for daemons, use\n> [\\-behaviour(ssh_server_channel)](`m:ssh_server_channel`) (Replaces\n> ssh_daemon_channel) instead.\n\n> #### Dont {: .error }\n>\n> Functions in this module are not supposed to be called outside a module\n> implementing this behaviour\\!","ref":"ssh_client_channel.html"},{"type":"behaviour","title":"Callback timeouts - ssh_client_channel","doc":"The timeout values that can be returned by the callback functions have the same\nsemantics as in a `m:gen_server`. If the time-out occurs, `c:handle_msg/2` is called as\nhandle_msg(timeout, State).","ref":"ssh_client_channel.html#module-callback-timeouts"},{"type":"function","title":"ssh_client_channel.call/2","doc":"Equivalent to  call/3 .","ref":"ssh_client_channel.html#call/2"},{"type":"function","title":"ssh_client_channel.call/3","doc":"Makes a synchronous call to the channel process by sending a message and waiting\nuntil a reply arrives, or a time-out occurs. The channel calls\n[Module:handle_call/3](`c:handle_call/3`) to handle the message. If the channel\nprocess does not exist, `{error, closed}` is returned.","ref":"ssh_client_channel.html#call/3"},{"type":"function","title":"ssh_client_channel.cast/2","doc":"Sends an asynchronous message to the channel process and returns ok immediately,\nignoring if the destination node or channel process does not exist. The channel\ncalls [Module:handle_cast/2](`c:handle_cast/2`) to handle the message.","ref":"ssh_client_channel.html#cast/2"},{"type":"opaque","title":"ssh_client_channel.client/0","doc":"","ref":"ssh_client_channel.html#t:client/0"},{"type":"callback","title":"ssh_client_channel.code_change/3","doc":"Converts process state when code is changed.\n\nThis function is called by a client-side channel when it is to update its\ninternal state during a release upgrade or downgrade, that is, when the\ninstruction `{update,Module,Change,...}`, where `Change={advanced,Extra}`, is\ngiven in the `appup` file. For more information, refer to Section 9.11.6 Release\nHandling Instructions in the\n[System Documentation](`e:system:release_handling.md#instr`).\n\n> #### Note {: .info }\n>\n> Soft upgrade according to the OTP release concept is not straight forward for\n> the server side, as subsystem channel processes are spawned by the `ssh`\n> application and hence added to its supervisor tree. The subsystem channels can\n> be upgraded when upgrading the user application, if the callback functions can\n> handle two versions of the state, but this function cannot be used in the\n> normal way.","ref":"ssh_client_channel.html#c:code_change/3"},{"type":"function","title":"ssh_client_channel.enter_loop/1","doc":"Makes an existing process an `ssh_client_channel` (replaces ssh_channel)\nprocess.\n\nDoes not return, instead the calling process enters the\n`ssh_client_channel` (replaces ssh_channel) process receive loop and become an\n`ssh_client_channel` process. The process must have been started using one of\nthe start functions in `proc_lib`, see the `m:proc_lib` manual page in STDLIB.\nThe user is responsible for any initialization of the process and must call\n`init/1`.","ref":"ssh_client_channel.html#enter_loop/1"},{"type":"callback","title":"ssh_client_channel.handle_call/3","doc":"Handles messages sent by calling [call/2,3](`call/2`)\n\nFor more detailed information on time-outs,, see Section\n[Callback timeouts](`m:ssh_client_channel#module-callback-timeouts`).","ref":"ssh_client_channel.html#c:handle_call/3"},{"type":"callback","title":"ssh_client_channel.handle_cast/2","doc":"Handles messages sent by calling [`cast/2`](`cast/2`).\n\nFor more detailed information on time-outs, see Section\n[Callback timeouts](`m:ssh_client_channel#module-callback-timeouts`).","ref":"ssh_client_channel.html#c:handle_cast/2"},{"type":"callback","title":"ssh_client_channel.handle_msg/2","doc":"Handles other messages than SSH Connection Protocol, call, or cast messages sent\nto the channel.\n\nPossible Erlang 'EXIT' messages is to be handled by this function and all\nchannels are to handle the following message.\n\n- **`{ssh_channel_up,` `t:ssh:channel_id/0` `,` `t:ssh:connection_ref/0` `}`** -\n  This is the first message that the channel receives. It is sent just before\n  the `init/1` function returns successfully. This is especially useful if the\n  server wants to send a message to the client without first receiving a message\n  from it. If the message is not useful for your particular scenario, ignore it\n  by immediately returning `{ok, State}`.","ref":"ssh_client_channel.html#c:handle_msg/2"},{"type":"callback","title":"ssh_client_channel.handle_ssh_msg/2","doc":"Handles SSH Connection Protocol messages that may need service-specific\nattention. For details, see `t:ssh_connection:event/0`.\n\nThe following message is taken care of by the `ssh_client_channel` behavior.\n\n- **`{closed,` `t:ssh:channel_id/0` `}`** - The channel behavior sends a close\n  message to the other side, if such a message has not already been sent. Then\n  it terminates the channel with reason `normal`.","ref":"ssh_client_channel.html#c:handle_ssh_msg/2"},{"type":"callback","title":"ssh_client_channel.init/1","doc":"Makes necessary initializations and returns the initial channel state if the\ninitializations succeed.\n\nFor more detailed information on time-outs, see Section\n[Callback timeouts](`m:ssh_client_channel#module-callback-timeouts`).","ref":"ssh_client_channel.html#c:init/1"},{"type":"function","title":"ssh_client_channel.init/1","doc":"Initiates a client channel.\n\nThe following options must be present:\n\n- **`{channel_cb, atom()}`** - The module that implements the channel behaviour.\n\n- **`{init_args(), list()}`** - The list of arguments to the `init` function of\n  the callback module.\n\n- **`{cm,` `t:ssh:connection_ref/0` `}`** - Reference to the `ssh` connection as\n  returned by `ssh:connect/3`.\n\n- **`{channel_id,` `t:ssh:channel_id/0` `}`** - Id of the `ssh` channel as\n  returned by\n  [ssh_connection:session_channel/2,4](`ssh_connection:session_channel/2`).\n\n> #### Note {: .info }\n>\n> This function is normally not called by the user. The user only needs to call\n> if the channel process needs to be started with help of `proc_lib` instead of\n> calling [`start/4`](`start/4`) or [`start_link/4`](`start_link/4`).","ref":"ssh_client_channel.html#init/1"},{"type":"function","title":"ssh_client_channel.reply/2","doc":"This function can be used by a channel to send a reply to a client that called\n`call/[2,3]` when the reply cannot be defined in the return value of\n[Module:handle_call/3](`c:handle_call/3`).\n\n`Client` must be the `From` argument provided to the callback function\n[`handle_call/3`](`c:handle_call/3`). `Reply` is an arbitrary term, which is\ngiven back to the client as the return value of [call/\\[2,3].](`call/2`)","ref":"ssh_client_channel.html#reply/2"},{"type":"function","title":"ssh_client_channel.start/4","doc":"Equivalent to  start_link/4 .","ref":"ssh_client_channel.html#start/4"},{"type":"function","title":"ssh_client_channel.start_link/4","doc":"Starts a process that handles an SSH channel. It is called internally, by the\n`ssh` daemon, or explicitly by the `ssh` client implementations. The behavior\nsets the `trap_exit` flag to `true`.","ref":"ssh_client_channel.html#start_link/4"},{"type":"callback","title":"ssh_client_channel.terminate/2","doc":"This function is called by a channel process when it is about to terminate.\nBefore this function is called,\n[ssh_connection:close/2 ](`ssh_connection:close/2`)is called, if it has not been\ncalled earlier. This function does any necessary cleaning up. When it returns,\nthe channel process terminates with reason `Reason`. The return value is\nignored.","ref":"ssh_client_channel.html#c:terminate/2"},{"type":"behaviour","title":"ssh_client_key_api","doc":"\\-behaviour(ssh_client_key_api).\n\nBehavior describing the API for public key handling of an SSH client. By\nimplementing the callbacks defined in this behavior, the public key handling of\nan SSH client can be customized. By default the `ssh` application implements\nthis behavior with help of the standard OpenSSH files, see the\n[ssh](ssh_app.md) application manual.","ref":"ssh_client_key_api.html"},{"type":"callback","title":"ssh_client_key_api.add_host_key/3","doc":"This function is retired in favour for\n[`Module:add_host_key/4`](`c:add_host_key/4`) which is the preferred API\nfunction. The calling SSH application will still try the\n[`add_host_key/3`](`c:add_host_key/3`) if the call to\n[`add_host_key/4`](`c:add_host_key/4`) failed.\n\nAdds a host key to the set of trusted host keys.","ref":"ssh_client_key_api.html#c:add_host_key/3"},{"type":"callback","title":"ssh_client_key_api.add_host_key/4","doc":"Adds a host key to the set of trusted host keys.\n\nThis function is preferred to the old\n[`Module:add_host_key/3`](`c:add_host_key/3`) since it also uses the peer host\nport number and may return an error message.\n\nThe OTP/SSH application first calls this function in the callback module, and\nthen the old [`Module:add_host_key/3`](`c:add_host_key/3`) for compatibility.","ref":"ssh_client_key_api.html#c:add_host_key/4"},{"type":"type","title":"ssh_client_key_api.client_key_cb_options/1","doc":"Options provided to [ssh:connect/3,4](`ssh:connect/3`).\n\nThe option list given in the [`key_cb`](`t:ssh:key_cb_common_option/0`) option\nis available with the key `key_cb_private`.","ref":"ssh_client_key_api.html#t:client_key_cb_options/1"},{"type":"callback","title":"ssh_client_key_api.is_host_key/4","doc":"This function is retired in favour for\n[`Module:is_host_key/5`](`c:is_host_key/5`) which is the preferred API function.\nThe calling SSH application will still try the\n[`is_host_key/4`](`c:is_host_key/4`) if the call to\n[`is_host_key/5`](`c:is_host_key/5`) failed.\n\nChecks if a host key is trusted.","ref":"ssh_client_key_api.html#c:is_host_key/4"},{"type":"callback","title":"ssh_client_key_api.is_host_key/5","doc":"Checks if a host key is trusted.\n\nThis function is preferred to the old\n[`Module:is_host_key/4`](`c:is_host_key/4`) since it also uses the peer host\nport number and may return an error message.\n\nThe OTP/SSH application first calls this function in the callback module, and\nthen the old [`Module:is_host_key/4`](`c:is_host_key/4`) for compatibility.","ref":"ssh_client_key_api.html#c:is_host_key/5"},{"type":"callback","title":"ssh_client_key_api.sign/3","doc":"Sign the SigData with the _private_ key corresponding to PubKeyBlob.","ref":"ssh_client_key_api.html#c:sign/3"},{"type":"callback","title":"ssh_client_key_api.user_key/2","doc":"Fetches the users _public key_ matching the `Algorithm`. Some key callback\nmodules may return `{ssh2_pubkey, PubKeyBlob :: binary()}`.\n\n> #### Note {: .info }\n>\n> The private key contains the public key.","ref":"ssh_client_key_api.html#c:user_key/2"},{"type":"module","title":"ssh_connection","doc":"This module provides API functions to send SSH Connection Protocol events to the\nother side of an SSH channel.\n\nThe [SSH Connection Protocol (RFC 4254)](http://www.ietf.org/rfc/rfc4254.txt) is used by\nclients and servers, that is, SSH channels, to communicate over the SSH\nconnection. The API functions in this module send SSH Connection Protocol\nevents, which are received as messages by the remote channel handling the remote\nchannel. The Erlang format of thoose messages is (see also\n[below](`t:event/0`)):\n\n`{ssh_cm,` `t:ssh:connection_ref/0` `,` `t:channel_msg/0` `}`\n\nIf the `m:ssh_client_channel` behavior is used to implement the channel process,\nthese messages are handled by\n[handle_ssh_msg/2](`c:ssh_client_channel:handle_ssh_msg/2`).","ref":"ssh_connection.html"},{"type":"function","title":"ssh_connection.adjust_window/3","doc":"Adjusts the SSH flow control window. This is to be done by both the client- and\nserver-side channel processes.\n\n> #### Note {: .info }\n>\n> Channels implemented with the `m:ssh_client_channel` behavior do not normally\n> need to call this function as flow control is handled by the behavior. The\n> behavior adjusts the window every time the callback\n> [handle_ssh_msg/2](`c:ssh_client_channel:handle_ssh_msg/2`) returns after\n> processing channel data.","ref":"ssh_connection.html#adjust_window/3"},{"type":"type","title":"ssh_connection.channel_id/0","doc":"","ref":"ssh_connection.html#t:channel_id/0"},{"type":"type","title":"ssh_connection.channel_msg/0","doc":"As mentioned in the introduction, the\n[SSH Connection Protocol](https://tools.ietf.org/html/rfc4254) events are\nhandled as messages. When writing a channel handling process without using the\nsupport by the `m:ssh_client_channel` behavior the process must handle thoose\nmessages.","ref":"ssh_connection.html#t:channel_msg/0"},{"type":"function","title":"ssh_connection.close/2","doc":"A server- or client-channel process can choose to close their session by sending\na close event.\n\n> #### Note {: .info }\n>\n> This function is called by the `ssh_client_channel` behavior when the channel\n> is terminated, see `m:ssh_client_channel`. Thus, channels implemented with the\n> behavior are not to call this function explicitly.","ref":"ssh_connection.html#close/2"},{"type":"type","title":"ssh_connection.closed_ch_msg/0","doc":"This event is sent as a result of calling [ssh_connection:close/2](`close/2`).\nBoth the handling of this event and sending it are taken care of by the\n`m:ssh_client_channel` behavior.","ref":"ssh_connection.html#t:closed_ch_msg/0"},{"type":"type","title":"ssh_connection.connection_ref/0","doc":"","ref":"ssh_connection.html#t:connection_ref/0"},{"type":"type","title":"ssh_connection.data_ch_msg/0","doc":"Data has arrived on the channel. This event is sent as a result of calling\n[ssh_connection:send/3,4,5](`send/3`).","ref":"ssh_connection.html#t:data_ch_msg/0"},{"type":"type","title":"ssh_connection.env_ch_msg/0","doc":"Environment variables can be passed to the shell/command to be started later.\nThis event is sent as a result of calling [ssh_connection:setenv/5](`setenv/5`).","ref":"ssh_connection.html#t:env_ch_msg/0"},{"type":"type","title":"ssh_connection.eof_ch_msg/0","doc":"Indicates that the other side sends no more data. This event is sent as a result\nof calling [ssh_connection:send_eof/2](`send_eof/2`).","ref":"ssh_connection.html#t:eof_ch_msg/0"},{"type":"type","title":"ssh_connection.event/0","doc":"","ref":"ssh_connection.html#t:event/0"},{"type":"function","title":"ssh_connection.exec/4","doc":"Is to be called by a client-channel process to request that the server starts\nexecuting the given command. The result is several messages according to the\nfollowing pattern. The last message is a channel close message, as the `exec`\nrequest is a one-time execution that closes the channel when it is done.\n\n- **N x [data message(s)](`t:data_ch_msg/0`)** - The result of executing the\n  command can be only one line or thousands of lines depending on the command.\n\n- **0 or 1 x [eof message](`t:eof_ch_msg/0`)** - Indicates that no more data is\n  to be sent.\n\n- **0 or 1 x [exit signal message](`t:exit_signal_ch_msg/0`)** - Not all systems\n  send signals. For details on valid string values, see RFC 4254, Section 6.10\n\n- **0 or 1 x [exit status message](`t:exit_status_ch_msg/0`)** - It is\n  recommended by the SSH Connection Protocol to send this message, but that is\n  not always the case.\n\n- **1 x [closed status message](`t:closed_ch_msg/0`)** - Indicates that the\n  `ssh_client_channel` started for the execution of the command has now been\n  shut down.\n\nSee the User's Guide section on\n[One-Time Execution](using_ssh.md#one-time-execution) for examples.\n\n> #### Note {: .info }\n>\n> In case when command generates large amount of output data, manual\n> window adjustment might be necessary in order to receive it.\n> see [`ssh_connectino:adjust_window/3`](`adjust_window/3`)","ref":"ssh_connection.html#exec/4"},{"type":"type","title":"ssh_connection.exec_ch_msg/0","doc":"This message requests that the server starts execution of the given command.\nThis event is sent as a result of calling [ssh_connection:exec/4 ](`exec/4`).","ref":"ssh_connection.html#t:exec_ch_msg/0"},{"type":"type","title":"ssh_connection.exit_signal_ch_msg/0","doc":"A remote execution can terminate violently because of a signal. Then this\nmessage can be received. For details on valid string values, see\n[RFC 4254](https://tools.ietf.org/html/rfc4254#section-6.10) Section 6.10, which\nshows a special case of these signals.","ref":"ssh_connection.html#t:exit_signal_ch_msg/0"},{"type":"function","title":"ssh_connection.exit_status/3","doc":"Is to be called by a server-channel process to send the exit status of a command\nto the client.","ref":"ssh_connection.html#exit_status/3"},{"type":"type","title":"ssh_connection.exit_status_ch_msg/0","doc":"When the command running at the other end terminates, the following message can\nbe sent to return the exit status of the command. A zero `exit_status` usually\nmeans that the command terminated successfully. This event is sent as a result\nof calling [ssh_connection:exit_status/3](`exit_status/3`).","ref":"ssh_connection.html#t:exit_status_ch_msg/0"},{"type":"function","title":"ssh_connection.ptty_alloc/3","doc":"Equivalent to  ptty_alloc/4 .","ref":"ssh_connection.html#ptty_alloc/3"},{"type":"function","title":"ssh_connection.ptty_alloc/4","doc":"Sends an SSH Connection Protocol `pty_req`, to allocate a pseudo-terminal. Is to\nbe called by an SSH client process.\n\nOptions:\n\n- **\\{term, string()\\}** - Defaults to _os:getenv(\"TERM\")_ or _vt100_ if it is\n  undefined.\n\n- **\\{width, integer()\\}** - Defaults to 80 if `pixel_width` is not defined.\n\n- **\\{height, integer()\\}** - Defaults to 24 if `pixel_height` is not defined.\n\n- **\\{pixel_width, integer()\\}** - Is disregarded if `width` is defined.\n\n- **\\{pixel_height, integer()\\}** - Is disregarded if `height` is defined.\n\n- **\\{pty_opts, \\[\\{posix_atom(), integer()\\}]\\}** - Option can be an empty\n  list. Otherwise, see possible _POSIX_ names in Section 8 in\n  [RFC 4254](http://www.ietf.org/rfc/rfc4254.txt).","ref":"ssh_connection.html#ptty_alloc/4"},{"type":"type","title":"ssh_connection.pty_ch_msg/0","doc":"","ref":"ssh_connection.html#t:pty_ch_msg/0"},{"type":"type","title":"ssh_connection.reason/0","doc":"The result of a call.\n\nIf the request reached the peer, was handled and the response reached the\nrequesting node the `t:req_status/0` is the status reported from the peer.\n\nIf not, the `t:reason/0` indicates what went wrong:\n\n- **`closed`** - indicates that the channel or connection was closed when trying\n  to send the request\n\n- **`timeout`** - indicates that the operation exceeded a time limit","ref":"ssh_connection.html#t:reason/0"},{"type":"function","title":"ssh_connection.reply_request/4","doc":"Sends status replies to requests where the requester has stated that it wants a\nstatus report, that is, `WantReply = true`. If `WantReply` is `false`, calling\nthis function becomes a \"noop\". Is to be called while handling an SSH Connection\nProtocol message containing a `WantReply` boolean value.","ref":"ssh_connection.html#reply_request/4"},{"type":"type","title":"ssh_connection.req_status/0","doc":"The status of a request. Corresponds to the `SSH_MSG_CHANNEL_SUCCESS` and\n`SSH_MSG_CHANNEL_FAILURE` values in\n[RFC 4254, Section 5.4](https://tools.ietf.org/html/rfc4254#section-5.4).","ref":"ssh_connection.html#t:req_status/0"},{"type":"type","title":"ssh_connection.result/0","doc":"","ref":"ssh_connection.html#t:result/0"},{"type":"function","title":"ssh_connection.send/3","doc":"Equivalent to  send/5 .","ref":"ssh_connection.html#send/3"},{"type":"function","title":"ssh_connection.send/4","doc":"Depending on input arguments equivalent to one of `send/5` calls specified below.\n\nEquivalent to [send(ConnectionRef, ChannelId, 0, Data, TimeOut)](`send/5`) if\ncalled with TimeOut being integer.\n\nEquivalent to [send(ConnectionRef, ChannelId, 0, Data, infinity)](`send/5`) if\ncalled with TimeOut being infinity atom.\n\nEquivalent to [send(ConnectionRef, ChannelId, Type, Data, infinity)](`send/5`) if\ncalled with last argument which is not integer or infinity atom.","ref":"ssh_connection.html#send/4"},{"type":"function","title":"ssh_connection.send/5","doc":"Is to be called by client- and server-channel processes to send data to each\nother.\n\nThe function `subsystem/4` and subsequent calls of `send/3,4,5` must be executed\nin the same process.","ref":"ssh_connection.html#send/5"},{"type":"function","title":"ssh_connection.send_eof/2","doc":"Sends EOF on channel `ChannelId`.","ref":"ssh_connection.html#send_eof/2"},{"type":"function","title":"ssh_connection.session_channel/2","doc":"Equivalent to  session_channel/4 .","ref":"ssh_connection.html#session_channel/2"},{"type":"function","title":"ssh_connection.session_channel/4","doc":"Opens a channel for an SSH session. The channel id returned from this function\nis the id used as input to the other functions in this module.","ref":"ssh_connection.html#session_channel/4"},{"type":"function","title":"ssh_connection.setenv/5","doc":"Environment variables can be passed before starting the shell/command. Is to be\ncalled by a client channel processes.","ref":"ssh_connection.html#setenv/5"},{"type":"function","title":"ssh_connection.shell/2","doc":"Is to be called by a client channel process to request that the user default\nshell (typically defined in /etc/passwd in Unix systems) is executed at the\nserver end.\n\nNote: the return value is `ok` instead of `success` unlike in other functions in\nthis module. This is a fault that was introduced so long ago that any change\nwould break a large number of existing software.","ref":"ssh_connection.html#shell/2"},{"type":"type","title":"ssh_connection.shell_ch_msg/0","doc":"This message requests that the user default shell is started at the other end.\nThis event is sent as a result of calling [ssh_connection:shell/2](`shell/2`).","ref":"ssh_connection.html#t:shell_ch_msg/0"},{"type":"type","title":"ssh_connection.signal_ch_msg/0","doc":"A signal can be delivered to the remote process/service using the following\nmessage. Some systems do not support signals, in which case they are to ignore\nthis message. There is currently no function to generate this event as the\nsignals referred to are on OS-level and not something generated by an Erlang\nprogram.","ref":"ssh_connection.html#t:signal_ch_msg/0"},{"type":"type","title":"ssh_connection.ssh_data_type_code/0","doc":"The valid values are `0` (\"normal\") and `1` (\"stderr\"), see\n[RFC 4254, Section 5.2](https://tools.ietf.org/html/rfc4254#page-8).","ref":"ssh_connection.html#t:ssh_data_type_code/0"},{"type":"function","title":"ssh_connection.subsystem/4","doc":"Is to be called by a client-channel process for requesting to execute a\npredefined subsystem on the server.\n\nThe function [`subsystem/4`](`subsystem/4`) and subsequent calls of\n[send/3,4,5](`send/3`) must be executed in the same process.","ref":"ssh_connection.html#subsystem/4"},{"type":"type","title":"ssh_connection.term_mode/0","doc":"A pseudo-terminal has been requested for the session. `Terminal` is the value of\nthe TERM environment variable value, that is, `vt100`. Zero dimension parameters\nmust be ignored. The character/row dimensions override the pixel dimensions\n(when non-zero). Pixel dimensions refer to the drawable area of the window.\n`Opcode` in the `TerminalModes` list is the mnemonic name, represented as a\nlowercase Erlang atom, defined in\n[RFC 4254](https://tools.ietf.org/html/rfc4254#section/8), Section 8. It can\nalso be an `Opcode` if the mnemonic name is not listed in the RFC. Example:\n`OP code: 53, mnemonic name ECHO erlang atom: echo`. This event is sent as a\nresult of calling [ssh_connection:ptty_alloc/4](`ptty_alloc/4`).","ref":"ssh_connection.html#t:term_mode/0"},{"type":"type","title":"ssh_connection.want_reply/0","doc":"Messages that include a `WantReply` expect the channel handling process to call\n[ssh_connection:reply_request/4](`reply_request/4`) with the boolean value of\n`WantReply` as the second argument.","ref":"ssh_connection.html#t:want_reply/0"},{"type":"type","title":"ssh_connection.window_change_ch_msg/0","doc":"When the window (terminal) size changes on the client side, it _can_ send a\nmessage to the server side to inform it of the new dimensions. No API function\ngenerates this event.","ref":"ssh_connection.html#t:window_change_ch_msg/0"},{"type":"module","title":"ssh_file","doc":"Default callback module for the client's and server's database operations in the\nssh application\n\nThis module is the default callback handler for the client's and the server's\nuser and host \"database\" operations. All data, for instance key pairs, are\nstored in files in the normal file system. This page documents the files, where\nthey are stored and configuration options for this callback module.\n\nThe intention is to be compatible with the [OpenSSH](http://www.openssh.com)\nstorage in files. Therefore it mimics directories and filenames of\n[OpenSSH](http://www.openssh.com).\n\nSsh_file implements the `m:ssh_server_key_api` and the `m:ssh_client_key_api`.\nThis enables the user to make an own interface using for example a database\nhandler.\n\nSuch another callback module could be used by setting the option\n[`key_cb`](`t:ssh:key_cb_common_option/0`) when starting a client or a server\n(with for example [ssh:connect](`ssh:connect/3`), [ssh:daemon](`ssh:daemon/2`)\nof [ssh:shell](`ssh:shell/1`) ).\n\n> #### Note {: .info }\n>\n> The functions are _Callbacks_ for the SSH app. They are not intended to be\n> called from the user's code\\!","ref":"ssh_file.html"},{"type":"module","title":"Files, directories and who uses them - ssh_file","doc":"","ref":"ssh_file.html#module-files-directories-and-who-uses-them"},{"type":"module","title":"Daemons - ssh_file","doc":"Daemons uses all files stored in the [SYSDIR](`m:ssh_file#SYSDIR`) directory.\n\nOptionally, in case of `publickey` authorization, one or more of the remote\nuser's public keys in the [USERDIR](`m:ssh_file#USERDIR`) directory are used.\nSee the files [`USERDIR/authorized_keys`](`m:ssh_file#FILE-authorized_keys`) and\n[`USERDIR/authorized_keys2`](`m:ssh_file#FILE-authorized_keys2`).","ref":"ssh_file.html#module-daemons"},{"type":"module","title":"Clients - ssh_file","doc":"Clients uses all files stored in the [USERDIR](`m:ssh_file#USERDIR`) directory.","ref":"ssh_file.html#module-clients"},{"type":"module","title":"Directory contents - ssh_file","doc":"- **[](){: #LOCALUSER } LOCALUSER**  \n  The user name of the OS process running the Erlang virtual machine (emulator).\n\n- **[](){: #SYSDIR } SYSDIR**  \n  This is the directory holding the server's files:\n\n  - [](){: #FILE-ssh_host_STAR_key } `ssh_host_dsa_key`{: #FILE-ssh_host_dsa_key\n    } \\- private dss host key (optional)\n  - `ssh_host_rsa_key`{: #FILE-ssh_host_rsa_key } \\- private rsa host key\n    (optional)\n  - `ssh_host_ecdsa_key`{: #FILE-ssh_host_ecdsa_key } \\- private ecdsa host key\n    (optional)\n  - `ssh_host_ed25519_key`{: #FILE-ssh_host_ed25519_key } \\- private eddsa host\n    key for curve 25519 (optional)\n  - `ssh_host_ed448_key`{: #FILE-ssh_host_ed448_key } \\- private eddsa host key\n    for curve 448 (optional)\n\n  The key files could be generated with OpenSSH's ssh-keygen command.\n\n  At least one host key must be defined. The default value of SYSDIR is\n  `/etc/ssh`{: ##/etc/ssh }.\n\n  For security reasons, this directory is normally accessible only to the root\n  user.\n\n  To change the SYSDIR, see the [system_dir](`t:system_dir_daemon_option/0`)\n  option.\n\n- **[](){: #USERDIR } USERDIR**  \n  This is the directory holding the files:\n\n  - `authorized_keys`{: #FILE-authorized_keys } and, as second alternative\n    `authorized_keys2`{: #FILE-authorized_keys2 } \\- the user's public keys are\n    stored concatenated in one of those files.\n\n    It is composed of lines as for\n    [OpenSSH](https://man.openbsd.org/sshd#AUTHORIZED_KEYS_FILE_FORMAT):\n\n    ```text\n    (options)? keytype base64-encoded-key comment\n    ```\n\n    where\n\n    ```text\n    options :: option(,option)*\n    option :: % All options are skipped\n    keytype :: 'ssh-dsa'\n             | 'ssh-rsa'\n             | 'ssh-ecdsa-nistp256'\n    \t | 'ssh-ecdsa-nistp384'\n             | 'ssh-ecdsa-nistp521'\n             | 'ssh-ed25519'\n    \t | 'ssh-ed448'\n    base64-encoded-key :: % The user's public key\n    comment :: % Comments are skipped\n    ```\n\n  - `known_hosts`{: #FILE-known_hosts } \\- host keys from hosts visited\n    concatenated. The file is created and used by the client.\n\n    It is composed of lines as for\n    [OpenSSH](https://man.openbsd.org/sshd#SSH_KNOWN_HOSTS_FILE_FORMAT):\n\n    ```text\n    (option)? pattern(,pattern)* keytype key (comment)?\n    ```\n\n    where\n\n    ```text\n    option :: '@revoked'\n    pattern :: host | '[' host ']:' port\n    host :: ip-address | hostname | '*'\n    port :: portnumber | '*'\n    keytype :: 'ssh-dsa'\n             | 'ssh-rsa'\n             | 'ssh-ecdsa-nistp256'\n    \t | 'ssh-ecdsa-nistp384'\n             | 'ssh-ecdsa-nistp521'\n             | 'ssh-ed25519'\n    \t | 'ssh-ed448'\n    key :: % encoded key from eg ssh_host_*.pub\n    ```\n\n  - [](){: #FILE-id_STAR } `id_dsa`{: #FILE-id_dsa } \\- private dss user key\n    (optional)\n  - `id_rsa`{: #FILE-id_rsa } \\- private rsa user key (optional)\n  - `id_ecdsa`{: #FILE-id_ecdsa } \\- private ecdsa user key (optional)\n  - `id_ed25519`{: #FILE-id_ed25519 } \\- private eddsa user key for curve 25519\n    (optional)\n  - `id_ed448`{: #FILE-id_ed448 } \\- private eddsa user key for curve 448\n    (optional)\n\n  The key files could be generated with OpenSSH's ssh-keygen command.\n\n  The default value of USERDIR is\n  `/home/`[`LOCALUSER`](`m:ssh_file#LOCALUSER`)`/.ssh`.\n\n  To change the USERDIR, see the [user_dir](`t:user_dir_common_option/0`) option","ref":"ssh_file.html#module-directory-contents"},{"type":"function","title":"ssh_file.add_host_key/4","doc":"**Types and description**\n\nSee the api description in\n[ssh_client_key_api, Module:add_host_key/4](`c:ssh_client_key_api:add_host_key/4`).\n\n[](){: #add_host_key-3 }\n\nNote that the alternative, the old\n[Module:add_host_key/3](`c:ssh_client_key_api:add_host_key/3`) is no longer\nsupported by `ssh_file`.\n\n**Option**\n\n- [user_dir](`t:user_dir_common_option/0`)\n\n**File**\n\n- [`USERDIR/known_hosts`](`m:ssh_file#FILE-known_hosts`)","ref":"ssh_file.html#add_host_key/4"},{"type":"function","title":"ssh_file.decode/2","doc":"Decodes an SSH file-binary.\n\nIf `Type` is `public_key` the binary can be either an RFC4716 public key or an\nOpenSSH public key.\n\n> #### Note {: .info }\n>\n> The implementation of the `openssh_key_v1` format is still experimental.","ref":"ssh_file.html#decode/2"},{"type":"function","title":"ssh_file.encode/2","doc":"Encodes a list of SSH file entries (public keys and attributes) to a binary.\n\n> #### Note {: .info }\n>\n> The implementation of the `openssh_key_v1` format is still experimental.","ref":"ssh_file.html#encode/2"},{"type":"type","title":"ssh_file.experimental_openssh_key_v1/0","doc":"","ref":"ssh_file.html#t:experimental_openssh_key_v1/0"},{"type":"function","title":"ssh_file.extract_public_key/1","doc":"Fetches the public key from a private key.","ref":"ssh_file.html#extract_public_key/1"},{"type":"function","title":"ssh_file.host_key/2","doc":"**Types and description**\n\nSee the api description in\n[ssh_server_key_api, Module:host_key/2](`c:ssh_server_key_api:host_key/2`).\n\n**Options**\n\n- [system_dir](`t:system_dir_daemon_option/0`)\n\n**Files**\n\n- [`SYSDIR/ssh_host_rsa_key`](`m:ssh_file#FILE-ssh_host_rsa_key`)\n- [`SYSDIR/ssh_host_dsa_key`](`m:ssh_file#FILE-ssh_host_dsa_key`)\n- [`SYSDIR/ssh_host_ecdsa_key`](`m:ssh_file#FILE-ssh_host_ecdsa_key`)\n- [`SYSDIR/ssh_host_ed25519_key`](`m:ssh_file#FILE-ssh_host_ed25519_key`)\n- [`SYSDIR/ssh_host_ed448_key`](`m:ssh_file#FILE-ssh_host_ed448_key`)","ref":"ssh_file.html#host_key/2"},{"type":"function","title":"ssh_file.is_auth_key/3","doc":"**Types and description**\n\nSee the api description in\n[ssh_server_key_api: Module:is_auth_key/3](`c:ssh_server_key_api:is_auth_key/3`).\n\n**Options**\n\n- [user_dir_fun](`t:user_dir_fun_common_option/0`)\n- [user_dir](`t:user_dir_common_option/0`)\n\n**Files**\n\n- [`USERDIR/authorized_keys`](`m:ssh_file#FILE-authorized_keys`)\n- [`USERDIR/authorized_keys2`](`m:ssh_file#FILE-authorized_keys2`)\n\nThis functions discards all options in the beginning of the lines of thoose\nfiles when reading them.","ref":"ssh_file.html#is_auth_key/3"},{"type":"function","title":"ssh_file.is_host_key/5","doc":"**Types and description**\n\nSee the api description in\n[ssh_client_key_api, Module:is_host_key/5](`c:ssh_client_key_api:is_host_key/5`).\n\n[](){: #is_host_key-4 }\n\nNote that the alternative, the old\n[Module:is_host_key/4](`c:ssh_client_key_api:is_host_key/4`) is no longer\nsupported by `ssh_file`.\n\n**Option**\n\n- [user_dir](`t:user_dir_common_option/0`)\n\n**File**\n\n- [`USERDIR/known_hosts`](`m:ssh_file#FILE-known_hosts`)","ref":"ssh_file.html#is_host_key/5"},{"type":"type","title":"ssh_file.key/0","doc":"The key representation","ref":"ssh_file.html#t:key/0"},{"type":"type","title":"ssh_file.openssh_key_v1_attributes/0","doc":"Types for the experimental implementaition of the `openssh_key_v1` format.","ref":"ssh_file.html#t:openssh_key_v1_attributes/0"},{"type":"type","title":"ssh_file.optimize_key_lookup/0","doc":"Make the handling of large files fast by setting `time`, but this will use more\nmemory. The `space` variant shrinks the memory requirements, but with a higher\ntime consumption.\n\nTo set it, set the option `{key_cb, {ssh_file, [{optimize,TimeOrSpace}]}` in the\ncall of [\"ssh:connect/3](`ssh:connect/3`), `ssh:daemon/2` or similar function\ncall that initiates an ssh connection.","ref":"ssh_file.html#t:optimize_key_lookup/0"},{"type":"type","title":"ssh_file.pubkey_passphrase_client_options/0","doc":"If the user's DSA, RSA or ECDSA key is protected by a passphrase, it can be\nsupplied with those options.\n\nNote that EdDSA passhrases (Curves 25519 and 448) are not implemented.","ref":"ssh_file.html#t:pubkey_passphrase_client_options/0"},{"type":"type","title":"ssh_file.system_dir_daemon_option/0","doc":"Sets the [system directory](`m:ssh_file#SYSDIR`).","ref":"ssh_file.html#t:system_dir_daemon_option/0"},{"type":"type","title":"ssh_file.user2dir/0","doc":"Sets the [user directory](`m:ssh_file#USERDIR`) dynamically by evaluating the\n`user2dir` function.","ref":"ssh_file.html#t:user2dir/0"},{"type":"type","title":"ssh_file.user_dir_common_option/0","doc":"Sets the [user directory](`m:ssh_file#USERDIR`).","ref":"ssh_file.html#t:user_dir_common_option/0"},{"type":"type","title":"ssh_file.user_dir_fun_common_option/0","doc":"","ref":"ssh_file.html#t:user_dir_fun_common_option/0"},{"type":"function","title":"ssh_file.user_key/2","doc":"**Types and description**\n\nSee the api description in\n[ssh_client_key_api, Module:user_key/2](`c:ssh_client_key_api:user_key/2`).\n\n**Options**\n\n- [user_dir](`t:user_dir_common_option/0`)\n- [dsa_pass_phrase](`t:pubkey_passphrase_client_options/0`)\n- [rsa_pass_phrase](`t:pubkey_passphrase_client_options/0`)\n- [ecdsa_pass_phrase](`t:pubkey_passphrase_client_options/0`)\n\nNote that EdDSA passhrases (Curves 25519 and 448) are not implemented.\n\n**Files**\n\n- [`USERDIR/id_dsa`](`m:ssh_file#FILE-id_dsa`)\n- [`USERDIR/id_rsa`](`m:ssh_file#FILE-id_rsa`)\n- [`USERDIR/id_ecdsa`](`m:ssh_file#FILE-id_ecdsa`)\n- [`USERDIR/id_ed25519`](`m:ssh_file#FILE-id_ed25519`)\n- [`USERDIR/id_ed448`](`m:ssh_file#FILE-id_ed448`)","ref":"ssh_file.html#user_key/2"},{"type":"behaviour","title":"ssh_server_channel","doc":"\\-behaviour(ssh_server_channel). (Replaces ssh_daemon_channel)\n\n> #### Note {: .info }\n>\n> This module replaces ssh_daemon_channel.\n>\n> The old module is still available for compatibility, but should not be used\n> for new programs. The old module will not be maintained except for some error\n> corrections\n\nSSH services (clients and servers) are implemented as channels that are\nmultiplexed over an SSH connection and communicates over the\n[SSH Connection Protocol](http://www.ietf.org/rfc/rfc4254.txt). This module\nprovides a callback API that takes care of generic channel aspects for daemons,\nsuch as flow control and close messages. It lets the callback functions take\ncare of the service (application) specific parts. This behavior also ensures\nthat the channel process honors the principal of an OTP-process so that it can\nbe part of a supervisor tree. This is a requirement of channel processes\nimplementing a subsystem that will be added to the `ssh` applications supervisor\ntree.\n\n> #### Note {: .info }\n>\n> When implementing a client subsystem handler, use\n> [\\-behaviour(ssh_client_channel)](`m:ssh_client_channel`) instead.","ref":"ssh_server_channel.html"},{"type":"callback","title":"ssh_server_channel.handle_msg/2","doc":"Handles other messages than SSH Connection Protocol, call, or cast messages sent\nto the channel.\n\nPossible Erlang 'EXIT' messages is to be handled by this function and all\nchannels are to handle the following message.\n\n- **`{ssh_channel_up,` `t:ssh:channel_id/0` `,` `t:ssh:connection_ref/0` `}`** -\n  This is the first message that the channel receives. This is especially useful\n  if the server wants to send a message to the client without first receiving a\n  message from it. If the message is not useful for your particular scenario,\n  ignore it by immediately returning `{ok, State}`.","ref":"ssh_server_channel.html#c:handle_msg/2"},{"type":"callback","title":"ssh_server_channel.handle_ssh_msg/2","doc":"Handles SSH Connection Protocol messages that may need service-specific\nattention. For details, see `t:ssh_connection:event/0`.\n\nThe following message is taken care of by the `ssh_server_channel` behavior.\n\n- **`{closed,` `t:ssh:channel_id/0` `}`** - The channel behavior sends a close\n  message to the other side, if such a message has not already been sent. Then\n  it terminates the channel with reason `normal`.","ref":"ssh_server_channel.html#c:handle_ssh_msg/2"},{"type":"callback","title":"ssh_server_channel.init/1","doc":"Makes necessary initializations and returns the initial channel state if the\ninitializations succeed.\n\nThe time-out values that can be returned have the same semantics as in a\n`m:gen_server`. If the time-out occurs, `c:handle_msg/2` is called as\n[`handle_msg(timeout, State)`](`c:handle_msg/2`).","ref":"ssh_server_channel.html#c:init/1"},{"type":"callback","title":"ssh_server_channel.terminate/2","doc":"This function is called by a channel process when it is about to terminate.\nBefore this function is called,\n[ssh_connection:close/2 ](`ssh_connection:close/2`)is called, if it has not been\ncalled earlier. This function does any necessary cleaning up. When it returns,\nthe channel process terminates with reason `Reason`. The return value is\nignored.","ref":"ssh_server_channel.html#c:terminate/2"},{"type":"behaviour","title":"ssh_server_key_api","doc":"\\-behaviour(ssh_server_key_api).\n\nBehaviour describing the API for public key handling of an SSH server. By\nimplementing the callbacks defined in this behavior, the public key handling of\nan SSH server can be customized. By default the SSH application implements this\nbehavior with help of the standard OpenSSH files, see the [ssh](ssh_app.md)\napplication manual.","ref":"ssh_server_key_api.html"},{"type":"type","title":"ssh_server_key_api.daemon_key_cb_options/1","doc":"Options provided to [ssh:daemon/2,3](`ssh:daemon/2`).\n\nThe option list given in the [`key_cb`](`t:ssh:key_cb_common_option/0`) option\nis available with the key `key_cb_private`.","ref":"ssh_server_key_api.html#t:daemon_key_cb_options/1"},{"type":"callback","title":"ssh_server_key_api.host_key/2","doc":"Fetches the private key of the host.","ref":"ssh_server_key_api.html#c:host_key/2"},{"type":"callback","title":"ssh_server_key_api.is_auth_key/3","doc":"Checks if the user key is authorized.","ref":"ssh_server_key_api.html#c:is_auth_key/3"},{"type":"module","title":"ssh_sftp","doc":"SFTP client.\n\nThis module implements an SSH FTP (SFTP) client. SFTP is a secure, encrypted\nfile transfer service available for SSH.","ref":"ssh_sftp.html"},{"type":"function","title":"ssh_sftp.apread/4","doc":"The [`apread/4`](`apread/4`) function reads from a specified position, combining\nthe `position/3` and `aread/3` functions.","ref":"ssh_sftp.html#apread/4"},{"type":"function","title":"ssh_sftp.apwrite/4","doc":"The [`apwrite/4`](`apwrite/4`) function writes to a specified position,\ncombining the `position/3` and `awrite/3` functions.","ref":"ssh_sftp.html#apwrite/4"},{"type":"function","title":"ssh_sftp.aread/3","doc":"Reads from an open file, without waiting for the result. If the handle is valid,\nthe function returns `{async, N}`, where `N` is a term guaranteed to be unique\nbetween calls of `aread`. The actual data is sent as a message to the calling\nprocess. This message has the form `{async_reply, N, Result}`, where `Result` is\nthe result from the read, either `{ok, Data}`, `eof`, or `{error, reason()}`.","ref":"ssh_sftp.html#aread/3"},{"type":"function","title":"ssh_sftp.awrite/3","doc":"Writes to an open file, without waiting for the result. If the handle is valid,\nthe function returns `{async, N}`, where `N` is a term guaranteed to be unique\nbetween calls of `awrite`. The result of the `write` operation is sent as a\nmessage to the calling process. This message has the form\n`{async_reply, N, Result}`, where `Result` is the result from the write, either\n`ok`, or `{error, reason()}`.","ref":"ssh_sftp.html#awrite/3"},{"type":"type","title":"ssh_sftp.chunk_size/0","doc":"","ref":"ssh_sftp.html#t:chunk_size/0"},{"type":"function","title":"ssh_sftp.close/2","doc":"Equivalent to  close/3 .","ref":"ssh_sftp.html#close/2"},{"type":"function","title":"ssh_sftp.close/3","doc":"Closes a handle to an open file or directory on the server.","ref":"ssh_sftp.html#close/3"},{"type":"type","title":"ssh_sftp.crypto_fun/0","doc":"","ref":"ssh_sftp.html#t:crypto_fun/0"},{"type":"type","title":"ssh_sftp.crypto_result/0","doc":"The initial `t:crypto_state/0` returned from the `t:init_fun/0` is folded into\nrepeated applications of the `t:crypto_fun/0` in the\n[tar_crypto_spec](`t:tar_crypto_spec/0`). The binary returned from that fun is\nsent to the remote SFTP server and the new `t:crypto_state/0` is used in the\nnext call of the `t:crypto_fun/0`.\n\nIf the `t:crypto_fun/0` reurns a `t:chunk_size/0`, that value is as block size\nfor further blocks in calls to `t:crypto_fun/0`.","ref":"ssh_sftp.html#t:crypto_result/0"},{"type":"type","title":"ssh_sftp.crypto_state/0","doc":"The `t:init_fun/0` in the [tar_crypto_spec](`t:tar_crypto_spec/0`) is applied\nonce prior to any other `crypto` operation. The intention is that this function\ninitiates the encryption or decryption for example by calling\n`crypto:crypto_init/4` or similar. The `t:crypto_state/0` is the state such a\nfunction may return.\n\nIf the selected cipher needs to have the input data partitioned into blocks of a\ncertain size, the `t:init_fun/0` should return the second form of return value\nwith the `t:chunk_size/0` set to the block size. If the `t:chunk_size/0` is\n`undefined`, the size of the `PlainBin`s varies, because this is intended for\nstream crypto, whereas a fixed `t:chunk_size/0` is intended for block crypto. A\n`t:chunk_size/0` can be changed in the return from the `t:crypto_fun/0`. The\nvalue can be changed between `t:pos_integer/0` and `undefined`.","ref":"ssh_sftp.html#t:crypto_state/0"},{"type":"type","title":"ssh_sftp.decrypt_spec/0","doc":"Specifies the encryption or decryption applied to tar files when using\n`open_tar/3` or `open_tar/4`.\n\nThe encryption or decryption is applied to the generated stream of bytes prior\nto sending the resulting stream to the SFTP server.\n\nFor code examples see Section\n[Example with encryption](using_ssh.md#example-with-encryption) in the ssh Users\nGuide.","ref":"ssh_sftp.html#t:decrypt_spec/0"},{"type":"function","title":"ssh_sftp.del_dir/2","doc":"Equivalent to  del_dir/3 .","ref":"ssh_sftp.html#del_dir/2"},{"type":"function","title":"ssh_sftp.del_dir/3","doc":"Deletes a directory specified by `Name`. The directory must be empty before it\ncan be successfully deleted.","ref":"ssh_sftp.html#del_dir/3"},{"type":"function","title":"ssh_sftp.delete/2","doc":"Equivalent to  delete/3 .","ref":"ssh_sftp.html#delete/2"},{"type":"function","title":"ssh_sftp.delete/3","doc":"Deletes the file specified by `Name`.","ref":"ssh_sftp.html#delete/3"},{"type":"type","title":"ssh_sftp.encrypt_spec/0","doc":"","ref":"ssh_sftp.html#t:encrypt_spec/0"},{"type":"type","title":"ssh_sftp.final_fun/0","doc":"If doing encryption, the `t:final_fun/0` in the\n[tar_crypto_spec](`t:tar_crypto_spec/0`) is applied to the last piece of data.\nThe `t:final_fun/0` is responsible for padding (if needed) and encryption of\nthat last piece.","ref":"ssh_sftp.html#t:final_fun/0"},{"type":"type","title":"ssh_sftp.init_fun/0","doc":"","ref":"ssh_sftp.html#t:init_fun/0"},{"type":"function","title":"ssh_sftp.list_dir/2","doc":"Equivalent to  list_dir/3 .","ref":"ssh_sftp.html#list_dir/2"},{"type":"function","title":"ssh_sftp.list_dir/3","doc":"Lists the given directory on the server, returning the filenames as a list of\nstrings.","ref":"ssh_sftp.html#list_dir/3"},{"type":"function","title":"ssh_sftp.make_dir/2","doc":"Equivalent to  make_dir/3 .","ref":"ssh_sftp.html#make_dir/2"},{"type":"function","title":"ssh_sftp.make_dir/3","doc":"Creates a directory specified by `Name`. `Name` must be a full path to a new\ndirectory. The directory can only be created in an existing directory.","ref":"ssh_sftp.html#make_dir/3"},{"type":"function","title":"ssh_sftp.make_symlink/3","doc":"Equivalent to  make_symlink/4 .","ref":"ssh_sftp.html#make_symlink/3"},{"type":"function","title":"ssh_sftp.make_symlink/4","doc":"Creates a symbolic link pointing to `Target` with the name `Name`.","ref":"ssh_sftp.html#make_symlink/4"},{"type":"function","title":"ssh_sftp.open/3","doc":"Equivalent to  open/4 .","ref":"ssh_sftp.html#open/3"},{"type":"function","title":"ssh_sftp.open/4","doc":"Opens a file on the server and returns a handle, which can be used for reading\nor writing.","ref":"ssh_sftp.html#open/4"},{"type":"function","title":"ssh_sftp.open_tar/3","doc":"Equivalent to  open_tar/4 .","ref":"ssh_sftp.html#open_tar/3"},{"type":"function","title":"ssh_sftp.open_tar/4","doc":"Opens a handle to a tar file on the server, associated with `ChannelPid`. The\nhandle can be used for remote tar creation and extraction. The actual writing\nand reading is performed by calls to [erl_tar:add/3,4](`erl_tar:add/3`) and\n`erl_tar:extract/2`. Note: The `erl_tar:init/3` function should not be called,\nthat one is called by this open_tar function.\n\nFor code examples see Section\n[SFTP Client with TAR Compression](using_ssh.md#sftp-client-with-tar-compression)\nin the ssh Users Guide.\n\nThe `crypto` mode option is explained in the data types section above, see\n[Crypto operations for open_tar](`m:ssh_sftp#types-crypto-open_tar`).\nEncryption is assumed if the `Mode` contains `write`, and decryption if the\n`Mode` contains `read`.","ref":"ssh_sftp.html#open_tar/4"},{"type":"function","title":"ssh_sftp.opendir/2","doc":"Equivalent to  opendir/3 .","ref":"ssh_sftp.html#opendir/2"},{"type":"function","title":"ssh_sftp.opendir/3","doc":"Opens a handle to a directory on the server. The handle can be used for reading\ndirectory contents.","ref":"ssh_sftp.html#opendir/3"},{"type":"function","title":"ssh_sftp.position/3","doc":"Equivalent to  position/4 .","ref":"ssh_sftp.html#position/3"},{"type":"function","title":"ssh_sftp.position/4","doc":"Sets the file position of the file referenced by `Handle`. Returns\n`{ok, NewPosition}` (as an absolute offset) if successful, otherwise\n`{error, reason()}`. `Location` is one of the following:\n\n- **`Offset`** - The same as `{bof, Offset}`.\n\n- **`{bof, Offset}`** - Absolute offset.\n\n- **`{cur, Offset}`** - Offset from the current position.\n\n- **`{eof, Offset}`** - Offset from the end of file.\n\n- **`bof | cur | eof`** - The same as eariler with `Offset` 0, that is, `{bof, 0} | {cur, 0} | {eof, 0}`.","ref":"ssh_sftp.html#position/4"},{"type":"function","title":"ssh_sftp.pread/4","doc":"Equivalent to  pread/5 .","ref":"ssh_sftp.html#pread/4"},{"type":"function","title":"ssh_sftp.pread/5","doc":"The `pread/3,4` function reads from a specified position, combining the\n`position/3` and [`read/3,4`](`read/3`) functions.","ref":"ssh_sftp.html#pread/5"},{"type":"function","title":"ssh_sftp.pwrite/4","doc":"Equivalent to  pwrite/5 .","ref":"ssh_sftp.html#pwrite/4"},{"type":"function","title":"ssh_sftp.pwrite/5","doc":"The `pwrite/3,4` function writes to a specified position, combining the\n`position/3` and [`write/3,4`](`write/3`) functions.","ref":"ssh_sftp.html#pwrite/5"},{"type":"function","title":"ssh_sftp.read/3","doc":"Equivalent to  read/4 .","ref":"ssh_sftp.html#read/3"},{"type":"function","title":"ssh_sftp.read/4","doc":"Reads `Len` bytes from the file referenced by `Handle`. Returns `{ok, Data}`,\n`eof`, or `{error, reason()}`. If the file is opened with `binary`, `Data` is a\nbinary, otherwise it is a string.\n\nIf the file is read past `eof`, only the remaining bytes are read and returned.\nIf no bytes are read, `eof` is returned.","ref":"ssh_sftp.html#read/4"},{"type":"function","title":"ssh_sftp.read_file/2","doc":"Equivalent to  read_file/3 .","ref":"ssh_sftp.html#read_file/2"},{"type":"function","title":"ssh_sftp.read_file/3","doc":"Reads a file from the server, and returns the data in a binary.","ref":"ssh_sftp.html#read_file/3"},{"type":"function","title":"ssh_sftp.read_file_info/2","doc":"Equivalent to  read_file_info/3 .","ref":"ssh_sftp.html#read_file_info/2"},{"type":"function","title":"ssh_sftp.read_file_info/3","doc":"Returns a `file_info` record from the file system object specified by `Name` or\n`Handle`. See `file:read_file_info/2` for information about the record.\n\nDepending on the underlying OS:es links might be followed and info on the final\nfile, directory etc is returned. See `read_link_info/2` on how to get\ninformation on links instead.","ref":"ssh_sftp.html#read_file_info/3"},{"type":"function","title":"ssh_sftp.read_link/2","doc":"Equivalent to  read_link/3 .","ref":"ssh_sftp.html#read_link/2"},{"type":"function","title":"ssh_sftp.read_link/3","doc":"Reads the link target from the symbolic link specified by `name`.","ref":"ssh_sftp.html#read_link/3"},{"type":"function","title":"ssh_sftp.read_link_info/2","doc":"Equivalent to  read_link_info/3 .","ref":"ssh_sftp.html#read_link_info/2"},{"type":"function","title":"ssh_sftp.read_link_info/3","doc":"Returns a `file_info` record from the symbolic link specified by `Name` or\n`Handle`. See `file:read_link_info/2` for information about the record.","ref":"ssh_sftp.html#read_link_info/3"},{"type":"type","title":"ssh_sftp.reason/0","doc":"A description of the reason why an operation failed.\n\nThe `t:atom/0` value is formed from the sftp error codes in the protocol-level\nresponses as defined in\n[draft-ietf-secsh-filexfer-13](https://tools.ietf.org/html/draft-ietf-secsh-filexfer-13#page-49)\nsection 9.1. The codes are named as `SSH_FX_*` which are transformed into\nlowercase of the star-part. E.g. the error code `SSH_FX_NO_SUCH_FILE` will cause\nthe `t:reason/0` to be `no_such_file`.\n\nThe `t:string/0` reason is the error information from the server in case of an\nexit-signal. If that information is empty, the reason is the exit signal name.\n\nThe `t:tuple/0` reason are other errors like for example `{exit_status,1}`.","ref":"ssh_sftp.html#t:reason/0"},{"type":"function","title":"ssh_sftp.rename/3","doc":"Equivalent to  rename/4 .","ref":"ssh_sftp.html#rename/3"},{"type":"function","title":"ssh_sftp.rename/4","doc":"Renames a file named `OldName` and gives it the name `NewName`.","ref":"ssh_sftp.html#rename/4"},{"type":"type","title":"ssh_sftp.sftp_option/0","doc":"Specifies available SFTP options.","ref":"ssh_sftp.html#t:sftp_option/0"},{"type":"function","title":"ssh_sftp.start_channel/1","doc":"Equivalent to  start_channel/2 .","ref":"ssh_sftp.html#start_channel/1"},{"type":"function","title":"ssh_sftp.start_channel/2","doc":"Starts new ssh channel for communicating with the SFTP server.\n\nStarts an ssh channel when first argument is a connection reference.\n\nEquivalent to [start_channel(Host, 22, UserOptions)](`start_channel/3`) when\nfirst argument is recognized as network host.\n\nOtherwise, first argument is treated as a network socket which will be used for\nestablishing new SSH connection. New connection reference will be used for\nstarting an SSH channel.\n\nThe returned `pid` for this process is to be used as input to all other API\nfunctions in this module.\n\nSee also (`start_channel/3`).","ref":"ssh_sftp.html#start_channel/2"},{"type":"function","title":"ssh_sftp.start_channel/3","doc":"Starts new ssh connection and channel for communicating with the SFTP server.\n\nThe returned `pid` for this process is to be\nused as input to all other API functions in this module.\n\nOptions:\n\n- **`{timeout, timeout()}`** - There are two ways to set a timeout for the\n  underlying ssh connection:\n\n  - If the connection timeout option `connect_timeout` is set, that value is\n    used also for the negotiation timeout and this option (`timeout`) is\n    ignored.\n  - Otherwise, this option (`timeout`) is used as the negotiation timeout only\n    and there is no connection timeout set\n\n  The value defaults to `infinity`.\n\n- **`{sftp_vsn, integer()}`** - Desired SFTP protocol version. The actual\n  version is the minimum of the desired version and the maximum supported\n  versions by the SFTP server.\n\nAll other options are directly passed to [ssh:connect/3](`m:ssh`) or ignored if\na connection is already provided.","ref":"ssh_sftp.html#start_channel/3"},{"type":"function","title":"ssh_sftp.stop_channel/1","doc":"Stops an SFTP channel. Does not close the SSH connection. Use `ssh:close/1` to\nclose it.","ref":"ssh_sftp.html#stop_channel/1"},{"type":"type","title":"ssh_sftp.tar_crypto_spec/0","doc":"","ref":"ssh_sftp.html#t:tar_crypto_spec/0"},{"type":"function","title":"ssh_sftp.write/3","doc":"Equivalent to  write/4 .","ref":"ssh_sftp.html#write/3"},{"type":"function","title":"ssh_sftp.write/4","doc":"Writes `data` to the file referenced by `Handle`. The file is to be opened with\n`write` or `append` flag. Returns `ok` if successful or `{error, reason()}`\notherwise.","ref":"ssh_sftp.html#write/4"},{"type":"function","title":"ssh_sftp.write_file/3","doc":"Equivalent to  write_file/4 .","ref":"ssh_sftp.html#write_file/3"},{"type":"function","title":"ssh_sftp.write_file/4","doc":"Writes a file to the server. The file is created if it does not exist but\noverwritten if it exists.","ref":"ssh_sftp.html#write_file/4"},{"type":"function","title":"ssh_sftp.write_file_info/3","doc":"Equivalent to  write_file_info/4 .","ref":"ssh_sftp.html#write_file_info/3"},{"type":"function","title":"ssh_sftp.write_file_info/4","doc":"Writes file information from a `file_info` record to the file specified by\n`Name`. See [file:write_file_info/2,3](`file:write_file_info/2`) for\ninformation about the record.","ref":"ssh_sftp.html#write_file_info/4"},{"type":"module","title":"ssh_sftpd","doc":"Specifies the channel process to handle an SFTP subsystem.\n\nSpecifies a channel process to handle an SFTP subsystem.","ref":"ssh_sftpd.html"},{"type":"function","title":"ssh_sftpd.subsystem_spec/1","doc":"Is to be used together with `ssh:daemon/[1,2,3]`\n\nThe `Name` is `\"sftp\"` and `CbMod` is the name of the Erlang module implementing\nthe subsystem using the `m:ssh_server_channel` (replaces ssh_daemon_channel)\nbehaviour.\n\nOptions:\n\n- **`cwd`** - Sets the initial current working directory for the server.\n\n- **`file_handler`** - Determines which module to call for accessing the file\n  server. The default value is `ssh_sftpd_file`, which uses the `m:file` and\n  `m:filelib` APIs to access the standard OTP file server. This option can be\n  used to plug in other file servers.\n\n- **`max_files`** - The default value is `0`, which means that there is no upper\n  limit. If supplied, the number of filenames returned to the SFTP client per\n  `READDIR` request is limited to at most the given value.\n\n- **`max_handles`** - The default value is `1000`. Positive integer\n  value represents the maximum number of file handles allowed for a\n  connection.\n\n  (Note: separate limitation might be also enforced by underlying\n  operating system)\n\n- **`max_path`** - The default value is `4096`. Positive integer value\n    represents the maximum path length which cannot be exceeded in\n    data provided by the SFTP client. (Note: limitations might be also\n    enforced by underlying operating system)\n\n- **`root`** - Sets the SFTP root directory. Then the user cannot see any files\n  above this root. If, for example, the root directory is set to `/tmp`, then\n  the user sees this directory as `/`. If the user then writes `cd /etc`, the\n  user moves to `/tmp/etc`.\n\n- **`sftpd_vsn`** - Sets the SFTP version to use. Defaults to 5. Version 6 is\n  under development and limited.","ref":"ssh_sftpd.html#subsystem_spec/1"},{"type":"extras","title":"SSH Application","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SSH Application\n\nThe ssh application implements the Secure Shell (SSH) protocol and provides an\nSSH File Transfer Protocol (SFTP) client and server.","ref":"ssh_app.html"},{"type":"extras","title":"Description - SSH Application","doc":"The `ssh` application is an implementation of the SSH protocol in Erlang. `ssh`\noffers API functions to write customized SSH clients and servers as well as\nmaking the Erlang shell available over SSH. An SFTP client, `ssh_sftp`, and\nserver, `ssh_sftpd`, are also included.","ref":"ssh_app.html#description"},{"type":"extras","title":"Dependencies - SSH Application","doc":"The `ssh` application uses the applications `m:public_key` and `m:crypto` to\nhandle public keys and encryption. Hence, these applications must be loaded for\nthe `ssh` application to work. The call `ssh:start/0` will do the necessary\ncalls to [application:start/1,2](`application:start/1`) before it starts the\n`ssh` itself.","ref":"ssh_app.html#dependencies"},{"type":"extras","title":"Configuration - SSH Application","doc":"The SSH application uses Configuration Parameters. Where to set them are\ndescribed in [config User's Guide](`e:kernel:config.md`) with SSH details in\n[Configuration in SSH](configurations.md).\n\nSome special configuration files from OpenSSH are also used:\n\n- `known_hosts`\n- `authorized_keys`\n- `authorized_keys2`\n- `id_dsa` _(supported but disabled by default)_\n- `id_rsa` _(SHA1 sign/verify are supported but disabled by default from\n  OTP-24)_\n- `id_ecdsa`\n- `id_ed25519`\n- `id_ed448`\n- `ssh_host_dsa_key` _(supported but disabled by default)_\n- `ssh_host_rsa_key` _(SHA1 sign/verify are supported but disabled by default\n  from OTP-24)_\n- `ssh_host_ecdsa_key`\n- `ssh_host_ed25519_key`\n- `ssh_host_ed448_key`\n\nBy default, `ssh` looks for `id_*`, `known_hosts`, and `authorized_keys` in\n`~/.ssh`, and for the ssh\\_host\\_\\*\\_key files in `/etc/ssh`. These locations can\nbe changed by the options [`user_dir`](`t:ssh_file:user_dir_common_option/0`)\nand [`system_dir`](`t:ssh_file:system_dir_daemon_option/0`). More about where to\nset them is described in [Configuration in SSH](configurations.md).\n\nPublic key handling can also be customized through a callback module that\nimplements the behaviors `m:ssh_client_key_api` and `m:ssh_server_key_api`.\n\nSee also the default callback module documentation in `m:ssh_file`.\n\nDisabled public key algorithms can be enabled with the\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) options. See\n[Example 9](configure_algos.md#example-9) in\n[Configuring algorithms in SSH](configure_algos.md) for a description.","ref":"ssh_app.html#configuration"},{"type":"extras","title":"Public Keys - SSH Application","doc":"`id_*` are the users private key files. Notice that the public key is part of\nthe private key so the `ssh` application does not use the `id_*.pub` files.\nThese are for the user's convenience when it is needed to convey the user's\npublic key.\n\nSee [ssh_file](`m:ssh_file#FILE-id_STAR`) for details.","ref":"ssh_app.html#public-keys"},{"type":"extras","title":"Known Hosts - SSH Application","doc":"The `known_hosts` file contains a list of approved servers and their public\nkeys. Once a server is listed, it can be verified without user interaction.\n\nSee [ssh_file](`m:ssh_file#FILE-known_hosts`) for details.","ref":"ssh_app.html#known-hosts"},{"type":"extras","title":"Authorized Keys - SSH Application","doc":"The `authorized_key` file keeps track of the user's authorized public keys. The\nmost common use of this file is to let users log in without entering their\npassword, which is supported by the Erlang `ssh` daemon.\n\nSee [ssh_file](`m:ssh_file#FILE-authorized_keys`) for details.","ref":"ssh_app.html#authorized-keys"},{"type":"extras","title":"Host Keys - SSH Application","doc":"RSA, DSA (if enabled), ECDSA, ED25519 and ED448 host keys are supported and are\nexpected to be found in files named `ssh_host_rsa_key`, `ssh_host_dsa_key`,\n`ssh_host_ecdsa_key`, `ssh_host_ed25519_key` and `ssh_host_ed448_key`.\n\nSee [ssh_file](`m:ssh_file#FILE-ssh_host_STAR_key`) for details.","ref":"ssh_app.html#host-keys"},{"type":"extras","title":"Error Logger and Event Handlers - SSH Application","doc":"The `ssh` application uses the default [OTP error logger](`m:error_logger`) to\nlog unexpected errors or print information about special events.\n\n[](){: #supported }","ref":"ssh_app.html#error-logger-and-event-handlers"},{"type":"extras","title":"Supported Specifications and Standards - SSH Application","doc":"The supported SSH version is 2.0.","ref":"ssh_app.html#supported-specifications-and-standards"},{"type":"extras","title":"Algorithms - SSH Application","doc":"The actual set of algorithms may vary depending on which OpenSSL crypto library\nthat is installed on the machine. For the list on a particular installation, use\nthe command `ssh:default_algorithms/0`. The user may override the default\nalgorithm configuration both on the server side and the client side. See the\noptions [preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) and\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) in the\n[ssh:daemon/1,2,3](`ssh:daemon/1`) and [ssh:connect/3,4](`ssh:connect/3`)\nfunctions.\n\nSupported algorithms are (in the default order):\n\n[](){: #supported_algos }\n\n**Key exchange algorithms**\n\n- curve25519-sha256\n- curve25519-sha256@libssh.org\n- curve448-sha512\n- ecdh-sha2-nistp521\n- ecdh-sha2-nistp384\n- ecdh-sha2-nistp256\n- diffie-hellman-group-exchange-sha256\n- diffie-hellman-group16-sha512\n- diffie-hellman-group18-sha512\n- diffie-hellman-group14-sha256\n\nThe following unsecure `SHA1` algorithms are now disabled by default:\n\n- (diffie-hellman-group14-sha1)\n- (diffie-hellman-group-exchange-sha1)\n- (diffie-hellman-group1-sha1)\n\nThey can be enabled with the\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) options. Use\nfor example the Option value\n`{modify_algorithms, [{append, [{kex,['diffie-hellman-group1-sha1']}]}]}`)\n\n**Public key algorithms**\n\n- ssh-ed25519\n- ssh-ed448\n- ecdsa-sha2-nistp521\n- ecdsa-sha2-nistp384\n- ecdsa-sha2-nistp256\n- rsa-sha2-512\n- rsa-sha2-256\n\nThe following unsecure `SHA1` algorithms are supported but disabled by\ndefault:\n\n- (ssh-dss)\n- (ssh-rsa)\n\nDisabled public key algorithms can be enabled with the\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) options. See\n[Example 9](configure_algos.md#example-9) in\n[Configuring algorithms in SSH](configure_algos.md) for a description.\n\n**MAC algorithms**\n\n- hmac-sha2-512-etm@openssh.com\n- hmac-sha2-256-etm@openssh.com\n- hmac-sha2-512\n- hmac-sha2-256\n- hmac-sha1-etm@openssh.com\n- hmac-sha1\n\nThe following unsecure `SHA1` algorithm is disabled by default:\n\n- (hmac-sha1-96)\n\nIt can be enabled with the\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) options. Use\nfor example the Option value\n`{modify_algorithms, [{append, [{mac,['hmac-sha1-96']}]}]}`)\n\n**Encryption algorithms (ciphers)**\n\n- aes256-gcm@openssh.com\n- aes256-ctr\n- aes192-ctr\n- aes128-gcm@openssh.com\n- aes128-ctr\n- chacha20-poly1305@openssh.com\n- aes256-cbc\n- aes192-cbc\n- aes128-cbc\n- 3des-cbc\n\nThe following unsecure algorithms are disabled by default:\n- (AEAD_AES_128_GCM)\n- (AEAD_AES_256_GCM)\n\nSee the text at the description of\n[the rfc 5647 further down](ssh_app.md#rfc5647_note) for more information\nregarding AEAD\\_AES\\_\\*\\_GCM.\n\nFollowing the internet de-facto standard, the cipher and mac algorithm\nAEAD_AES_128_GCM is selected when the cipher aes128-gcm@openssh.com is\nnegotiated. The cipher and mac algorithm AEAD_AES_256_GCM is selected when the\ncipher aes256-gcm@openssh.com is negotiated.\n\n**Compression algorithms**\n  - none\n  - zlib@openssh.com\n  - zlib","ref":"ssh_app.html#algorithms"},{"type":"extras","title":"Unicode support - SSH Application","doc":"Unicode filenames are supported if the emulator and the underlying OS supports\nit. See `m:file` manual page in Kernel for\ninformation about this subject.\n\nThe shell and the cli both support unicode.","ref":"ssh_app.html#unicode-support"},{"type":"extras","title":"RFCs - SSH Application","doc":"The following RFCs are supported:\n\n- [RFC 4251](https://tools.ietf.org/html/rfc4251), The Secure Shell (SSH)\n  Protocol Architecture.\n\n  Except\n\n  - 9\\.4.6 Host-Based Authentication\n  - 9\\.5.2 Proxy Forwarding\n  - 9\\.5.3 X11 Forwarding\n\n- [RFC 4252](https://tools.ietf.org/html/rfc4252), The Secure Shell (SSH)\n  Authentication Protocol.\n\n  Except\n\n  - 9\\. Host-Based Authentication: \"hostbased\"\n\n- [RFC 4253](https://tools.ietf.org/html/rfc4253), The Secure Shell (SSH)\n  Transport Layer Protocol.\n\n  Except\n\n  - 8\\.1. diffie-hellman-group1-sha1\n  - 6\\.6. Public Key Algorithms\n    - ssh-dss\n    - ssh-rsa\n\n  They are disabled by default as they now are regarded insecure, but they can\n  be enabled with the\n  [preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n  [modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) options. See\n  [Example 8](configure_algos.md#example-8) (diffie-hellman-group1-sha1) and\n  [Example 9](configure_algos.md#example-9) (ssh-dss) in\n  [Configuring algorithms in SSH](configure_algos.md) for descriptions.\n\n- [RFC 4254](https://tools.ietf.org/html/rfc4254), The Secure Shell (SSH)\n  Connection Protocol.\n\n  Except\n\n  - 6\\.3. X11 Forwarding\n  - 7\\. TCP/IP Port Forwarding\n\n- [RFC 4256](https://tools.ietf.org/html/rfc4256), Generic Message Exchange\n  Authentication for the Secure Shell Protocol (SSH).\n\n  Except\n\n  - `num-prompts > 1`\n  - password changing\n  - other identification methods than userid-password\n\n- [RFC 4419](https://tools.ietf.org/html/rfc4419), Diffie-Hellman Group Exchange\n  for the Secure Shell (SSH) Transport Layer Protocol.\n\n  Except\n\n  - 4\\.1. diffie-hellman-group-exchange-sha1\n\n  It is disabled by default as it now is regarded insecure, but it can be\n  enabled with the\n  [preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n  [modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) options.\n\n- [RFC 4716](https://tools.ietf.org/html/rfc4716), The Secure Shell (SSH) Public\n  Key File Format.\n- [RFC 5647](https://tools.ietf.org/html/rfc5647), AES Galois Counter Mode for\n  the Secure Shell Transport Layer Protocol.\n\n  [](){: #rfc5647_note } There is an ambiguity in the synchronized selection of\n  cipher and mac algorithm. This is resolved by OpenSSH in the ciphers\n  aes128-gcm@openssh.com and aes256-gcm@openssh.com which are implemented. If\n  the explicit ciphers and macs AEAD_AES_128_GCM or AEAD_AES_256_GCM are needed,\n  they could be enabled with the options\n  [preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n  [modify_algorithms](`t:ssh:modify_algorithms_common_option/0`).\n\n  > #### Warning {: .warning }\n  >\n  > If the client or the server is not Erlang/OTP, it is the users\n  > responsibility to check that other implementation has the same\n  > interpretation of AEAD\\_AES\\_\\*\\_GCM as the Erlang/OTP SSH before enabling\n  > them. The aes\\*-gcm@openssh.com variants are always safe to use since they\n  > lack the ambiguity.\n\n  The second paragraph in section 5.1 is resolved as:\n\n  1. If the negotiated cipher is AEAD_AES_128_GCM, the mac algorithm is set to\n     AEAD_AES_128_GCM.\n  1. If the negotiated cipher is AEAD_AES_256_GCM, the mac algorithm is set to\n     AEAD_AES_256_GCM.\n  1. If the mac algorithm is AEAD_AES_128_GCM, the cipher is set to\n     AEAD_AES_128_GCM.\n  1. If the mac algorithm is AEAD_AES_256_GCM, the cipher is set to\n     AEAD_AES_256_GCM.\n\n  The first rule that matches when read in order from the top is applied\n\n- [RFC 5656](https://tools.ietf.org/html/rfc5656), Elliptic Curve Algorithm\n  Integration in the Secure Shell Transport Layer.\n\n  Except\n\n  - 5\\. ECMQV Key Exchange\n  - 6\\.4. ECMQV Key Exchange and Verification Method Name\n  - 7\\.2. ECMQV Message Numbers\n  - 10\\.2. Recommended Curves\n\n- [RFC 6668](https://tools.ietf.org/html/rfc6668), SHA-2 Data Integrity\n  Verification for the Secure Shell (SSH) Transport Layer Protocol\n\n  Comment: Defines hmac-sha2-256 and hmac-sha2-512\n\n- [Draft-ietf-curdle-ssh-kex-sha2 (work in progress)](https://tools.ietf.org/html/draft-ietf-curdle-ssh-kex-sha2),\n  Key Exchange (KEX) Method Updates and Recommendations for Secure Shell (SSH).\n\n  Deviations:\n\n  - `diffie-hellman-group1-sha1`\n  - `diffie-hellman-group-exchange-sha1`\n  - `diffie-hellman-group14-sha1`\n\n  are not enabled by default as they now are regarded insecure, but are still\n  supported and can be enabled with the options\n  [preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) or\n  [modify_algorithms](`t:ssh:modify_algorithms_common_option/0`).\n\n- [RFC 8332](https://tools.ietf.org/html/rfc8332), Use of RSA Keys with SHA-256\n  and SHA-512 in the Secure Shell (SSH) Protocol.\n- [](){: #supported-ext-info } [RFC 8308](https://tools.ietf.org/html/rfc8308),\n  Extension Negotiation in the Secure Shell (SSH) Protocol.\n\n  Implemented are:\n\n  - The Extension Negotiation Mechanism\n  - The extension `server-sig-algs`\n\n- [Secure Shell (SSH) Key Exchange Method Using Curve25519 and Curve448](https://tools.ietf.org/html/rfc8731)\n- [RFC 8709](https://tools.ietf.org/html/rfc8709) Ed25519 and Ed448 public key\n  algorithms for the Secure Shell (SSH) protocol","ref":"ssh_app.html#rfcs"},{"type":"extras","title":"See Also - SSH Application","doc":"`m:application`","ref":"ssh_app.html#see-also"},{"type":"extras","title":"SSH Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SSH Release Notes","ref":"notes.html"},{"type":"extras","title":"Ssh 5.3.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change user space buffers are used to limit ssh hello message size instead of kernel buffers\n\n  Own Id: OTP-19839 Aux Id: ERIERL-1273, [PR-10350]\n\n[PR-10350]: https://github.com/erlang/otp/pull/10350","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Ssh 5.3.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Option max_handles can be configured for sshd running SFTP. The positive integer value limits amount of file handles opened for a connection (by default 4096 is used).\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19701 Aux Id: [CVE-2025-48041], [PR-10157]\n\n- Avoid decoding KEX messages providing too many algorithms. This change does not introduce new limitation but assures it is enforced earlier in processing chain. Adjustments in error logging during handshake.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19741 Aux Id: [CVE-2025-48040], [PR-10162]\n\n- A new 'max_path' option is now available in the sshd configuration, allowing administrators to set the maximum allowable path length. By default, this value is set to 4096 characters.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19742 Aux Id: [CVE-2025-48039], [PR-10155]\n\n- Reject file handles exceeding size specified in RFCs (256 bytes).\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19748 Aux Id: [CVE-2025-48038], [PR-10156]\n\n[CVE-2025-48041]: https://nvd.nist.gov/vuln/detail/2025-48041\n[PR-10157]: https://github.com/erlang/otp/pull/10157\n[CVE-2025-48040]: https://nvd.nist.gov/vuln/detail/2025-48040\n[PR-10162]: https://github.com/erlang/otp/pull/10162\n[CVE-2025-48039]: https://nvd.nist.gov/vuln/detail/2025-48039\n[PR-10155]: https://github.com/erlang/otp/pull/10155\n[CVE-2025-48038]: https://nvd.nist.gov/vuln/detail/2025-48038\n[PR-10156]: https://github.com/erlang/otp/pull/10156","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Ssh 5.3.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix file handle id generation.\n\n  Own Id: OTP-19691 Aux Id: [PR-10003]\n\n- Fixes a badmatch error, when SFTP operation cannot be processed due to channel closed in parallel.\n\n  Own Id: OTP-19707 Aux Id: [GH-9655], [PR-10035], [PR-10036]\n\n[PR-10003]: https://github.com/erlang/otp/pull/10003\n[GH-9655]: https://github.com/erlang/otp/issues/9655\n[PR-10035]: https://github.com/erlang/otp/pull/10035\n[PR-10036]: https://github.com/erlang/otp/pull/10036","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"Ssh 5.3.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Various channel closing robustness improvements. Avoid crashes when channel handling process closes channel and immediately exits. Avoid breaking the protocol by sending duplicated channel-close messages. Cleanup channels which timeout during closing procedure.\n\n  Own Id: OTP-19634 Aux Id: [GH-9102], [PR-9103]\n\n- Improved interoperability with clients acting as Paramiko.\n\n  Own Id: OTP-19637 Aux Id: [GH-6463], [PR-9838]\n\n[GH-9102]: https://github.com/erlang/otp/issues/9102\n[PR-9103]: https://github.com/erlang/otp/pull/9103\n[GH-6463]: https://github.com/erlang/otp/issues/6463\n[PR-9838]: https://github.com/erlang/otp/pull/9838","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"Ssh 5.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The implementation of the ssh server-side supervision tree has been improved.\n\n  Own Id: OTP-19324 Aux Id: [PR-8968], [GH-8223]\n\n- SSH daemon accepts fun as tcpip_tunnel_in option. This provides more control over TCP connection tunnel handle by server.\n\n  Own Id: OTP-19566 Aux Id: [PR-9571]\n\n[PR-8968]: https://github.com/erlang/otp/pull/8968\n[GH-8223]: https://github.com/erlang/otp/issues/8223\n[PR-9571]: https://github.com/erlang/otp/pull/9571","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The [`Erlang SSH daemon`](using_ssh.md#running-an-erlang-ssh-daemon) now uses the same backend to handle multiline functionality as the Erlang shell.\n\n  Own Id: OTP-19226 Aux Id: [PR-8805]\n\n- CBC algorithms are not offered by default. See Configuring algorithms in SSH if you wish to enable them.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19420 Aux Id: [PR-9277]\n\n- Daemon can be configured (bannerfun option) to send banner message at the beginning of user authentication.\n\n  Own Id: OTP-19535 Aux Id: [PR-9149]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n- For interoperability reasons, SSH ignore message with no length specified is treated as message with zero length specified - it will not cause decode error.\n\n  Own Id: OTP-19586 Aux Id: [PR-9214]\n\n- Documentation improvements.\n\n  Own Id: OTP-19596 Aux Id: [PR-9298]\n\n[PR-8805]: https://github.com/erlang/otp/pull/8805\n[PR-9277]: https://github.com/erlang/otp/pull/9277\n[PR-9149]: https://github.com/erlang/otp/pull/9149\n[PR-9670]: https://github.com/erlang/otp/pull/9670\n[PR-9214]: https://github.com/erlang/otp/pull/9214\n[PR-9298]: https://github.com/erlang/otp/pull/9298","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Ssh 5.2.11.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-11-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Option max_handles can be configured for sshd running SFTP. The positive integer value limits amount of file handles opened for a connection (by default 4096 is used).\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19701 Aux Id: [CVE-2025-48041], [PR-10157]\n\n- Avoid decoding KEX messages providing too many algorithms. This change does not introduce new limitation but assures it is enforced earlier in processing chain. Adjustments in error logging during handshake.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19741 Aux Id: [CVE-2025-48040], [PR-10162]\n\n- A new 'max_path' option is now available in the sshd configuration, allowing administrators to set the maximum allowable path length. By default, this value is set to 4096 characters.\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19742 Aux Id: [CVE-2025-48039], [PR-10155]\n\n- Reject file handles exceeding size specified in RFCs (256 bytes).\n\n  *** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19748 Aux Id: [CVE-2025-48038], [PR-10156]\n\n[CVE-2025-48041]: https://nvd.nist.gov/vuln/detail/2025-48041\n[PR-10157]: https://github.com/erlang/otp/pull/10157\n[CVE-2025-48040]: https://nvd.nist.gov/vuln/detail/2025-48040\n[PR-10162]: https://github.com/erlang/otp/pull/10162\n[CVE-2025-48039]: https://nvd.nist.gov/vuln/detail/2025-48039\n[PR-10155]: https://github.com/erlang/otp/pull/10155\n[CVE-2025-48038]: https://nvd.nist.gov/vuln/detail/2025-48038\n[PR-10156]: https://github.com/erlang/otp/pull/10156","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"Ssh 5.2.11.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-11-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix file handle id generation.\n\n  Own Id: OTP-19691 Aux Id: [PR-10003]\n\n- Fixes a badmatch error, when SFTP operation cannot be processed due to channel closed in parallel.\n\n  Own Id: OTP-19707 Aux Id: [GH-9655], [PR-10035], [PR-10036]\n\n[PR-10003]: https://github.com/erlang/otp/pull/10003\n[GH-9655]: https://github.com/erlang/otp/issues/9655\n[PR-10035]: https://github.com/erlang/otp/pull/10035\n[PR-10036]: https://github.com/erlang/otp/pull/10036","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"Ssh 5.2.11.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Various channel closing robustness improvements. Avoid crashes when channel handling process closes channel and immediately exits. Avoid breaking the protocol by sending duplicated channel-close messages. Cleanup channels which timeout during closing procedure.\n\n  Own Id: OTP-19634 Aux Id: [GH-9102], [PR-9103]\n\n- Improved interoperability with clients acting as Paramiko.\n\n  Own Id: OTP-19637 Aux Id: [GH-6463], [PR-9838]\n\n[GH-9102]: https://github.com/erlang/otp/issues/9102\n[PR-9103]: https://github.com/erlang/otp/pull/9103\n[GH-6463]: https://github.com/erlang/otp/issues/6463\n[PR-9838]: https://github.com/erlang/otp/pull/9838","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Ssh 5.2.11 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix KEX strict implementation according to draft-miller-sshm-strict-kex-01 document.\n\n  Thanks to Fabian Bäumer, Marcel Maehren, Marcus Brinkmann, and Jörg Schwenk from the Ruhr University Bochum for finding and responsibly disclosing this vulnerability to the Erlang/OTP project.\n\n  Own Id: OTP-19625 Aux Id: [CVE-2025-46712](https://nvd.nist.gov/vuln/detail/CVE-2025-46712)","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"Ssh 5.2.10 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Reception of wrong Unicode does not cause unnecessary processing. US-ASCII fields are not decoded as Unicode.\n\n  Own Id: OTP-19582 Aux Id: [PR-9679]\n\n- SSH daemon disconnects upon receiving connection protocol message for unauthenticated used.\n  \n  Thanks to Fabian Bäumer, Marcel Maehren, Marcus Brinkmann, Nurullah Erinola, Jörg Schwenk (Ruhr University Bochum).\n\n  Own Id: OTP-19595 Aux Id: [CVE-2025-32433](https://nvd.nist.gov/vuln/detail/CVE-2025-32433)\n\n[PR-9679]: https://github.com/erlang/otp/pull/9679","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"Ssh 5.2.9 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Reception of malicious KEX init message does not result with ssh daemon excessive memory usage.\n\n  Own Id: OTP-19543 Aux Id: CVE-2025-30211\n\n- Call to ssh:daemon_replace_options does not crash when argument is not a valid daemon ref.\n\n  Own Id: OTP-19559 Aux Id: [GH-9554], [PR-9545]\n\n[GH-9554]: https://github.com/erlang/otp/issues/9554\n[PR-9545]: https://github.com/erlang/otp/pull/9545","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"Ssh 5.2.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Minor documentation improvements.\n\n  Own Id: OTP-19410 Aux Id: [PR-9188]\n\n- Function specification for `ssh_sftp:start_channel/2` is fixed.\n\n  Own Id: OTP-19475 Aux Id: [PR-9368], [GH-9359]\n\n[PR-9188]: https://github.com/erlang/otp/pull/9188\n[PR-9368]: https://github.com/erlang/otp/pull/9368\n[GH-9359]: https://github.com/erlang/otp/issues/9359","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"Ssh 5.2.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SFTP packets exceeding max packet size are not processed and dropped.\n\n  Own Id: OTP-19466 Aux Id: ERIERL-1173, CVE-2025-26618","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"Ssh 5.2.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, type specs for ssh:connection_info/1,2 functions are fixed so they include \\{error, term()\\} return value.\n\n  Own Id: OTP-19388 Aux Id: ERIERL-1165, [PR-9161]\n\n- With this change, ssh client accepts a banner sent during processing keyboard interactive user authentication.\n\n  Own Id: OTP-19392 Aux Id: [PR-9139], [GH-9065]\n\n- With this change, large sftp transfers does not hang. Redundant window adjustment are not requested.\n\n  Own Id: OTP-19435 Aux Id: [PR-9309]\n\n[PR-9161]: https://github.com/erlang/otp/pull/9161\n[PR-9139]: https://github.com/erlang/otp/pull/9139\n[GH-9065]: https://github.com/erlang/otp/issues/9065\n[PR-9309]: https://github.com/erlang/otp/pull/9309","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Ssh 5.2.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Documentation is polished after OTP-27 migration to markdown.\n\n  Own Id: OTP-19335 Aux Id: [PR-9021]\n\n[PR-9021]: https://github.com/erlang/otp/pull/9021","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"Ssh 5.2.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, ssh connection does not crash upon receiving exit-signal message for an already terminated channel.\n\n  Own Id: OTP-19326 Aux Id: [PR-8995], [GH-8929]\n\n[PR-8995]: https://github.com/erlang/otp/pull/8995\n[GH-8929]: https://github.com/erlang/otp/issues/8929","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Ssh 5.2.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, a race condition is removed from ssh client connection setup procedure.\n\n  Own Id: OTP-19124 Aux Id: [GH-7550], [PR-8766]\n\n- With this change, ssh:connect is not affected by presence of EXIT message in queue.\n\n  Own Id: OTP-19246 Aux Id: [GH-8223], [PR-8854]\n\n- With this change, ssh appends {active, false} option after socket options received from user - so that false value is always used.\n\n  Own Id: OTP-19247 Aux Id: [PR-8226]\n\n[GH-7550]: https://github.com/erlang/otp/issues/7550\n[PR-8766]: https://github.com/erlang/otp/pull/8766\n[GH-8223]: https://github.com/erlang/otp/issues/8223\n[PR-8854]: https://github.com/erlang/otp/pull/8854\n[PR-8226]: https://github.com/erlang/otp/pull/8226","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"Ssh 5.2.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The SSh daemon started with a TCP port number argument will now re-try obtaining a listen socket before returning an error to the user.\n\n  Own Id: OTP-19170 Aux Id: [GH-7746]\n\n- Robustness has been improved by monitoring the connection handler process before casting the socket control notification.\n\n  Own Id: OTP-19173 Aux Id: [PR-8310]\n\n[GH-7746]: https://github.com/erlang/otp/issues/7746\n[PR-8310]: https://github.com/erlang/otp/pull/8310","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Ssh 5.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, race condition between connection closing and automatic window adjustment is fixed.\n\n  Own Id: OTP-19109 Aux Id: [PR-8345]\n\n[PR-8345]: https://github.com/erlang/otp/pull/8345","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"Ssh 5.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH processes are now assigned labels for troubleshooting purposes.\n\n  Own Id: OTP-19017 Aux Id: [PR-8249]\n\n- With this change, ssh client will automatically adjust transfer window size for commands executed remotely over SSH.\n\n  Own Id: OTP-19057 Aux Id: [PR-8345], [GH-7483]\n\n[PR-8249]: https://github.com/erlang/otp/pull/8249\n[PR-8345]: https://github.com/erlang/otp/pull/8345\n[GH-7483]: https://github.com/erlang/otp/issues/7483","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The shell now pages long output from the documentation help command ([`h(Module)`](`c:h/1`)), auto completions and the search command.\n\n  Own Id: OTP-18846 Aux Id: [PR-7845]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- Updated types and specs for all API modules.\n\n  Own Id: OTP-18961\n\n[PR-7845]: https://github.com/erlang/otp/pull/7845\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"Ssh 5.1.4.12 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Option max_handles can be configured for sshd running SFTP. The positive integer value limits amount of file handles opened for a connection (by default 4096 is used).\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19701 Aux Id: CVE-2025-48041, PR-10157\n* Avoid decoding KEX messages providing too many algorithms. This change does not introduce new limitation but assures it is enforced earlier in processing chain. Adjustments in error logging during handshake.\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19741 Aux Id: CVE-2025-48040, PR-10162\n* A new 'max_path' option is now available in the sshd configuration, allowing administrators to set the maximum allowable path length. By default, this value is set to 4096 characters.\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19742 Aux Id: CVE-2025-48039, PR-10155\n* Reject file handles exceeding size specified in RFCs (256 bytes).\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-19748 Aux Id: CVE-2025-48038, PR-10156","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Ssh 5.1.4.11 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Fix file handle id generation.\n\n  Own Id: OTP-19691 Aux Id: PR-10003\n* Fixes a badmatch error, when SFTP operation cannot be processed due to channel closed in parallel.\n\n  Own Id: OTP-19707 Aux Id: GH-9655, PR-10035, PR-10036","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"Ssh 5.1.4.10 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Various channel closing robustness improvements. Avoid crashes when channel handling process closes channel and immediately exits. Avoid breaking the protocol by sending duplicated channel-close messages. Cleanup channels which timeout during closing procedure.\n\n  Own Id: OTP-19634 Aux Id: GH-9102, PR-9103\n* Improved interoperability with clients acting as Paramiko.\n\n  Own Id: OTP-19637 Aux Id: GH-6463, PR-9838","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Ssh 5.1.4.9 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Fix KEX strict implementation according to draft-miller-sshm-strict-kex-01 document.\n\n  Thanks to Fabian Bäumer, Marcel Maehren, Marcus Brinkmann, and Jörg Schwenk from the Ruhr University Bochum for finding and responsibly disclosing this vulnerability to the Erlang/OTP project.\n\n  Own Id: OTP-19625 Aux Id: [CVE-2025-46712](https://nvd.nist.gov/vuln/detail/CVE-2025-46712)","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Ssh 5.1.4.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Reception of wrong Unicode does not cause unnecessary processing. US-ASCII fields are not decoded as Unicode.\n\n  Own Id: OTP-19582 Aux Id: PR-9679\n* SSH daemon disconnects upon receiving connection protocol message for unauthenticated used.\n\n  Thanks to Fabian Bäumer, Marcel Maehren, Marcus Brinkmann, Nurullah Erinola, Jörg Schwenk (Ruhr University Bochum).\n\n  Own Id: OTP-19595 Aux Id: [CVE-2025-32433](https://nvd.nist.gov/vuln/detail/CVE-2025-32433)","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"Ssh 5.1.4.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Reception of malicious KEX init message does not result with ssh daemon excessive memory usage.\n\n  Own Id: OTP-19543 Aux Id: CVE-2025-30211\n* Call to ssh:daemon_replace_options does not crash when argument is not a valid daemon ref.\n\n  Own Id: OTP-19559 Aux Id: GH-9554, PR-9545","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"Ssh 5.1.4.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* SFTP packets exceeding max packet size are not processed and dropped.\n\n  Own Id: OTP-19466 Aux Id: ERIERL-1173, CVE-2025-26618","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"Ssh 5.1.4.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, type specs for ssh:connection_info/1,2 functions are fixed so they include \\{error, term()\\} return value.\n\n  Own Id: OTP-19388 Aux Id: ERIERL-1165, PR-9161\n* With this change, ssh client accepts a banner sent during processing keyboard interactive user authentication.\n\n  Own Id: OTP-19392 Aux Id: PR-9139, GH-9065\n* With this change, large sftp transfers does not hang. Redundant window adjustment are not requested.\n\n  Own Id: OTP-19435 Aux Id: PR-9309","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Ssh 5.1.4.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, ssh connection does not crash upon receiving exit-signal message for an already terminated channel.\n\n  Own Id: OTP-19326 Aux Id: PR-8995, GH-8929","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Ssh 5.1.4.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, a race condition is removed from ssh client connection setup procedure.\n\n  Own Id: OTP-19124 Aux Id: GH-7550, PR-8766\n* With this change, ssh:connect is not affected by presence of EXIT message in queue.\n\n  Own Id: OTP-19246 Aux Id: GH-8223, PR-8854\n* With this change, ssh appends \\{active, false\\} option after socket options received from user - so that false value is always used.\n\n  Own Id: OTP-19247 Aux Id: PR-8226","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"Ssh 5.1.4.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, ssh daemon started with TCP port number argument will re-try to obtain listen socket before returning error to user.\n\n  Own Id: OTP-19170 Aux Id: GH-7746\n* With this change, robustness is improved by monitoring connection handler process before casting socket control notification.\n\n  Own Id: OTP-19173 Aux Id: PR-8310","ref":"notes.html#fixed-bugs-and-malfunctions-30"},{"type":"extras","title":"Ssh 5.1.4.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, ssh client will automatically adjust transfer window size for commands executed remotely over SSH.\n\n  Own Id: OTP-19057 Aux Id: PR-8345, GH-7483\n* With this change, race condition between connection closing and automatic window adjustment is fixed.\n\n  Own Id: OTP-19109 Aux Id: PR-8345","ref":"notes.html#fixed-bugs-and-malfunctions-31"},{"type":"extras","title":"Ssh 5.1.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, owner and group file attributes decoding is fixed and results with value of integer type.\n\n  Own Id: OTP-19013 Aux Id: GH-7897, PR-8220","ref":"notes.html#fixed-bugs-and-malfunctions-32"},{"type":"extras","title":"Ssh 5.1.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, acceptor_sup is not started for ssh client as it is not needed in that role.\n\n  Own Id: OTP-18974\n* With this change, more secure algorithms are preferred by ssh and documentation is updated to reflect that.\n\n  Own Id: OTP-18986\n* With this change, KEX strict terminal message is emitted with debug verbosity.\n\n  Own Id: OTP-19002 Aux Id: ERIERL-1041\n* Fix reading of password for ssh client when in `user_interactive` mode.\n\n  Own Id: OTP-19007 Aux Id: ERIERL-1049","ref":"notes.html#fixed-bugs-and-malfunctions-33"},{"type":"extras","title":"Ssh 5.1.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, Curve25519 and Curve448 KEX methods become most preferred (related to RFC8731).\n\n  Own Id: OTP-18964","ref":"notes.html#fixed-bugs-and-malfunctions-34"},{"type":"extras","title":"Ssh 5.1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change (being response to CVE-2023-48795), ssh can negotiate \"strict\n  KEX\" OpenSSH extension with peers supporting it; also\n  'chacha20-poly1305@openssh.com' algorithm becomes a less preferred cipher.\n\n  If strict KEX availability cannot be ensured on both connection sides,\n  affected encryption modes(CHACHA and CBC) can be disabled with standard ssh\n  configuration. This will provide protection against vulnerability, but at a\n  cost of affecting interoperability. See\n  [Configuring algorithms in SSH](configure_algos.md).\n\n  Thanks to Fabian Bäumer, Marcus Brinkmann and Jörg Schwenk.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18897","ref":"notes.html#fixed-bugs-and-malfunctions-35"},{"type":"extras","title":"Ssh 5.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Replaced unintentional Erlang Public License 1.1 headers in some files with\n  the intended Apache License 2.0 header.\n\n  Own Id: OTP-18815 Aux Id: PR-7780\n\n- Avoid outputting ansi escape sequences to dumb ssh clients.\n\n  Own Id: OTP-18861 Aux Id: PR-7627\n\n- With this change, connection handler does not execute socket operations until\n  it becomes socket owner. Previously errors could occur if connection handler\n  tried to work with socket whose owner exited.\n\n  Own Id: OTP-18869 Aux Id: PR-7849,GH-7571","ref":"notes.html#fixed-bugs-and-malfunctions-36"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- With this change, reverse search works with ssh shell and non dumb terminals.\n\n  Own Id: OTP-18730 Aux Id: PR-7499","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"Ssh 5.0.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Added multiline editing support to ssh clients connected through OTP ssh\n  daemon.\n\n  Own Id: OTP-18653 Aux Id: PR-7242","ref":"notes.html#fixed-bugs-and-malfunctions-37"},{"type":"extras","title":"Ssh 5.0 - SSH Release Notes","doc":"","ref":"notes.html#ssh-5-0"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The ssh_cli has been updated to work with the changes introduced in the new\n  Erlang shell implementation.\n\n  Own Id: OTP-18231 Aux Id: OTP-17932 PR-6144\n\n- Typing `Ctrl+L` in a shell now clears the screen and redraws the current line\n  instead of only redrawing the current line. To only redraw the current line,\n  you must now type `Alt+L`. This brings the behaviour of `Ctrl+L` closer to how\n  bash and other shells work.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18285 Aux Id: PR-6262\n\n- Deprecates `dbg:stop_clear/0` because it is simply a function alias to\n  `dbg:stop/0`\n\n  Own Id: OTP-18478 Aux Id: GH-6903\n\n- The implementation has been fixed to use `proc_lib:init_fail/2,3` where\n  appropriate, instead of `proc_lib:init_ack/1,2`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18490 Aux Id: OTP-18471, GH-6339, PR-6843","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"Ssh 4.15.3.13 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Fix KEX strict implementation according to draft-miller-sshm-strict-kex-01 document.\n\n  Thanks to Fabian Bäumer, Marcel Maehren, Marcus Brinkmann, and Jörg Schwenk from the Ruhr University Bochum for finding and responsibly disclosing this vulnerability to the Erlang/OTP project.\n\n  Own Id: OTP-19625 Aux Id: [CVE-2025-46712](https://nvd.nist.gov/vuln/detail/CVE-2025-46712)","ref":"notes.html#fixed-bugs-and-malfunctions-38"},{"type":"extras","title":"Ssh 4.15.3.12 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Reception of wrong Unicode does not cause unnecessary processing. US-ASCII fields are not decoded as Unicode.\n\n  Own Id: OTP-19582 Aux Id: PR-9679\n* SSH daemon disconnects upon receiving connection protocol message for unauthenticated used.\n\n  Thanks to Fabian Bäumer, Marcel Maehren, Marcus Brinkmann, Nurullah Erinola, Jörg Schwenk (Ruhr University Bochum).\n\n  Own Id: OTP-19595 Aux Id: [CVE-2025-32433](https://nvd.nist.gov/vuln/detail/CVE-2025-32433)","ref":"notes.html#fixed-bugs-and-malfunctions-39"},{"type":"extras","title":"Ssh 4.15.3.11 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* Reception of malicious KEX init message does not result with ssh daemon excessive memory usage.\n\n  Own Id: OTP-19543 Aux Id: CVE-2025-30211\n* Call to ssh:daemon_replace_options does not crash when argument is not a valid daemon ref.\n\n  Own Id: OTP-19559 Aux Id: GH-9554, PR-9545","ref":"notes.html#fixed-bugs-and-malfunctions-40"},{"type":"extras","title":"Ssh 4.15.3.10 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* SFTP packets exceeding max packet size are not processed and dropped.\n\n  Own Id: OTP-19466 Aux Id: ERIERL-1173, CVE-2025-26618","ref":"notes.html#fixed-bugs-and-malfunctions-41"},{"type":"extras","title":"Ssh 4.15.3.9 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, type specs for ssh:connection_info/1,2 functions are fixed so they include \\{error, term()\\} return value.\n\n  Own Id: OTP-19388 Aux Id: ERIERL-1165, PR-9161\n* With this change, ssh client accepts a banner sent during processing keyboard interactive user authentication.\n\n  Own Id: OTP-19392 Aux Id: PR-9139, GH-9065\n* With this change, large sftp transfers does not hang. Redundant window adjustment are not requested.\n\n  Own Id: OTP-19435 Aux Id: PR-9309","ref":"notes.html#fixed-bugs-and-malfunctions-42"},{"type":"extras","title":"Ssh 4.15.3.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, ssh connection does not crash upon receiving exit-signal message for an already terminated channel.\n\n  Own Id: OTP-19326 Aux Id: PR-8995, GH-8929","ref":"notes.html#fixed-bugs-and-malfunctions-43"},{"type":"extras","title":"Ssh 4.15.3.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, a race condition is removed from ssh client connection setup procedure.\n\n  Own Id: OTP-19124 Aux Id: GH-7550, PR-8766\n* With this change, ssh:connect is not affected by presence of EXIT message in queue.\n\n  Own Id: OTP-19246 Aux Id: GH-8223, PR-8854\n* With this change, ssh appends \\{active, false\\} option after socket options received from user - so that false value is always used.\n\n  Own Id: OTP-19247 Aux Id: PR-8226","ref":"notes.html#fixed-bugs-and-malfunctions-44"},{"type":"extras","title":"Ssh 4.15.3.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* The SSh daemon started with a TCP port number argument will now re-try obtaining a listen socket before returning an error to the user.\n\n  Own Id: OTP-19170 Aux Id: GH-7746\n* Robustness has been improved by monitoring the connection handler process before casting the socket control notification.\n\n  Own Id: OTP-19173 Aux Id: PR-8310","ref":"notes.html#fixed-bugs-and-malfunctions-45"},{"type":"extras","title":"Ssh 4.15.3.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, ssh client will automatically adjust transfer window size for commands executed remotely over SSH.\n\n  Own Id: OTP-19057 Aux Id: PR-8345, GH-7483\n* With this change, race condition between connection closing and automatic window adjustment is fixed.\n\n  Own Id: OTP-19109 Aux Id: PR-8345","ref":"notes.html#fixed-bugs-and-malfunctions-46"},{"type":"extras","title":"Ssh 4.15.3.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, owner and group file attributes decoding is fixed and results with value of integer type.\n\n  Own Id: OTP-19013 Aux Id: GH-7897, PR-8220","ref":"notes.html#fixed-bugs-and-malfunctions-47"},{"type":"extras","title":"Ssh 4.15.3.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, more secure algorithms are preferred by ssh and documentation is updated to reflect that.\n\n  Own Id: OTP-18986\n* With this change, KEX strict terminal message is emitted with debug verbosity.\n\n  Own Id: OTP-19002 Aux Id: ERIERL-1041","ref":"notes.html#fixed-bugs-and-malfunctions-48"},{"type":"extras","title":"Ssh 4.15.3.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, Curve25519 and Curve448 KEX methods become most preferred (related to RFC8731).\n\n  Own Id: OTP-18964","ref":"notes.html#fixed-bugs-and-malfunctions-49"},{"type":"extras","title":"Ssh 4.15.3.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, connection handler does not execute socket operations until\n  it becomes socket owner. Previously errors could occur if connection handler\n  tried to work with socket whose owner exited.\n\n  Own Id: OTP-18869 Aux Id: PR-7849,GH-7571\n\n- With this change (being response to CVE-2023-48795), ssh can negotiate \"strict\n  KEX\" OpenSSH extension with peers supporting it; also\n  'chacha20-poly1305@openssh.com' algorithm becomes a less preferred cipher.\n\n  If strict KEX availability cannot be ensured on both connection sides,\n  affected encryption modes(CHACHA and CBC) can be disabled with standard ssh\n  configuration. This will provide protection against vulnerability, but at a\n  cost of affecting interoperability. See\n  [Configuring algorithms in SSH](configure_algos.md).\n\n  Thanks to Fabian Bäumer, Marcus Brinkmann and Jörg Schwenk.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18897","ref":"notes.html#fixed-bugs-and-malfunctions-50"},{"type":"extras","title":"Ssh 4.15.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, PKCS8 formatted private key file is properly decoded and SSH\n  daemon with such key can be started.\n\n  Own Id: OTP-18446 Aux Id: GH-6475","ref":"notes.html#fixed-bugs-and-malfunctions-51"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"Ssh 4.15.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, ssh application does not crash when formatting some of info\n  reports for unsuccessful connections.\n\n  Own Id: OTP-18386 Aux Id: PR-6611\n\n- With this change, ssh does not log extensively long messages.\n\n  Own Id: OTP-18417 Aux Id: DAFH-1349,ERIERL-888,IA18357","ref":"notes.html#fixed-bugs-and-malfunctions-52"},{"type":"extras","title":"Ssh 4.15.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- graceful shutdown of ssh_conection_handler when connection is closed by peer\n\n  Own Id: OTP-18326 Aux Id: ERIERL-865","ref":"notes.html#fixed-bugs-and-malfunctions-53"},{"type":"extras","title":"Ssh 4.15 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-15"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Handling rare race condition at channel close.\n\n  Own Id: OTP-18220 Aux Id: ERIERL-666, ERIERL-661","ref":"notes.html#fixed-bugs-and-malfunctions-54"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- New ssh option `no_auth_needed` to skip the ssh authentication. Use with\n  caution\\!\n\n  Own Id: OTP-18134 Aux Id: GH-6021\n\n- This change fixes dialyzer warnings generated for inets/httpd examples\n  (includes needed adjustment of spec for ssh_sftp module).\n\n  Own Id: OTP-18178 Aux Id: ERIERL-833, ERIERL-834, ERIERL-835\n\n- The new function `ssh:daemon_replace_options/2` makes it possible to change\n  the `Options` in a running SSH server.\n\n  Established connections are not affected, only those created after the call to\n  this new function.\n\n  Own Id: OTP-18196\n\n- Add a timeout as option `max_initial_idle_time`. It closes a connection that\n  does not allocate a channel within the timeout time.\n\n  For more information about timeouts, see the\n  [Timeouts section ](hardening.md#timeouts)in the User's Guide\n  [Hardening](hardening.md) chapter.\n\n  Own Id: OTP-18207 Aux Id: PR-6231","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"Ssh 4.14.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-14-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Binaries can be limited in logs with the parameter `max_log_item_len`. The\n  default value is 500 bytes.\n\n  Own Id: OTP-18094","ref":"notes.html#fixed-bugs-and-malfunctions-55"},{"type":"extras","title":"Ssh 4.14 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-14"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The representation of Edward curves (ed25519 and ed448) inside ssh had a\n  temporary representation (ed_pri and ed_pub).\n\n  That is now changed to the public_key form. See the manual for more\n  information.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17920\n\n- Former internal function `ssh_file:extract_public_key/1` documented publicly.\n\n  Internally it was previously in ssh_transport.\n\n  Own Id: OTP-18079 Aux Id: GH-5767","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"Ssh 4.13.2.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, more secure algorithms are preferred by ssh and documentation is updated to reflect that.\n\n  Own Id: OTP-18986\n* With this change, KEX strict terminal message is emitted with debug verbosity.\n\n  Own Id: OTP-19002 Aux Id: ERIERL-1041\n* With this change, owner and group file attributes decoding is fixed and results with value of integer type.\n\n  Own Id: OTP-19013 Aux Id: GH-7897, PR-8220","ref":"notes.html#fixed-bugs-and-malfunctions-56"},{"type":"extras","title":"Ssh 4.13.2.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change, Curve25519 and Curve448 KEX methods become most preferred (related to RFC8731).\n\n  Own Id: OTP-18964","ref":"notes.html#fixed-bugs-and-malfunctions-57"},{"type":"extras","title":"Ssh 4.13.2.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, connection handler does not execute socket operations until\n  it becomes socket owner. Previously errors could occur if connection handler\n  tried to work with socket whose owner exited.\n\n  Own Id: OTP-18869 Aux Id: PR-7849,GH-7571\n\n- With this change (being response to CVE-2023-48795), ssh can negotiate \"strict\n  KEX\" OpenSSH extension with peers supporting it; also\n  'chacha20-poly1305@openssh.com' algorithm becomes a less preferred cipher.\n\n  If strict KEX availability cannot be ensured on both connection sides,\n  affected encryption modes(CHACHA and CBC) can be disabled with standard ssh\n  configuration. This will provide protection against vulnerability, but at a\n  cost of affecting interoperability. See\n  [Configuring algorithms in SSH](configure_algos.md).\n\n  Thanks to Fabian Bäumer, Marcus Brinkmann and Jörg Schwenk.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18897","ref":"notes.html#fixed-bugs-and-malfunctions-58"},{"type":"extras","title":"Ssh 4.13.2.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, error logging related crashes in ssh_connection_handler\n  module are fixed.\n\n  Own Id: OTP-18620 Aux Id: OTP-18386,PR-6611","ref":"notes.html#fixed-bugs-and-malfunctions-59"},{"type":"extras","title":"Ssh 4.13.2.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- With this change, ssh application does not crash when formatting some of info\n  reports for unsuccessful connections.\n\n  Own Id: OTP-18386 Aux Id: PR-6611\n\n- With this change, ssh does not log extensively long messages.\n\n  Own Id: OTP-18417 Aux Id: DAFH-1349,ERIERL-888,IA18357","ref":"notes.html#fixed-bugs-and-malfunctions-60"},{"type":"extras","title":"Ssh 4.13.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Binaries can be limited in logs with the parameter `max_log_item_len`. The\n  default value is 500 bytes.\n\n  Own Id: OTP-18094","ref":"notes.html#fixed-bugs-and-malfunctions-61"},{"type":"extras","title":"Ssh 4.13.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix makefile dependency bugs.\n\n  Own Id: OTP-17847 Aux Id: PR-5574 GH-5548\n\n- Fixed faulty OpenSSH decoding of Ed25519/Ed448 keys in the OpenSSH format\n  `openssh_key_v1`.\n\n  Own Id: OTP-17868 Aux Id: PR-5520\n\n- Correction of ssh_file typing, specially for the experimental openssh-key-v1\n  encoding.\n\n  Own Id: OTP-17912 Aux Id: GH-5680\n\n- Improper tag for private ED keys when encoding with ssh:encode/2.\n\n  The tuple had `ed_priv` as first element, but should have had `ed_pri`. This\n  is now corrected.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17928 Aux Id: PR-5679","ref":"notes.html#fixed-bugs-and-malfunctions-62"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Add support for Ed25519/Ed448 SSH host keys in the RFC 4716 format\n  (\"`-----BEGIN EC PRIVATE KEY-----`\") generated by for example openssl or via\n  Erlang functions (i.e. `public_key:generate_key({namedCurve, ed25519})`).\n\n  Ed25519 SSH host keys generated by `ssh-keygen` was, and are still, supported.\n\n  Own Id: OTP-17857 Aux Id: PR-5532","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"Ssh 4.13.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The ssh sever `parallel_login` option was missing in OTP-24\n\n  Own Id: OTP-17850 Aux Id: ERIERL-764","ref":"notes.html#fixed-bugs-and-malfunctions-63"},{"type":"extras","title":"Ssh 4.13 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The value of the `connect_timeout` option is now used as default value for the\n  negotiation timeout.\n\n  Own Id: OTP-17707 Aux Id: ERIERL-706","ref":"notes.html#fixed-bugs-and-malfunctions-64"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Add better error handling in connect/2,3,4. Detect incorrect arguments and\n  return an informative error tuple instead of throwing a function_clause or\n  similar.\n\n  Own Id: OTP-17515 Aux Id: ERIERL-648\n\n- Make ssh algorithm selection better handle dynamic changes changes in crypto\n  fips mode.\n\n  Own Id: OTP-17795","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"Ssh 4.12.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-12-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed a race condition in the acceptor loop: if a client disconnected\n  immediately after the tcp connect, the server could cease handling connection\n  on that address:port.\n\n  Own Id: OTP-17764 Aux Id: ERIERL-726","ref":"notes.html#fixed-bugs-and-malfunctions-65"},{"type":"extras","title":"Ssh 4.12.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-12-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed that a slow start (>30s) of a client subsystem could cause a log entry\n  with the password.\n\n  Own Id: OTP-17390 Aux Id: ERIERL-648\n\n- Fixed an error when running as an sftp server and a client requests a\n  directory contents listing.\n\n  The fix is to handle the error code `{error, eacces}` as `{error, enoent}` in\n  the `ssh_sftpd:get_attrs/5` internal function; that is, just skip it.\n\n  Own Id: OTP-17586 Aux Id: GH-5014","ref":"notes.html#fixed-bugs-and-malfunctions-66"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The \"Key exchange failed\" Info Report is now more informative.\n\n  Own Id: OTP-17450 Aux Id: ERIERL-655","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"Ssh 4.12.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-12-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Filter out sensitive data (passwords etc) from progress reports and supervisor\n  reports.\n\n  Own Id: OTP-17468 Aux Id: ERIERL-656","ref":"notes.html#fixed-bugs-and-malfunctions-67"},{"type":"extras","title":"Ssh 4.12.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-12-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Avoid an extra blank line in the ssh known_hosts file\n\n  Own Id: OTP-17427","ref":"notes.html#fixed-bugs-and-malfunctions-68"},{"type":"extras","title":"Ssh 4.12.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-12-1"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Add missing `known_hosts` and `authorized_keys` file types to\n  `ssh_file:decode/2` and `ssh_file:encode/2`.\n\n  Own Id: OTP-17397","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"Ssh 4.12 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Missing runtime dependencies has been added to this application.\n\n  Own Id: OTP-17243 Aux Id: PR-4557\n\n- The send window handling is changed to not initialize a too large window on\n  some occasions.\n\n  Own Id: OTP-17353","ref":"notes.html#fixed-bugs-and-malfunctions-69"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Removed usage of `erlang:is_port/1` from the SSH implementation.\n\n  Own Id: OTP-16750\n\n- Internal connection setup refactoring.\n\n  Own Id: OTP-17051\n\n- Refactor SSH fsm into a (hopefully) more comprehensible set of gen_statem\n  callback-files.\n\n  Own Id: OTP-17140\n\n- The RSA SHA1 sign/verify variants are disabled by default. That is, ssh-rsa is\n  disabled by default as well as the SHA1 sign/verify with RSA keys from id_rsa\n  and ssh_host_rsa_key. All SHA2 sign/verify are enabled by default.\n\n  The reason is that SHA1 is now considered easy to break.\n\n  To enable RSA with SHA1, for example for a very old and unsafe peer, see\n  [Example 9](configure_algos.md#example-9) in the User's Guide chapter\n  [Configuring algorithms in SSH](configure_algos.md).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-17259 Aux Id: OTP-16511, ERIERL-619\n\n- Adapt ssh supervisors to the new 'significant' and 'auto_shutdown' flags in\n  supervisor.\n\n  Own Id: OTP-17322 Aux Id: PR-4638, EEP-56, OTP-17334\n\n- The functions public_key:ssh_encode/2, public_key:ssh_decode/2,\n  public_key:ssh_hostkey_fingerprint/1 and public_key:ssh_hostkey_fingerprint/2\n  are deprecated.\n\n  Replacement functions are available in SSH, see the\n  [Deprecations](`e:general_info:deprecations.md#otp-24`) chapter in the\n  Erlang/OTP documentation.\n\n  Own Id: OTP-17352","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"Ssh 4.11.1.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change (being response to CVE-2023-48795), ssh can negotiate \"strict KEX\" OpenSSH extension with peers supporting it; also 'chacha20-poly1305@openssh.com' algorithm becomes a less preferred cipher.\n\n  If strict KEX availability cannot be ensured on both connection sides, affected encryption modes(CHACHA and CBC) can be disabled with standard ssh configuration. This will provide protection against vulnerability, but at a cost of affecting interoperability. See Configuring algorithms in SSH User's Guide.\n\n  Thanks to Fabian Bäumer, Marcus Brinkmann and Jörg Schwenk.\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18897\n* With this change, KEX strict terminal message is emitted with debug verbosity.\n\n  Own Id: OTP-19002 Aux Id: ERIERL-1041","ref":"notes.html#fixed-bugs-and-malfunctions-70"},{"type":"extras","title":"Ssh 4.11.1.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Binaries can be limited in logs with the parameter `max_log_item_len`. The\n  default value is 500 bytes.\n\n  Own Id: OTP-18094","ref":"notes.html#fixed-bugs-and-malfunctions-71"},{"type":"extras","title":"Ssh 4.11.1.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed problem with blocked server after multiple restarts. Applies to daemons\n  with options `{parallel_login,true}` and also `{max_sessions, int()>0}`.\n\n  Own Id: OTP-17835 Aux Id: ERIERL-721","ref":"notes.html#fixed-bugs-and-malfunctions-72"},{"type":"extras","title":"Ssh 4.11.1.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The value of the `connect_timeout` option is now used as default value for the\n  negotiation timeout.\n\n  Own Id: OTP-17707 Aux Id: ERIERL-706","ref":"notes.html#fixed-bugs-and-malfunctions-73"},{"type":"extras","title":"Ssh 4.11.1.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Filter out sensitive data (passwords etc) from progress reports and supervisor\n  reports.\n\n  Own Id: OTP-17468 Aux Id: ERIERL-656","ref":"notes.html#fixed-bugs-and-malfunctions-74"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The \"Key exchange failed\" Info Report is now more informative.\n\n  Own Id: OTP-17450 Aux Id: ERIERL-655","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"Ssh 4.11.1.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Avoid an extra blank line in the ssh known_hosts file\n\n  Own Id: OTP-17427","ref":"notes.html#fixed-bugs-and-malfunctions-75"},{"type":"extras","title":"Ssh 4.11.1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed that a slow start (>30s) of a client subsystem could cause a log entry\n  with the password.\n\n  Own Id: OTP-17390 Aux Id: ERIERL-648","ref":"notes.html#fixed-bugs-and-malfunctions-76"},{"type":"extras","title":"Ssh 4.11.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The idle_time timer was not cancelled when a channel was opened within the\n  timeout time on an empty connection that have had channels previously.\n\n  Own Id: OTP-17279","ref":"notes.html#fixed-bugs-and-malfunctions-77"},{"type":"extras","title":"Ssh 4.11 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-11"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The long name field in SSH_FXP_NAME responses to display file information in\n  sftp version 3 now contains the expanded format defined in the sftp draft. It\n  is similar to what is returned by \"ls -l\" on Unix systems.\n\n  Own Id: OTP-17197 Aux Id: PR- 3049","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"Ssh 4.10.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Don't timeout slow connection setups and tear-downs. A rare crash risk for the\n  controller is also removed.\n\n  Own Id: OTP-17173 Aux Id: ERIERL-581","ref":"notes.html#fixed-bugs-and-malfunctions-78"},{"type":"extras","title":"Ssh 4.10.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The SSH daemon erroneously replaced LF with CRLF also when there was no pty\n  requested from the server.\n\n  Own Id: OTP-17108 Aux Id: ERL-1442","ref":"notes.html#fixed-bugs-and-malfunctions-79"},{"type":"extras","title":"Ssh 4.10.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed problems in the ssh cli/shell handling. Most important are:\n\n  1. the ssh:shell function did sometimes cause the input to be echoed twice,\n\n  2. the ssh:shell function didn't transfer the LANG and LC_ALL shell variables\n     to the connected server which sometimes made Unicode handling erroneous,\n\n  3. Unicode was not always transferred correctly to and from the peer.\n\n  Own Id: OTP-16799\n\n- The SSH protocol message SSH_MSG_DISCONNECT was sometimes sent instead of\n  SSH_MSG_CHANNEL_FAILURE\n\n  Own Id: OTP-16900\n\n- The ssh_cli module now always sends the exit-status to connected clients so\n  they can use that to check for successful command execution.\n\n  Own Id: OTP-16908 Aux Id: PR-2753","ref":"notes.html#fixed-bugs-and-malfunctions-80"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- A new option [`pk_check_user`](`m:ssh#option-pk_check_user`) enables checking\n  of the client's user name in the server when doing public key authentication.\n\n  Own Id: OTP-16889","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"Ssh 4.10.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- An ssh-client can take an accepted socket from a listening socket and do an\n  ssh:connect/2 on it.\n\n  Multiple clients on sockets accepted from the same listening socket had\n  stopped working. This is corrected now.\n\n  Own Id: OTP-17021 Aux Id: ERIERL-567","ref":"notes.html#fixed-bugs-and-malfunctions-81"},{"type":"extras","title":"Ssh 4.10.4.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Filter out sensitive data (passwords etc) from progress reports and supervisor\n  reports.\n\n  Own Id: OTP-17468 Aux Id: ERIERL-656","ref":"notes.html#fixed-bugs-and-malfunctions-82"},{"type":"extras","title":"Ssh 4.10.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The inet option raw was not passed on from the ssh option list to inet.\n\n  Own Id: OTP-17016 Aux Id: ERIERL-562","ref":"notes.html#fixed-bugs-and-malfunctions-83"},{"type":"extras","title":"Ssh 4.10.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- A supervisor sub-tree could be left if the connection handler process is\n  brutally killed. This will make the max_sessions checking option to count the\n  existing sessions erroneously and could finally block further sessions.\n\n  Own Id: OTP-17006 Aux Id: ERIERL-556","ref":"notes.html#fixed-bugs-and-malfunctions-84"},{"type":"extras","title":"Ssh 4.10.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix decoder bug.\n\n  Own Id: OTP-16904","ref":"notes.html#fixed-bugs-and-malfunctions-85"},{"type":"extras","title":"Ssh 4.10.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed a bug when a message to ssh-agent was divided into separate packets.\n\n  Own Id: OTP-16761 Aux Id: PR-2679\n\n- Fix a bug that could crash the cli server if a too large cli-window was\n  requested from the client.\n\n  Own Id: OTP-16791 Aux Id: ERIERL-520","ref":"notes.html#fixed-bugs-and-malfunctions-86"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Increased test coverage.\n\n  Own Id: OTP-14106\n\n- A chapter about [hardening the OTP SSH](hardening.md) is added to the User's\n  Guide.\n\n  Own Id: OTP-16411\n\n- The internal Diffie-Hellman high level API for key generation was slow in old\n  and by OpenSSL now unsupported cryptolib versions (1.0.1 and earlier).\n\n  If such a cryptolib is used anyhow, the low-level API is used internally in\n  the crypto application.\n\n  Own Id: OTP-16774\n\n- A new timeout is defined for daemons:\n  [hello_timeout](`t:ssh:hello_timeout_daemon_option/0`).\n\n  The timeout is supposed to be used as a simple\n  [DoS attack protection](hardening.md#resilience-to-dos-attacks). It closes an\n  incoming TCP-connection if no valid first SSH message is received from the\n  client within the timeout limit after the TCP initial connection setup.\n\n  The initial value is 30s by compatibility reasons, but could be lowered if\n  needed, for example in the code or in a [config file](configurations.md).\n\n  Own Id: OTP-16803","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"Ssh 4.10 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix error in ssh_sftpd typespec.\n\n  Own Id: OTP-16363","ref":"notes.html#fixed-bugs-and-malfunctions-87"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The plug-in file ssh_file.erl, that is responsible for default file handling,\n  is re-factored, optimized and re-written.\n\n  Own Id: OTP-11688 Aux Id: OTP-12699\n\n- OpenSSH 6.5 introduced a new file representation of keys called\n  [openssh-key-v1](https://cvsweb.openbsd.org/src/usr.bin/ssh/PROTOCOL.key?annotate=1.1).\n\n  OTP/SSH had an experimental implementation of this format. That implementation\n  is now improved and supported with the exception of handling encrypted keys.\n\n  Own Id: OTP-15434\n\n- TCP/IP port forwarding, a.k.a tunneling a.k.a tcp-forward/direct-tcp is\n  implemented. In the OpenSSH client, this corresponds to the options -L and -R.\n\n  The client or server listens to a specified socket, and when something\n  connects to it with TCP/IP, that connection is forwarded in an encrypted\n  tunnel to the peer. The peer then connects to a predefined IP/port pair and\n  then acts as a proxy.\n\n  See the manual, `ssh:tcpip_tunnel_to_server/6` and\n  `ssh:tcpip_tunnel_from_server/6`.\n\n  The functionality is disabled per default but can be enabled when starting a\n  daemon.\n\n  Own Id: OTP-15998 Aux Id: PR-2376, PR-2368\n\n- The client-side of the supervisor tree (under sshc_sup) was previously not\n  complete; the channel handling processes were handled with links but had no\n  supervisors.\n\n  This is now corrected with a client-side supervisor tree under `sshc_sup`,\n  similar to the server-side supervisor tree under `sshd_sup`.\n\n  Own Id: OTP-16026 Aux Id: PR-2368, (OTP-15998)\n\n- The extension\n  [posix-rename@openssh.com](https://cvsweb.openbsd.org/src/usr.bin/ssh/PROTOCOL?annotate=HEAD)\n  is added to the [ssh/sftp rename](`ssh_sftp:rename/3`) operation.\n\n  Own Id: OTP-16289 Aux Id: PR-2448\n\n- Calls of deprecated functions in the\n  [Old Crypto API](`e:crypto:new_api.md#the-old-api`) are replaced by calls of\n  their [substitutions](`e:crypto:new_api.md#the-new-api`).\n\n  Own Id: OTP-16346\n\n- The default known_hosts file handling is improved to include ports.\n\n  The handling of the contents in that file is updated to support the\n  [full syntax](https://man.openbsd.org/sshd#SSH_KNOWN_HOSTS_FILE_FORMAT), with\n  exception of 1) the wildcard '?', 2) wildcards in canonical names and 3) the\n  option '@cert-authority'\n\n  Own Id: OTP-16506\n\n- The MAC (Message Authorization Code) algorithms\n\n  - hmac-sha1-etm@openssh.com\n  - hmac-sha2-256-etm@openssh.com\n  - hmac-sha2-512-etm@openssh.com\n\n  are implemented.\n\n  Own Id: OTP-16508\n\n- The key-exchange algorithms `'diffie-hellman-group14-sha1'` and\n  `'diffie-hellman-group-exchange-sha1'` are disabled per default. The reason is\n  that SHA1 now is considered insecure.\n\n  They can be enabled if needed, see [SSH (App)](ssh_app.md#algorithms).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16509\n\n- The public key algorithm `'ssh-dss'` is disabled per default. The reason is\n  that it is now considered as insecure.\n\n  It can be enabled if needed, see [SSH (App)](ssh_app.md#algorithms).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16510\n\n- The public key `'ssh-rsa'` is now considered as insecure because of its usage\n  of SHA1.\n\n  It is therefore deprecated and will no longer be enabled per default in\n  OTP-24.0.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16511\n\n- An option [optimize (optimize_key_lookup)](`t:ssh_file:optimize_key_lookup/0`)\n  is introduced for the file interface ssh_file.erl\n\n  The option enables the user to select between the default handling which is\n  fast but memory consuming vs memory efficient but not as fast. The effect\n  might be observable only for large files.\n\n  See the manual for `ssh_file:is_host_key/5` and `ssh_file:is_auth_key/3`.\n\n  Own Id: OTP-16512\n\n- The ssh agent is now implemented in the ssh_agent key callback module.\n\n  Enable with the the option `{key_cb, {ssh_agent, []}}` in for example\n  ssh:connect/3.\n\n  See the [ssh_agent manual](`m:ssh_agent`) for details.\n\n  Own Id: OTP-16513\n\n- Algorithm configuration could now be done in a .config file.\n\n  This is useful for example to enable an algorithm that is disabled by default.\n  It could now be enabled in an .config-file without changing the code,\n\n  See the SSH User's Guide chapter [\"Configuration in SSH\"](configurations.md).\n\n  Own Id: OTP-16540\n\n- Documented which gen_tcp socket options can't be used in calls to ssh:connect\n  and ssh:daemon.\n\n  Own Id: OTP-16589\n\n- Added [kb_int_fun_4()](`t:ssh:kb_int_fun_4/0`) to the\n  [authentication_daemon_options()](`t:ssh:authentication_daemon_options/0`) to\n  enable generating dynamic keyboard-interactive prompts from the user's state\n  returned from the authentication fun [pwdfun_4()](`t:ssh:pwdfun_4/0`).\n\n  Own Id: OTP-16622 Aux Id: PR-2604","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"Ssh 4.9.1.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"* With this change (being response to CVE-2023-48795), ssh can negotiate \"strict KEX\" OpenSSH extension with peers supporting it; also 'chacha20-poly1305@openssh.com' algorithm becomes a less preferred cipher.\n\n  If strict KEX availability cannot be ensured on both connection sides, affected encryption modes(CHACHA and CBC) can be disabled with standard ssh configuration. This will provide protection against vulnerability, but at a cost of affecting interoperability. See Configuring algorithms in SSH User's Guide.\n\n  Thanks to Fabian Bäumer, Marcus Brinkmann and Jörg Schwenk.\n\n  \\*** POTENTIAL INCOMPATIBILITY ***\n\n  Own Id: OTP-18897\n* With this change, KEX strict terminal message is emitted with debug verbosity.\n\n  Own Id: OTP-19002 Aux Id: ERIERL-1041","ref":"notes.html#fixed-bugs-and-malfunctions-88"},{"type":"extras","title":"Ssh 4.9.1.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The value of the `connect_timeout` option is now used as default value for the\n  negotiation timeout.\n\n  Own Id: OTP-17707 Aux Id: ERIERL-706","ref":"notes.html#fixed-bugs-and-malfunctions-89"},{"type":"extras","title":"Ssh 4.9.1.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The idle_time timer was not cancelled when a channel was opened within the\n  timeout time on an empty connection that have had channels previously.\n\n  Own Id: OTP-17279","ref":"notes.html#fixed-bugs-and-malfunctions-90"},{"type":"extras","title":"Ssh 4.9.1.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix decoder bug.\n\n  Own Id: OTP-16904","ref":"notes.html#fixed-bugs-and-malfunctions-91"},{"type":"extras","title":"Ssh 4.9.1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix a bug that could crash the cli server if a too large cli-window was\n  requested from the client.\n\n  Own Id: OTP-16791 Aux Id: ERIERL-520","ref":"notes.html#fixed-bugs-and-malfunctions-92"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- A new timeout is defined for daemons: `hello_timeout`.\n\n  It closes an incoming TCP-connection if no valid 1st message is received from\n  the client within the timeout limit.\n\n  Own Id: OTP-16803","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"Ssh 4.9.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Potential hazard between re-keying decision and socket close.\n\n  Own Id: OTP-16462 Aux Id: ERIERL-464","ref":"notes.html#fixed-bugs-and-malfunctions-93"},{"type":"extras","title":"Ssh 4.9 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Unicode problems for ssh_sftp:write fixed.\n\n  Own Id: OTP-16377","ref":"notes.html#fixed-bugs-and-malfunctions-94"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Changes to the internal api of the experimental ssh_dbg tool.\n\n  Own Id: OTP-16353\n\n- The new functions `ssh:set_sock_opts/2` and `ssh:get_sock_opts/2` sets and\n  reads option values for the underlying TCP stream.\n\n  Own Id: OTP-16485","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"Ssh 4.8.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed that `ssh_connection:send` could allocate a large amount of memory if\n  given an iolist() as input data.\n\n  Own Id: OTP-16373\n\n- Safe atom conversions.\n\n  Own Id: OTP-16375\n\n- Constant time comparisons added.\n\n  Own Id: OTP-16376","ref":"notes.html#fixed-bugs-and-malfunctions-95"},{"type":"extras","title":"Ssh 4.8.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The ssh cli (e.g shell) server behaved strangely when characters were inserted\n  in a string such that the last characters tried to wrap the line.\n\n  Own Id: OTP-14849 Aux Id: ERL-545\n\n- If an OTP SSH server was serving an \"exec\" request and the executed code used\n  Erlang `standard_io` for input/output, the I/O was erroneously handled by the\n  _server's_ group leader, so the I/O turned up in the the server's Erlang shell\n  (if any). The user at the client side did therefore not see that I/O.\n\n  This is corrected now, so the client - for example the ssh OS shell command -\n  handles the I/O. The user could send input to the server side exec handling\n  code by writing on the terminal, and server side output from for example\n  io:format is presented on the terminal - not only the functional result.\n\n  NOTE 1: Servers executing exec requests with the old, undocumented ways of\n  specifying the custom exec handler is not changed. Changed are only the two\n  cases where the server's 'exec' option either:\n\n  1. is not specified (i.e. using the default shell) or,\n  2. it has the `{direct, fun(...) -> ... end}` value format.\n\n  NOTE 2: Previously an end-of-line marker was appended on the result and error\n  reports at the client side. They are removed now and the error reports are\n  slightly enhanced.\n\n  TECHNICAL DETAILS: The server's device `standard_input` receives data events\n  from the exec request's channel, and the device `standard_output` is sending\n  its data by data events to the client on that channel. The result is that\n  `standard_io` is now performed by the client's group leader.\n\n  Own Id: OTP-15417 Aux Id: OTP-16108\n\n- The functions ssh:shell/1,2,3 left the connection open when they returned.\n  That leakage is fixed now.\n\n  Own Id: OTP-16047\n\n- Corrected that an Erlang SSH server could return the status code 4294967295\n  instead of 255 on some errors of an exec request.\n\n  Own Id: OTP-16123","ref":"notes.html#fixed-bugs-and-malfunctions-96"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Internal simplification of ssh_sftp/ssh_xfer\n\n  Own Id: OTP-15972\n\n- The documentation of [One-Time Execution](using_ssh.md#one-time-execution) in\n  the User's Guide is updated with more examples.\n\n  Own Id: OTP-16108 Aux Id: OTP-15417\n\n- The new value `'disabled'` is introduced in the SSH daemon options 'exec' and\n  'shell'. Previously they lacked a clear way of disabling them.\n\n  Own Id: OTP-16113\n\n- The old algorithms 'aes192_cbc', 'aes256_cbc' and 'hmac-sha1-96' are added for\n  compatibility with older peers.\n\n  The mac 'hmac-sha1-96' is nowadays not recommended and must therefore be\n  explicitly enabled. Use for example the Option value\n  `{modify_algorithms, [{append, [{mac,['hmac-sha1-96']}]}]}`\n\n  Own Id: OTP-16170","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"Ssh 4.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed wrong type definition for the daemon option `subsystems`.\n\n  Own Id: OTP-15820\n\n- Fixed a possible SSH logging crash if there was a problem in an early stage of\n  session setup.\n\n  Own Id: OTP-15962 Aux Id: ERL-990","ref":"notes.html#fixed-bugs-and-malfunctions-97"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The documentation for the modules ssh_connection, ssh_sftp and ssh_sftpd are\n  now generated from the -spec:s.\n\n  Own Id: OTP-15395\n\n- Internal cleanup including removal of the internal file `ssh_userauth.hrl`.\n\n  Own Id: OTP-15876 Aux Id: PR-2255, PR-2256\n\n- Removed unused definitions in `ssh.hrl`.\n\n  Own Id: OTP-15929 Aux Id: PR-2297\n\n- Removed unused fields in the internal `#connection{}` record.\n\n  Own Id: OTP-15984\n\n- To get information of a `connection_ref()` from for example `ssh:connect/3`,\n  there was previously one function available namely `ssh:connection_info/2`.\n  This ticket adds `ssh:connection_info/1` which returns all information.\n\n  For daemons (servers) started with for example `ssh:daemon/2` the function\n  `ssh:daemon_info/1` returning all information was available. This ticket adds\n  `ssh:daemon_info/2` which returns only the information specified in the second\n  argument.\n\n  The info of connections and of daemons now also includes the item '`options`'.\n  Only those options that does not have their default values are returned.\n\n  For a connection also the items '`algorithms`' and '`channels`' are added.\n\n  Own Id: OTP-16040","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"Ssh 4.7.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-7"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- SSH uses the new crypto API.\n\n  Own Id: OTP-15673","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"Ssh 4.7.6.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The idle_time timer was not cancelled when a channel was opened within the\n  timeout time on an empty connection that have had channels previously.\n\n  Own Id: OTP-17279","ref":"notes.html#fixed-bugs-and-malfunctions-98"},{"type":"extras","title":"Ssh 4.7.6.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix decoder bug.\n\n  Own Id: OTP-16904","ref":"notes.html#fixed-bugs-and-malfunctions-99"},{"type":"extras","title":"Ssh 4.7.6.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Potential hazard between re-keying decision and socket close.\n\n  Own Id: OTP-16462 Aux Id: ERIERL-464","ref":"notes.html#fixed-bugs-and-malfunctions-100"},{"type":"extras","title":"Ssh 4.7.6.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed that `ssh_connection:send` could allocate a large amount of memory if\n  given an iolist() as input data.\n\n  Own Id: OTP-16373\n\n- Safe atom conversions.\n\n  Own Id: OTP-16375\n\n- Constant time comparisons added.\n\n  Own Id: OTP-16376","ref":"notes.html#fixed-bugs-and-malfunctions-101"},{"type":"extras","title":"Ssh 4.7.6.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The ssh cli (e.g shell) server behaved strangely when characters were inserted\n  in a string so that the last characters tried to wrap the line.\n\n  Own Id: OTP-14849 Aux Id: ERL-545","ref":"notes.html#fixed-bugs-and-malfunctions-102"},{"type":"extras","title":"Ssh 4.7.6.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed a possible SSH logging crash if there was a problem in an early stage of\n  session setup.\n\n  Own Id: OTP-15962 Aux Id: ERL-990","ref":"notes.html#fixed-bugs-and-malfunctions-103"},{"type":"extras","title":"Ssh 4.7.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-6"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- When an SSH server receives the very first message on a new TCP connection,\n  and that message is not the expected one, the 64 first bytes of the received\n  message are now dumped in the INFO REPORT that reports the Protocol Error.\n\n  This facilitates the debugging of who sends the bad message or of detecting a\n  possible port scanning.\n\n  Own Id: OTP-15772","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"Ssh 4.7.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The callback `ssh_channel:init/1` was missing in OTP-21\n\n  Own Id: OTP-15762\n\n- If a client was connected to an server on an already open socket, the callback\n  `fun(PeerName,FingerPrint)` in the `accept_callback` option passed the local\n  name in the argument PeerName instead of the remote name.\n\n  Own Id: OTP-15763","ref":"notes.html#fixed-bugs-and-malfunctions-104"},{"type":"extras","title":"Ssh 4.7.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH sftp daemon now accepts an SSH_FXP_STAT message encoded according to the\n  wrong sftp version. Some clients sends such messages.\n\n  Own Id: OTP-15498 Aux Id: ERL-822, PR-2077","ref":"notes.html#fixed-bugs-and-malfunctions-105"},{"type":"extras","title":"Ssh 4.7.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed port leakage if a ssh:daemon call failed.\n\n  Own Id: OTP-15397 Aux Id: ERL-801","ref":"notes.html#fixed-bugs-and-malfunctions-106"},{"type":"extras","title":"Ssh 4.7.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Incompatibility with newer OpenSSH fixed. Previously versions 7.8 and later\n  could cause Erlang SSH to exit.\n\n  Own Id: OTP-15413\n\n- The '`exec`' option for ssh daemons had wrong format in the documentation.\n\n  Own Id: OTP-15416","ref":"notes.html#fixed-bugs-and-malfunctions-107"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Added public key methods ssh-ed25519 and ssh-ed448.\n\n  Requires OpenSSL 1.1.1 or higher as cryptolib under the OTP application\n  `crypto`.\n\n  Own Id: OTP-15094 Aux Id: OTP-15419\n\n- The SSH property tests are now adapted to the PropEr testing tool.\n\n  Own Id: OTP-15312\n\n- The term \"user\" was not documented in the SSH app. A new chapter with\n  terminology is added to the User's Manual where the term \"user\" is defined.\n\n  A reference manual page about the module `ssh_file` is also added. This is the\n  default callback module for user's keys, host keys etc.\n\n  Own Id: OTP-15314\n\n- Host and user key checking is made more robust.\n\n  Own Id: OTP-15424","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"Ssh 4.7.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7-1"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Extended the undocumented `ssh_dbg` debug module with an api for a circular\n  trace buffer. This makes it easy to record the last low-level events before an\n  error is detected. It is intended for solving difficult errors.\n\n  Own Id: OTP-15020\n\n- The key exchange methods `'curve25519-sha256@libssh.org'`,\n  `'curve25519-sha256'` and `'curve448-sha512'` are implemented. The last two\n  are defined in https://tools.ietf.org/html/draft-ietf-curdle-ssh-curves\n\n  They all depends on that OpenSSL 1.1.1 or higher is used as cryptolib.\n\n  Own Id: OTP-15133 Aux Id: OTP-15240\n\n- The cipher '`chacha20-poly1305@openssh.com`' is now supported if OpenSSL 1.1.1\n  or higher is used as cryptolib.\n\n  Own Id: OTP-15209 Aux Id: OTP-15164","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Ssh 4.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- If the daemon port listener is restarted, it could potentially fail with\n  `eaddrinuse` if the timing is unlucky. It will now retry and exponentially\n  back off the listener restart a few times before failing.\n\n  Own Id: OTP-14955\n\n- A channel callback module always got the module name as reason in a call to\n  terminate. Now it will get the proper Reason, usually 'normal'.\n\n  Own Id: OTP-15084","ref":"notes.html#fixed-bugs-and-malfunctions-108"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The option `exec` has new option values defined to make it much more easy to\n  implement an own `exec` server.\n\n  An option called `exec` for daemons implementing the handling of 'exec'\n  requests has existed a long time but has been undocumented. The old\n  undocumented value - as well as its behavior - is kept for compatibility\n  EXCEPT that error messages are changed and are sent as \"stderror\" text.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14851\n\n- Updated ssh_connection:shell/2 documentation.\n\n  Own Id: OTP-14880\n\n- The experimental `ssh_dbg` module is completely re-written. Its purpose is to\n  make tracing and debugging easier on deployed systems.\n\n  Own Id: OTP-14896\n\n- The SSH supervisor structure has been slightly changed. This makes stopping\n  the ssh application considerably faster if there are open connections. This is\n  important in for example restarts.\n\n  Own Id: OTP-14988\n\n- The type specifications in SSH are completely reworked and the following types\n  are renamed:\n\n  `ssh:ssh_connection_ref()` is changed to\n  [`ssh:connection_ref()`](`t:ssh:connection_ref/0`),\n\n  `ssh:ssh_daemon_ref()` is changed to\n  [`ssh:daemon_ref()`](`t:ssh:daemon_ref/0`),\n\n  `ssh:ssh_channel_id()` is changed to\n  [`ssh:channel_id()`](`t:ssh:channel_id/0`).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15002 Aux Id: OTP-15030\n\n- The internal timer handling in SSH is now based on the gen_statem timers.\n\n  Own Id: OTP-15019\n\n- Removed the undocumented and unused modules `ssh_client_key.erl` and\n  `ssh_server_key.erl`.\n\n  Own Id: OTP-15028\n\n- The Reference Manual pages are partly updated.\n\n  The ssh page is now generated from specs and types, is restructured and is\n  partly rephrased.\n\n  The ssh_channel, ssh_connection, ssh_client_key_api, ssh_server_key_api and\n  ssh_sftp pages are updated with links, correct type names and some minor\n  changes.\n\n  Own Id: OTP-15030 Aux Id: OTP-15002\n\n- The behaviors `ssh_channel` and `ssh_daemon_channel` are renamed to\n  `ssh_client_channel` and `ssh_server_channel` respectively.\n\n  The old modules are kept for compatibility but should preferably be replaced\n  when updating callback modules referring them.\n\n  Own Id: OTP-15041\n\n- New test suite for channels.\n\n  Own Id: OTP-15051\n\n- The `rekey_limit` option could now set the max time as well as the previously\n  max data amount.\n\n  Own Id: OTP-15069 Aux Id: ERL-617\n\n- Changed process exit supervision from links to monitors.\n\n  Own Id: OTP-15082\n\n- Better handling of misbehaving channel callback modules.\n\n  Own Id: OTP-15083\n\n- A new moduli file is generated. This file is used for the recommended\n  `diffie-hellman-group-exchange-sha256` key exchange algorithm in SSH.\n\n  Own Id: OTP-15113","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"Ssh 4.6.9.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed possible hanging in `ssh_sftp:stop_channel/1`.\n\n  Own Id: OTP-16507 Aux Id: ERIERL-470","ref":"notes.html#fixed-bugs-and-malfunctions-109"},{"type":"extras","title":"Ssh 4.6.9.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed that `ssh_connection:send` could allocate a large amount of memory if\n  given an iolist() as input data.\n\n  Own Id: OTP-16373\n\n- Safe atom conversions.\n\n  Own Id: OTP-16375\n\n- Constant time comparisons added.\n\n  Own Id: OTP-16376","ref":"notes.html#fixed-bugs-and-malfunctions-110"},{"type":"extras","title":"Ssh 4.6.9.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The ssh cli (e.g shell) server behaved strangely when characters were inserted\n  in a string so that the last characters tried to wrap the line.\n\n  Own Id: OTP-14849 Aux Id: ERL-545","ref":"notes.html#fixed-bugs-and-malfunctions-111"},{"type":"extras","title":"Ssh 4.6.9.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- If a client was connected to an server on an already open socket, the callback\n  `fun(PeerName,FingerPrint)` in the `accept_callback` option passed the local\n  name in the argument PeerName instead of the remote name.\n\n  Own Id: OTP-15763","ref":"notes.html#fixed-bugs-and-malfunctions-112"},{"type":"extras","title":"Ssh 4.6.9.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed port leakage if a ssh:daemon call failed.\n\n  Own Id: OTP-15397 Aux Id: ERL-801","ref":"notes.html#fixed-bugs-and-malfunctions-113"},{"type":"extras","title":"Ssh 4.6.9.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Incompatibility with newer OpenSSH fixed. Previously versions 7.8 and later\n  could cause Erlang SSH to exit.\n\n  Own Id: OTP-15413","ref":"notes.html#fixed-bugs-and-malfunctions-114"},{"type":"extras","title":"Ssh 4.6.9.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SFTP clients reported the error reason `\"\"` if a non-OTP sftp server was\n  killed during a long file transmission.\n\n  Now the signal name (for example `\"KILL\"`) will be the error reason if the\n  server's reason is empty.\n\n  The documentation also lacked type information about this class of errors.\n\n  Own Id: OTP-15148 Aux Id: ERIERL-194\n\n- Fix ssh_sftp decode error for sftp protocol version 4\n\n  Own Id: OTP-15149 Aux Id: ERIERL-199","ref":"notes.html#fixed-bugs-and-malfunctions-115"},{"type":"extras","title":"Ssh 4.6.9 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Host key hash erroneously calculated for clients following draft-00 of RFC\n  4419, for example PuTTY\n\n  Own Id: OTP-15064\n\n- Renegotiation could fail in some states\n\n  Own Id: OTP-15066","ref":"notes.html#fixed-bugs-and-malfunctions-116"},{"type":"extras","title":"Ssh 4.6.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- An ssh_sftp server (running version 6) could fail if it is told to remove a\n  file which in fact is a directory.\n\n  Own Id: OTP-15004\n\n- Fix rare spurious shutdowns of ssh servers when receiving `{'EXIT',_,normal}`\n  messages.\n\n  Own Id: OTP-15018","ref":"notes.html#fixed-bugs-and-malfunctions-117"},{"type":"extras","title":"Ssh 4.6.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix bad spec in ssh.hrl: `double_algs()`.\n\n  Own Id: OTP-14990","ref":"notes.html#fixed-bugs-and-malfunctions-118"},{"type":"extras","title":"Ssh 4.6.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Remove a blocking risk when a channel is closed and an operation is tried on\n  that channel after at least a second's time gap.\n\n  Own Id: OTP-14939","ref":"notes.html#fixed-bugs-and-malfunctions-119"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Added ssh_compat_SUITE.\n\n  This suite contains a number of interoperability tests mainly with OpenSSH.\n  The tests start docker containers with different OpenSSH and\n  OpenSSL/LibreSSLcryptolib versions and performs a number of tests of supported\n  algorithms.\n\n  All login methods and all user's public key types are tested both for the\n  client and the server.\n\n  All algorithms for kex, cipher, host key, mac and compressions are tested with\n  a number of exec and sftp tests, both for the client and the server.\n\n  Own Id: OTP-14194 Aux Id: OTP-12487\n\n- Default exec is disabled when a user-defined shell is enabled.\n\n  Own Id: OTP-14881","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"Ssh 4.6.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Adjusted supervisor timeouts\n\n  Own Id: OTP-14907\n\n- Remove ERROR messages for slow process exits\n\n  Own Id: OTP-14930","ref":"notes.html#fixed-bugs-and-malfunctions-120"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Add option `save_accepted_host` to `ssh:connection`. This option, if set to\n  false, inhibits saving host keys to e.g the file `known_hosts`.\n\n  Own Id: OTP-14935","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Ssh 4.6.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix problem with OpenSSH 7.2 (and later) clients that has used sha1 instead of\n  sha2 for rsa-sha-256/512 user's public keys.\n\n  Own Id: OTP-14827 Aux Id: ERL-531","ref":"notes.html#fixed-bugs-and-malfunctions-121"},{"type":"extras","title":"Ssh 4.6.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Passphrase option for ecdsa public keys was missing.\n\n  Own Id: OTP-14602","ref":"notes.html#fixed-bugs-and-malfunctions-122"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The host and user public key handling is hardened so that a faulty plugin\n  can't deliver a key of wrong type.\n\n  Better checks in the server of the available hostkey's types at start and at\n  each accept.\n\n  Better checks in the client of the available user public key types at connect.\n\n  Own Id: OTP-14676 Aux Id: ERIERL-52, OTP-14570\n\n- SSH can now fetch the host key from the private keys stored in an Engine. See\n  the crypto application for details about Engines.\n\n  Own Id: OTP-14757","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Ssh 4.6.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Trailing white space was removed at end of the hello-string. This caused\n  interoperability problems with some other ssh-implementations (e.g OpenSSH\n  7.3p1 on Solaris 11)\n\n  Own Id: OTP-14763 Aux Id: ERIERL-74\n\n- Fixes that tcp connections that was immediately closed (SYN, SYNACK, ACK, RST)\n  by a client could be left in a zombie state.\n\n  Own Id: OTP-14778 Aux Id: ERIERL-104","ref":"notes.html#fixed-bugs-and-malfunctions-123"},{"type":"extras","title":"Ssh 4.6.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed broken printout\n\n  Own Id: OTP-14645","ref":"notes.html#fixed-bugs-and-malfunctions-124"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Disable aes_gcm ciphers if peer is OpenSSH 6.2 which is known to have trouble\n  with them in some cases.\n\n  Own Id: OTP-14638","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"Ssh 4.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Enables the `ssh_io module` to also accept binary values when reading\n  standard_io instead of getting stuck in the receive clause.\n\n  Own Id: OTP-14506 Aux Id: PR1503\n\n- Previously, the file owner access permission in response to\n  ssh_sftp:read_file_info/2 function was always `read_write`. With this fix, the\n  actual value of file owner access permission is added to the returning record.\n  That value is calculated from file mode value.\n\n  Own Id: OTP-14550 Aux Id: PR1533","ref":"notes.html#fixed-bugs-and-malfunctions-125"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- A new option `modify_algorithms` is implemented. It enables specifying changes\n  on the default algorithms list. See the reference manual and the SSH User's\n  Guide chapter \"Configuring algorithms in SSH\".\n\n  Own Id: OTP-14568","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"Ssh 4.5.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- All unknown options are sent to the transport handler regardless of type.\n\n  Own Id: OTP-14541 Aux Id: EIRERL-63","ref":"notes.html#fixed-bugs-and-malfunctions-126"},{"type":"extras","title":"Ssh 4.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-5"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The internal handling of SSH options is re-written.\n\n  Previously there were no checks if a client option was given to a daemon or\n  vice versa. This is corrected now. If your code has e.g. a client-only option\n  in a call to start a daemon, the call will fail.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12872\n\n- Modernization of key exchange algorithms. See draft-ietf-curdle-ssh-kex-sha2\n  for a discussion.\n\n  Removed an outdated weak algorithm and added stronger replacements to keep\n  interoperability with other modern ssh clients and servers. The default\n  ordering of the algorithms is also adjusted.\n\n  Retired: The nowadays unsecure key-exchange `diffie-hellman-group1-sha1` is\n  not enabled by default, but can be enabled with the option\n  `preferred-algorithms`.\n\n  Added: The new stronger key-exchange `diffie-hellman-group16-sha512`,\n  `diffie-hellman-group18-sha512` and `diffie-hellman-group14-sha256` are added\n  and enabled by default.\n\n  The questionable \\[RFC 6194] sha1-based algorithms\n  `diffie-hellman-group-exchange-sha1` and `diffie-hellman-group14-sha1` are\n  however still kept enabled by default for compatibility with ancient clients\n  and servers that lack modern key-exchange alternatives. When the\n  draft-ietf-curdle-ssh-kex-sha2 becomes an rfc, those sha1-based algorithms and\n  `diffie-hellman-group1-sha1` will be deprecated by IETF. They might then be\n  removed from the default list in Erlang/OTP.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14110\n\n- Modernized internal representation of sftp by use of maps.\n\n  Own Id: OTP-14117\n\n- The Extension Negotiation Mechanism and the extension `server-sig-algs` in\n  draft-ietf-curdle-ssh-ext-info-05 are implemented.\n\n  The related draft-ietf-curdle-rsa-sha2-05 is implemented and introduces the\n  signature algorithms `rsa-sha2-256` and `rsa-sha2-512`.\n\n  Own Id: OTP-14193\n\n- The 'timeout' and 'connect_timeout' handling in ssh_sftp:start_channel\n  documentation is clarified.\n\n  Own Id: OTP-14216\n\n- The functions `ssh:connect`, `ssh:shell` and `ssh:start_channel` now accept an\n  IP-tuple as Host destination argument.\n\n  Own Id: OTP-14243\n\n- The function `ssh:daemon_info/1` now returns Host and Profile as well as the\n  Port info in the property list.\n\n  Own Id: OTP-14259\n\n- Removed the option `public_key_alg` which was deprecated in 18.2. Use\n  `pref_public_key_algs` instead.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14263\n\n- The SSH application is refactored regarding daemon starting. The resolution of\n  contradicting `Host` argument and `ip` option were not described. There were\n  also strange corner cases when the `'any'` value was used in `Host` argument\n  or `ip` option. This is (hopefully) resolved now, but it may cause\n  incompatibilities for code using both `Host` and the `ip` option. The value\n  'loopback' has been added for a correct way of naming those addresses.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14264\n\n- The supervisor code is refactored. The naming of listening IP-Port-Profile\n  triples are slightly changed to improve consistency in strange corner cases as\n  resolved by OTP-14264\n\n  Own Id: OTP-14267 Aux Id: OTP-14266\n\n- The `idle_time` option can now be used in daemons.\n\n  Own Id: OTP-14312\n\n- Added test cases for IETF-CURDLE Extension Negotiation (ext-info)\n\n  Own Id: OTP-14361\n\n- Testcases for IETF-CURDLE extension `server-sig-algs` including `rsa-sha2-*`\n\n  Own Id: OTP-14362 Aux Id: OTP-14361\n\n- The option `auth_methods` can now also be used in clients to select which\n  authentication options that are used and in which order.\n\n  Own Id: OTP-14399\n\n- Checks that a ECDSA public key (`ecdsa-sha2-nistp*`) stored in a file has the\n  correct size.\n\n  Own Id: OTP-14410","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"Ssh 4.4.2.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix rare spurious shutdowns of ssh servers when receiving `{'EXIT',_,normal}`\n  messages.\n\n  Own Id: OTP-15018\n\n- Host key hash erroneously calculated for clients following draft-00 of RFC\n  4419, for example PuTTY\n\n  Own Id: OTP-15064\n\n- Renegotiation could fail in some states\n\n  Own Id: OTP-15066","ref":"notes.html#fixed-bugs-and-malfunctions-127"},{"type":"extras","title":"Ssh 4.4.2.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- An ssh_sftp server (running version 6) could fail if it is told to remove a\n  file which in fact is a directory.\n\n  Own Id: OTP-15004","ref":"notes.html#fixed-bugs-and-malfunctions-128"},{"type":"extras","title":"Ssh 4.4.2.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4-2-2"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Default exec is disabled when a user-defined shell is enabled.\n\n  Own Id: OTP-14881","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Ssh 4.4.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Trailing white space was removed at end of the hello-string. This caused\n  interoperability problems with some other ssh-implementations (e.g OpenSSH\n  7.3p1 on Solaris 11)\n\n  Own Id: OTP-14763 Aux Id: ERIERL-74","ref":"notes.html#fixed-bugs-and-malfunctions-129"},{"type":"extras","title":"Ssh 4.4.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- ssh:daemon_info/1 crashed if the listening IP was not 'any'\n\n  Own Id: OTP-14298 Aux Id: seq13294","ref":"notes.html#fixed-bugs-and-malfunctions-130"},{"type":"extras","title":"Ssh 4.4.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix bug when opening connections. If the tcp setup failed, that would in some\n  cases not result in an error return value.\n\n  Own Id: OTP-14108\n\n- Reduce information leakage in case of decryption errors.\n\n  Own Id: OTP-14109\n\n- The key exchange algorithm diffie-hellman-group-exchange-sha\\* has a\n  server-option `{dh_gex_limits,{Min,Max}}`. There was a hostkey signature\n  validation error on the client side if the option was used and the `Min` or\n  the `Max` differed from the corresponding values obtained from the client.\n\n  This bug is now corrected.\n\n  Own Id: OTP-14166\n\n- The sftpd server now correctly uses `root_dir` and `cwd` when resolving file\n  paths if both are provided. The `cwd` handling is also corrected.\n\n  Thanks to kape1395\\!\n\n  Own Id: OTP-14225 Aux Id: PR-1331, PR-1335\n\n- Ssh_cli used a function that does not handle non-utf8 unicode correctly.\n\n  Own Id: OTP-14230 Aux Id: ERL-364","ref":"notes.html#fixed-bugs-and-malfunctions-131"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The implementation of the key exchange algorithms\n  diffie-hellman-group-exchange-sha\\* are optimized, up to a factor of 11 for\n  the slowest ( = biggest and safest) group size.\n\n  Own Id: OTP-14169 Aux Id: seq-13261\n\n- The ssh host key fingerprint generation now also takes a list of algorithms\n  and returns a list of corresponding fingerprints. See\n  `public_key:ssh_hostkey_fingerprint/2` and the option `silently_accept_hosts`\n  in `ssh:connect`.\n\n  Own Id: OTP-14223","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Ssh 4.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- A file read with an sftp client could loose data if the packet_size is set to\n  larger than 64k. This is corrected now in such a way that the packet_size is\n  silently lowered if there is a risk for data loss.\n\n  Own Id: OTP-13857 Aux Id: ERL-238, OTP-13858\n\n- When user defined SSH shell REPL process exits with reason normal, the SSH\n  channel callback module should report successful exit status to the SSH\n  client. This provides simple way for SSH clients to check for successful\n  completion of executed commands. (Thanks to isvilen)\n\n  Own Id: OTP-13905 Aux Id: PR-1173","ref":"notes.html#fixed-bugs-and-malfunctions-132"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Extended the option `silently_accept_hosts` for `ssh:connect` to make it\n  possible for the client to check the SSH host key fingerprint string. Se the\n  reference manual for SSH.\n\n  Own Id: OTP-13887 Aux Id: OTP-13888","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"Ssh 4.3.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Re-negotiation problems with OpenSSH client solved.\n\n  Own Id: OTP-13972","ref":"notes.html#fixed-bugs-and-malfunctions-133"},{"type":"extras","title":"Ssh 4.3.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- If a client illegaly sends an info-line and then immediately closes the\n  TCP-connection, a badmatch exception was raised.\n\n  Own Id: OTP-13966","ref":"notes.html#fixed-bugs-and-malfunctions-134"},{"type":"extras","title":"Ssh 4.3.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Intermittent ssh ERROR REPORT mentioning nonblocking_sender\n\n  Own Id: OTP-13953 Aux Id: seq13199","ref":"notes.html#fixed-bugs-and-malfunctions-135"},{"type":"extras","title":"Ssh 4.3.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Handle all possible exit values that should be interpreted as \\{error,\n  closed\\}. Failing to do so could lead to unexpected crashes for users of the\n  ssh application.\n\n  Own Id: OTP-13932 Aux Id: seq13189","ref":"notes.html#fixed-bugs-and-malfunctions-136"},{"type":"extras","title":"Ssh 4.3.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Upgrade of an established client connection could crash because the ssh client\n  supervisors children had wrong type. This is fixed now.\n\n  Own Id: OTP-13782 Aux Id: seq13158\n\n- Partly checks the public key early in public key authorization\n\n  Own Id: OTP-13847 Aux Id: defensics-ssh3.1.0-190243,205277,219318\n\n- Corrected handling of SHA for ECDSA (Elliptic curve public keys)\n\n  Own Id: OTP-13850 Aux Id: defensics-ssh3.1.0-214168\n\n- Problems found by test suites as well as by Codenomicon/Defensics fixed: -\n  reduce max random padding to 15 bytes (Codenomicon/Defensics) - inclomplete\n  pdu handling (Codenomicon/Defensics) - badmatch in test suite - non-blocking\n  send fixes deadlock in ssh_connection_SUITE:interrupted_send\n\n  Own Id: OTP-13854\n\n- Caller is now notified when a tcp close is received.\n\n  Own Id: OTP-13859 Aux Id: seq13177","ref":"notes.html#fixed-bugs-and-malfunctions-137"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Use application:ensure_all_started/2 instead of hard-coding deps\n\n  Own Id: OTP-13843 Aux Id: PR-1147","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"Ssh 4.3.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH client does not any longer retry a bad password given as option to\n  ssh:connect et al.\n\n  Own Id: OTP-13674 Aux Id: TR-HU92273\n\n- Removed possible hanging risk for a certain timing sequence when communicating\n  client and server executes on the same node.\n\n  Own Id: OTP-13715","ref":"notes.html#fixed-bugs-and-malfunctions-138"},{"type":"extras","title":"Ssh 4.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-3"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- A socket created and connected by gen_tcp could now be used as input to\n  ssh:connect, ssh:shell, ssh_sftp:start_channel and ssh:daemon.\n\n  Own Id: OTP-12860\n\n- Some time optimization mainly in message encoding.\n\n  Own Id: OTP-13131\n\n- Optimized the sftp client time by setting new packet and window sizes.\n\n  Own Id: OTP-13175\n\n- The `ssh_connection_handler` module in SSH is changed and now uses the new\n  behaviour `gen_statem`.\n\n  The module can be used as an example of a `gen_statem` callback module but\n  with a warning: This commit of ssh is just a straightforward port from gen_fsm\n  to gen_statem with some code cleaning. Since the state machine and the state\n  callbacks are almost unchanged the ssh module does not demonstrate the full\n  potential of the new behaviour.\n\n  The \"new\" state machine uses compound states. The ssh server and client state\n  machines are quite similar but differences exist. With `gen_fsm` there were\n  flags in the user data which in fact implemented \"substates\". Now with\n  `gen_statem` those are made explicit in the state names, eg. the state\n  `userauth` and the binary `role`\\-flag becomes the two state names\n  `{userauth, server}` and `{userauth, client}`.\n\n  Own Id: OTP-13267\n\n- The `{error, Reason}` tuples returned from `ssh_sftp` api functions are\n  described.\n\n  Own Id: OTP-13347 Aux Id: ERL-86\n\n- Added -spec in ssh\n\n  Own Id: OTP-13479\n\n- It is now possible to call `ssh:daemon/{1,2,3}` with `Port=0`. This makes the\n  daemon select a free listening tcp port before opening it. To find this port\n  number after the call, use the new function `ssh:daemon_info/1`. See the\n  reference manual for details.\n\n  Own Id: OTP-13527","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Ssh 4.2.2.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fix rare spurious shutdowns of ssh servers when receiving `{'EXIT',_,normal}`\n  messages.\n\n  Own Id: OTP-15018","ref":"notes.html#fixed-bugs-and-malfunctions-139"},{"type":"extras","title":"Ssh 4.2.2.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2-5"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Default exec is disabled when a user-defined shell is enabled.\n\n  Own Id: OTP-14881","ref":"notes.html#improvements-and-new-features-37"},{"type":"extras","title":"Ssh 4.2.2.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Trailing white space was removed at end of the hello-string. This caused\n  interoperability problems with some other ssh-implementations (e.g OpenSSH\n  7.3p1 on Solaris 11)\n\n  Own Id: OTP-14763 Aux Id: ERIERL-74","ref":"notes.html#fixed-bugs-and-malfunctions-140"},{"type":"extras","title":"Ssh 4.2.2.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The key exchange algorithm diffie-hellman-group-exchange-sha\\* has a\n  server-option `{dh_gex_limits,{Min,Max}}`. There was a hostkey signature\n  validation error on the client side if the option was used and the `Min` or\n  the `Max` differed from the corresponding values obtained from the client.\n\n  This bug is now corrected.\n\n  Own Id: OTP-14166","ref":"notes.html#fixed-bugs-and-malfunctions-141"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Key exchange algorithms diffie-hellman-group-exchange-sha\\* optimized, up to a\n  factor of 11 for the slowest ( = biggest and safest) one.\n\n  Own Id: OTP-14169 Aux Id: seq-13261","ref":"notes.html#improvements-and-new-features-38"},{"type":"extras","title":"Ssh 4.2.2.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Upgrade of an established client connection could crash because the ssh client\n  supervisors children had wrong type. This is fixed now.\n\n  Own Id: OTP-13782 Aux Id: seq13158","ref":"notes.html#fixed-bugs-and-malfunctions-142"},{"type":"extras","title":"Ssh 4.2.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH client does not any longer retry a bad password given as option to\n  ssh:connect et al.\n\n  Own Id: OTP-13674 Aux Id: TR-HU92273","ref":"notes.html#fixed-bugs-and-malfunctions-143"},{"type":"extras","title":"Ssh 4.2.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Documentation correction of `ssh_sftp:position/4`\n\n  Thanks to Rabbe Fogelholm.\n\n  Own Id: OTP-13305 Aux Id: ERL-87","ref":"notes.html#fixed-bugs-and-malfunctions-144"},{"type":"extras","title":"Ssh 4.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The authentication method 'keyboard-interactive' failed in the Erlang client\n  when the server after successful authentication continued by asking for zero\n  more passwords.\n\n  Own Id: OTP-13225","ref":"notes.html#fixed-bugs-and-malfunctions-145"},{"type":"extras","title":"Ssh 4.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Better error handling in ssh_file. There was some rare errors when a\n  NFS-mounted file was opened by ssh_file and then remotely deleted during\n  reading. That caused an endless loop.\n\n  That bug is now fixed.\n\n  Own Id: OTP-12699 Aux Id: OTP-11688\n\n- Fixed a bug in the compression algorithm zlib@openssh.com.\n\n  Own Id: OTP-12759\n\n- It is now possible to start more than one daemon with a file descriptor given\n  in option fd. Each daemon must of course have a unique file descriptor.\n\n  Own Id: OTP-12966 Aux Id: seq12945\n\n- Fixed a bug that caused the option `dh_gex_limit` to be ignored.\n\n  Own Id: OTP-13029\n\n- A problem is fixed with the `ssh:connect` option `pref_public_key_algs`\n  specifying user keys.\n\n  Own Id: OTP-13158","ref":"notes.html#fixed-bugs-and-malfunctions-146"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Document updates in the ssh reference manual: app doc file and ssh_connection.\n\n  Own Id: OTP-12003\n\n- The authorization phase is made stateful to prevent ssh acting on messages\n  sent in wrong order.\n\n  Own Id: OTP-12787\n\n- Testcases for bad message lengths and for bad subfield lengths added.\n\n  Own Id: OTP-12792 Aux Id: Codenomicon #5214, 6166\n\n- The 'ecdsa-sha2-nistp256', 'ecdsa-sha2-nistp384' and 'ecdsa-sha2-nistp521'\n  signature algorithms for ssh are implemented. See RFC 5656.\n\n  Own Id: OTP-12936\n\n- The crypto algorithms 'aes192-ctr' and 'aes256-ctr' are implemented. See\n  RFC 4344.\n\n  Own Id: OTP-12939\n\n- The ciphers and macs AEAD_AES_128_GCM and AEAD_AES_256_GCM are implemented but\n  not enabled per default. See the SSH App Reference Manual and RFC5647 for\n  details.\n\n  The ciphers aes128-gcm@openssh.com and aes256-gcm@openssh.com are also\n  implemented and available in the default configuration.\n\n  Own Id: OTP-13018\n\n- The ssh:daemon option dh_gex_groups is extended to read a user provided ssh\n  moduli file with generator-modulus pairs. The file is in openssh format.\n\n  Own Id: OTP-13052 Aux Id: OTP-13054\n\n- There is now a file (public_key/priv/moduli) which lists\n  size-generator-modulus triples. The purpose is to give servers the possibility\n  to select the crypto primes randomly among a list of pregenerated triples.\n  This reduces the risk for some attacks on diffie-hellman negotiation.\n\n  See the reference manual for public_key:dh_gex_group/4 where the handling of\n  this is described.\n\n  The ssh server (ssh:daemon) uses this.\n\n  Own Id: OTP-13054 Aux Id: OTP-13052\n\n- The ssh:daemon option pwdfun now also takes a fun/4. This enables the user\n  to 1) check userid-password in another way than the builtin algorithm, 2)\n  implement rate limiting per user or source IP or IP+Port, and 3) implement\n  blocking of missbehaving peers.\n\n  The old fun/2 still works as previously.\n\n  Own Id: OTP-13055 Aux Id: OTP-13053\n\n- There is now a new option to make the server limit the size range of moduli\n  available for the diffie-hellman group exchange negotiation. See option\n  `{dh_gex_limits,{Min,Max}}` in ssh:daemon/3.\n\n  Own Id: OTP-13066\n\n- Ecdh key exchange now validates compressed and uncompressed keys as defined in\n  rfc5656\n\n  Own Id: OTP-13067\n\n- Search order for the .ssh directory are changed so `$HOME` is tried before\n  `init:get_argument(home)`.\n\n  Own Id: OTP-13109\n\n- The sftp receive window handling is optimized so it will not update the remote\n  end too often. This makes \"sftp mget\" considerable faster.\n\n  Own Id: OTP-13130\n\n- The option `key_cb` is extended to take an optional list that is passed to the\n  callback module as an option. With this it is possible to have different keys\n  depending on which host that is connected. Another possibility is to write a\n  callback module that fetches keys etc from a database.\n\n  Thanks to Vipin Nair.\n\n  Own Id: OTP-13156","ref":"notes.html#improvements-and-new-features-39"},{"type":"extras","title":"Ssh 4.1.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-1-3"},{"type":"extras","title":"Known Bugs and Problems - SSH Release Notes","doc":"- SSH_MSG_KEX_DH_GEX_REQUEST_OLD implemented to make PuTTY work with erl server.\n\n  Own Id: OTP-13140","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Ssh 4.1.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Add a 1024 group to the list of key group-exchange groups\n\n  Own Id: OTP-13046","ref":"notes.html#fixed-bugs-and-malfunctions-147"},{"type":"extras","title":"Ssh 4.1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-1-1"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- A new option `max_channels` limits the number of channels with active\n  server-side subsystems that are accepted.\n\n  Own Id: OTP-13036","ref":"notes.html#improvements-and-new-features-40"},{"type":"extras","title":"Ssh 4.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Send an understandable disconnect message when the key exchange phase can't\n  find a common algorithm. There are also some test cases added.\n\n  Own Id: OTP-11531\n\n- The third parameter in `ssh_sftp:write_file` is now accepting iolists again.\n  Unicode handling adjusted.\n\n  Own Id: OTP-12853 Aux Id: seq12891","ref":"notes.html#fixed-bugs-and-malfunctions-148"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- First part of ssh test suite re-organization and extension.\n\n  Own Id: OTP-12230\n\n- The key exchange algorithms 'ecdh-sha2-nistp256', 'ecdh-sha2-nistp384' and\n  'ecdh-sha2-nistp521' are implemented. See RFC 5656.\n\n  This raises the security level considerably.\n\n  Own Id: OTP-12622 Aux Id: OTP-12671, OTP-12672\n\n- The key exchange algorithm 'diffie-hellman-group14-sha1' is implemented. See\n  RFC 4253.\n\n  This raises the security level.\n\n  Own Id: OTP-12671 Aux Id: OTP-12672, OTP-12622\n\n- The key exchange algorithms 'diffie-hellman-group-exchange-sha1' and\n  'diffie-hellman-group-exchange-sha256' are implemented. See RFC 4419.\n\n  This raises the security level.\n\n  Own Id: OTP-12672 Aux Id: OTP-12671, OTP-12622\n\n- Adding random length extra padding as recommended in RFC 4253 section 6.\n\n  Own Id: OTP-12831\n\n- New test library for low-level protocol testing. There is also a test suite\n  using it for some preliminary tests. The intention is to build on that for\n  more testing of individual ssh messages. See\n  `lib/ssh/test/ssh_trpt_test_lib.erl` and `ssh_protocol_SUITE.erl` in the same\n  directory.\n\n  Own Id: OTP-12858\n\n- Increased default values for diffie-hellman-group-exchange-sha\\* to Min =\n  1024, N = 6144, Max = 8192.\n\n  Added 6144 and 8192 bit default gex groups.\n\n  Own Id: OTP-12937\n\n- The mac algorithm 'hmac-sha2-512' is implemented. See RFC 6668.\n\n  Own Id: OTP-12938","ref":"notes.html#improvements-and-new-features-41"},{"type":"extras","title":"Ssh 4.0 - SSH Release Notes","doc":"","ref":"notes.html#ssh-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Ssh crashed if a message was sent on a channel with packet_size = 0.\n\n  A new option for ssh:daemon is also introduced:\n  `minimal_remote_max_packet_size`. This option sets the least max packet size\n  declaration that the daemon will accept from a client. The default value is 0\n  to maintain compatibility with OpenSSH and the rfc:s.\n\n  Own Id: OTP-12645 Aux Id: seq12816\n\n- Included test of the 'e' and 'f' parameters in diffie-hellman key exchange as\n  specified in rfc 4253 section 8.\n\n  Own Id: OTP-12649\n\n- Fixes the bug that once the `rekey_limit` bytes (by default, 1GB) had been\n  transmitted the connection was rekeyed every minute, not after the next\n  transferred 'rekey_limit' chunk.\n\n  Thanks to Simon Cornish for the report and the fix\\!\n\n  Own Id: OTP-12692\n\n- Fixes a bug that causes an SFTP connection to always fail when \\{timeout,\n  Timeout\\} option is used with ssh_sftp:start_channel.\n\n  Thanks to Simon Cornish\n\n  Own Id: OTP-12708\n\n- Fix various ssh key exchange problems.\n\n  Thanks to Simon Cornish\n\n  Own Id: OTP-12760 Aux Id:\n  [pull req 715](https://github.com/erlang/otp/pull/715)\n\n- The options `system_dir` and `user_dir` assumes that the value is a path to a\n  directory which is readable. This is now checked early, so `ssh:daemon` and\n  `ssh:connect` will fail with an error message immediately.\n\n  Own Id: OTP-12788\n\n- A daemon now checks that a client doesn't try to authorize with methods not in\n  the option auth_methods.\n\n  Own Id: OTP-12790\n\n- Disconnectfun now should trigger on all disconnects.\n\n  Own Id: OTP-12811","ref":"notes.html#fixed-bugs-and-malfunctions-149"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Better usage of binary matching in ssh_auth.erl and ssh_message.erl\n\n  Own Id: OTP-11697\n\n- A new option 'preferred_algorithms' is available for `ssh:daemon` and\n  `ssh:connect`.\n\n  This option defines the algorithms presented to the peer in the algorithm\n  negotiation phase of the ssh protocol.\n\n  The default list can be obtained from the new function\n  `ssh:default_algorithms/0`.\n\n  \\*** INCOMPATIBILITY with removed undocumented options 'role' and\n  'compression' \\***\n\n  Own Id: OTP-12029\n\n- The internal group to user_drv protocol has been changed to be synchronous in\n  order to guarantee that output sent to a process implementing the user_drv\n  protocol is printed before replying. This protocol is used by the\n  standard_output device and the ssh application when acting as a client.\n\n  This change changes the previous unlimited buffer when printing to standard_io\n  and other devices that end up in user_drv to 1KB.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-12240\n\n- If ssh_connection:subsystem/4 fails we do not want to crash but rather\n  terminate gracefully.\n\n  Own Id: OTP-12648 Aux Id: seq12834\n\n- New option `id_string` for `ssh:daemon` and `ssh:connect` for limiting banner\n  grabbing attempts.\n\n  The possible values are: `{id_string,string()}` and `{id_string,random}`. The\n  latter will make ssh generate a random nonsense id-string for each new\n  connection.\n\n  Own Id: OTP-12659\n\n- To enable the ssh daemon to run in a virtualized environment, where there can\n  be more that one server that has the same ip-address and port, we add a new\n  option profile.\n\n  Own Id: OTP-12675\n\n- Upgrade test suite added.\n\n  Own Id: OTP-12676\n\n- A new option for handling the SSH_MSG_DEBUG message's printouts. A fun could\n  be given in the options that will be called whenever the SSH_MSG_DEBUG message\n  arrives. This enables the user to format the printout or just discard it.\n\n  Own Id: OTP-12738 Aux Id: seq12860\n\n- Testcase improvements and corrections:\n\n  \\* Add testcases for the `disconnectfun` option on both server and client\n  sides\n\n  \\* Timeout testcases adjusted for slow machines where they sometimes failed\n\n  Own Id: OTP-12786\n\n- The option `disconnectfun` can now be used both on the client and server side.\n\n  Own Id: OTP-12789\n\n- A new option unknown_msgfun/2 for ssh:connect and ssh:daemon for handling\n  unknown messages. With the option it is possible to intercept before an INFO\n  log message is generated.\n\n  One usage is to filter out messages that are not wanted in the error logger as\n  info reports. An example of such a message is the 'etimedout' tcp error\n  message that will be received if a connection has keep_alive and the peer is\n  restarted.\n\n  Own Id: OTP-12813 Aux Id: seq12881","ref":"notes.html#improvements-and-new-features-42"},{"type":"extras","title":"Ssh 3.2.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Gracefully terminate if sockets is unexpectedly closed.\n\n  Own Id: OTP-12782\n\n- Made Codenomicon Defensics test suite pass:\n\n  - limit number of algorithms in kexinit message\n  - check 'e' and 'f' parameters in kexdh\n  - implement 'keyboard-interactive' user authentication on server side\n  - return plain text message to bad version exchange message\n\n  Own Id: OTP-12784","ref":"notes.html#fixed-bugs-and-malfunctions-150"},{"type":"extras","title":"Ssh 3.2.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- A new option for handling the SSH_MSG_DEBUG message's printouts. A fun could\n  be given in the options that will be called whenever the SSH_MSG_DEBUG message\n  arrives. This enables the user to format the printout or just discard it.\n\n  Own Id: OTP-12738 Aux Id: seq12860","ref":"notes.html#fixed-bugs-and-malfunctions-151"},{"type":"extras","title":"Ssh 3.2.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-2-2"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- New option `id_string` for `ssh:daemon` and `ssh:connect` for limiting banner\n  grabbing attempts.\n\n  The possible values are: `{id_string,string()}` and `{id_string,random}`. The\n  latter will make ssh generate a random nonsense id-string for each new\n  connection.\n\n  Own Id: OTP-12659","ref":"notes.html#improvements-and-new-features-43"},{"type":"extras","title":"Ssh 3.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Ssh crashed if a message was sent on a channel with packet_size = 0.\n\n  A new option for ssh:daemon is also introduced:\n  `minimal_remote_max_packet_size`. This option sets the least max packet size\n  declaration that the daemon will accept from a client. The default value is 0\n  to maintain compatibility with OpenSSH and the rfc:s.\n\n  Own Id: OTP-12645 Aux Id: seq12816","ref":"notes.html#fixed-bugs-and-malfunctions-152"},{"type":"extras","title":"Ssh 3.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- If a channel is closed by the peer while using a function with call semantics\n  in ssh_connection.erl return \\{error, closed\\}. Document that the functions\n  can return \\{error, timeout | closed\\} and not only ssh_request_status()\n\n  Own Id: OTP-12004\n\n- Bug that causes ssh:connect to return `{error,int()}` instead of\n  `{error,timeout}` when ssh handshake takes too long time.\n\n  Own Id: OTP-12369\n\n- Documentation corrections. (Thanks to Rabbe Fogelholm)\n\n  Own Id: OTP-12399","ref":"notes.html#fixed-bugs-and-malfunctions-153"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Example of ssh_connection:exec added.\n\n  Own Id: OTP-12558","ref":"notes.html#improvements-and-new-features-44"},{"type":"extras","title":"Ssh 3.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Make sure the clean rule for ssh, ssl, eunit and otp_mibs actually removes\n  generated files.\n\n  Own Id: OTP-12200\n\n- Improved Property Tests (Thanks to Thomas, John and Tobias at QuviQ)\n\n  Own Id: OTP-12256\n\n- Correct typo of renegotiate that could cause rekeying to fail\n\n  Own Id: OTP-12277 Aux Id: seq12736\n\n- The \\{timeout, Timeout\\} option passed to ssh_sftp:start_channel was not\n  applied to the early phases of the SSH protocol. This patch passes the Timeout\n  through to ssh:connect. In case the timeout occurs during these phases,\n  \\{error, timeout\\} is returned. (Thanks to Simon Cornish)\n\n  Own Id: OTP-12306","ref":"notes.html#fixed-bugs-and-malfunctions-154"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Added API functions ptty_alloc/3 and ptty_alloc/4, to allocate a pseudo tty.\n\n  Own Id: OTP-11542 Aux Id: seq12493, OTP-11631\n\n- Supports tar file creation on other media than file systems mounted on the\n  local machine.\n\n  The `erl_tar` api is extended with `erl_tar:init/3` that enables usage of user\n  provided media storage routines. A ssh-specific set of such routines is hidden\n  in the new function `ssh_sftp:open_tar/3` to simplify creating a tar archive\n  on a remote ssh server.\n\n  A chunked file reading option is added to `erl_tar:add/3,4` to save memory on\n  e.g small embedded systems. The size of the slices read from a file in that\n  case can be specified.\n\n  Own Id: OTP-12180 Aux Id: seq12715\n\n- Always send SSH_DISCONNECT protocol messages when peer sends corrupt messages.\n\n  Own Id: OTP-12185\n\n- Hooks for funs that can change binaries sent to remote sites from erl_tar for\n  renote tar file creation are added. See `ssh_sftp:open_tar/3,4` for details.\n  The hooks could also be used to read remote tar files that need transformation\n  before file extraction.\n\n  Those hooks are intended for encryption and decryption of tar files. Effort is\n  put into memory, disk and network resource economy.\n\n  Own Id: OTP-12312 Aux Id: OTP-12180","ref":"notes.html#improvements-and-new-features-45"},{"type":"extras","title":"Ssh 3.0.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixes of login blocking after port scanning.\n\n  Own Id: OTP-12247 Aux Id: seq12726","ref":"notes.html#fixed-bugs-and-malfunctions-155"},{"type":"extras","title":"Ssh 3.0.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Add option sftp_vsn to SFTP\n\n  Own Id: OTP-12227","ref":"notes.html#fixed-bugs-and-malfunctions-156"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Fix option user_interaction to work as expected. When password authentication\n  is implemented with ssh keyboard-interactive method and the password is\n  already supplied, so that we do not need to query user, then connections\n  should succeed even though user_interaction option is set to false.\n\n  Own Id: OTP-11329 Aux Id: seq12420, seq12335","ref":"notes.html#improvements-and-new-features-46"},{"type":"extras","title":"Ssh 3.0.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Gracefully handle bad data from the client when expecting ssh version\n  exchange.\n\n  Own Id: OTP-12157 Aux Id: seq12706\n\n- When restarting an ssh daemon, that was stopped with ssh:stop_listner/ \\[1,2]\n  new options given shall replace old ones.\n\n  Own Id: OTP-12168 Aux Id: seq12711","ref":"notes.html#fixed-bugs-and-malfunctions-157"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- ssh now has a format_status function to avoid printing sensitive information\n  in error loggs.\n\n  Own Id: OTP-12030","ref":"notes.html#improvements-and-new-features-47"},{"type":"extras","title":"Known Bugs and Problems - SSH Release Notes","doc":"- The option `parallel_login` didn't work with the value `true`. All logins were\n  serial.\n\n  Own Id: OTP-12194","ref":"notes.html#known-bugs-and-problems-1"},{"type":"extras","title":"Ssh 3.0.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- When starting an ssh-daemon giving the option \\{parallel_login, true\\}, the\n  timeout for authentication negotiation (\\{negotiation_timeout, integer()\\})\n  was never removed.\n\n  This caused the session to always be terminated after the timeout if\n  parallel_login was set.\n\n  Own Id: OTP-12057 Aux Id: seq12663","ref":"notes.html#fixed-bugs-and-malfunctions-158"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Warning: this is experimental and may disappear or change without previous\n  warning.\n\n  Experimental support for running Quickcheck and PropEr tests from common_test\n  suites is added to common_test. See the reference manual for the new module\n  `ct_property_testing`.\n\n  Experimental property tests are added under\n  `lib/{inet,ssh}/test/property_test`. They can be run directly or from the\n  commont_test suites `inet/ftp_property_test_SUITE.erl` and\n  `ssh/test/ssh_property_test_SUITE.erl`.\n\n  See the code in the `test` directories and the man page for details.\n\n  (Thanks to Tuncer Ayaz for a patch adding Triq)\n\n  Own Id: OTP-12119","ref":"notes.html#improvements-and-new-features-48"},{"type":"extras","title":"Ssh 3.0.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- When starting an ssh-daemon giving the option \\{parallel_login, true\\}, the\n  timeout for authentication negotiation (\\{negotiation_timeout, integer()\\})\n  was never removed.\n\n  This caused the session to always be terminated after the timeout if\n  parallel_login was set.\n\n  Own Id: OTP-12057 Aux Id: seq12663","ref":"notes.html#fixed-bugs-and-malfunctions-159"},{"type":"extras","title":"Ssh 3.0.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Removed mail address from error reports and corrected spelling error\n  (Stacktace -> stacktrace)\n\n  Own Id: OTP-11883 Aux Id: seq12586\n\n- Decode/encode fixes in SSH_MSG_IGNORE and SSH_MSG_UNIMPLEMENTED.\n\n  Own Id: OTP-11983","ref":"notes.html#fixed-bugs-and-malfunctions-160"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Accepts that some older OpenSSH clients sends incorrect disconnect messages.\n\n  Own Id: OTP-11972\n\n- Handle inet and inet6 option correctly\n\n  Own Id: OTP-11976","ref":"notes.html#improvements-and-new-features-49"},{"type":"extras","title":"Ssh 3.0.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed timeout bug in ssh:connect.\n\n  Own Id: OTP-11908","ref":"notes.html#fixed-bugs-and-malfunctions-161"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Option `max_sessions` added to `ssh:daemon/{2,3}`. This option, if set, limits\n  the number of simultaneous connections accepted by the daemon.\n\n  Own Id: OTP-11885","ref":"notes.html#improvements-and-new-features-50"},{"type":"extras","title":"Ssh 3.0.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixes the problem that ssh_cli in some cases could delay the prompt if a tty\n  was not requested by the client.\n\n  Own Id: OTP-10732\n\n- The variable NewCol is now correctly calculated allowing for tab-completion of\n  function calls even when preceded with blank space (Thanks to Alexander\n  Demidenko)\n\n  Own Id: OTP-11566\n\n- Fix incorrect dialyzer spec and types, also enhance documentation.\n\n  Thanks to Ayaz Tuncer.\n\n  Own Id: OTP-11627\n\n- Fixed a bug when ssh:exec executes a linux command on a linux ssh daemon. If\n  the result is sent back from standard error, the length information was not\n  stripped off correctly.\n\n  Own Id: OTP-11667\n\n- Fixed a bug with the ssh file 'known_hosts' which made the file grow with many\n  equal entries.\n\n  Own Id: OTP-11671\n\n- Some local implementations of removing the last element from a list are\n  replaced by `lists:droplast/1`. Note that this requires at least `stdlib-2.0`,\n  which is the stdlib version delivered in OTP 17.0. (Thanks to Hans Svensson)\n\n  Own Id: OTP-11678\n\n- Bug fix for `ssh:daemon/2,3` so that the failfun is called when it should.\n\n  Own Id: OTP-11680\n\n- Fixed bug which crashed ssh when SSH_MSG_KEX_DH_GEX_GROUP is received. This\n  could cause a vm-crash for eheap_alloc during garbage collect.\n\n  Own Id: OTP-11696 Aux Id: 12547, 12532\n\n- Fixes a bug that breaks keyboard-interactive authentication. Thanks to Simon\n  Cornish for reporting and suggesting a fix.\n\n  Own Id: OTP-11698\n\n- dialyzer specs are now correct for `ssh:start/0`, `ssh:start/1`, `ssh:stop/0`\n  and `ssh_connection_handler:open_channel/5`. (Thanks to Johannes Weißl )\n\n  Own Id: OTP-11705\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- Fixed dialyzer warning for `ssh_connection:send`.\n\n  Own Id: OTP-11821\n\n- `ssh:daemon/2,3` : Added options `negotiation_timeout` and `parallel_login` to\n  tune the authentication behaviour.\n\n  Own Id: OTP-11823","ref":"notes.html#fixed-bugs-and-malfunctions-162"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Ssh now fully supports unicode filenames, filecontents, shell and cli. Please\n  note that the underlying os and emulator must also give support for unicode.\n  You may want to start the emulator with \"`erl +fnu`\" on Linux.\n\n  Own Id: OTP-10953","ref":"notes.html#improvements-and-new-features-51"},{"type":"extras","title":"Ssh 3.0 - SSH Release Notes","doc":"","ref":"notes.html#ssh-3-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The ssh cli is now faster at close and before new prompt.\n\n  Own Id: OTP-11339 Aux Id: seq12423\n\n- Ssh process structure was redesigned to better map to what is truly parallel\n  this has solved a lot of strange timing issues that sometimes would occur, for\n  instance a process leak could happen when a lot of connections where taken up\n  and down in parallel in a short period of time. Also backwards compatible\n  clauses to \"original\" but never supported features has been removed.\n\n  Impact: Increases flow efficiency\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-11363\n\n- Fix various typos in erts, kernel and ssh. Thanks to Martin Hässler.\n\n  Own Id: OTP-11414\n\n- Correct private_key type documentation in ssh_server_key_api. Thanks to\n  Tristan Sloughter.\n\n  Own Id: OTP-11449\n\n- The functions in ssh_no_io.erl did not mimic the functions in ssh_io.erl\n  correctly, the arity was incorrect for some functions which caused ssh to fail\n  in the wrong way.\n\n  Own Id: OTP-11490","ref":"notes.html#fixed-bugs-and-malfunctions-163"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Add option to disallow CLI\n\n  Own Id: OTP-10976\n\n- Add sockname and user to ssh:connection_info/2\n\n  Own Id: OTP-11296","ref":"notes.html#improvements-and-new-features-52"},{"type":"extras","title":"Ssh 2.1.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-8"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Do not chmod ~/.ssh unnecessarily.\n\n  Own Id: OTP-11189\n\n- Make ssh_cli.erl handle CTRL+C. Thanks to Stefan Zegenhagen.\n\n  Own Id: OTP-11199\n\n- Clarified timeout options in documentation.\n\n  Own Id: OTP-11249\n\n- Add openssh_zlib compression type to ssh_transport. Thanks to Louis-Philippe\n  Gauthier.\n\n  Own Id: OTP-11256","ref":"notes.html#improvements-and-new-features-53"},{"type":"extras","title":"Ssh 2.1.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- ssh:daemon will get fed with an argument even if it is not a valid expression.\n\n  Own Id: OTP-10975","ref":"notes.html#fixed-bugs-and-malfunctions-164"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Properly ignore everything in lib/ssh/doc/html/. Thanks to Anthony Ramine.\n\n  Own Id: OTP-10983\n\n- Integrate elliptic curve contribution from Andreas Schultz\n\n  In order to be able to support elliptic curve cipher suites in SSL/TLS,\n  additions to handle elliptic curve infrastructure has been added to public_key\n  and crypto.\n\n  This also has resulted in a rewrite of the crypto API to gain consistency and\n  remove unnecessary overhead. All OTP applications using crypto has been\n  updated to use the new API.\n\n  Impact: Elliptic curve cryptography (ECC) offers equivalent security with\n  smaller key sizes than other public key algorithms. Smaller key sizes result\n  in savings for power, memory, bandwidth, and computational cost that make ECC\n  especially attractive for constrained environments.\n\n  Own Id: OTP-11009","ref":"notes.html#improvements-and-new-features-54"},{"type":"extras","title":"Ssh 2.1.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Fixed timing rekeying bug.\n\n  Own Id: OTP-10940","ref":"notes.html#fixed-bugs-and-malfunctions-165"},{"type":"extras","title":"Ssh 2.1.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Bug in rekeying for daemon fixed.\n\n  Own Id: OTP-10911","ref":"notes.html#fixed-bugs-and-malfunctions-166"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Enhanced error message and added test for ssh clients trying to start non\n  existing subsystems.\n\n  Own Id: OTP-10714","ref":"notes.html#improvements-and-new-features-55"},{"type":"extras","title":"Ssh 2.1.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-4"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Better quality on the error messages for when key exchange failed.\n\n  Own Id: OTP-10553 Aux Id: seq12152\n\n- Fix link to documentation for ssh:connect/3,4. Thanks to Martin Hässler.\n\n  Own Id: OTP-10862","ref":"notes.html#improvements-and-new-features-56"},{"type":"extras","title":"Ssh 2.1.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- It is now possible to send an empty binary using ssh_connection:send/3, this\n  corner case previously caused ssh_connection:send to hang.\n\n  Own Id: OTP-9478 Aux Id: kunagi-226 \\[137]\n\n- Fix typo in keyboard-interactive string. Thanks to Daniel Goertzen\n\n  Own Id: OTP-10456\n\n- ssh_connectino:send/3 will not return until all data has been sent. Previously\n  it could return too early, resulting in things such premature close of the\n  connection. Also improved error handling of closed SSH channels.\n\n  Own Id: OTP-10467\n\n- Fixed ssh_cli.erl crashes because #state.buf is yet 'undefined'.\n\n  Fixed Client terminateing connections due to channel_request message response\n  is sent to the wrong id.\n\n  Affected SSH clients: - all clients based on SSH-2.0-TrileadSSH2Java_213\n  (problem #1) - SSH Term Pro (problem #2)\n\n  Thanks to Stefan Zegenhagen\n\n  Own Id: OTP-10475\n\n- Fixed various syntax errors in SSH appup file\n\n  Own Id: OTP-10657","ref":"notes.html#fixed-bugs-and-malfunctions-167"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- SSH_FX_FILE_IS_A_DIRECTORY message for sftp implemented\n\n  Own Id: OTP-6406 Aux Id: kunagi-218 \\[129]\n\n- SSH Rekeying fixed\n\n  Own Id: OTP-7785 Aux Id: kunagi-220 \\[131]\n\n- Added User Guide for the SSH application\n\n  Own Id: OTP-7786 Aux Id: kunagi-221 \\[132]\n\n- Documentation regarding failfun, connectfun and disconnectfun provided\n\n  Own Id: OTP-7792 Aux Id: kunagi-222 \\[133]\n\n- SSH connection timer implementation\n\n  New option, \\{idle_time, integer()\\}, sets a timeout on connection when no\n  channels are active, defaults to infinity\n\n  Own Id: OTP-10514 Aux Id: seq12020\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665\n\n- Fixed internal error on when client and server cannot agree o which authmethod\n  to use.\n\n  Own Id: OTP-10731 Aux Id: seq12237","ref":"notes.html#improvements-and-new-features-57"},{"type":"extras","title":"Ssh 2.1.2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-2-1"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Removed error report in ssh_connection_handler triggered by badmatch failure.\n\n  Own Id: OTP-11188","ref":"notes.html#improvements-and-new-features-58"},{"type":"extras","title":"Ssh 2.1.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH quiet mode\n\n  A new option to ssh:connect/3,4, quiet_mode. If true, the client will not\n  print out anything on authorization.\n\n  Own Id: OTP-10429 Aux Id: kunagi-273 \\[184]\n\n- Restrict which key algorithms to use\n\n  A new option to ssh:connect/3,4 is introduced, public_key_algs, where you can\n  restrict which key algorithms to use and in which order to try them.\n\n  Own Id: OTP-10498 Aux Id: kunagi-289 \\[200]\n\n- Confidentiality of client password\n\n  Unsets clients password after authentication.\n\n  Own Id: OTP-10511 Aux Id: kunagi-292 \\[203]\n\n- Fixed user interaction for SSH\n\n  It's now available to accept hosts and input password\n\n  Own Id: OTP-10513 Aux Id: kunagi-293 \\[204]","ref":"notes.html#fixed-bugs-and-malfunctions-168"},{"type":"extras","title":"Ssh 2.1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Ssh now only sends one channel close message under all circumstances, before\n  it would sometimes incorrectly send two.\n\n  Own Id: OTP-10060\n\n- The options check mistreated the ip_v6_disable-option, and did not handle\n  some, at the moment, undocumented options correctly.\n\n  Own Id: OTP-10061\n\n- The channel id in a channel failure message, sent to the peer, is now in all\n  cases the remote channel id\n\n  Own Id: OTP-10062\n\n- Improved handling of multiple closes to avoid occasional crashes when a\n  channel is closed more than once.\n\n  Own Id: OTP-10112\n\n- Fix lib/src/test/ssh_basic_SUITE.erl to fix IPv6 option typos\n\n  Fixed incorrect option \"ipv6_disable\" to \"ipv6_disabled\" as documented in the\n  ssh manual.\n\n  Own Id: OTP-10219\n\n- SSH: Make \"auth_methods\" server option re-usable\n\n  The 'auth_methods' option is used by the server side of the SSH code to tell a\n  connecting SSH client about the authentication methods that are supported by\n  the server. The code still extracts and handles the 'auth_methods' option from\n  Opts in appropriate places, but the Opts checking code in ssh.erl didn't allow\n  that option to be specified.\n\n  Own Id: OTP-10224\n\n- Use the correct channel id when adjusting the channel window\n\n  Own Id: OTP-10232","ref":"notes.html#fixed-bugs-and-malfunctions-169"},{"type":"extras","title":"Ssh 2.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- All keys in authorized_keys are considered, wrongly only the first one was\n  before.\n\n  Own Id: OTP-7235\n\n- ssh daemon now properly handles ras host keys, in previous versions only dsa\n  host keys sufficed to set up a connection.\n\n  Own Id: OTP-7677\n\n- ssh:shell/3 and ssh:connect/3 does not hang anymore if connection negotiation\n  fails\n\n  Own Id: OTP-8111\n\n- Improve check so that we will not try to read ssh packet length indicator if\n  not sure we have enough data.\n\n  Own Id: OTP-8380\n\n- Do not try to use user interaction when it is disabled.\n\n  Own Id: OTP-9466 Aux Id: seq11886\n\n- Improved error handling of internal errors i the ssh connection handling\n  process\n\n  Own Id: OTP-9905\n\n- sftp daemon generates file handles correct\n\n  Own Id: OTP-9948","ref":"notes.html#fixed-bugs-and-malfunctions-170"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Document supported algorithms\n\n  Own Id: OTP-8109\n\n- Graceful handling of premature close from an sftp client.\n\n  Own Id: OTP-9391 Aux Id: seq11838\n\n- Changed ssh implementation to use the public_key application for all public\n  key handling. This is also a first step for enabling a callback API for\n  supplying public keys and handling keys protected with password phrases.\n\n  Additionally the test suites where improved so that they do not copy the users\n  keys to test server directories as this is a security liability. Also ipv6 and\n  file access issues found in the process has been fixed.\n\n  This change also solves OTP-7677 and OTP-7235\n\n  This changes also involves some updates to public_keys ssh-functions.\n\n  Own Id: OTP-9911\n\n- Added options for the ssh client to support user keys files that are password\n  protected.\n\n  Own Id: OTP-10036 Aux Id: OTP-6400, Seq10595","ref":"notes.html#improvements-and-new-features-59"},{"type":"extras","title":"Ssh 2.0.9 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-9"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Erlang/OTP can now be built using parallel make if you limit the number of\n  jobs, for instance using '`make -j6`' or '`make -j10`'. '`make -j`' does not\n  work at the moment because of some missing dependencies.\n\n  Own Id: OTP-9451\n\n- Ssh behaviours now use the new directive \"-callback\". Parameters will be\n  further specified in a later version of ssh.\n\n  Own Id: OTP-9796","ref":"notes.html#improvements-and-new-features-60"},{"type":"extras","title":"Ssh 2.0.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Calling ssh_sftp:stop_channel/1 resulted in that the trap_exit flag was set to\n  true for the invoking process.\n\n  Own Id: OTP-9386 Aux Id: seq11865","ref":"notes.html#fixed-bugs-and-malfunctions-171"},{"type":"extras","title":"Ssh 2.0.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- An unexpected message would crash the ssh_connection_handler and close the\n  connection. Now an error message is generated instead.\n\n  Own Id: OTP-9273","ref":"notes.html#fixed-bugs-and-malfunctions-172"},{"type":"extras","title":"Ssh 2.0.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- A memory leak has been fixed. I.e. per terminated connection the size of a pid\n  and the length of a user name string was not cleared.\n\n  Own Id: OTP-9232","ref":"notes.html#fixed-bugs-and-malfunctions-173"},{"type":"extras","title":"Ssh 2.0.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-5"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Strengthened random number generation. (Thanks to Geoff Cant)\n\n  Own Id: OTP-9225","ref":"notes.html#improvements-and-new-features-61"},{"type":"extras","title":"Ssh 2.0.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- In some cases SSH returned \\{error, normal\\} when a channel was terminated\n  unexpectedly. This has now been changed to \\{error, channel_closed\\}.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8987 Aux Id: seq11748\n\n- SSH did not handle the error reason enetunreach when trying to open a IPv6\n  connection.\n\n  Own Id: OTP-9031","ref":"notes.html#fixed-bugs-and-malfunctions-174"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- It is now possible to use SSH to sign and verify binary data.\n\n  Own Id: OTP-8986\n\n- SSH now ensures that the .ssh directory exists before trying to access files\n  located in that directory.\n\n  Own Id: OTP-9010","ref":"notes.html#improvements-and-new-features-62"},{"type":"extras","title":"Ssh 2.0.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The fix regarding OTP-8849 was not included in the previous version as stated.\n\n  Own Id: OTP-8918","ref":"notes.html#fixed-bugs-and-malfunctions-175"},{"type":"extras","title":"Ssh 2.0.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The ssh_system_sup did not catch noproc and shutdown messages.\n\n  Own Id: OTP-8863\n\n- In some cases a crash report was generated when a connection was closing down.\n  This was caused by a race condition between two processes.\n\n  Own Id: OTP-8881 Aux Id: seq11656, seq11648","ref":"notes.html#fixed-bugs-and-malfunctions-176"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- SSH no longer use deprecated public_key functions.\n\n  Own Id: OTP-8849","ref":"notes.html#improvements-and-new-features-63"},{"type":"extras","title":"Ssh 2.0.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH in some cases terminated channels with reason normal when it should have\n  been shutdown.\n\n  Own Id: OTP-8714\n\n- SSH in some cases generated a crash report when a channel was closed in a\n  normal way.\n\n  Own Id: OTP-8735 Aux Id: seq11615\n\n- The processes ssh_subsystem_sup and one ssh_channel_sup was not terminated\n  when a connection was closed.\n\n  Own Id: OTP-8807","ref":"notes.html#fixed-bugs-and-malfunctions-177"},{"type":"extras","title":"Ssh 2.0 - SSH Release Notes","doc":"","ref":"notes.html#ssh-2-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The function ssh:connect/4 was not exported.\n\n  Own Id: OTP-8550 Aux Id:\n\n- Aligned error message with used version (SSH_FX_FAILURE vs\n  SSH_FX_NOT_A_DIRECTORY, the latter introduced in version 6).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8644 Aux Id: seq11574\n\n- Resolved race condition when another connection is started before a channel is\n  opened in the first connection.\n\n  Own Id: OTP-8645 Aux Id: seq11577","ref":"notes.html#fixed-bugs-and-malfunctions-178"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The configuration parameter ip_v6_disabled is now available, which makes it\n  possible for the user to alter the IP version SSH shall use.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8535 Aux Id:\n\n- The ssh_connection:send operation now accepts infinity as timeout.\n\n  Own Id: OTP-8534 Aux Id:\n\n- The connection handler now include stack traces when a channel message is not\n  handled correctly.\n\n  Own Id: OTP-8524 Aux Id:\n\n- Removed deprecated modules (ssh_ssh, ssh_sshd and ssh_cm) and functions\n  (ssh_sftp:connect and ssh_sftp:stop).\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8596 Aux Id:","ref":"notes.html#improvements-and-new-features-64"},{"type":"extras","title":"Ssh 1.1.8 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- In some cases SSH ceased to collect more data from the transport layer.\n\n  Own Id: OTP-8401 Aux Id: seq11479","ref":"notes.html#fixed-bugs-and-malfunctions-179"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Old release notes removed.\n\n  Own Id: OTP-8356 Aux Id:","ref":"notes.html#improvements-and-new-features-65"},{"type":"extras","title":"Ssh 1.1.7 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Now clear all processes when a connection is terminated.\n\n  Own Id: OTP-8121 Aux Id:\n\n- In some rare cases the connection handler could enter an infinite loop.\n\n  Own Id: OTP-8277 Aux Id: seq11428\n\n- If an SFTP server did not respond with EOF, the function ssh_sftp:list_dir/2/3\n  would enter an infinite loop.\n\n  Own Id: OTP-8278 Aux Id: seq11450","ref":"notes.html#fixed-bugs-and-malfunctions-180"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201 Aux Id:","ref":"notes.html#improvements-and-new-features-66"},{"type":"extras","title":"Ssh 1.1.6 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- ssh_sftp:start_channel did not handle all possible return values from\n  ssh_channel:start correctly.\n\n  Own Id: OTP-8176 Aux Id:\n\n- SFTPD did not handle rename command (version 4) correctly.\n\n  Own Id: OTP-8175 Aux Id: seq11373\n\n- If a connection manager already had been terminated it could cause a channel\n  to generate a crash report when it was about to stop.\n\n  Own Id: OTP-8174 Aux Id: seq11377\n\n- Requests could result in badarg or badmatch EXIT messages in the connection\n  manager if the channel no longer existed.\n\n  Own Id: OTP-8173 Aux Id: seq11379\n\n- ssh_transport:unpack/3 could cause a badarg error.\n\n  Own Id: OTP-8162 Aux Id:","ref":"notes.html#fixed-bugs-and-malfunctions-181"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The encryption algorithm aes128-cbc is now supported. Requires that\n  crypto-1.6.1 is available.\n\n  Own Id: OTP-8110 Aux Id:","ref":"notes.html#improvements-and-new-features-67"},{"type":"extras","title":"Ssh 1.1.5 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- ssh_sftp:start_channel/3 did not handle timeout correctly.\n\n  Own Id: OTP-8159 Aux Id: seq11386\n\n- If a progress message was not received after invoking ssh:connect/3 the call\n  could hang for ever. A timeout option has also been added.\n\n  Own Id: OTP-8160 Aux Id: seq11386\n\n- A comma has been missing in the ssh.appup file since SSH-1.0.2.\n\n  Own Id: OTP-8161 Aux Id:","ref":"notes.html#fixed-bugs-and-malfunctions-182"},{"type":"extras","title":"Ssh 1.1.4 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- SSH sometimes caused a crash report at disconnect.\n\n  Own Id: OTP-8071 Aux Id: seq11319","ref":"notes.html#fixed-bugs-and-malfunctions-183"},{"type":"extras","title":"Ssh 1.1.3 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The operation ssh_sftp:stop_channel/1 returned an exception if the connection\n  already had been closed.\n\n  Own Id: OTP-7996 Aux Id: seq11281\n\n- SSH did not handle if supervisor:start_child/2 returned \\{error,\n  already_present\\}.\n\n  Own Id: OTP-8034 Aux Id: seq11307\n\n- SSH no longer cause supervisor reports when a connection is terminated in a\n  controlled manner.\n\n  Own Id: OTP-8035 Aux Id: seq11308","ref":"notes.html#fixed-bugs-and-malfunctions-184"},{"type":"extras","title":"Ssh 1.1.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Ssh confused local and remote channel id's, which in some cases resulted in\n  that messages were discarded.\n\n  Own Id: OTP-7914 Aux Id: seq11234\n\n- Ssh could not handle echo values other than 0 and 1.\n\n  Own Id: OTP-7917 Aux Id: seq11238\n\n- A crash occurred if a non-valid channel reference was received.\n\n  Own Id: OTP-7918 Aux Id: seq11238\n\n- Sftpd connections was not closed after receiving eof from a client.\n\n  Own Id: OTP-7921 Aux Id: seq11222\n\n- It was not possible to start a SFTP subsystem on certain platforms, i.e. those\n  who do not support symbolic links.\n\n  Own Id: OTP-7930 Aux Id:\n\n- In some cases the message \\{ssh_cm, ssh_connection_ref(), \\{closed,\n  ssh_channel_id()\\}\\} was not passed to the registered callback module.\n\n  Own Id: OTP-7957 Aux Id:","ref":"notes.html#fixed-bugs-and-malfunctions-185"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- By using the sftpd option \\{max_files, Integer\\}, the message size for READDIR\n  commands can be reduced.\n\n  Own Id: OTP-7919 Aux Id: seq11230","ref":"notes.html#improvements-and-new-features-68"},{"type":"extras","title":"Ssh 1.1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- The erlang ssh server has presented itself incorrectly, using the special\n  version ssh-1.99, although it never has supported versions below 2.0. Since\n  ssh-1.1 client versions below 2.0 are correctly rejected instead of letting\n  the server crash later on. Alas the problem with the presentation string was\n  not discovered until after ssh.1.1 was released. Now the server will present\n  itself as ssh-2.0.\n\n  Own Id: OTP-7795\n\n- An internal function call used an incorrect parameter, which caused problem\n  when the old listen API was used. This was introduced in Ssh-1.1.\n\n  Own Id: OTP-7920 Aux Id: seq11211","ref":"notes.html#fixed-bugs-and-malfunctions-186"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Ssh timeouts will now behave as expected i.e. defaults to infinity only the\n  user of the ssh application can know of a reasonable timeout value for their\n  application.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7807\n\n- The implementation of timeouts added as a patch in ssh-1.0.1 was slightly\n  changed and is now documented.\n\n  Own Id: OTP-7808\n\n- To honor the multiplexing of channels over one ssh connection concept\n  ssh_sftp:connect/ \\[1,2,3] is deprecated and replaced by\n  ssh_sftp:start_channel/\\[1,2,3] and ssh_sftp:stop/1 is deprecated and replaced\n  by ssh_sftp:stop_channel/1 and to stop the ssh connection ssh:close/ 1 should\n  be called.\n\n  Own Id: OTP-7809\n\n- Added the message \\{ssh_channel_up, ChannelId, ConnectionManager\\} that shall\n  be handled by the channel callback handle_msg/2. This makes the function\n  handle_msg/2 a mandatory function for ssh channels implementations which it\n  was not in ssh-1.1.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7828","ref":"notes.html#improvements-and-new-features-69"},{"type":"extras","title":"Ssh 1.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- A flaw in the implementation of the supervision tree caused the ssh daemon to\n  close the connections to all currently logged in users if one user logged out.\n  Another problem related to the supervision tree caused the closing down of\n  clients to leak processes i.e. all processes was not shutdown correctly.\n\n  Own Id: OTP-7676\n\n- Tabs could cause ssh_cli to print things in a surprising way.\n\n  Own Id: OTP-7683 Aux Id: seq11102\n\n- \\[sftp, sftpd] - Added patch to make sftp timestamps more correct, in the long\n  run it would be nice to have better support in file to be able to make it\n  always behave correctly now it will be correct 99 % of time instead of almost\n  never correct, at least on unix-based platforms.\n\n  Own Id: OTP-7685 Aux Id: seq11082\n\n- \\[sftpd] - Added patch to further improve handling of symbolic links in the\n  sftp-server.\n\n  Own Id: OTP-7766 Aux Id: seq11101\n\n- Ssh incorrectly sent the local id instead of the remote id of a channel to the\n  peer. For simpler cases these ids often happen to have the same value. One\n  case when they do not is when the client sends an exec command two times in a\n  raw on the same ssh connection (different channels of course as the channel\n  will be closed when the exec command has been evaluated) .\n\n  Own Id: OTP-7767\n\n- Packet data could be lost under high load due to the fact that buffered data\n  was sometimes wrongly discarded before it had been sent.\n\n  Own Id: OTP-7768\n\n- Improved ipv6-handling as some assumptions about inet functions where\n  incorrect.\n\n  Own Id: OTP-7770","ref":"notes.html#fixed-bugs-and-malfunctions-187"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- Added new API function ssh:connection_info/2.\n\n  Own Id: OTP-7456\n\n- Now starts ssh channel processes later avoiding synchronization problems\n  between processes.\n\n  Own Id: OTP-7516\n\n- Ssh now rejects old versions of the ssh protocol for security reasons. (Even\n  if they where not correctly rejected before the connection would probably have\n  failed anyway due to other reasons.)\n\n  Own Id: OTP-7645 Aux Id: seq11094\n\n- New API module ssh_channel has been added. This is a behaviour to facilitate\n  the implementation of ssh clients and plug in subsystems to the ssh daemon.\n  Note that this slightly changes the options to the API function\n  ssh:daemon/\\[1,2,3] deprecating all no longer documented options. Note that\n  the new API enforces the \"logical way\" of using the old API i.e. making the\n  subsystem process part of the ssh applications supervisor tree, so missuses of\n  the old API are not compatible with the new API.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7769","ref":"notes.html#improvements-and-new-features-70"},{"type":"extras","title":"Known Bugs and Problems - SSH Release Notes","doc":"- Public keys protected by a password are currently not handled by the erlang\n  ssh application.\n\n  Own Id: OTP-6400 Aux Id: 10595","ref":"notes.html#known-bugs-and-problems-2"},{"type":"extras","title":"Ssh 1.0.2 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- \\[sftpd] - Listing of symbolic link directories should now work as expected.\n\n  Own Id: OTP-7141 Aux Id: seq10856","ref":"notes.html#fixed-bugs-and-malfunctions-188"},{"type":"extras","title":"Ssh 1.0.1 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- \\[sftp] - When listing a directory with more than 100 files only the first 100\n  where listed. This has now been fixed.\n\n  Own Id: OTP-7318 Aux Id: seq10953\n\n- When restarting an ssh-system the expected return value from\n  ssh_system_sup:restart_acceptor/2 was incorrect, this is no longer the case.\n\n  Own Id: OTP-7564 Aux Id: seq11055\n\n- A few minor bugs where fixed in ssh_userreg.erl and ssh_connection_manager and\n  a a ssh_cli option was added to restore backwards compatibility with the old\n  ssh_cm - API.\n\n  Own Id: OTP-7565\n\n- Fixed bug in ipv6 support and added option to disable ipv6 as a workaround for\n  badly configured computers.\n\n  Own Id: OTP-7566","ref":"notes.html#fixed-bugs-and-malfunctions-189"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- \\[sftp] - Option added to set timeout value in sftp.\n\n  Own Id: OTP-7305 Aux Id: seq10945","ref":"notes.html#improvements-and-new-features-71"},{"type":"extras","title":"Ssh 1.0 - SSH Release Notes","doc":"","ref":"notes.html#ssh-1-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - SSH Release Notes","doc":"- Removed some special handling of prompts that made ssh behave differently than\n  openssh.\n\n  Own Id: OTP-7485 Aux Id: seq11025\n\n- Bug in encoding of pty opts has been fixed.\n\n  Own Id: OTP-7504","ref":"notes.html#fixed-bugs-and-malfunctions-190"},{"type":"extras","title":"Improvements and New Features - SSH Release Notes","doc":"- The architecture of the ssh processes has been reconstructed to fit in a\n  supervision tree as to become a real OTP application and benefit from this\n  when starting and stopping.\n\n  Own Id: OTP-7356 Aux Id: seq10899\n\n- Support for pty option echo off added. Requires kernel from R12B-4.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7502 Aux Id: seq10959\n\n- The ssh API has been enhanced a lot of old API functions has become\n  deprecated.\n\n  Own Id: OTP-7503","ref":"notes.html#improvements-and-new-features-72"},{"type":"extras","title":"SSH Protocol Introduction","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# SSH Protocol Introduction\n\nSSH is a protocol for secure remote logon and other secure network services over\nan insecure network.","ref":"introduction.html"},{"type":"extras","title":"Scope and Purpose - SSH Protocol Introduction","doc":"SSH provides a single, full-duplex, and byte-oriented connection between client\nand server. The protocol also provides privacy, integrity, server\nauthentication, and man-in-the-middle protection.\n\nThe `ssh` application is an implementation of the SSH Transport, Connection and\nAuthentication Layer Protocols in Erlang. It provides the following:\n\n- API functions to write customized SSH clients and servers applications\n- The Erlang shell available over SSH\n- An SFTP client (`m:ssh_sftp`) and server (`m:ssh_sftpd`)","ref":"introduction.html#scope-and-purpose"},{"type":"extras","title":"Prerequisites - SSH Protocol Introduction","doc":"It is assumed that the reader is familiar with the Erlang programming language,\nconcepts of **OTP**, and has a basic understanding of **public keys**.","ref":"introduction.html#prerequisites"},{"type":"extras","title":"Protocol Overview - SSH Protocol Introduction","doc":"Conceptually, the SSH protocol can be partitioned into four layers:\n\n```mermaid\n---\ntitle: SSH Protocol Architecture\n---\n\nblock-beta\n    columns 2\n\n    l1[\"SSH Client/Server Applications\"]:2\n    l2a[\"Connection Protocol\"] l2b[\"Authentication Protocol\"]\n    l3[\"Transport Protocol\"]:2\n    l4[\"TCP/IP Stack\"]:2\n```","ref":"introduction.html#protocol-overview"},{"type":"extras","title":"Transport Protocol - SSH Protocol Introduction","doc":"The SSH Transport Protocol is a secure, low-level transport. It provides strong\nencryption, cryptographic host authentication, and integrity protection. A\nminimum of Message Authentication Code (MAC) and encryption algorithms are\nsupported. For details, see the `m:ssh` manual page in `ssh`.","ref":"introduction.html#transport-protocol"},{"type":"extras","title":"Authentication Protocol - SSH Protocol Introduction","doc":"The SSH Authentication Protocol is a general-purpose user authentication\nprotocol run over the SSH Transport Layer Protocol. The `ssh` application\nsupports user authentication as follows:\n\n- Using public key technology. RSA and DSA, X509-certificates are not supported.\n- Using keyboard-interactive authentication. This is suitable for interactive\n  authentication methods that do not need any special software support on the\n  client side. Instead, all authentication data is entered from the keyboard.\n- Using a pure password-based authentication scheme. Here, the plain text\n  password is encrypted before sent over the network.\n\nSeveral configuration options for authentication handling are available in\n[ssh:connect/3,4](`ssh:connect/3`) and [ssh:daemon/2,3](`ssh:daemon/2`).\n\nThe public key handling can be customized by implementing the following\nbehaviours from `ssh`:\n\n- Module `m:ssh_client_key_api`.\n- Module `m:ssh_server_key_api`.","ref":"introduction.html#authentication-protocol"},{"type":"extras","title":"Connection Protocol - SSH Protocol Introduction","doc":"The SSH Connection Protocol provides application-support services over the\ntransport pipe, for example, channel multiplexing, flow control, remote program\nexecution, signal propagation, and connection forwarding. Functions for handling\nthe SSH Connection Protocol can be found in the module `m:ssh_connection` in\n`ssh`.","ref":"introduction.html#connection-protocol"},{"type":"extras","title":"Channels - SSH Protocol Introduction","doc":"All terminal sessions, forwarded connections, and so on, are channels. Multiple\nchannels are multiplexed into a single connection. All channels are\nflow-controlled. This means that no data is sent to a channel peer until a\nmessage is received to indicate that window space is available. The _initial\nwindow size_ specifies how many bytes of channel data that can be sent to the\nchannel peer without adjusting the window. Typically, an SSH client opens a\nchannel, sends data (commands), receives data (control information), and then\ncloses the channel. The `m:ssh_client_channel` behaviour handles generic parts\nof SSH channel management. This makes it easy to write your own SSH\nclient/server processes that use flow-control and thus opens for more focus on\nthe application logic.\n\nChannels come in the following three flavors:\n\n- _Subsystem_ \\- Named services that can be run as part of an SSH server, such\n  as SFTP [(ssh_sftpd)](`m:ssh_sftpd`), that is built into the SSH daemon\n  (server) by default, but it can be disabled. The Erlang `ssh` daemon can be\n  configured to run any Erlang- implemented SSH subsystem.\n- _Shell_ \\- Interactive shell. By default the Erlang daemon runs the Erlang\n  shell. The shell can be customized by providing your own read-eval-print loop.\n  You can also provide your own Command-Line Interface (CLI) implementation, but\n  that is much more work.\n- _Exec_ \\- One-time remote execution of commands. See function\n  `ssh_connection:exec/4` for more information.","ref":"introduction.html#channels"},{"type":"extras","title":"Where to Find More Information - SSH Protocol Introduction","doc":"For detailed information about the SSH protocol, refer to the following Request\nfor Comments(RFCs):\n\n- [RFC 4250](http://www.ietf.org/rfc/rfc4250.txt) \\- Protocol Assigned Numbers\n- [RFC 4251](http://www.ietf.org/rfc/rfc4251.txt) \\- Protocol Architecture\n- [RFC 4252](http://www.ietf.org/rfc/rfc4252.txt) \\- Authentication Protocol\n- [RFC 4253](http://www.ietf.org/rfc/rfc4253.txt) \\- Transport Layer Protocol\n- [RFC 4254](http://www.ietf.org/rfc/rfc4254.txt) \\- Connection Protocol\n- [RFC 4344](http://www.ietf.org/rfc/rfc4344.txt) \\- Transport Layer Encryption\n  Modes\n- [RFC 4716](http://www.ietf.org/rfc/rfc4716.txt) \\- Public Key File Format","ref":"introduction.html#where-to-find-more-information"},{"type":"extras","title":"Examples","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Examples\n\nThe following examples use the utility function `ssh:start/0` to start all\nneeded applications (`crypto`, `public_key`, and `ssh`). All examples are run in\nan Erlang shell, or in a bash shell, using **OpenSSH** to illustrate how the `ssh`\napplication can be used. The examples are run as the user `otptest` on a local\nnetwork where the user is authorized to log in over `ssh` to the host **ssh.example.com**.\n\nIf nothing else is stated, it is presumed that the `otptest` user has an entry\nin the **authorized\\_keys** file of **ssh.example.com** (allowed to log in over `ssh` without\nentering a password). Also, **ssh.example.com** is a known host in the `known_hosts` file\nof the user `otptest`. This means that host-verification can be done without\nuser-interaction.","ref":"using_ssh.html"},{"type":"extras","title":"Using the Erlang ssh Terminal Client - Examples","doc":"The user `otptest`, which has bash as default shell, uses the `ssh:shell/1`\nclient to connect to the **OpenSSH** daemon running on a host called **ssh.example.com**:\n\n```erlang\n1> ssh:start().\nok\n2> {ok, S} = ssh:shell(\"ssh.example.com\").\notptest@ssh.example.com:> pwd\n/home/otptest\notptest@ssh.example.com:> exit\nlogout\n3>\n```","ref":"using_ssh.html#using-the-erlang-ssh-terminal-client"},{"type":"extras","title":"Running an Erlang ssh Daemon - Examples","doc":"The [`system_dir`](`t:ssh_file:system_dir_daemon_option/0`) option must be a\ndirectory containing a host key file and it defaults to `/etc/ssh`. For details,\nsee Section Configuration in [ssh](ssh_app.md).\n\n> #### Note {: .info }\n>\n> Normally, the `/etc/ssh` directory is only readable by root.\n\nThe option [`user_dir`](`t:ssh_file:user_dir_common_option/0`) defaults to\ndirectory `~/.ssh`.\n\n_Step 1._ To run the example without root privileges, generate new keys and host\nkeys:\n\n```text\n$bash> ssh-keygen -t rsa -f /tmp/ssh_daemon/ssh_host_rsa_key\n[...]\n$bash> ssh-keygen -t rsa -f /tmp/otptest_user/.ssh/id_rsa\n[...]\n```\n\n_Step 2._ Create the file `/tmp/otptest_user/.ssh/authorized_keys` and add the\ncontent of `/tmp/otptest_user/.ssh/id_rsa.pub`.\n\n[](){: #start-daemon-step3 }\n\n_Step 3._ Start the Erlang `ssh` daemon:\n\n```erlang\n1> ssh:start().\nok\n2> {ok, Sshd} = ssh:daemon(8989, [{system_dir, \"/tmp/ssh_daemon\"},\n                                  {user_dir, \"/tmp/otptest_user/.ssh\"}]).\n{ok,<0.54.0>}\n3>\n```\n\n_Step 4._ Use the **OpenSSH** client from a shell to connect to the Erlang `ssh`\ndaemon:\n\n```text\n$bash> ssh ssh.example.com -p 8989  -i /tmp/otptest_user/.ssh/id_rsa \\\n                  -o UserKnownHostsFile=/tmp/otptest_user/.ssh/known_hosts\nThe authenticity of host 'ssh.example.com' can't be established.\nRSA key fingerprint is 14:81:80:50:b1:1f:57:dd:93:a8:2d:2f:dd:90:ae:a8.\nAre you sure you want to continue connecting (yes/no)? yes\nWarning: Permanently added 'ssh.example.com' (RSA) to the list of known hosts.\nEshell V5.10  (abort with ^G)\n1>\n```\n\nThere are two ways of shutting down an `ssh` daemon, see _Step 5a_ and _Step\n5b_.\n\n_Step 5a._ Shut down the Erlang `ssh` daemon so that it stops the listener but\nleaves existing connections, started by the listener, operational:\n\n```erlang\n3> ssh:stop_listener(Sshd).\nok\n4>\n```\n\n_Step 5b._ Shut down the Erlang `ssh` daemon so that it stops the listener and\nall connections started by the listener:\n\n```erlang\n3> ssh:stop_daemon(Sshd).\nok\n4>\n```","ref":"using_ssh.html#running-an-erlang-ssh-daemon"},{"type":"extras","title":"One-Time Execution - Examples","doc":"[](){: #simple-client-example }","ref":"using_ssh.html#one-time-execution"},{"type":"extras","title":"Erlang client contacting OS standard ssh server - Examples","doc":"In the following example, the Erlang shell is the client process that receives\nthe channel replies as Erlang messages.\n\nDo an one-time execution of a remote OS command (\"pwd\") over `ssh` to the ssh\nserver of the OS at the host \"ssh.example.com\":\n\n```erlang\n1> ssh:start().\nok\n2> {ok, ConnectionRef} = ssh:connect(\"ssh.example.com\", 22, []).\n{ok,<0.57.0>}\n3> {ok, ChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n{ok,0}\n4> success = ssh_connection:exec(ConnectionRef, ChannelId, \"pwd\", infinity).\n5> flush(). % Get all pending messages. NOTE: ordering may vary!\nShell got {ssh_cm,<0.57.0>,{data,0,0,<<\"/home/otptest\\n\">>}}\nShell got {ssh_cm,<0.57.0>,{eof,0}}\nShell got {ssh_cm,<0.57.0>,{exit_status,0,0}}\nShell got {ssh_cm,<0.57.0>,{closed,0}}\nok\n6> ssh:connection_info(ConnectionRef, channels).\n{channels,[]}\n7>\n```\n\nSee `m:ssh_connection` and `ssh_connection:exec/4` for finding documentation of\nthe channel messages.\n\nTo collect the channel messages in a program, use `receive...end` instead of\n`flush/1`:\n\n```erlang\n5> receive\n5>     {ssh_cm, ConnectionRef, {data, ChannelId, Type, Result}} when Type == 0 ->\n5>         {ok,Result}\n5>     {ssh_cm, ConnectionRef, {data, ChannelId, Type, Result}} when Type == 1 ->\n5>         {error,Result}\n5> end.\n{ok,<<\"/home/otptest\\n\">>}\n6>\n```\n\nNote that only the exec channel is closed after the one-time execution. The\nconnection is still up and can handle previously opened channels. It is also\npossible to open a new channel:\n\n```erlang\n% try to open a new channel to check if the ConnectionRef is still open\n7> {ok, NewChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n{ok,1}\n8>\n```\n\nTo close the connection, call the function\n[`ssh:close(ConnectionRef)`](`ssh:close/1`). As an alternative, set the option\n[`{idle_time, 1}`](`t:ssh:max_idle_time_common_option/0`) when opening the\nconnection. This will cause the connection to be closed automatically when there\nare no channels open for the specified time period, in this case 1 ms.","ref":"using_ssh.html#erlang-client-contacting-os-standard-ssh-server"},{"type":"extras","title":"OS standard client and Erlang daemon (server) - Examples","doc":"An Erlang SSH daemon could be called for one-time execution of a \"command\". The\n\"command\" must be as if entered into the erlang shell, that is a sequence of\nErlang [expressions](`e:system:expressions.md`) ended by a period (.). Variables\nbound in that sequence will keep their bindings throughout the expression\nsequence. The bindings are disposed when the result is returned.\n\nHere is an example of a suitable expression sequence:\n\n```erlang\nA=1, B=2, 3 == (A + B).\n```\n\nIt evaluates to `true` if submitted to the Erlang daemon started in\n[Step 3](using_ssh.md#start-daemon-step3) above:\n\n```text\n$bash> ssh ssh.example.com -p 8989 \"A=1, B=2, 3 == (A + B).\"\ntrue\n$bash>\n```\n\nThe same example but now using the Erlang ssh client to contact the Erlang\nserver:\n\n```erlang\n1> {ok, ConnectionRef} = ssh:connect(\"ssh.example.com\", 8989, []).\n{ok,<0.216.0>}\n2> {ok, ChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n{ok,0}\n3> success = ssh_connection:exec(ConnectionRef, ChannelId,\n                                 \"A=1, B=2, 3 == (A + B).\",\n                                 infinity).\nsuccess\n4> flush().\nShell got {ssh_cm,<0.216.0>,{data,0,0,<<\"true\">>}}\nShell got {ssh_cm,<0.216.0>,{exit_status,0,0}}\nShell got {ssh_cm,<0.216.0>,{eof,0}}\nShell got {ssh_cm,<0.216.0>,{closed,0}}\nok\n5>\n```\n\nNote that Erlang shell specific functions and control sequences like for example\n`h().` are not supported.","ref":"using_ssh.html#os-standard-client-and-erlang-daemon-server"},{"type":"extras","title":"I/O from a function called in an Erlang ssh daemon - Examples","doc":"Output to stdout on the server side is also displayed as well as the resulting\nterm from the function call:\n\n```text\n$bash> ssh ssh.example.com -p 8989 'io:format(\"Hello!~n~nHow are ~p?~n\",[you]).'\nHello!\n\nHow are you?\nok\n$bash>\n```\n\nAnd similar for reading from stdin. As an example we use `io:read/1` which\ndisplays the argument as a prompt on stdout, reads a term from stdin and returns\nit in an ok-tuple:\n\n```text\n$bash> ssh ssh.example.com -p 8989 'io:read(\"write something: \").'\nwrite something: [a,b,c].\n{ok,[a,b,c]}\n$bash>\n```\n\nThe same example but using the Erlang ssh client:\n\n```erlang\n\nEshell V10.5.2  (abort with ^G)\n1> ssh:start().\nok\n2> {ok, ConnectionRef} = ssh:connect(loopback, 8989, []).\n{ok,<0.92.0>}\n3> {ok, ChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n{ok,0}\n4> success = ssh_connection:exec(ConnectionRef, ChannelId,\n                                 \"io:read(\\\"write something: \\\").\",\n                                 infinity).\nsuccess\n5> flush().\nShell got {ssh_cm,<0.92.0>,{data,0,0,<<\"write something: \">>}}\nok\n% All data is sent as binaries with string contents:\n6> ok = ssh_connection:send(ConnectionRef, ChannelId, <<\"[a,b,c].\">>).\nok\n7> flush().\nok\n%% Nothing is received, because the io:read/1\n%% requires the input line to end with a newline.\n\n%% Send a newline (it could have been included in the last send):\n8> ssh_connection:send(ConnectionRef, ChannelId, <<\"\\n\">>).\nok\n9> flush().\nShell got {ssh_cm,<0.92.0>,{data,0,0,<<\"{ok,[a,b,c]}\">>}}\nShell got {ssh_cm,<0.92.0>,{exit_status,0,0}}\nShell got {ssh_cm,<0.92.0>,{eof,0}}\nShell got {ssh_cm,<0.92.0>,{closed,0}}\nok\n10>\n```","ref":"using_ssh.html#i-o-from-a-function-called-in-an-erlang-ssh-daemon"},{"type":"extras","title":"Configuring the server's (daemon's) command execution - Examples","doc":"Every time a daemon [is started](using_ssh.md#running-an-erlang-ssh-daemon), it\nenables one-time execution of commands as described in the\n[previous section](using_ssh.md#simple-client-example) unless explicitly\ndisabled.\n\nThere is often a need to configure some other exec evaluator to tailor the input\nlanguage or restrict the possible functions to call. There are two ways of doing\nthis which will be shown with examples below. See\n[ssh:daemon/2,3](`ssh:daemon/2`) and\n[exec_daemon_option()](`t:ssh:exec_daemon_option/0`) for details.\n\nExamples of the two ways to configure the exec evaluator:\n\n1. Disable one-time execution.  \n   To modify the daemon start example above to reject one-time execution\n   requests, we change [Step 3](using_ssh.md#start-daemon-step3) by adding the\n   option `{exec, disabled}` to:\n\n```erlang\n1> ssh:start().\nok\n2> {ok, Sshd} = ssh:daemon(8989, [{system_dir, \"/tmp/ssh_daemon\"},\n                                  {user_dir, \"/tmp/otptest_user/.ssh\"},\n                                  {exec, disabled}\n                                 ]).\n{ok,<0.54.0>}\n3>\n```\n\nA call to that daemon will return the text \"Prohibited.\" on stderr (depending on\nthe client and OS), and the exit status 255:\n\n```text\n$bash> ssh ssh.example.com -p 8989 \"test.\"\nProhibited.\n$bash> echo $?\n255\n$bash>\n```\n\nAnd the Erlang client library also returns the text \"Prohibited.\" on data type 1\ninstead of the normal 0 and exit status 255:\n\n```erlang\n2> {ok, ConnectionRef} = ssh:connect(loopback, 8989, []).\n{ok,<0.92.0>}\n3> {ok, ChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n{ok,0}\n4> success = ssh_connection:exec(ConnectionRef, ChannelId, \"test.\"\nsuccess\n5> flush().\nShell got {ssh_cm,<0.106.0>,{data,0,1,<<\"Prohibited.\">>}}\nShell got {ssh_cm,<0.106.0>,{exit_status,0,255}}\nShell got {ssh_cm,<0.106.0>,{eof,0}}\nShell got {ssh_cm,<0.106.0>,{closed,0}}\nok\n6>\n```\n\n1. Install an alternative evaluator.  \n   Start the damon with a reference to a `fun()` that handles the evaluation:\n\n```erlang\n1> ssh:start().\nok\n2> MyEvaluator = fun(\"1\") -> {ok, some_value};\n                    (\"2\") -> {ok, some_other_value};\n                    (\"3\") -> {ok, V} = io:read(\"input erlang term>> \"),\n                             {ok, V};\n                    (Err) -> {error,{bad_input,Err}}\n                 end.\n3> {ok, Sshd} = ssh:daemon(1234, [{system_dir, \"/tmp/ssh_daemon\"},\n                                  {user_dir, \"/tmp/otptest_user/.ssh\"},\n                                  {exec, {direct,MyEvaluator}}\n                                 ]).\n{ok,<0.275.0>}\n4>\n```\n\nand call it:\n\n```text\n$bash> ssh localhost -p 1234 1\nsome_value\n$bash> ssh localhost -p 1234 2\nsome_other_value\n# I/O works:\n$bash> ssh localhost -p 1234 3\ninput erlang term>> abc.\nabc\n# Check that Erlang evaluation is disabled:\n$bash> ssh localhost -p 1234 1+ 2.\n**Error** {bad_input,\"1+ 2.\"}\n$bash>\n```\n\nNote that spaces are preserved and that no point (.) is needed at the end - that\nwas required by the default evaluator.\n\nThe error return in the Erlang client (The text as data type 1 and exit_status\n255):\n\n```erlang\n2> {ok, ConnectionRef} = ssh:connect(loopback, 1234, []).\n{ok,<0.92.0>}\n3> {ok, ChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n{ok,0}\n4> success = ssh_connection:exec(ConnectionRef, ChannelId, \"1+ 2.\").\nsuccess\n5> flush().\nShell got {ssh_cm,<0.106.0>,{data,0,1,<<\"**Error** {bad_input,\\\"1+ 2.\\\"}\">>}}\nShell got {ssh_cm,<0.106.0>,{exit_status,0,255}}\nShell got {ssh_cm,<0.106.0>,{eof,0}}\nShell got {ssh_cm,<0.106.0>,{closed,0}}\nok\n6>\n```\n\nThe `fun()` in the exec option could take up to three arguments (`Cmd`, `User`\nand `ClientAddress`). See the\n[exec_daemon_option()](`t:ssh:exec_daemon_option/0`) for the details.\n\n> #### Note {: .info }\n>\n> An old, discouraged and undocumented way of installing an alternative\n> evaluator exists.\n>\n> It still works, but lacks for example I/O possibility. It is because of that\n> compatibility we need the `{direct,...}` construction.","ref":"using_ssh.html#configuring-the-server-s-daemon-s-command-execution"},{"type":"extras","title":"SFTP Server - Examples","doc":"Start the Erlang `ssh` daemon with the SFTP subsystem:\n\n```erlang\n1> ssh:start().\nok\n2> ssh:daemon(8989, [{system_dir, \"/tmp/ssh_daemon\"},\n                     {user_dir, \"/tmp/otptest_user/.ssh\"},\n                     {subsystems, [ssh_sftpd:subsystem_spec(\n                                            [{cwd, \"/tmp/sftp/example\"}])\n                                  ]}]).\n{ok,<0.54.0>}\n3>\n```\n\nRun the OpenSSH SFTP client:\n\n```text\n$bash> sftp -oPort=8989 -o IdentityFile=/tmp/otptest_user/.ssh/id_rsa \\\n            -o UserKnownHostsFile=/tmp/otptest_user/.ssh/known_hosts ssh.example.com\nConnecting to ssh.example.com...\nsftp> pwd\nRemote working directory: /tmp/sftp/example\nsftp>\n```","ref":"using_ssh.html#sftp-server"},{"type":"extras","title":"SFTP Client - Examples","doc":"Fetch a file with the Erlang SFTP client:\n\n```erlang\n1> ssh:start().\nok\n2> {ok, ChannelPid, Connection} = ssh_sftp:start_channel(\"ssh.example.com\", []).\n{ok,<0.57.0>,<0.51.0>}\n3> ssh_sftp:read_file(ChannelPid, \"/home/otptest/test.txt\").\n{ok,<<\"This is a test file\\n\">>}\n```","ref":"using_ssh.html#sftp-client"},{"type":"extras","title":"SFTP Client with TAR Compression - Examples","doc":"","ref":"using_ssh.html#sftp-client-with-tar-compression"},{"type":"extras","title":"Basic example - Examples","doc":"This is an example of writing and then reading a tar file:\n\n```erlang\n{ok,HandleWrite} = ssh_sftp:open_tar(ChannelPid, ?tar_file_name, [write]),\nok = erl_tar:add(HandleWrite, .... ),\nok = erl_tar:add(HandleWrite, .... ),\n...\nok = erl_tar:add(HandleWrite, .... ),\nok = erl_tar:close(HandleWrite),\n\n%% And for reading\n{ok,HandleRead} = ssh_sftp:open_tar(ChannelPid, ?tar_file_name, [read]),\n{ok,NameValueList} = erl_tar:extract(HandleRead,[memory]),\nok = erl_tar:close(HandleRead),\n```","ref":"using_ssh.html#basic-example"},{"type":"extras","title":"Example with encryption - Examples","doc":"The previous [Basic example](using_ssh.md#basic-example) can be extended with\nencryption and decryption as follows:\n\n```erlang\n%% First three parameters depending on which crypto type we select:\nKey = <<\"This is a 256 bit key. abcdefghi\">>,\nIvec0 = crypto:strong_rand_bytes(16),\nDataSize = 1024,  % DataSize rem 16 = 0 for aes_cbc\n\n%% Initialization of the CryptoState, in this case it is the Ivector.\nInitFun = fun() -> {ok, Ivec0, DataSize} end,\n\n%% How to encrypt:\nEncryptFun =\n    fun(PlainBin,Ivec) ->\n        EncryptedBin = crypto:block_encrypt(aes_cbc256, Key, Ivec, PlainBin),\n        {ok, EncryptedBin, crypto:next_iv(aes_cbc,EncryptedBin)}\n    end,\n\n%% What to do with the very last block:\nCloseFun =\n    fun(PlainBin, Ivec) ->\n        EncryptedBin = crypto:block_encrypt(aes_cbc256, Key, Ivec,\n                                            pad(16,PlainBin) %% Last chunk\n                                           ),\n       {ok, EncryptedBin}\n    end,\n\nCw = {InitFun,EncryptFun,CloseFun},\n{ok,HandleWrite} = ssh_sftp:open_tar(ChannelPid, ?tar_file_name, [write,{crypto,Cw}]),\nok = erl_tar:add(HandleWrite, .... ),\nok = erl_tar:add(HandleWrite, .... ),\n...\nok = erl_tar:add(HandleWrite, .... ),\nok = erl_tar:close(HandleWrite),\n\n%% And for decryption (in this crypto example we could use the same InitFun\n%% as for encryption):\nDecryptFun =\n    fun(EncryptedBin,Ivec) ->\n        PlainBin = crypto:block_decrypt(aes_cbc256, Key, Ivec, EncryptedBin),\n       {ok, PlainBin, crypto:next_iv(aes_cbc,EncryptedBin)}\n    end,\n\nCr = {InitFun,DecryptFun},\n{ok,HandleRead} = ssh_sftp:open_tar(ChannelPid, ?tar_file_name, [read,{crypto,Cr}]),\n{ok,NameValueList} = erl_tar:extract(HandleRead,[memory]),\nok = erl_tar:close(HandleRead),\n```\n\n[](){: #usersguide_creating_a_subsystem }","ref":"using_ssh.html#example-with-encryption"},{"type":"extras","title":"Creating a Subsystem - Examples","doc":"A small `ssh` subsystem that echoes N bytes can be implemented as shown in the\nfollowing example:\n\n```erlang\n-module(ssh_echo_server).\n-behaviour(ssh_server_channel). % replaces ssh_daemon_channel\n-record(state, {\n\t  n,\n\t  id,\n\t  cm\n\t }).\n-export([init/1, handle_msg/2, handle_ssh_msg/2, terminate/2]).\n\ninit([N]) ->\n    {ok, #state{n = N}}.\n\nhandle_msg({ssh_channel_up, ChannelId, ConnectionManager}, State) ->\n    {ok, State#state{id = ChannelId,\n\t\t     cm = ConnectionManager}}.\n\nhandle_ssh_msg({ssh_cm, CM, {data, ChannelId, 0, Data}}, #state{n = N} = State) ->\n    M = N - size(Data),\n    case M > 0 of\n\ttrue ->\n\t   ssh_connection:send(CM, ChannelId, Data),\n\t   {ok, State#state{n = M}};\n\tfalse ->\n\t   < > = Data,\n           ssh_connection:send(CM, ChannelId, SendData),\n           ssh_connection:send_eof(CM, ChannelId),\n\t   {stop, ChannelId, State}\n    end;\nhandle_ssh_msg({ssh_cm, _ConnectionManager,\n\t\t{data, _ChannelId, 1, Data}}, State) ->\n    error_logger:format(standard_error, \" ~p~n\", [binary_to_list(Data)]),\n    {ok, State};\n\nhandle_ssh_msg({ssh_cm, _ConnectionManager, {eof, _ChannelId}}, State) ->\n    {ok, State};\n\nhandle_ssh_msg({ssh_cm, _, {signal, _, _}}, State) ->\n    %% Ignore signals according to RFC 4254 section 6.9.\n    {ok, State};\n\nhandle_ssh_msg({ssh_cm, _, {exit_signal, ChannelId, _, _Error, _}},\n\t       State) ->\n    {stop, ChannelId,  State};\n\nhandle_ssh_msg({ssh_cm, _, {exit_status, ChannelId, _Status}}, State) ->\n    {stop, ChannelId, State}.\n\nterminate(_Reason, _State) ->\n    ok.\n```\n\nThe subsystem can be run on the host **ssh.example.com** with the generated keys, as\ndescribed in Section\n[Running an Erlang ssh Daemon](using_ssh.md#running-an-erlang-ssh-daemon):\n\n```erlang\n1> ssh:start().\nok\n2> ssh:daemon(8989, [{system_dir, \"/tmp/ssh_daemon\"},\n                     {user_dir, \"/tmp/otptest_user/.ssh\"}\n                     {subsystems, [{\"echo_n\", {ssh_echo_server, [10]}}]}]).\n{ok,<0.54.0>}\n3>\n```\n\n```erlang\n1> ssh:start().\nok\n2> {ok, ConnectionRef} = ssh:connect(\"ssh.example.com\", 8989,\n                                    [{user_dir, \"/tmp/otptest_user/.ssh\"}]).\n {ok,<0.57.0>}\n3> {ok, ChannelId} = ssh_connection:session_channel(ConnectionRef, infinity).\n4> success = ssh_connection:subsystem(ConnectionRef, ChannelId, \"echo_n\", infinity).\n5> ok = ssh_connection:send(ConnectionRef, ChannelId, \"0123456789\", infinity).\n6> flush().\n{ssh_msg, <0.57.0>, {data, 0, 1, \"0123456789\"}}\n{ssh_msg, <0.57.0>, {eof, 0}}\n{ssh_msg, <0.57.0>, {closed, 0}}\n7> {error, closed} = ssh_connection:send(ConnectionRef, ChannelId, \"10\", infinity).\n```\n\nSee also `m:ssh_client_channel` (replaces ssh_channel(3)).","ref":"using_ssh.html#creating-a-subsystem"},{"type":"extras","title":"Terminology","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Terminology","ref":"terminology.html"},{"type":"extras","title":"General Information - Terminology","doc":"In the following terms that may cause confusion are explained.","ref":"terminology.html#general-information"},{"type":"extras","title":"The term \"user\" - Terminology","doc":"A \"user\" is a term that everyone understands intuitively. However, the\nunderstandings may differ which can cause confusion.\n\nThe term is used differently in [OpenSSH](http://www.openssh.com) and SSH in\nErlang/OTP. The reason is the different environments and use cases that are not\nimmediately obvious.\n\nThis chapter aims at explaining the differences and giving a rationale for why\nErlang/OTP handles \"user\" as it does.","ref":"terminology.html#the-term-user"},{"type":"extras","title":"In OpenSSH - Terminology","doc":"Many have been in contact with the command 'ssh' on a Linux machine (or similar)\nto remotly log in on another machine. One types\n\n```text\nssh host\n```\n\nto log in on the machine named `host`. The command prompts for your password on\nthe remote `host` and then you can read, write and execute as your _user name_\nhas rights on the remote `host`. There are stronger variants with\npre-distributed keys or certificates, but that are for now just details in the\nauthentication process.\n\nYou could log in as the user `anotheruser` with\n\n```text\nssh anotheruser@host\n```\n\nand you will then be enabled to act as `anotheruser` on the `host` if authorized\ncorrectly.\n\nSo what does _\"your user name has rights\"_ mean? In a UNIX/Linux/etc context it\nis exactly as that context: The _user_ could read, write and execute programs\naccording to the OS rules. In addition, the user has a home directory (`$HOME`)\nand there is a `$HOME/.ssh/` directory with ssh-specific files.\n\n#### SSH password authentication\n\nWhen SSH tries to log in to a host, the ssh protocol communicates the user name\n(as a string) and a password. The remote ssh server checks that there is such a\nuser defined and that the provided password is acceptable.\n\nIf so, the user is authorized.\n\n#### SSH public key authentication\n\nThis is a stronger method where the ssh protocol brings the user name, the\nuser's public key and some cryptographic information which we could ignore here.\n\nThe ssh server on the remote host checks:\n\n- That the _user_ has a home directory,\n- that home directory contains a .ssh/ directory and\n- the .ssh/ directory contains the public key just received in the\n  `authorized_keys` file\n\nif so, the user is authorized.\n\n#### The SSH server on UNIX/Linux/etc after a successful authentication\n\nAfter a successful incoming authentication, a new process runs as the just\nauthenticated user.\n\nNext step is to start a service according to the ssh request. In case of a\nrequest of a shell, a new one is started which handles the OS-commands that\narrives from the client (that's \"you\").\n\nIn case of a sftp request, an sftp server is started in with the user's rights.\nSo it could read, write or delete files if allowed for that user.","ref":"terminology.html#in-openssh"},{"type":"extras","title":"In Erlang/OTP SSH - Terminology","doc":"For the Erlang/OTP SSH server the situation is different. The server executes in\nan Erlang process in the Erlang emulator which in turn executes in an OS\nprocess. The emulator does not try to change its user when authenticated over\nthe SSH protocol. So the remote user name is only for authentication purposes in\nthe Erlang/OTP SSH application.\n\n#### Password authentication in Erlang SSH\n\nThe Erlang/OTP SSH server checks the user name and password in the following\norder:\n\n1. If a [`pwdfun`](`m:ssh#option-pwdfun`) is defined, that one is called and the\n   returned boolean is the authentication result.\n1. Else, if the [`user_passwords`](`m:ssh#option-user_passwords`) option is\n   defined and the username and the password matches, the authentication is a\n   success.\n1. Else, if the option [`password`](`m:ssh#option-password`) is defined and\n   matches the password the authentication is a success. Note that the use of\n   this option is not recommended in non-test code.\n\n#### Public key authentication in Erlang SSH\n\nThe user name, public key and cryptographic data (a signature) that is sent by\nthe client are used as follows (some steps left out for clarity):\n\n1. A callback module is selected using the options\n   [`key_cb`](`t:ssh:key_cb_common_option/0`).\n1. The callback module is used to check that the provided public key is one of\n   the user's pre-stored. In case of the default callback module, the files\n   `authorized_keys` and `authorized_keys2` are searched in a directory found in\n   the following order:\n\n- If the option [`user_dir_fun`](`t:ssh_file:user_dir_fun_common_option/0`) is\n  defined, that fun is called and the returned directory is used,\n- Else, If the option [`user_dir`](`t:ssh_file:user_dir_common_option/0`) is\n  defined, that directory is used,\n- Else the subdirectory `.ssh` in the home directory of the user executing the\n  OS process of the Erlang emulator is used.\n\nIf the provided public key is not found, the authentication fails.\n\n1. Finally, if the provided public key is found, the signature provided by the\n   client is checked with the public key.\n\n#### The Erlang/OTP SSH server after a successful authentication\n\nAfter a successful authentication an _Erlang process_ is handling the service\nrequest from the remote ssh client. The rights of that process are those of the\nuser of the OS process running the Erlang emulator.\n\nIf a shell service request arrives to the server, an _Erlang shell_ is opened in\nthe server's emulator. The rights in that shell is independent of the just\nauthenticated user.\n\nIn case of an sftp request, an sftp server is started with the rights of the\nuser of the Erlang emulator's OS process. So with sftp the authenticated user\ndoes not influence the rights.\n\nSo after an authentication, the user name is not used anymore and has no\ninfluence.","ref":"terminology.html#in-erlang-otp-ssh"},{"type":"extras","title":"Configuration in SSH","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Configuration in SSH","ref":"configurations.html"},{"type":"extras","title":"Introduction - Configuration in SSH","doc":"The OTP SSH app can be configurated by a large amount of _Options_. This chapter\nwill not go into details of what each of the options does. It will however\ndescribe and define different ways by which they could be entered.\n\nOptions for hardening are described in the [Hardening SSH](hardening.md)\nchapter. How the options for algorithm configuration interact are described in\nthe [Configuring algorithms in SSH](configure_algos.md) chapter.","ref":"configurations.html#introduction"},{"type":"extras","title":"Options configuration - Configuration in SSH","doc":"There are from OTP-23.0 two main ways to set an option:\n\n- Like before, in the `Options` parameter in the Erlang code in a call to for\n  example `ssh:daemon/3` or `ssh:connect/3` or any of their variants. Example:\n\n  ```erlang\n  ssh:connect(22, [{user,\"foo\"}])\n  ```\n\n- In [OTP Configuration Parameters](`e:kernel:config.md`):\n\n  - In the erl command line:\n\n    ```text\n    erl -ssh user \\\"foo\\\"\n    ```\n\n  - In the `ssh.app` file, in the `env` part\n\n    ```erlang\n    {application, ssh,\n     [{description, \"SSH-2 for Erlang/OTP\"},\n      {vsn, \"4.9\"},\n      {modules, [ssh,\n            ...\n    \t     ssh_xfer]},\n      {registered, []},\n      {applications, [kernel, stdlib, crypto, public_key]},\n      {env, [{user, \"bar\"]}, % <<<<<<<<<<<<<<<<<<<<<<<<<<<<<< HERE\n      {mod, {ssh_app, []}},\n           ...\n    ```\n\n  - In a .config file:\n\n    ```text\n    erl -config ex1\n    ```\n\n    where `ex1.config` contains:\n\n    ```erlang\n    [\n    {ssh, [{user, \"foo\"}]}\n    ].\n    ```\n\n  If the option is intended only for a server or for a client, it may be set in\n  this way:\n\n  ```erlang\n  [\n  {ssh, [{server_options,[{user, \"foo\"}]},\n         {client_options,[{user, \"bar\"}]}\n  ].\n  ```\n\n  A server (daemon) will use the user name `foo`, and a client will use the name\n  `bar`.","ref":"configurations.html#options-configuration"},{"type":"extras","title":"Precedence - Configuration in SSH","doc":"If an option is set in more than one way, what happens?\n\nThere is an ordering, which is:\n\n- Level 0: Hard-coded default values in the OTP SSH source code\n- Level 1: [OTP Configuration Parameters](`e:kernel:config.md`)\n- Level 2: Options in the [OTP Configuration Parameters](`e:kernel:config.md`)\n  `server_options` or `client_options`\n- Level 3: Options in argument list to a function\n\nIf the same option is set at two different levels, the one at the highest level\nis used.\n\nThe only exception is the\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) common option.\nThey are all applied in ascending level order on the set of algorithms. So a\n`modify_algorithms` on level one is applied before one of level two and so on.\n\nIf there is an\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) option on\nsome level the whole set is replaced by that in that option and _all\nmodify_algorithms are applied_ in level ordering.\n\nThe reason for applying all\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) in level order,\nis to enable the user to add an algorithm that has been removed from the default\nset without code changes, only by adding an option in a config file. This can be\nused to interoperate with legacy systems that still uses algorithms no longer\nconsidered secure enough to be supported by default.","ref":"configurations.html#precedence"},{"type":"extras","title":"Algorithm configuration - Configuration in SSH","doc":"There is a [separate chapter](configure_algos.md#introduction) about how\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) and\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) co-operate. How\nthe different configuration levels affect them, is described here in this\nsection.\n\n#### The ssh:start/0 function\n\nIf the application SSH is _not_ [started](`ssh:start/0`), the command\n`ssh:default_algorithms/0` delivers the list of default (hardcoded) algorithms\nwith respect to the support in the current cryptolib.\n\nIf the application SSH _is_ [started](`ssh:start/0`), the command\n`ssh:default_algorithms/0` delvers the list of algorithms after application of\nlevel 0 and level 1 configurations.\n\nHere is an example. The config-file has the following contents:\n\n```text\n$ cat ex2.config\n[\n {ssh, [{preferred_algorithms, [{cipher, ['aes192-ctr']},\n       \t\t\t        {public_key, ['ssh-rsa']},\n                                {kex, ['ecdh-sha2-nistp384']},\n                                {mac, ['hmac-sha1']}]}]}\n].\n```\n\nErlang is started with `ex2.config` as configuration and we check the default\nset of algorithms before starting ssh:\n\n```text\n$ erl -config ex2\nErlang/OTP 23 [RELEASE CANDIDATE 1] [erts-10.6.4] [source-96a0823109] [64-bit] [smp:4:4] [ds:4:4:10] [async-threads:1] [hipe]\n\nEshell V10.6.4  (abort with ^G)\n1> ssh:default_algorithms().\n[{kex,['ecdh-sha2-nistp384','ecdh-sha2-nistp521',\n       'ecdh-sha2-nistp256','diffie-hellman-group-exchange-sha256',\n       'diffie-hellman-group16-sha512',\n       'diffie-hellman-group18-sha512',\n       'diffie-hellman-group14-sha256','curve25519-sha256',\n       'curve25519-sha256@libssh.org','curve448-sha512',\n       'diffie-hellman-group14-sha1',\n       'diffie-hellman-group-exchange-sha1']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n              'ecdsa-sha2-nistp256','ssh-ed25519','ssh-ed448','ssh-rsa',\n              'rsa-sha2-256','rsa-sha2-512','ssh-dss']},\n {cipher,[{client2server,['chacha20-poly1305@openssh.com',\n                          'aes256-gcm@openssh.com','aes256-ctr','aes192-ctr',\n                          'aes128-gcm@openssh.com','aes128-ctr','aes256-cbc',\n                          'aes192-cbc','aes128-cbc','3des-cbc']},\n          {server2client,['chacha20-poly1305@openssh.com',\n                          'aes256-gcm@openssh.com','aes256-ctr','aes192-ctr',\n                          'aes128-gcm@openssh.com','aes128-ctr','aes256-cbc',\n                          'aes192-cbc','aes128-cbc','3des-cbc']}]},\n {mac,[{client2server,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']},\n       {server2client,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n```\n\nNote that the algorithms in the file `ex2.config` is not yet applied. They will\nbe when we start ssh:\n\n```erlang\n2> ssh:start().\nok\n3> ssh:default_algorithms().\n[{kex,['ecdh-sha2-nistp384']},\n {public_key,['ssh-rsa']},\n {cipher,[{client2server,['aes192-ctr']},\n          {server2client,['aes192-ctr']}]},\n {mac,[{client2server,['hmac-sha1']},\n       {server2client,['hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n4>\n```\n\nWe see that the algorithm set is changed to the one in the `ex2.config`. Since\n`compression` is not specified in the file, the hard-coded default is still used\nfor that entry.\n\n#### Establishing a connection (ssh:connect et al) or starting a daemon (ssh:daemon)\n\nBoth when the client establishes a connection with ssh:connect or other\nfunctions, or a daemon is started with ssh:daemon, the option lists in the\nfunction calls are also used.\n\nIf a client is started (ssh:connect et al), the environment variable\n`client_options` is used. Similarly for a daemon the `server_options` variable\nis handled.\n\nIf any [preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) is\npresent, the one with the highest level is used, that is, the `Option` list\nparameter has the highest priority. Then the\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) on all levels in\norder starting with level 0 are applied.\n\nWe continue the example above by connecting to a server and modifying the `kex`\nalgorithm set. We remove the only one (`'ecdh-sha2-nistp384'`) and add\n`'curve25519-sha256@libssh.org'` by appending it to the now empty list:\n\n```erlang\n4> {ok,C} = ssh:connect(loopback, 22,\n                        [{modify_algorithms,\n                                 [{rm,\n                                     [ {kex,['ecdh-sha2-nistp384']} ]\n\t\t\t\t  },\n                                  {append,\n\t\t\t             [ {kex,['curve25519-sha256@libssh.org']} ]\n\t\t\t\t  }\n\t\t\t\t ]\n\t                 }\n                        ]).\n{ok,>0.118.0>}\n```\n\nWe check which algorithms are negotiated by the client and the server, and note\nthat the (only) `kex` algorithm `'curve25519-sha256@libssh.org'` was selected:\n\n```erlang\n5> ssh:connection_info(C, algorithms).\n{algorithms,[{kex,'curve25519-sha256@libssh.org'},\n             {hkey,'ssh-rsa'},\n             {send_mac,'hmac-sha1'},\n             {recv_mac,'hmac-sha1'},\n             {encrypt,'aes192-ctr'},\n             {decrypt,'aes192-ctr'},\n             {compress,none},\n             {decompress,none},\n             {send_ext_info,false},\n             {recv_ext_info,true}]}\n```\n\n#### Example of modify_algorithms handling\n\nWe will now check if the\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) on a lower level\nis applied to a\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) on a higher\nlevel. We will do that by enabling the `ssh-dss` algorithm that is supported,\nbut not in the default set.\n\nThe config file `ex3.config` has the contents:\n\n```erlang\n[\n {ssh, [{modify_algorithms,\n         [ {prepend, [{public_key, ['ssh-dss']}]} ]\n        }]}\n].\n```\n\nA newly started erlang shell shows that no `'ssh-dss'` is present in the\n`public_key` entry:\n\n```erlang\n1> proplists:get_value(public_key, ssh:default_algorithms()).\n['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n 'ecdsa-sha2-nistp256','ssh-ed25519','ssh-ed448',\n 'rsa-sha2-256','rsa-sha2-512','ssh-rsa']\n2>\n```\n\nA call to `ssh:connect/3` removes all algorithms but one of each type:\n\n```erlang\n2> ssh:start().\nok\n3> {ok,C} = ssh:connect(loopback, 22,\n                        [{preferred_algorithms,\n                         [{public_key, ['ecdsa-sha2-nistp256']},\n\t\t\t  {kex, ['ecdh-sha2-nistp256']},\n\t\t          {cipher, ['chacha20-poly1305@openssh.com']},\n\t\t\t  {mac, ['hmac-sha2-256']},\n\t\t\t  {compression, [none]}\n\t\t\t  ]}\n\t\t\t ]).\n{ok,<0.101.0>}\n4> ssh:connection_info(C,algorithms).\n{algorithms,[{kex,'ecdh-sha2-nistp256'},\n             {hkey,'ssh-dss'},\n             {send_mac,'chacha20-poly1305@openssh.com'},\n             {recv_mac,'chacha20-poly1305@openssh.com'},\n             {encrypt,'chacha20-poly1305@openssh.com'},\n             {decrypt,'chacha20-poly1305@openssh.com'},\n             {compress,none},\n             {decompress,none},\n             {send_ext_info,false},\n             {recv_ext_info,true}]}\n5>\n```\n\nBut `'ssh-dss'` is selected although the call inserted _only_\n`'ecdsa-sha2-nistp256'` as acceptable.\n\nThis example showed that we could augment the set of algorithms with a\nconfig-file without the need to change the actual call.\n\nFor demonstration purposes we used `prepend` instead of `append`. This forces\nthe negotiation to select `ssh-dss` since the the full list of public key\nalgorithms was `['ssh-dss','ecdsa-sha2-nistp256']`. Normally it is safer to\nappend a non-default algorithm.","ref":"configurations.html#algorithm-configuration"},{"type":"extras","title":"Configuring algorithms in SSH","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Configuring algorithms in SSH","ref":"configure_algos.html"},{"type":"extras","title":"Introduction - Configuring algorithms in SSH","doc":"To fully understand how to configure the algorithms, it is essential to have a\nbasic understanding of the SSH protocol and how OTP SSH app handles the\ncorresponding items.\n\nThe first subsection will give a short background of the SSH protocol while\nlater sections describes the implementation and provides some examples.\n\nHow the different levels of configuration \"interfere\" with this, see the section\n[Algorithm Configuration](configurations.md#algorithm-configuration) in the\nchapter [Configuration in SSH](configurations.md).","ref":"configure_algos.html#introduction"},{"type":"extras","title":"Basics of the ssh protocol's algorithms handling - Configuring algorithms in SSH","doc":"SSH uses different sets of algorithms in different phases of a session. Which\nalgorithms to use is negotiated by the client and the server at the beginning of\na session. See [RFC 4253](https://tools.ietf.org/html/rfc4253), \"The Secure\nShell (SSH) Transport Layer Protocol\" for details.\n\nThe negotiation is simple: both peers sends their list of supported alghorithms\nto the other part. The first algorithm on the client's list that also in on the\nserver's list is selected. So it is the client's ordering of the list that\ngives the priority for the algorithms.\n\nThere are five lists exchanged in the connection setup. Three of them are also\ndivided in two directions, to and from the server.\n\nThe lists are (named as in the SSH application's options):\n\n- **`kex`** - Key exchange\n\n  An algorithm is selected for computing a secret encryption key. Among examples\n  are: the old nowadays week `'diffie-hellman-group-exchange-sha1'` and the very\n  strong and modern `'ecdh-sha2-nistp512'`.\n\n- **`public_key`** - Server host key\n\n  The asymmetric encryption algorithm used in the server's private-public host\n  key pair. Examples include the well-known RSA `'ssh-rsa'` and elliptic curve\n  `'ecdsa-sha2-nistp521'`.\n\n- **`cipher`** - Symmetric cipher algorithm used for the payload encryption.\n  This algorithm will use the key calculated in the kex phase (together with\n  other info) to generate the actual key used. Examples are tripple-DES\n  `'3des-cbc'` and one of many AES variants `'aes192-ctr'`.\n\n  This list is actually two - one for each direction server-to-client and\n  client-to-server. Therefore it is possible but rare to have different\n  algorithms in the two directions in one connection.\n\n- **`mac`** - Message authentication code\n\n  \"Check sum\" of each message sent between the peers. Examples are SHA\n  `'hmac-sha1'` and SHA2 `'hmac-sha2-512'`.\n\n  This list is also divided into two for the both directions\n\n- **`compression`** - If and how to compress the message. Examples are `none`,\n  that is, no compression and `zlib`.\n\n  This list is also divided into two for the both directions","ref":"configure_algos.html#basics-of-the-ssh-protocol-s-algorithms-handling"},{"type":"extras","title":"The SSH app's mechanism - Configuring algorithms in SSH","doc":"The set of algorithms that the SSH app uses by default depends on the algorithms\nsupported by the:\n\n- `m:crypto` app,\n- The cryptolib OTP is linked with, usually the one the OS uses, probably\n  OpenSSL,\n- and finally what the SSH app implements\n\nDue to this, it impossible to list in documentation what algorithms that are\navailable in a certain installation.\n\nThere is an important command to list the actual algorithms and their ordering:\n`ssh:default_algorithms/0`.\n\n```erlang\n0> ssh:default_algorithms().\n[{kex,['ecdh-sha2-nistp384','ecdh-sha2-nistp521',\n       'ecdh-sha2-nistp256','diffie-hellman-group-exchange-sha256',\n       'diffie-hellman-group16-sha512',\n       'diffie-hellman-group18-sha512',\n       'diffie-hellman-group14-sha256',\n       'diffie-hellman-group14-sha1',\n       'diffie-hellman-group-exchange-sha1']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n              'ecdsa-sha2-nistp256','ssh-rsa','rsa-sha2-256',\n              'rsa-sha2-512','ssh-dss']},\n {cipher,[{client2server,['aes256-gcm@openssh.com',\n                          'aes256-ctr','aes192-ctr','aes128-gcm@openssh.com',\n                          'aes128-ctr','aes128-cbc','3des-cbc']},\n          {server2client,['aes256-gcm@openssh.com','aes256-ctr',\n                          'aes192-ctr','aes128-gcm@openssh.com','aes128-ctr',\n                          'aes128-cbc','3des-cbc']}]},\n {mac,[{client2server,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']},\n       {server2client,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n```\n\n{: #example_default_algorithms }\n\nTo change the algorithm list, there are two options which can be used in\n[ssh:connect/2,3,4](`ssh:connect/3`) and [ssh:daemon/2,3](`ssh:daemon/2`). The\noptions could of course be used in all other functions that initiates\nconnections.\n\nThe options are\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) and\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`). The first one\nreplaces the default set, while the latter modifies the default set.","ref":"configure_algos.html#the-ssh-app-s-mechanism"},{"type":"extras","title":"Replacing the default set: preferred_algorithms - Configuring algorithms in SSH","doc":"See the [Reference Manual](`t:ssh:preferred_algorithms_common_option/0`) for\ndetails\n\nHere follows a series of examples ranging from simple to more complex.\n\nTo forsee the effect of an option there is an experimental function\n`ssh:chk_algos_opts(Opts)`. It mangles the options `preferred_algorithms` and\n`modify_algorithms` in the same way as `ssh:daemon`, `ssh:connect` and their\nfriends does.","ref":"configure_algos.html#replacing-the-default-set-preferred_algorithms"},{"type":"extras","title":"Example 1 - Configuring algorithms in SSH","doc":"Replace the kex algorithms list with the single algorithm\n`'diffie-hellman-group14-sha256'`:\n\n```erlang\n1> ssh:chk_algos_opts(\n               [{preferred_algorithms,\n                     [{kex, ['diffie-hellman-group14-sha256']}\n                     ]\n                }\n              ]).\n[{kex,['diffie-hellman-group14-sha256']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n              'ecdsa-sha2-nistp256','ssh-rsa','rsa-sha2-256',\n              'rsa-sha2-512','ssh-dss']},\n {cipher,[{client2server,['aes256-gcm@openssh.com',\n                          'aes256-ctr','aes192-ctr','aes128-gcm@openssh.com',\n                          'aes128-ctr','aes128-cbc','3des-cbc']},\n          {server2client,['aes256-gcm@openssh.com','aes256-ctr',\n                          'aes192-ctr','aes128-gcm@openssh.com','aes128-ctr',\n                          'aes128-cbc','3des-cbc']}]},\n {mac,[{client2server,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']},\n       {server2client,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n```\n\nNote that the unmentioned lists (`public_key`, `cipher`, `mac` and\n`compression`) are unchanged.","ref":"configure_algos.html#example-1"},{"type":"extras","title":"Example 2 - Configuring algorithms in SSH","doc":"In the lists that are divided in two for the two directions (for example `cipher`) it is\npossible to change both directions at once:\n\n```erlang\n2> ssh:chk_algos_opts(\n               [{preferred_algorithms,\n                     [{cipher,['aes128-ctr']}\n                     ]\n                }\n              ]).\n[{kex,['ecdh-sha2-nistp384','ecdh-sha2-nistp521',\n       'ecdh-sha2-nistp256','diffie-hellman-group-exchange-sha256',\n       'diffie-hellman-group16-sha512',\n       'diffie-hellman-group18-sha512',\n       'diffie-hellman-group14-sha256',\n       'diffie-hellman-group14-sha1',\n       'diffie-hellman-group-exchange-sha1']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n              'ecdsa-sha2-nistp256','ssh-rsa','rsa-sha2-256',\n              'rsa-sha2-512','ssh-dss']},\n {cipher,[{client2server,['aes128-ctr']},\n          {server2client,['aes128-ctr']}]},\n {mac,[{client2server,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']},\n       {server2client,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n```\n\nNote that both lists in `cipher` has been changed to the provided value\n(`'aes128-ctr'`).","ref":"configure_algos.html#example-2"},{"type":"extras","title":"Example 3 - Configuring algorithms in SSH","doc":"In the lists that are divided in two for the two directions (for example `cipher`) it is\npossible to change only one of the directions:\n\n```erlang\n3> ssh:chk_algos_opts(\n               [{preferred_algorithms,\n                     [{cipher,[{client2server,['aes128-ctr']}]}\n                     ]\n                }\n              ]).\n[{kex,['ecdh-sha2-nistp384','ecdh-sha2-nistp521',\n       'ecdh-sha2-nistp256','diffie-hellman-group-exchange-sha256',\n       'diffie-hellman-group16-sha512',\n       'diffie-hellman-group18-sha512',\n       'diffie-hellman-group14-sha256',\n       'diffie-hellman-group14-sha1',\n       'diffie-hellman-group-exchange-sha1']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n              'ecdsa-sha2-nistp256','ssh-rsa','rsa-sha2-256',\n              'rsa-sha2-512','ssh-dss']},\n {cipher,[{client2server,['aes128-ctr']},\n          {server2client,['aes256-gcm@openssh.com','aes256-ctr',\n                          'aes192-ctr','aes128-gcm@openssh.com','aes128-ctr',\n                          'aes128-cbc','3des-cbc']}]},\n {mac,[{client2server,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']},\n       {server2client,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n```","ref":"configure_algos.html#example-3"},{"type":"extras","title":"Example 4 - Configuring algorithms in SSH","doc":"It is of course possible to change more than one list:\n\n```erlang\n4> ssh:chk_algos_opts(\n               [{preferred_algorithms,\n                     [{cipher,['aes128-ctr']},\n\t\t      {mac,['hmac-sha2-256']},\n                      {kex,['ecdh-sha2-nistp384']},\n\t\t      {public_key,['ssh-rsa']},\n\t\t      {compression,[{server2client,[none]},\n\t\t                    {client2server,[zlib]}]}\n                     ]\n                }\n              ]).\n[{kex,['ecdh-sha2-nistp384']},\n {public_key,['ssh-rsa']},\n {cipher,[{client2server,['aes128-ctr']},\n          {server2client,['aes128-ctr']}]},\n {mac,[{client2server,['hmac-sha2-256']},\n       {server2client,['hmac-sha2-256']}]},\n {compression,[{client2server,[zlib]},\n               {server2client,[none]}]}]\n```\n\nNote that the order of the tuples in the lists does not matter.","ref":"configure_algos.html#example-4"},{"type":"extras","title":"Modifying the default set: modify_algorithms - Configuring algorithms in SSH","doc":"A situation where it might be useful to add an algorithm is when one need to use\na supported but disabled one. An example is the `'diffie-hellman-group1-sha1'`\nwhich nowadays is very unsecure and therefore disabled. It is however still\nsupported and might be used.\n\nThe option `preferred_algorithms` may be complicated to use for adding or\nremoving single algorithms. First one has to list them with\n`ssh:default_algorithms()` and then do changes in the lists.\n\nTo facilitate addition or removal of algorithms the option `modify_algorithms`\nis available. See the\n[Reference Manual](`t:ssh:modify_algorithms_common_option/0`) for details.\n\nThe option takes a list with instructions to append, prepend or remove\nalgorithms:\n\n```erlang\n{modify_algorithms, [{append,  ...},\n                     {prepend, ...},\n\t\t     {rm,      ...}\n\t\t    ]}\n```\n\nEach of the `...` can be a `algs_list()` as the argument to the\n`preferred_algorithms` option.","ref":"configure_algos.html#modifying-the-default-set-modify_algorithms"},{"type":"extras","title":"Example 5 - Configuring algorithms in SSH","doc":"As an example let's add the Diffie-Hellman Group1 first in the kex list. It is\nsupported according to [Supported algorithms](ssh_app.md#supported_algos).\n\n```erlang\n5> ssh:chk_algos_opts(\n         [{modify_algorithms,\n\t       [{prepend,\n\t           [{kex,['diffie-hellman-group1-sha1']}]\n\t\t   }\n\t       ]\n          }\n        ]).\n[{kex,['diffie-hellman-group1-sha1','ecdh-sha2-nistp384',\n       'ecdh-sha2-nistp521','ecdh-sha2-nistp256',\n       'diffie-hellman-group-exchange-sha256',\n       'diffie-hellman-group16-sha512',\n       'diffie-hellman-group18-sha512',\n       'diffie-hellman-group14-sha256',\n       'diffie-hellman-group14-sha1',\n       'diffie-hellman-group-exchange-sha1']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n              'ecdsa-sha2-nistp256','ssh-rsa','rsa-sha2-256',\n              'rsa-sha2-512','ssh-dss']},\n {cipher,[{client2server,['aes256-gcm@openssh.com',\n                          'aes256-ctr','aes192-ctr','aes128-gcm@openssh.com',\n                          'aes128-ctr','aes128-cbc','3des-cbc']},\n          {server2client,['aes256-gcm@openssh.com','aes256-ctr',\n                          'aes192-ctr','aes128-gcm@openssh.com','aes128-ctr',\n                          'aes128-cbc','3des-cbc']}]},\n {mac,[{client2server,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']},\n       {server2client,['hmac-sha2-256','hmac-sha2-512',\n                       'hmac-sha1']}]},\n {compression,[{client2server,[none,'zlib@openssh.com',zlib]},\n               {server2client,[none,'zlib@openssh.com',zlib]}]}]\n```\n\nAnd the result shows that the Diffie-Hellman Group1 is added at the head of the\nkex list","ref":"configure_algos.html#example-5"},{"type":"extras","title":"Example 6 - Configuring algorithms in SSH","doc":"In this example, we in put the 'diffie-hellman-group1-sha1' first and also move\nthe `'ecdh-sha2-nistp521'` to the end in the kex list, that is, `append` it.\n\n```erlang\n6> ssh:chk_algos_opts(\n         [{modify_algorithms,\n\t       [{prepend,\n\t           [{kex, ['diffie-hellman-group1-sha1']}\n\t\t   ]},\n\t\t{append,\n                   [{kex, ['ecdh-sha2-nistp521']}\n                   ]}\n\t       ]\n          }\n        ]).\n[{kex,['diffie-hellman-group1-sha1','ecdh-sha2-nistp384',\n       'ecdh-sha2-nistp256','diffie-hellman-group-exchange-sha256',\n       'diffie-hellman-group16-sha512',\n       'diffie-hellman-group18-sha512',\n       'diffie-hellman-group14-sha256',\n       'diffie-hellman-group14-sha1',\n       'diffie-hellman-group-exchange-sha1','ecdh-sha2-nistp521']},\n {public_key,['ecdsa-sha2-nistp384','ecdsa-sha2-nistp521',\n   .....\n]\n```\n\nNote that the appended algorithm is removed from its original place and then\nappended to the same list.","ref":"configure_algos.html#example-6"},{"type":"extras","title":"Example 7 - Configuring algorithms in SSH","doc":"In this example, we use both options (`preferred_algorithms` and\n`modify_algorithms`) and also try to prepend an unsupported algorithm. Any\nunsupported algorithm is quietly removed.\n\n```erlang\n7> ssh:chk_algos_opts(\n         [{preferred_algorithms,\n               [{cipher,['aes128-ctr']},\n\t        {mac,['hmac-sha2-256']},\n                {kex,['ecdh-sha2-nistp384']},\n\t\t{public_key,['ssh-rsa']},\n\t\t{compression,[{server2client,[none]},\n\t\t              {client2server,[zlib]}]}\n               ]\n           },\n          {modify_algorithms,\n\t       [{prepend,\n\t           [{kex, ['some unsupported algorithm']}\n\t\t   ]},\n\t\t{append,\n                   [{kex, ['diffie-hellman-group1-sha1']}\n                   ]}\n\t       ]\n          }\n        ]).\n[{kex,['ecdh-sha2-nistp384','diffie-hellman-group1-sha1']},\n {public_key,['ssh-rsa']},\n {cipher,[{client2server,['aes128-ctr']},\n          {server2client,['aes128-ctr']}]},\n {mac,[{client2server,['hmac-sha2-256']},\n       {server2client,['hmac-sha2-256']}]},\n {compression,[{client2server,[zlib]},\n               {server2client,[none]}]}]\n```\n\nIt is of course questionable why anyone would like to use the both these options\ntogether, but it is possible if an unforeseen need should arise.","ref":"configure_algos.html#example-7"},{"type":"extras","title":"Example 8 - Configuring algorithms in SSH","doc":"In this example, we need to use a diffie-hellman-group1-sha1 key exchange\nalgorithm although it is unsafe and disabled by default.\n\nWe use the [modify_algorithms](`t:ssh:modify_algorithms_common_option/0`)\noption, because we want to keep all other algorithm definitions.\n\nWe add the option:\n\n```erlang\n  {modify_algorithms, [{append, [{kex,['diffie-hellman-group1-sha1']}]}]}\n```\n\neither to the Options list in a function call, in the `ssh.app` file or in a\n`.config` file for the `erl` command. See the chapter\n[Configuration in SSH](configurations.md) in the SSH User's Guide.","ref":"configure_algos.html#example-8"},{"type":"extras","title":"Example 9 - Configuring algorithms in SSH","doc":"In this example, we need to use a DSA key for sign and verify. It might be\neither as a user's key, a host's key or both.\n\nTo do that, we enable the 'ssh-dss' algorithm that is disabled by default by\nsecurity reasons. We use the\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`) option, because\nwe want to keep all other algorithm definitions.\n\nWe add the option:\n\n```erlang\n  {modify_algorithms, [{append, [{public_key,['ssh-dss']}]}]}\n```\n\neither to the Options list in a function call, in the `ssh.app` file or in a\n`.config` file for the `erl` command. See the chapter\n[Configuration in SSH](configurations.md) in the SSH User's Guide.","ref":"configure_algos.html#example-9"},{"type":"extras","title":"Hardening","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Hardening","ref":"hardening.html"},{"type":"extras","title":"Introduction - Hardening","doc":"The Erlang/OTP SSH application is intended to be used in other applications as a\nlibrary.\n\nDifferent applications using this library may have very different requirements.\nOne application could be running on a high performance server, while another is\nrunning on a small device with very limited cpu capacity. For example, the first\none may accept many users simultaneously logged in, while the second one wants\nto limit them to only one.\n\nThat simple example shows that it is impossible to deliver the SSH application\nwith default values on hardening options as well on other options that suites\nevery need.\n\nThe purpose of this guide is to discuss the different hardening options\navailable, as a guide to the reader. Configuration in general is described in\nthe [Configuration in SSH](configurations.md) chapter.","ref":"hardening.html#introduction"},{"type":"extras","title":"Resilience to DoS attacks - Hardening","doc":"The following applies to daemons (servers).\n\nDoS (Denial of Service) attacks are hard to fight at the node level. Here are\nfirewalls and other means needed, but that is out of scope for this guide.\nHowever, some measures could be taken in the configuration of the SSH server to\nincrease the resilence. The options to use are:","ref":"hardening.html#resilience-to-dos-attacks"},{"type":"extras","title":"Counters and parallelism - Hardening","doc":"- **[max_sessions](`m:ssh#hardening_daemon_options-max_sessions`)** - The\n  maximum number of simultaneous sessions that are accepted at any time for this\n  daemon. This includes sessions that are being authorized. The default is that\n  an unlimited number of simultaneous sessions are allowed. It is a good\n  candidate to set if the capacity of the server is low or a capacity margin is\n  needed.\n\n- **[max_channels](`m:ssh#hardening_daemon_options-max_channels`)** - The\n  maximum number of channels that are accepted for each connection. The default\n  is unlimited.\n\n- **[parallel_login](`m:ssh#hardening_daemon_options-parallel_login`)** - If set\n  to false (the default value), only one login is handled at a time. If set to\n  true, the number of simultaneous login attempts are limited by the value of\n  the [max_sessions](`m:ssh#hardening_daemon_options-max_sessions`) option.","ref":"hardening.html#counters-and-parallelism"},{"type":"extras","title":"Timeouts - Hardening","doc":"- **[hello_timeout](`t:ssh:hello_timeout_daemon_option/0`)** - If the client\n  fails to send the first ssh message after a tcp connection setup within this\n  time (in milliseconds), the connection is closed. The default value is 30\n  seconds. This is actually a generous time, so it can lowered to make the\n  daemon less prone to DoS attacks.\n\n- **[negotiation_timeout](`t:ssh:negotiation_timeout_daemon_option/0`)** -\n  Maximum time in milliseconds for the authentication negotiation counted from\n  the TCP connection establishment. If the client fails to log in within this\n  time the connection is closed. The default value is 2 minutes. It is quite a\n  long time, but can lowered if the client is supposed to be fast like if it is\n  a program logging in.\n\n- **[idle_time](`t:ssh:max_idle_time_common_option/0`)** - Sets a time-out on a\n  connection when no channels are left after closing the final one. It defaults\n  to infinity.\n\n- **[max_initial_idle_time](`t:ssh:max_initial_idle_time_daemon_option/0`)** -\n  Sets a time-out on a connection that will expire if no channel is opened on\n  the connection. The timeout is started when the authentication phase is\n  completed. It defaults to infinity.\n\nA figure clarifies when a timeout is started and when it triggers:\n\n![SSH server timeouts](assets/ssh_timeouts.jpg \"SSH server timeouts\")","ref":"hardening.html#timeouts"},{"type":"extras","title":"Verifying the remote daemon (server) in an SSH client - Hardening","doc":"Every SSH server presents a public key - the _host key_ \\- to the client while\nkeeping the corresponding private key in relatively safe privacy.\n\nThe client checks that the host that presented the public key also possesses the\nprivate key of the key-pair. That check is part of the SSH protocol.\n\nBut how can the client know that the host _really_ is the one that it tried to\nconnect to and not an evil one impersonating the expected one using its own\nvalid key-pair? There are two alternatives available with the default key\nhandling plugin `m:ssh_file`. The alternatives are:\n\n- **Pre-store the host key** - \\* For the default handler ssh_file, store the\n  valid host keys in the file [`known_hosts`](`m:ssh_file#FILE-known_hosts`) and\n  set the option\n  [silently_accept_hosts](`m:ssh#hardening_client_options-silently_accept_hosts`)\n  to `false`.\n\n  - or, write a specialized key handler using the\n    [SSH client key API](`m:ssh_client_key_api`) that accesses the pre-shared\n    key in some other way.\n\n- **Pre-store the \"fingerprint\" (checksum) of the host key** - \\*\n  [silently_accept_hosts](`m:ssh#hardening_client_options-silently_accept_hosts`)\n  - [`accept_callback()`](`t:ssh:accept_callback/0`)\n  - [`{HashAlgoSpec, accept_callback()}`](`t:ssh:accept_hosts/0`)","ref":"hardening.html#verifying-the-remote-daemon-server-in-an-ssh-client"},{"type":"extras","title":"Verifying the remote client in a daemon (server) - Hardening","doc":"- **Password checking** - The default password checking is with the list in the\n  [user_passwords](`m:ssh#option-user_passwords`) option in the SSH daemon. It\n  could be replaced with a [pwdfun](`m:ssh#option-pwdfun`) plugin. The arity\n  four variant ([`pwdfun_4()`](`t:ssh:pwdfun_4/0`)) can also be used for\n  introducing delays after failed password checking attempts. Here is a simple\n  example of such a pwdfun:\n\n  ```erlang\n  fun(User, Password, _PeerAddress, State) ->\n          case lists:member({User,Password}, my_user_pwds()) of\n              true ->\n                  {true, undefined}; % Reset delay time\n              false when State == undefined ->\n                  timer:sleep(1000),\n                  {false, 2000}; % Next delay is 2000 ms\n              false when is_integer(State) ->\n                  timer:sleep(State),\n                  {false, 2*State} % Double the delay for each failure\n          end\n  end.\n  ```\n\n  If a public key is used for logging in, there is normally no checking of the\n  user name. It could be enabled by setting the option\n  [`pk_check_user`](`m:ssh#option-pk_check_user`) to `true`. In that case the\n  pwdfun will get the atom `pubkey` in the password argument.","ref":"hardening.html#verifying-the-remote-client-in-a-daemon-server"},{"type":"extras","title":"Hardening in the cryptographic area - Hardening","doc":"","ref":"hardening.html#hardening-in-the-cryptographic-area"},{"type":"extras","title":"Algorithm selection - Hardening","doc":"One of the cornerstones of security in SSH is cryptography. The development in\ncrypto analysis is fast, and yesterday's secure algorithms are unsafe today.\nTherefore some algorithms are no longer enabled by default and that group grows\nwith time. See the\n[SSH (App)](ssh_app.md#supported-specifications-and-standards) for a list of\nsupported and of disabled algorithms. In the User's Guide the chapter\n[Configuring algorithms in SSH](configure_algos.md) describes the options for\nenabling or disabling algorithms -\n[preferred_algorithms](`t:ssh:preferred_algorithms_common_option/0`) and\n[modify_algorithms](`t:ssh:modify_algorithms_common_option/0`).","ref":"hardening.html#algorithm-selection"},{"type":"extras","title":"Re-keying - Hardening","doc":"In the setup of the SSH connection a secret cipher key is generated by\nco-operation of the client and the server. Keeping this key secret is crucial\nfor keeping the communication secret. As time passes and encrypted messages are\nexchanged, the probability that a listener could guess that key increases.\n\nThe SSH protocol therefore has a special operation defined - _key\nre-negotiation_ or _re-keying_. Any side (client or server) could initiate the\nre-keying and the result is a new cipher key. The result is that the\neves-dropper has to restart its evil and dirty craftmanship.\n\nSee the option [rekey_limit](`t:ssh:rekey_limit_common_option/0`) for a\ndescription.","ref":"hardening.html#re-keying"},{"type":"extras","title":"Hardening of the SSH protocol - both daemons and clients - Hardening","doc":"","ref":"hardening.html#hardening-of-the-ssh-protocol-both-daemons-and-clients"},{"type":"extras","title":"Disabling shell and exec in a daemon - Hardening","doc":"A daemon has two services for evaluating tasks on behalf of a remote client. The\n_exec_ server-side service takes a string provided by the client, evaluates it\nand returns the result. The _shell_ function enables the client to open a shell\nin the shell host.\n\nThose service could - and should - be disabled when they are not needed. The\noptions [exec](`t:ssh:exec_daemon_option/0`) and\n[shell](`t:ssh:shell_daemon_option/0`) are enabled per default but could be set\nto `disabled` if not needed. The same options could also install handlers for\nthe string(s) passed from the client to the server.","ref":"hardening.html#disabling-shell-and-exec-in-a-daemon"},{"type":"extras","title":"The id string - Hardening","doc":"One way to reduce the risk of intrusion is to not convey which software and\nwhich version the intruder is connected to. This limits the risk of an intruder\nexploiting known faults or peculiarities learned by reading the public code.\n\nEach SSH client or daemon presents themselves to each other with brand and\nversion. This may look like\n\n```text\nSSH-2.0-Erlang/4.10\n```\n\nor\n\n```text\nSSH-2.0-OpenSSH_7.6p1 Ubuntu-4ubuntu0.3\n```\n\nThis brand and version may be changed with the option\n[id_string](`t:ssh:id_string_common_option/0`). We start a daemon with that\noption:\n\n```erlang\n\tssh:daemon(1234, [{id_string,\"hi there\"}, ... ]).\n```\n\nand the daemon will present itself as:\n\n```text\nSSH-2.0-hi there\n```\n\nIt is possible to replace the string with one randomly generated for each\nconnection attempt. See the reference manual for\n[id_string](`t:ssh:id_string_common_option/0`).","ref":"hardening.html#the-id-string"},{"type":"extras","title":"Client connection options - Hardening","doc":"A client could limit the time for the initial tcp connection establishment with\nthe option [connect_timeout](`t:ssh:connect_timeout_client_option/0`). The time\nis in milliseconds, and the initial value is infinity.\n\nThe negotiation (session setup time) time can be limited with the _parameter_\n`NegotiationTimeout` in a call establishing an ssh session, for example\n`ssh:connect/3`.","ref":"hardening.html#client-connection-options"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}