/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.element;

import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.mam.element.MamVersion;
import org.jxmpp.jid.Jid;

public class MamElements {

    public static class NeverJidListElement
    implements Element {
        private List<Jid> neverJids;

        public NeverJidListElement(List<Jid> neverJids) {
            this.neverJids = neverJids;
        }

        @Override
        public CharSequence toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("never");
            for (Jid jid : this.neverJids) {
                xml.element("jid", jid);
            }
            xml.closeElement("never");
            return xml;
        }
    }

    public static class AlwaysJidListElement
    implements Element {
        private final List<Jid> alwaysJids;

        AlwaysJidListElement(List<Jid> alwaysJids) {
            this.alwaysJids = alwaysJids;
        }

        @Override
        public CharSequence toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.openElement("always");
            for (Jid jid : this.alwaysJids) {
                xml.element("jid", jid);
            }
            xml.closeElement("always");
            return xml;
        }
    }

    public static abstract class MamResultExtension
    implements ExtensionElement {
        public static final String ELEMENT = "result";
        private final String id;
        private final Forwarded<Message> forwarded;
        private String queryId;
        protected final MamVersion version;

        public MamResultExtension(MamVersion version, String queryId, String id, Forwarded<Message> forwarded) {
            if (StringUtils.isEmpty(id)) {
                throw new IllegalArgumentException("id must not be null or empty");
            }
            if (forwarded == null) {
                throw new IllegalArgumentException("forwarded must no be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("version must not be null");
            }
            this.version = version;
            this.id = id;
            this.forwarded = forwarded;
            this.queryId = queryId;
        }

        public String getId() {
            return this.id;
        }

        public Forwarded<Message> getForwarded() {
            return this.forwarded;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public final String getNamespace() {
            return this.version.getNamespace();
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
            xml.optAttribute("queryid", this.getQueryId());
            xml.optAttribute("id", this.getId());
            xml.rightAngleBracket();
            xml.append(this.getForwarded());
            xml.closeElement(this);
            return xml;
        }

        public static MamResultExtension from(MessageView message) {
            for (XmlElement extension : message.getExtensions()) {
                if (!(extension instanceof MamResultExtension)) continue;
                return (MamResultExtension)extension;
            }
            return null;
        }
    }
}

