/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dane;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.minidns.dane.X509TrustManagerUtil;

public class ExpectingTrustManager
implements X509TrustManager {
    private CertificateException exception;
    private final X509TrustManager trustManager;

    public ExpectingTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager == null ? X509TrustManagerUtil.getDefault() : trustManager;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public CertificateException getException() {
        CertificateException e = this.exception;
        this.exception = null;
        return e;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.exception = e;
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.exception = e;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

