/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script;

import com.google.inject.Binder;
import com.google.inject.Module;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.model.script.engine.IActionServiceProvider;
import org.openhab.core.model.script.engine.IThingActionsProvider;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.internal.engine.ServiceTrackerActionServiceProvider;
import org.openhab.core.model.script.internal.engine.ServiceTrackerThingActionsProvider;
import org.openhab.core.model.script.script.Script;
import org.openhab.core.model.script.script.impl.ScriptImpl;
import org.openhab.core.thing.ThingRegistry;

public class ServiceModule
implements Module {
    private final ScriptServiceUtil scriptServiceUtil;
    private final ScriptEngine scriptEngine;

    public ServiceModule(ScriptServiceUtil scriptServiceUtil, ScriptEngine scriptEngine) {
        this.scriptServiceUtil = scriptServiceUtil;
        this.scriptEngine = scriptEngine;
    }

    public void configure(Binder binder) {
        binder.bind(ItemRegistry.class).toInstance((Object)this.scriptServiceUtil.getItemRegistryInstance());
        binder.bind(ThingRegistry.class).toInstance((Object)this.scriptServiceUtil.getThingRegistryInstance());
        binder.bind(ModelRepository.class).toInstance((Object)this.scriptServiceUtil.getModelRepositoryInstance());
        binder.bind(ScriptEngine.class).toInstance((Object)this.scriptEngine);
        binder.bind(IActionServiceProvider.class).toInstance((Object)new ServiceTrackerActionServiceProvider(this.scriptServiceUtil));
        binder.bind(IThingActionsProvider.class).toInstance((Object)new ServiceTrackerThingActionsProvider(this.scriptServiceUtil));
        binder.bind(Script.class).to(ScriptImpl.class);
    }
}

