/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.log;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.openhab.core.common.ThreadFactoryBuilder;
import org.openhab.core.io.websocket.log.LogDTO;
import org.openhab.core.io.websocket.log.LogFilterDTO;
import org.openhab.core.io.websocket.log.LogWebSocketAdapter;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
@NonNullByDefault
public class LogWebSocket
implements LogListener {
    private static final TypeToken<List<String>> STRING_LIST_TYPE = TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class});
    private static final int SEND_PERIOD = 100;
    private static final long FIRST_SEQUENCE = 0L;
    private final Logger logger = LoggerFactory.getLogger(LogWebSocket.class);
    private final LogWebSocketAdapter wsAdapter;
    private final Gson gson;
    private @Nullable Session session;
    private @Nullable RemoteEndpoint remoteEndpoint;
    private @Nullable ScheduledExecutorService scheduledExecutorService;
    private @Nullable ScheduledFuture<?> commitScheduledFuture;
    private long lastSentTime = 0L;
    private List<LogDTO> deferredLogs = new ArrayList<LogDTO>();
    private boolean enabled = false;
    private long lastSequence = 0L;
    private final List<Pattern> loggerPatterns = new CopyOnWriteArrayList<Pattern>();

    public LogWebSocket(Gson gson, LogWebSocketAdapter wsAdapter) {
        this.wsAdapter = wsAdapter;
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.stopDeferredScheduledFuture();
        LogWebSocket logWebSocket = this;
        synchronized (logWebSocket) {
            if (this.enabled) {
                this.wsAdapter.unregisterListener(this);
                this.enabled = false;
            }
            this.session = null;
            this.remoteEndpoint = null;
            this.deferredLogs.clear();
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdownNow();
            }
            this.scheduledExecutorService = null;
        }
    }

    @OnWebSocketConnect
    public synchronized void onConnect(Session session) {
        InetSocketAddress isa;
        this.session = session;
        this.remoteEndpoint = session.getRemote();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        String name = (isa = session.getRemoteAddress()) == null ? "websocket-logger" : "websocket-logger-" + isa.getHostString() + ":" + isa.getPort();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.create().withNamePrefix("OH").withName(name).withUncaughtExceptionHandler((t, e) -> {}).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onText(String message) {
        long sentTime;
        Long sequenceStart;
        List<Pattern> filters;
        List<String> loggerNames;
        LogFilterDTO logFilterDto;
        RemoteEndpoint remoteEndpoint;
        Session session;
        if ("{}".equals(message)) {
            return;
        }
        LogWebSocket logWebSocket = this;
        synchronized (logWebSocket) {
            this.lastSentTime = Long.MAX_VALUE;
            this.stopDeferredScheduledFuture();
            if (!this.enabled) {
                this.wsAdapter.registerListener(this);
                this.enabled = true;
            }
            session = this.session;
            remoteEndpoint = this.remoteEndpoint;
        }
        if (session == null || remoteEndpoint == null) {
            return;
        }
        try {
            logFilterDto = (LogFilterDTO)this.gson.fromJson(message, LogFilterDTO.class);
        }
        catch (JsonParseException e) {
            this.logger.warn("Failed to parse '{}' to a valid log filter object", (Object)message);
            return;
        }
        if (!this.loggerPatterns.isEmpty()) {
            this.loggerPatterns.clear();
        }
        if (logFilterDto != null && (loggerNames = logFilterDto.loggerNames) != null && !(filters = loggerNames.stream().map(Pattern::compile).toList()).isEmpty()) {
            this.loggerPatterns.addAll(filters);
        }
        Long timeStart = logFilterDto != null && logFilterDto.timeStart != null ? logFilterDto.timeStart : Long.valueOf(Long.MIN_VALUE);
        Long timeStop = logFilterDto != null && logFilterDto.timeStop != null ? logFilterDto.timeStop : Long.valueOf(Long.MAX_VALUE);
        if (logFilterDto != null && logFilterDto.sequenceStart != null) {
            sequenceStart = logFilterDto.sequenceStart;
        } else {
            LogWebSocket logWebSocket2 = this;
            synchronized (logWebSocket2) {
                sequenceStart = this.lastSequence;
            }
        }
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        Object history = this.wsAdapter.getLog();
        while (history.hasMoreElements()) {
            logs.add(history.nextElement());
        }
        if (logs.isEmpty()) {
            history = this;
            synchronized (history) {
                this.lastSentTime = 0L;
            }
            return;
        }
        Predicate<LogEntry> withinTimeRange = log -> log.getTime() >= timeStart && log.getTime() <= timeStop;
        Predicate<LogEntry> withinSequence = log -> log.getSequence() > sequenceStart;
        Predicate<LogEntry> nameMatchesAnyPattern = log -> this.loggerPatterns.stream().anyMatch(pattern -> pattern.matcher(log.getLoggerName()).matches());
        List filteredEvents = logs.stream().filter(withinTimeRange.and(withinSequence)).collect(Collectors.toList());
        List dtoList = filteredEvents.stream().map(this::map).collect(Collectors.toList());
        Collections.sort(dtoList);
        try {
            this.sendMessage(this.gson.toJson(dtoList));
            sentTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            sentTime = Long.MIN_VALUE;
        }
        long newestSequence = ((LogEntry)logs.getFirst()).getSequence();
        LogWebSocket logWebSocket3 = this;
        synchronized (logWebSocket3) {
            Iterator<LogDTO> iterator = this.deferredLogs.iterator();
            while (iterator.hasNext()) {
                LogDTO value = iterator.next();
                if (value.sequence > newestSequence) continue;
                iterator.remove();
            }
        }
        logWebSocket3 = this;
        synchronized (logWebSocket3) {
            this.lastSentTime = sentTime == Long.MIN_VALUE ? 0L : sentTime;
        }
        this.flush();
    }

    @OnWebSocketError
    public void onError(@Nullable Session session, @Nullable Throwable error) {
        if (session != null) {
            session.close();
        }
        String message = error == null ? "<null>" : Objects.requireNonNullElse(error.getMessage(), "<null>");
        this.logger.info("WebSocket error: {}", (Object)message);
        this.onClose(1005, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(String message) throws IOException {
        RemoteEndpoint remoteEndpoint;
        LogWebSocket logWebSocket = this;
        synchronized (logWebSocket) {
            remoteEndpoint = this.remoteEndpoint;
        }
        if (remoteEndpoint == null) {
            return;
        }
        remoteEndpoint.sendString(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logged(@NonNullByDefault(value={}) LogEntry logEntry) {
        if (!this.loggerPatterns.isEmpty() && this.loggerPatterns.stream().noneMatch(LogWebSocket.logPatternMatch(logEntry))) {
            return;
        }
        LogDTO logDTO = this.map(logEntry);
        LogWebSocket logWebSocket = this;
        synchronized (logWebSocket) {
            ScheduledExecutorService executor = this.scheduledExecutorService;
            if (executor == null) {
                return;
            }
            this.lastSequence = logEntry.getSequence();
            boolean bufferEmpty = this.deferredLogs.isEmpty();
            if (!bufferEmpty || this.lastSentTime > System.currentTimeMillis() - 100L) {
                if (bufferEmpty) {
                    this.stopDeferredScheduledFuture();
                    this.commitScheduledFuture = executor.schedule(this::flush, this.lastSentTime + 100L - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                this.deferredLogs.add(logDTO);
            } else {
                this.lastSentTime = System.currentTimeMillis();
                executor.submit(() -> {
                    try {
                        this.sendMessage(this.gson.toJson((Object)logDTO));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
    }

    private static Predicate<Pattern> logPatternMatch(LogEntry logEntry) {
        return pattern -> pattern.matcher(logEntry.getLoggerName()).matches();
    }

    private LogDTO map(LogEntry logEntry) {
        String stackTrace;
        if (logEntry.getException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            logEntry.getException().printStackTrace(pw);
            stackTrace = sw.toString();
        } else {
            stackTrace = "";
        }
        return new LogDTO(logEntry.getSequence(), logEntry.getLoggerName(), logEntry.getLogLevel(), logEntry.getTime(), logEntry.getMessage(), stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDeferredScheduledFuture() {
        ScheduledFuture<?> commitScheduledFuture;
        LogWebSocket logWebSocket = this;
        synchronized (logWebSocket) {
            commitScheduledFuture = this.commitScheduledFuture;
            this.commitScheduledFuture = null;
        }
        if (commitScheduledFuture != null && !commitScheduledFuture.isDone()) {
            commitScheduledFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        List<LogDTO> logs;
        this.stopDeferredScheduledFuture();
        LogWebSocket logWebSocket = this;
        synchronized (logWebSocket) {
            if (this.deferredLogs.isEmpty()) {
                logs = null;
            } else {
                logs = List.copyOf(this.deferredLogs);
                this.deferredLogs.clear();
            }
        }
        if (logs != null) {
            try {
                this.sendMessage(this.gson.toJson(logs));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

