/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.JBBPExternalValueProvider;
import com.igormaznitsa.jbbp.JBBPNamedNumericFieldMap;
import com.igormaznitsa.jbbp.JBBPParserExpressionArraySizeController;
import com.igormaznitsa.jbbp.JBBPVarFieldProcessor;
import com.igormaznitsa.jbbp.ResultSrcItem;
import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPCompiler;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.conversion.JBBPToJavaConverter;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.exceptions.JBBPParsingException;
import com.igormaznitsa.jbbp.io.JBBPArraySizeLimiter;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayDouble;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayFloat;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayString;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldByte;
import com.igormaznitsa.jbbp.model.JBBPFieldDouble;
import com.igormaznitsa.jbbp.model.JBBPFieldFloat;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldString;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldUInt;
import com.igormaznitsa.jbbp.model.JBBPFieldUShort;
import com.igormaznitsa.jbbp.model.JBBPNumericField;
import com.igormaznitsa.jbbp.utils.JBBPIntCounter;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import com.igormaznitsa.jbbp.utils.TargetSources;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class JBBPParser {
    public static final int FLAG_SKIP_REMAINING_FIELDS_IF_EOF = 1;
    public static final int FLAG_NEGATIVE_EXPRESSION_RESULT_AS_ZERO = 2;
    public static final JBBPParserExpressionArraySizeController DEFAULT_EXPRESSION_ARRAY_SIZE_CONTROLLER = (parser, expressionEvaluator, fieldName, arraySize) -> arraySize;
    private static final JBBPFieldStruct[] EMPTY_STRUCT_ARRAY = new JBBPFieldStruct[0];
    private final JBBPCompiledBlock compiledBlock;
    private final JBBPBitOrder bitOrder;
    private final int flags;
    private final JBBPCustomFieldTypeProcessor customFieldTypeProcessor;
    private JBBPParserExpressionArraySizeController expressionArraySizeController = DEFAULT_EXPRESSION_ARRAY_SIZE_CONTROLLER;
    private long finalStreamByteCounter;

    private JBBPParser(String source, JBBPBitOrder bitOrder, JBBPCustomFieldTypeProcessor customFieldTypeProcessor, int flags) {
        JBBPUtils.assertNotNull(source, "Script is null");
        JBBPUtils.assertNotNull((Object)bitOrder, "Bit order is null");
        this.customFieldTypeProcessor = customFieldTypeProcessor;
        this.bitOrder = bitOrder;
        this.flags = flags;
        try {
            this.compiledBlock = JBBPCompiler.compile(source, customFieldTypeProcessor);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't compile script for unexpected IOException", ex);
        }
    }

    private static void assertArrayLength(int length, JBBPNamedFieldInfo name) {
        if (length < 0) {
            throw new JBBPParsingException("Detected negative calculated array length for field '" + (name == null ? "<NO NAME>" : name.getFieldPath()) + "' [" + JBBPUtils.int2msg(length) + "]");
        }
    }

    public static JBBPParser prepare(String script, JBBPBitOrder bitOrder) {
        return new JBBPParser(script, bitOrder, null, 0);
    }

    public static JBBPParser prepare(String script, JBBPBitOrder bitOrder, int flags) {
        return new JBBPParser(script, bitOrder, null, flags);
    }

    public static JBBPParser prepare(String script, JBBPBitOrder bitOrder, JBBPCustomFieldTypeProcessor customFieldTypeProcessor, int flags) {
        return new JBBPParser(script, bitOrder, customFieldTypeProcessor, flags);
    }

    public static JBBPParser prepare(String script) {
        return JBBPParser.prepare(script, JBBPBitOrder.LSB0);
    }

    public static JBBPParser prepare(String script, JBBPCustomFieldTypeProcessor customFieldTypeProcessor) {
        return JBBPParser.prepare(script, JBBPBitOrder.LSB0, customFieldTypeProcessor, 0);
    }

    public static JBBPParser prepare(String script, int flags) {
        return JBBPParser.prepare(script, JBBPBitOrder.LSB0, flags);
    }

    public JBBPParserExpressionArraySizeController getExpressionArraySizeController() {
        return this.expressionArraySizeController;
    }

    public JBBPParser setExpressionArraySizeController(JBBPParserExpressionArraySizeController arraySizeController) {
        if (arraySizeController == null) {
            throw new NullPointerException("Controller value must not be null");
        }
        this.expressionArraySizeController = arraySizeController;
        return this;
    }

    private List<JBBPAbstractField> parseStruct(JBBPBitInputStream inStream, JBBPIntCounter positionAtCompiledBlock, JBBPVarFieldProcessor varFieldProcessor, JBBPNamedNumericFieldMap namedNumericFieldMap, JBBPIntCounter positionAtNamedFieldList, JBBPIntCounter positionAtVarLengthProcessors, JBBPArraySizeLimiter arraySizeLimiter, boolean skipStructureFields) throws IOException {
        ArrayList<JBBPAbstractField> structureFields = skipStructureFields ? null : new ArrayList<JBBPAbstractField>();
        byte[] compiled = this.compiledBlock.getCompiledData();
        boolean endStructureNotMet = true;
        while (endStructureNotMet && positionAtCompiledBlock.get() < compiled.length && !inStream.isDetectedArrayLimit() && (inStream.hasAvailableData() || (this.flags & 1) == 0)) {
            boolean wholeStreamArray;
            int packedArraySizeOffset;
            int arrayLength;
            int extraFieldNumExprResult;
            boolean resultNotIgnored;
            int c = compiled[positionAtCompiledBlock.getAndIncrement()] & 0xFF;
            boolean wideCode = (c & 0x80) != 0;
            int ec = wideCode ? compiled[positionAtCompiledBlock.getAndIncrement()] & 0xFF : 0;
            boolean extraFieldNumAsExpr = (ec & 2) != 0;
            int code = ec << 8 | c;
            boolean fieldTypeDiff = (ec & 4) != 0;
            JBBPNamedFieldInfo name = (code & 0x10) == 0 ? null : this.compiledBlock.getNamedFields()[positionAtNamedFieldList.getAndIncrement()];
            JBBPByteOrder byteOrder = (code & 0x40) == 0 ? JBBPByteOrder.BIG_ENDIAN : JBBPByteOrder.LITTLE_ENDIAN;
            boolean bl = resultNotIgnored = !skipStructureFields;
            if (extraFieldNumAsExpr) {
                int resultOfExpression;
                JBBPIntegerValueEvaluator evaluator = this.compiledBlock.getArraySizeEvaluators()[positionAtVarLengthProcessors.getAndIncrement()];
                if (resultNotIgnored) {
                    resultOfExpression = evaluator.eval(inStream, positionAtCompiledBlock.get(), this.compiledBlock, namedNumericFieldMap);
                    if ((this.flags & 2) != 0) {
                        resultOfExpression = Math.max(resultOfExpression, 0);
                    }
                } else {
                    resultOfExpression = 0;
                }
                extraFieldNumExprResult = resultOfExpression;
            } else {
                extraFieldNumExprResult = 0;
            }
            switch (code & 0x120) {
                case 32: {
                    int pos = positionAtCompiledBlock.get();
                    arrayLength = JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                    packedArraySizeOffset = positionAtCompiledBlock.get() - pos;
                    wholeStreamArray = false;
                    break;
                }
                case 256: {
                    wholeStreamArray = resultNotIgnored;
                    packedArraySizeOffset = 0;
                    arrayLength = 0;
                    break;
                }
                case 288: {
                    int resultOfExpression;
                    JBBPIntegerValueEvaluator evaluator = this.compiledBlock.getArraySizeEvaluators()[positionAtVarLengthProcessors.getAndIncrement()];
                    if (resultNotIgnored) {
                        resultOfExpression = evaluator.eval(inStream, positionAtCompiledBlock.get(), this.compiledBlock, namedNumericFieldMap);
                        if ((this.flags & 2) != 0) {
                            resultOfExpression = Math.max(resultOfExpression, 0);
                        }
                        resultOfExpression = this.expressionArraySizeController.onCalculatedArraySize(this, evaluator, name, resultOfExpression);
                    } else {
                        resultOfExpression = 0;
                    }
                    arrayLength = resultOfExpression;
                    packedArraySizeOffset = 0;
                    JBBPParser.assertArrayLength(arrayLength, name);
                    wholeStreamArray = false;
                    break;
                }
                default: {
                    packedArraySizeOffset = 0;
                    wholeStreamArray = false;
                    arrayLength = -1;
                }
            }
            JBBPAbstractField singleAtomicField = null;
            try {
                switch (code & 0xF) {
                    case 14: {
                        if (resultNotIgnored) {
                            inStream.resetCounter();
                        }
                        break;
                    }
                    case 1: {
                        int alignValue;
                        int n = alignValue = extraFieldNumAsExpr ? extraFieldNumExprResult : JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                        if (resultNotIgnored) {
                            inStream.align(alignValue);
                        }
                        break;
                    }
                    case 12: {
                        int skipByteNumber;
                        int n = skipByteNumber = extraFieldNumAsExpr ? extraFieldNumExprResult : JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                        if (resultNotIgnored) {
                            long skippedBytes;
                            if (fieldTypeDiff) {
                                singleAtomicField = new JBBPFieldInt(name, skipByteNumber);
                                break;
                            }
                            if (skipByteNumber > 0 && (skippedBytes = inStream.skip(skipByteNumber)) != (long)skipByteNumber) {
                                throw new EOFException("Can't skip " + skipByteNumber + " byte(s), skipped only " + skippedBytes + " byte(s)");
                            }
                        }
                        break;
                    }
                    case 2: {
                        int numberOfBits;
                        int n = numberOfBits = extraFieldNumAsExpr ? extraFieldNumExprResult : JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                        if (resultNotIgnored) {
                            JBBPBitNumber bitNumber = JBBPBitNumber.decode(numberOfBits);
                            if (arrayLength < 0) {
                                byte read = inStream.readBitField(bitNumber);
                                singleAtomicField = new JBBPFieldBit(name, read & 0xFF, bitNumber);
                                break;
                            }
                            structureFields.add(new JBBPFieldArrayBit(name, inStream.readBitsArray(wholeStreamArray ? -1 : arrayLength, bitNumber, arraySizeLimiter), bitNumber));
                        }
                        break;
                    }
                    case 13: {
                        int extraField;
                        int n = extraField = extraFieldNumAsExpr ? extraFieldNumExprResult : JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                        if (!resultNotIgnored) break;
                        if (arrayLength < 0) {
                            singleAtomicField = varFieldProcessor.readVarField(inStream, name, extraField, byteOrder, namedNumericFieldMap);
                            JBBPUtils.assertNotNull(singleAtomicField, "A Var processor must not return null as a result of a field reading");
                            if (singleAtomicField instanceof JBBPAbstractArrayField) {
                                throw new JBBPParsingException("A Var field processor has returned an array value instead of a field value [" + String.valueOf(name) + ":" + extraField + "]");
                            }
                            if (singleAtomicField.getNameInfo() != name) {
                                throw new JBBPParsingException("Detected wrong name for a read field , must be " + String.valueOf(name) + " but detected " + String.valueOf(singleAtomicField.getNameInfo()) + "]");
                            }
                            break;
                        }
                        JBBPAbstractArrayField<? extends JBBPAbstractField> array = varFieldProcessor.readVarArray(inStream, wholeStreamArray ? -1 : arrayLength, name, extraField, byteOrder, namedNumericFieldMap, arraySizeLimiter);
                        JBBPUtils.assertNotNull(array, "A Var processor must not return null as a result of an array field reading [" + String.valueOf(name) + ":" + extraField + "]");
                        if (array.getNameInfo() != name) {
                            throw new JBBPParsingException("Detected wrong name for a read field array, must be " + String.valueOf(name) + " but detected " + String.valueOf(array.getNameInfo()) + "]");
                        }
                        structureFields.add(array);
                        break;
                    }
                    case 15: {
                        int extraData;
                        int n = extraData = extraFieldNumAsExpr ? extraFieldNumExprResult : JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                        if (resultNotIgnored) {
                            JBBPFieldTypeParameterContainer fieldTypeInfo = this.compiledBlock.getCustomTypeFields()[JBBPUtils.unpackInt(compiled, positionAtCompiledBlock)];
                            JBBPAbstractField field = this.customFieldTypeProcessor.readCustomFieldType(inStream, this.bitOrder, this.flags, fieldTypeInfo, name, extraData, wholeStreamArray, arrayLength, arraySizeLimiter);
                            JBBPUtils.assertNotNull(field, "Must not return null as read result");
                            if (arrayLength < 0) {
                                singleAtomicField = field;
                                break;
                            }
                            structureFields.add(field);
                        }
                        break;
                    }
                    case 5: {
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                singleAtomicField = fieldTypeDiff ? new JBBPFieldUInt(name, (long)inStream.readInt(byteOrder) & 0xFFFFFFFFL) : new JBBPFieldByte(name, (byte)inStream.readByte());
                                break;
                            }
                            structureFields.add(fieldTypeDiff ? new JBBPFieldArrayUInt(name, inStream.readIntArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)) : new JBBPFieldArrayByte(name, inStream.readByteArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 4: {
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                singleAtomicField = new JBBPFieldUByte(name, (byte)inStream.readByte());
                                break;
                            }
                            structureFields.add(new JBBPFieldArrayUByte(name, inStream.readByteArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 3: {
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                singleAtomicField = fieldTypeDiff ? new JBBPFieldString(name, inStream.readString(byteOrder)) : new JBBPFieldBoolean(name, inStream.readBoolean());
                                break;
                            }
                            structureFields.add(fieldTypeDiff ? new JBBPFieldArrayString(name, inStream.readStringArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)) : new JBBPFieldArrayBoolean(name, inStream.readBoolArray(wholeStreamArray ? -1 : arrayLength, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 8: {
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                singleAtomicField = fieldTypeDiff ? new JBBPFieldFloat(name, inStream.readFloat(byteOrder)) : new JBBPFieldInt(name, inStream.readInt(byteOrder));
                                break;
                            }
                            structureFields.add(fieldTypeDiff ? new JBBPFieldArrayFloat(name, inStream.readFloatArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)) : new JBBPFieldArrayInt(name, inStream.readIntArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 9: {
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                singleAtomicField = fieldTypeDiff ? new JBBPFieldDouble(name, inStream.readDouble(byteOrder)) : new JBBPFieldLong(name, inStream.readLong(byteOrder));
                                break;
                            }
                            structureFields.add(fieldTypeDiff ? new JBBPFieldArrayDouble(name, inStream.readDoubleArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)) : new JBBPFieldArrayLong(name, inStream.readLongArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 7: {
                        int value;
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                value = inStream.readUnsignedShort(byteOrder);
                                singleAtomicField = new JBBPFieldShort(name, (short)value);
                                break;
                            }
                            structureFields.add(new JBBPFieldArrayShort(name, inStream.readShortArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 6: {
                        int value;
                        if (resultNotIgnored) {
                            if (arrayLength < 0) {
                                value = inStream.readUnsignedShort(byteOrder);
                                singleAtomicField = new JBBPFieldUShort(name, (short)value);
                                break;
                            }
                            structureFields.add(new JBBPFieldArrayUShort(name, inStream.readShortArray(wholeStreamArray ? -1 : arrayLength, byteOrder, arraySizeLimiter)));
                        }
                        break;
                    }
                    case 10: {
                        if (arrayLength < 0) {
                            List<JBBPAbstractField> structFields = this.parseStruct(inStream, positionAtCompiledBlock, varFieldProcessor, namedNumericFieldMap, positionAtNamedFieldList, positionAtVarLengthProcessors, arraySizeLimiter, skipStructureFields);
                            JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                            if (resultNotIgnored) {
                                structureFields.add(new JBBPFieldStruct(name, structFields.toArray(JBBPUtils.ARRAY_FIELD_EMPTY)));
                            }
                            break;
                        }
                        int nameFieldCurrent = positionAtNamedFieldList.get();
                        int varLenProcCurrent = positionAtVarLengthProcessors.get();
                        if (resultNotIgnored) {
                            JBBPFieldStruct[] result;
                            List<JBBPAbstractField> fieldsForStruct;
                            if (wholeStreamArray) {
                                ArrayList<JBBPFieldStruct> list = new ArrayList<JBBPFieldStruct>();
                                while (inStream.hasAvailableData()) {
                                    positionAtNamedFieldList.set(nameFieldCurrent);
                                    positionAtVarLengthProcessors.set(varLenProcCurrent);
                                    fieldsForStruct = this.parseStruct(inStream, positionAtCompiledBlock, varFieldProcessor, namedNumericFieldMap, positionAtNamedFieldList, positionAtVarLengthProcessors, arraySizeLimiter, skipStructureFields);
                                    list.add(new JBBPFieldStruct(name, fieldsForStruct));
                                    if (JBBPArraySizeLimiter.isBreakReadWholeStream(list.size(), arraySizeLimiter)) {
                                        inStream.setDetectedArrayLimit(true);
                                        break;
                                    }
                                    int structStart = JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                                    if (!inStream.hasAvailableData()) continue;
                                    positionAtCompiledBlock.set(structStart + (wideCode ? 2 : 1));
                                }
                                result = list.isEmpty() ? EMPTY_STRUCT_ARRAY : list.toArray(EMPTY_STRUCT_ARRAY);
                            } else if (arrayLength == 0) {
                                result = EMPTY_STRUCT_ARRAY;
                                this.parseStruct(inStream, positionAtCompiledBlock, varFieldProcessor, namedNumericFieldMap, positionAtNamedFieldList, positionAtVarLengthProcessors, arraySizeLimiter, true);
                                JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                            } else {
                                result = new JBBPFieldStruct[arrayLength];
                                for (int i = 0; i < arrayLength; ++i) {
                                    fieldsForStruct = this.parseStruct(inStream, positionAtCompiledBlock, varFieldProcessor, namedNumericFieldMap, positionAtNamedFieldList, positionAtVarLengthProcessors, arraySizeLimiter, skipStructureFields);
                                    int structBodyStart = JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                                    result[i] = new JBBPFieldStruct(name, fieldsForStruct);
                                    if (i >= arrayLength - 1) continue;
                                    positionAtNamedFieldList.set(nameFieldCurrent);
                                    positionAtVarLengthProcessors.set(varLenProcCurrent);
                                    positionAtCompiledBlock.set(structBodyStart + packedArraySizeOffset + (wideCode ? 2 : 1));
                                }
                            }
                            if (result != null) {
                                structureFields.add(new JBBPFieldArrayStruct(name, result));
                            }
                            break;
                        }
                        this.parseStruct(inStream, positionAtCompiledBlock, varFieldProcessor, namedNumericFieldMap, positionAtNamedFieldList, positionAtVarLengthProcessors, arraySizeLimiter, skipStructureFields);
                        JBBPUtils.unpackInt(compiled, positionAtCompiledBlock);
                        break;
                    }
                    case 11: {
                        endStructureNotMet = false;
                        break;
                    }
                    default: {
                        throw new Error("Detected unexpected field type! Contact developer! [" + code + "]");
                    }
                }
            }
            catch (IOException ex) {
                if (name == null) {
                    throw ex;
                }
                throw new JBBPParsingException("Can't parse field '" + name.getFieldPath() + "' for IOException", ex);
            }
            if (singleAtomicField == null) continue;
            structureFields.add(singleAtomicField);
            if (namedNumericFieldMap == null || !(singleAtomicField instanceof JBBPNumericField) || name == null) continue;
            namedNumericFieldMap.putField((JBBPNumericField)((Object)singleAtomicField));
        }
        return structureFields;
    }

    public JBBPFieldStruct parse(InputStream in) throws IOException {
        return this.parse(in, null, null);
    }

    public JBBPFieldStruct parse(InputStream in, JBBPVarFieldProcessor varFieldProcessor, JBBPExternalValueProvider externalValueProvider) throws IOException {
        return this.parse(in, varFieldProcessor, externalValueProvider, JBBPArraySizeLimiter.NO_LIMIT_FOR_ARRAY_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBBPFieldStruct parse(InputStream in, JBBPVarFieldProcessor varFieldProcessor, JBBPExternalValueProvider externalValueProvider, JBBPArraySizeLimiter arraySizeLimiter) throws IOException {
        JBBPBitInputStream bitInStream = in instanceof JBBPBitInputStream ? (JBBPBitInputStream)in : new JBBPBitInputStream(in, this.bitOrder);
        this.finalStreamByteCounter = bitInStream.getCounter();
        JBBPNamedNumericFieldMap fieldMap = this.compiledBlock.hasEvaluatedSizeArrays() || this.compiledBlock.hasVarFields() ? new JBBPNamedNumericFieldMap(externalValueProvider) : null;
        if (this.compiledBlock.hasVarFields()) {
            JBBPUtils.assertNotNull(varFieldProcessor, "The Script contains VAR fields, a var field processor must be provided");
        }
        try {
            JBBPFieldStruct jBBPFieldStruct = new JBBPFieldStruct(new JBBPNamedFieldInfo("", "", -1), this.parseStruct(bitInStream, new JBBPIntCounter(), varFieldProcessor, fieldMap, new JBBPIntCounter(), new JBBPIntCounter(), arraySizeLimiter, false));
            return jBBPFieldStruct;
        }
        finally {
            this.finalStreamByteCounter = bitInStream.getCounter();
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public JBBPFieldStruct parse(byte[] array) throws IOException {
        JBBPUtils.assertNotNull(array, "Array must not be null");
        return this.parse(new ByteArrayInputStream(array), null, null);
    }

    public JBBPFieldStruct parse(byte[] array, JBBPVarFieldProcessor varFieldProcessor, JBBPExternalValueProvider externalValueProvider) throws IOException {
        JBBPUtils.assertNotNull(array, "Array must not be null");
        return this.parse(new ByteArrayInputStream(array), varFieldProcessor, externalValueProvider);
    }

    public long getFinalStreamByteCounter() {
        return this.finalStreamByteCounter;
    }

    public JBBPCompiledBlock getCompiledBlock() {
        return this.compiledBlock;
    }

    public List<ResultSrcItem> convertToSrc(TargetSources target, String name) {
        JBBPUtils.assertNotNull(name, "Name must not be null");
        if (target == TargetSources.JAVA) {
            String className;
            String packageName;
            final Properties metadata = new Properties();
            metadata.setProperty("script", this.compiledBlock.getSource());
            metadata.setProperty("name", name);
            metadata.setProperty("target", target.name());
            metadata.setProperty("converter", JBBPToJavaConverter.class.getCanonicalName());
            int nameStart = name.lastIndexOf(46);
            if (nameStart < 0) {
                packageName = "";
                className = name;
            } else {
                packageName = name.substring(0, nameStart);
                className = name.substring(nameStart + 1);
            }
            String resultSources = JBBPToJavaConverter.makeBuilder(this).setMainClassPackage(packageName).setMainClassName(className).build().convert();
            final Map<CallSite, String> resultMap = Collections.singletonMap(name.replace('.', '/') + ".java", resultSources);
            return Collections.singletonList(new ResultSrcItem(){
                final /* synthetic */ JBBPParser this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Properties getMetadata() {
                    return metadata;
                }

                @Override
                public Map<String, String> getResult() {
                    return resultMap;
                }
            });
        }
        throw new IllegalArgumentException("Unsupported target : " + String.valueOf((Object)target));
    }
}

