/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.tokenizer;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPToken;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPTokenType;
import com.igormaznitsa.jbbp.exceptions.JBBPTokenizerException;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JBBPTokenizer
implements Iterable<JBBPToken>,
Iterator<JBBPToken> {
    private static final Pattern PATTERN = Pattern.compile("\\s*//.*$|\\s*(\\})|\\s*([^\\s;\\[\\]\\}\\{]+)?\\s*(?:\\[\\s*([^\\[\\]\\{\\};]+)\\s*\\])?\\s*([^\\d\\s;\\[\\]\\}\\{/][^\\s;\\[\\]\\}\\{/]*)?\\s*([\\{;])", 8);
    private static final Pattern FIELD_TYPE_BREAK_PATTERN = Pattern.compile("^([<>])?([\\w][\\w$]*)(?::((?:[-]?\\d+)|(?:\\(.+\\))))?$");
    private static final Set<String> GLOBAL_RESERVED_TYPE_NAMES = new HashSet<String>();
    private final Matcher matcher;
    private final String processingString;
    private final Set<String> reservedTypeNames;
    private JBBPToken nextItem;
    private JBBPTokenizerException detectedException;
    private int lastCharSubstringFound = -1;

    public JBBPTokenizer(String str) {
        this(str, null);
    }

    public JBBPTokenizer(String str, JBBPCustomFieldTypeProcessor customFieldTypeProcessor) {
        JBBPUtils.assertNotNull(str, "String must not be null");
        if (customFieldTypeProcessor == null) {
            this.reservedTypeNames = GLOBAL_RESERVED_TYPE_NAMES;
        } else {
            this.reservedTypeNames = new HashSet<String>(GLOBAL_RESERVED_TYPE_NAMES);
            for (String customType : customFieldTypeProcessor.getCustomFieldTypes()) {
                JBBPUtils.assertNotNull(customType, "Type must not be null");
                this.reservedTypeNames.add(customType);
            }
        }
        this.processingString = str;
        this.matcher = PATTERN.matcher(this.processingString);
        this.readNextItem();
    }

    public static boolean isGlobalReservedName(String name) {
        return GLOBAL_RESERVED_TYPE_NAMES.contains(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JBBPByteOrder getJbbpByteOrder(String groupTypeByteOrder, String fieldType) {
        if (groupTypeByteOrder == null) return JBBPByteOrder.BIG_ENDIAN;
        if (">".equals(groupTypeByteOrder)) {
            return JBBPByteOrder.BIG_ENDIAN;
        }
        if (!"<".equals(groupTypeByteOrder)) throw new Error("Illegal byte order char, unexpected error, contact developer please [" + fieldType + "]");
        return JBBPByteOrder.LITTLE_ENDIAN;
    }

    private void readNextItem() {
        if (this.matcher.find()) {
            String groupWholeFound = this.matcher.group(0);
            String groupWholeFoundTrimmed = groupWholeFound.trim();
            String groupCloseStruct = this.matcher.group(1);
            String groupTypeOrName = this.matcher.group(2);
            String groupArrayLength = this.matcher.group(3);
            String groupName = this.matcher.group(4);
            String groupEnder = this.matcher.group(5);
            String skipString = this.processingString.substring(Math.max(this.lastCharSubstringFound, 0), this.matcher.start()).trim();
            if (!skipString.isEmpty() && !skipString.startsWith("//")) {
                this.detectedException = new JBBPTokenizerException(skipString, this.processingString, Math.max(this.lastCharSubstringFound, 0));
            } else {
                String fieldName;
                JBBPTokenType type = JBBPTokenType.ATOM;
                if (groupWholeFoundTrimmed.startsWith("//")) {
                    type = JBBPTokenType.COMMENT;
                } else if ("{".equals(groupEnder)) {
                    type = JBBPTokenType.STRUCT_START;
                    if (groupName != null) {
                        int position = this.matcher.start() + groupWholeFound.length() - groupWholeFoundTrimmed.length();
                        this.detectedException = new JBBPTokenizerException("Wrong structure format, it must have only name (and may be array definition)", this.processingString, position);
                        return;
                    }
                } else if (groupCloseStruct != null) {
                    type = JBBPTokenType.STRUCT_END;
                } else if (groupTypeOrName == null) {
                    int position = this.matcher.start() + groupWholeFound.length() - groupWholeFoundTrimmed.length();
                    this.detectedException = new JBBPTokenizerException("Detected atomic field definition without type", this.processingString, position);
                    return;
                }
                String fieldType = groupTypeOrName;
                int position = this.matcher.start();
                if (type == JBBPTokenType.COMMENT) {
                    fieldName = this.matcher.group(0).trim().substring(2).trim();
                    position += groupWholeFound.indexOf(47);
                } else {
                    if (type == JBBPTokenType.STRUCT_START) {
                        fieldName = fieldType;
                        fieldType = null;
                    } else {
                        fieldName = groupName;
                    }
                    this.detectedException = this.checkFieldName(fieldName, position += groupWholeFound.length() - groupWholeFound.trim().length());
                    if (this.detectedException != null) {
                        return;
                    }
                }
                JBBPFieldTypeParameterContainer parsedType = null;
                if (fieldType != null) {
                    Matcher typeMatcher = FIELD_TYPE_BREAK_PATTERN.matcher(fieldType);
                    boolean wrongFormat = true;
                    if (typeMatcher.find()) {
                        String groupTypeByteOrder = typeMatcher.group(1);
                        String groupTypeName = typeMatcher.group(2);
                        String groupTypeExtraField = typeMatcher.group(3);
                        wrongFormat = false;
                        JBBPByteOrder byteOrder = JBBPTokenizer.getJbbpByteOrder(groupTypeByteOrder, fieldType);
                        parsedType = new JBBPFieldTypeParameterContainer(byteOrder, groupTypeName, groupTypeExtraField);
                    }
                    if (wrongFormat) {
                        this.detectedException = new JBBPTokenizerException("Wrong format of type definition [" + fieldType + "]", this.processingString, position);
                        return;
                    }
                }
                this.nextItem = new JBBPToken(type, position, parsedType, groupArrayLength, fieldName);
                this.lastCharSubstringFound = this.matcher.end();
            }
        } else {
            if (this.lastCharSubstringFound < 0) {
                this.detectedException = new JBBPTokenizerException("Wrong format of whole string", this.processingString, 0);
            } else {
                String restOfString = this.processingString.substring(this.lastCharSubstringFound);
                if (!restOfString.trim().isEmpty()) {
                    throw new JBBPTokenizerException("Can't recognize a part of script [" + restOfString + "]", this.processingString, this.lastCharSubstringFound);
                }
            }
            this.nextItem = null;
        }
    }

    private JBBPTokenizerException checkFieldName(String name, int position) {
        if (name != null) {
            String normalized = JBBPUtils.normalizeFieldNameOrPath(name);
            if (normalized.indexOf(46) >= 0) {
                return new JBBPTokenizerException("Field name must not contain '.' char", this.processingString, position);
            }
            if (!normalized.isEmpty()) {
                if (normalized.equals("_") || normalized.equals("$$") || normalized.startsWith("$") || Character.isDigit(normalized.charAt(0))) {
                    return new JBBPTokenizerException("'" + name + "' can't be field name", this.processingString, position);
                }
                for (int i = 1; i < normalized.length(); ++i) {
                    char chr = normalized.charAt(i);
                    if (chr == '_' || Character.isLetterOrDigit(chr)) continue;
                    return new JBBPTokenizerException("Char '" + chr + "' not allowed in name", this.processingString, position);
                }
            }
        }
        return null;
    }

    @Override
    public Iterator<JBBPToken> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.detectedException != null || this.nextItem != null;
    }

    @Override
    public JBBPToken next() {
        if (this.detectedException != null) {
            JBBPTokenizerException ex = this.detectedException;
            this.detectedException = null;
            throw ex;
        }
        JBBPToken current = this.nextItem;
        if (current == null) {
            throw new NoSuchElementException("Parsing has been completed");
        }
        this.readNextItem();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    static {
        GLOBAL_RESERVED_TYPE_NAMES.add("floatj");
        GLOBAL_RESERVED_TYPE_NAMES.add("doublej");
        GLOBAL_RESERVED_TYPE_NAMES.add("stringj");
        GLOBAL_RESERVED_TYPE_NAMES.add("uint");
        GLOBAL_RESERVED_TYPE_NAMES.add("bit");
        GLOBAL_RESERVED_TYPE_NAMES.add("bool");
        GLOBAL_RESERVED_TYPE_NAMES.add("byte");
        GLOBAL_RESERVED_TYPE_NAMES.add("ubyte");
        GLOBAL_RESERVED_TYPE_NAMES.add("short");
        GLOBAL_RESERVED_TYPE_NAMES.add("ushort");
        GLOBAL_RESERVED_TYPE_NAMES.add("int");
        GLOBAL_RESERVED_TYPE_NAMES.add("long");
        GLOBAL_RESERVED_TYPE_NAMES.add("align");
        GLOBAL_RESERVED_TYPE_NAMES.add("skip");
        GLOBAL_RESERVED_TYPE_NAMES.add("var");
        GLOBAL_RESERVED_TYPE_NAMES.add("val");
        GLOBAL_RESERVED_TYPE_NAMES.add("$");
    }
}

