//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = 3); // DEBUG:event,nt,-,-,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,nt,-,p,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,nt,-,f,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = false); // DEBUG:event,nt,-,-,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,nt,-,p,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,nt,-,f,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?3); // DEBUG:event,nt,-,-,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,nt,-,p,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,nt,-,f,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %3); // DEBUG:event,nt,-,-,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,nt,-,p,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,nt,-,f,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?deb); // DEBUG:event,nt,-,-,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,nt,-,p,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,nt,-,f,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %disp); // DEBUG:event,nt,-,-,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,nt,-,p,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,nt,-,f,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,nt,-,-,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,nt,-,p,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %sub.field); // DEBUG:event,nt,-,-,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,nt,-,p,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,nt,-,-,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,nt,-,p,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,nt,-,f,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,nt,-,pf,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,nt,-,-,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,nt,-,p,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,nt,-,-,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,nt,-,p,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,nt,-,f,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,nt,-,pf,-,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,nt,-,-,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,nt,-,p,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,nt,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,nt,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,nt,-,-,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,nt,-,p,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = false); // DEBUG:event,nt,-,-,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,nt,-,p,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,nt,-,-,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,nt,-,p,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,nt,-,-,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,nt,-,p,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,nt,-,-,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,nt,-,p,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,nt,-,-,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,nt,-,p,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,nt,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,nt,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,nt,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,nt,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,nt,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,nt,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,nt,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,nt,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,nt,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,nt,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = 3); // DEBUG:event,nt,-,-,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,nt,-,p,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = false); // DEBUG:event,nt,-,-,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,nt,-,p,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?3); // DEBUG:event,nt,-,-,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,nt,-,p,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %3); // DEBUG:event,nt,-,-,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,nt,-,p,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,nt,-,-,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,nt,-,p,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %disp); // DEBUG:event,nt,-,-,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,nt,-,p,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,nt,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,nt,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,nt,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,nt,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,nt,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,nt,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,nt,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,nt,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,nt,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,nt,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,nt,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,nt,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = 3); // DEBUG:event,nt,-,-,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,nt,-,p,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = false); // DEBUG:event,nt,-,-,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,nt,-,p,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","false"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?3); // DEBUG:event,nt,-,-,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,nt,-,p,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","?3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %3); // DEBUG:event,nt,-,-,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,nt,-,p,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","%3"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?deb); // DEBUG:event,nt,-,-,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,nt,-,p,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %disp); // DEBUG:event,nt,-,-,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,nt,-,p,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,nt,-,-,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,nt,-,p,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,nt,-,-,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,nt,-,p,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,nt,-,-,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,nt,-,p,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,nt,-,f,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,nt,-,-,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,nt,-,p,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,nt,-,f,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,nt,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,nt,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,nt,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,nt,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,nt,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, var); // DEBUG:event,nt,-,-,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, var); // DEBUG:event,nt,-,p,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, var, qux = 3); // DEBUG:event,nt,-,f,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,nt,-,pf,-,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, var, "msg without args"); // DEBUG:event,nt,-,-,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,nt,-,p,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,nt,{},-,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,nt,{},p,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,-,"var"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, sub.field); // DEBUG:event,nt,-,-,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,nt,-,p,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,nt,-,f,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,-,"sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %disp); // DEBUG:event,nt,-,-,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %disp); // DEBUG:event,nt,-,p,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,nt,-,f,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,nt,-,pf,-,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,nt,-,-,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,nt,-,p,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,nt,{},-,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,nt,{},p,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,-,"%disp"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?deb); // DEBUG:event,nt,-,-,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,nt,-,p,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,nt,-,f,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,nt,-,pf,-,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,nt,-,-,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,nt,-,p,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,nt,{},-,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,nt,{},p,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,-,"?deb"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %sub.field); // DEBUG:event,nt,-,-,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,nt,-,p,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,nt,-,f,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,-,"%sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?sub.field); // DEBUG:event,nt,-,-,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,nt,-,p,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,nt,-,f,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,nt,-,pf,-,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,nt,-,-,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,nt,-,p,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,f,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,nt,-,pf,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,nt,{},-,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,nt,{},p,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},f,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,nt,{},pf,m,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,-,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,p,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,f,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,nt,-,pf,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},-,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},p,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},f,ma,-,"?sub.field"
    tracing::event!(name: "mog", target: "my::module", tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,nt,{},pf,ma,-,"?sub.field"
}
