/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.model.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import org.jkiss.dbeaver.data.gis.handlers.GISGeometryValueHandler;
import org.jkiss.dbeaver.ext.duckdb.model.data.DuckDBGeometryConverter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class DuckDBGeometryValueHandler
extends GISGeometryValueHandler {
    public static final DuckDBGeometryValueHandler INSTANCE = new DuckDBGeometryValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        try {
            return this.getValueFromObject(session, type, resultSet.getBytes(index), false, false);
        }
        catch (Exception exception) {
            return this.getValueFromObject(session, type, resultSet.getString(index), false, false);
        }
    }

    protected Geometry convertGeometryFromBinaryFormat(DBCSession session, byte[] object) throws DBCException {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(object).order(ByteOrder.LITTLE_ENDIAN);
            GeometryFactory factory = new GeometryFactory(new PrecisionModel());
            return DuckDBGeometryConverter.deserialize(buffer, factory);
        }
        catch (Exception exception) {
            return super.convertGeometryFromBinaryFormat(session, object);
        }
    }
}

