/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.util.StringHelper;

public abstract class SimpleExpression
extends Expression {
    private final String propertyName;
    private final Object value;

    SimpleExpression(String propertyName, Object value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        return StringHelper.join(" and ", StringHelper.suffix(Expression.getColumns(sessionFactory, persistentClass, this.propertyName, alias), this.getOp() + "?"));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        return new TypedValue[]{Expression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.value)};
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.value;
    }

    abstract String getOp();
}

