package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamOptimizedFeatureConfig invokes the live.DescribeLiveStreamOptimizedFeatureConfig API synchronously
func (client *Client) DescribeLiveStreamOptimizedFeatureConfig(request *DescribeLiveStreamOptimizedFeatureConfigRequest) (response *DescribeLiveStreamOptimizedFeatureConfigResponse, err error) {
	response = CreateDescribeLiveStreamOptimizedFeatureConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamOptimizedFeatureConfigWithChan invokes the live.DescribeLiveStreamOptimizedFeatureConfig API asynchronously
func (client *Client) DescribeLiveStreamOptimizedFeatureConfigWithChan(request *DescribeLiveStreamOptimizedFeatureConfigRequest) (<-chan *DescribeLiveStreamOptimizedFeatureConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamOptimizedFeatureConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamOptimizedFeatureConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamOptimizedFeatureConfigWithCallback invokes the live.DescribeLiveStreamOptimizedFeatureConfig API asynchronously
func (client *Client) DescribeLiveStreamOptimizedFeatureConfigWithCallback(request *DescribeLiveStreamOptimizedFeatureConfigRequest, callback func(response *DescribeLiveStreamOptimizedFeatureConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamOptimizedFeatureConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamOptimizedFeatureConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamOptimizedFeatureConfigRequest is the request struct for api DescribeLiveStreamOptimizedFeatureConfig
type DescribeLiveStreamOptimizedFeatureConfigRequest struct {
	*requests.RpcRequest
	ConfigName string           `position:"Query" name:"ConfigName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamOptimizedFeatureConfigResponse is the response struct for api DescribeLiveStreamOptimizedFeatureConfig
type DescribeLiveStreamOptimizedFeatureConfigResponse struct {
	*responses.BaseResponse
	RequestId                            string                               `json:"RequestId" xml:"RequestId"`
	LiveStreamOptimizedFeatureConfigList LiveStreamOptimizedFeatureConfigList `json:"LiveStreamOptimizedFeatureConfigList" xml:"LiveStreamOptimizedFeatureConfigList"`
}

// CreateDescribeLiveStreamOptimizedFeatureConfigRequest creates a request to invoke DescribeLiveStreamOptimizedFeatureConfig API
func CreateDescribeLiveStreamOptimizedFeatureConfigRequest() (request *DescribeLiveStreamOptimizedFeatureConfigRequest) {
	request = &DescribeLiveStreamOptimizedFeatureConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamOptimizedFeatureConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamOptimizedFeatureConfigResponse creates a response to parse from DescribeLiveStreamOptimizedFeatureConfig response
func CreateDescribeLiveStreamOptimizedFeatureConfigResponse() (response *DescribeLiveStreamOptimizedFeatureConfigResponse) {
	response = &DescribeLiveStreamOptimizedFeatureConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
