package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePersistentVolume invokes the retailcloud.CreatePersistentVolume API synchronously
func (client *Client) CreatePersistentVolume(request *CreatePersistentVolumeRequest) (response *CreatePersistentVolumeResponse, err error) {
	response = CreateCreatePersistentVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePersistentVolumeWithChan invokes the retailcloud.CreatePersistentVolume API asynchronously
func (client *Client) CreatePersistentVolumeWithChan(request *CreatePersistentVolumeRequest) (<-chan *CreatePersistentVolumeResponse, <-chan error) {
	responseChan := make(chan *CreatePersistentVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePersistentVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePersistentVolumeWithCallback invokes the retailcloud.CreatePersistentVolume API asynchronously
func (client *Client) CreatePersistentVolumeWithCallback(request *CreatePersistentVolumeRequest, callback func(response *CreatePersistentVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePersistentVolumeResponse
		var err error
		defer close(result)
		response, err = client.CreatePersistentVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePersistentVolumeRequest is the request struct for api CreatePersistentVolume
type CreatePersistentVolumeRequest struct {
	*requests.RpcRequest
	ReclaimPolicy     string `position:"Body" name:"ReclaimPolicy"`
	NFSVersion        string `position:"Body" name:"NFSVersion"`
	AccessModes       string `position:"Body" name:"AccessModes"`
	Name              string `position:"Body" name:"Name"`
	MountTargetDomain string `position:"Body" name:"MountTargetDomain"`
	MountDir          string `position:"Body" name:"MountDir"`
	ClusterInstanceId string `position:"Body" name:"ClusterInstanceId"`
	Capacity          string `position:"Body" name:"Capacity"`
	StorageClass      string `position:"Body" name:"StorageClass"`
}

// CreatePersistentVolumeResponse is the response struct for api CreatePersistentVolume
type CreatePersistentVolumeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreatePersistentVolumeRequest creates a request to invoke CreatePersistentVolume API
func CreateCreatePersistentVolumeRequest() (request *CreatePersistentVolumeRequest) {
	request = &CreatePersistentVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "CreatePersistentVolume", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePersistentVolumeResponse creates a response to parse from CreatePersistentVolume response
func CreateCreatePersistentVolumeResponse() (response *CreatePersistentVolumeResponse) {
	response = &CreatePersistentVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
