/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.comments;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.javamodularity.moduleplugin.shadow.javaparser.Range;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.comments.BlockComment;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.comments.Comment;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.comments.JavadocComment;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.comments.LineComment;

public class CommentsCollection {
    private final TreeSet<Comment> comments = new TreeSet(Node.NODE_BY_BEGIN_POSITION);

    public CommentsCollection() {
    }

    public CommentsCollection(Collection<Comment> commentsToCopy) {
        this.comments.addAll(commentsToCopy);
    }

    public Set<LineComment> getLineComments() {
        return (Set)this.comments.stream().filter((Predicate<Comment> & Serializable)comment -> comment instanceof LineComment).map((Function<Comment, LineComment> & Serializable)comment -> (LineComment)comment).collect(Collectors.toCollection((Supplier<TreeSet> & Serializable)() -> new TreeSet(Node.NODE_BY_BEGIN_POSITION)));
    }

    public Set<BlockComment> getBlockComments() {
        return (Set)this.comments.stream().filter((Predicate<Comment> & Serializable)comment -> comment instanceof BlockComment).map((Function<Comment, BlockComment> & Serializable)comment -> (BlockComment)comment).collect(Collectors.toCollection((Supplier<TreeSet> & Serializable)() -> new TreeSet(Node.NODE_BY_BEGIN_POSITION)));
    }

    public Set<JavadocComment> getJavadocComments() {
        return (Set)this.comments.stream().filter((Predicate<Comment> & Serializable)comment -> comment instanceof JavadocComment).map((Function<Comment, JavadocComment> & Serializable)comment -> (JavadocComment)comment).collect(Collectors.toCollection((Supplier<TreeSet> & Serializable)() -> new TreeSet(Node.NODE_BY_BEGIN_POSITION)));
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public boolean contains(Comment comment) {
        if (!comment.hasRange()) {
            return false;
        }
        Range commentRange = comment.getRange().get();
        for (Comment c : this.getComments()) {
            if (!c.hasRange()) {
                return false;
            }
            Range cRange = c.getRange().get();
            if (!cRange.begin.equals(commentRange.begin) || cRange.end.line != commentRange.end.line || Math.abs(cRange.end.column - commentRange.end.column) >= 2) continue;
            return true;
        }
        return false;
    }

    public TreeSet<Comment> getComments() {
        return this.comments;
    }

    public int size() {
        return this.comments.size();
    }

    public CommentsCollection minus(CommentsCollection other) {
        CommentsCollection result = new CommentsCollection();
        result.comments.addAll(this.comments.stream().filter((Predicate<Comment> & Serializable)comment -> !other.contains((Comment)comment)).collect(Collectors.toList()));
        return result;
    }

    public CommentsCollection copy() {
        return new CommentsCollection(this.comments);
    }
}

